/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.BaseProducerSendTest;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001i2AAC\u0006\u0001!!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C\u00013!)A\u0006\u0001C\u00013!)a\u0006\u0001C\u00013!)\u0001\u0007\u0001C\u00013!)!\u0007\u0001C\u00013!)A\u0007\u0001C\u00013!)a\u0007\u0001C\u00013!)\u0001\b\u0001C\u00013\tI\u0002\u000b\\1j]R,\u0007\u0010\u001e)s_\u0012,8-\u001a:TK:$G+Z:u\u0015\taQ\"A\u0002ba&T\u0011AD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013'5\t1\"\u0003\u0002\u0015\u0017\t!\")Y:f!J|G-^2feN+g\u000e\u001a+fgR\fa\u0001P5oSRtD#A\f\u0011\u0005I\u0001\u0011a\u0005;fgR<&o\u001c8h'\u0016\u0014\u0018.\u00197ju\u0016\u0014H#\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0005\u0002\"A\t\u0016\u000e\u0003\rR!\u0001\u0004\u0013\u000b\u0005\u00152\u0013a\u00026va&$XM\u001d\u0006\u0003O!\nQA[;oSRT\u0011!K\u0001\u0004_J<\u0017BA\u0016$\u0005\u0011!Vm\u001d;\u0002#Q,7\u000f\u001e\"bi\u000eD7+\u001b>f5\u0016\u0014x\u000e\u000b\u0002\u0004C\u0005QC/Z:u'\u0016tGmQ8naJ,7o]3e\u001b\u0016\u001c8/Y4f/&$\b\u000eT8h\u0003B\u0004XM\u001c3US6,\u0007F\u0001\u0003\"\u00035\"Xm\u001d;TK:$gj\u001c8D_6\u0004(/Z:tK\u0012lUm]:bO\u0016<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u0015\u0003\u000b\u0005\n1\u0003^3ti\u0006+Ho\\\"sK\u0006$X\rV8qS\u000eD#AB\u0011\u0002;Q,7\u000f^*f]\u0012<\u0016\u000e\u001e5J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016D#aB\u0011\u0002/Q,7\u000f\u001e(p]\ncwnY6j]\u001e\u0004&o\u001c3vG\u0016\u0014\bF\u0001\u0005\"\u00039\"Xm\u001d;TK:$'+Z2pe\u0012\u0014\u0015\r^2i/&$\b.T1y%\u0016\fX/Z:u'&TX-\u00118e\u0011&<\u0007.\u001a:)\u0005%\t\u0003")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    @Test
    public void testWrongSerializer() {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(SerializationException.class, () -> producer.send(record));
    }

    @Test
    public void testBatchSizeZero() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerify(producer, this.sendAndVerify$default$2(), this.sendAndVerify$default$3());
    }

    @Test
    public void testSendCompressedMessageWithLogAppendTime() {
        String x$1 = "gzip";
        int x$2 = Integer.MAX_VALUE;
        int x$3 = Integer.MAX_VALUE;
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$1, x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithLogAppendTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @Test
    public void testAutoCreateTopic() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record).get()).offset(), (String)"Should have offset 0");
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        }
    }

    @Test
    public void testSendWithInvalidCreateTime() {
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), "1000");
        this.createTopic(this.topic(), 1, 2, topicProps, this.createTopic$default$5());
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
        String x$1 = "gzip";
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$2, x$3, x$4, x$1, x$5, x$6);){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
    }

    @Test
    public void testNonBlockingProducer() {
        long x$1 = 0L;
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$5, x$1, x$6);
        PlaintextProducerSendTest.verifyMetadataNotAvailable$1(this.send$1(producer));
        Future future = this.sendUntilQueued$1(producer);
        this.verifySendSuccess$1(future);
        long x$7 = 0L;
        int x$8 = 15000;
        int x$9 = 1100;
        long x$10 = 1500L;
        int x$11 = this.createProducer$default$2();
        String x$12 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer2 = this.createProducer(x$8, x$11, x$9, x$12, x$7, x$10);
        Future future2 = this.sendUntilQueued$1(producer2);
        PlaintextProducerSendTest.verifyBufferExhausted$1(this.send$1(producer2));
        this.verifySendSuccess$1(future2);
    }

    @Test
    public void testSendRecordBatchWithMaxRequestSizeAndHigher() {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()));
        int keyLengthSize = 1;
        int headerLengthSize = 1;
        int valueLengthSize = 3;
        int overhead = 94 + keyLengthSize + headerLengthSize + valueLengthSize;
        int valueSize = Defaults$.MODULE$.MessageMaxBytes() - overhead;
        ProducerRecord record0 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize]);
        Assertions.assertEquals((int)((byte[])record0.value()).length, (int)((RecordMetadata)producer.send(record0).get()).serializedValueSize());
        ProducerRecord record1 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize + 1]);
        Assertions.assertEquals(RecordTooLargeException.class, Assertions.assertThrows(ExecutionException.class, () -> producer.send(record1).get()).getCause().getClass());
    }

    private final Future send$1(KafkaProducer producer) {
        return producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)new byte[1000]));
    }

    public static final /* synthetic */ boolean $anonfun$testNonBlockingProducer$2(Future future) {
        if (future.isDone()) {
            try {
                future.get();
                return true;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Future sendUntilQueued$1(KafkaProducer producer) {
        void var2_7;
        Tuple2 tuple2;
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Future computeUntilTrue_result;
            if (PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(computeUntilTrue_result = this.send$1(producer))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Future future = (Future)tuple2._1();
        return var2_7;
    }

    private final void verifySendSuccess$1(Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get(30L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)0, (int)recordMetadata.partition());
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
    }

    private static final void verifyMetadataNotAvailable$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    private static final void verifyBufferExhausted$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(BufferExhaustedException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    public static final /* synthetic */ Object $anonfun$testNonBlockingProducer$2$adapted(Future future) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(future));
    }
}

