/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest;
import kafka.log.LogConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0011]a\u0001\u0002-Z\u0001yCQa\u0019\u0001\u0005\u0002\u0011DQA\u001a\u0001\u0005\u0002\u001d4qA\u001f\u0001\u0011\u0002\u0007\u00051\u0010\u0003\u0004\u0002,\r!\ta\u001a\u0005\n\u0003[\u0019\u0001\u0019!C\u0001\u0003_A\u0011\"a\u000e\u0004\u0001\u0004%\t!!\u000f\t\u000f\u0005}2\u0001\"\u0011\u0002B!9\u0011\u0011O\u0002\u0005B\u0005M\u0004BBAT\u0007\u0011\u0005s\rC\u0004\u0002@\r!\t%!+\u0007\u0013\u0005=\u0006\u0001%A\u0002\u0002\u0005E\u0006BBA\u0016\u0017\u0011\u0005q\rC\u0005\u0002:.\u0001\r\u0011\"\u0001\u0002<\"I\u00111Y\u0006A\u0002\u0013\u0005\u0011Q\u0019\u0005\b\u0003\u0013\\A\u0011IAf\u0011\u001d\t\th\u0003C!\u0003'Da!a*\f\t\u0003:\u0007bBAe\u0017\u0011\u0005\u00131\u001d\u0005\b\u0003S\u0004A\u0011BAv\u0011\u0019\t\t\u0010\u0001C\u0001O\"1!Q\u0001\u0001\u0005\u0002\u001dDaA!\u0003\u0001\t\u00039\u0007B\u0002B\u0007\u0001\u0011\u0005q\r\u0003\u0004\u0003\u0012\u0001!\ta\u001a\u0005\u0007\u0005+\u0001A\u0011A4\t\r\te\u0001\u0001\"\u0001h\u0011\u0019\u0011i\u0002\u0001C\u0001O\"1!\u0011\u0005\u0001\u0005\u0002\u001dDaA!\n\u0001\t\u00039\u0007B\u0002B\u0015\u0001\u0011\u0005q\r\u0003\u0004\u0003.\u0001!\ta\u001a\u0005\u0007\u0005c\u0001A\u0011A4\t\r\tU\u0002\u0001\"\u0001h\u0011\u0019\u0011I\u0004\u0001C\u0001O\"1!Q\b\u0001\u0005\u0002\u001dDaA!\u0011\u0001\t\u00039\u0007B\u0002B#\u0001\u0011\u0005q\r\u0003\u0004\u0003J\u0001!\ta\u001a\u0005\u0007\u0005\u001b\u0002A\u0011A4\t\r\tE\u0003\u0001\"\u0001h\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/BaAa\u001c\u0001\t\u00039\u0007B\u0002B:\u0001\u0011\u0005q\r\u0003\u0004\u0003x\u0001!\ta\u001a\u0005\u0007\u0005w\u0002A\u0011A4\t\u000f\t}\u0004\u0001\"\u0003\u0003\u0002\"1!q\u0011\u0001\u0005\u0002\u001dDqAa#\u0001\t\u0013\u0011i\t\u0003\u0004\u0003\u0014\u0002!\ta\u001a\u0005\u0007\u0005/\u0003A\u0011A4\t\r\tm\u0005\u0001\"\u0001h\u0011\u0019\u0011y\n\u0001C\u0001O\"1!1\u0015\u0001\u0005\u0002\u001dDaAa*\u0001\t\u00039\u0007B\u0002BV\u0001\u0011\u0005q\rC\u0004\u00030\u0002!\tA!-\t\r\t}\u0007\u0001\"\u0001h\u0011\u0019\u0011\u0019\u000f\u0001C\u0001O\"1!q\u001d\u0001\u0005\u0002\u001dDaAa;\u0001\t\u00039\u0007B\u0002Bx\u0001\u0011\u0005q\r\u0003\u0004\u0003t\u0002!\ta\u001a\u0005\u0007\u0005o\u0004A\u0011A4\t\r\tm\b\u0001\"\u0001h\u0011\u0019\u0011y\u0010\u0001C\u0001O\"111\u0001\u0001\u0005\u0002\u001dDaaa\u0002\u0001\t\u00039\u0007BBB\u0006\u0001\u0011\u0005q\r\u0003\u0004\u0004\u0010\u0001!\ta\u001a\u0005\u0007\u0007'\u0001A\u0011A4\t\r\r]\u0001\u0001\"\u0001h\u0011\u0019\u0019Y\u0002\u0001C\u0001O\"11q\u0004\u0001\u0005\u0002\u001dDaaa\t\u0001\t\u00039\u0007BBB\u0014\u0001\u0011\u0005q\r\u0003\u0004\u0004,\u0001!\ta\u001a\u0005\u0007\u0007_\u0001A\u0011A4\t\u000f\rM\u0002\u0001\"\u0001\u00046!911\b\u0001\u0005\u0002\ru\u0002bBBD\u0001\u0011\u00051\u0011\u0012\u0005\b\u0007C\u0003A\u0011ABR\u0011\u001d\u0019i\u000b\u0001C\u0001\u0007_Cqaa6\u0001\t\u0013\u0019I\u000eC\u0004\u0004t\u0002!Ia!>\t\r\u0011-\u0001\u0001\"\u0001h\u0011\u0019!y\u0001\u0001C\u0001O\"1A1\u0003\u0001\u0005\u0002\u001d\u0014Q\u0003\u00157bS:$X\r\u001f;D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002[7\u0006\u0019\u0011\r]5\u000b\u0003q\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001?B\u0011\u0001-Y\u0007\u00023&\u0011!-\u0017\u0002\u0011\u0005\u0006\u001cXmQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#A3\u0011\u0005\u0001\u0004\u0011a\u0003;fgRDU-\u00193feN$\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0002W\u0006)1oY1mC&\u0011QN\u001b\u0002\u0005+:LG\u000f\u000b\u0002\u0003_B\u0011\u0001\u000f_\u0007\u0002c*\u0011!L\u001d\u0006\u0003gR\fqA[;qSR,'O\u0003\u0002vm\u0006)!.\u001e8ji*\tq/A\u0002pe\u001eL!!_9\u0003\tQ+7\u000f\u001e\u0002\u000f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018*\u001c9m'\u0011\u0019A0!\u0003\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0004\u0005!!.\u0019<b\u0013\r\t9A \u0002\u0007\u001f\nTWm\u0019;\u0011\r\u0005-\u00111DA\u0010\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011!D:fe&\fG.\u001b>bi&|gN\u0003\u0003\u0002\u0014\u0005U\u0011AB2p[6|gNC\u0002]\u0003/Q1!!\u0007w\u0003\u0019\t\u0007/Y2iK&!\u0011QDA\u0007\u0005)\u0019VM]5bY&TXM\u001d\t\u0006S\u0006\u0005\u0012QE\u0005\u0004\u0003GQ'!B!se\u0006L\bcA5\u0002(%\u0019\u0011\u0011\u00066\u0003\t\tKH/Z\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0002\u0015M,'/[1mSj,'/\u0006\u0002\u00022A!\u00111BA\u001a\u0013\u0011\t)$!\u0004\u0003'\tKH/Z!se\u0006L8+\u001a:jC2L'0\u001a:\u0002\u001dM,'/[1mSj,'o\u0018\u0013fcR\u0019\u0001.a\u000f\t\u0013\u0005ub!!AA\u0002\u0005E\u0012a\u0001=%c\u0005I1/\u001a:jC2L'0\u001a\u000b\t\u0003?\t\u0019%!\u0018\u0002n!9\u0011QI\u0004A\u0002\u0005\u001d\u0013!\u0002;pa&\u001c\u0007\u0003BA%\u0003/rA!a\u0013\u0002TA\u0019\u0011Q\n6\u000e\u0005\u0005=#bAA);\u00061AH]8pizJ1!!\u0016k\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011LA.\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u000b6\t\u000f\u0005}s\u00011\u0001\u0002b\u00059\u0001.Z1eKJ\u001c\b\u0003BA2\u0003Sj!!!\u001a\u000b\t\u0005\u001d\u0014\u0011C\u0001\u0007Q\u0016\fG-\u001a:\n\t\u0005-\u0014Q\r\u0002\b\u0011\u0016\fG-\u001a:t\u0011\u001d\tyg\u0002a\u0001\u0003?\tA\u0001Z1uC\u0006I1m\u001c8gS\u001e,(/\u001a\u000b\u0006Q\u0006U\u0014Q\u0014\u0005\b\u0003oB\u0001\u0019AA=\u0003\u001d\u0019wN\u001c4jON\u0004D!a\u001f\u0002\fBA\u0011QPAB\u0003\u000f\n9)\u0004\u0002\u0002\u0000)!\u0011\u0011QA\u0001\u0003\u0011)H/\u001b7\n\t\u0005\u0015\u0015q\u0010\u0002\u0004\u001b\u0006\u0004\b\u0003BAE\u0003\u0017c\u0001\u0001\u0002\u0007\u0002\u000e\u0006U\u0014\u0011!A\u0001\u0006\u0003\tyIA\u0002`IE\nB!!%\u0002\u0018B\u0019\u0011.a%\n\u0007\u0005U%NA\u0004O_RD\u0017N\\4\u0011\u0007%\fI*C\u0002\u0002\u001c*\u00141!\u00118z\u0011\u001d\ty\n\u0003a\u0001\u0003C\u000bQ![:LKf\u00042![AR\u0013\r\t)K\u001b\u0002\b\u0005>|G.Z1o\u0003\u0015\u0019Gn\\:f)\u0019\ty\"a+\u0002.\"9\u0011Q\t\u0006A\u0002\u0005\u001d\u0003bBA8\u0015\u0001\u0007\u0011q\u0004\u0002\u0011\t\u0016\u001cXM]5bY&TXM]%na2\u001cBa\u0003?\u00024B1\u00111BA[\u0003?IA!a.\u0002\u000e\taA)Z:fe&\fG.\u001b>fe\u0006aA-Z:fe&\fG.\u001b>feV\u0011\u0011Q\u0018\t\u0005\u0003\u0017\ty,\u0003\u0003\u0002B\u00065!!\u0006\"zi\u0016\f%O]1z\t\u0016\u001cXM]5bY&TXM]\u0001\u0011I\u0016\u001cXM]5bY&TXM]0%KF$2\u0001[Ad\u0011%\tiDDA\u0001\u0002\u0004\ti,A\u0006eKN,'/[1mSj,G\u0003CA\u0010\u0003\u001b\fy-!5\t\u000f\u0005\u0015s\u00021\u0001\u0002H!9\u0011qL\bA\u0002\u0005\u0005\u0004bBA8\u001f\u0001\u0007\u0011q\u0004\u000b\u0006Q\u0006U\u0017\u0011\u001d\u0005\b\u0003o\u0002\u0002\u0019AAla\u0011\tI.!8\u0011\u0011\u0005u\u00141QA$\u00037\u0004B!!#\u0002^\u0012a\u0011q\\Ak\u0003\u0003\u0005\tQ!\u0001\u0002\u0010\n\u0019q\f\n\u001a\t\u000f\u0005}\u0005\u00031\u0001\u0002\"R1\u0011qDAs\u0003ODq!!\u0012\u0013\u0001\u0004\t9\u0005C\u0004\u0002pI\u0001\r!a\b\u0002?Q,7\u000f\u001e%fC\u0012,'o]*fe&\fG.\u001b>f\t\u0016\u001cXM]5bY&TX\rF\u0003i\u0003[\fy\u000fC\u0004\u0002.M\u0001\r!!\u0003\t\u000f\u0005e6\u00031\u0001\u00024\u0006)C/Z:u\t\u0016\u0004(/Z2bi\u0016$\u0007k\u001c7m\u00052|7m[:G_J\f5o]5h]6,g\u000e\u001e\u0015\u0003)=Ds\u0001FA|\u0003{\u0014\t\u0001E\u0002j\u0003sL1!a?k\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003\u007f\f\u0011\u0005]8mY\"\"UO]1uS>t\u0017\u0006I5tAQDW\r\t:fa2\f7-Z7f]R\f#Aa\u0001\u0002\u0007Ir\u0003'A\u0011uKN$\b*Z1eKJ\u001c8+\u001a:jC2L'0\u001a:EKN,'/[1mSj,'\u000f\u000b\u0002\u0016_\u0006\u0011B/Z:u\u001b\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3tQ\t1r.A\u000buKN$X*\u0019=Q_2d\u0017J\u001c;feZ\fG.T:)\u0005]y\u0017A\n;fgRl\u0015\r\u001f)pY2Le\u000e^3sm\u0006dWj\u001d#fY\u0006L\u0018J\u001c*fm>\u001c\u0017\r^5p]\"\u0012\u0001d\\\u0001'i\u0016\u001cH/T1y!>dG.\u00138uKJ4\u0018\r\\'t\t\u0016d\u0017-_%o\u0003N\u001c\u0018n\u001a8nK:$\bFA\rp\u0003U!Xm\u001d;BkR|7i\\7nSR|en\u00117pg\u0016D#AG8\u0002AQ,7\u000f^!vi>\u001cu.\\7ji>s7\t\\8tK\u00063G/\u001a:XC.,W\u000f\u001d\u0015\u00037=\f1\u0003^3ti\u0006+Ho\\(gMN,GOU3tKRD#\u0001H8\u0002)Q,7\u000f^$s_V\u00048i\u001c8tk6\u0004H/[8oQ\tir.A\fuKN$\b+\u0019;uKJt7+\u001e2tGJL\u0007\u000f^5p]\"\u0012ad\\\u0001\"i\u0016\u001cHoU;cg\u0016\fX/\u001a8u!\u0006$H/\u001a:o'V\u00147o\u0019:jaRLwN\u001c\u0015\u0003?=\f\u0011\u0004^3tiB\u000bG\u000f^3s]Vs7/\u001e2tGJL\u0007\u000f^5p]\"\u0012\u0001e\\\u0001\u0013i\u0016\u001cHoQ8n[&$X*\u001a;bI\u0006$\u0018\r\u000b\u0002\"_\u0006yA/Z:u\u0003NLhnY\"p[6LG\u000f\u000b\u0002#_\u0006yB/Z:u\u000bb\u0004\u0018M\u001c3j]\u001e$v\u000e]5d'V\u00147o\u0019:jaRLwN\\:)\u0005\rz\u0017a\b;fgR\u001c\u0006N]5oW&tw\rV8qS\u000e\u001cVOY:de&\u0004H/[8og\"\u0012Ae\\\u0001\u0012i\u0016\u001cH\u000fU1si&$\u0018n\u001c8t\r>\u0014\bFA\u0013p\u0003m!Xm\u001d;QCJ$\u0018\u000e^5p]N4uN]!vi>\u001c%/Z1uK\"\u0012ae\\\u0001\u001ei\u0016\u001cH\u000fU1si&$\u0018n\u001c8t\r>\u0014\u0018J\u001c<bY&$Gk\u001c9jG\"\u0012qe\\\u0001\ti\u0016\u001cHoU3fW\"\u0012\u0001f\\\u0001\u0017g\u0016tGmQ8naJ,7o]3e\u001b\u0016\u001c8/Y4fgR)\u0001N!\u0017\u0003d!9!1L\u0015A\u0002\tu\u0013A\u00038v[J+7m\u001c:egB\u0019\u0011Na\u0018\n\u0007\t\u0005$NA\u0002J]RDqA!\u001a*\u0001\u0004\u00119'\u0001\u0002uaB!!\u0011\u000eB6\u001b\t\t\t\"\u0003\u0003\u0003n\u0005E!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0016i\u0016\u001cH\u000fU8tSRLwN\\!oI\u000e{W.\\5uQ\tQs.A\u000euKN$\b+\u0019:uSRLwN\u001c)bkN,\u0017I\u001c3SKN,X.\u001a\u0015\u0003W=\fa\u0003^3ti\u001a+Go\u00195J]Z\fG.\u001b3PM\u001a\u001cX\r\u001e\u0015\u0003Y=\fa\u0005^3ti\u001a+Go\u00195SK\u000e|'\u000f\u001a'be\u001e,'\u000f\u00165b]\u001a+Go\u00195NCb\u0014\u0015\u0010^3tQ\tis.\u0001\tdQ\u0016\u001c7\u000eT1sO\u0016\u0014VmY8sIR\u0019\u0001Na!\t\u000f\t\u0015e\u00061\u0001\u0003^\u0005\u0011\u0002O]8ek\u000e,'OU3d_J$7+\u001b>f\u00039\"Xm\u001d;GKR\u001c\u0007\u000eS8o_V\u00148OR3uG\"\u001c\u0016N_3JM2\u000b'oZ3SK\u000e|'\u000f\u001a(pi\u001aK'o\u001d;)\u0005=z\u0017AK2iK\u000e\\g)\u001a;dQ\"{gn\\;sgNK'0Z%g\u0019\u0006\u0014x-\u001a*fG>\u0014HMT8u\r&\u00148\u000f\u001e\u000b\u0004Q\n=\u0005b\u0002BIa\u0001\u0007!QL\u0001\u0018Y\u0006\u0014x-\u001a)s_\u0012,8-\u001a:SK\u000e|'\u000fZ*ju\u0016\f1\b^3ti\u001a+Go\u00195I_:|WO]:NCb\u0004\u0016M\u001d;ji&|gNR3uG\"\u0014\u0015\u0010^3t\u0013\u001ad\u0015M]4f%\u0016\u001cwN\u001d3O_R4\u0015N]:uQ\t\tt.A\u0018uKN$h)\u001a;dQJ+7m\u001c:e\u0019\u0006\u0014x-\u001a:UQ\u0006tW*\u0019=QCJ$\u0018\u000e^5p]\u001a+Go\u00195CsR,7\u000f\u000b\u00023_\u0006IC/Z:u\u0019><X*\u0019=GKR\u001c\u0007nU5{K\u001a{'OU3rk\u0016\u001cH/\u00118e!\u0006\u0014H/\u001b;j_:D#aM8\u00021Q,7\u000f\u001e*pk:$'k\u001c2j]\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u00025_\u0006\u0019C/Z:u\u001bVdG/[\"p]N,X.\u001a:S_VtGMU8cS:\f5o]5h]>\u0014\bFA\u001bp\u0003}!Xm\u001d;Nk2$\u0018nQ8ogVlWM]*uS\u000e\\\u00170Q:tS\u001etwN\u001d\u0015\u0003m=\f\u0001\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s\t\u00164\u0017-\u001e7u\u0003N\u001c\u0018n\u001a8pe\"\u0012qg\\\u0001\u0017i\u0016\u001cHOU3cC2\fgnY3B]\u0012\u0014VM[8j]R\u0019\u0001Na-\t\u000f\tU\u0006\b1\u0001\u0002H\u0005\u0011\u0012m]:jO:lWM\u001c;TiJ\fG/Z4zQ\u001dA$\u0011\u0018Be\u0005\u0017\u0004BAa/\u0003F6\u0011!Q\u0018\u0006\u0005\u0005\u007f\u0013\t-\u0001\u0005qe>4\u0018\u000eZ3s\u0015\r\u0011\u0019M]\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\t\u001d'Q\u0018\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\t5'\u0011[\u0011\u0003\u0005\u001f\f1h\u001c:h]\u0005\u0004\u0018m\u00195f]-\fgm[1/G2LWM\u001c;t]\r|gn];nKJt3i\\8qKJ\fG/\u001b<f'RL7m[=BgNLwM\\8sC\t\u0011\u0019.A\u0018pe\u001et\u0013\r]1dQ\u0016t3.\u00194lC:\u001aG.[3oiNt3m\u001c8tk6,'O\f*b]\u001e,\u0017i]:jO:|'\u000fK\u00029\u0005/\u0004BA!7\u0003\\6\u0011!\u0011Y\u0005\u0005\u0005;\u0014\tMA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f1\u0007^3ti6+H\u000e^5D_:\u001cX/\\3s\t\u00164\u0017-\u001e7u\u0003N\u001c\u0018n\u001a8pe\u0006sGMV3sS\u001aL\u0018i]:jO:lWM\u001c;)\u0005ez\u0017\u0001\f;fgRlU\u000f\u001c;j\u0007>t7/^7feN+7o]5p]RKW.Z8vi>s7\u000b^8q!>dG.\u001b8hQ\tQt.\u0001\u0014uKN$X*\u001e7uS\u000e{gn];nKJ\u001cVm]:j_:$\u0016.\\3pkR|en\u00117pg\u0016D#aO8\u0002!Q,7\u000f^%oi\u0016\u00148-\u001a9u_J\u001c\bF\u0001\u001fp\u0003]!Xm\u001d;BkR|7i\\7nSRLe\u000e^3sG\u0016\u0004H\u000f\u000b\u0002>_\u0006\tC/Z:u\u0013:$XM]2faR|'o],ji\"<&o\u001c8h\u0017\u0016Lh+\u00197vK\"\u0012ah\\\u0001\"i\u0016\u001cHoQ8ogVlW-T3tg\u0006<Wm],ji\"\u001c%/Z1uKRKW.\u001a\u0015\u0003\u007f=\fA\u0005^3ti\u000e{gn];nK6+7o]1hKN<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u0015\u0003\u0001>\fa\u0002^3ti2K7\u000f\u001e+pa&\u001c7\u000f\u000b\u0002B_\u0006!B/Z:u+:\u001cXOY:de&\u0014W\rV8qS\u000eD#AQ8\u0002KQ,7\u000f\u001e)bkN,7\u000b^1uK:{G\u000f\u0015:fg\u0016\u0014h/\u001a3CsJ+'-\u00197b]\u000e,\u0007FA\"p\u0003i!Xm\u001d;D_6l\u0017\u000e^*qK\u000eLg-[3e\u001f\u001a47/\u001a;tQ\t!u.A\ruKN$\u0018)\u001e;p\u0007>lW.\u001b;P]J+'-\u00197b]\u000e,\u0007FA#p\u0003=\"Xm\u001d;QKJ\u0004\u0016M\u001d;ji&|g\u000eT3bI6+GO]5dg\u000ecW-\u00198Va^KG\u000f[*vEN\u001c'/\u001b2fQ\t1u.\u0001\u0018uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2\u000bw-T3ue&\u001c7o\u00117fC:,\u0006oV5uQN+(m]2sS\n,\u0007FA$p\u00031\"Xm\u001d;QKJ\u0004\u0016M\u001d;ji&|g\u000eT3bI6+GO]5dg\u000ecW-\u00198Va^KG\u000f[!tg&<g\u000e\u000b\u0002I_\u0006YC/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'bO6+GO]5dg\u000ecW-\u00198Va^KG\u000f[!tg&<g\u000e\u000b\u0002J_\u0006YC/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'bO6+GO]5dg^CWM\u001c*fC\u0012\u001cu.\\7jiR,G\r\u000b\u0002K_\u00061C/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'fC\u0012<\u0016\u000e\u001e5NCb\u0004v\u000e\u001c7SK\u000e|'\u000fZ:)\u0005-{\u0017!\n;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0006<w+\u001b;i\u001b\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3tQ\tau.\u0001\u0018uKN$\u0018+^8uC6+GO]5dg:{Go\u0011:fCR,G-\u00134O_F+x\u000e^1t\u0007>tg-[4ve\u0016$\u0007FA'p\u0003\t\u0012XO\\'vYRL7i\u001c8tk6,'oU3tg&|g\u000eV5nK>,H\u000fV3tiR\u0019\u0001na\u000e\t\u000f\reb\n1\u0001\u0002\"\u0006i1\r\\8tK\u000e{gn];nKJ\f!c];cg\u000e\u0014\u0018NY3D_:\u001cX/\\3sgR11qHB.\u0007c\u0002ba!\u0011\u0004L\r=SBAB\"\u0015\u0011\u0019)ea\u0012\u0002\u000f5,H/\u00192mK*\u00191\u0011\n6\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004N\r\r#A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0004R\rMS\"\u0001\u0001\n\t\rU3q\u000b\u0002\u0019\u0007>t7/^7fe\u0006\u001b8/[4o[\u0016tG\u000fU8mY\u0016\u0014\u0018bAB-3\n!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgRDqa!\u0018P\u0001\u0004\u0019y&A\u0007d_:\u001cX/\\3s\u000fJ|W\u000f\u001d\t\u0007\u0007\u0003\u001aYe!\u0019\u0011\u0011\r\r4QNA\u0010\u0003?i!a!\u001a\u000b\t\r\u001d4\u0011N\u0001\tG>t7/^7fe*!11NA\u000b\u0003\u001d\u0019G.[3oiNLAaa\u001c\u0004f\ti1*\u00194lC\u000e{gn];nKJDqaa\u001dP\u0001\u0004\u0019)(A\tu_BL7m\u001d+p'V\u00147o\u0019:jE\u0016\u0004baa\u001e\u0004\u0002\u0006\u001dc\u0002BB=\u0007{rA!!\u0014\u0004|%\t1.C\u0002\u0004\u0000)\fq\u0001]1dW\u0006<W-\u0003\u0003\u0004\u0004\u000e\u0015%\u0001\u0002'jgRT1aa k\u0003\u001d\u001a'/Z1uK\u000e{gn];nKJ<%o\\;q\u0003:$w+Y5u\r>\u0014\u0018i]:jO:lWM\u001c;\u0015\u0011\r-5\u0011SBK\u0007/\u0003r![BG\u0007?\u001ay$C\u0002\u0004\u0010*\u0014a\u0001V;qY\u0016\u0014\u0004bBBJ!\u0002\u0007!QL\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\u000f\rM\u0004\u000b1\u0001\u0004v!91\u0011\u0014)A\u0002\rm\u0015!D:vEN\u001c'/\u001b9uS>t7\u000f\u0005\u0004\u0002J\ru%qM\u0005\u0005\u0007?\u000bYFA\u0002TKR\fAg\u00195b]\u001e,7i\u001c8tk6,'o\u0012:pkB\u001cVOY:de&\u0004H/[8o\u0003:$g+\u00197jI\u0006$X-Q:tS\u001etW.\u001a8u)\u001dA7QUBU\u0007WCqaa*R\u0001\u0004\u0019y$A\bd_:\u001cX/\\3s!>dG.\u001a:t\u0011\u001d\u0019\u0019(\u0015a\u0001\u0007kBqa!'R\u0001\u0004\u0019Y*A\u0018dQ\u0006tw-Z\"p]N,X.\u001a:Tk\n\u001c8M]5qi&|g.\u00118e-\u0006d\u0017\u000eZ1uK\u0006\u001b8/[4o[\u0016tG/\u0006\u0004\u00042\u000eu61\u0019\u000b\nQ\u000eM6qYBe\u0007\u001bDqaa\u001aS\u0001\u0004\u0019)\f\u0005\u0005\u0004d\r]61XBa\u0013\u0011\u0019Il!\u001a\u0003\u0011\r{gn];nKJ\u0004B!!#\u0004>\u001291q\u0018*C\u0002\u0005=%!A&\u0011\t\u0005%51\u0019\u0003\b\u0007\u000b\u0014&\u0019AAH\u0005\u00051\u0006bBB:%\u0002\u00071Q\u000f\u0005\b\u0007\u0017\u0014\u0006\u0019ABN\u0003I)\u0007\u0010]3di\u0016$\u0017i]:jO:lWM\u001c;\t\u000f\r='\u000b1\u0001\u0004R\u0006\t\"/\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\u0011\t\r\r41[\u0005\u0005\u0007+\u001c)GA\rD_:\u001cX/\\3s%\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014\u0018\u0001F1xC&$hj\u001c8F[B$\u0018PU3d_J$7/\u0006\u0004\u0004\\\u000e\u00158\u0011\u001e\u000b\u0007\u0007;\u001cYoa<\u0011\u0011\r\r4q\\Br\u0007OLAa!9\u0004f\ty1i\u001c8tk6,'OU3d_J$7\u000f\u0005\u0003\u0002\n\u000e\u0015HaBB`'\n\u0007\u0011q\u0012\t\u0005\u0003\u0013\u001bI\u000fB\u0004\u0004FN\u0013\r!a$\t\u000f\r\u001d4\u000b1\u0001\u0004nBA11MB\\\u0007G\u001c9\u000fC\u0004\u0004rN\u0003\rAa\u001a\u0002\u0013A\f'\u000f^5uS>t\u0017aD1xC&$\u0018i]:jO:lWM\u001c;\u0015\u000b!\u001c9\u0010\"\u0003\t\u000f\r\u001dD\u000b1\u0001\u0004zB211`B\u0000\t\u000b\u0001\u0002ba\u0019\u00048\u000euH1\u0001\t\u0005\u0003\u0013\u001by\u0010\u0002\u0007\u0005\u0002\r]\u0018\u0011!A\u0001\u0006\u0003\tyIA\u0002`IM\u0002B!!#\u0005\u0006\u0011aAqAB|\u0003\u0003\u0005\tQ!\u0001\u0002\u0010\n\u0019q\f\n\u001b\t\u000f\r-G\u000b1\u0001\u0004\u001c\u0006aB/Z:u\u0007>t7/^7j]\u001e<\u0016\u000e\u001e5Ok2dwI]8va&#\u0007FA+p\u0003u!Xm\u001d;D_:\u001cX/\\5oO^KG\u000f[#naRLxI]8va&#\u0007F\u0001,p\u0003a\"Xm\u001d;Ti\u0006$\u0018nY\"p]N,X.\u001a:EKR,7\r^:OK^\u0004\u0016M\u001d;ji&|gn\u0011:fCR,G-\u00114uKJ\u0014Vm\u001d;beRD#aV8")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @Test
    public void testHeaders() {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Header header = ((ConsumerRecord)records.apply(i)).headers().lastHeader("headerKey");
            Assertions.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3()).send(record);
        KafkaConsumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
    }

    @Test
    public void testDeprecatedPollBlocksForAssignment() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        consumer.poll(0L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
    }

    @Test
    public void testHeadersSerializerDeserializer() {
        SerializerImpl extendedSerializer = new SerializerImpl(this){
            private ByteArraySerializer serializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] serialize(String topic, Headers headers, byte[] data) {
                return SerializerImpl.serialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                SerializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                SerializerImpl.close$(this);
            }

            public byte[] serialize(String topic, byte[] data) {
                return SerializerImpl.serialize$(this, topic, data);
            }

            public ByteArraySerializer serializer() {
                return this.serializer;
            }

            public void serializer_$eq(ByteArraySerializer x$1) {
                this.serializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                SerializerImpl.$init$(this);
            }
        };
        DeserializerImpl extendedDeserializer = new DeserializerImpl(this){
            private ByteArrayDeserializer deserializer;
            private final /* synthetic */ PlaintextConsumerTest $outer;

            public byte[] deserialize(String topic, Headers headers, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, headers, data);
            }

            public void configure(java.util.Map<String, ?> configs, boolean isKey) {
                DeserializerImpl.configure$(this, configs, isKey);
            }

            public void close() {
                DeserializerImpl.close$(this);
            }

            public byte[] deserialize(String topic, byte[] data) {
                return DeserializerImpl.deserialize$(this, topic, data);
            }

            public ByteArrayDeserializer deserializer() {
                return this.deserializer;
            }

            public void deserializer_$eq(ByteArrayDeserializer x$1) {
                this.deserializer = x$1;
            }

            public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                DeserializerImpl.$init$(this);
            }
        };
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @Test
    public void testMaxPollRecords() {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$3 = 0;
        int x$6 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$8 = this.consumeAndVerifyRecords$default$7();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$3, x$6, startingTimestamp, x$7, x$8, maxPollRecords);
    }

    @Test
    public void testMaxPollIntervalMs() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(2000));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)0, (int)listener.callsToRevoked());
        Thread.sleep(3000L);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((int)2, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)1, (int)listener.callsToRevoked());
    }

    @Test
    public void testMaxPollIntervalMsDelayInRevocation() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this, committedPosition, consumer, commitCompleted){
            private final /* synthetic */ PlaintextConsumerTest $outer;
            private final LongRef committedPosition$1;
            private final KafkaConsumer consumer$1;
            private final BooleanRef commitCompleted$1;

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (!partitions.isEmpty() && partitions.contains(this.$outer.tp())) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.committedPosition$1 = committedPosition$1;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"otherTopic", (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertEquals((long)0L, (long)committedPosition.elem);
        Assertions.assertTrue((boolean)commitCompleted.elem);
    }

    @Test
    public void testMaxPollIntervalMsDelayInAssignment() {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        this.ensureNoRebalance((Consumer<?, ?>)consumer, listener);
    }

    @Test
    public void testAutoCommitOnClose() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnCloseAfterWakeup() {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.wakeup();
        consumer.close();
        KafkaConsumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoOffsetReset() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$2 = 1;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @Test
    public void testGroupConsumption() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 10, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        int x$2 = 1;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
    }

    @Test
    public void testPatternSubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        String topic2 = "tblablak";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic2, 1), this.sendRecords$default$4());
        String topic3 = "tblab1";
        this.createTopic(topic3, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic3, 1), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern = Pattern.compile("t.*c");
        consumer.subscribe(pattern, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        String topic4 = "tsomec";
        this.createTopic(topic4, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic4, 1), this.sendRecords$default$4());
        assignment = (scala.collection.immutable.Set)assignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic4, 0), new TopicPartition(topic4, 1)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testSubsequentPatternSubscription() {
        this.consumerConfig().setProperty("metadata.max.age.ms", "30000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String fooTopic = "foo";
        this.createTopic(fooTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(fooTopic, 0), this.sendRecords$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        Pattern pattern1 = Pattern.compile(".*o.*");
        consumer.subscribe(pattern1, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(fooTopic, 0)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        String barTopic = "bar";
        this.createTopic(barTopic, 1, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(barTopic, 0), this.sendRecords$default$4());
        Pattern pattern2 = Pattern.compile("...");
        consumer.subscribe(pattern2, (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        assignment = (scala.collection.immutable.Set)assignment.$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)})));
        assignment = (scala.collection.immutable.Set)assignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(barTopic, 0)})));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testPatternUnsubscription() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        String topic1 = "tblablac";
        this.createTopic(topic1, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        this.sendRecords(producer, 1000, new TopicPartition(topic1, 1), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe(Pattern.compile("t.*c"), (ConsumerRebalanceListener)new AbstractConsumerTest.TestConsumerReassignmentListener());
        scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(topic1, 0), new TopicPartition(topic1, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)assignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testCommitMetadata() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, Optional.of(Predef$.MODULE$.int2Integer(15)), "foo");
        consumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assertions.assertEquals((Object)syncMetadata, consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)asyncMetadata)}))));
        Assertions.assertEquals((Object)asyncMetadata, consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        consumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)nullMetadata)}))).asJava());
        Assertions.assertEquals((Object)nullMetadata, consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAsyncCommit() {
        void pollUntilTrue_action;
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        AbstractConsumerTest.CountConsumerCommitCallback callback = new AbstractConsumerTest.CountConsumerCommitCallback();
        int count = 5;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> consumer.commitAsync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)callback));
        long l = 10000L;
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> callback.successCount() >= count || callback.lastError().isDefined();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testAsyncCommit$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
        Assertions.assertEquals((Object)None$.MODULE$, callback.lastError());
        Assertions.assertEquals((int)count, (int)callback.successCount());
        Assertions.assertEquals((Object)new OffsetAndMetadata((long)count), consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @Test
    public void testExpandingTopicSubscriptions() {
        String otherTopic = "other";
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.immutable.Set expandedAssignment = (scala.collection.immutable.Set)initialAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expandedAssignment);
    }

    @Test
    public void testShrinkingTopicSubscriptions() {
        String otherTopic = "other";
        this.createTopic(otherTopic, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.immutable.Set initialAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1), new TopicPartition(otherTopic, 0), new TopicPartition(otherTopic, 1)}));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)otherTopic, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)initialAssignment);
        scala.collection.immutable.Set shrunkenAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), 0), new TopicPartition(this.topic(), 1)}));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)shrunkenAssignment);
    }

    @Test
    public void testPartitionsFor() {
        int numParts = 2;
        this.createTopic("part-test", numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        java.util.List parts = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).partitionsFor("part-test");
        Assertions.assertNotNull((Object)parts);
        Assertions.assertEquals((int)2, (int)parts.size());
    }

    @Test
    public void testPartitionsForAutoCreate() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.partitionsFor("non-exist-topic");
        Assertions.assertFalse((boolean)consumer.partitionsFor("non-exist-topic").isEmpty());
    }

    @Test
    public void testPartitionsForInvalidTopic() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(InvalidTopicException.class, () -> consumer.partitionsFor(";3# ads,{234"));
    }

    @Test
    public void testSeek() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()));
        int x$2 = 1;
        int x$3 = 0;
        long x$4 = startingTimestamp;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, x$4, x$6, x$7, x$8);
        consumer.seek(this.tp(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp2()));
        int x$10 = 1;
        int x$11 = 0;
        TopicPartition x$12 = this.tp2();
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$10, x$11, x$13, x$14, x$15, x$12, x$16);
        consumer.seek(this.tp2(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        int x$18 = 1;
        int x$19 = (int)mid;
        int x$20 = (int)mid;
        TopicPartition x$22 = this.tp2();
        TimestampType x$23 = this.consumeAndVerifyRecords$default$6();
        int x$24 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$18, x$19, x$20, mid, x$23, x$22, x$24);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", Integer.toString(Integer.MAX_VALUE));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, producerProps);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes())));
        producer.close();
    }

    @Test
    public void testPositionAndCommit() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertNull(consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))).asJava()).get(topicPartition));
        Assertions.assertThrows(IllegalStateException.class, () -> consumer.position(topicPartition));
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()), (String)"position() on a partition that we are subscribed to should reset the offset");
        consumer.commitSync();
        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        int x$2 = 5;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        Assertions.assertEquals((long)5L, (long)consumer.position(this.tp()), (String)"After consuming 5 records, position should be 5");
        consumer.commitSync();
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset(), (String)"Committed offset should be returned");
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp);
        KafkaConsumer otherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        otherConsumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$10 = 1;
        int x$11 = 5;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)otherConsumer, x$10, x$11, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testPartitionPauseAndResume() {
        java.util.List partitions = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)partitions);
        int x$2 = 5;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)partitions);
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(100L)).isEmpty());
        consumer.resume((Collection)partitions);
        int x$10 = 5;
        int x$11 = 5;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$10, x$11, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testFetchInvalidOffset() {
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int totalRecords = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, totalRecords, this.tp(), this.sendRecords$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertThrows(NoOffsetForPartitionException.class, () -> consumer.poll(Duration.ofMillis(15000L)));
        int outOfRangePos = totalRecords + 1;
        consumer.seek(this.tp(), (long)outOfRangePos);
        java.util.Map outOfRangePartitions = ((OffsetOutOfRangeException)Assertions.assertThrows(OffsetOutOfRangeException.class, () -> consumer.poll(Duration.ofMillis(20000L)))).offsetOutOfRangePartitions();
        Assertions.assertNotNull((Object)outOfRangePartitions);
        Assertions.assertEquals((int)1, (int)outOfRangePartitions.size());
        Assertions.assertEquals((long)outOfRangePos, (Long)((Long)outOfRangePartitions.get(this.tp())));
    }

    @Test
    public void testFetchRecordLargerThanFetchMaxBytes() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkLargeRecord(maxFetchBytes + 1);
    }

    private void checkLargeRecord(int producerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)new byte[producerRecordSize]);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])record.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])record.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursFetchSizeIfLargeRecordNotFirst() {
        int maxFetchBytes = 10240;
        this.consumerConfig().setProperty("fetch.max.bytes", Integer.toString(maxFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxFetchBytes);
    }

    private void checkFetchHonoursSizeIfLargeRecordNotFirst(int largeProducerRecordSize) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ProducerRecord smallRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"small".getBytes(), (Object)"value".getBytes());
        ProducerRecord largeRecord = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"large".getBytes(), (Object)new byte[largeProducerRecordSize]);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(smallRecord).get();
        producer.send(largeRecord).get();
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = consumer.poll(Duration.ofMillis(20000L));
        Assertions.assertEquals((int)1, (int)records.count());
        ConsumerRecord consumerRecord = (ConsumerRecord)records.iterator().next();
        Assertions.assertEquals((long)0L, (long)consumerRecord.offset());
        Assertions.assertEquals((Object)this.tp().topic(), (Object)consumerRecord.topic());
        Assertions.assertEquals((int)this.tp().partition(), (int)consumerRecord.partition());
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.key()), (byte[])((byte[])consumerRecord.key()));
        Assertions.assertArrayEquals((byte[])((byte[])smallRecord.value()), (byte[])((byte[])consumerRecord.value()));
    }

    @Test
    public void testFetchHonoursMaxPartitionFetchBytesIfLargeRecordNotFirst() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkFetchHonoursSizeIfLargeRecordNotFirst(maxPartitionFetchBytes);
    }

    @Test
    public void testFetchRecordLargerThanMaxPartitionFetchBytes() {
        int maxPartitionFetchBytes = 10240;
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(maxPartitionFetchBytes));
        this.checkLargeRecord(maxPartitionFetchBytes + 1);
    }

    @Test
    public void testLowMaxFetchSizeForRequestAndPartition() {
        this.consumerConfig().setProperty("fetch.max.bytes", "500");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(20000));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        String topic3 = "topic3";
        int partitionCount = 30;
        .colon.colon topics = new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)));
        topics.foreach((Function1 & Serializable & scala.Serializable)topicName -> this.createTopic((String)topicName, partitionCount, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5()));
        Seq partitions = (Seq)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionCount).map((Function1 & Serializable & scala.Serializable)x$1 -> PlaintextConsumerTest.$anonfun$testLowMaxFetchSizeForRequestAndPartition$3(topic, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)partitions.toSet());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Seq producerRecords = (Seq)partitions.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, partitionCount, (TopicPartition)x$2, this.sendRecords$default$4()), Seq$.MODULE$.canBuildFrom());
        ArrayBuffer consumerRecords = this.consumeRecords(consumer, producerRecords.size(), this.consumeRecords$default$3());
        scala.collection.immutable.Set expected = ((TraversableOnce)producerRecords.map((Function1 & Serializable & scala.Serializable)record -> new Tuple5((Object)record.topic(), (Object)record.partition(), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)record.timestamp()), Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set actual = ((TraversableOnce)consumerRecords.map((Function1 & Serializable & scala.Serializable)record -> new Tuple5((Object)record.topic(), (Object)BoxesRunTime.boxToInteger((int)record.partition()), (Object)new String((byte[])record.key()), (Object)new String((byte[])record.value()), (Object)BoxesRunTime.boxToLong((long)record.timestamp())), ArrayBuffer$.MODULE$.canBuildFrom())).toSet();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRoundRobinAssignment() {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        String topic3 = "topic3";
        this.createTopicAndSendRecords(producer, topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newExpectedAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerRoundRobinAssignor() {
        void var7_7;
        void var6_6;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 8, 100));
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        void consumerGroup2 = var6_6;
        void consumerPollers2 = var7_7;
        try {
            this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions, "roundrobin-group");
        }
        finally {
            consumerPollers2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultiConsumerStickyAssignor() {
        void var7_7;
        void var6_6;
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicAndSendRecords(producer, topic, rand * 10, 100);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        void consumerGroup2 = var6_6;
        void consumerPollers2 = var7_7;
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, partitions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        scala.collection.immutable.Map prePartition2PollerId = PlaintextConsumerTest.reverse$1(((TraversableOnce)consumerPollers2.map((Function1 & Serializable & scala.Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup2, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers2, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, "sticky-group");
        scala.collection.immutable.Map postPartition2PollerId = PlaintextConsumerTest.reverse$1(((TraversableOnce)consumerPollers2.map((Function1 & Serializable & scala.Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        scala.collection.immutable.Set keys = (scala.collection.immutable.Set)prePartition2PollerId.keySet().union((GenSet)postPartition2PollerId.keySet());
        IntRef changes = IntRef.create((int)0);
        keys.foreach((Function1 & Serializable & scala.Serializable)key -> {
            PlaintextConsumerTest.$anonfun$testMultiConsumerStickyAssignor$5(prePartition2PollerId, postPartition2PollerId, changes, key);
            return BoxedUnit.UNIT;
        });
        consumerPollers2.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)rand, (int)changes.elem, (String)"Expected only two topic partitions that have switched to other consumers.");
    }

    @Test
    public void testMultiConsumerDefaultAssignor() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 5, 100));
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, (Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.addConsumersToGroupAndWaitForGroupAssignment$default$6());
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(producer, topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"org.apache.kafka.clients.consumer.CooperativeStickyAssignor", "org.apache.kafka.clients.consumer.RangeAssignor"})
    public void testRebalanceAndRejoin(String assignmentStrategy) {
        String stableMemberId1;
        int stableGeneration;
        this.consumerConfig().setProperty("group.id", "rebalance-and-rejoin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", assignmentStrategy);
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer1 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaConsumer consumer2 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic = "topic1";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> expectedAssignment = this.createTopicAndSendRecords(producer, topic, 2, 100);
        Assertions.assertEquals((int)0, (int)consumer1.assignment().size());
        Assertions.assertEquals((int)0, (int)consumer2.assignment().size());
        ReentrantLock lock = new ReentrantLock();
        IntRef generationId1 = IntRef.create((int)-1);
        ObjectRef memberId1 = ObjectRef.create((Object)"");
        ConsumerRebalanceListener customRebalanceListener = new ConsumerRebalanceListener(null, lock, generationId1, consumer1, memberId1){
            private final ReentrantLock lock$1;
            private final IntRef generationId1$1;
            private final KafkaConsumer consumer1$1;
            private final ObjectRef memberId1$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                if (!this.lock$1.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    Assertions.fail((String)"Time out while awaiting for lock.");
                }
                try {
                    this.generationId1$1.elem = this.consumer1$1.groupMetadata().generationId();
                    this.memberId1$1.elem = this.consumer1$1.groupMetadata().memberId();
                }
                finally {
                    this.lock$1.unlock();
                }
            }
            {
                this.lock$1 = lock$1;
                this.generationId1$1 = generationId1$1;
                this.consumer1$1 = consumer1$1;
                this.memberId1$1 = memberId1$1;
            }
        };
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller1 = new AbstractConsumerTest.ConsumerAssignmentPoller(this, (Consumer<byte[], byte[]>)consumer1, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), customRebalanceListener);
        consumerPoller1.start();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testRebalanceAndRejoin$1(consumerPoller1, expectedAssignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testRebalanceAndRejoin$2(expectedAssignment));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Time out while awaiting for lock.");
        }
        try {
            stableGeneration = generationId1.elem;
            stableMemberId1 = (String)memberId1.elem;
        }
        finally {
            lock.unlock();
        }
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller2 = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer2, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), this.subscribeConsumerAndStartPolling$default$3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testRebalanceAndRejoin$3(consumerPoller1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testRebalanceAndRejoin$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testRebalanceAndRejoin$5(consumerPoller2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testRebalanceAndRejoin$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Time out while awaiting for lock.");
        }
        try {
            if (assignmentStrategy.equals(CooperativeStickyAssignor.class.getName())) {
                Assertions.assertEquals((int)(stableGeneration + 2), (int)generationId1.elem);
            } else {
                Assertions.assertEquals((int)(stableGeneration + 1), (int)generationId1.elem);
            }
            Assertions.assertEquals((Object)stableMemberId1, (Object)((String)memberId1.elem));
        }
        finally {
            lock.unlock();
        }
        consumerPoller1.shutdown();
        consumerPoller2.shutdown();
    }

    @Test
    public void testMultiConsumerDefaultAssignorAndVerifyAssignment() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic2, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        TopicPartition tp1_0 = new TopicPartition(topic1, 0);
        TopicPartition tp1_1 = new TopicPartition(topic1, 1);
        TopicPartition tp1_2 = new TopicPartition(topic1, 2);
        TopicPartition tp2_0 = new TopicPartition(topic2, 0);
        TopicPartition tp2_1 = new TopicPartition(topic2, 1);
        TopicPartition tp2_2 = new TopicPartition(topic2, 2);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp1_2, tp2_0, tp2_1, tp2_2}));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumersInGroup, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)));
        Buffer expectedAssignment = (Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{(scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp2_0, tp2_1})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_2, tp2_2}))}));
        try {
            Option<String> x$4 = this.validateGroupAssignment$default$3();
            long x$5 = this.validateGroupAssignment$default$4();
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, x$4, x$5, (Buffer<scala.collection.immutable.Set<TopicPartition>>)expectedAssignment);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                x$9.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnStopPolling() {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @Test
    public void testMultiConsumerSessionTimeoutOnClose() {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @Test
    public void testInterceptors() {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$10 -> (RecordMetadata)x$10.get());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        Assertions.assertThrows(Throwable.class, () -> testProducer.send(null), () -> "Should not allow sending a null record");
        Assertions.assertEquals((int)1, (int)MockProducerInterceptor.ON_ERROR_COUNT.intValue(), (String)"Interceptor should be notified about exception");
        Assertions.assertEquals((int)0, (int)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue(), (String)"Interceptor should not receive metadata with an exception when record is null");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(i).toString(), (Object)new String((String)record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(i).append(appendStr).toString().toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
        });
        int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 1), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        this.sendAndAwaitAsyncCommit(testConsumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata(5L))}))));
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 2), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        testConsumer.close();
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
    }

    @Test
    public void testAutoCommitIntercept() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        int numRecords = 100;
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString(), (Object)new StringBuilder(6).append("value ").append(BoxesRunTime.unboxToInt((Object)i)).toString())), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$11 -> (RecordMetadata)x$11.get());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, testConsumer){
            private final KafkaConsumer testConsumer$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment((Consumer)testConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)20L, (long)((OffsetAndMetadata)testConsumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @Test
    public void testInterceptorsWithWrongKeyValue() {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)"value will not be modified".getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        KafkaConsumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        testConsumer.seek(this.tp(), 0L);
        ConsumerRecord record = (ConsumerRecord)this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3()).head();
        Assertions.assertEquals((Object)"value will not be modified", (Object)new String((byte[])record.value()));
    }

    @Test
    public void testConsumeMessagesWithCreateTime() {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        TopicPartition x$11 = this.tp2();
        int x$12 = 0;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        long x$14 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$12, x$13, x$14, x$15, x$11, x$16);
    }

    @Test
    public void testConsumeMessagesWithLogAppendTime() {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps, this.createTopic$default$5());
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1, this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)).asJava());
        int x$4 = 0;
        int x$5 = 0;
        TimestampType x$7 = TimestampType.LOG_APPEND_TIME;
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$4, x$5, startTime, x$7, tp1, x$8);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$12 = 0;
        int x$13 = 0;
        TimestampType x$15 = TimestampType.LOG_APPEND_TIME;
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$12, x$13, startTime, x$15, tp2, x$16);
    }

    @Test
    public void testListTopics() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic2, numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4(), this.createTopic$default$5());
        java.util.Map topics = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).listTopics();
        Assertions.assertNotNull((Object)topics);
        Assertions.assertEquals((int)5, (int)topics.size());
        Assertions.assertEquals((int)5, (int)topics.keySet().size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic1)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic2)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic3)).size());
    }

    @Test
    public void testUnsubscribeTopic() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    @Test
    public void testPauseStateNotPreservedByRebalance() {
        this.consumerConfig().setProperty("session.timeout.ms", "100");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        int x$2 = 5;
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$2, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        consumer.pause((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$)).asJava());
        int x$10 = 0;
        int x$11 = 5;
        int x$13 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$14 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$15 = this.consumeAndVerifyRecords$default$7();
        int x$16 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, x$10, x$11, x$13, startingTimestamp, x$14, x$15, x$16);
    }

    @Test
    public void testCommitSpecifiedOffsets() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 7, this.tp2(), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$))).asJava());
        long pos1 = consumer.position(this.tp());
        long pos2 = consumer.position(this.tp2());
        consumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertNull(consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2()));
        Assertions.assertEquals((long)pos1, (long)consumer.position(this.tp()));
        Assertions.assertEquals((long)pos2, (long)consumer.position(this.tp2()));
        consumer.commitSync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)new OffsetAndMetadata(7L))}))));
        Assertions.assertEquals((long)7L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testAutoCommitOnRebalance() {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, consumer){
            private final KafkaConsumer consumer$6;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer$6.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer$6 = consumer$6;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), rebalanceListener);
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        this.awaitAssignment((Consumer<?, ?>)consumer, (scala.collection.immutable.Set<TopicPartition>)newAssignment);
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLead0);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead0.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithSubscribe() {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @Test
    public void testPerPartitionLeadMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLead);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead.metricValue(), (String)new StringBuilder(19).append("The lead should be ").append(records.count()).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsCleanUpWithAssign() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(expectedLag).toString());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp2());
        Assertions.assertNull(consumer.metrics().get(new MetricName(new StringBuilder(12).append(this.tp().toString()).append(".records-lag").toString(), "consumer-fetch-manager-metrics", "", tags)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @Test
    public void testPerPartitionLagMetricsWhenReadCommitted() {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Assertions.assertNotNull((Object)((Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags))));
    }

    @Test
    public void testPerPartitionLeadWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)maxPollRecords, (double)BoxesRunTime.unboxToDouble((Object)lead.metricValue()), (String)new StringBuilder(19).append("The lead should be ").append(maxPollRecords).toString());
    }

    @Test
    public void testPerPartitionLagWithMaxPollRecords() {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords((Consumer)consumer, this.tp());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)(numMessages - records.count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon(), (String)new StringBuilder(18).append("The lag should be ").append(numMessages - records.count()).toString());
    }

    @Test
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured() {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$3 = 0;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, x$3, x$5, startingTimestamp, x$6, x$7, x$8);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$12, "byte-rate", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$13, "throttle-time", (QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$14, "byte-rate", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$15, "throttle-time", (QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$16, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$17, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$18, "request-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$19, "throttle-time", (QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            PlaintextConsumerTest.assertNoExemptRequestMetric$1(broker);
            return BoxedUnit.UNIT;
        });
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        KafkaConsumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)timeoutConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3());
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        timeoutPoller.shutdown();
        consumerPollers.$minus$eq((Object)timeoutPoller);
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, (Option<String>)new Some((Object)new StringBuilder(68).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)subscriptions).asJava()).append(" after one consumer left").toString()), 3L * this.groupMaxSessionTimeoutMs(), this.validateGroupAssignment$default$5());
        consumerPollers.foreach((Function1 & Serializable & scala.Serializable)poller -> {
            poller.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> subscribeConsumers(Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, List<String> topicsToSubscribe) {
        void var3_3;
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        consumerGroup.foreach((Function1 & Serializable & scala.Serializable)consumer -> consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, topicsToSubscribe, this.subscribeConsumerAndStartPolling$default$3())));
        return var3_3;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> createConsumerGroupAndWaitForAssignment(int consumerCount, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        Assertions.assertTrue((consumerCount <= subscriptions.size() ? 1 : 0) != 0);
        Buffer consumerGroup = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), consumerCount).foreach((Function1 & Serializable & scala.Serializable)_ -> consumerGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4())));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<KafkaConsumer<byte[], byte[]>>)consumerGroup, topicsToSubscribe);
        return new Tuple2((Object)consumerGroup, consumerPollers);
    }

    /*
     * WARNING - void declaration
     */
    public void changeConsumerGroupSubscriptionAndValidateAssignment(Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions) {
        consumerPollers.foreach((Function1 & Serializable & scala.Serializable)poller -> {
            poller.subscribe((List<String>)topicsToSubscribe);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!consumerPollers.forall((Function1 & Serializable & scala.Serializable)poller -> BoxesRunTime.boxToBoolean((boolean)poller.isSubscribeRequestProcessed()))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$changeConsumerGroupSubscriptionAndValidateAssignment$4(subscriptions));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.validateGroupAssignment(consumerPollers, subscriptions, (Option<String>)new Some((Object)new StringBuilder(74).append("Did not get valid assignment for partitions ").append(CollectionConverters$.MODULE$.setAsJavaSetConverter(subscriptions).asJava()).append(" after we changed subscription").toString()), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> expectedAssignment, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), rebalanceListener);
        this.awaitAssignment(consumer, expectedAssignment);
    }

    /*
     * WARNING - void declaration
     */
    private <K, V> ConsumerRecords<K, V> awaitNonEmptyRecords(Consumer<K, V> consumer, TopicPartition partition) {
        Object object = new Object();
        try {
            void pollRecordsUntilTrue_action;
            long l = TestUtils$.MODULE$.pollRecordsUntilTrue$default$4();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$1(partition, object, polledRecords));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long pollRecordsUntilTrue_x$3 = 0L;
            long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestUtils$.$anonfun$pollRecordsUntilTrue$1(consumer, (Function1)pollRecordsUntilTrue_action)) {
                void pollRecordsUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + pollRecordsUntilTrue_waitTimeMs) {
                    Assertions.fail((String)PlaintextConsumerTest.$anonfun$awaitNonEmptyRecords$2(partition));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollRecordsUntilTrue_waitTimeMs), pollRecordsUntilTrue_x$3));
            }
            throw new IllegalStateException("Should have timed out before reaching here");
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ConsumerRecords)ex.value();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void awaitAssignment(Consumer<?, ?> consumer, scala.collection.immutable.Set<TopicPartition> expectedAssignment) {
        void pollUntilTrue_action;
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            java.util.Set set = consumer.assignment();
            Object object = CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)expectedAssignment).asJava();
            return !(set != null ? !((Object)set).equals(object) : object != null);
        };
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$awaitAssignment$2(expectedAssignment, consumer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumingWithNullGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testConsumingWithNullGroupId$1(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testConsumingWithNullGroupId$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k3".getBytes(), (Object)"v3".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        KafkaConsumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("client.id", "consumer2");
        .colon.colon x$6 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$7 = this.createConsumer$default$1();
        ByteArrayDeserializer x$8 = this.createConsumer$default$2();
        KafkaConsumer consumer2 = this.createConsumer(x$7, x$8, consumer2Config, (List<String>)x$6);
        Properties consumer3Config = new Properties(this.consumerConfig());
        consumer3Config.put("client.id", "consumer3");
        .colon.colon x$10 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$11 = this.createConsumer$default$1();
        ByteArrayDeserializer x$12 = this.createConsumer$default$2();
        KafkaConsumer consumer3 = this.createConsumer(x$11, x$12, consumer3Config, (List<String>)x$10);
        consumer1.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer2.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer3.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer3.seek(tp, 1L);
        int numRecords1 = consumer1.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer2.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()));
        int numRecords2 = consumer2.poll(Duration.ofMillis(5000L)).count();
        int numRecords3 = consumer3.poll(Duration.ofMillis(5000L)).count();
        consumer1.unsubscribe();
        consumer2.unsubscribe();
        consumer3.unsubscribe();
        consumer1.close();
        consumer2.close();
        consumer3.close();
        Assertions.assertEquals((int)3, (int)numRecords1, (String)"Expected consumer1 to consume from earliest offset");
        Assertions.assertEquals((int)0, (int)numRecords2, (String)"Expected consumer2 to consume from latest offset");
        Assertions.assertEquals((int)2, (int)numRecords3, (String)"Expected consumer3 to consume from offset 1");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumingWithEmptyGroupId() {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testConsumingWithEmptyGroupId$1(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testConsumingWithEmptyGroupId$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("group.id", "");
        consumer1Config.put("client.id", "consumer1");
        consumer1Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer1 = this.createConsumer(x$2, x$3, consumer1Config, x$4);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("group.id", "");
        consumer2Config.put("client.id", "consumer2");
        consumer2Config.put("max.poll.records", "1");
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        KafkaConsumer consumer2 = this.createConsumer(x$6, x$7, consumer2Config, x$8);
        consumer1.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        consumer2.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        ConsumerRecords records1 = consumer1.poll(Duration.ofMillis(5000L));
        consumer1.commitSync();
        ConsumerRecords records2 = consumer2.poll(Duration.ofMillis(5000L));
        consumer2.commitSync();
        consumer1.close();
        consumer2.close();
        Assertions.assertTrue((records1.count() == 1 && ((ConsumerRecord)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(records1.records(tp)).asScala()).head()).offset() == 0L ? 1 : 0) != 0, (String)"Expected consumer1 to consume one message from offset 0");
        Assertions.assertTrue((records2.count() == 1 && ((ConsumerRecord)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(records2.records(tp)).asScala()).head()).offset() == 1L ? 1 : 0) != 0, (String)"Expected consumer2 to consume one message from offset 1, which is the committed offset of consumer1");
    }

    @Test
    public void testStaticConsumerDetectsNewPartitionCreatedAfterRestart() {
        String foo = "foo";
        TopicPartition foo0 = new TopicPartition(foo, 0);
        TopicPartition foo1 = new TopicPartition(foo, 1);
        ConfluentAdmin admin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        admin.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new NewTopic(foo, 1, (short)1), (List)Nil$.MODULE$)).asJava()).all().get();
        Properties consumerConfig = new Properties();
        consumerConfig.put("group.id", "my-group-id");
        consumerConfig.put("group.instance.id", "my-instance-id");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer1 = this.createConsumer(x$2, x$3, consumerConfig, x$4);
        consumer1.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)foo, (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer1, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        consumer1.close();
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        KafkaConsumer consumer2 = this.createConsumer(x$6, x$7, consumerConfig, x$8);
        consumer2.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)foo, (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment((Consumer<?, ?>)consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        admin.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).all().get();
        this.awaitAssignment((Consumer<?, ?>)consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1}))));
        consumer2.close();
    }

    public static final /* synthetic */ String $anonfun$testAsyncCommit$3() {
        return "Failed to observe commit callback before timeout";
    }

    public static final /* synthetic */ TopicPartition $anonfun$testLowMaxFetchSizeForRequestAndPartition$3(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }

    private static final scala.collection.immutable.Map reverse$1(scala.collection.immutable.Map m) {
        return ((TraversableOnce)((SetLike)m.values().toSet().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, ((IterableLike)m.keys().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$5 -> ((SetLike)m.apply((Object)BoxesRunTime.boxToLong((long)x$5))).contains(v))).head()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$testMultiConsumerStickyAssignor$5(scala.collection.immutable.Map prePartition2PollerId$1, scala.collection.immutable.Map postPartition2PollerId$1, IntRef changes$1, TopicPartition key) {
        Option preVal = prePartition2PollerId$1.get((Object)key);
        Option postVal = postPartition2PollerId$1.get((Object)key);
        if (preVal.nonEmpty() && postVal.nonEmpty()) {
            if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                ++changes$1.elem;
                return;
            }
        } else {
            ++changes$1.elem;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testRebalanceAndRejoin$1(AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller1$1, scala.collection.immutable.Set expectedAssignment$1) {
        scala.collection.immutable.Set<TopicPartition> set = consumerPoller1$1.consumerAssignment();
        return !(set != null ? !set.equals((Object)expectedAssignment$1) : expectedAssignment$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testRebalanceAndRejoin$2(scala.collection.immutable.Set expectedAssignment$1) {
        return new StringBuilder(56).append("Timed out while awaiting expected assignment change to ").append(expectedAssignment$1).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRebalanceAndRejoin$3(AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller1$1) {
        return consumerPoller1$1.consumerAssignment().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testRebalanceAndRejoin$4() {
        return "Timed out while awaiting expected assignment size change to 1.";
    }

    public static final /* synthetic */ boolean $anonfun$testRebalanceAndRejoin$5(AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller2$1) {
        return consumerPoller2$1.consumerAssignment().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testRebalanceAndRejoin$6() {
        return "Timed out while awaiting expected assignment size change to 1.";
    }

    private static final void assertNoMetric$1(KafkaServer broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)new StringBuilder(36).append("Metric should not have been created ").append(metricName).toString());
    }

    private static final void assertNoExemptRequestMetric$1(KafkaServer broker) {
        MetricName metricName = broker.metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)new StringBuilder(36).append("Metric should not have been created ").append(metricName).toString());
    }

    public static final /* synthetic */ String $anonfun$changeConsumerGroupSubscriptionAndValidateAssignment$4(scala.collection.immutable.Set subscriptions$1) {
        return new StringBuilder(72).append("Failed to call subscribe on all consumers in the group for subscription ").append(subscriptions$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$awaitNonEmptyRecords$1(TopicPartition partition$1, Object nonLocalReturnKey1$1, ConsumerRecords polledRecords) {
        if (((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(polledRecords.records(partition$1)).asScala()).nonEmpty()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)polledRecords);
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$awaitNonEmptyRecords$2(TopicPartition partition$1) {
        return new StringBuilder(68).append("Consumer did not consume any messages for partition ").append(partition$1).append(" before timeout.").toString();
    }

    public static final /* synthetic */ String $anonfun$awaitAssignment$2(scala.collection.immutable.Set expectedAssignment$2, Consumer consumer$7) {
        return new StringBuilder(73).append("Timed out while awaiting expected assignment ").append(expectedAssignment$2).append(". ").append("The current assignment is ").append(consumer$7.assignment()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumingWithNullGroupId$1(PlaintextConsumerTest $this, String topic$2) {
        return $this.zkClient().topicExists(topic$2);
    }

    public static final /* synthetic */ String $anonfun$testConsumingWithNullGroupId$2() {
        return "Failed to create topic";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumingWithEmptyGroupId$1(PlaintextConsumerTest $this, String topic$3) {
        return $this.zkClient().topicExists(topic$3);
    }

    public static final /* synthetic */ String $anonfun$testConsumingWithEmptyGroupId$2() {
        return "Failed to create topic";
    }

    public interface DeserializerImpl
    extends Deserializer<byte[]> {
        public ByteArrayDeserializer deserializer();

        public void deserializer_$eq(ByteArrayDeserializer var1);

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.deserialize(topic, headers, data);
        }

        default public byte[] deserialize(String topic, Headers headers, byte[] data) {
            Header header = headers.lastHeader("content-type");
            Assertions.assertEquals((Object)"application/octet-stream", (Object)(header == null ? null : new String(header.value())));
            return this.deserializer().deserialize(topic, data);
        }

        public static /* synthetic */ void configure$(DeserializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.deserializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(DeserializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.deserializer().close();
        }

        public static /* synthetic */ byte[] deserialize$(DeserializerImpl $this, String topic, byte[] data) {
            return $this.deserialize(topic, data);
        }

        default public byte[] deserialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$DeserializerImpl$$$outer();

        public static void $init$(DeserializerImpl $this) {
            $this.deserializer_$eq(new ByteArrayDeserializer());
        }
    }

    public interface SerializerImpl
    extends Serializer<byte[]> {
        public ByteArraySerializer serializer();

        public void serializer_$eq(ByteArraySerializer var1);

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, Headers headers, byte[] data) {
            return $this.serialize(topic, headers, data);
        }

        default public byte[] serialize(String topic, Headers headers, byte[] data) {
            headers.add("content-type", "application/octet-stream".getBytes());
            return this.serializer().serialize(topic, data);
        }

        public static /* synthetic */ void configure$(SerializerImpl $this, java.util.Map configs, boolean isKey) {
            $this.configure(configs, isKey);
        }

        default public void configure(java.util.Map<String, ?> configs, boolean isKey) {
            this.serializer().configure(configs, isKey);
        }

        public static /* synthetic */ void close$(SerializerImpl $this) {
            $this.close();
        }

        default public void close() {
            this.serializer().close();
        }

        public static /* synthetic */ byte[] serialize$(SerializerImpl $this, String topic, byte[] data) {
            return $this.serialize(topic, data);
        }

        default public byte[] serialize(String topic, byte[] data) {
            Assertions.fail((String)"method should not be invoked");
            return null;
        }

        public /* synthetic */ PlaintextConsumerTest kafka$api$PlaintextConsumerTest$SerializerImpl$$$outer();

        public static void $init$(SerializerImpl $this) {
            $this.serializer_$eq(new ByteArraySerializer());
        }
    }
}

