/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.BaseAdminIntegrationTest;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.authorizer.AclEntry$;
import kafka.server.Defaults$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.EligibleLeadersNotAvailableException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\rMe\u0001B+W\u0001mCQ\u0001\u0019\u0001\u0005\u0002\u0005DQa\u0019\u0001\u0005\u0002\u0011DQa\u001b\u0001\u0005B1Dq\u0001\u001d\u0001C\u0002\u0013\u0005\u0011\u000f\u0003\u0004{\u0001\u0001\u0006IA\u001d\u0005\bw\u0002\u0011\r\u0011\"\u0001m\u0011\u0019a\b\u0001)A\u0005[\"9Q\u0010\u0001b\u0001\n\u0003q\bbBA\u000b\u0001\u0001\u0006Ia \u0005\t\u0003/\u0001!\u0019!C\u0001c\"9\u0011\u0011\u0004\u0001!\u0002\u0013\u0011\bbCA\u000e\u0001\u0001\u0007\t\u0019!C\u0005\u0003;A1\"a\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002.!Y\u0011\u0011\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0010\u0011%\tY\u0004\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA \u0011\u001d\t)\u0007\u0001C!\u0003OBq!a\"\u0001\t\u0003\nI\tC\u0004\u0002\u0014\u0002!\t!!#\t\u000f\u0005u\u0005\u0001\"\u0001\u0002\n\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005%\u0005bBAS\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003S\u0003A\u0011AAE\u0011\u001d\ti\u000b\u0001C\u0001\u0003\u0013Cq!!-\u0001\t\u0003\tI\tC\u0004\u00026\u0002!\t!!#\t\u000f\u0005e\u0006\u0001\"\u0001\u0002\n\"9\u0011Q\u0018\u0001\u0005\u0002\u0005%\u0005bBAa\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u000b\u0004A\u0011AAE\u0011\u001d\tI\r\u0001C\u0001\u0003\u0013Cq!!4\u0001\t\u0003\ty\rC\u0004\u0003\u0004\u0001!\t!!#\t\u000f\t\u001d\u0001\u0001\"\u0001\u0002\n\"9!1\u0002\u0001\u0005\u0002\u0005%\u0005b\u0002B\b\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0005'\u0001A\u0011AAE\u0011\u001d\u00119\u0002\u0001C\u0001\u0003\u0013CqAa\u0007\u0001\t\u0003\tI\tC\u0004\u0003 \u0001!\t!!#\t\u000f\t\r\u0002\u0001\"\u0001\u0002\n\"9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B&\u0001\u0011%!Q\n\u0005\b\u0005G\u0002A\u0011AAE\u0011\u001d\u00119\u0007\u0001C\u0001\u0003\u0013CqAa\u001b\u0001\t\u0003\tI\tC\u0004\u0003p\u0001!\t!!#\t\u000f\tM\u0004\u0001\"\u0001\u0002\n\"9!q\u000f\u0001\u0005\u0002\u0005%\u0005b\u0002B>\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0005\u007f\u0002A\u0011AAE\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0003\u0013CqAa\"\u0001\t\u0003\tI\tC\u0004\u0003\f\u0002!\t!!#\t\u000f\t=\u0005\u0001\"\u0001\u0002\n\"9!1\u0013\u0001\u0005\u0002\u0005%\u0005b\u0002BL\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u00057\u0003A\u0011AAE\u0011\u001d\u0011y\n\u0001C\u0001\u0003\u0013CqAa)\u0001\t\u0003\tI\tC\u0004\u0003(\u0002!\t!!#\t\u000f\t-\u0006\u0001\"\u0001\u0002\n\"9!q\u0016\u0001\u0005\u0002\u0005%\u0005b\u0002BZ\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0005o\u0003A\u0011AAE\u0011\u001d\u0011Y\f\u0001C\u0001\u0003\u0013CqAa0\u0001\t\u0003\tI\tC\u0004\u0003D\u0002!\t!!#\t\u000f\t\u001d\u0007\u0001\"\u0001\u0002\n\"9!1\u001a\u0001\u0005\u0002\u0005%\u0005b\u0002Bl\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0005;\u0004A\u0011AAE\u0011\u001d\u0011\u0019\u000f\u0001C\u0001\u0003\u0013CqA!;\u0001\t\u0003\tI\tC\u0004\u0003p\u0002!\tA!=\t\u0013\rM\u0001!%A\u0005\u0002\rU\u0001bBB\u0016\u0001\u0011\u00051Q\u0006\u0005\b\u0007k\u0001A\u0011BAE\u0011\u001d\u00199\u0004\u0001C\u0001\u0007s9qaa\u0011W\u0011\u0003\u0019)E\u0002\u0004V-\"\u00051q\t\u0005\u0007AF#\taa\u0014\t\u000f\rE\u0013\u000b\"\u0001\u0004T!91qM)\u0005\u0002\r%$!\b)mC&tG/\u001a=u\u0003\u0012l\u0017N\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005]C\u0016aA1qS*\t\u0011,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0006CA/_\u001b\u00051\u0016BA0W\u0005a\u0011\u0015m]3BI6Lg.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0004\"!\u0018\u0001\u0002\u0017QLWM\u001d$fCR,(/Z\u000b\u0002KB\u0011a-[\u0007\u0002O*\t\u0001.A\u0003tG\u0006d\u0017-\u0003\u0002kO\n9!i\\8mK\u0006t\u0017a\u00037pO\u0012K'oQ8v]R,\u0012!\u001c\t\u0003M:L!a\\4\u0003\u0007%sG/A\u0003u_BL7-F\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0003mC:<'\"A<\u0002\t)\fg/Y\u0005\u0003sR\u0014aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0005qCJ$\u0018\u000e^5p]\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\tq\u0010\u0005\u0003\u0002\u0002\u0005EQBAA\u0002\u0015\u0011\t)!a\u0002\u0002\r\r|W.\\8o\u0015\rI\u0016\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001f\t1a\u001c:h\u0013\u0011\t\u0019\"a\u0001\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u000euQJ|G\u000f\u001e7fIJ\u000bG/Z*uCRL7\rR3gCVdG/A\u000euQJ|G\u000f\u001e7fIJ\u000bG/Z*uCRL7\rR3gCVdG\u000fI\u0001\u001bEJ|7.\u001a:M_\u001e<WM]\"p]\u001aLwMU3t_V\u00148-Z\u000b\u0003\u0003?\u0001B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0005\u0003K\t\u0019!\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003S\t\u0019C\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u0002=\t\u0014xn[3s\u0019><w-\u001a:D_:4\u0017n\u001a*fg>,(oY3`I\u0015\fH\u0003BA\u0018\u0003k\u00012AZA\u0019\u0013\r\t\u0019d\u001a\u0002\u0005+:LG\u000fC\u0005\u000285\t\t\u00111\u0001\u0002 \u0005\u0019\u0001\u0010J\u0019\u00027\t\u0014xn[3s\u0019><w-\u001a:D_:4\u0017n\u001a*fg>,(oY3!\u0003Q\u0019\u0007.\u00198hK\u0012\u0014%o\\6fe2{wmZ3sgV\u0011\u0011q\b\t\u0007\u0003\u0003\nY%a\u0014\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nq!\\;uC\ndWMC\u0002\u0002J\u001d\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti%a\u0011\u0003\u0007M+G\u000f\u0005\u0003\u0002R\u0005}c\u0002BA*\u00037\u00022!!\u0016h\u001b\t\t9FC\u0002\u0002Zi\u000ba\u0001\u0010:p_Rt\u0014bAA/O\u00061\u0001K]3eK\u001aL1!_A1\u0015\r\tifZ\u0001\u0016G\"\fgnZ3e\u0005J|7.\u001a:M_\u001e<WM]:!\u0003\u0015\u0019X\r^+q)\u0011\ty#!\u001b\t\u000f\u0005-\u0014\u00031\u0001\u0002n\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002p\u0005mTBAA9\u0015\r9\u00161\u000f\u0006\u0005\u0003k\n9(A\u0004kkBLG/\u001a:\u000b\t\u0005e\u0014QB\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003{\n\tH\u0001\u0005UKN$\u0018J\u001c4pQ\r\t\u0012\u0011\u0011\t\u0005\u0003_\n\u0019)\u0003\u0003\u0002\u0006\u0006E$A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u0006\u0002\u00020!\u001a!#!$\u0011\t\u0005=\u0014qR\u0005\u0005\u0003#\u000b\tHA\u0005BMR,'/R1dQ\u0006IA/Z:u\u00072|7/\u001a\u0015\u0004'\u0005]\u0005\u0003BA8\u00033KA!a'\u0002r\t!A+Z:u\u00035!Xm\u001d;MSN$hj\u001c3fg\"\u001aA#a&\u0002UQ,7\u000f^!e[&t7\t\\5f]RD\u0015M\u001c3mS:<')\u00193J!^KG\u000f[8viRKW.Z8vi\"\u001aQ#a&\u0002cQ,7\u000f^\"sK\u0006$X-\u0012=jgRLgn\u001a+pa&\u001c7\u000f\u00165s_^$v\u000e]5d\u000bbL7\u000f^:Fq\u000e,\u0007\u000f^5p]\"\u001aa#a&\u0002/Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e\u001cx+\u001b;i\u0013\u0012\u001c\bfA\f\u0002\u0018\u0006\u0019B/Z:u\u001b\u0016$\u0018\rZ1uCJ+gM]3tQ\"\u001a\u0001$a&\u00029Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3O_:,\u00050[:uS:<Gk\u001c9jG\"\u001a\u0011$a&\u00023Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3U_BL7m],ji\"LEm\u001d\u0015\u00045\u0005]\u0015a\u0005;fgR$Um]2sS\n,7\t\\;ti\u0016\u0014\bfA\u000e\u0002\u0018\u0006\u0019B/Z:u\t\u0016\u001c8M]5cK2{w\rR5sg\"\u001aA$a&\u00025Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3SKBd\u0017nY1M_\u001e$\u0015N]:)\u0007u\t9*A\fuKN$\u0018\t\u001c;feJ+\u0007\u000f\\5dC2{w\rR5sg\"\u001aa$a&\u00027Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3B]\u0012\fE\u000e^3s\u0007>tg-[4tQ\ry\u0012qS\u0001\u0015i\u0016\u001cHo\u0011:fCR,\u0007+\u0019:uSRLwN\\:\u0015\t\u0005=\u0012\u0011\u001b\u0005\b\u0003'\u0004\u0003\u0019AA(\u0003\u0019\tXo\u001c:v[\":\u0001%a6\u0002h\u0006%\b\u0003BAm\u0003Gl!!a7\u000b\t\u0005u\u0017q\\\u0001\taJ|g/\u001b3fe*!\u0011\u0011]A:\u0003\u0019\u0001\u0018M]1ng&!\u0011Q]An\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u00111^AxC\t\ti/\u0001\u0002{W\u0006\u0012\u0011\u0011_\u0001\u0006WJ\fg\r\u001e\u0015\bA\u0005U\u0018Q`A\u0000!\u0011\t90!?\u000e\u0005\u0005}\u0017\u0002BA~\u0003?\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\t\u0005\u0011\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u0006QB/Z:u'\u0016,7.\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u001a\u0011%a&\u00029Q,7\u000f\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oi\"\u001a!%a&\u0002IQ,7\u000f\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND3aIAL\u0003]\"Xm\u001d;SKBd\u0017nY1DC:4U\r^2i\rJ|W\u000eT8h'R\f'\u000f^(gMN,G/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u001aA%a&\u0002EQ,7\u000f^!mi\u0016\u0014Hj\\4ESJ\u001c\u0018I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3tQ\r)\u0013qS\u0001&i\u0016\u001cHo\u00144gg\u0016$8OR8s)&lWm]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND3AJAL\u0003u!Xm\u001d;D_:\u001cX/\\3BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\bfA\u0014\u0002\u0018\u0006qB/Z:u\t\u0016dW\r^3SK\u000e|'\u000fZ:XSRDW\t_2faRLwN\u001c\u0015\u0004Q\u0005]\u0015a\u0007;fgR$Um]2sS\n,7i\u001c8gS\u001e\u001chi\u001c:U_BL7\rK\u0002*\u0003/\u000bQd];cg\u000e\u0014\u0018NY3B]\u0012<\u0016-\u001b;G_J\f5o]5h]6,g\u000e\u001e\u000b\u0007\u0003_\u0011YC!\f\t\rAT\u0003\u0019AA(\u0011\u001d\u0011yC\u000ba\u0001\u0005c\t\u0001bY8ogVlWM\u001d\t\t\u0005g\u0011YDa\u0010\u0003@5\u0011!Q\u0007\u0006\u0005\u0005_\u00119D\u0003\u0003\u0003:\u0005\u001d\u0011aB2mS\u0016tGo]\u0005\u0005\u0005{\u0011)DA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0006M\n\u0005#QI\u0005\u0004\u0005\u0007:'!B!se\u0006L\bc\u00014\u0003H%\u0019!\u0011J4\u0003\t\tKH/Z\u0001\fg\u0016tGMU3d_J$7\u000f\u0006\u0005\u00020\t=#Q\fB1\u0011\u001d\u0011\tf\u000ba\u0001\u0005'\n\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0005+\u0012IFa\u0010\u0003@5\u0011!q\u000b\u0006\u0005\u0005#\u00129$\u0003\u0003\u0003\\\t]#!D&bM.\f\u0007K]8ek\u000e,'\u000f\u0003\u0004\u0003`-\u0002\r!\\\u0001\u000b]Vl'+Z2pe\u0012\u001c\b\"B?,\u0001\u0004y\u0018a\u0006;fgRLeN^1mS\u0012\fE\u000e^3s\u0007>tg-[4tQ\ra\u0013qS\u0001\u0012i\u0016\u001cH/Q2m\u001fB,'/\u0019;j_:\u001c\bfA\u0017\u0002\u0018\u0006\u0001B/Z:u\t\u0016d\u0017-_3e\u00072|7/\u001a\u0015\u0004]\u0005]\u0015A\u0004;fgR4uN]2f\u00072|7/\u001a\u0015\u0004_\u0005]\u0015A\u0007;fgRl\u0015N\\5nk6\u0014V-];fgR$\u0016.\\3pkR\u001c\bf\u0001\u0019\u0002\u0018\u0006AB/Z:u\u0007\u0006dG.\u00138GY&<\u0007\u000e\u001e+j[\u0016|W\u000f^:)\u0007E\n9*\u0001\nuKN$8i\u001c8tk6,'o\u0012:pkB\u001c\bf\u0001\u001a\u0002\u0018\u0006qB/Z:u\t\u0016dW\r^3D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u001d\u0015\u0004g\u0005]\u0015!\u0007;fgR,E.Z2u!J,g-\u001a:sK\u0012dU-\u00193feND3\u0001NAL\u0003\u0019\"Xm\u001d;FY\u0016\u001cG/\u00168dY\u0016\fg\u000eT3bI\u0016\u00148OR8s\u001f:,\u0007+\u0019:uSRLwN\u001c\u0015\u0004k\u0005]\u0015\u0001\u000b;fgR,E.Z2u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:t\r>\u0014X*\u00198z!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u001c\u0002\u0018\u00069C/Z:u\u000b2,7\r^+oG2,\u0017M\u001c'fC\u0012,'o\u001d$pe\u0006cG\u000eU1si&$\u0018n\u001c8tQ\r9\u0014qS\u0001,i\u0016\u001cH/\u00127fGR,fn\u00197fC:dU-\u00193feN4uN]+oW:|wO\u001c)beRLG/[8og\"\u001a\u0001(a&\u0002QQ,7\u000f^#mK\u000e$XK\\2mK\u0006tG*Z1eKJ\u001cx\u000b[3o\u001d>d\u0015N^3Ce>\\WM]:)\u0007e\n9*A\u000euKN$X\t\\3diVs7\r\\3b]2+\u0017\rZ3sg:{w\u000e\u001d\u0015\u0004u\u0005]\u0015A\b;fgR,E.Z2u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:t\u0003:$gj\\8qQ\rY\u0014qS\u00019i\u0016\u001cH\u000fT5tiJ+\u0017m]:jO:lWM\u001c;t\t>,7OT8u'\"|wOT8o%\u0016\f7o]5h]&tw\rU1si&$\u0018n\u001c8tQ\ra\u0014qS\u00012i\u0016\u001cH\u000fT5tiJ+\u0017m]:jO:lWM\u001c;t\t>,7OT8u'\"|w\u000fR3mKR,G\rU1si&$\u0018n\u001c8tQ\ri\u0014qS\u0001!i\u0016\u001cHOV1mS\u0012Len\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000fK\u0002?\u0003/\u000bA\u0007^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001cH)\u001a7fi\u0016\fe\u000eZ*fi\n\u0013xn[3s\u0007>tg-[4tQ\ry\u0014qS\u0001/i\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:EK2,G/\u001a\"s_.,'oQ8oM&<7\u000fK\u0002A\u0003/\u000b!\u0005^3ti&sg/\u00197jI&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c\bfA!\u0002\u0018\u00061C/Z:u\u0013:4\u0018\r\\5e\u00032$XM\u001d)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^:)\u0007\t\u000b9*\u0001\nuKN$Hj\u001c8h)>\u0004\u0018n\u0019(b[\u0016\u001c\bfA\"\u0002\u0018\u0006yA/Z:u\u001dVdGnQ8oM&<7\u000fK\u0002E\u0003/\u000bA\u0005^3ti\u0012+7o\u0019:jE\u0016\u001cuN\u001c4jON4uN\u001d'pORRGj\\4MKZ,Gn\u001d\u0015\u0004\u000b\u0006]\u0015\u0001\f;fgRLen\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7OR8s\u0019><GG\u001b'pO2+g/\u001a7tQ\r1%q\u001a\t\u0005\u0003_\u0012\t.\u0003\u0003\u0003T\u0006E$\u0001\u0003#jg\u0006\u0014G.\u001a3)\u0007\u0019\u000b9*A$uKN$\u0018J\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d$pe2{w\r\u000e6M_\u001edUM^3mg\u000e\u000bgNU3tKRdunZ4feR{7)\u001e:sK:$(k\\8uQ\r9%q\u001a\u0015\u0004\u000f\u0006]\u0015!\u0011;fgRLen\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7OR8s\u0019><GG\u001b'pO2+g/\u001a7t\u0007\u0006tgn\u001c;SKN,GOU8pi2{wmZ3sQ\rA%q\u001a\u0015\u0004\u0011\u0006]\u0015!\u0013;fgRLen\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7OR8s\u0019><GG\u001b'pO2+g/\u001a7t\t>,7OT8u/>\u00148nV5uQ&sg/\u00197jI\u000e{gNZ5hg\"\u001a\u0011Ja4)\u0007%\u000b9*\u0001\u0017uKN$\u0018\t\u001c;fe\u000e{gNZ5hg\u001a{'\u000fT8hi)dun\u001a'fm\u0016d7\u000fR8fg:{GoV8sW\"\u001a!Ja4)\u0007)\u000b9*\u0001\nbYR,'O\u0011:pW\u0016\u0014Hj\\4hKJ\u001cHCBA\u0018\u0005g\u001cy\u0001C\u0004\u0003v.\u0003\rAa>\u0002\u000f\u0015tGO]5fgB1!\u0011 B\u0000\u0007\u0007i!Aa?\u000b\u0007\tuh/\u0001\u0003vi&d\u0017\u0002BB\u0001\u0005w\u0014!bQ8mY\u0016\u001cG/[8o!\u0011\u0019)aa\u0003\u000e\u0005\r\u001d!\u0002BB\u0005\u0005o\tQ!\u00193nS:LAa!\u0004\u0004\b\ti\u0011\t\u001c;fe\u000e{gNZ5h\u001fBD\u0001b!\u0005L!\u0003\u0005\r!Z\u0001\rm\u0006d\u0017\u000eZ1uK>sG._\u0001\u001dC2$XM\u001d\"s_.,'\u000fT8hO\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u00199BK\u0002f\u00073Y#aa\u0007\u0011\t\ru1qE\u0007\u0003\u0007?QAa!\t\u0004$\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007K9\u0017AC1o]>$\u0018\r^5p]&!1\u0011FB\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016I\u0016\u001c8M]5cK\n\u0013xn[3s\u0019><w-\u001a:t)\t\u0019y\u0003\u0005\u0003\u0004\u0006\rE\u0012\u0002BB\u001a\u0007\u000f\u0011aaQ8oM&<\u0017!\u0006;fCJ$wn\u001e8Ce>\\WM\u001d'pO\u001e,'o]\u0001\u001fi\u0016\u001cHo\u0011:fCR,Gk\u001c9jGN\u0014V\r^;s]N\u001cuN\u001c4jON$B!a\f\u0004<!9\u00111[(A\u0002\u0005=\u0003fB(\u0002X\u0006\u001d8q\b\u0017\u0005\u0003W\fy\u000fK\u0002P\u0003k\fQ\u0004\u00157bS:$X\r\u001f;BI6Lg.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003;F\u001b2!UB%!\r171J\u0005\u0004\u0007\u001b:'AB!osJ+g\r\u0006\u0002\u0004F\u000512\r[3dWZ\u000bG.\u001b3BYR,'oQ8oM&<7\u000f\u0006\u0005\u00020\rU3qLB2\u0011\u001d\u00199f\u0015a\u0001\u00073\naa\u00197jK:$\b\u0003BB\u0003\u00077JAa!\u0018\u0004\b\t)\u0011\tZ7j]\"91\u0011M*A\u0002\u0005}\u0011A\u0004;pa&\u001c'+Z:pkJ\u001cW-\r\u0005\b\u0007K\u001a\u0006\u0019AA\u0010\u00039!x\u000e]5d%\u0016\u001cx.\u001e:dKJ\n\u0001d\u00195fG.LeN^1mS\u0012\fE\u000e^3s\u0007>tg-[4t)!\tyca\u001b\u0004z\rE\u0005bBB7)\u0002\u00071qN\u0001\tu.\u001cE.[3oiB!1\u0011OB;\u001b\t\u0019\u0019HC\u0002\u0002nbKAaa\u001e\u0004t\ti1*\u00194lCj[7\t\\5f]RDqaa\u001fU\u0001\u0004\u0019i(A\u0004tKJ4XM]:\u0011\r\r}4\u0011QBC\u001b\t\t9%\u0003\u0003\u0004\u0004\u0006\u001d#aA*fcB!1qQBG\u001b\t\u0019IIC\u0002\u0004\fb\u000baa]3sm\u0016\u0014\u0018\u0002BBH\u0007\u0013\u00131bS1gW\u0006\u001cVM\u001d<fe\"91q\u000b+A\u0002\re\u0003")
public class PlaintextAdminIntegrationTest
extends BaseAdminIntegrationTest {
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private final String throttledRateStaticDefault = Long.toString(Long.MAX_VALUE);
    private ConfigResource brokerLoggerConfigResource;
    private final Set<String> changedBrokerLoggers = (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, Seq<KafkaServer> seq, Admin admin) {
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, admin);
    }

    public static void checkValidAlterConfigs(Admin admin, ConfigResource configResource, ConfigResource configResource2) {
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(admin, configResource, configResource2);
    }

    public boolean tierFeature() {
        return false;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public String throttledRateStaticDefault() {
        return this.throttledRateStaticDefault;
    }

    private ConfigResource brokerLoggerConfigResource() {
        return this.brokerLoggerConfigResource;
    }

    private void brokerLoggerConfigResource_$eq(ConfigResource x$1) {
        this.brokerLoggerConfigResource = x$1;
    }

    private Set<String> changedBrokerLoggers() {
        return this.changedBrokerLoggers;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.brokerLoggerConfigResource_$eq(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.teardownBrokerLoggers();
        super.tearDown();
    }

    @Test
    public void testClose() {
        Admin client = Admin.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        List nodeStrs;
        this.client_$eq(Admin.create(this.createConfig()));
        List brokerStrs = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bootstrapServers(this.bootstrapServers$default$1()).split(","))).toList().sorted((Ordering)Ordering.String$.MODULE$);
        while ((nodeStrs = (List)((TraversableOnce)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assertions.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testAdminClientHandlingBadIPWithoutTimeout() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("socket.connection.setup.timeout.ms", "1000");
        HostResolver returnBadAddressFirst = new HostResolver(null){

            public InetAddress[] resolve(String host) {
                return (InetAddress[])((Object[])new InetAddress[]{InetAddress.getByName("10.200.20.100"), InetAddress.getByName(host)});
            }
        };
        this.client_$eq(AdminClientTestUtils.create(config, (HostResolver)returnBadAddressFirst));
        this.client().describeCluster().nodes().get();
    }

    @Test
    public void testCreateExistingTopicsThrowTopicExistsException() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "mytopic";
        .colon.colon topics = new .colon.colon((Object)topic, (List)Nil$.MODULE$);
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic(topic, 1, (short)1), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        .colon.colon newTopicsWithInvalidRF = new .colon.colon((Object)new NewTopic(topic, 1, (short)(this.servers().size() + 1)), (List)Nil$.MODULE$);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> PlaintextAdminIntegrationTest.$anonfun$testCreateExistingTopicsThrowTopicExistsException$1(this, (Seq)newTopicsWithInvalidRF))).getCause() instanceof TopicExistsException));
    }

    @Test
    public void testDeleteTopicsWithIds() {
        this.client_$eq(Admin.create(this.createConfig()));
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)new .colon.colon((Object)"mytopic3", (List)Nil$.MODULE$)));
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)Nil$.MODULE$))).asJava())}))).asJava()), (List)new .colon.colon((Object)new NewTopic("mytopic2", 3, (short)3), (List)new .colon.colon((Object)new NewTopic("mytopic3", OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty()))), (List)Nil$.MODULE$)));
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        scala.collection.immutable.Set topicIds = this.getTopicIds().values().toSet();
        this.client().deleteTopics((TopicCollection)TopicCollection.ofTopicIds((Collection)((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)topicIds).asJava()))).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq(Admin.create(this.createConfig()));
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)Nil$.MODULE$);
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", 3, (short)3), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testMetadataRefresh$1(this, x$1))).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava()).allTopicNames().get();
        Assertions.assertEquals((Object)topics.toSet(), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(topicDesc.keySet()).asScala());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(Admin.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$2 -> new NewTopic(x$2, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)nonExistingTopic, (List)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$))).asJava()).topicNameValues();
        Assertions.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)results.get(nonExistingTopic)).get()).getCause() instanceof UnknownTopicOrPartitionException;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeTopicsWithIds() {
        this.client_$eq(Admin.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$3 -> new NewTopic(x$3, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)existingTopic, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        Uuid existingTopicId = (Uuid)this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).values().head();
        Uuid nonExistingTopicId = Uuid.randomUuid();
        java.util.Map results = this.client().describeTopics((TopicCollection)TopicCollection.ofTopicIds((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)existingTopicId, (List)new .colon.colon((Object)nonExistingTopicId, (List)Nil$.MODULE$))).asJava()))).topicIdValues();
        Assertions.assertEquals((Object)existingTopicId, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopicId)).get()).topicId());
        boolean cfr_ignored_0 = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)results.get(nonExistingTopicId)).get()).getCause() instanceof UnknownTopicIdException;
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(Admin.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Collection nodes = (Collection)result.nodes().get();
        String clusterId = (String)result.clusterId().get();
        Assertions.assertEquals((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().clusterId(), (Object)clusterId);
        Node controller = (Node)result.controller().get();
        Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().metadataCache().getControllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), (int)controller.id());
        String[] brokers = this.bootstrapServers(this.bootstrapServers$default$1()).split(",");
        Assertions.assertEquals((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (int)nodes.size());
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
            PlaintextAdminIntegrationTest.$anonfun$testDescribeCluster$2(brokers, node);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map partitionsByBroker = (scala.collection.immutable.Map)this.createTopic(topic, 10, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5()).groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$1(x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int k = x0$2._1$mcI$sp();
            scala.collection.immutable.Map v = (scala.collection.immutable.Map)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.keys().toSeq());
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).allDescriptions().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$5(brokerId, x$4))).get();
            Seq expectedPartitions = (Seq)partitionsByBroker.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
            java.util.Map logDirInfos = (java.util.Map)logDirInfosByBroker.get(BoxesRunTime.boxToInteger((int)brokerId));
            scala.collection.mutable.Map replicaInfos = (scala.collection.mutable.Map)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                LogDirDescription logDirInfo = (LogDirDescription)x0$3._2();
                scala.collection.mutable.Map map = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos()).asScala();
                return map;
            }, Map$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$7(topic, x0$4)));
            Assertions.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.partition()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
            logDirInfos.forEach((logDir, logDirInfo) -> ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos()).asScala()).keys().foreach((Function1 & Serializable & scala.Serializable)tp -> {
                PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$10(server, logDir, tp);
                return BoxedUnit.UNIT;
            }));
        });
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        Seq replicas = ((TraversableOnce)this.createTopic(topic, 10, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            int brokerId = x0$1._2$mcI$sp();
            TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(topic, partition, brokerId);
            return topicPartitionReplica;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        ((java.util.Map)this.client().describeReplicaLogDirs(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get()).forEach((topicPartitionReplica, replicaDirInfo) -> {
            KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeReplicaLogDirs$3(topicPartitionReplica, x$6))).get();
            TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
            LogManager qual$1 = server.logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Assertions.assertEquals((Object)((AbstractLog)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(server), (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2))), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map firstReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map secondReplicaAssignment = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, 0, server.config().brokerId())), (Object)logDir);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)future -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$4(future);
            return BoxedUnit.UNIT;
        });
        int x$2 = this.brokerCount();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(topic, x$3, x$2, x$4, x$5);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$6(tp, firstReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        this.client().alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$7(tp, secondReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        scala.concurrent.Future producerFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            int n;
            String x$10 = this.bootstrapServers(this.bootstrapServers$default$1());
            SecurityProtocol x$11 = this.securityProtocol();
            Option<File> x$12 = this.trustStoreFile();
            int x$13 = 0;
            int x$14 = 10000;
            int x$15 = -1;
            long x$16 = TestUtils$.MODULE$.createProducer$default$3();
            long x$17 = TestUtils$.MODULE$.createProducer$default$4();
            int x$18 = TestUtils$.MODULE$.createProducer$default$6();
            int x$19 = TestUtils$.MODULE$.createProducer$default$7();
            int x$20 = TestUtils$.MODULE$.createProducer$default$8();
            String x$21 = TestUtils$.MODULE$.createProducer$default$9();
            Option<Properties> x$22 = TestUtils$.MODULE$.createProducer$default$13();
            ByteArraySerializer x$23 = TestUtils$.MODULE$.createProducer$default$14();
            ByteArraySerializer x$24 = TestUtils$.MODULE$.createProducer$default$15();
            boolean x$25 = TestUtils$.MODULE$.createProducer$default$16();
            try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$10, x$15, x$16, x$17, x$13, x$18, x$19, x$20, x$21, x$14, x$11, x$12, x$22, x$23, x$24, x$25);){
                while (running.get()) {
                    Future future = producer.send(new ProducerRecord(topic, (Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(numMessages).toString().getBytes()));
                    numMessages.incrementAndGet();
                    future.get(10L, TimeUnit.SECONDS);
                }
                n = numMessages.get();
            }
            return n;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$11(numMessages)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$12(numMessages, producerFuture));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            this.client().alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$13(tp, firstReplicaAssignment, topic, producerFuture, server);
                return BoxedUnit.UNIT;
            });
            int currentMessagesNum = numMessages.get();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$16(numMessages, currentMessagesNum)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$17(numMessages, currentMessagesNum, producerFuture));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            running.set(false);
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Buffer<KafkaServer> x$28 = this.servers();
        SecurityProtocol x$31 = this.securityProtocol();
        Option<File> x$32 = this.trustStoreFile();
        String x$33 = TestUtils$.MODULE$.consumeTopicRecords$default$4();
        long x$34 = TestUtils$.MODULE$.consumeTopicRecords$default$7();
        ((IterableLike)TestUtils$.MODULE$.consumeTopicRecords(x$28, topic, finalNumMessages, x$33, x$31, x$32, x$34).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$18(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1, this.createTopic$default$5());
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)this.servers().apply(1)).config().brokerId()));
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)this.servers().apply(2)).config().brokerId()));
        .colon.colon configResources = new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)brokerResource1, (List)new .colon.colon((Object)brokerResource2, (List)Nil$.MODULE$))));
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)configResources).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assertions.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assertions.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assertions.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assertions.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assertions.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assertions.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MessageMaxBytes()), (Object)maxMessageBytes2.value());
        Assertions.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assertions.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assertions.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assertions.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assertions.assertEquals((Object)PlaintextAdminIntegrationTest.filteredConfigs$1((KafkaServer)this.servers().apply(1)), (Object)PlaintextAdminIntegrationTest.customFilteredDescribedConfigs$1(brokerResource1, configs));
        Assertions.assertEquals((Object)Integer.toString(((KafkaServer)this.servers().apply(1)).config().brokerId()), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assertions.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assertions.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assertions.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assertions.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assertions.assertNull((Object)truststorePassword.value());
        Assertions.assertFalse((boolean)truststorePassword.isDefault());
        Assertions.assertTrue((boolean)truststorePassword.isSensitive());
        Assertions.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assertions.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType(), (Object)compressionType.value());
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assertions.assertTrue((boolean)compressionType.isDefault());
        Assertions.assertFalse((boolean)compressionType.isSensitive());
        Assertions.assertFalse((boolean)compressionType.isReadOnly());
        Assertions.assertEquals((Object)PlaintextAdminIntegrationTest.filteredConfigs$1((KafkaServer)this.servers().apply(2)), (Object)PlaintextAdminIntegrationTest.customFilteredDescribedConfigs$1(brokerResource2, configs));
        Assertions.assertEquals((Object)Integer.toString(((KafkaServer)this.servers().apply(2)).config().brokerId()), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assertions.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreatePartitions(String quorum) {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        String topic2 = "create-partitions-topic-2";
        int x$2 = 2;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(topic2, x$3, x$2, x$4, x$5);
        TopicDescription topic1_metadata = this.getTopicMetadata(this.client(), topic1, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        TopicDescription topic2_metadata = this.getTopicMetadata(this.client(), topic2, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topic1_metadata.partitions().size());
        Assertions.assertEquals((int)1, (int)topic2_metadata.partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        Void cfr_ignored_0 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assertions.assertEquals((int)1, (int)this.numPartitions$1(topic1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        Void cfr_ignored_1 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$1(this, topic1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        Void cfr_ignored_2 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assertions.assertEquals((int)1, (int)this.numPartitions$1(topic2, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        Void cfr_ignored_3 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
        Assertions.assertEquals((int)3, (int)actualPartitions2.size());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Buffer$.MODULE$.canBuildFrom())).toList());
        new .colon.colon((Object)validateOnly, (List)new .colon.colon((Object)actuallyDoIt, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)option -> {
            PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$5(this, alterResult, topic1, topic2, newPartition2Assignments, option);
            return BoxedUnit.UNIT;
        });
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        Void cfr_ignored_4 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$34(this, topic1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$35());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2)).get());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException));
        Assertions.assertEquals((Object)(this.isKRaftTest() ? "The topic create-partitions-topic-2 currently has 3 partition(s); 2 would not be an increase." : "Topic currently has 3 partitions, which is higher than the requested 2."), (Object)e.getCause().getMessage());
        Assertions.assertEquals((int)3, (int)this.numPartitions$1(topic2, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        ((KafkaFuture)this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1})).topicNameValues().get(topic1)).get();
        alterResult.elem = this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1)).get(), () -> "Expect InvalidTopicException or UnknownTopicOrPartitionException when the topic is queued for deletion");
        if (this.isKRaftTest()) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof UnknownTopicOrPartitionException), (String)e.toString());
            Assertions.assertEquals((Object)"This server does not host this topic-partition.", (Object)e.getCause().getMessage());
            return;
        }
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidTopicException), (String)e.toString());
        Assertions.assertEquals((Object)"The topic is queued for deletion.", (Object)e.getCause().getMessage());
    }

    @Test
    public void testSeekAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assertions.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assertions.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assertions.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assertions.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assertions.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogStartOffsetCheckpoint() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        ObjectRef result = ObjectRef.create((Object)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()));
        ObjectRef lowWatermark = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)((KafkaFuture)((DeleteRecordsResult)result.elem).lowWatermarks().get(this.topicPartition())).get()).lowWatermark())));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)((Option)lowWatermark.elem));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.client().close();
        this.client_$eq(Admin.create(this.createConfig()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetCheckpoint$2(this, result, lowWatermark)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetCheckpoint$3(lowWatermark));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assertions.assertEquals((long)3L, (long)lowWatermark);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((long)3L, (long)((AbstractLog)((KafkaServer)this.servers().apply(i)).replicaManager().localLog(this.topicPartition()).get()).logStartOffset()));
    }

    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        ListenerName x$5;
        Properties x$4;
        String x$1 = this.topic();
        int x$2 = this.brokerCount();
        int x$3 = this.createTopic$default$2();
        int followerIndex = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$3, x$2, x$4 = this.createTopic$default$4(), x$5 = this.createTopic$default$5()).apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((long)3L, (long)((AbstractLog)((KafkaServer)this.servers().apply(i)).replicaManager().localLog(this.topicPartition()).get()).logStartOffset()));
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)117L))}))).asJava()).all().get();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        this.client_$eq(Admin.create(this.createConfig()));
        String x$1 = this.topic();
        int x$2 = this.brokerCount();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(x$1, x$3, x$2, x$4, x$5);
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)3L, (long)((AbstractLog)((KafkaServer)this.servers().apply(i)).replicaManager().localLog(this.topicPartition()).get()).logStartOffset());
            Assertions.assertEquals((long)expectedLEO, (long)((AbstractLog)((KafkaServer)this.servers().apply(i)).replicaManager().localLog(this.topicPartition()).get()).logEndOffset());
        });
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        this.client().alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)futureReplica), (Object)futureLogDir)}))).asJava()).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$2(this, futureLogDir)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)3L, (long)((AbstractLog)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logStartOffset());
        Assertions.assertEquals((long)expectedLEO, (long)((AbstractLog)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logEndOffset());
    }

    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assertions.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).all().get();
        Assertions.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava()).all().get();
        Assertions.assertNull(consumer.offsetsForTimes((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition()));
    }

    @Test
    public void testConsumeAfterDeleteRecords() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        TestUtils$.MODULE$.consumeRecords(consumer, 10, TestUtils$.MODULE$.consumeRecords$default$3());
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 7, TestUtils$.MODULE$.consumeRecords$default$3());
        this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)8L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
    }

    @Test
    public void testDeleteRecordsWithException() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assertions.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).getCause();
        Assertions.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistPartition), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(nonExistPartition)).get()).getCause();
        Assertions.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)describeResult1.values().get(nonExistentTopic)).get()).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)describeResult2.values().get(invalidTopic)).get()).getCause() instanceof InvalidTopicException));
    }

    /*
     * WARNING - void declaration
     */
    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        void pollUntilTrue_action;
        consumer.subscribe(Collections.singletonList(topic));
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.assignment().isEmpty();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$subscribeAndWaitForAssignment$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        ((IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> PlaintextAdminIntegrationTest.$anonfun$sendRecords$1(this, topicPartition, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$11 -> (RecordMetadata)x$11.get());
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testAclOperations() {
        AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        this.client_$eq(Admin.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(acl)).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(acl.toFilter())).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(Admin.create(this.createConfig()));
        Seq newTopics = (Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$12 -> new NewTopic(x$12, 1, (short)1), Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(java.time.Duration.ofHours(2L));
        KafkaFuture future2 = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        future.get();
        this.client().close(java.time.Duration.ofMinutes(30L));
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        this.client_$eq(Admin.create(config));
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$13 -> new NewTopic(x$13, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(java.time.Duration.ZERO);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        config.put("request.timeout.ms", "0");
        this.client_$eq(Admin.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$14 -> new NewTopic(x$14, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertTrue((Time.SYSTEM.milliseconds() > startTimeMs ? 1 : 0) != 0, (String)"Expected the timeout to take at least one millisecond.");
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("default.api.timeout.ms", "100000000");
        config.put("retries", "0");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((Admin)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$15 -> new NewTopic(x$15, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"mytopic3", (List)new .colon.colon((Object)"mytopic4", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$16 -> new NewTopic(x$16, 1, (short)1), Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        Assertions.assertEquals((int)1, (int)factory.failuresInjected());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerGroups() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            ListConsumerGroupsResult list1 = this.client().listConsumerGroups();
            Assertions.assertTrue((0 == ((Collection)list1.all().get()).size() ? 1 : 0) != 0);
            Assertions.assertTrue((0 == ((Collection)list1.errors().get()).size() ? 1 : 0) != 0);
            Assertions.assertTrue((0 == ((Collection)list1.valid().get()).size() ? 1 : 0) != 0);
            String testTopicName = "test_topic";
            String testTopicName1 = new StringBuilder(1).append(testTopicName).append("1").toString();
            String testTopicName2 = new StringBuilder(1).append(testTopicName).append("2").toString();
            int testNumPartitions = 2;
            this.client().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(testTopicName, testNumPartitions, (short)1), new NewTopic(testTopicName1, testNumPartitions, (short)1), new NewTopic(testTopicName2, testNumPartitions, (short)1)})).all().get();
            this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)testTopicName, (List)new .colon.colon((Object)testTopicName1, (List)new .colon.colon((Object)testTopicName2, (List)Nil$.MODULE$))), (Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            String EMPTY_GROUP_INSTANCE_ID = "";
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String testInstanceId1 = "test_instance_id_1";
            String testInstanceId2 = "test_instance_id_2";
            String fakeGroupId = "fake_group_id";
            scala.collection.immutable.Set groupInstanceSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testInstanceId1, testInstanceId2, EMPTY_GROUP_INSTANCE_ID}));
            scala.collection.immutable.Set consumerSet = (scala.collection.immutable.Set)groupInstanceSet.map((Function1 & Serializable & scala.Serializable)groupInstanceId -> {
                Properties x$1 = this.createProperties$1((String)groupInstanceId, testGroupId, testClientId, EMPTY_GROUP_INSTANCE_ID);
                ByteArrayDeserializer x$2 = this.createConsumer$default$1();
                ByteArrayDeserializer x$3 = this.createConsumer$default$2();
                List<String> x$4 = this.createConsumer$default$4();
                return this.createConsumer(x$2, x$3, x$1, x$4);
            }, Set$.MODULE$.canBuildFrom());
            scala.collection.immutable.Set topicSet = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTopicName, testTopicName1, testTopicName2}));
            CountDownLatch latch = new CountDownLatch(consumerSet.size());
            try {
                scala.collection.immutable.Set consumerThreads = (scala.collection.immutable.Set)((SetLike)consumerSet.zip((GenIterable)topicSet, Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)zipped -> PlaintextAdminIntegrationTest.createConsumerThread$1((KafkaConsumer)zipped._1(), (String)zipped._2(), latch), Set$.MODULE$.canBuildFrom());
                try {
                    consumerThreads.foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                        x$17.start();
                        return BoxedUnit.UNIT;
                    });
                    Assertions.assertTrue((boolean)latch.await(30000L, TimeUnit.MILLISECONDS));
                    long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$4(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                            Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$6(testGroupId));
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    }
                    long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime2 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$7(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                            Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$9(testGroupId));
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    }
                    long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime3 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$10(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                            Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$12());
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    }
                    DescribeConsumerGroupsResult describeWithFakeGroupResult = this.client().describeConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)new .colon.colon((Object)fakeGroupId, (List)Nil$.MODULE$))).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assertions.assertEquals((int)2, (int)describeWithFakeGroupResult.describedGroups().size());
                    Assertions.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(testGroupId));
                    ConsumerGroupDescription testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(testGroupId)).get();
                    Assertions.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assertions.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assertions.assertEquals((int)groupInstanceSet.size(), (int)testGroupDescription.members().size());
                    Collection members = testGroupDescription.members();
                    ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(members).asScala()).foreach((Function1 & Serializable & scala.Serializable)member -> {
                        PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$13(testClientId, member);
                        return BoxedUnit.UNIT;
                    });
                    scala.collection.immutable.Map topicPartitionsByTopic = ((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(members).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> (Set)CollectionConverters$.MODULE$.asScalaSetConverter(x$19.assignment().topicPartitions()).asScala(), scala.collection.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$20 -> x$20.topic());
                    topicSet.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                        PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$16(topicPartitionsByTopic, testNumPartitions, topic);
                        return BoxedUnit.UNIT;
                    });
                    java.util.Set expectedOperations = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)AclEntry$.MODULE$.supportedOperations(ResourceType.GROUP)).asJava();
                    Assertions.assertEquals((Object)expectedOperations, (Object)testGroupDescription.authorizedOperations());
                    Assertions.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(fakeGroupId));
                    ConsumerGroupDescription fakeGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(fakeGroupId)).get();
                    Assertions.assertEquals((Object)fakeGroupId, (Object)fakeGroupDescription.groupId());
                    Assertions.assertEquals((int)0, (int)fakeGroupDescription.members().size());
                    Assertions.assertEquals((Object)"", (Object)fakeGroupDescription.partitionAssignor());
                    Assertions.assertEquals((Object)ConsumerGroupState.DEAD, (Object)fakeGroupDescription.state());
                    Assertions.assertEquals((Object)expectedOperations, (Object)fakeGroupDescription.authorizedOperations());
                    Assertions.assertEquals((int)2, (int)((java.util.Map)describeWithFakeGroupResult.all().get()).size());
                    long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long waitUntilTrue_startTime4 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$18(this, testGroupId, testTopicName)) {
                        void waitUntilTrue_pause;
                        void waitUntilTrue_waitTimeMs;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                            Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$19());
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    }
                    String invalidInstanceId = "invalid-instance-id";
                    RemoveMembersFromConsumerGroupResult removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(invalidInstanceId))));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(removeMembersResult.all(), UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    KafkaFuture firstMemberFuture = removeMembersResult.memberResult(new MemberToRemove(invalidInstanceId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(firstMemberFuture, UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    DeleteConsumerGroupsResult deleteResult = this.client().deleteConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)new .colon.colon((Object)fakeGroupId, (List)Nil$.MODULE$))).asJava());
                    Assertions.assertEquals((int)2, (int)deleteResult.deletedGroups().size());
                    Assertions.assertTrue((boolean)deleteResult.deletedGroups().containsKey(fakeGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(fakeGroupId), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    Assertions.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(testGroupId), GroupNotEmptyException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(testInstanceId1))));
                    Assertions.assertNull((Object)removeMembersResult.all().get());
                    Assertions.assertNull((Object)removeMembersResult.memberResult(new MemberToRemove(testInstanceId1)).get());
                    DescribeConsumerGroupsResult describeTestGroupResult = this.client().describeConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)Nil$.MODULE$)).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assertions.assertEquals((int)1, (int)describeTestGroupResult.describedGroups().size());
                    testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeTestGroupResult.describedGroups().get(testGroupId)).get();
                    Assertions.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assertions.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assertions.assertEquals((int)(consumerSet.size() - 1), (int)testGroupDescription.members().size());
                    removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions());
                    Assertions.assertNull((Object)removeMembersResult.all().get());
                    testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)this.client().describeConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)Nil$.MODULE$)).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true)).describedGroups().get(testGroupId)).get();
                    Assertions.assertTrue((boolean)testGroupDescription.members().isEmpty());
                    deleteResult = this.client().deleteConsumerGroups((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testGroupId, (List)Nil$.MODULE$)).asJava());
                    Assertions.assertEquals((int)1, (int)deleteResult.deletedGroups().size());
                    Assertions.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    Assertions.assertNull((Object)((KafkaFuture)deleteResult.deletedGroups().get(testGroupId)).get());
                }
                finally {
                    consumerThreads.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$20(x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            finally {
                ((IterableLike)consumerSet.zip((GenIterable)groupInstanceSet, Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)zipped -> {
                    PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$21(zipped);
                    return BoxedUnit.UNIT;
                });
            }
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsets() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            String testTopicName = "test_topic";
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String fakeGroupId = "fake_group_id";
            TopicPartition tp1 = new TopicPartition(testTopicName, 0);
            TopicPartition tp2 = new TopicPartition("foo", 0);
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, 1, (short)1))).all().get();
            this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)testTopicName, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            newConsumerConfig.setProperty("max.poll.interval.ms", Integer.toString(Integer.MAX_VALUE));
            newConsumerConfig.setProperty("session.timeout.ms", Integer.toString(Defaults$.MODULE$.GroupMaxSessionTimeoutMs()));
            ByteArrayDeserializer x$2 = this.createConsumer$default$1();
            ByteArrayDeserializer x$3 = this.createConsumer$default$2();
            List<String> x$4 = this.createConsumer$default$4();
            KafkaConsumer consumer = this.createConsumer(x$2, x$3, newConsumerConfig, x$4);
            try {
                TestUtils$.MODULE$.subscribeAndWaitForRecords(testTopicName, consumer, TestUtils$.MODULE$.subscribeAndWaitForRecords$default$3());
                consumer.commitSync();
                DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp1), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                DeleteConsumerGroupOffsetsResult fakeDeleteResult = this.client().deleteConsumerGroupOffsets(fakeGroupId, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.all(), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp1), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp2), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            }
            finally {
                Utils.closeQuietly(consumer, (String)"consumer");
            }
            DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            Assertions.assertNull((Object)offsetDeleteResult.partitionResult(tp1).get());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    @Test
    public void testElectPreferredLeaders() {
        this.client_$eq(Admin.create(this.createConfig()));
        Seq prefer0 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq prefer1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Seq prefer2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1}));
        TopicPartition partition1 = new TopicPartition("elect-preferred-leaders-topic-1", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)prefer0)}))), (Seq<KafkaBroker>)this.servers());
        TopicPartition partition2 = new TopicPartition("elect-preferred-leaders-topic-2", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition2.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)prefer0)}))), (Seq<KafkaBroker>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Throwable exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assertions.assertEquals(ElectionNotNeededException.class, exception.getClass());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assertions.assertTrue((boolean)((java.util.Map)electResult.partitions().get()).isEmpty());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        Assertions.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(((java.util.Map)electResult.partitions().get()).keySet()).asScala());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        TopicPartition unknownPartition = new TopicPartition("topic-does-not-exist", 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assertions.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assertions.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        this.changePreferredLeader$1(prefer2, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assertions.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assertions.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        ((KafkaServer)this.servers().apply(1)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
        ElectLeadersOptions shortTimeout = (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Predef$.MODULE$.int2Integer(10000));
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), shortTimeout);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assertions.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assertions.assertTrue((boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"), (String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null, shortTimeout);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assertions.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assertions.assertTrue((boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"), (String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get();
        Assertions.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assertions.assertTrue((boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-2-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"), (String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
    }

    @Test
    public void testElectUncleanLeadersForOnePartition() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        TopicPartition partition1 = new TopicPartition("unclean-test-topic-1", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), (Seq<KafkaBroker>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
    }

    @Test
    public void testElectUncleanLeadersForManyPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)assignment2)}))), (Seq<KafkaBroker>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition2);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker2);
    }

    @Test
    public void testElectUncleanLeadersForAllPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)assignment2)}))), (Seq<KafkaBroker>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, null);
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assertions.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    @Test
    public void testElectUncleanLeadersForUnknownPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition unknownPartition = new TopicPartition(topic, 1);
        TopicPartition unknownTopic = new TopicPartition("unknown-topic", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)assignment1)}))), (Seq<KafkaBroker>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), new TopicPartition(topic, 0), broker1);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, unknownTopic}))).asJava());
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get() instanceof UnknownTopicOrPartitionException));
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownTopic)).get() instanceof UnknownTopicOrPartitionException));
    }

    @Test
    public void testElectUncleanLeadersWhenNoLiveBrokers() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), (Seq<KafkaBroker>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).get() instanceof EligibleLeadersNotAvailableException));
    }

    @Test
    public void testElectUncleanLeadersNoop() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), (Seq<KafkaBroker>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        ((KafkaServer)this.servers().apply(broker1)).startup();
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava()).partitions().get()).get(partition1)).get() instanceof ElectionNotNeededException));
    }

    @Test
    public void testElectUncleanLeadersAndNoop() {
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)assignment2)}))), (Seq<KafkaBroker>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assertions.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assertions.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get() instanceof ElectionNotNeededException));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    @Test
    public void testListReassignmentsDoesNotShowNonReassigningPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        int x$2 = 3;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(topic, x$3, x$2, x$4, x$5);
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assertions.assertEquals((int)0, (int)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assertions.assertEquals((int)0, (int)allReassignmentsMap.size());
    }

    @Test
    public void testListReassignmentsDoesNotShowDeletedPartitions() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assertions.assertEquals((int)0, (int)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assertions.assertEquals((int)0, (int)allReassignmentsMap.size());
    }

    @Test
    public void testValidIncrementalAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topic1CreateConfigs = new Properties();
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic1, 1, 1, topic1CreateConfigs, this.createTopic$default$5());
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        Collection topic1AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete()), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionMsProp(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)))).asJavaCollection();
        Collection topic2AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:0"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))))).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1Resource, (List)new .colon.colon((Object)topic2Resource, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assertions.assertEquals((Object)"compact,delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        ConfigEntry retentionMsPropEntry = ((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.RetentionMsProp());
        Assertions.assertTrue((boolean)retentionMsPropEntry.isDefault(), (String)new StringBuilder(28).append("Config value isn't default: ").append(retentionMsPropEntry.value()).toString());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)"lz4", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)"delete,compact", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assertions.assertEquals((Object)"0:0", (Object)((Config)configs.get(topic2Resource)).get(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()).value());
        topic1AlterConfigs = (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.SUBTRACT), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))).asJava();
        topic2AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString()), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$)).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1Resource, (List)new .colon.colon((Object)topic2Resource, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assertions.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assertions.assertEquals((Object)"", (Object)((Config)configs.get(topic1Resource)).get(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()).value());
        Assertions.assertEquals((Object)"", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$)).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1Resource, (List)Nil$.MODULE$)).asJava()).all().get();
        Assertions.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "zip"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testIncrementalAlterConfigsDeleteAndSetBrokerConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection())}))).asJava()).all().get();
        long x$3 = 25L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$1(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
        this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "654"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "987"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)))).asJavaCollection())}))).asJava()).all().get();
        long x$7 = 25L;
        long x$8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$6(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + x$8) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$8), x$7));
        }
    }

    @Test
    public void testIncrementalAlterConfigsDeleteBrokerConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "789"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)))).asJavaCollection())}))).asJava()).all().get();
        long x$3 = 25L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$1(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
        this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)))).asJavaCollection())}))).asJava()).all().get();
        long x$7 = 25L;
        long x$8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$7(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + x$8) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$8), x$7));
        }
    }

    @Test
    public void testInvalidIncrementalAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        Collection topic1AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.75"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.65"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)))).asJavaCollection();
        Collection topic2AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Error due to duplicate config keys"));
        ((KafkaFuture)alterResult.values().get(topic2Resource)).get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1Resource, (List)new .colon.colon((Object)topic2Resource, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType().toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        topic1AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$)).asJavaCollection();
        topic2AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$)).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value append is not allowed for config"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic2Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value subtract is not allowed for config"));
        topic1AlterConfigs = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testInvalidAlterPartitionReassignments() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "alter-reassignments-topic-1";
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        TopicPartition tp3 = new TopicPartition(topic, 2);
        this.createTopic(topic, 4, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        Optional<NewPartitionReassignment> validAssignment = Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1 & Serializable & scala.Serializable)x$21 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$1(BoxesRunTime.unboxToInt((Object)x$21)), IndexedSeq$.MODULE$.canBuildFrom())).asJava()));
        TopicPartition nonExistentTp1 = new TopicPartition("topicA", 0);
        TopicPartition nonExistentTp2 = new TopicPartition(topic, 4);
        java.util.Map nonExistentPartitionsResult = this.client().alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp1), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp2), validAssignment)}))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp1), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Optional<NewPartitionReassignment> extraNonExistentReplica = Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount() + 1).map((Function1 & Serializable & scala.Serializable)x$22 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$2(BoxesRunTime.unboxToInt((Object)x$22)), IndexedSeq$.MODULE$.canBuildFrom())).asJava()));
        Optional<NewPartitionReassignment> negativeIdReplica = Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-3, -2, -1}))).map((Function1 & Serializable & scala.Serializable)x$23 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$3(BoxesRunTime.unboxToInt((Object)x$23)), Seq$.MODULE$.canBuildFrom())).asJava()));
        Optional<NewPartitionReassignment> duplicateReplica = Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 1}))).map((Function1 & Serializable & scala.Serializable)x$24 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$4(BoxesRunTime.unboxToInt((Object)x$24)), Seq$.MODULE$.canBuildFrom())).asJava()));
        java.util.Map invalidReplicaResult = this.client().alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), extraNonExistentReplica), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), negativeIdReplica), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), duplicateReplica)}))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp1), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp2), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp3), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testLongTopicNames() {
        Admin client = Admin.create(this.createConfig());
        String longTopicName = String.join((CharSequence)"", Collections.nCopies(249, "x"));
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(250, "x"));
        .colon.colon newTopics2 = new .colon.colon((Object)new NewTopic(invalidTopicName, 3, (short)3), (List)new .colon.colon((Object)new NewTopic(longTopicName, 3, (short)3), (List)Nil$.MODULE$));
        java.util.Map results = client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics2).asJava()).values();
        Assertions.assertTrue((boolean)results.containsKey(longTopicName));
        ((KafkaFuture)results.get(longTopicName)).get();
        Assertions.assertTrue((boolean)results.containsKey(invalidTopicName));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get(invalidTopicName), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(client.alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(longTopicName, 0, 0)), ((KafkaServer)this.servers().apply(0)).config().logDirs().apply(0))}))).asJava()).all(), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        client.close();
    }

    @Test
    public void testNullConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        java.util.Map invalidConfigs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.RetentionBytesProp()), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)"producer")}))).asJava();
        NewTopic newTopic = new NewTopic(this.topic(), 2, (short)this.brokerCount());
        ExecutionException e1 = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.client().createTopics(Collections.singletonList(newTopic.configs(invalidConfigs))).all().get());
        Assertions.assertTrue((boolean)(e1.getCause() instanceof InvalidRequestException), (String)new StringBuilder(21).append("Unexpected exception ").append(e1.getCause().getClass()).toString());
        java.util.Map validConfigs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)"producer")}))).asJava();
        this.client().createTopics(Collections.singletonList(newTopic.configs(validConfigs))).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        this.validateLogConfig$1("producer");
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        .colon.colon alterOps = new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionBytesProp(), null), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$));
        ExecutionException e2 = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> PlaintextAdminIntegrationTest.$anonfun$testNullConfigs$2(this, topicResource, (Seq)alterOps));
        Assertions.assertTrue((boolean)(e2.getCause() instanceof InvalidRequestException), (String)new StringBuilder(21).append("Unexpected exception ").append(e2.getCause().getClass()).toString());
        this.validateLogConfig$1("producer");
    }

    @Test
    public void testDescribeConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        LoggerFactory.getLogger((String)"kafka.cluster.Replica").trace("Message to create the logger");
        Config loggerConfig = this.describeBrokerLoggers();
        String kafkaLogLevel = loggerConfig.get("kafka").value();
        ConfigEntry logCleanerLogLevelConfig = loggerConfig.get("kafka.cluster.Replica");
        Assertions.assertEquals((Object)kafkaLogLevel, (Object)logCleanerLogLevelConfig.value());
        Assertions.assertEquals((Object)"kafka.cluster.Replica", (Object)logCleanerLogLevelConfig.name());
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, (Object)logCleanerLogLevelConfig.source());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isReadOnly()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isSensitive()));
        Assertions.assertTrue((boolean)logCleanerLogLevelConfig.synonyms().isEmpty());
    }

    @Test
    @Disabled
    public void testIncrementalAlterConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        Config initialLoggerConfig = this.describeBrokerLoggers();
        String initialRootLogLevel = initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.log.LogCleaner").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.server.ReplicaManager").value());
        String newRootLogLevel = "DEBUG";
        Collection alterRootLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, true);
        Config validatedLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.controller.KafkaController").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.log.LogCleaner").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedRootLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.controller.KafkaController").value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.log.LogCleaner").value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterZKLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", "ERROR"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterZKLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedZKLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)"ERROR", (Object)changedZKLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterLogLevelsEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "ERROR"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", "TRACE"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))))).asJavaCollection();
        this.alterBrokerLoggers(alterLogLevelsEntries, this.alterBrokerLoggers$default$2());
        Config alteredLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)"INFO", (Object)alteredLoggerConfig.get("kafka.controller.KafkaController").value());
        Assertions.assertEquals((Object)"ERROR", (Object)alteredLoggerConfig.get("kafka.log.LogCleaner").value());
        Assertions.assertEquals((Object)"TRACE", (Object)alteredLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
    }

    @Test
    @Disabled
    public void testIncrementalAlterConfigsForLog4jLogLevelsCanResetLoggerToCurrentRoot() {
        this.client_$eq(Admin.create(this.createConfig()));
        String initialRootLogLevel = "TRACE";
        Collection alterRootLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), initialRootLogLevel), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config initialLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection alterControllerLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(alterControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedControllerLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)changedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)"INFO", (Object)changedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection deleteControllerLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(deleteControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config deletedControllerLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        String newRootLogLevel = "ERROR";
        Collection newAlterRootLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection();
        this.alterBrokerLoggers(newAlterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config newRootLoggerConfig = this.describeBrokerLoggers();
        Assertions.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assertions.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get("kafka.controller.KafkaController").value());
    }

    @Test
    @Disabled
    public void testIncrementalAlterConfigsForLog4jLogLevelsCannotResetRootLogger() {
        this.client_$eq(Admin.create(this.createConfig()));
        Collection deleteRootLoggerEntry = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$)).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(deleteRootLoggerEntry, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
    }

    @Test
    @Disabled
    public void testIncrementalAlterConfigsForLog4jLogLevelsDoesNotWorkWithInvalidConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String validLoggerName = "kafka.server.KafkaRequestHandler";
        ConfigEntry expectedValidLoggerLogLevel = this.describeBrokerLoggers().get(validLoggerName);
        Collection appendLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(appendLogLevelEntries, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection subtractLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(subtractLogLevelEntries, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection invalidLogLevelLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "OFF"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(invalidLogLevelLogLevelEntries, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Collection invalidLoggerNameLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("Some Other LogCleaner", "ERROR"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))).asJavaCollection();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> this.alterBrokerLoggers(invalidLoggerNameLogLevelEntries, this.alterBrokerLoggers$default$2())).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
    }

    @Test
    @Disabled
    public void testAlterConfigsForLog4jLogLevelsDoesNotWork() {
        this.client_$eq(Admin.create(this.createConfig()));
        Collection alterLogLevelsEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("kafka.controller.KafkaController", "INFO"), (List)Nil$.MODULE$)).asJavaCollection();
        AlterConfigsResult alterResult = this.client().alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.brokerLoggerConfigResource()), (Object)new Config(alterLogLevelsEntries))}))).asJava());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)alterResult.values().get(this.brokerLoggerConfigResource())).get()).getCause() instanceof InvalidRequestException));
    }

    public void alterBrokerLoggers(Collection<AlterConfigOp> entries, boolean validateOnly) {
        if (!validateOnly) {
            ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(entries).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$alterBrokerLoggers$1(this, entry)));
        }
        ((KafkaFuture)this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.brokerLoggerConfigResource()), entries)}))).asJava(), new AlterConfigsOptions().validateOnly(validateOnly)).values().get(this.brokerLoggerConfigResource())).get();
    }

    public boolean alterBrokerLoggers$default$2() {
        return false;
    }

    public Config describeBrokerLoggers() {
        return (Config)((KafkaFuture)this.client().describeConfigs(Collections.singletonList(this.brokerLoggerConfigResource())).values().get(this.brokerLoggerConfigResource())).get();
    }

    private void teardownBrokerLoggers() {
        if (this.changedBrokerLoggers().nonEmpty()) {
            scala.collection.immutable.Set validLoggers = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.describeBrokerLoggers().entries()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$teardownBrokerLoggers$1(x$25)))).map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.name(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
            Collection unsetBrokerLoggersEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((SetLike)this.changedBrokerLoggers().intersect((GenSet)validLoggers)).map((Function1 & Serializable & scala.Serializable)logger -> new AlterConfigOp(new ConfigEntry(logger, ""), AlterConfigOp.OpType.DELETE), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).asJavaCollection();
            this.alterBrokerLoggers(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), "FATAL"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)).asJavaCollection(), this.alterBrokerLoggers$default$2());
            this.alterBrokerLoggers(unsetBrokerLoggersEntries, this.alterBrokerLoggers$default$2());
            this.changedBrokerLoggers().clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateTopicsReturnsConfigs(String quorum) {
        this.client_$eq(Admin.create(super.createConfig()));
        HashMap<ConfigResource, java.util.List<Object>> alterMap = new HashMap<ConfigResource, java.util.List<Object>>();
        alterMap.put(new ConfigResource(ConfigResource.Type.BROKER, ""), Arrays.asList((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "10800000"), AlterConfigOp.OpType.SET)}));
        ((BufferLike)this.brokers().map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.config(), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.controllerServers().map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.config(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> alterMap.put(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(x0$1.nodeId())), Arrays.asList((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp(), "34"), AlterConfigOp.OpType.SET)})));
        this.client().incrementalAlterConfigs(alterMap).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreateTopicsReturnsConfigs$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testCreateTopicsReturnsConfigs$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("foo", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)Nil$.MODULE$))).asJava())}))).asJava()).configs(Collections.singletonMap(LogConfig$.MODULE$.IndexIntervalBytesProp(), "9999999")), (List)new .colon.colon((Object)new NewTopic("bar", 3, (short)3), (List)new .colon.colon((Object)new NewTopic("baz", OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty()))), (List)Nil$.MODULE$)));
        CreateTopicsResult result = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava());
        result.all().get();
        this.waitForTopics(this.client(), (Seq<String>)((TraversableOnce)newTopics.map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.name(), Seq$.MODULE$.canBuildFrom())).toList(), (Seq<String>)Nil$.MODULE$);
        Assertions.assertEquals((int)2, (Integer)((Integer)result.numPartitions("foo").get()));
        Assertions.assertEquals((int)2, (Integer)((Integer)result.replicationFactor("foo").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.numPartitions("bar").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.replicationFactor("bar").get()));
        Assertions.assertEquals((Integer)((KafkaConfig)this.configs().head()).numPartitions(), (Integer)((Integer)result.numPartitions("baz").get()));
        Assertions.assertEquals((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (Integer)((Integer)result.replicationFactor("baz").get()));
        Config topicConfigs = (Config)result.config("foo").get();
        Assertions.assertEquals((Object)new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), "delete", ConfigEntry.ConfigSource.DEFAULT_CONFIG, false, false, Collections.emptyList(), null, null), (Object)topicConfigs.get(LogConfig$.MODULE$.CleanupPolicyProp()));
        Assertions.assertEquals((Object)new ConfigEntry(LogConfig$.MODULE$.RetentionMsProp(), "10800000", ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, false, false, Collections.emptyList(), null, null), (Object)topicConfigs.get(LogConfig$.MODULE$.RetentionMsProp()));
        Assertions.assertEquals((Object)new ConfigEntry(LogConfig$.MODULE$.DeleteRetentionMsProp(), "34", ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG, false, false, Collections.emptyList(), null, null), (Object)topicConfigs.get(LogConfig$.MODULE$.DeleteRetentionMsProp()));
        Assertions.assertEquals((Object)new ConfigEntry(LogConfig$.MODULE$.SegmentJitterMsProp(), "123", ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG, false, false, Collections.emptyList(), null, null), (Object)topicConfigs.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        ConfigEntry.ConfigSource segmentMsPropType = this.isKRaftTest() ? ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG : ConfigEntry.ConfigSource.DEFAULT_CONFIG;
        Assertions.assertEquals((Object)new ConfigEntry(LogConfig$.MODULE$.SegmentMsProp(), "7200000", segmentMsPropType, false, false, Collections.emptyList(), null, null), (Object)topicConfigs.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assertions.assertEquals((Object)new ConfigEntry(LogConfig$.MODULE$.IndexIntervalBytesProp(), "9999999", ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, false, false, Collections.emptyList(), null, null), (Object)topicConfigs.get(LogConfig$.MODULE$.IndexIntervalBytesProp()));
    }

    public static final /* synthetic */ void $anonfun$testCreateExistingTopicsThrowTopicExistsException$1(PlaintextAdminIntegrationTest $this, Seq newTopicsWithInvalidRF$1) {
        $this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(newTopicsWithInvalidRF$1).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataRefresh$1(PlaintextAdminIntegrationTest $this, KafkaServer x$1) {
        return x$1.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected($this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString();
        Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr), (String)new StringBuilder(45).append("Unknown host:port pair ").append(hostStr).append(" in brokerVersionInfos").toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$testDescribeLogDirs$1(Tuple2 x0$1) {
        void var1_1;
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int leaderId = x0$1._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$5(int brokerId$1, KafkaServer x$4) {
        return x$4.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$7(String topic$1, Tuple2 x0$4) {
        if (x0$4 == null) {
            throw new MatchError(null);
        }
        String string = ((TopicPartition)x0$4._1()).topic();
        boolean bl = !(string != null ? !string.equals(topic$1) : topic$1 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$10(KafkaServer server$1, String logDir$1, TopicPartition tp) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertEquals((Object)((AbstractLog)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)logDir$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeReplicaLogDirs$3(TopicPartitionReplica topicPartitionReplica$1, KafkaServer x$6) {
        return x$6.config().brokerId() == topicPartitionReplica$1.brokerId();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$4(KafkaFuture future) {
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get())).getCause() instanceof UnknownTopicOrPartitionException));
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$6(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        boolean x$7 = qual$1.getLog$default$2();
        String logDir = ((AbstractLog)qual$1.getLog(tp$1, x$7).get()).dir().getParent();
        Assertions.assertEquals((Object)firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId())), (Object)logDir);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$8(KafkaServer server$2, TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3) {
        LogManager qual$2 = server$2.logManager();
        boolean x$9 = qual$2.getLog$default$2();
        String logDir = ((AbstractLog)qual$2.getLog(tp$1, x$9).get()).dir().getParent();
        Object object = secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$2.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$9() {
        return "timed out waiting for replica movement";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$7(TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$8(server, tp$1, secondReplicaAssignment$1, topic$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$11(AtomicInteger numMessages$1) {
        return numMessages$1.get() > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$12(AtomicInteger numMessages$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(60).append("only ").append(numMessages$1).append(" messages are produced before timeout. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$14(KafkaServer server$3, TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3) {
        LogManager qual$3 = server$3.logManager();
        boolean x$27 = qual$3.getLog$default$2();
        String logDir = ((AbstractLog)qual$3.getLog(tp$1, x$27).get()).dir().getParent();
        Object object = firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$3.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$15(scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(56).append("timed out waiting for replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$13(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, scala.concurrent.Future producerFuture$1, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$14(server, tp$1, firstReplicaAssignment$1, topic$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$15(producerFuture$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$16(AtomicInteger numMessages$1, int currentMessagesNum$1) {
        return numMessages$1.get() - currentMessagesNum$1 > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$17(AtomicInteger numMessages$1, int currentMessagesNum$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(83).append("only ").append(numMessages$1.get() - currentMessagesNum$1).append(" messages are produced within timeout after replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$18(Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord consumerRecord = (ConsumerRecord)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Assertions.assertEquals((Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(index).toString(), (Object)new String((byte[])consumerRecord.value()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAndAlterConfigs$1(String config) {
        return config.equals("confluent.schema.registry.url") || config.equals("confluent.basic.auth.credentials.source") || config.equals("confluent.schema.validator.samples.per.min") || config.equals("confluent.basic.auth.user.info") || config.equals("confluent.bearer.auth.credentials.source") || config.equals("confluent.bearer.auth.token") || config.equals("confluent.schema.validator.interceptor.class") || config.equals(LogConfig$.MODULE$.AppendRecordInterceptorClassesProp()) || config.equals("confluent.schema.validator.multitenant.enable") || config.equals("confluent.ssl.protocol") || config.equals("confluent.ssl.keystore.type") || config.equals("confluent.ssl.keystore.location") || config.equals("confluent.ssl.keystore.password") || config.equals("confluent.ssl.key.password") || config.equals("confluent.ssl.truststore.type") || config.equals("confluent.ssl.truststore.location") || config.equals("confluent.ssl.truststore.password");
    }

    private static final scala.collection.immutable.Set filteredConfigs$1(KafkaServer server) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(server.config().nonInternalValues().keySet()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeAndAlterConfigs$1(config)))).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAndAlterConfigs$2(ConfigEntry x$7) {
        return x$7.name().startsWith("confluent.license");
    }

    private static final scala.collection.immutable.Set customFilteredDescribedConfigs$1(ConfigResource brokerResource, java.util.Map configs$1) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs$1.get(brokerResource)).entries()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeAndAlterConfigs$2(x$7)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private final java.util.List partitions$1(String topic, Option expectedNumPartitionsOpt) {
        Admin x$1 = this.client();
        DescribeTopicsOptions x$4 = this.getTopicMetadata$default$3();
        return this.getTopicMetadata(x$1, topic, x$4, (Option<Object>)expectedNumPartitionsOpt).partitions();
    }

    private final int numPartitions$1(String topic, Option expectedNumPartitionsOpt) {
        return this.partitions$1(topic, expectedNumPartitionsOpt).size();
    }

    private static final Option numPartitions$default$2$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$1(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()) == 3;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$2() {
        return "Timed out waiting for new partitions to appear";
    }

    public static final /* synthetic */ void $anonfun$testCreatePartitions$5(PlaintextAdminIntegrationTest $this, ObjectRef alterResult$1, String topic1$1, String topic2$1, java.util.List newPartition2Assignments$1, CreatePartitionsOptions option) {
        String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(63).append(desc).append(": Expect InvalidPartitionsException when newCount is a decrease").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        String exceptionMsgStr = $this.isKRaftTest() ? "The topic create-partitions-topic-1 currently has 3 partition(s); 1 would not be an increase." : "Topic currently has 3 partitions, which is higher than the requested 1.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get(), () -> new StringBuilder(58).append(desc).append(": Expect InvalidPartitionsException when requesting a noop").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "Topic already has 3 partition(s)." : "Topic already has 3 partitions.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)newPartition2Assignments$1))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(newPartition2Assignments$1).asScala()).reverse()).toList()).asJava())))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (String)desc);
        String unknownTopic = "an-unknown-topic";
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(unknownTopic)).get(), () -> new StringBuilder(58).append(desc).append(": Expect InvalidTopicException when using an unknown topic").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof UnknownTopicOrPartitionException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "This server does not host this topic-partition." : "The topic 'an-unknown-topic' does not exist.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)0))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(60).append(desc).append(": Expect InvalidPartitionsException when newCount is invalid").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "The topic create-partitions-topic-1 currently has 3 partition(s); 0 would not be an increase." : "Cannot create 0 new partitions.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(60).append(desc).append(": Expect InvalidPartitionsException when newCount is invalid").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "The topic create-partitions-topic-1 currently has 3 partition(s); -22 would not be an increase." : "Cannot create -22 new partitions.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)Integer.MIN_VALUE))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(60).append(desc).append(": Expect InvalidPartitionsException when newCount is invalid").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException), (String)new StringBuilder(72).append(desc).append(": Expected the cause of the exception to be of type ").append(InvalidPartitionsException.class).append(" but instead it was ").append(e.getCause().getClass()).toString());
        exceptionMsgStr = $this.isKRaftTest() ? new StringBuilder(92).append("The topic create-partitions-topic-1 currently has 3 partition(s); ").append(Integer.MIN_VALUE).append(" would not be an ").append("increase.").toString() : new StringBuilder(30).append("Cannot create ").append(Integer.MIN_VALUE).append(" new partitions.").toString();
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(71).append(desc).append(": Expect InvalidPartitionsException when #brokers != replication factor").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "The manual partition assignment includes a partition with 2 replica(s), but this is not consistent with previous partitions, which have 1 replica(s)." : "Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "Attempted to add 3 additional partition(s), but only 1 assignment(s) were specified." : "Increasing the number of partitions by 3 but 1 assignments provided.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        exceptionMsgStr = $this.isKRaftTest() ? "Attempted to add 1 additional partition(s), but only 2 assignment(s) were specified." : "Increasing the number of partitions by 1 but 2 assignments provided.";
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(81).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "The manual partition assignment includes the broker 1 more than once." : "Duplicate replicas not allowed in partition assignment: 1, 1.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})})))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(94).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "The manual partition assignment includes a partition with 2 replica(s), but this is not consistent with previous partitions, which have 1 replica(s)." : "Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})})))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(86).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "The manual partition assignment includes broker 12, but no such broker is registered." : "Unknown broker(s) in replica assignment: 12.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1$1), (Object)NewPartitions.increaseTo((int)4, Collections.emptyList()))}))).asJava(), option);
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get(), () -> new StringBuilder(68).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments is empty").toString());
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidReplicaAssignmentException), (String)desc);
        exceptionMsgStr = $this.isKRaftTest() ? "Attempted to add 1 additional partition(s), but only 0 assignment(s) were specified." : "Increasing the number of partitions by 1 but 0 assignments provided.";
        Assertions.assertEquals((Object)exceptionMsgStr, (Object)e.getCause().getMessage(), (String)desc);
        Assertions.assertEquals((int)3, (int)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()), (String)desc);
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$34(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()) == 4;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$35() {
        return "Timed out waiting for new partitions to appear";
    }

    public static final /* synthetic */ boolean $anonfun$testLogStartOffsetCheckpoint$2(PlaintextAdminIntegrationTest $this, ObjectRef result$1, ObjectRef lowWatermark$1) {
        result$1.elem = $this.client().deleteRecords((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)0L))}))).asJava());
        lowWatermark$1.elem = None$.MODULE$;
        KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)result$1.elem).lowWatermarks().get($this.topicPartition());
        try {
            lowWatermark$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)future.get()).lowWatermark()));
            return ((Option)lowWatermark$1.elem).contains((Object)BoxesRunTime.boxToLong((long)5L));
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (!(throwable instanceof ExecutionException) || !((executionException = (ExecutionException)throwable).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderOrFollowerException)) {
                throw throwable;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static final /* synthetic */ String $anonfun$testLogStartOffsetCheckpoint$3(ObjectRef lowWatermark$1) {
        return new StringBuilder(56).append("Expected low watermark of the partition to be 5 but got ").append(((Option)lowWatermark$1.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> "no response within the timeout")).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int followerIndex$1) {
        Option option = ((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition());
        None$ none$ = None$.MODULE$;
        return option == null ? none$ != null : !option.equals(none$);
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$2() {
        return "Expected follower to create replica for partition";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedStartOffset$1) {
        return ((AbstractLog)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset() == expectedStartOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(long expectedStartOffset$1) {
        return new StringBuilder(51).append("Expected follower to discover new log start offset ").append(expectedStartOffset$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedEndOffset$1) {
        return ((AbstractLog)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logEndOffset() == expectedEndOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(long expectedEndOffset$1) {
        return new StringBuilder(48).append("Expected follower to catch up to log end offset ").append(expectedEndOffset$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(this, followerIndex$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(this, followerIndex$1, expectedStartOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(expectedStartOffset));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(this, followerIndex$1, expectedEndOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(expectedEndOffset));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterLogDirsAfterDeleteRecords$2(PlaintextAdminIntegrationTest $this, String futureLogDir$1) {
        String string = futureLogDir$1;
        LogManager qual$1 = ((KafkaServer)$this.servers().apply(0)).logManager();
        TopicPartition x$6 = $this.topicPartition();
        boolean x$7 = qual$1.getLog$default$2();
        String string2 = ((AbstractLog)qual$1.getLog(x$6, x$7).get()).dir().getParent();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterLogDirsAfterDeleteRecords$3() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(PlaintextAdminIntegrationTest $this, TopicPartition topicPartition$1, KafkaProducer producer$1, int i) {
        ProducerRecord record = new ProducerRecord(topicPartition$1.topic(), Predef$.MODULE$.int2Integer(topicPartition$1.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$1.send(record);
    }

    private final Properties createProperties$1(String groupInstanceId, String testGroupId$1, String testClientId$1, String EMPTY_GROUP_INSTANCE_ID$1) {
        Properties newConsumerConfig = new Properties(this.consumerConfig());
        newConsumerConfig.setProperty("enable.auto.commit", "false");
        newConsumerConfig.setProperty("group.id", testGroupId$1);
        newConsumerConfig.setProperty("client.id", testClientId$1);
        String string = groupInstanceId;
        if (string == null ? EMPTY_GROUP_INSTANCE_ID$1 != null : !string.equals(EMPTY_GROUP_INSTANCE_ID$1)) {
            newConsumerConfig.setProperty("group.instance.id", groupInstanceId);
        }
        return newConsumerConfig;
    }

    private static final Thread createConsumerThread$1(KafkaConsumer consumer, String topic, CountDownLatch latch$1) {
        return new Thread(null, consumer, topic, latch$1){
            private final KafkaConsumer consumer$2;
            private final String topic$4;
            private final CountDownLatch latch$1;

            public void run() {
                this.consumer$2.subscribe(Collections.singleton(this.topic$4));
                try {
                    while (true) {
                        this.consumer$2.poll(java.time.Duration.ofSeconds(5L));
                        if (!this.consumer$2.assignment().isEmpty() && this.latch$1.getCount() > 0L) {
                            this.latch$1.countDown();
                        }
                        this.consumer$2.commitSync();
                    }
                }
                catch (InterruptException interruptException) {
                    return;
                }
            }
            {
                this.consumer$2 = consumer$2;
                this.topic$4 = topic$4;
                this.latch$1 = latch$1;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$5(String testGroupId$1, ConsumerGroupListing group) {
        String string = group.groupId();
        if (!(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null)) {
            Object t = group.state().get();
            ConsumerGroupState consumerGroupState = ConsumerGroupState.STABLE;
            if (!(t != null ? !t.equals(consumerGroupState) : consumerGroupState != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$4(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        return ((Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)$this.client().listConsumerGroups().all().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)group -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$5(testGroupId$1, group)))).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$6(String testGroupId$1) {
        return new StringBuilder(28).append("Expected to be able to list ").append(testGroupId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$8(String testGroupId$1, ConsumerGroupListing group) {
        String string = group.groupId();
        if (!(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null)) {
            Object t = group.state().get();
            ConsumerGroupState consumerGroupState = ConsumerGroupState.STABLE;
            if (!(t != null ? !t.equals(consumerGroupState) : consumerGroupState != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$7(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        ListConsumerGroupsOptions options = new ListConsumerGroupsOptions().inStates((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE}))).asJava());
        return ((Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)$this.client().listConsumerGroups(options).all().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)group -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$8(testGroupId$1, group)))).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$9(String testGroupId$1) {
        return new StringBuilder(44).append("Expected to be able to list ").append(testGroupId$1).append(" in state Stable").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$11(String testGroupId$1, ConsumerGroupListing x$18) {
        String string = x$18.groupId();
        return !(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$10(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        ListConsumerGroupsOptions options = new ListConsumerGroupsOptions().inStates((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.EMPTY}))).asJava());
        return ((Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)$this.client().listConsumerGroups(options).all().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$11(testGroupId$1, x$18)))).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$12() {
        return "Expected to find zero groups";
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$13(String testClientId$1, MemberDescription member) {
        Assertions.assertEquals((Object)testClientId$1, (Object)member.clientId());
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$16(scala.collection.immutable.Map topicPartitionsByTopic$1, int testNumPartitions$1, String topic) {
        Iterable topicPartitions = (Iterable)topicPartitionsByTopic$1.getOrElse((Object)topic, (Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        Assertions.assertEquals((int)testNumPartitions$1, (int)topicPartitions.size());
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$18(PlaintextAdminIntegrationTest $this, String testGroupId$1, String testTopicName$1) {
        TopicPartition part;
        java.util.Map parts = (java.util.Map)$this.client().listConsumerGroupOffsets(testGroupId$1).partitionsToOffsetAndMetadata().get();
        return parts.containsKey(part = new TopicPartition(testTopicName$1, 0)) && ((OffsetAndMetadata)parts.get(part)).offset() == 1L;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$19() {
        return "Expected the offset for partition 0 to eventually become 1.";
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$20(Thread x0$1) {
        x0$1.interrupt();
        x0$1.join();
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroups$21(Tuple2 zipped) {
        Utils.closeQuietly((AutoCloseable)((AutoCloseable)zipped._1()), (String)((String)zipped._2()));
    }

    private final int preferredLeader$1(TopicPartition topicPartition) {
        return ((Node)((TopicPartitionInfo)this.getTopicMetadata(this.client(), topicPartition.topic(), this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4()).partitions().get(topicPartition.partition())).replicas().get(0)).id();
    }

    public static final /* synthetic */ boolean $anonfun$testElectPreferredLeaders$1(PlaintextAdminIntegrationTest $this, TopicPartition partition1$1, int preferred$1, TopicPartition partition2$1) {
        return $this.preferredLeader$1(partition1$1) == preferred$1 && $this.preferredLeader$1(partition2$1) == preferred$1;
    }

    public static final /* synthetic */ String $anonfun$testElectPreferredLeaders$2(PlaintextAdminIntegrationTest $this, int preferred$1, TopicPartition partition1$1, TopicPartition partition2$1) {
        return new StringBuilder(50).append("Expected preferred leader to become ").append(preferred$1).append(", but is ").append($this.preferredLeader$1(partition1$1)).append(" and ").append($this.preferredLeader$1(partition2$1)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void changePreferredLeader$1(Seq newAssignment, TopicPartition partition1$1, TopicPartition partition2$1) {
        int preferred = BoxesRunTime.unboxToInt((Object)newAssignment.head());
        int prior1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition1$1).get());
        int prior2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition2$1).get());
        scala.collection.immutable.Map m = Predef$.MODULE$.Map().empty();
        if (prior1 != preferred) {
            m = m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1$1), (Object)newAssignment));
        }
        if (prior2 != preferred) {
            m = m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2$1), (Object)newAssignment));
        }
        this.zkClient().createPartitionReassignment((Map)m);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$1(this, partition1$1, preferred, partition2$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$2(this, preferred, partition1$1, partition2$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.assertLeader(this.client(), partition1$1, prior1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2$1, prior2);
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$1(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$1) {
        scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)broker0Resource$1, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$1)).entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> new Tuple2((Object)x0$1.name(), (Object)x0$1.value()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return "123".equals(broker0Configs.getOrElse((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "456".equals(broker0Configs.getOrElse((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$5() {
        return "Expected to see the broker properties we just set";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$6(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$1) {
        scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)broker0Resource$1, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$1)).entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> new Tuple2((Object)x0$2.name(), (Object)x0$2.value()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return $this.throttledRateStaticDefault().equals(broker0Configs.getOrElse((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "654".equals(broker0Configs.getOrElse((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "987".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$11() {
        return "Expected to see the broker properties we just modified";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$1(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$2) {
        scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)broker0Resource$2, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$2)).entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> new Tuple2((Object)x0$1.name(), (Object)x0$1.value()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return "123".equals(broker0Configs.getOrElse((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "456".equals(broker0Configs.getOrElse((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "789".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$6() {
        return "Expected to see the broker properties we just set";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$7(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$2) {
        scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)broker0Resource$2, (List)Nil$.MODULE$)).asJava()).all().get()).get(broker0Resource$2)).entries()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> new Tuple2((Object)x0$2.name(), (Object)x0$2.value()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return $this.throttledRateStaticDefault().equals(broker0Configs.getOrElse((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && $this.throttledRateStaticDefault().equals(broker0Configs.getOrElse((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable & scala.Serializable)() -> "")) && "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$12() {
        return "Expected to see the broker properties we just removed to be deleted";
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$1(int x$21) {
        return BoxesRunTime.boxToInteger((int)x$21);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$2(int x$22) {
        return BoxesRunTime.boxToInteger((int)x$22);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$3(int x$23) {
        return BoxesRunTime.boxToInteger((int)x$23);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$4(int x$24) {
        return BoxesRunTime.boxToInteger((int)x$24);
    }

    private final void validateLogConfig$1(String compressionType) {
        LogConfig logConfig = (LogConfig)((MapLike)this.zkClient().getLogConfigs((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), Collections.emptyMap())._1()).apply((Object)this.topic());
        Assertions.assertEquals((Object)compressionType, logConfig.originals().get(LogConfig$.MODULE$.CompressionTypeProp()));
        Assertions.assertNull(logConfig.originals().get(LogConfig$.MODULE$.RetentionBytesProp()));
        Assertions.assertEquals((long)Defaults$.MODULE$.LogRetentionBytes(), (Long)logConfig.retentionSize());
    }

    public static final /* synthetic */ void $anonfun$testNullConfigs$2(PlaintextAdminIntegrationTest $this, ConfigResource topicResource$1, Seq alterOps$1) {
        $this.client().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource$1), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)alterOps$1).asJavaCollection())}))).asJava()).all().get();
    }

    private final void assertLogLevelDidNotChange$1(ConfigEntry expectedValidLoggerLogLevel$1, String validLoggerName$1) {
        Assertions.assertEquals((Object)expectedValidLoggerLogLevel$1, (Object)this.describeBrokerLoggers().get(validLoggerName$1));
    }

    public static final /* synthetic */ boolean $anonfun$alterBrokerLoggers$1(PlaintextAdminIntegrationTest $this, AlterConfigOp entry) {
        return $this.changedBrokerLoggers().add((Object)entry.configEntry().name());
    }

    public static final /* synthetic */ boolean $anonfun$teardownBrokerLoggers$1(ConfigEntry x$25) {
        return x$25.name().equals(Log4jController$.MODULE$.ROOT_LOGGER());
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicsReturnsConfigs$5(KafkaBroker x$29) {
        return x$29.config().originals().getOrDefault(KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp(), "").toString().equals("34");
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicsReturnsConfigs$4(PlaintextAdminIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testCreateTopicsReturnsConfigs$5(x$29)));
    }

    public static final /* synthetic */ String $anonfun$testCreateTopicsReturnsConfigs$6() {
        return new StringBuilder(32).append("Timed out waiting for change to ").append(KafkaConfig$.MODULE$.LogCleanerDeleteRetentionMsProp()).toString();
    }

    public PlaintextAdminIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
    }
}

