/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.junit.jupiter.api.Assertions;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ObjectRef;

public final class PlaintextAdminIntegrationTest$ {
    public static PlaintextAdminIntegrationTest$ MODULE$;

    static {
        new PlaintextAdminIntegrationTest$();
    }

    public void checkValidAlterConfigs(Admin client, ConfigResource topicResource1, ConfigResource topicResource2) {
        java.util.List topicConfigEntries1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), (List)Nil$.MODULE$)).asJava();
        java.util.List topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), (List)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), (List)Nil$.MODULE$))).asJava();
        AlterConfigsResult alterResult = client.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2))}))).asJava());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        java.util.Map configs = (java.util.Map)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)"1000", (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MessageMaxBytes()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.LogRetentionHours() * 60 * 60 * 1000), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)"lz4", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        topicConfigEntries1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MaxMessageBytesProp(), "10"), (List)Nil$.MODULE$)).asJava();
        topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.3"), (List)Nil$.MODULE$)).asJava();
        alterResult = client.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        configs = (java.util.Map)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MessageMaxBytes()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp()).value());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
    }

    public void checkInvalidAlterConfigs(KafkaZkClient zkClient, Seq<KafkaServer> servers, Admin client) {
        String topic1 = "invalid-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        TestUtils$.MODULE$.createTopic(zkClient, topic1, 1, 1, servers, TestUtils$.MODULE$.createTopic$default$6());
        String topic2 = "invalid-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        TestUtils$.MODULE$.createTopic(zkClient, topic2, 1, 1, servers, TestUtils$.MODULE$.createTopic$default$6());
        java.util.List topicConfigEntries1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), (List)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), (List)Nil$.MODULE$))).asJava();
        java.util.List topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), (List)Nil$.MODULE$)).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)servers.head()).config().brokerId()));
        java.util.List brokerConfigEntries = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181"), (List)Nil$.MODULE$)).asJava();
        ObjectRef alterResult = ObjectRef.create((Object)client.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava()));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$3.elem).values().get(topicResource1)).get()).getCause() instanceof InvalidRequestException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$3.elem).values().get(brokerResource)).get()).getCause() instanceof InvalidRequestException));
        java.util.Map configs = (java.util.Map)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$)))).asJava()).all().get();
        Assertions.assertEquals((int)3, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)"snappy", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType(), (Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.CompressionTypeProp()).value());
        topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), (List)Nil$.MODULE$)).asJava();
        alterResult.elem = client.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$3.elem).values().get(topicResource1)).get()).getCause() instanceof InvalidRequestException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$3.elem).values().get(brokerResource)).get()).getCause() instanceof InvalidRequestException));
        configs = (java.util.Map)client.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$)))).asJava()).all().get();
        Assertions.assertEquals((int)3, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)"snappy", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assertions.assertEquals((Object)Defaults$.MODULE$.CompressionType(), (Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.CompressionTypeProp()).value());
    }

    private PlaintextAdminIntegrationTest$() {
        MODULE$ = this;
    }
}

