/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.QuotaTestClients;
import kafka.api.QuotaTestClients$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ub!\u0002\u0010 \u0003\u0003!\u0003\"B\u0015\u0001\t\u0003Q\u0003b\u0002\u0017\u0001\u0005\u0004%\t%\f\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0018\t\u000bU\u0002A\u0011\u0003\u001c\t\u000b}\u0002A\u0011\u0003\u001c\t\u000b\u0001\u0003a\u0011C!\t\u000fe\u0003!\u0019!C\u00015\"1a\f\u0001Q\u0001\nmCqa\u0018\u0001C\u0002\u0013\u0005!\f\u0003\u0004a\u0001\u0001\u0006Ia\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u00191\u0007\u0001)A\u0005G\"9q\r\u0001b\u0001\n\u00031\u0004B\u00025\u0001A\u0003%q\u0007C\u0005S\u0001\u0001\u0007\t\u0019!C\u0001S\"I!\u000e\u0001a\u0001\u0002\u0004%\ta\u001b\u0005\nc\u0002\u0001\r\u0011!Q!\nMC\u0011B\u001d\u0001A\u0002\u0003\u0007I\u0011A5\t\u0013M\u0004\u0001\u0019!a\u0001\n\u0003!\b\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003T\u0011%9\b\u00011AA\u0002\u0013\u0005\u0001\u0010C\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\"IA\u0010\u0001a\u0001\u0002\u0003\u0006KA\u0011\u0005\u0006{\u0002!\tE \u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\ti\u0003\u0001C\u0001\u0003GAq!!\r\u0001\t\u0003\t\u0019\u0003C\u0004\u00026\u0001!\t!a\t\t\u000f\u0005e\u0002\u0001\"\u0001\u0002$\ti!)Y:f#V|G/\u0019+fgRT!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018NC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019:S\"A\u0010\n\u0005!z\"AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005Y\u0003C\u0001\u0014\u0001\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u00121!\u00138u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003A\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE-F\u00018!\tAT(D\u0001:\u0015\tQ4(\u0001\u0003mC:<'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012aa\u0015;sS:<\u0017\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0003Y\u0019'/Z1uKF+x\u000e^1UKN$8\t\\5f]R\u001cHc\u0001\"F#B\u0011aeQ\u0005\u0003\t~\u0011\u0001#U;pi\u0006$Vm\u001d;DY&,g\u000e^:\t\u000b\u00193\u0001\u0019A$\u0002\u000bQ|\u0007/[2\u0011\u0005!{eBA%N!\tQ\u0005'D\u0001L\u0015\ta5%\u0001\u0004=e>|GOP\u0005\u0003\u001dB\na\u0001\u0015:fI\u00164\u0017B\u0001 Q\u0015\tq\u0005\u0007C\u0003S\r\u0001\u00071+\u0001\u0006mK\u0006$WM\u001d(pI\u0016\u0004\"\u0001V,\u000e\u0003US!AV\u0011\u0002\rM,'O^3s\u0013\tAVKA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018\u0001\u00063fM\u0006,H\u000e\u001e)s_\u0012,8-\u001a:Rk>$\u0018-F\u0001\\!\tyC,\u0003\u0002^a\t!Aj\u001c8h\u0003U!WMZ1vYR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uC\u0002\nA\u0003Z3gCVdGoQ8ogVlWM])v_R\f\u0017!\u00063fM\u0006,H\u000e^\"p]N,X.\u001a:Rk>$\u0018\rI\u0001\u0014I\u00164\u0017-\u001e7u%\u0016\fX/Z:u#V|G/Y\u000b\u0002GB\u0011q\u0006Z\u0005\u0003KB\u0012a\u0001R8vE2,\u0017\u0001\u00063fM\u0006,H\u000e\u001e*fcV,7\u000f^)v_R\f\u0007%\u0001\u0004u_BL7-M\u0001\bi>\u0004\u0018nY\u0019!+\u0005\u0019\u0016A\u00047fC\u0012,'OT8eK~#S-\u001d\u000b\u0003Y>\u0004\"aL7\n\u00059\u0004$\u0001B+oSRDq\u0001\u001d\t\u0002\u0002\u0003\u00071+A\u0002yIE\n1\u0002\\3bI\u0016\u0014hj\u001c3fA\u0005aam\u001c7m_^,'OT8eK\u0006\u0001bm\u001c7m_^,'OT8eK~#S-\u001d\u000b\u0003YVDq\u0001]\n\u0002\u0002\u0003\u00071+A\u0007g_2dwn^3s\u001d>$W\rI\u0001\u0011cV|G/\u0019+fgR\u001cE.[3oiN,\u0012AQ\u0001\u0015cV|G/\u0019+fgR\u001cE.[3oiN|F%Z9\u0015\u00051\\\bb\u00029\u0017\u0003\u0003\u0005\rAQ\u0001\u0012cV|G/\u0019+fgR\u001cE.[3oiN\u0004\u0013!B:fiV\u0003HC\u00017\u0000\u0011\u001d\t\t\u0001\u0007a\u0001\u0003\u0007\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u000b\t)\"\u0004\u0002\u0002\b)\u0019\u0001%!\u0003\u000b\t\u0005-\u0011QB\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\ty!!\u0005\u0002\u000b),h.\u001b;\u000b\u0005\u0005M\u0011aA8sO&!\u0011qCA\u0004\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\r\u0002\u001cA!\u0011QAA\u000f\u0013\u0011\ty\"a\u0002\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u000fuKN$H\u000b\u001b:piRdW\r\u001a)s_\u0012,8-\u001a:D_:\u001cX/\\3s)\u0005a\u0007fA\r\u0002(A!\u0011QAA\u0015\u0013\u0011\tY#a\u0002\u0003\tQ+7\u000f^\u0001(i\u0016\u001cH\u000f\u0015:pIV\u001cWM]\"p]N,X.\u001a:Pm\u0016\u0014(/\u001b3f+:$\bN]8ui2,G\rK\u0002\u001b\u0003O\ta\u0005^3tiB\u0013x\u000eZ;dKJ\u001cuN\\:v[\u0016\u0014xJ^3se&$W\rT8xKJ\fVo\u001c;bQ\rY\u0012qE\u0001\u0018i\u0016\u001cH/U;pi\u0006|e/\u001a:sS\u0012,G)\u001a7fi\u0016D3\u0001HA\u0014\u0003Q!Xm\u001d;UQJ|G\u000f\u001e7fIJ+\u0017/^3ti\"\u001aQ$a\n")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int brokerCount;
    private final long defaultProducerQuota;
    private final long defaultConsumerQuota;
    private final double defaultRequestQuota;
    private final String topic1;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private QuotaTestClients quotaTestClients;

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String producerClientId() {
        return "QuotasTestProducer-1";
    }

    public String consumerClientId() {
        return "QuotasTestConsumer-1";
    }

    public abstract QuotaTestClients createQuotaTestClients(String var1, KafkaServer var2);

    public long defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public long defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public double defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public String topic1() {
        return this.topic1;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    public QuotaTestClients quotaTestClients() {
        return this.quotaTestClients;
    }

    public void quotaTestClients_$eq(QuotaTestClients x$1) {
        this.quotaTestClients = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        int numPartitions = 1;
        Map<Object, Object> leaders = this.createTopic(this.topic1(), numPartitions, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.quotaTestClients_$eq(this.createQuotaTestClients(this.topic1(), this.leaderNode()));
    }

    @Test
    public void testThrottledProducerConsumer() {
        int numRecords = 1000;
        QuotaTestClients qual$1 = this.quotaTestClients();
        boolean x$2 = qual$1.produceUntilThrottled$default$2();
        int produced = qual$1.produceUntilThrottled(numRecords, x$2);
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$3 = true;
        boolean x$4 = qual$2.verifyProduceThrottle$default$2();
        boolean x$5 = qual$2.verifyProduceThrottle$default$3();
        qual$2.verifyProduceThrottle(x$3, x$4, x$5);
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = qual$3.consumeUntilThrottled$default$2();
        Assertions.assertTrue((qual$3.consumeUntilThrottled(produced, x$7) > 0 ? 1 : 0) != 0, (String)"Should have consumed at least one record");
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$8 = true;
        boolean x$9 = qual$4.verifyConsumeThrottle$default$2();
        boolean x$10 = qual$4.verifyConsumeThrottle$default$3();
        qual$4.verifyConsumeThrottle(x$8, x$9, x$10);
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put("producer_byte_rate", Long.toString(Long.MAX_VALUE));
        props.put("consumer_byte_rate", Long.toString(Long.MAX_VALUE));
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = Long.MAX_VALUE;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$2.produceUntilThrottled(numRecords, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = false;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        boolean x$9 = qual$3.verifyProduceThrottle$default$3();
        qual$3.verifyProduceThrottle(x$7, x$8, x$9);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$11 = qual$4.consumeUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$4.consumeUntilThrottled(numRecords, x$11));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$12 = false;
        boolean x$13 = qual$5.verifyConsumeThrottle$default$2();
        boolean x$14 = qual$5.verifyConsumeThrottle$default$3();
        qual$5.verifyConsumeThrottle(x$12, x$13, x$14);
    }

    @Test
    public void testProducerConsumerOverrideLowerQuota() {
        this.quotaTestClients().overrideQuotas(2000L, 250L, Long.MAX_VALUE);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = 2000L;
        long x$2 = 250L;
        double x$3 = Long.MAX_VALUE;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        int produced = qual$2.produceUntilThrottled(numRecords, x$6);
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = true;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        boolean x$9 = qual$3.verifyProduceThrottle$default$3();
        qual$3.verifyProduceThrottle(x$7, x$8, x$9);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$11 = qual$4.consumeUntilThrottled$default$2();
        Assertions.assertTrue((qual$4.consumeUntilThrottled(produced, x$11) > 0 ? 1 : 0) != 0, (String)"Should have consumed at least one record");
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$12 = true;
        boolean x$13 = qual$5.verifyConsumeThrottle$default$2();
        boolean x$14 = qual$5.verifyConsumeThrottle$default$3();
        qual$5.verifyConsumeThrottle(x$12, x$13, x$14);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = Long.MAX_VALUE;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$2.produceUntilThrottled(numRecords, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = false;
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        boolean x$9 = qual$3.verifyProduceThrottle$default$3();
        qual$3.verifyProduceThrottle(x$7, x$8, x$9);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$11 = qual$4.consumeUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$4.consumeUntilThrottled(numRecords, x$11));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$12 = false;
        boolean x$13 = qual$5.verifyConsumeThrottle$default$2();
        boolean x$14 = qual$5.verifyConsumeThrottle$default$3();
        qual$5.verifyConsumeThrottle(x$12, x$13, x$14);
        this.quotaTestClients().removeQuotaOverrides();
        QuotaTestClients qual$6 = this.quotaTestClients();
        long x$15 = this.defaultProducerQuota();
        long x$16 = this.defaultConsumerQuota();
        double x$17 = this.defaultRequestQuota();
        KafkaServer x$18 = qual$6.waitForQuotaUpdate$default$4();
        qual$6.waitForQuotaUpdate(x$15, x$16, x$17, x$18);
        QuotaTestClients qual$7 = this.quotaTestClients();
        boolean x$20 = qual$7.produceUntilThrottled$default$2();
        int produced = qual$7.produceUntilThrottled(numRecords, x$20);
        QuotaTestClients qual$8 = this.quotaTestClients();
        boolean x$21 = true;
        boolean x$22 = qual$8.verifyProduceThrottle$default$2();
        boolean x$23 = qual$8.verifyProduceThrottle$default$3();
        qual$8.verifyProduceThrottle(x$21, x$22, x$23);
        this.quotaTestClients().consumer().seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        QuotaTestClients qual$9 = this.quotaTestClients();
        int x$24 = numRecords + produced;
        boolean x$25 = qual$9.consumeUntilThrottled$default$2();
        qual$9.consumeUntilThrottled(x$24, x$25);
        QuotaTestClients qual$10 = this.quotaTestClients();
        boolean x$26 = true;
        boolean x$27 = qual$10.verifyConsumeThrottle$default$2();
        boolean x$28 = qual$10.verifyConsumeThrottle$default$3();
        qual$10.verifyConsumeThrottle(x$26, x$27, x$28);
    }

    @Test
    public void testThrottledRequest() {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 0.1);
        QuotaTestClients qual$1 = this.quotaTestClients();
        long x$1 = Long.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        double x$3 = 0.1;
        KafkaServer x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(x$1, x$2, x$3, x$4);
        KafkaConsumer<byte[], byte[]> consumer = this.quotaTestClients().consumer();
        consumer.subscribe(Collections.singleton(this.topic1()));
        long endTimeMs = System.currentTimeMillis() + 10000L;
        boolean throttled = false;
        while (!(throttled && this.quotaTestClients().exemptRequestMetric() != null || System.currentTimeMillis() >= endTimeMs)) {
            consumer.poll(Duration.ofMillis(100L));
            KafkaMetric throttleMetric = this.quotaTestClients().throttleMetric((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
            throttled = throttleMetric != null && QuotaTestClients$.MODULE$.metricValue((Metric)throttleMetric) > 0.0;
        }
        Assertions.assertTrue((boolean)throttled, (String)"Should have been throttled");
        this.quotaTestClients().verifyConsumerClientThrottleTimeMetric(true, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)((double)Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds() * 1000.0))));
        KafkaMetric exemptMetric = this.quotaTestClients().exemptRequestMetric();
        Assertions.assertNotNull((Object)exemptMetric, (String)"Exempt requests not recorded");
        Assertions.assertTrue((QuotaTestClients$.MODULE$.metricValue((Metric)exemptMetric) > 0.0 ? 1 : 0) != 0, (String)"Exempt requests not recorded");
    }

    public BaseQuotaTest() {
        this.brokerCount = 2;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), "4");
        this.producerConfig().setProperty("acks", "1");
        this.producerConfig().setProperty("enable.idempotence", "false");
        this.producerConfig().setProperty("buffer.memory", "300000");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(4096));
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 4000L;
        this.defaultConsumerQuota = 1250L;
        this.defaultRequestQuota = Long.MAX_VALUE;
        this.topic1 = "topic-1";
    }
}

