/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.RackAwareMode;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$callback$1$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.controller.ReplicaAssignment;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-h!B\u0012%\u0003\u0003I\u0003\"\u0002\u0019\u0001\t\u0003\t\u0004\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0003#\u0001\u0001\u0004\u0005\r\u0011\"\u0003F\u0011%I\u0006\u00011AA\u0002\u0013%!\fC\u0005a\u0001\u0001\u0007\t\u0011)Q\u0005\r\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007BB8\u0001A\u0003%1\rC\u0004q\u0001\t\u0007I\u0011C9\t\ri\u0004\u0001\u0015!\u0003s\u0011\u001dY\bA1A\u0005\nqDq!!\u0001\u0001A\u0003%Q\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011\u0011\u0007\u0001\u0005\u0012\u0005M\u0002\"CA4\u0001E\u0005I\u0011CA5\u0011%\ty\bAI\u0001\n#\tI\u0007C\u0005\u0002\u0002\u0002\t\n\u0011\"\u0005\u0002j!I\u00111\u0011\u0001\u0012\u0002\u0013E\u0011Q\u0011\u0005\n\u0003\u0013\u0003\u0011\u0013!C\t\u0003\u0017C\u0011\"a$\u0001#\u0003%\t\"a#\t\u000f\u0005E\u0005\u0001\"\u0005\u0002\u0014\"9\u0011q\u0013\u0001\u0005\u0002\u0005\u001d\u0002bBAQ\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003K\u0003A\u0011AA\u0014\u0011\u001d\tI\u000b\u0001C\t\u0003WC\u0011\"!.\u0001#\u0003%\t\"!\u001b\t\u0013\u0005]\u0006!%A\u0005\u0012\u0005-\u0005bBA]\u0001\u0011E\u00111\u0018\u0005\b\u0003'\u0004A\u0011AA\u0014\u0011\u001d\t9\u000e\u0001C\u0001\u0003OAq!a7\u0001\t\u0003\t9\u0003C\u0004\u0002`\u0002!\t!a\n\t\u000f\u0005\r\b\u0001\"\u0001\u0002(!9\u0011q\u001d\u0001\u0005\u0002\u0005\u001d\"\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002&M\u0005\u0019\u0011\r]5\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\u0011QFJ\u0001\fS:$Xm\u001a:bi&|g.\u0003\u00020Y\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002I\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u00017!\r9DHP\u0007\u0002q)\u0011\u0011HO\u0001\u000bG>dG.Z2uS>t'\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uB$aA*fcB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IJ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\r\u0003%aC&bM.\f7i\u001c8gS\u001e\f\u0001bY8ogVlWM]\u000b\u0002\rB!q\t\u0015*S\u001b\u0005A%B\u0001#J\u0015\tQ5*A\u0004dY&,g\u000e^:\u000b\u0005\u001db%BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001eL!!\u0015%\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\r\u0019FKV\u0007\u0002u%\u0011QK\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003'^K!\u0001\u0017\u001e\u0003\t\tKH/Z\u0001\rG>t7/^7fe~#S-\u001d\u000b\u00037z\u0003\"a\u0015/\n\u0005uS$\u0001B+oSRDqa\u0018\u0003\u0002\u0002\u0003\u0007a)A\u0002yIE\n\u0011bY8ogVlWM\u001d\u0011\u0002\u0013A\u0014x\u000eZ;dKJ\u001cX#A2\u0011\u0007\u0011<\u0017.D\u0001f\u0015\t1\u0007(A\u0004nkR\f'\r\\3\n\u0005!,'A\u0002\"vM\u001a,'\u000f\u0005\u0003k[J\u0013V\"A6\u000b\u00051L\u0015\u0001\u00039s_\u0012,8-\u001a:\n\u00059\\'!D&bM.\f\u0007K]8ek\u000e,'/\u0001\u0006qe>$WoY3sg\u0002\nQ\u0001^8qS\u000e,\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fA\u0001\\1oO*\tq/\u0001\u0003kCZ\f\u0017BA=u\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n!B\\;n%\u0016\u001cwN\u001d3t+\u0005i\bCA*\u007f\u0013\ty(HA\u0002J]R\f1B\\;n%\u0016\u001cwN\u001d3tA\u0005)1/\u001a;VaR\u00191,a\u0002\t\u000f\u0005%A\u00021\u0001\u0002\f\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002\u000e\u0005eQBAA\b\u0015\r)\u0013\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005]a*A\u0003kk:LG/\u0003\u0003\u0002\u001c\u0005=!\u0001\u0003+fgRLeNZ8)\u00071\ty\u0002\u0005\u0003\u0002\u000e\u0005\u0005\u0012\u0002BA\u0012\u0003\u001f\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#A.)\u00075\tY\u0003\u0005\u0003\u0002\u000e\u00055\u0012\u0002BA\u0018\u0003\u001f\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u001d\r\u0014X-\u0019;f!J|G-^2feRi\u0011.!\u000e\u0002:\u0005u\u0012\u0011IA-\u0003GB\u0001\"a\u000e\u000f!\u0003\u0005\r!`\u0001\tY&tw-\u001a:Ng\"A\u00111\b\b\u0011\u0002\u0003\u0007Q0A\teK2Lg/\u001a:z)&lWm\\;u\u001bND\u0001\"a\u0010\u000f!\u0003\u0005\r!`\u0001\nE\u0006$8\r[*ju\u0016D\u0011\"a\u0011\u000f!\u0003\u0005\r!!\u0012\u0002\u001f\r|W\u000e\u001d:fgNLwN\u001c+za\u0016\u0004B!a\u0012\u0002V9!\u0011\u0011JA)!\r\tYEO\u0007\u0003\u0003\u001bR1!a\u0014)\u0003\u0019a$o\\8u}%\u0019\u00111\u000b\u001e\u0002\rA\u0013X\rZ3g\u0013\rI\u0018q\u000b\u0006\u0004\u0003'R\u0004\"CA.\u001dA\u0005\t\u0019AA/\u0003)i\u0017\r\u001f\"m_\u000e\\Wj\u001d\t\u0004'\u0006}\u0013bAA1u\t!Aj\u001c8h\u0011%\t)G\u0004I\u0001\u0002\u0004\ti&\u0001\u0006ck\u001a4WM]*ju\u0016\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tYGK\u0002~\u0003[Z#!a\u001c\u0011\t\u0005E\u00141P\u0007\u0003\u0003gRA!!\u001e\u0002x\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003sR\u0014AC1o]>$\u0018\r^5p]&!\u0011QPA:\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u001d%\u0006BA#\u0003[\n\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tiI\u000b\u0003\u0002^\u00055\u0014\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005\u0001\"/Z4jgR,'\u000f\u0015:pIV\u001cWM\u001d\u000b\u0004S\u0006U\u0005\"\u00027\u0016\u0001\u0004I\u0017A\u0004;fgR\u001cVM\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004-\u0005m\u0005\u0003BA\u0007\u0003;KA!a(\u0002\u0010\t!A+Z:u\u0003\u001d\"Xm\u001d;TK:$7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3XSRD7I]3bi\u0016$\u0016.\\3)\u0007]\tY*\u0001\u0016uKN$8+\u001a8e\u001d>t7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3XSRD7I]3bi\u0016$\u0016.\\3)\u0007a\tY*A\u0007tK:$\u0017I\u001c3WKJLg-\u001f\u000b\b7\u00065\u0016qVAY\u0011\u0015a\u0017\u00041\u0001j\u0011\u001dY\u0018\u0004%AA\u0002uD\u0011\"a-\u001a!\u0003\u0005\r!!\u0018\u0002\u0013QLW.Z8vi6\u001b\u0018aF:f]\u0012\fe\u000e\u001a,fe&4\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003]\u0019XM\u001c3B]\u00124VM]5gs\u0012\"WMZ1vYR$3'\u0001\ftK:$\u0017I\u001c3WKJLg-\u001f+j[\u0016\u001cH/Y7q)\u0015Y\u0016QXA`\u0011\u0015aG\u00041\u0001j\u0011\u001d\t\t\r\ba\u0001\u0003\u0007\fQ\u0002^5nKN$\u0018-\u001c9UsB,\u0007\u0003BAc\u0003\u001fl!!a2\u000b\t\u0005%\u00171Z\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0007\u000557*\u0001\u0004d_6lwN\\\u0005\u0005\u0003#\f9MA\u0007US6,7\u000f^1naRK\b/Z\u0001\ni\u0016\u001cHo\u00117pg\u0016D3!HAN\u0003M!Xm\u001d;TK:$Gk\u001c)beRLG/[8oQ\rq\u00121T\u0001)i\u0016\u001cHoU3oI\n+gm\u001c:f\u0003:$\u0017I\u001a;feB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\u001c\u0015\u0004?\u0005m\u0015!\u0003;fgR4E.^:iQ\r\u0001\u00131T\u0001)i\u0016\u001cHo\u00117pg\u0016<\u0016\u000e\u001e5[KJ|G+[7f_V$hI]8n\u0007\u0006dG.\u001a:UQJ,\u0017\r\u001a\u0015\u0004C\u0005m\u0015\u0001\u000b;fgR\u001cEn\\:f/&$\bNW3s_RKW.Z8vi\u001a\u0013x.\\*f]\u0012,'\u000f\u00165sK\u0006$\u0007f\u0001\u0012\u0002\u001c\u0002")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(4));
        String x$2 = this.zkConnect();
        boolean x$3 = false;
        Some x$4 = new Some((Object)this.securityProtocol());
        Option<File> x$5 = this.trustStoreFile();
        Option<Properties> x$6 = this.serverSaslProperties();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$17();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(numServers, x$2, x$3, x$7, (Option<SecurityProtocol>)x$4, x$5, x$6, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, overridingProps), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        String x$1 = this.bootstrapServers(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        String x$3 = TestUtils$.MODULE$.createConsumer$default$2();
        Option<String> x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        String x$5 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$6 = TestUtils$.MODULE$.createConsumer$default$5();
        boolean x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        int x$8 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        Option<Properties> x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        ByteArrayDeserializer x$12 = TestUtils$.MODULE$.createConsumer$default$12();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10, x$11, x$12));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.consumer().close();
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(int lingerMs, int deliveryTimeoutMs, int batchSize, String compressionType, long maxBlockMs, long bufferSize) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$3 = this.securityProtocol();
        Option<File> x$4 = this.trustStoreFile();
        Option<Properties> x$5 = this.clientSaslProperties();
        int x$11 = TestUtils$.MODULE$.createProducer$default$2();
        int x$12 = TestUtils$.MODULE$.createProducer$default$5();
        int x$13 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$11, maxBlockMs, bufferSize, x$12, deliveryTimeoutMs, lingerMs, batchSize, compressionType, x$13, x$3, x$4, x$5, x$14, x$15, x$16);
        return this.registerProducer(producer);
    }

    public int createProducer$default$1() {
        return 0;
    }

    public int createProducer$default$2() {
        return 120000;
    }

    public int createProducer$default$3() {
        return 16384;
    }

    public String createProducer$default$4() {
        return "none";
    }

    public long createProducer$default$5() {
        return 60000L;
    }

    public long createProducer$default$6() {
        return 0x100000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    @Test
    public void testSendOffset() {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4(), this.createTopic$default$5());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 0");
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assertions.assertEquals((long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 1");
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 2");
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 3");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0, (Callback)this.callback$2(callback$module, partition)));
            Assertions.assertEquals((long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords() + 4).toString());
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        String x$1 = "gzip";
        int x$2 = Integer.MAX_VALUE;
        int x$3 = Integer.MAX_VALUE;
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$1, x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4(), this.createTopic$default$5());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerify$1(this, partition, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(Duration.ofMillis(timeoutMs));
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)BaseProducerSendTest.$anonfun$sendAndVerify$2(this, partition, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
            } else {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            }
            this.createTopic(this.topic(), 1, 2, topicProps, this.createTopic$default$5());
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1(this, partition, baseTimestamp, producer, callback$module, timestampType, startTime, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(Duration.ofSeconds(20L));
            recordAndFutures.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$2(timestampType, startTime, x0$1);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset(), (String)new StringBuilder(47).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).append(" but only successfully sent ").append(this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset()).toString());
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testClose() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4(), this.createTopic$default$5());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)_ -> producer.send(record0));
            Future response0 = producer.send(record0);
            producer.close();
            Assertions.assertTrue((boolean)response0.isDone(), (String)"The last message should be acked before producer is shutdown");
            Assertions.assertEquals((long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset(), (String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).toString());
        }
    }

    @Test
    public void testSendToPartition() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4(), this.createTopic$default$5());
            int partition = 1;
            long now = System.currentTimeMillis();
            ((TraversableLike)((IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), Predef$.MODULE$.long2Long(now), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$4(this, partition, x$4);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
            ((IterableLike)TestUtils$.MODULE$.consumeRecords(this.consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.consumeRecords$default$3()).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$5(this, partition, now, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        long x$1 = 5000L;
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$52 = this.createProducer$default$4();
        long x$62 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$52, x$1, x$62);
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4(), this.createTopic$default$5());
        int partition0 = 0;
        ((TraversableLike)((IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> (RecordMetadata)x$5.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$4(this, partition0, x$6);
            return BoxedUnit.UNIT;
        });
        int partition1 = 1;
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get());
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ReplicaAssignment assignment = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)assignment);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        AdminZkClient qual$1 = this.adminZkClient();
        String x$92 = this.topic();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$72 = qual$2.getBrokerMetadatas$default$1();
        Option x$82 = qual$2.getBrokerMetadatas$default$2();
        Seq x$11 = qual$2.getBrokerMetadatas(x$72, x$82);
        int x$12 = 2;
        Option x$13 = qual$1.addPartitions$default$5();
        boolean x$14 = qual$1.addPartitions$default$6();
        Option x$15 = qual$1.addPartitions$default$7();
        Option x$16 = qual$1.addPartitions$default$8();
        qual$1.addPartitions(x$92, existingAssignment, x$11, x$12, x$13, x$14, x$15, x$16);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        ((TraversableLike)((IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> (RecordMetadata)x$7.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$10(this, partition1, x$8);
            return BoxedUnit.UNIT;
        });
        ((TraversableLike)((IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8))), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> (RecordMetadata)x$9.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$14(this, partition0, x$10);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFlush() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4(), this.createTopic$default$5());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$11 -> producer.send(record), IndexedSeq$.MODULE$.canBuildFrom());
                Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testFlush$3(x$12))), (String)"No request is complete.");
                producer.flush();
                Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDone())), (String)"All requests are complete.");
            });
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        this.createTopic(this.topic(), 2, 2, this.createTopic$default$4(), this.createTopic$default$5());
        int partition = 0;
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$14 -> producer.send(record0), IndexedSeq$.MODULE$.canBuildFrom());
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$3(x$15))), (String)"No request is complete.");
            producer.close(Duration.ZERO);
            responses.foreach((Function1 & Serializable & scala.Serializable)future -> {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$4(future);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((int)0, (int)this.consumer().poll(Duration.ofMillis(50L)).count(), (String)"Fetch response should have no message returned.");
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4(), this.createTopic$default$5());
        int partition = 0;
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1(this, record, BoxesRunTime.unboxToInt((Object)i)));
    }

    private final /* synthetic */ BaseProducerSendTest$callback$1$ callback$lzycompute$1(LazyRef callback$module$1, int partition$1) {
        synchronized (callback$module$1) {
            BaseProducerSendTest$callback$1$ baseProducerSendTest$callback$1$ = callback$module$1.initialized() ? (BaseProducerSendTest$callback$1$)callback$module$1.value() : (BaseProducerSendTest$callback$1$)callback$module$1.initialize((Object)new BaseProducerSendTest$callback$1$(this, partition$1));
            return baseProducerSendTest$callback$1$;
        }
    }

    private final BaseProducerSendTest$callback$1$ callback$2(LazyRef callback$module$1, int partition$1) {
        if (callback$module$1.initialized()) {
            return (BaseProducerSendTest$callback$1$)callback$module$1.value();
        }
        return this.callback$lzycompute$1(callback$module$1, partition$1);
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1(BaseProducerSendTest $this, int partition$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$2), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$sendAndVerify$2(BaseProducerSendTest $this, int partition$2, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)partition$2, (int)recordMetadata.partition());
        Assertions.assertEquals((long)offset, (long)recordMetadata.offset());
        return offset + 1;
    }

    private final /* synthetic */ BaseProducerSendTest$callback$3$ callback$lzycompute$2(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        synchronized (callback$module$2) {
            BaseProducerSendTest$callback$3$ baseProducerSendTest$callback$3$ = callback$module$2.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$2.value() : (BaseProducerSendTest$callback$3$)callback$module$2.initialize((Object)new BaseProducerSendTest$callback$3$(this, timestampType$1, baseTimestamp$1, startTime$1, partition$3));
            return baseProducerSendTest$callback$3$;
        }
    }

    private final BaseProducerSendTest$callback$3$ callback$4(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        if (callback$module$2.initialized()) {
            return (BaseProducerSendTest$callback$3$)callback$module$2.value();
        }
        return this.callback$lzycompute$2(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3);
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1(BaseProducerSendTest $this, int partition$3, long baseTimestamp$1, KafkaProducer producer$3, LazyRef callback$module$2, TimestampType timestampType$1, long startTime$1, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$3), Predef$.MODULE$.long2Long(baseTimestamp$1 + (long)i), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return new Tuple2((Object)record, (Object)producer$3.send(record, (Callback)$this.callback$4(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3)));
    }

    public static final /* synthetic */ void $anonfun$sendAndVerifyTimestamp$2(TimestampType timestampType$1, long startTime$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ProducerRecord record = (ProducerRecord)x0$1._1();
            RecordMetadata recordMetadata = (RecordMetadata)((Future)x0$1._2()).get();
            TimestampType timestampType = timestampType$1;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assertions.assertTrue((recordMetadata.timestamp() >= startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                return;
            }
            Assertions.assertEquals((Long)record.timestamp(), (long)recordMetadata.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$4(BaseProducerSendTest $this, int partition$4, Tuple2 x$4) {
        if (x$4 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$4._1();
            Assertions.assertEquals((long)x$4._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition$4, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$5(BaseProducerSendTest $this, int partition$4, long now$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assertions.assertEquals((Object)$this.topic(), (Object)record.topic());
            Assertions.assertEquals((int)partition$4, (int)record.partition());
            Assertions.assertEquals((long)i, (long)record.offset());
            Assertions.assertNull((Object)record.key());
            Assertions.assertEquals((Object)new StringBuilder(5).append("value").append(i + 1).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((long)now$1, (long)record.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$4(BaseProducerSendTest $this, int partition0$1, Tuple2 x$6) {
        if (x$6 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$6._1();
            Assertions.assertEquals((long)x$6._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition0$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$10(BaseProducerSendTest $this, int partition1$1, Tuple2 x$8) {
        if (x$8 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$8._1();
            Assertions.assertEquals((long)x$8._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition1$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$14(BaseProducerSendTest $this, int partition0$1, Tuple2 x$10) {
        if (x$10 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$10._1();
            Assertions.assertEquals((long)x$10._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition0$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFlush$3(Future x$12) {
        return !x$12.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromCallerThread$3(Future x$15) {
        return !x$15.isDone();
    }

    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$4(Future future) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get());
        Assertions.assertEquals(KafkaException.class, e.getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2(BaseProducerSendTest $this, KafkaProducer producer$9, ProducerRecord record$2, int i) {
        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
        implements Callback {
            private final KafkaProducer<byte[], byte[]> producer;
            private final boolean sendRecords;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final ProducerRecord record$2;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (this.sendRecords) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1(this, BoxesRunTime.unboxToInt((Object)x$16)));
                }
                this.producer.close(Duration.ZERO);
                this.producer.close();
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, int x$16) {
                return $this.producer.send($this.record$2);
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_api_BaseProducerSendTest$CloseCallback$1(KafkaProducer<byte[], byte[]> producer, boolean sendRecords) {
                void var4_4;
                this.producer = producer;
                this.sendRecords = sendRecords;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = var4_4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onCompletion$1$adapted(kafka.api.BaseProducerSendTest$CloseCallback$1 java.lang.Object )}, serializedLambda);
            }
        }
        return producer$9.send(record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1($this, producer$9, i == 0, record$2));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromSenderThread$3(Future x$17) {
        return !x$17.isDone();
    }

    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1(BaseProducerSendTest $this, ProducerRecord record$2, int i2) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        try (KafkaProducer<byte[], byte[]> producer = $this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, $this.createProducer$default$3(), $this.createProducer$default$4(), $this.createProducer$default$5(), $this.createProducer$default$6());){
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, producer, record$2, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$3(x$17))), (String)"No request is complete.");
            producer.flush();
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isDone())), (String)"All requests are complete.");
            seq = TestUtils$.MODULE$.pollUntilAtLeastNumRecords($this.consumer(), $this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        }
        return seq;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

