/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import kafka.admin.LeaderElectionCommand$;
import kafka.admin.LeaderElectionCommandTest$;
import kafka.common.AdminCommandFailedException;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Console$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.BOTH, brokers=3)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001\u0002\f\u0018\u0005qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006U\u0001!\ta\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019!\u0004\u0001)A\u0005c!9Q\u0007\u0001b\u0001\n\u0003\u0001\u0004B\u0002\u001c\u0001A\u0003%\u0011\u0007C\u00048\u0001\t\u0007I\u0011\u0001\u0019\t\ra\u0002\u0001\u0015!\u00032\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015I\u0006\u0001\"\u0001R\u0011\u0015y\u0006\u0001\"\u0001R\u0011\u0015\u0011\u0007\u0001\"\u0001R\u0011\u0015)\u0007\u0001\"\u0001R\u0011\u00159\u0007\u0001\"\u0001R\u000f\u001d\t)b\u0006E\u0001\u0003/1aAF\f\t\u0002\u0005e\u0001B\u0002\u0016\u0012\t\u0003\tY\u0002C\u0004\u0002\u001eE!\t!a\b\t\u000f\u0005=\u0014\u0003\"\u0001\u0002r!9\u0011QO\t\u0005\u0002\u0005]$!\u0007'fC\u0012,'/\u00127fGRLwN\\\"p[6\fg\u000e\u001a+fgRT!\u0001G\r\u0002\u000b\u0005$W.\u001b8\u000b\u0003i\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\fqa\u00197vgR,'\u000f\u0005\u0002&Q5\taE\u0003\u0002(3\u0005!A/Z:u\u0013\tIcEA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011AF\f\t\u0003[\u0001i\u0011a\u0006\u0005\u0006G\t\u0001\r\u0001J\u0001\bEJ|7.\u001a:2+\u0005\t\u0004C\u0001\u00103\u0013\t\u0019tDA\u0002J]R\f\u0001B\u0019:pW\u0016\u0014\u0018\u0007I\u0001\bEJ|7.\u001a:3\u0003!\u0011'o\\6feJ\u0002\u0013a\u00022s_.,'oM\u0001\tEJ|7.\u001a:4A\u0005)1/\u001a;vaR\u00111H\u0010\t\u0003=qJ!!P\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007f%\u0001\r\u0001Q\u0001\u000eG2,8\u000f^3s\u0007>tg-[4\u0011\u0005\u0015\n\u0015B\u0001\"'\u00055\u0019E.^:uKJ\u001cuN\u001c4jO\"\u0012\u0011\u0002\u0012\t\u0003\u000b:k\u0011A\u0012\u0006\u0003\u000f\"\u000b1!\u00199j\u0015\tI%*A\u0004kkBLG/\u001a:\u000b\u0005-c\u0015!\u00026v]&$(\"A'\u0002\u0007=\u0014x-\u0003\u0002P\r\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002+Q,7\u000f^!mYR{\u0007/[2QCJ$\u0018\u000e^5p]R\t1\b\u000b\u0002\u000b'B\u0011AkV\u0007\u0002+*\u0011aKJ\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001-V\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002%Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0015\u0003\u0017m\u0003\"!\u0012/\n\u0005u3%\u0001\u0003#jg\u0006\u0014G.\u001a3)\u0005-\u0019\u0016A\u0005;fgR\u0004\u0016\r\u001e5U_*\u001bxN\u001c$jY\u0016D#\u0001D.)\u00051\u0019\u0016\u0001\b;fgR\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017-\u00127fGRLwN\u001c\u0015\u0003\u001bmC#!D*\u0002+Q,7\u000f\u001e+pa&\u001cGi\\3t\u001d>$X\t_5ti\"\u0012abU\u0001\u0019i\u0016\u001cH/\u00127fGRLwN\u001c*fgVdGoT;uaV$\bFA\bTQ\u0011\u0001!.\u001c8\u0011\u0005\u0015[\u0017B\u00017G\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0002_\u0006Y\u0011N\u001c;fOJ\fG/[8oQ\u0019\u0001\u0011\u000f^;{wB\u0011AK]\u0005\u0003gV\u00131c\u00117vgR,'\u000fV3ti\u0012+g-Y;miN\f1b\u00197vgR,'\u000fV=qK\u0012\na/\u0003\u0002xq\u0006!!i\u0014+I\u0015\tIX+\u0001\u0003UsB,\u0017a\u00022s_.,'o]\u000f\u0002\u0007!*\u0001!`7\u0002\bA\u0019a0a\u0001\u000e\u0003}T1!!\u0001G\u0003%)\u0007\u0010^3og&|g.C\u0002\u0002\u0006}\u0014!\"\u0012=uK:$w+\u001b;iY\t\tIa\t\u0002\u0002\fA!\u0011QBA\t\u001b\t\tyA\u0003\u0002LM%!\u00111CA\b\u0005U\u0019E.^:uKJ$Vm\u001d;FqR,gn]5p]N\f\u0011\u0004T3bI\u0016\u0014X\t\\3di&|gnQ8n[\u0006tG\rV3tiB\u0011Q&E\n\u0003#u!\"!a\u0006\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\t\u0005\u0005\u0012Q\n\t\t\u0003G\t\t$a\u000e\u0002>9!\u0011QEA\u0017!\r\t9cH\u0007\u0003\u0003SQ1!a\u000b\u001c\u0003\u0019a$o\\8u}%\u0019\u0011qF\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019$!\u000e\u0003\u00075\u000b\u0007OC\u0002\u00020}\u0001B!a\t\u0002:%!\u00111HA\u001b\u0005\u0019\u0019FO]5oOB!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001\u00027b]\u001eT!!a\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\n\tE\u0001\u0004PE*,7\r\u001e\u0005\b\u0003\u001f\u001a\u0002\u0019AA)\u0003\u001d\u0019XM\u001d<feN\u0004b!a\u0015\u0002^\u0005\rd\u0002BA+\u00033rA!a\n\u0002X%\t\u0001%C\u0002\u0002\\}\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002`\u0005\u0005$aA*fc*\u0019\u00111L\u0010\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001b\u001a\u0003\u0019\u0019XM\u001d<fe&!\u0011QNA4\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001cH\u0003BA\u001c\u0003gBq!a\u0014\u0015\u0001\u0004\t\t&\u0001\fuK6\u0004Hk\u001c9jGB\u000b'\u000f^5uS>tg)\u001b7f)\u0011\tI(!#\u0011\t\u0005m\u0014QQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006!a-\u001b7f\u0015\u0011\t\u0019)!\u0012\u0002\u00079Lw.\u0003\u0003\u0002\b\u0006u$\u0001\u0002)bi\"Dq!a#\u0016\u0001\u0004\ti)\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!a\t\u0002\u0010\u0006M\u0015\u0002BAI\u0003k\u00111aU3u!\u0011\t)*!)\u000e\u0005\u0005]%\u0002BAM\u00037\u000baaY8n[>t'b\u0001\u000e\u0002\u001e*\u0019\u0011q\u0014'\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\u0019+a&\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0002")
public final class LeaderElectionCommandTest {
    private final ClusterInstance cluster;
    private final int broker1;
    private final int broker2;
    private final int broker3;

    public static Path tempTopicPartitionFile(Set<TopicPartition> set) {
        return LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile(set);
    }

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.bootstrapServers(seq);
    }

    public static Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.createConfig(seq);
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    @BeforeEach
    public void setup(ClusterConfig clusterConfig) {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeEach");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
    }

    @ClusterTest
    public void testAllTopicPartition() {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))));
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
        this.cluster.shutdownBroker(this.broker3());
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker3()}))));
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertNoLeader(client, topicPartition);
        this.cluster.startBroker(this.broker3());
        TestUtils$.MODULE$.waitForOnlineBroker(client, this.broker3());
        LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--all-topic-partitions"}));
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker3());
    }

    @ClusterTest
    @Disabled
    public void testTopicPartition() {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))));
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
        this.cluster.shutdownBroker(this.broker3());
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker3()}))));
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertNoLeader(client, topicPartition);
        this.cluster.startBroker(this.broker3());
        TestUtils$.MODULE$.waitForOnlineBroker(client, this.broker3());
        LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--topic", topic, "--partition", Integer.toString(partition)}));
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker3());
    }

    @ClusterTest
    @Disabled
    public void testPathToJsonFile() {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))));
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
        this.cluster.shutdownBroker(this.broker3());
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker3()}))));
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertNoLeader(client, topicPartition);
        this.cluster.startBroker(this.broker3());
        TestUtils$.MODULE$.waitForOnlineBroker(client, this.broker3());
        Path topicPartitionPath = LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile((Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--path-to-json-file", ((Object)topicPartitionPath).toString()}));
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker3());
    }

    @ClusterTest
    @Disabled
    public void testPreferredReplicaElection() {
        String topic = "preferred-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))));
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker3());
        this.cluster.startBroker(this.broker2());
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2()}))));
        LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "preferred", "--all-topic-partitions"}));
        TestUtils$.MODULE$.assertLeader(client, topicPartition, this.broker2());
    }

    @ClusterTest
    public void testTopicDoesNotExist() {
        Assertions.assertTrue((boolean)(((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "--election-type", "preferred", "--topic", "unknown-topic-name", "--partition", "0"})))).getSuppressed()[0] instanceof UnknownTopicOrPartitionException));
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testElectionResultOutput() {
        String topic = "non-preferred-topic";
        int partition0 = 0;
        int partition1 = 1;
        Seq assignment0 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2(), this.broker3()}));
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker3(), this.broker2()}));
        this.cluster.waitForReadyBrokers();
        Admin client = this.cluster.createAdminClient();
        IntegrationTestUtils$.MODULE$.createTopic(client, topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition0)), (Object)assignment0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1)), (Object)assignment1)}))));
        TopicPartition topicPartition0 = new TopicPartition(topic, partition0);
        TopicPartition topicPartition1 = new TopicPartition(topic, partition1);
        TestUtils$.MODULE$.assertLeader(client, topicPartition0, this.broker2());
        TestUtils$.MODULE$.assertLeader(client, topicPartition1, this.broker3());
        this.cluster.shutdownBroker(this.broker2());
        TestUtils$.MODULE$.assertLeader(client, topicPartition0, this.broker3());
        this.cluster.startBroker(this.broker2());
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.broker2()}))));
        Path topicPartitionPath = LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile((Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition0, topicPartition1}))));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LeaderElectionCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "--election-type", "preferred", "--path-to-json-file", ((Object)topicPartitionPath).toString()}));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Iterator electionResultOutputIter = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split("\n"))).iterator();
        Assertions.assertTrue((boolean)electionResultOutputIter.hasNext());
        String firstLine = (String)electionResultOutputIter.next();
        Assertions.assertTrue((boolean)firstLine.contains(new StringBuilder(66).append("Successfully completed leader election (PREFERRED) for partitions ").append(topicPartition0).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(firstLine).toString());
        Assertions.assertTrue((boolean)electionResultOutputIter.hasNext());
        String secondLine = (String)electionResultOutputIter.next();
        Assertions.assertTrue((boolean)secondLine.contains(new StringBuilder(45).append("Valid replica already elected for partitions ").append(topicPartition1).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(secondLine).toString());
    }

    public LeaderElectionCommandTest(ClusterInstance cluster) {
        this.cluster = cluster;
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
    }
}

