/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Properties;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0016-\u0001=BQA\u000e\u0001\u0005\u0002]BQA\u000f\u0001\u0005\u0002mBQ\u0001\u0014\u0001\u0005\u0002mBQ!\u0015\u0001\u0005\u0002mBQA\u0016\u0001\u0005\u0002mBQ\u0001\u0017\u0001\u0005\u0002mBQA\u0017\u0001\u0005\u0002mBQ\u0001\u0018\u0001\u0005\u0002mBQA\u0018\u0001\u0005\u0002mBQ\u0001\u0019\u0001\u0005\u0002mBQA\u0019\u0001\u0005\u0002mBQ\u0001\u001a\u0001\u0005\n\u0015DQ\u0001\u001d\u0001\u0005\u0002mBQA\u001d\u0001\u0005\u0002mBq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001e\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u001d\t)\u0001\u0001Q\u0001\nqD\u0001\"a\u0002\u0001\u0005\u0004%Ia\u001f\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003}\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti\u0001\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\b\u0011\u0019\t\t\u0003\u0001C\u0001w!1\u0011Q\u0005\u0001\u0005\u0002mBa!!\u000b\u0001\t\u0003Y\u0004BBA\u0017\u0001\u0011\u00051\b\u0003\u0004\u00022\u0001!\ta\u000f\u0005\u0007\u0003k\u0001A\u0011A\u001e\t\r\u0005e\u0002\u0001\"\u0001<\u0011\u0019\ti\u0004\u0001C\u0001w!1\u0011\u0011\t\u0001\u0005\u0002mBa!!\u0012\u0001\t\u0003Y\u0004BBA%\u0001\u0011\u00051\b\u0003\u0004\u0002N\u0001!\ta\u000f\u0005\u0007\u0003#\u0002A\u0011A\u001e\t\r\u0005U\u0003\u0001\"\u0001<\u0011\u0019\tI\u0006\u0001C\u0001w!1\u0011Q\f\u0001\u0005\u0002mBq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0005\u0002L\u0002\t\n\u0011\"\u0003\u0002N\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\bbBAz\u0001\u0011\u0005\u0011Q\u001f\u0002\n\u0017\u000647.\u0019+fgRT\u0011!L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0002\"!\u000f\u0001\u000e\u00031\nQa]3u+B$\u0012\u0001\u0010\t\u0003cuJ!A\u0010\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0001\u0003\"!\u0011&\u000e\u0003\tS!a\u0011#\u0002\u0007\u0005\u0004\u0018N\u0003\u0002F\r\u00069!.\u001e9ji\u0016\u0014(BA$I\u0003\u0015QWO\\5u\u0015\u0005I\u0015aA8sO&\u00111J\u0011\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0005\rq\u0005CA!P\u0013\t\u0001&IA\u0005BMR,'/R1dQ\u0006QB/Z:u\u000f\u0016$8*\u00194lC\u000e{gNZ5h\rJ|W.\u0011:hg\"\u0012Aa\u0015\t\u0003\u0003RK!!\u0016\"\u0003\tQ+7\u000f^\u0001*i\u0016\u001cHoR3u\u0017\u000647.Y\"p]\u001aLwM\u0012:p[\u0006\u0013xm\u001d(p]\u0006\u0013xm]!u)\",WI\u001c3)\u0005\u0015\u0019\u0016!\n;fgR<U\r^&bM.\f7i\u001c8gS\u001e4%o\\7Be\u001e\u001chj\u001c8Be\u001e\u001cxJ\u001c7zQ\t11+A\u0017uKN$x)\u001a;LC\u001a\\\u0017mQ8oM&<gI]8n\u0003J<7OT8o\u0003J<7/\u0011;UQ\u0016\u0014UmZ4j]\u001eD#aB*\u0002=Q,7\u000f\u001e\"s_.,'OU8mK:{G-Z%e-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\u0005T\u0003\t\"Xm\u001d;D_:$(o\u001c7mKJ\u0014v\u000e\\3O_\u0012,\u0017\n\u001a,bY&$\u0017\r^5p]\"\u0012\u0011bU\u0001\"i\u0016\u001cHoQ8m_\u000e\fG/\u001a3S_2,gj\u001c3f\u0013\u00124\u0016\r\\5eCRLwN\u001c\u0015\u0003\u0015M\u000ba\u0006^3ti6+8\u000f^\"p]R\f\u0017N\\)v_J,XNV8uKJ\u001c\u0018JZ+tS:<\u0007K]8dKN\u001c(k\u001c7fg\"\u00121bU\u0001\u0011g\u0016$H*[:uK:,'\u000f\u0015:paN$\"\u0001\u00104\t\u000b\u001dd\u0001\u0019\u00015\u0002\u000bA\u0014x\u000e]:\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017\u0001B;uS2T\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pU\nQ\u0001K]8qKJ$\u0018.Z:\u0002+Q,7\u000f^&bM.\f7k\u001d7QCN\u001cxo\u001c:eg\"\u0012QbU\u0001!i\u0016\u001cHoS1gW\u0006\u001c6\u000f\u001c)bgN<xN\u001d3t/&$\bnU=nE>d7\u000f\u000b\u0002\u000f'\u0006)\"m\\8mK\u0006t\u0007K]8q-\u0006dW/\u001a+p'\u0016$X#\u0001<\u0011\u0005E:\u0018B\u0001=3\u0005\u001d\u0011un\u001c7fC:\faCY8pY\u0016\fg\u000e\u0015:paZ\u000bG.^3U_N+G\u000fI\u0001\u0015gR\u0014\u0018N\\4Qe>\u0004h+\u00197vKR{7+\u001a;\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@m\u0003\u0011a\u0017M\\4\n\u0007\u0005\raP\u0001\u0004TiJLgnZ\u0001\u0016gR\u0014\u0018N\\4Qe>\u0004h+\u00197vKR{7+\u001a;!\u0003Y\u0001\u0018m]:x_J$\u0007K]8q-\u0006dW/\u001a+p'\u0016$\u0018a\u00069bgN<xN\u001d3Qe>\u0004h+\u00197vKR{7+\u001a;!\u0003Ia\u0017n\u001d;Qe>\u0004h+\u00197vKR{7+\u001a;\u0016\u0005\u0005=\u0001#BA\t\u00037aXBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0013%lW.\u001e;bE2,'bAA\re\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00111\u0003\u0002\u0005\u0019&\u001cH/A\nmSN$\bK]8q-\u0006dW/\u001a+p'\u0016$\b%A\u000buKN$(l[*tY\u000ec\u0017.\u001a8u\u000b:\f'\r\\3)\u0005]\u0019\u0016!\u0007;fgRT6nU:m\u0017\u0016L8\u000b^8sK2{7-\u0019;j_:D#\u0001G*\u00027Q,7\u000f\u001e.l'NdGK];tiN#xN]3M_\u000e\fG/[8oQ\tI2+A\u000fuKN$(l\\8lK\u0016\u0004XM]&fsN#xN]3QCN\u001cxo\u001c:eQ\tQ2+A\u0010uKN$(l\\8lK\u0016\u0004XM\u001d+skN$8\u000b^8sKB\u000b7o]<pe\u0012D#aG*\u0002+Q,7\u000f\u001e.l'Nd7*Z=Ti>\u0014X\rV=qK\"\u0012AdU\u0001\u0018i\u0016\u001cHOW6Tg2$&/^:u'R|'/\u001a+za\u0016D#!H*\u0002#Q,7\u000f\u001e.l'Nd\u0007K]8u_\u000e|G\u000e\u000b\u0002\u001f'\u0006IB/Z:u5.\u001c6\u000f\\#oC\ndW\r\u001a)s_R|7m\u001c7tQ\ty2+A\u000buKN$(l[*tY\u000eK\u0007\u000f[3s'VLG/Z:)\u0005\u0001\u001a\u0016\u0001\u000b;fgRT6nU:m\u000b:$\u0007o\\5oi&#WM\u001c;jM&\u001c\u0017\r^5p]\u0006cwm\u001c:ji\"l\u0007FA\u0011T\u0003I!Xm\u001d;[WN\u001bHn\u0011:m\u000b:\f'\r\\3)\u0005\t\u001a\u0016a\u0005;fgRT6nU:m\u001f\u000e\u001c\b/\u00128bE2,\u0007FA\u0012T\u0003\u0005\"Xm\u001d;D_:tWm\u0019;j_:\u001cX*\u0019=SK\u0006,H\u000f['t\t\u00164\u0017-\u001e7uQ\t!3+\u0001\u0012uKN$8i\u001c8oK\u000e$\u0018n\u001c8t\u001b\u0006D(+Z1vi\"l5/\u0012=qY&\u001c\u0017\u000e\u001e\u0015\u0003KM\u000bA\b^3tiR{\u0007/[2SKBd\u0017nY1BgNLwM\\8s%\u0016$XO\u001d8t\u000b6\u0004H/_(qi&|gn],iK:tu\u000e^\"p]\u001aLw-\u001e:fI\"\u0012aeU\u0001\ri\u0016\u001cHOW6D_:4\u0017nZ\u000b\u0007\u0003K\ny)a1\u0015\u001fq\n9'a \u0002\u0004\u0006\u001d\u0015\u0011UA_\u0003\u000fDq!!\u001b(\u0001\u0004\tY'A\u0007lC\u001a\\\u0017\r\u0015:pa:\u000bW.\u001a\t\u0005\u0003[\nYH\u0004\u0003\u0002p\u0005]\u0004cAA9e5\u0011\u00111\u000f\u0006\u0004\u0003kr\u0013A\u0002\u001fs_>$h(C\u0002\u0002zI\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0002\u0003{R1!!\u001f3\u0011\u001d\t\ti\na\u0001\u0003W\nQ#\u001a=qK\u000e$X\rZ&bM.\f\u0007K]8q\u001d\u0006lW\rC\u0004\u0002\u0006\u001e\u0002\r!a\u001b\u0002\u0017ML8\u000f\u0015:pa:\u000bW.\u001a\u0005\b\u0003\u0013;\u0003\u0019AAF\u00039\u0001(o\u001c9WC2,X\rV8TKR\u0004B!!$\u0002\u00102\u0001AaBAIO\t\u0007\u00111\u0013\u0002\u0002)F!\u0011QSAN!\r\t\u0014qS\u0005\u0004\u00033\u0013$a\u0002(pi\"Lgn\u001a\t\u0004c\u0005u\u0015bAAPe\t\u0019\u0011I\\=\t\u000f\u0005\rv\u00051\u0001\u0002&\u0006\u0001r-\u001a;Qe>\u0004h+\u00197vK\u001a\u0013x.\u001c\t\bc\u0005\u001d\u00161VA\\\u0013\r\tIK\r\u0002\n\rVt7\r^5p]F\u0002B!!,\u000246\u0011\u0011q\u0016\u0006\u0004\u0003cc\u0013AB:feZ,'/\u0003\u0003\u00026\u0006=&aC&bM.\f7i\u001c8gS\u001e\u0004R!MA]\u0003\u0017K1!a/3\u0005\u0019y\u0005\u000f^5p]\"9\u0011qX\u0014A\u0002\u0005\u0005\u0017!F3ya\u0016\u001cG/\u001a3Qe>\u0004XM\u001d;z-\u0006dW/\u001a\t\u0005\u0003\u001b\u000b\u0019\rB\u0004\u0002F\u001e\u0012\r!a%\u0003\u0003UC\u0011\"!3(!\u0003\u0005\r!a.\u0002)\u0015D\b/Z2uK\u0012$UMZ1vYR4\u0016\r\\;f\u0003Y!Xm\u001d;[W\u000e{gNZ5hI\u0011,g-Y;mi\u0012:TCBAh\u0003W\fi/\u0006\u0002\u0002R*\"\u00111[Am\u001d\r\t\u0014Q[\u0005\u0004\u0003/\u0014\u0014\u0001\u0002(p]\u0016\\#!a7\u0011\t\u0005u\u0017q]\u0007\u0003\u0003?TA!!9\u0002d\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003K\u0014\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011^Ap\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\b\u0003#C#\u0019AAJ\t\u001d\t)\r\u000bb\u0001\u0003'\u000bA\u0003\u001d:fa\u0006\u0014X\rR3gCVdGoQ8oM&<GCAA6\u00035\u0001(/\u001a9be\u0016\u001cuN\u001c4jOR!\u00111NA|\u0011\u001d\tIP\u000ba\u0001\u0003w\fQ\u0001\\5oKN\u0004R!MA\u007f\u0003WJ1!a@3\u0005\u0015\t%O]1z\u0001")
public class KafkaTest {
    private final boolean booleanPropValueToSet;
    private final String stringPropValueToSet;
    private final String passwordPropValueToSet;
    private final List<String> listPropValueToSet = new .colon.colon((Object)"A", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$));

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$1) -> KafkaTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)status), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assertions.assertEquals((int)1, (int)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=2"})));
        Assertions.assertEquals((int)2, (int)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"})));
        Assertions.assertEquals((int)1, (int)config3.brokerId());
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"compact"}), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"})));
        Assertions.assertEquals((int)2, (int)config4.brokerId());
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"compact", "delete"}), (Object)config4.logCleanupPolicy());
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"}))));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "broker.id=2"}))));
    }

    @Test
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertThrows(FatalExitError.class, () -> KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"}))));
    }

    @Test
    public void testBrokerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains just the 'broker' role, the node id 1 must not be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testControllerRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testColocatedRoleNodeIdValidation() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "2@localhost:9092");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If process.roles contains the 'controller' role, the node id 1 must be included in the set of voters");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    @Test
    public void testMustContainQuorumVotersIfUsingProcessRoles() {
        Properties propertiesFile = new Properties();
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        this.setListenerProps(propertiesFile);
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "If using process.roles, controller.quorum.voters must contain a parseable set of voters.");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "");
        TestUtils$.MODULE$.assertBadConfigContainingMessage(propertiesFile, "Missing required configuration `zookeeper.connect` which has no default value.");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        propertiesFile.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "");
        KafkaConfig$.MODULE$.fromProps(propertiesFile);
    }

    private void setListenerProps(Properties props) {
        boolean hasBrokerRole = props.getProperty(KafkaConfig$.MODULE$.ProcessRolesProp()).contains("broker");
        boolean hasControllerRole = props.getProperty(KafkaConfig$.MODULE$.ProcessRolesProp()).contains("controller");
        String controllerListener = "SASL_PLAINTEXT://localhost:9092";
        String brokerListener = "PLAINTEXT://localhost:9093";
        if (hasBrokerRole || hasControllerRole) {
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SASL_PLAINTEXT");
            if (hasBrokerRole && hasControllerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(1).append(brokerListener).append(",").append(controllerListener).toString());
            } else if (hasControllerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), controllerListener);
            } else if (hasBrokerRole) {
                props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), brokerListener);
            }
        } else {
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), brokerListener);
        }
        if (!(hasControllerRole & !hasBrokerRole)) {
            props.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "PLAINTEXT");
            props.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:9092");
        }
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password", "--override", "ssl.keystore.certificate.chain=certificate_chain", "--override", "ssl.keystore.key=private_key", "--override", "ssl.truststore.certificates=truststore_certificates"})));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreKeyProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreCertificateChainProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststoreCertificatesProp()).toString());
        Assertions.assertEquals((Object)"key_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assertions.assertEquals((Object)"keystore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assertions.assertEquals((Object)"truststore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        Assertions.assertEquals((Object)"private_key", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreKeyProp()).value());
        Assertions.assertEquals((Object)"certificate_chain", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystoreCertificateChainProp()).value());
        Assertions.assertEquals((Object)"truststore_certificates", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststoreCertificatesProp()).value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder(22).append("ssl.keystore.password=").append(password).toString(), "--override", new StringBuilder(17).append("ssl.key.password=").append(password).toString(), "--override", new StringBuilder(24).append("ssl.truststore.password=").append(password).toString()})));
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assertions.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assertions.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    private boolean booleanPropValueToSet() {
        return this.booleanPropValueToSet;
    }

    private String stringPropValueToSet() {
        return this.stringPropValueToSet;
    }

    private String passwordPropValueToSet() {
        return this.passwordPropValueToSet;
    }

    private List<String> listPropValueToSet() {
        return this.listPropValueToSet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslClientEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.client.secure";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.client.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslClientEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.location";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreLocation() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.location";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.location";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreLocation());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreLocation());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperKeyStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.keyStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.password";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZookeeperTrustStorePassword() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        Password password = new Password(this.passwordPropValueToSet());
        String string = this.passwordPropValueToSet();
        String string2 = "zookeeper.ssl.trustStore.password";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.password";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStorePassword());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStorePassword());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslKeyStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.keyStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.keystore.type";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslKeyStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslKeyStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslKeyStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslTrustStoreType() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.trustStore.type";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.truststore.type";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.zkSslTrustStoreType().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.zkSslTrustStoreType());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.zkSslTrustStoreType());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslProtocol() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)"TLSv1.2");
        String string = this.stringPropValueToSet();
        String string2 = this.stringPropValueToSet();
        String string3 = "zookeeper.ssl.protocol";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.protocol";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslProtocol$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslEnabledProtocols() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        Object object = CollectionConverters$.MODULE$.seqAsJavaListConverter(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.enabledProtocols";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.enabled.protocols";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslEnabledProtocols());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslEnabledProtocols());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCipherSuites() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        None$ none$ = this.testZkConfig$default$7();
        Object object = CollectionConverters$.MODULE$.seqAsJavaListConverter(this.listPropValueToSet()).asJava();
        String string = this.listPropValueToSet().mkString(",");
        String string2 = "zookeeper.ssl.ciphersuites";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.cipher.suites";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)testZkConfig_emptyConfig.ZkSslCipherSuites().get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)testZkConfig_emptyConfig.ZkSslCipherSuites());
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)testZkConfig_config.ZkSslCipherSuites());
    }

    @Test
    public void testZkSslEndpointIdentificationAlgorithm() {
        String kafkaPropName = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        Assertions.assertEquals((Object)"zookeeper.ssl.endpoint.identification.algorithm", (Object)kafkaPropName);
        String sysProp = "zookeeper.ssl.hostnameVerification";
        String expectedDefaultValue = "HTTPS";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, emptyConfig.values().get(kafkaPropName));
        Assertions.assertEquals((Object)expectedDefaultValue, (Object)emptyConfig.ZkSslEndpointIdentificationAlgorithm());
        ((IterableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"true"), (Object)"HTTPS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"false"), (Object)"")}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$1(sysProp, propertiesFile, kafkaPropName, expectedDefaultValue, x0$1);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)"https", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)expected -> {
            KafkaTest.$anonfun$testZkSslEndpointIdentificationAlgorithm$2(propertiesFile, kafkaPropName, expected);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslCrlEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.crl";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.crl.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslCrlEnable$1(testZkConfig_config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkSslOcspEnable() {
        void testZkConfig_expectedPropertyValue;
        void testZkConfig_propValueToSet;
        void testZkConfig_sysPropName;
        void testZkConfig_expectedDefaultValue;
        Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)this.booleanPropValueToSet());
        String string = "zookeeper.ssl.ocsp";
        String testZkConfig_expectedKafkaPropName = "zookeeper.ssl.ocsp.enable";
        String testZkConfig_kafkaPropName = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
        Assertions.assertEquals((Object)testZkConfig_expectedKafkaPropName, (Object)testZkConfig_kafkaPropName);
        String testZkConfig_propertiesFile = this.prepareDefaultConfig();
        KafkaConfig testZkConfig_emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
        Assertions.assertNull(testZkConfig_emptyConfig.originals().get(testZkConfig_kafkaPropName));
        if (testZkConfig_expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig).get());
        } else {
            Assertions.assertNull(testZkConfig_emptyConfig.values().get(testZkConfig_kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_emptyConfig));
        }
        try {
            System.setProperty((String)testZkConfig_sysPropName, String.valueOf(testZkConfig_propValueToSet));
            KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile})));
            Assertions.assertNull(testZkConfig_config.originals().get(testZkConfig_kafkaPropName));
            if (testZkConfig_expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)testZkConfig_expectedDefaultValue.get(), testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            } else {
                Assertions.assertNull(testZkConfig_config.values().get(testZkConfig_kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
        }
        finally {
            System.clearProperty((String)testZkConfig_sysPropName);
        }
        KafkaConfig testZkConfig_config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{testZkConfig_propertiesFile, "--override", new StringBuilder(1).append(testZkConfig_kafkaPropName).append("=").append(testZkConfig_propValueToSet).toString()})));
        Assertions.assertEquals((Object)testZkConfig_expectedPropertyValue, testZkConfig_config.values().get(testZkConfig_kafkaPropName));
        Assertions.assertEquals((Object)new Some((Object)testZkConfig_expectedPropertyValue), (Object)KafkaTest.$anonfun$testZkSslOcspEnable$1(testZkConfig_config));
    }

    @Test
    public void testConnectionsMaxReauthMsDefault() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testConnectionsMaxReauthMsExplicit() {
        String propertiesFile = this.prepareDefaultConfig();
        int expected = 3600000;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder(47).append("sasl_ssl.oauthbearer.connections.max.reauth.ms=").append(expected).toString()})));
        Assertions.assertEquals((long)expected, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testTopicReplicaAssignorReturnsEmptyOptionsWhenNotConfigured() {
        String propertiesFile = this.prepareDefaultConfig();
        Assertions.assertFalse((boolean)KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile}))).topicReplicaAssignorBuilder().isDefined(), (String)"Expected the assignor builder to not be loaded");
    }

    private <T, U> void testZkConfig(String kafkaPropName, String expectedKafkaPropName, String sysPropName, T propValueToSet, Function1<KafkaConfig, Option<T>> getPropValueFrom, U expectedPropertyValue, Option<T> expectedDefaultValue) {
        Assertions.assertEquals((Object)expectedKafkaPropName, (Object)kafkaPropName);
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig emptyConfig = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assertions.assertNull(emptyConfig.originals().get(kafkaPropName));
        if (expectedDefaultValue.isDefined()) {
            Assertions.assertEquals((Object)expectedDefaultValue.get(), emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)expectedDefaultValue.get(), (Object)((Option)getPropValueFrom.apply((Object)emptyConfig)).get());
        } else {
            Assertions.assertNull(emptyConfig.values().get(kafkaPropName));
            Assertions.assertEquals((Object)None$.MODULE$, (Object)getPropValueFrom.apply((Object)emptyConfig));
        }
        try {
            System.setProperty(sysPropName, String.valueOf(propValueToSet));
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
            Assertions.assertNull(config.originals().get(kafkaPropName));
            if (expectedDefaultValue.isDefined()) {
                Assertions.assertEquals((Object)expectedDefaultValue.get(), config.values().get(kafkaPropName));
            } else {
                Assertions.assertNull(config.values().get(kafkaPropName));
            }
            Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
        }
        finally {
            System.clearProperty(sysPropName);
        }
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder(1).append(kafkaPropName).append("=").append(propValueToSet).toString()})));
        Assertions.assertEquals(expectedPropertyValue, config.values().get(kafkaPropName));
        Assertions.assertEquals((Object)new Some(expectedPropertyValue), (Object)getPropValueFrom.apply((Object)config));
    }

    private <T, U> None$ testZkConfig$default$7() {
        return None$.MODULE$;
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    public String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).foreach((Function1 & Serializable & scala.Serializable)l -> {
                KafkaTest.$anonfun$prepareConfig$1(writer, l);
                return BoxedUnit.UNIT;
            });
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int status, Option x$1) {
        throw new FatalExitError(status);
    }

    public static final /* synthetic */ Some $anonfun$testZkSslClientEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.zkSslClientEnable()));
    }

    public static final /* synthetic */ Some $anonfun$testZkSslProtocol$1(KafkaConfig config) {
        return new Some((Object)config.ZkSslProtocol());
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$1(String sysProp$1, String propertiesFile$4, String kafkaPropName$1, String expectedDefaultValue$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String sysPropValue = (String)x0$1._1();
            String expected = (String)x0$1._2();
            try {
                System.setProperty(sysProp$1, sysPropValue);
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile$4})));
                Assertions.assertNull(config.originals().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expectedDefaultValue$1, config.values().get(kafkaPropName$1));
                Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
            }
            finally {
                System.clearProperty(sysProp$1);
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testZkSslEndpointIdentificationAlgorithm$2(String propertiesFile$4, String kafkaPropName$1, String expected) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile$4, "--override", new StringBuilder(1).append(kafkaPropName$1).append("=").append(expected).toString()})));
        Assertions.assertEquals((Object)expected, config.originals().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, config.values().get(kafkaPropName$1));
        Assertions.assertEquals((Object)expected, (Object)config.ZkSslEndpointIdentificationAlgorithm());
    }

    public static final /* synthetic */ Some $anonfun$testZkSslCrlEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslCrlEnable()));
    }

    public static final /* synthetic */ Some $anonfun$testZkSslOcspEnable$1(KafkaConfig config) {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)config.ZkSslOcspEnable()));
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public KafkaTest() {
        this.booleanPropValueToSet = true;
        this.stringPropValueToSet = "foo";
        this.passwordPropValueToSet = "ThePa$$word!";
    }
}

