/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier.management;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.TierLogSegment;
import kafka.server.BaseRequestTest;
import kafka.server.ConfigType$;
import kafka.server.HostedPartition;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\r\u001b\u0001\rBQa\u000b\u0001\u0005\u00021BQa\f\u0001\u0005BABqa\u000e\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004E\u0001\u0001\u0006I!\u000f\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019\u0011\u0006\u0001)A\u0005\u000f\"91\u000b\u0001b\u0001\n\u0003!\u0006BB/\u0001A\u0003%Q\u000bC\u0003_\u0001\u0011\u0005s\fC\u0003f\u0001\u0011\u0005a\rC\u0003s\u0001\u0011\u0005a\rC\u0003x\u0001\u0011\u0005a\rC\u0003z\u0001\u0011\u0005a\rC\u0003|\u0001\u0011\u0005a\rC\u0003~\u0001\u0011\u0005a\rC\u0003\u0000\u0001\u0011\u0005a\r\u0003\u0004\u0002\u0004\u0001!\tA\u001a\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u0019\t\t\u0004\u0001C\u0001M\"9\u0011Q\u0007\u0001\u0005\n\u0005]\u0002bBA!\u0001\u0011%\u00111\t\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!!\u001e\u0001\t\u0013\t9HA\u000eUS\u0016\u0014X\r\u001a)beRLG/[8o%\u0016\u001cwN^3ssR+7\u000f\u001e\u0006\u00037q\t!\"\\1oC\u001e,W.\u001a8u\u0015\tib$\u0001\u0003uS\u0016\u0014(BA\u0010!\u0003\u0015Y\u0017MZ6b\u0015\u0005\t\u0013aC5oi\u0016<'/\u0019;j_:\u001c\u0001a\u0005\u0002\u0001IA\u0011Q%K\u0007\u0002M)\u0011q\u0005K\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003}I!A\u000b\u0014\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"\u0001\u000e\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002cA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t\u0019\u0011J\u001c;\u0002\u0013Q|\u0007/[2OC6,W#A\u001d\u0011\u0005i\neBA\u001e@!\ta4'D\u0001>\u0015\tq$%\u0001\u0004=e>|GOP\u0005\u0003\u0001N\na\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001iM\u0001\u000bi>\u0004\u0018n\u0019(b[\u0016\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002\u000fB\u0011\u0001\nU\u0007\u0002\u0013*\u0011!jS\u0001\u0007G>lWn\u001c8\u000b\u0005}a%BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001eL!!U%\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%A\u0003qe>\u00048/F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0003vi&d'\"\u0001.\u0002\t)\fg/Y\u0005\u00039^\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0019\u0001(o\u001c9tA\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003A\u000e\u0004\"AM1\n\u0005\t\u001c$\u0001B+oSRDQ\u0001Z\u0005A\u0002U\u000b!\u0002\u001d:pa\u0016\u0014H/[3t\u00039\u0001(/\u001a9be\u00164uN\u001d+fgR$\u0012\u0001\u0019\u0015\u0003\u0015!\u0004\"!\u001b9\u000e\u0003)T!a\u001b7\u0002\u0007\u0005\u0004\u0018N\u0003\u0002n]\u00069!.\u001e9ji\u0016\u0014(BA8O\u0003\u0015QWO\\5u\u0013\t\t(N\u0001\u0006CK\u001a|'/Z#bG\"\fq\u0006^3tiJ+7m\u001c<fef\fE/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014x+\u001b;i\u001d>$\u0015\r^1Bi2{7-\u00197M_\u001eD#a\u0003;\u0011\u0005%,\u0018B\u0001<k\u0005\u0011!Vm\u001d;\u0002\u007fQ,7\u000f\u001e*fG>4XM]=BiVs7\r\\3b]2+\u0017\rZ3s/&$\b\u000eT8dC2dUi\u0014'fgN$\u0006.\u00198MCN$H+[3sK\u0012|eMZ:fi\"\u0012A\u0002^\u00011i\u0016\u001cHOU3d_Z,'/_!u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:XSRD\u0017\t\u001c7ECR\f\u0017\t\u001e'pG\u0006dGj\\4)\u00055!\u0018\u0001\u0010;fgR\u0014VmY8wKJL\u0018\t^+oG2,\u0017M\u001c'fC\u0012,'oV5uQ2\u001bvj\u00147eKJ$\u0006.\u00198GSJ\u001cH\u000fV5fe\u0016$wJ\u001a4tKRD#A\u0004;\u0002gQ,7\u000f\u001e*fG>4XM]=BiVs7\r\\3b]2+\u0017\rZ3s/&$\b\u000eR5wKJ<WM\\2f\u0003RdunY1m\u0019><\u0007FA\bu\u0003U\"Xm\u001d;SK\u000e|g/\u001a:z\u0003R,fn\u00197fC:dU-\u00193fe^CWM\u001c(p'\u0016<W.\u001a8u\u0011\u0006\u001c()Z3o)&,'/\u001a3)\u0005A!\u0018!\u0010;fgR\u0014VmY8wKJL\u0018\t^+oG2,\u0017M\u001c'fC\u0012,'OR8s)>\u0004\u0018nY\"sK\u0006$X\rZ,ji\"$\u0016.\u001a:j]\u001e$\u0015n]1cY\u0016$\u0007FA\tu\u0003=!\u0018.\u001a:M_\u001e\u001cVmZ7f]R\u001cH\u0003BA\u0006\u0003S\u0001b!!\u0004\u0002\u0018\u0005ua\u0002BA\b\u0003'q1\u0001PA\t\u0013\u0005!\u0014bAA\u000bg\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\r\u00037\u0011A\u0001T5ti*\u0019\u0011QC\u001a\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t)\u0003\rawnZ\u0005\u0005\u0003O\t\tC\u0001\bUS\u0016\u0014Hj\\4TK\u001elWM\u001c;\t\u000f\u0005\r\"\u00031\u0001\u0002,A!\u0011qDA\u0017\u0013\u0011\ty#!\t\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001Ai\u0016\u001cHOU3d_Z,'/_!u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:XSRDG+[3sK\u0012$\u0015\r^1CkR$\u0016.\u001a:j]\u001e\u001c\u0016N\\2f\t&\u001c\u0018M\u00197fI\"\u00121\u0003^\u0001\u0012G\"\fgnZ3U_BL7mQ8oM&<G#\u00021\u0002:\u0005u\u0002BBA\u001e)\u0001\u0007\u0011(A\u0002lKfDa!a\u0010\u0015\u0001\u0004I\u0014!\u0002<bYV,\u0017aD2sK\u0006$X\rV3tiR{\u0007/[2\u0015\t\u0005\u0015\u0013\u0011\u000b\t\ne\u0005\u001d\u0013'a\u00132\u0003\u0017J1!!\u00134\u0005\u0019!V\u000f\u001d7fiA\u0019Q%!\u0014\n\u0007\u0005=cEA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\b\"B*\u0016\u0001\u0004)\u0016aG1qa\u0016tG-T3tg\u0006<Wm]!oIZ+'/\u001b4z'ft7\rF\u0004a\u0003/\nY&a\u0018\t\r\u0005ec\u00031\u00012\u0003-qW/\\'fgN\fw-Z:\t\r\u0005uc\u00031\u00012\u0003!aW-\u00193fe&#\u0007BBA1-\u0001\u0007\u0011'\u0001\u0006g_2dwn^3s\u0013\u0012\fAc^1ji\u001a{'/S:s)>\u001c\u0005.\u00198hKR{G#\u00021\u0002h\u0005-\u0004bBA5/\u0001\u0007\u00111J\u0001\u0007Y\u0016\fG-\u001a:\t\u000f\u00055t\u00031\u0001\u0002p\u0005YQ\r\u001f9fGR,G-S:s!\u0011Q\u0014\u0011O\u0019\n\u0007\u0005M4IA\u0002TKR\f\u0001d^1ji\u001a{'OU3qY&\u001c\u0017\rV8CK2+\u0017\rZ3s)\u0015\u0001\u0017\u0011PA>\u0011\u0015)\u0005\u00041\u0001H\u0011\u001d\ti\b\u0007a\u0001\u0003\u0017\n\u0011B\\3x\u0019\u0016\fG-\u001a:")
public class TieredPartitionRecoveryTest
extends BaseRequestTest {
    private final String topicName;
    private final TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
    private final Properties props = new Properties();

    @Override
    public int brokerCount() {
        return 5;
    }

    public String topicName() {
        return this.topicName;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    @BeforeEach
    public void prepareForTest() {
        this.props().clear();
        this.props().put("confluent.tier.enable", "true");
        this.props().put("segment.bytes", "16384");
        this.props().put("confluent.tier.local.hotset.bytes", "16384");
        this.props().put("confluent.tier.local.hotset.ms", "-1");
        this.props().put("retention.bytes", "-1");
        this.props().put("unclean.leader.election.enable", "true");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAtUncleanLeaderWithNoDataAtLocalLog() {
        void var2_2;
        void var3_3;
        void var4_4;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        Tuple4<Object, KafkaServer, Object, KafkaServer> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaServer replica1 = (KafkaServer)tuple4._2();
        KafkaServer replica2 = (KafkaServer)tuple4._4();
        var4_4.shutdown();
        this.waitForIsrToChangeTo((KafkaServer)var3_3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var2_2}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$1(this, (KafkaServer)var3_3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numMessages = 26000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        AbstractLog log = (AbstractLog)var3_3.replicaManager().getLog(this.topicPartition()).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$3(this, log, numMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedLogStartOffset = log.logStartOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log).last()).endOffset();
        var3_3.shutdown();
        var4_4.startup();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var4_4);
        AbstractLog log_2 = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset() {
        void var3_3;
        void var5_5;
        void var4_4;
        void var2_2;
        Tuple4<Object, KafkaServer, Object, KafkaServer> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaServer replica1 = (KafkaServer)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaServer replica2 = (KafkaServer)tuple4._4();
        int numMessages = 1000;
        this.appendMessagesAndVerifySync(numMessages, (int)var2_2, (int)var4_4);
        var5_5.shutdown();
        this.waitForIsrToChangeTo((KafkaServer)var3_3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var2_2}))));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        AbstractLog log = (AbstractLog)var3_3.replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$1(this, log, numMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long firstTieredOffset = ((TierLogSegment)this.tierLogSegments(log).head()).baseOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log).last()).endOffset();
        var3_3.shutdown();
        var5_5.startup();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var5_5);
        AbstractLog log_2 = (AbstractLog)var5_5.replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)firstTieredOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered segment");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered segment");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered segment");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAtUncleanLeaderWithAllDataAtLocalLog() {
        void var5_5;
        void var3_3;
        void var4_4;
        void var2_2;
        this.props().put("confluent.tier.local.hotset.bytes", "-1");
        this.props().put("confluent.tier.local.hotset.ms", "-1");
        this.props().put("retention.bytes", "-1");
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        Tuple4<Object, KafkaServer, Object, KafkaServer> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaServer replica1 = (KafkaServer)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaServer replica2 = (KafkaServer)tuple4._4();
        int numMessages = 10000;
        this.appendMessagesAndVerifySync(numMessages, (int)var2_2, (int)var4_4);
        AbstractLog log = (AbstractLog)var3_3.replicaManager().getLog(this.topicPartition()).get();
        long expectedLogStartOffset = log.logStartOffset();
        long expectedLogEndOffset = log.logEndOffset();
        long expectedLocalLogStartOffset = ((AbstractLog)var5_5.replicaManager().getLog(this.topicPartition()).get()).localLogStartOffset();
        var5_5.shutdown();
        this.waitForIsrToChangeTo((KafkaServer)var3_3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var2_2}))));
        var3_3.shutdown();
        var5_5.startup();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var5_5);
        AbstractLog log_2 = (AbstractLog)var5_5.replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.logStartOffset(), (String)"Unexpected LogStartOffset after recovery");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.logEndOffset(), (String)"Unexpected LogEndOffset after recovery");
        Assertions.assertEquals((long)expectedLocalLogStartOffset, (long)log_2.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset after recovery");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.localLogEndOffset(), (String)"Unexpected LocalLogEndOffset after recovery");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset() {
        void var17_15;
        void var5_5;
        void var2_2;
        void var3_3;
        this.props().put("segment.bytes", "4096");
        this.props().put("confluent.tier.local.hotset.bytes", "40960");
        this.props().put("retention.bytes", "40960");
        this.props().put("file.delete.delay.ms", "100");
        Tuple4<Object, KafkaServer, Object, KafkaServer> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaServer replica1 = (KafkaServer)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaServer replica2 = (KafkaServer)tuple4._4();
        AbstractLog log = (AbstractLog)var3_3.replicaManager().getLog(this.topicPartition()).get();
        int numMessages = 50;
        while (log.size() < 40960L) {
            void var4_4;
            this.appendMessagesAndVerifySync(numMessages, (int)var2_2, (int)var4_4);
        }
        long oldLocalLogStartOffsetFollower = ((AbstractLog)var5_5.replicaManager().getLog(this.topicPartition()).get()).localLogStartOffset();
        var5_5.shutdown();
        this.waitForIsrToChangeTo((KafkaServer)var3_3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var2_2}))));
        this.props().put("confluent.tier.local.hotset.bytes", "20480");
        this.props().put("retention.bytes", "20480");
        this.adminZkClient().changeConfigs(ConfigType$.MODULE$.Topic(), this.topicName(), this.props());
        SortedSet offsetAndSize = (SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        log.localLogSegments().iterator().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)offsetAndSize.add((Object)new Tuple2.mcJI.sp(segment.baseOffset(), segment.size()))));
        this.tierLogSegments(log).iterator().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)offsetAndSize.add((Object)new Tuple2.mcJI.sp(segment.baseOffset(), segment.size()))));
        LongRef newStartOffset = LongRef.create((long)log.logEndOffset());
        Iterator it = offsetAndSize.toList().reverseIterator();
        for (int sizeInBytes = 0; sizeInBytes < 20480 && it.hasNext(); sizeInBytes += var17_15) {
            void var15_14;
            Tuple2 tuple2 = (Tuple2)it.next();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long baseOffset = tuple2._1$mcJ$sp();
            int segmentSize = tuple2._2$mcI$sp();
            newStartOffset.elem = var15_14;
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$3(this, log, newStartOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long firstTieredOffset = ((TierLogSegment)this.tierLogSegments(log).head()).baseOffset();
        long expectedLogEndOffset = log.logEndOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log).last()).endOffset();
        var3_3.shutdown();
        var5_5.startup();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var5_5);
        AbstractLog log_2 = (AbstractLog)var5_5.replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)firstTieredOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertTrue((log_2.localLogStartOffset() > oldLocalLogStartOffsetFollower ? 1 : 0) != 0, (String)"LocalLogStartOffset has not incremented to match first tiered offset");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.logEndOffset(), (String)"Unexpected LogEndOffset after recovery");
        Assertions.assertEquals((long)firstTieredOffset, (long)log_2.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset after recovery");
        Assertions.assertTrue((log_2.localLogEndOffset() >= lastTieredOffset ? 1 : 0) != 0, (String)new StringBuilder(72).append("LocalLogEndOffset ").append(log_2.localLogEndOffset()).append(" is lesser than the last tiered offset ").append(lastTieredOffset).append(" after recovery").toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAtUncleanLeaderWithDivergenceAtLocalLog() {
        void var5_5;
        void var3_3;
        void var4_4;
        void var2_2;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        Tuple4<Object, KafkaServer, Object, KafkaServer> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaServer replica1 = (KafkaServer)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaServer replica2 = (KafkaServer)tuple4._4();
        int numMessages = 5000;
        this.appendMessagesAndVerifySync(numMessages, (int)var2_2, (int)var4_4);
        var3_3.shutdown();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var5_5);
        var3_3.startup();
        this.waitForIsrToChangeTo((KafkaServer)var5_5, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var2_2, var4_4}))));
        this.appendMessagesAndVerifySync(numMessages, (int)var4_4, (int)var2_2);
        AbstractLog followerLog = (AbstractLog)var3_3.replicaManager().getLog(this.topicPartition()).get();
        Seq editedEpochEntries = (Seq)((LeaderEpochFileCache)followerLog.leaderEpochCache().get()).epochEntries().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends EpochEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                return (B1)new EpochEntry(x1.epoch(), x1.startOffset() + 1L);
            }

            public final boolean isDefinedAt(EpochEntry x1) {
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((LeaderEpochFileCache)followerLog.leaderEpochCache().get()).clearAndFlush();
        editedEpochEntries.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithDivergenceAtLocalLog$1(followerLog, entry);
            return BoxedUnit.UNIT;
        });
        AbstractLog leaderLog = (AbstractLog)var5_5.replicaManager().getLog(this.topicPartition()).get();
        long expectedLogStartOffset = leaderLog.logStartOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(leaderLog).last()).endOffset();
        var3_3.shutdown();
        this.waitForIsrToChangeTo((KafkaServer)var5_5, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var4_4}))));
        var5_5.shutdown();
        var3_3.startup();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var3_3);
        AbstractLog log = (AbstractLog)var3_3.replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log.logStartOffset(), (String)"Unexpected LogStartOffset after recovery");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log.logEndOffset(), (String)"Unexpected LogEndOffset after recovery");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset after recovery");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log.localLogEndOffset(), (String)"Unexpected LocalLogEndOffset after recovery");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAtUncleanLeaderWhenNoSegmentHasBeenTiered() {
        void var2_2;
        void var3_3;
        void var4_4;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        Tuple4<Object, KafkaServer, Object, KafkaServer> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaServer replica1 = (KafkaServer)tuple4._2();
        KafkaServer replica2 = (KafkaServer)tuple4._4();
        var4_4.shutdown();
        this.waitForIsrToChangeTo((KafkaServer)var3_3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var2_2}))));
        AbstractLog log = (AbstractLog)var3_3.replicaManager().getLog(this.topicPartition()).get();
        Predef$.MODULE$.assert(log.logStartOffset() == 0L && log.logEndOffset() == 0L && log.tierPartitionState().numSegments() == 0);
        var3_3.shutdown();
        var4_4.startup();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var4_4);
        AbstractLog log_2 = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)0L, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)0L, (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered offset");
        Assertions.assertEquals((long)0L, (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered offset");
        Assertions.assertEquals((long)0L, (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled() {
        void var3_3;
        void var5_5;
        void var4_4;
        void var2_2;
        this.props().put("confluent.tier.enable", "false");
        Tuple4<Object, KafkaServer, Object, KafkaServer> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaServer replica1 = (KafkaServer)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaServer replica2 = (KafkaServer)tuple4._4();
        int numMessages = 1000;
        AbstractLog log = (AbstractLog)((KafkaServer)this.serverForId((int)var2_2).get()).replicaManager().getLog(this.topicPartition()).get();
        AbstractLog followerLog = (AbstractLog)((KafkaServer)this.serverForId((int)var4_4).get()).replicaManager().getLog(this.topicPartition()).get();
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$1(log, numMessages, followerLog)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedLogStartOffset = followerLog.logStartOffset();
        long expectedLogEndOffset = followerLog.logEndOffset();
        var5_5.shutdown();
        this.waitForIsrToChangeTo((KafkaServer)var3_3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var2_2}))));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$3(log, numMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        var3_3.shutdown();
        var5_5.startup();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var5_5);
        AbstractLog log_2 = (AbstractLog)var5_5.replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered segment");
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered segment");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered segment");
    }

    private List<TierLogSegment> tierLogSegments(AbstractLog log) {
        return log.tieredLogSegments().toList();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled() {
        void var2_2;
        void var3_3;
        void var4_4;
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        this.props().put("segment.bytes", "4096");
        this.props().put("confluent.tier.local.hotset.bytes", "4096");
        Tuple4<Object, KafkaServer, Object, KafkaServer> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaServer replica1 = (KafkaServer)tuple4._2();
        KafkaServer replica2 = (KafkaServer)tuple4._4();
        var4_4.shutdown();
        this.waitForIsrToChangeTo((KafkaServer)var3_3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var2_2}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$1(this, (KafkaServer)var3_3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AbstractLog log1 = (AbstractLog)var3_3.replicaManager().getLog(this.topicPartition()).get();
        int numMessages = 100;
        IntRef totalMessages = IntRef.create((int)0);
        while (log1.numberOfSegments() < 4) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            totalMessages.elem += numMessages;
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$3(log1, totalMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$4(log1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedLogStartOffset = log1.logStartOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log1).last()).endOffset();
        this.changeTopicConfig("confluent.tier.enable", "false");
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$5(log1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long log1LocalLogStartOffset = log1.localLogStartOffset();
        long log1LogEndOffset = log1.logEndOffset();
        var3_3.shutdown();
        var4_4.startup();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var4_4);
        AbstractLog log2 = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$7(log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered offset");
        long oldSize = log2.size();
        long targetEndOffset = log2.logEndOffset() * 2L;
        while (log2.logEndOffset() < targetEndOffset) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        }
        long retentionBytes = log2.size() - oldSize;
        this.changeTopicConfig("retention.bytes", Long.toString(retentionBytes));
        LongRef size = LongRef.create((long)0L);
        LongRef startOffset = LongRef.create((long)((LogSegment)log2.localLogSegments().toList().last()).baseOffset());
        log2.localLogSegments().toList().reverse().foreach((Function1 & Serializable & scala.Serializable)seg -> {
            TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$9(size, retentionBytes, startOffset, seg);
            return BoxedUnit.UNIT;
        });
        long startOffsetAfterRetention = startOffset.elem;
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$10(log2, startOffsetAfterRetention)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$11(startOffsetAfterRetention, log2));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$12(log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        var4_4.shutdown();
        var3_3.startup();
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaServer)var3_3);
        AbstractLog log3 = (AbstractLog)var3_3.replicaManager().getLog(this.topicPartition()).get();
        long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l14 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$14(log1LocalLogStartOffset, log3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$15());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)log1LogEndOffset, (long)log3.logEndOffset(), (String)"Unexpected LogEndOffset");
        Assertions.assertEquals((long)log1LocalLogStartOffset, (long)log3.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset");
        Assertions.assertEquals((long)log1LogEndOffset, (long)log3.localLogEndOffset(), (String)"Unexpected LocalLogEndOffset");
        Predef$.MODULE$.assert(log3.tierPartitionState().numSegments() == 0);
    }

    private void changeTopicConfig(String key, String value) {
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(key, value), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.topicName()), Collections.singletonList(alterConfigOp));
        this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()).incrementalAlterConfigs(configs).all().get(5L, TimeUnit.SECONDS);
    }

    private Tuple4<Object, KafkaServer, Object, KafkaServer> createTestTopic(Properties props) {
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicName(), 1, 2, props, this.createTopic$default$5()).apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())));
        KafkaServer leader = (KafkaServer)this.serverForId(leaderId).get();
        int followerId = TestUtils$.MODULE$.findFollowerId(this.topicPartition(), (Iterable<KafkaBroker>)this.servers());
        KafkaServer follower = (KafkaServer)this.serverForId(followerId).get();
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)leaderId), (Object)leader, (Object)BoxesRunTime.boxToInteger((int)followerId), (Object)follower);
    }

    /*
     * WARNING - void declaration
     */
    private void appendMessagesAndVerifySync(int numMessages, int leaderId, int followerId) {
        AbstractLog leaderLog = (AbstractLog)((KafkaServer)this.serverForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        AbstractLog followerLog = (AbstractLog)((KafkaServer)this.serverForId(followerId).get()).replicaManager().getLog(this.topicPartition()).get();
        long currentEndOffset = leaderLog.logEndOffset();
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        long l = 50L;
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$appendMessagesAndVerifySync$1(this, leaderLog, currentEndOffset, numMessages, followerLog)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$appendMessagesAndVerifySync$2(this, leaderLog, followerLog, currentEndOffset, numMessages));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForIsrToChangeTo(KafkaServer leader, Set<Object> expectedIsr) {
        Partition partition = leader.replicaManager().getPartitionOrException(this.topicPartition());
        long l = 50L;
        long l2 = 150000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$waitForIsrToChangeTo$1(partition, expectedIsr)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$waitForIsrToChangeTo$2(expectedIsr, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForReplicaToBeLeader(TopicPartition topicPartition, KafkaServer newLeader) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$1(newLeader, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Partition partition = newLeader.replicaManager().getPartitionOrException(topicPartition);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$3(partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$1(TieredPartitionRecoveryTest $this, KafkaServer replica1$1) {
        return !replica1$1.replicaManager().getPartitionOrException($this.topicPartition()).isUncleanLeader();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$2() {
        return "Waiting for log to be clean";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$3(TieredPartitionRecoveryTest $this, AbstractLog log$1, int numMessages$1) {
        return log$1.logEndOffset() == (long)numMessages$1 && $this.tierLogSegments(log$1).size() >= log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$4() {
        return "Timeout waiting for all messages to be written";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$1(TieredPartitionRecoveryTest $this, AbstractLog log$2, int numMessages$2) {
        return log$2.logEndOffset() == (long)(2 * numMessages$2) && $this.tierLogSegments(log$2).size() >= log$2.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$2() {
        return "Timeout waiting for some segments to tier";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$3(TieredPartitionRecoveryTest $this, AbstractLog log$3, LongRef newStartOffset$1) {
        return log$3.logStartOffset() == newStartOffset$1.elem && ((TierLogSegment)$this.tierLogSegments(log$3).head()).baseOffset() == newStartOffset$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$4() {
        return "Timed out waiting for retention to complete";
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAtUncleanLeaderWithDivergenceAtLocalLog$1(AbstractLog followerLog$1, EpochEntry entry) {
        ((LeaderEpochFileCache)followerLog$1.leaderEpochCache().get()).assign(entry.epoch(), entry.startOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$1(AbstractLog log$4, int numMessages$3, AbstractLog followerLog$2) {
        return log$4.logEndOffset() == (long)numMessages$3 && followerLog$2.logEndOffset() == (long)numMessages$3;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$2() {
        return "Timeout waiting for all messages to be written and synced";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$3(AbstractLog log$4, int numMessages$3) {
        return log$4.logEndOffset() == (long)(2 * numMessages$3);
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$4() {
        return "Timeout waiting for all messages to be written";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$1(TieredPartitionRecoveryTest $this, KafkaServer replica1$2) {
        return !replica1$2.replicaManager().getPartitionOrException($this.topicPartition()).isUncleanLeader();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$2() {
        return "Waiting for log to be clean";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$3(AbstractLog log1$1, IntRef totalMessages$1) {
        return log1$1.logEndOffset() == (long)totalMessages$1.elem && log1$1.tierPartitionState().numSegments() >= log1$1.numberOfSegments() - 1 && log1$1.localLogStartOffset() > log1$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$4(AbstractLog log1$1) {
        return new StringBuilder(59).append("Timeout waiting for all messages to be written and tiered ").append(log1$1.tierPartitionState().numSegments()).append(" ").append(log1$1.numberOfSegments()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$5(AbstractLog log1$1) {
        return !log1$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$6() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$7(AbstractLog log2$1) {
        return !log2$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$8() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$9(LongRef size$1, long retentionBytes$1, LongRef startOffset$1, LogSegment seg) {
        if (size$1.elem < retentionBytes$1) {
            size$1.elem += (long)seg.size();
            startOffset$1.elem = seg.baseOffset();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$10(AbstractLog log2$1, long startOffsetAfterRetention$1) {
        return log2$1.logStartOffset() == startOffsetAfterRetention$1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$11(long startOffsetAfterRetention$1, AbstractLog log2$1) {
        return new StringBuilder(67).append("Timed out waiting for logStartOffset to change (expected: ").append(startOffsetAfterRetention$1).append(" actual: ").append(log2$1.logStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$12(AbstractLog log2$1) {
        return log2$1.tierPartitionState().numSegments() == 0;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$13() {
        return "Timed out waiting for tiered segments to delete";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$14(long log1LocalLogStartOffset$1, AbstractLog log3$1) {
        return log1LocalLogStartOffset$1 == log3$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$15() {
        return "Unexpected LogStartOffset";
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesAndVerifySync$1(TieredPartitionRecoveryTest $this, AbstractLog leaderLog$1, long currentEndOffset$1, int numMessages$4, AbstractLog followerLog$3) {
        return leaderLog$1.logEndOffset() >= currentEndOffset$1 + (long)numMessages$4 && leaderLog$1.logEndOffset() == followerLog$3.logEndOffset() && $this.tierLogSegments(leaderLog$1).size() >= leaderLog$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$appendMessagesAndVerifySync$2(TieredPartitionRecoveryTest $this, AbstractLog leaderLog$1, AbstractLog followerLog$3, long currentEndOffset$1, int numMessages$4) {
        return new StringBuilder(180).append("Timeout waiting for all messages to be written, synced and tiered.").append(" Leader logEndOffset ").append(leaderLog$1.logEndOffset()).append(" Follower logEndOffset ").append(followerLog$3.logEndOffset()).append(" Expected logEndOffset ").append(currentEndOffset$1 + (long)numMessages$4).append(" Tiered Segments ").append($this.tierLogSegments(leaderLog$1).size()).append(" Expected min tiered segments ").append(leaderLog$1.numberOfSegments() - 1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForIsrToChangeTo$1(Partition partition$1, Set expectedIsr$1) {
        return partition$1.inSyncReplicaIds().equals((Object)expectedIsr$1);
    }

    public static final /* synthetic */ String $anonfun$waitForIsrToChangeTo$2(Set expectedIsr$1, Partition partition$1) {
        return new StringBuilder(51).append("Timeout waiting for ISR to change to ").append(expectedIsr$1).append(". Current Isr ").append(partition$1.inSyncReplicaIds()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForReplicaToBeLeader$1(KafkaServer newLeader$1, TopicPartition topicPartition$1) {
        HostedPartition hostedPartition = newLeader$1.replicaManager().getPartition(topicPartition$1);
        HostedPartition.None$ none$ = HostedPartition.None$.MODULE$;
        return hostedPartition == null ? none$ != null : !hostedPartition.equals(none$);
    }

    public static final /* synthetic */ String $anonfun$waitForReplicaToBeLeader$2() {
        return "Timed out waiting for partition object at new leader";
    }

    public static final /* synthetic */ boolean $anonfun$waitForReplicaToBeLeader$3(Partition partition$2) {
        return partition$2.isLeader() && !partition$2.isUncleanLeader();
    }

    public static final /* synthetic */ String $anonfun$waitForReplicaToBeLeader$4() {
        return "Timed out waiting for leader to change and log to be recovered, if needed";
    }

    public TieredPartitionRecoveryTest() {
        this.topicName = "tiered-topic";
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
    }
}

