/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier.management;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator$;
import kafka.tier.backupobjectlifecycle.LifecycleManager;
import kafka.tier.backupobjectlifecycle.LifecycleManagerConfig;
import kafka.tier.backupobjectlifecycle.NameAndId;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0006\r\u0001UAQ!\b\u0001\u0005\u0002yA\u0011\"\t\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0012\t\u000f5\u0002!\u0019!C)]!1Q\u0007\u0001Q\u0001\n=BQA\u000e\u0001\u0005B]BQ!\u0011\u0001\u0005\u0002\tCQa\u0012\u0001\u0005\u0002!CQa\u001b\u0001\u0005\n1DqA \u0001\u0012\u0002\u0013%q\u0010C\u0004\u0002\u0016\u0001!\t!a\u0006\u0003Y\t\u000b7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK6\u000bg.Y4fe\u000e{wN\u001d3D_:4\u0017n\u001a+fgR\u001c(BA\u0007\u000f\u0003)i\u0017M\\1hK6,g\u000e\u001e\u0006\u0003\u001fA\tA\u0001^5fe*\u0011\u0011CE\u0001\u0006W\u000647.\u0019\u0006\u0002'\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]YR\"\u0001\r\u000b\u0005eQ\u0012aA1qS*\t\u0011#\u0003\u0002\u001d1\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0019\u0005Iq\f^3ti&sgm\u001c\t\u0003G-j\u0011\u0001\n\u0006\u00033\u0015R!AJ\u0014\u0002\u000f),\b/\u001b;fe*\u0011\u0001&K\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002U\u0005\u0019qN]4\n\u00051\"#\u0001\u0003+fgRLeNZ8\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t\u0019\u0011J\u001c;\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0005aZ\u0004C\u0001\u0019:\u0013\tQ\u0014G\u0001\u0003V]&$\b\"\u0002\u001f\u0006\u0001\u0004\u0011\u0013\u0001\u0003;fgRLeNZ8)\u0005\u0015q\u0004CA\u0012@\u0013\t\u0001EE\u0001\u0006CK\u001a|'/Z#bG\"\f1\u0004^3tiJ+G/\u001a8uS>tGk\u001c\"bG.,\boQ8oM&<G#\u0001\u001d)\u0005\u0019!\u0005CA\u0012F\u0013\t1EE\u0001\u0003UKN$\u0018a\u0007;fgR\u0014VmY8oM&<WO]3CC\u000e\\W\u000f\u001d)pY&\u001c\u0017\u0010\u0006\u00029\u0013\")!j\u0002a\u0001\u0017\u00061\u0011/^8sk6\u0004\"\u0001T*\u000f\u00055\u000b\u0006C\u0001(2\u001b\u0005y%B\u0001)\u0015\u0003\u0019a$o\\8u}%\u0011!+M\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002Sc!\"qaV0a!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0005qe>4\u0018\u000eZ3s\u0015\taV%\u0001\u0004qCJ\fWn]\u0005\u0003=f\u00131BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH&A1\"\u0003\t\f!A_6)\t\u001d!\u0007.\u001b\t\u0003K\u001al\u0011aW\u0005\u0003On\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003)\f\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003E\tG\u000e^3s\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0005[bTH\u0010\u0005\u0002om6\tqN\u0003\u0002qc\u0006)\u0011\rZ7j]*\u0011!o]\u0001\bG2LWM\u001c;t\u0015\t\tBO\u0003\u0002vS\u00051\u0011\r]1dQ\u0016L!a^8\u0003%\u0005cG/\u001a:D_:4\u0017nZ:SKN,H\u000e\u001e\u0005\u0006s\"\u0001\raS\u0001\baJ|\u0007oS3z\u0011\u0015Y\b\u00021\u0001L\u0003%\u0001(o\u001c9WC2,X\rC\u0004~\u0011A\u0005\t\u0019A&\u0002\u0015\u0015tG/\u001b;z\u001d\u0006lW-A\u000ebYR,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0003Q3aSA\u0002W\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\bc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0011\u0011\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u00057jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s)\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\rRBAA\u000f\u0015\u0011\ty\"!\t\u0002+\t\f7m[;q_\nTWm\u0019;mS\u001a,7-_2mK*\u0011qBG\u0005\u0005\u0003K\tiB\u0001\tMS\u001a,7-_2mK6\u000bg.Y4fe\u0002")
public class BackupObjectLifecycleManagerCoordConfigTests
extends IntegrationTestHarness {
    private TestInfo _testInfo;
    private final int brokerCount;

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
    }

    @Test
    public void testRetentionToBackupConfig() {
        TreeMap retentionToBackup = LifecycleManagerConfig.parseRetentionToBackupConfig((String)"\"0:0,3:3\"");
        Predef$.MODULE$.assert(retentionToBackup.size() == 3);
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToInteger((int)0)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)-1L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        retentionToBackup = LifecycleManagerConfig.parseRetentionToBackupConfig((String)"3:3");
        Predef$.MODULE$.assert(retentionToBackup.size() == 3);
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToInteger((int)0)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)-1L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        retentionToBackup = LifecycleManagerConfig.parseRetentionToBackupConfig((String)"3:3,-1:7");
        Predef$.MODULE$.assert(retentionToBackup.size() == 3);
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToInteger((int)0)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)3)));
        Predef$.MODULE$.assert(BoxesRunTime.equals(retentionToBackup.get(BoxesRunTime.boxToLong((long)-1L)), (Object)BoxesRunTime.boxToInteger((int)7)));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)""));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0033"));
        Assertions.assertThrows(NumberFormatException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"abc:abc"));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0:0,3:3,3:3"));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0:0,3:3,4:2"));
        Assertions.assertThrows(ConfigException.class, () -> LifecycleManagerConfig.parseRetentionToBackupConfig((String)"0:0,3:3,-1:2"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testReconfigureBackupPolicy(String quorum) {
        this.serverConfig().put(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp(), "7");
        this.serverConfig().put(KafkaConfig$.MODULE$.CLMTopicRetentionInDaysToBackupInDaysProp(), "0:0,3:3,4:4,5:5,6:6,7:7");
        super.setUp(this._testInfo);
        NameAndId topic_1h = new NameAndId("topic_1h");
        NameAndId topic_1d = new NameAndId("topic_1d");
        NameAndId topic_2d = new NameAndId("topic_2d");
        NameAndId topic_3d = new NameAndId("topic_3d");
        NameAndId topic_4d = new NameAndId("topic_4d");
        NameAndId topic_5d = new NameAndId("topic_5d");
        NameAndId topic_6d = new NameAndId("topic_6d");
        NameAndId topic_7d = new NameAndId("topic_7d");
        NameAndId topic_8d = new NameAndId("topic_8d");
        NameAndId topic_365d = new NameAndId("topic_365d");
        NameAndId topic_infinite = new NameAndId("topic_infinite");
        HashMap<NameAndId, Long> latestRetentionConfigs = new HashMap<NameAndId, Long>(null, topic_1h, topic_1d, topic_2d, topic_3d, topic_4d, topic_5d, topic_6d, topic_7d, topic_8d, topic_365d, topic_infinite){
            {
                this.put(topic_1h$1, Predef$.MODULE$.long2Long(3600000L));
                this.put(topic_1d$1, Predef$.MODULE$.long2Long(86400000L));
                this.put(topic_2d$1, Predef$.MODULE$.long2Long(172800000L));
                this.put(topic_3d$1, Predef$.MODULE$.long2Long(259200000L));
                this.put(topic_4d$1, Predef$.MODULE$.long2Long(345600000L));
                this.put(topic_5d$1, Predef$.MODULE$.long2Long(432000000L));
                this.put(topic_6d$1, Predef$.MODULE$.long2Long(518400000L));
                this.put(topic_7d$1, Predef$.MODULE$.long2Long(604800000L));
                this.put(topic_8d$1, Predef$.MODULE$.long2Long(691200000L));
                this.put(topic_365d$1, Predef$.MODULE$.long2Long(1471228928L));
                this.put(topic_infinite$1, Predef$.MODULE$.long2Long(-1L));
            }
        };
        LifecycleManager lm = this.lifecycleManager();
        Map backupRetentionDays = lm.getBackupRetentionInDaysForAllTopics((Map)latestRetentionConfigs);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1h), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_2d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_3d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_4d), (Object)BoxesRunTime.boxToInteger((int)4)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_5d), (Object)BoxesRunTime.boxToInteger((int)5)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_6d), (Object)BoxesRunTime.boxToInteger((int)6)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_7d), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_8d), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_infinite), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_365d), (Object)BoxesRunTime.boxToInteger((int)7)) ? 1 : 0) != 0);
        this.alterBrokerConfig(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp(), "3", this.alterBrokerConfig$default$3());
        this.alterBrokerConfig(KafkaConfig$.MODULE$.CLMTopicRetentionInDaysToBackupInDaysProp(), "0:0,3:3", this.alterBrokerConfig$default$3());
        Thread.sleep(2000L);
        backupRetentionDays = lm.getBackupRetentionInDaysForAllTopics((Map)latestRetentionConfigs);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1h), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_1d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_2d), (Object)BoxesRunTime.boxToInteger((int)0)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_3d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_4d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_5d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_6d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_7d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_8d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_infinite), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals(backupRetentionDays.get(topic_365d), (Object)BoxesRunTime.boxToInteger((int)3)) ? 1 : 0) != 0);
    }

    private AlterConfigsResult alterBrokerConfig(String propKey, String propValue, String entityName) {
        AlterConfigsResult alterConfigsResult;
        ConfigResource brokerConfigResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(propKey, propValue), AlterConfigOp.OpType.SET);
        Map<ConfigResource, Set<AlterConfigOp>> toSetOnBroker = Collections.singletonMap(brokerConfigResource, Collections.singleton(alterConfigOp));
        try (ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            alterConfigsResult = adminClient.incrementalAlterConfigs(toSetOnBroker);
        }
        return alterConfigsResult;
    }

    private String alterBrokerConfig$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public LifecycleManager lifecycleManager() {
        TopicPartition tp = new TopicPartition("_confluent-tier-state", BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerCoordConfigTests.$anonfun$lifecycleManager$3(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerCoordConfigTests.$anonfun$lifecycleManager$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (LifecycleManager)this.manager$1(tp).get();
    }

    public static final /* synthetic */ boolean $anonfun$lifecycleManager$1(TopicPartition tp$1, KafkaBroker broker) {
        boolean bl;
        Either either = broker.replicaManager().getPartitionOrError(tp$1);
        if (either instanceof Left) {
            bl = false;
        } else if (either instanceof Right) {
            bl = ((Partition)((Right)either).value()).isLeader();
        } else {
            throw new MatchError((Object)either);
        }
        return bl;
    }

    private final Option manager$1(TopicPartition tp$1) {
        return this.brokers().find((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)BackupObjectLifecycleManagerCoordConfigTests.$anonfun$lifecycleManager$1(tp$1, broker))).flatMap((Function1 & Serializable & scala.Serializable)broker -> ((BackupObjectLifecycleManagerCoordinator)broker.backupObjectLifecycleManagerCoordinatorOpt().get()).customLifecycleManager());
    }

    public static final /* synthetic */ boolean $anonfun$lifecycleManager$3(BackupObjectLifecycleManagerCoordConfigTests $this, TopicPartition tp$1) {
        return $this.manager$1(tp$1).isDefined();
    }

    public static final /* synthetic */ String $anonfun$lifecycleManager$4() {
        return "LifecycleManager not defined yet";
    }

    public BackupObjectLifecycleManagerCoordConfigTests() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.brokerCount = 3;
    }
}

