/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.log.Defaults$;
import kafka.log.LogConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001M4Aa\u0003\u0007\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003[\u0001\u0011\u00051\fC\u0003]\u0001\u0011\u00051\fC\u0003^\u0001\u0011\u00051\fC\u0003_\u0001\u0011\u00051\fC\u0003`\u0001\u0011%\u0001\rC\u0003g\u0001\u0011%qM\u0001\u0010NSJ\u0014xN\u001d+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7\u000fV3ti*\u0011QBD\u0001\u0005Y&t7N\u0003\u0002\u0010!\u0005)1.\u00194lC*\t\u0011#A\u0006j]R,wM]1uS>t7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!!D\f\u000b\u0003=I!!\u0007\f\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\tA\"A\nu_BL7mU=oG&sG/\u001a:wC2l5/F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0017\u0001\u0006;pa&\u001c7+\u001f8d\u0013:$XM\u001d<bY6\u001b\b%\u0001\u000euKN$Hk\u001c9jG\u000e{gNZ5h'ft7-\u00138dYV$W\r\u0006\u0002,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t!QK\\5u\u0011\u0015\u0011D\u00011\u00014\u0003\u0019\tXo\u001c:v[B\u0011Ag\u000f\b\u0003ke\u0002\"AN\u0017\u000e\u0003]R!\u0001\u000f\n\u0002\rq\u0012xn\u001c;?\u0013\tQT&\u0001\u0004Qe\u0016$WMZ\u0005\u0003OqR!AO\u0017)\t\u0011qD*\u0014\t\u0003\u007f)k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003\u0007\u0012\u000ba\u0001]1sC6\u001c(BA#G\u0003\u001dQW\u000f]5uKJT!a\u0012%\u0002\u000b),h.\u001b;\u000b\u0003%\u000b1a\u001c:h\u0013\tY\u0005IA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003\u001dB\u000b\u0013aT\u0001\u0003u.\f\u0013!U\u0001\u0006WJ\fg\r\u001e\u0015\u0005\tM;\u0006\f\u0005\u0002U+6\t!)\u0003\u0002W\u0005\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u00023\u0006A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002%Y,'/\u001b4z\u0013:4\u0018\r\\5e-\u0006dW/\u001a\u000b\u0002W\u0005\u0019d/\u001a:jMfl\u0015N\u001d:peR{\u0007/[2De\u0016\fG/[8o\u001fZ,'O]5eKN\fEn^1zgNKhnY\"p]\u001aLwm]\u0001\u000fm\u0016\u0014\u0018NZ=Pm\u0016\u0014(/\u001b3f\u000351XM]5gs\u0012+g-Y;mi\u0006a1m\u001c8gS\u001ed\u0015n\u001d;PMR\u00111'\u0019\u0005\u0006E&\u0001\raY\u0001\u0006K2,Wn\u001d\t\u0004Y\u0011\u001c\u0014BA3.\u0005)a$/\u001a9fCR,GMP\u0001\rCB\u0004XM\u001c3BY^\f\u0017p\u001d\u000b\u0003g!DQ!\u001b\u0006A\u0002M\n!\u0001^8)\t\u0001Y\u0017O\u001d\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u0012\u000b1!\u00199j\u0013\t\u0001XNA\u0002UC\u001e\fQA^1mk\u0016\f\u0013!\u0005")
public class MirrorTopicConfigSyncRulesTest
extends AbstractClusterLinkIntegrationTest {
    private final String topicSyncIntervalMs;

    public String topicSyncIntervalMs() {
        return this.topicSyncIntervalMs;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicConfigSyncInclude(String quorum) {
        this.verifyInvalidValue();
        this.verifyMirrorTopicCreationOverridesAlwaysSyncConfigs();
        this.verifyOverride();
        this.verifyDefault();
    }

    public void verifyInvalidValue() {
        String linkName = UUID.randomUUID().toString();
        new .colon.colon((Object)this.configListOf((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.RetentionBytesProp()})), (List)new .colon.colon((Object)this.appendAlways(this.configListOf((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.tier.enable"}))), (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties linkConfigOverrides = new Properties(this, (String)value){
                {
                    this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), value$1);
                    this.putAll((java.util.Map<?, ?>)$outer.destLinkProps($outer.destLinkProps$default$1()));
                }
            };
            return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        });
    }

    public void verifyMirrorTopicCreationOverridesAlwaysSyncConfigs() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String topicConfigSyncInclude = this.appendAlways(this.configListOf((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.FlushMsProp()})));
        Properties linkConfigOverrides = new Properties(null, topicConfigSyncInclude){
            {
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncInclude$1);
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
            }
        };
        linkConfigOverrides.putAll((java.util.Map<?, ?>)this.destLinkProps(this.destLinkProps$default$1()));
        this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        scala.collection.immutable.Map mirrorTopicConfigsOverride = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.FlushMsProp()), (Object)"14141414")}));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$1 = this.destCluster();
            short x$2 = this.replicationFactor();
            String x$5 = qual$1.linkTopic$default$5();
            qual$1.linkTopic(topic, x$2, linkName, (Map<String, String>)mirrorTopicConfigsOverride, x$5);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void verifyOverride() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String topicConfigSyncInclude = this.appendAlways(this.configListOf((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.MinCompactionLagMsProp(), LogConfig$.MODULE$.FlushMsProp()})));
        Properties linkConfigOverrides = new Properties(null, topicConfigSyncInclude){
            {
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncInclude$2);
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
            }
        };
        linkConfigOverrides.putAll((java.util.Map<?, ?>)this.destLinkProps(this.destLinkProps$default$1()));
        String minCompactionLagMs = "2222";
        String flushMs = "4444";
        String retentionBytesOverride = "3333333333";
        String tierEnable = "true";
        Properties topicConfigs = new Properties(null, minCompactionLagMs, flushMs, retentionBytesOverride, tierEnable){
            {
                this.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), minCompactionLagMs$1);
                this.put(LogConfig$.MODULE$.FlushMsProp(), flushMs$1);
                this.put(LogConfig$.MODULE$.RetentionBytesProp(), retentionBytesOverride$1);
                this.put(LogConfig$.MODULE$.TierEnableProp(), tierEnable$1);
            }
        };
        this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, x$2, x$3, topicConfigs, x$5);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$7 = this.replicationFactor();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$7, linkName, x$9, x$10);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MirrorTopicConfigSyncRulesTest.$anonfun$verifyOverride$1(this, topic, retentionBytesOverride)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MirrorTopicConfigSyncRulesTest.$anonfun$verifyOverride$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Map expect = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MinCompactionLagMsProp()), (Object)minCompactionLagMs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.FlushMsProp()), (Object)flushMs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TierEnableProp()), (Object)Boolean.toString(Defaults$.MODULE$.TierEnable()))}));
        Assertions.assertTrue((boolean)this.destCluster().describeTopicConfigEquals(topic, (Map<String, String>)expect), (String)"min.compaction.lag.ms should sync, flush.ms should sync, confluent.tier.enable shouldn't sync");
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDefault() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String minCompactionLagMs = "3333333333";
        String flushMs = "11111111";
        Properties topicConfigs = new Properties(null, minCompactionLagMs, flushMs){
            {
                this.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), minCompactionLagMs$2);
                this.put(LogConfig$.MODULE$.FlushMsProp(), flushMs$2);
            }
        };
        this.createClusterLink(linkName, this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, x$2, x$3, topicConfigs, x$5);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        short x$7 = this.replicationFactor();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(topic, x$7, linkName, x$9, x$10);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MirrorTopicConfigSyncRulesTest.$anonfun$verifyDefault$1(this, topic, minCompactionLagMs)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MirrorTopicConfigSyncRulesTest.$anonfun$verifyDefault$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.destCluster().describeTopicConfigEquals(topic, LogConfig$.MODULE$.FlushMsProp(), Long.toString(Defaults$.MODULE$.FlushMs())), (String)"flush.ms shouldn't sync");
    }

    private String configListOf(Seq<String> elems) {
        return elems.mkString(",");
    }

    private String appendAlways(String to) {
        List elems = (List)new .colon.colon((Object)to, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().toList(), List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("elems = ").append(elems).toString());
        return elems.mkString(",");
    }

    public static final /* synthetic */ boolean $anonfun$verifyOverride$1(MirrorTopicConfigSyncRulesTest $this, String topic$2, String retentionBytesOverride$1) {
        return $this.destCluster().describeTopicConfigEquals(topic$2, LogConfig$.MODULE$.RetentionBytesProp(), retentionBytesOverride$1);
    }

    public static final /* synthetic */ String $anonfun$verifyOverride$2() {
        return "retention.bytes should sync";
    }

    public static final /* synthetic */ boolean $anonfun$verifyDefault$1(MirrorTopicConfigSyncRulesTest $this, String topic$3, String minCompactionLagMs$2) {
        return $this.destCluster().describeTopicConfigEquals(topic$3, LogConfig$.MODULE$.MinCompactionLagMsProp(), minCompactionLagMs$2);
    }

    public static final /* synthetic */ String $anonfun$verifyDefault$2() {
        return "min.compaction.lag.ms should sync by default";
    }

    public MirrorTopicConfigSyncRulesTest() {
        this.numPartitions_$eq(1);
        this.topicSyncIntervalMs = "1000";
    }
}

