/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.coordinator.quota;

import integration.kafka.coordinator.quota.TestClientQuotaCallback;
import integration.kafka.coordinator.quota.TestClientQuotaCallback$;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u000e\u001d\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u00049\u0001\u0001\u0006IA\r\u0005\bs\u0001\u0011\r\u0011\"\u00012\u0011\u0019Q\u0004\u0001)A\u0005e!91\b\u0001b\u0001\n\u0003\t\u0004B\u0002\u001f\u0001A\u0003%!\u0007C\u0004>\u0001\t\u0007I\u0011A\u0019\t\ry\u0002\u0001\u0015!\u00033\u0011%y\u0004\u00011AA\u0002\u0013\u0005\u0001\tC\u0005O\u0001\u0001\u0007\t\u0019!C\u0001\u001f\"IQ\u000b\u0001a\u0001\u0002\u0003\u0006K!\u0011\u0005\n-\u0002\u0001\r\u00111A\u0005\u0002]C\u0011B\u0018\u0001A\u0002\u0003\u0007I\u0011A0\t\u0013\u0005\u0004\u0001\u0019!A!B\u0013A\u0006\"\u00032\u0001\u0001\u0004\u0005\r\u0011\"\u0001d\u0011%Q\u0007\u00011AA\u0002\u0013\u00051\u000eC\u0005n\u0001\u0001\u0007\t\u0011)Q\u0005I\")a\u000e\u0001C!_\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0007\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003#\u0001A\u0011AA\u0002\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002:\u0001!I!a\u000f\t\u0013\u0005%\u0005!%A\u0005\n\u0005-%!\u0005#z]\u0006l\u0017nY)v_R\f7\u000fV3ti*\u0011QDH\u0001\u0006cV|G/\u0019\u0006\u0003?\u0001\n1bY8pe\u0012Lg.\u0019;pe*\u0011\u0011EI\u0001\u0006W\u000647.\u0019\u0006\u0002G\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005\rJ#\"A\u0011\n\u0005-B#AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005a\u0012A\u00038v[N+'O^3sgV\t!\u0007\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DGA\u0002J]R\f1B\\;n'\u0016\u0014h/\u001a:tA\u0005Ab.^7Rk>$\u0018m\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\:\u000239,X.U;pi\u0006\u001cHk\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\bEJ|7.\u001a:1\u0003!\u0011'o\\6feB\u0002\u0013a\u00022s_.,'/M\u0001\tEJ|7.\u001a:2A\u0005!A/[7f+\u0005\t\u0005C\u0001\"M\u001b\u0005\u0019%B\u0001#F\u0003\u0015)H/\u001b7t\u0015\t1u)\u0001\u0004d_6lwN\u001c\u0006\u0003C!S!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO&\u0011Qj\u0011\u0002\u0005)&lW-\u0001\u0005uS6,w\fJ3r)\t\u00016\u000b\u0005\u00024#&\u0011!\u000b\u000e\u0002\u0005+:LG\u000fC\u0004U\u0017\u0005\u0005\t\u0019A!\u0002\u0007a$\u0013'A\u0003uS6,\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111,K\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005uS&aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\t\u0001\u0006\rC\u0004U\u001d\u0005\u0005\t\u0019\u0001-\u0002\u000f\r|gNZ5hA\u0005ia.\u001a;x_J\\7\t\\5f]R,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O\u001e\u000bqa\u00197jK:$8/\u0003\u0002jM\nia*\u001a;x_J\\7\t\\5f]R\f\u0011C\\3uo>\u00148n\u00117jK:$x\fJ3r)\t\u0001F\u000eC\u0004U#\u0005\u0005\t\u0019\u00013\u0002\u001d9,Go^8sW\u000ec\u0017.\u001a8uA\u0005)1/\u001a;VaR\u0011\u0001\u000b\u001d\u0005\u0006cN\u0001\rA]\u0001\ti\u0016\u001cH/\u00138g_B\u00111O_\u0007\u0002i*\u0011QO^\u0001\u0004CBL'BA<y\u0003\u001dQW\u000f]5uKJT!!\u001f&\u0002\u000b),h.\u001b;\n\u0005m$(\u0001\u0003+fgRLeNZ8)\u0005Mi\bCA:\u007f\u0013\tyHO\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0003^3tiJ+\u0007o\u001c:u\u0007>t7/^7qi&|g\u000eF\u0001QQ\r!\u0012q\u0001\t\u0004g\u0006%\u0011bAA\u0006i\n!A+Z:u\u0003]!Xm\u001d;Rk>$\u0018m\u001d+pa&\u001cg)Y5m_Z,'\u000fK\u0002\u0016\u0003\u000f\t1\u0003^3tiF+x\u000e^1FqBL'/\u0019;j_:D3AFA\u0004\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cXCAA\r!\u0015\tY\"!\tY\u001b\t\tiBC\u0002\u0002 Q\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019#!\b\u0003\u0007M+\u0017/A\u0006tKJ4XM\u001d)s_B\u001cHCAA\u0015!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tA!\u001e;jY*\u0011\u00111G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00028\u00055\"A\u0003)s_B,'\u000f^5fg\u0006\tr-\u001a;SKF,Xm\u001d;Ck&dG-\u001a:\u0015\u0019\u0005u\u0012\u0011KA+\u0003K\n)(a \u0011\t\u0005}\u00121\n\b\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI#\u0002\u0011I,\u0017/^3tiNLA!!\u0013\u0002D\u0005i\"+\u001a9peR\fVo\u001c;b\u0007>t7/^7qi&|gNU3rk\u0016\u001cH/\u0003\u0003\u0002N\u0005=#a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u0013\n\u0019\u0005\u0003\u0004\u0002Te\u0001\rAM\u0001\tEJ|7.\u001a:JI\"9\u0011qK\rA\u0002\u0005e\u0013aC9v_R\fWI\u001c;jif\u0004B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004;\u0005}#BA\u0010*\u0013\u0011\t\u0019'!\u0018\u0003\u0017E+x\u000e^1F]RLG/\u001f\u0005\b\u0003OJ\u0002\u0019AA5\u0003=\u0019G.[3oiF+x\u000e^1UsB,\u0007\u0003BA6\u0003cj!!!\u001c\u000b\u0007u\tyG\u0003\u0002\\\u000f&!\u00111OA7\u0005=\u0019E.[3oiF+x\u000e^1UsB,\u0007bBA<3\u0001\u0007\u0011\u0011P\u0001\u0006kN\fw-\u001a\t\u0004g\u0005m\u0014bAA?i\t1Ai\\;cY\u0016D\u0011\"!!\u001a!\u0003\u0005\r!a!\u0002\u0013QD'o\u001c;uY\u0016$\u0007cA\u001a\u0002\u0006&\u0019\u0011q\u0011\u001b\u0003\u000f\t{w\u000e\\3b]\u0006Yr-\u001a;SKF,Xm\u001d;Ck&dG-\u001a:%I\u00164\u0017-\u001e7uIU*\"!!$+\t\u0005\r\u0015qR\u0016\u0003\u0003#\u0003B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0014\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002 \u0006U%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class DynamicQuotasTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final int numQuotasTopicPartitions;
    private final int broker0;
    private final int broker1;
    private Time time;
    private KafkaConfig config;
    private NetworkClient networkClient;

    public int numServers() {
        return this.numServers;
    }

    public int numQuotasTopicPartitions() {
        return this.numQuotasTopicPartitions;
    }

    public int broker0() {
        return this.broker0;
    }

    public int broker1() {
        return this.broker1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public void networkClient_$eq(NetworkClient x$1) {
        this.networkClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), "_confluent-quotas", this.numQuotasTopicPartitions());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            DynamicQuotasTest.$anonfun$setUp$1(server);
            return BoxedUnit.UNIT;
        });
        this.config_$eq(((KafkaServer)this.servers().head()).config());
        this.time_$eq(((KafkaServer)this.servers().head()).time());
        Metrics metrics = ((KafkaServer)this.servers().head()).metrics();
        LogContext logContext = new LogContext("DynamicQuotasTest ");
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.config().interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config(), (ListenerName)this.config().interBrokerListenerName(), (String)this.config().saslMechanismInterBrokerProtocol(), (Time)this.time(), (boolean)this.config().saslInterBrokerHandshakeRequestEnable(), (LogContext)logContext);
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), metrics, this.time(), "dynamic-quota-test-client-metrics", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), false, channelBuilder, logContext);
        this.networkClient_$eq(new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), "dynamic-quota-test-client", 1, 50L, 50L, -1, Predef$.MODULE$.Integer2int(this.config().socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config().connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config().connectionSetupTimeoutMaxMs()), this.time(), false, new ApiVersions(), logContext));
    }

    @Test
    public void testReportConsumption() {
        Node node;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
        int partition = ((QuotaCoordinator)((KafkaBroker)this.servers().head()).quotaCoordinatorOpt().get()).partitionFor(quotaEntity);
        Option option = ((KafkaServer)this.servers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option instanceof Some) {
            node = (Node)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            node = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option);
        }
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            int brokerId = server.config().brokerId();
            ReportQuotaConsumptionRequest.Builder requestBuilder = this.getRequestBuilder(brokerId, quotaEntity, ClientQuotaType.PRODUCE, (double)(brokerId + 1) * 100.0, this.getRequestBuilder$default$5());
            ClientRequest request = this.networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)requestBuilder, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$1(response));
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)node, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
                Assertions.fail((String)new StringBuilder(24).append("Node ").append(node).append(" never became ready").toString());
            }
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)request, (Time)this.time());
        });
        Map quotas = ((QuotaDescription)((QuotaCoordinator)((KafkaBroker)this.servers().apply(node.id())).quotaCoordinatorOpt().get()).describeQuota(quotaEntity)._2()).brokerQuotas();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            DynamicQuotasTest.$anonfun$testReportConsumption$3(quotas, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotasTopicFailover() {
        void var28_27;
        void var27_26;
        Node node;
        void var19_18;
        void var18_17;
        Node node2;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
        double usageBroker0 = 1000.0;
        double usageBroker1 = 2000.0;
        int partition = ((QuotaCoordinator)((KafkaBroker)this.servers().head()).quotaCoordinatorOpt().get()).partitionFor(quotaEntity);
        int initialLeader = TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "_confluent-quotas", partition, TestUtils$.MODULE$.waitForPartitionMetadata$default$4()).leader();
        Option option = ((KafkaServer)this.servers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option instanceof Some) {
            node2 = (Node)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            node2 = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option);
        }
        ReportQuotaConsumptionRequest.Builder requestBuilderBroker0 = this.getRequestBuilder(this.broker0(), quotaEntity, ClientQuotaType.PRODUCE, usageBroker0, this.getRequestBuilder$default$5());
        ClientRequest requestBroker0 = this.networkClient().newClientRequest(node2.idString(), (AbstractRequest.Builder)requestBuilderBroker0, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$2(response));
        if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)node2, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
            Assertions.fail((String)new StringBuilder(24).append("Node ").append(node2).append(" never became ready").toString());
        }
        NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)requestBroker0, (Time)this.time());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicQuotasTest.$anonfun$testQuotasTopicFailover$2(this, initialLeader, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicQuotasTest.$anonfun$testQuotasTopicFailover$3(initialLeader));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long lastUpdatedTimestamp = ((QuotaEntry)((QuotaCoordinator)((KafkaBroker)this.servers().apply(initialLeader)).quotaCoordinatorOpt().get()).quotaStateManager().getQuota(quotaEntity).get()).lastUpdatedTimestamp();
        ((KafkaServer)this.servers().apply(initialLeader)).shutdown();
        ((KafkaServer)this.servers().apply(initialLeader)).awaitShutdown();
        int newLeader = TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "_confluent-quotas", partition, TestUtils$.MODULE$.waitForPartitionMetadata$default$4()).leader();
        QuotaCoordinator newCoordinator = (QuotaCoordinator)((KafkaBroker)this.servers().apply(newLeader)).quotaCoordinatorOpt().get();
        Tuple2 tuple2 = newCoordinator.describeQuota(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription loadedQuota = (QuotaDescription)tuple2._2();
        void error2 = var18_17;
        double quotaValue = BoxesRunTime.unboxToDouble((Object)((MapLike)var19_18.brokerQuotas().apply((Object)BoxesRunTime.boxToInteger((int)this.broker0()))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)error2, (String)new StringBuilder(37).append("Got error ").append(error2).append(" when describing quota for ").append(quotaEntity).toString());
        Assertions.assertEquals((double)TestClientQuotaCallback$.MODULE$.clusterLevelQuota(), (double)quotaValue, (String)new StringBuilder(44).append("Loaded quotas ").append(quotaValue).append(" did not match expected quota ").append(TestClientQuotaCallback$.MODULE$.clusterLevelQuota()).toString());
        Assertions.assertEquals((long)lastUpdatedTimestamp, (long)((QuotaEntry)newCoordinator.quotaStateManager().getQuota(quotaEntity).get()).lastUpdatedTimestamp(), (String)new StringBuilder(63).append("Loaded last update timestamp ").append(((QuotaEntry)newCoordinator.quotaStateManager().getQuota(quotaEntity).get()).lastUpdatedTimestamp()).append(" ").append("did not match expected timestamp ").append(lastUpdatedTimestamp).toString());
        ReportQuotaConsumptionRequest.Builder requestBuilderBroker1 = this.getRequestBuilder(this.broker1(), quotaEntity, ClientQuotaType.PRODUCE, usageBroker1, this.getRequestBuilder$default$5());
        Option option2 = ((KafkaServer)this.servers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option2 instanceof Some) {
            node = (Node)((Some)option2).value();
        } else if (None$.MODULE$.equals(option2)) {
            node = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option2);
        }
        ClientRequest request = this.networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)requestBuilderBroker1, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$2(response));
        if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)node, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
            Assertions.fail((String)new StringBuilder(24).append("Node ").append(node).append(" never became ready").toString());
        }
        NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)request, (Time)this.time());
        Tuple2 tuple22 = newCoordinator.describeQuota(quotaEntity);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Errors newError = (Errors)tuple22._1();
        QuotaDescription newLoadedQuota = (QuotaDescription)tuple22._2();
        void newError2 = var27_26;
        void newLoadedQuota2 = var28_27;
        double quotaValueBroker0 = BoxesRunTime.unboxToDouble((Object)((MapLike)newLoadedQuota2.brokerQuotas().apply((Object)BoxesRunTime.boxToInteger((int)this.broker0()))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        double quotaValueBroker1 = BoxesRunTime.unboxToDouble((Object)((MapLike)newLoadedQuota2.brokerQuotas().apply((Object)BoxesRunTime.boxToInteger((int)this.broker1()))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)newError2, (String)new StringBuilder(37).append("Got error ").append(newError2).append(" when describing quota for ").append(quotaEntity).toString());
        Assertions.assertEquals((double)40000.0, (double)quotaValueBroker0, (String)new StringBuilder(51).append("Loaded quotas ").append(quotaValueBroker0).append(" did not match expected quota 40000.0").toString());
        Assertions.assertEquals((double)80000.0, (double)quotaValueBroker1, (String)new StringBuilder(51).append("Loaded quotas ").append(quotaValueBroker1).append(" did not match expected quota 80000.0").toString());
    }

    @Test
    public void testQuotaExpiration() {
        Node node;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
        int partition = ((QuotaCoordinator)((KafkaBroker)this.servers().head()).quotaCoordinatorOpt().get()).partitionFor(quotaEntity);
        Option option = ((KafkaServer)this.servers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option instanceof Some) {
            node = (Node)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            node = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option);
        }
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            int brokerId = server.config().brokerId();
            ReportQuotaConsumptionRequest.Builder requestBuilder = this.getRequestBuilder(brokerId, quotaEntity, ClientQuotaType.PRODUCE, (double)(brokerId + 1) * 100.0, this.getRequestBuilder$default$5());
            ClientRequest request = this.networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)requestBuilder, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$3(response));
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)node, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
                Assertions.fail((String)new StringBuilder(24).append("Node ").append(node).append(" never became ready").toString());
            }
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)request, (Time)this.time());
        });
        Map quotas = ((QuotaDescription)((QuotaCoordinator)((KafkaBroker)this.servers().apply(node.id())).quotaCoordinatorOpt().get()).describeQuota(quotaEntity)._2()).brokerQuotas();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            DynamicQuotasTest.$anonfun$testQuotaExpiration$3(quotas, server);
            return BoxedUnit.UNIT;
        });
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        alterableConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.QuotasExpirationTimeMsProp()).setValue("5000").setConfigOperation(AlterConfigOp.OpType.SET.id()));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(alterableConfigs));
        IncrementalAlterConfigsRequest.Builder alterConfigRequestBuilder = new IncrementalAlterConfigsRequest.Builder(data);
        ClientRequest alterConfigsRequest = this.networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)alterConfigRequestBuilder, this.time().milliseconds(), true);
        NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)alterConfigsRequest, (Time)this.time());
        Thread.sleep(10000L);
        Tuple2 quotasAfterExpiration = ((QuotaCoordinator)((KafkaBroker)this.servers().apply(node.id())).quotaCoordinatorOpt().get()).describeQuota(quotaEntity);
        if (quotasAfterExpiration != null) {
            Errors error = (Errors)quotasAfterExpiration._1();
            QuotaDescription quotaDescription = (QuotaDescription)quotasAfterExpiration._2();
            if (error != null && quotaDescription != null) {
                Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)quotaDescription, (String)new StringBuilder(67).append("Got description ").append(quotaDescription).append(" when describing entity ").append(quotaEntity).append(", but expected an empty map").toString());
                Assertions.assertEquals((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)error, (String)new StringBuilder(24).append("Got error ").append(error).append(" but expected ").append(Errors.QUOTA_ENTITY_NOT_FOUND).toString());
                return;
            }
        }
        throw new MatchError((Object)quotasAfterExpiration);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$3 -> KafkaConfig$.MODULE$.fromProps(x$3, this.serverProps()), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.DynamicQuotaEnabledProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.QuotasTopicPartitionsProp(), Integer.toString(this.numQuotasTopicPartitions()));
        serverProps.put(KafkaConfig$.MODULE$.QuotasTopicReplicationFactorProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), TestClientQuotaCallback.class.getName());
        serverProps.put(KafkaConfig$.MODULE$.QuotasExpirationTimeMsProp(), Integer.toString(0));
        serverProps.put(KafkaConfig$.MODULE$.QuotasExpirationIntervalMsProp(), Integer.toString(2000));
        return var1_1;
    }

    private ReportQuotaConsumptionRequest.Builder getRequestBuilder(int brokerId, QuotaEntity quotaEntity, ClientQuotaType clientQuotaType, double usage, boolean throttled) {
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        quotaEntity.entityTypes().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicQuotasTest.$anonfun$getRequestBuilder$1(entryData, x0$1)));
        entryData.consumptions().add(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType(clientQuotaType.toString()).setUsage(usage).setThrottled(throttled));
        ReportQuotaConsumptionRequestData requestData = new ReportQuotaConsumptionRequestData().setBrokerId(brokerId).setEntries((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)entryData, (List)Nil$.MODULE$)).asJava());
        return new ReportQuotaConsumptionRequest.Builder(requestData);
    }

    private boolean getRequestBuilder$default$5() {
        return false;
    }

    public static final /* synthetic */ String $anonfun$setUp$3(KafkaServer server$1) {
        return new StringBuilder(48).append("Quota coordinator on broker ").append(server$1).append(" never became active").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setUp$1(KafkaServer server) {
        AtomicBoolean atomicBoolean = ((QuotaCoordinator)server.quotaCoordinatorOpt().get()).isActive();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!atomicBoolean.get()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicQuotasTest.$anonfun$setUp$3(server));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private static final void requestCallback$1(ClientResponse response) {
        Assertions.assertEquals((int)1, (int)response.responseBody().errorCounts().size());
        Assertions.assertTrue((boolean)response.responseBody().errorCounts().containsKey(Errors.NONE));
    }

    public static final /* synthetic */ void $anonfun$testReportConsumption$3(Map quotas$1, KafkaServer server) {
        int brokerId = server.config().brokerId();
        double expected = TestClientQuotaCallback$.MODULE$.clusterLevelQuota() / (double)6 * (double)(brokerId + 1);
        double actual = BoxesRunTime.unboxToDouble((Object)((MapLike)quotas$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((double)expected, (double)actual, (String)new StringBuilder(39).append("Got quota of ").append(actual).append(" for broker ").append(brokerId).append(" but expected ").append(expected).toString());
    }

    private static final void requestCallback$2(ClientResponse response) {
        Assertions.assertEquals((int)1, (int)response.responseBody().errorCounts().size());
        Assertions.assertTrue((boolean)response.responseBody().errorCounts().containsKey(Errors.NONE));
    }

    public static final /* synthetic */ boolean $anonfun$testQuotasTopicFailover$2(DynamicQuotasTest $this, int initialLeader$1, int partition$1) {
        boolean x$2;
        TopicPartition x$1;
        LogManager qual$1 = ((KafkaServer)$this.servers().apply(initialLeader$1)).logManager();
        return ((AbstractLog)qual$1.getLog(x$1 = new TopicPartition("_confluent-quotas", partition$1), x$2 = qual$1.getLog$default$2()).get()).highWatermark() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testQuotasTopicFailover$3(int initialLeader$1) {
        return new StringBuilder(65).append("Quota records were not successfully written to the log on broker ").append(initialLeader$1).toString();
    }

    private static final void requestCallback$3(ClientResponse response) {
        Assertions.assertEquals((int)1, (int)response.responseBody().errorCounts().size());
        Assertions.assertTrue((boolean)response.responseBody().errorCounts().containsKey(Errors.NONE));
    }

    public static final /* synthetic */ void $anonfun$testQuotaExpiration$3(Map quotas$2, KafkaServer server) {
        int brokerId = server.config().brokerId();
        double expected = TestClientQuotaCallback$.MODULE$.clusterLevelQuota() / (double)6 * (double)(brokerId + 1);
        double actual = BoxesRunTime.unboxToDouble((Object)((MapLike)quotas$2.apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((double)expected, (double)actual, (String)new StringBuilder(39).append("Got quota of ").append(actual).append(" for broker ").append(brokerId).append(" but expected ").append(expected).toString());
    }

    public static final /* synthetic */ boolean $anonfun$getRequestBuilder$1(ReportQuotaConsumptionRequestData.EntryData entryData$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String entityType = (String)x0$1._1();
        String entityName = (String)x0$1._2();
        boolean bl = entryData$1.entity().add(new ReportQuotaConsumptionRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        return bl;
    }

    public DynamicQuotasTest() {
        this.numServers = 3;
        this.numQuotasTopicPartitions = 3;
        this.broker0 = 0;
        this.broker1 = 1;
    }
}

