/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionLinkState;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeBoolean$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.TopicPartitionZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class TopicPartitionStateZNode$ {
    public static TopicPartitionStateZNode$ MODULE$;

    static {
        new TopicPartitionStateZNode$();
    }

    public String path(TopicPartition partition) {
        return new StringBuilder(6).append(TopicPartitionZNode$.MODULE$.path(partition)).append("/state").toString();
    }

    public byte[] encode(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch) {
        LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
        int controllerEpoch = leaderIsrAndControllerEpoch.controllerEpoch();
        Map partitionState = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leader())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)controllerEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), CollectionConverters$.MODULE$.seqAsJavaListConverter(leaderAndIsr.isr()).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent_is_unclean_leader"), (Object)BoxesRunTime.boxToBoolean((boolean)leaderAndIsr.isUnclean()))}));
        leaderAndIsr.clusterLinkState().foreach((Function1 & Serializable & scala.Serializable)linkState -> {
            Map linkStateMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent_linked_leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)linkState.linkedLeaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent_link_failed"), (Object)BoxesRunTime.boxToBoolean((boolean)linkState.linkFailed()))}));
            return (Map)partitionState.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent_cluster_link"), CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(linkStateMap).asJava()));
        });
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(partitionState).asJava());
    }

    public Option<LeaderIsrAndControllerEpoch> decode(byte[] bytes, Stat stat) {
        return Json$.MODULE$.parseBytes(bytes).map((Function1 & Serializable & scala.Serializable)js -> {
            JsonObject leaderIsrAndEpochInfo = js.asJsonObject();
            int leader = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.apply("leader").to(DecodeJson$DecodeInt$.MODULE$));
            int epoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.apply("leader_epoch").to(DecodeJson$DecodeInt$.MODULE$));
            List isr = (List)leaderIsrAndEpochInfo.apply("isr").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, List$.MODULE$.canBuildFrom()));
            int controllerEpoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.apply("controller_epoch").to(DecodeJson$DecodeInt$.MODULE$));
            Option isUncleanOpt = leaderIsrAndEpochInfo.get("confluent_is_unclean_leader").map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TopicPartitionStateZNode$.$anonfun$decode$26(x$16)));
            Option clusterLinkState = leaderIsrAndEpochInfo.get("confluent_cluster_link").map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.asJsonObject()).map((Function1 & Serializable & scala.Serializable)linkJson -> {
                int linkedLeaderEpoch = BoxesRunTime.unboxToInt((Object)linkJson.apply("confluent_linked_leader_epoch").to(DecodeJson$DecodeInt$.MODULE$));
                boolean linkFailed = linkJson.get("confluent_link_failed").exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TopicPartitionStateZNode$.$anonfun$decode$29(x$18)));
                return new PartitionLinkState(linkedLeaderEpoch, linkFailed);
            });
            int zkPathVersion = stat.getVersion();
            return new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, epoch, (List<Object>)isr, zkPathVersion, BoxesRunTime.unboxToBoolean((Object)isUncleanOpt.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), (Option<PartitionLinkState>)clusterLinkState), controllerEpoch);
        });
    }

    public static final /* synthetic */ boolean $anonfun$decode$26(JsonValue x$16) {
        return BoxesRunTime.unboxToBoolean((Object)x$16.to(DecodeJson$DecodeBoolean$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$decode$29(JsonValue x$18) {
        return BoxesRunTime.unboxToBoolean((Object)x$18.to(DecodeJson$DecodeBoolean$.MODULE$));
    }

    private TopicPartitionStateZNode$() {
        MODULE$ = this;
    }
}

