/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.cluster.Observer$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.ClusterLinksZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rmc\u0001\u0002 @\u0001\u0011C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\u00065\u0002!\ta\u0017\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003kA\u0011\"a\u0013\u0001#\u0003%\t!!\u0014\t\u0013\u0005E\u0003!%A\u0005\u0002\u0005M\u0003\"CA,\u0001E\u0005I\u0011AA*\u0011%\tI\u0006AI\u0001\n\u0003\tY\u0006C\u0004\u0002`\u0001!\t!!\u0019\t\u0013\u0005}\u0004!%A\u0005\u0002\u00055\u0003\"CAA\u0001E\u0005I\u0011AAB\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013C\u0011\"!-\u0001#\u0003%\t!a\u0015\t\u0013\u0005M\u0006!%A\u0005\u0002\u0005M\u0003\"CA[\u0001E\u0005I\u0011AA*\u0011%\t9\fAI\u0001\n\u0003\tY\u0006C\u0004\u0002:\u0002!\t!a/\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0007\"CAp\u0001E\u0005I\u0011AA*\u0011%\t\t\u000fAI\u0001\n\u0003\t\u0019\u0006C\u0005\u0002d\u0002\t\n\u0011\"\u0001\u0002\\!9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d\bbBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\n\u00053\u0001\u0011\u0013!C\u0001\u00057A\u0011Ba\b\u0001#\u0003%\tA!\t\t\u0013\t\u0015\u0002!%A\u0005\u0002\u0005M\u0003\"\u0003B\u0014\u0001E\u0005I\u0011\u0001B\u0015\u0011%\u0011i\u0003AI\u0001\n\u0003\tY\u0006C\u0004\u00030\u0001!\tA!\r\t\u0013\t}\u0002!%A\u0005\u0002\tm\u0001b\u0002B!\u0001\u0011\u0005!1\t\u0005\n\u0005\u001f\u0002\u0011\u0013!C\u0001\u00037BqA!\u0015\u0001\t\u0013\u0011\u0019\u0006C\u0004\u0003f\u0001!\tAa\u001a\t\u000f\t=\u0004\u0001\"\u0001\u0003r!9!q\u0010\u0001\u0005\u0002\t\u0005\u0005b\u0002BE\u0001\u0011\u0005!1\u0012\u0005\b\u0005'\u0003A\u0011\u0001BK\u0011\u001d\u0011i\n\u0001C\u0001\u0005?CqA!*\u0001\t\u0003\u00119\u000bC\u0004\u0003.\u0002!\tAa,\t\u000f\tU\u0006\u0001\"\u0001\u00038\"9!Q\u0017\u0001\u0005\u0002\t}\u0006b\u0002Bc\u0001\u0011\u0005!q\u0019\u0005\b\u0005\u0017\u0004A\u0011\u0001Bg\u0011\u001d\u0011i\u000e\u0001C\u0001\u0005?DqAa9\u0001\t\u0003\u0011)\u000fC\u0004\u0003j\u0002!IAa;\t\u000f\t]\b\u0001\"\u0001\u0003z\"9!q \u0001\u0005\u0002\r\u0005\u0001bBB\u0003\u0001\u0011\u00051q\u0001\u0005\b\u0007\u0017\u0001A\u0011AB\u0007\u0011\u001d\tY\u0010\u0001C\u0001\u0007+Aq!a?\u0001\t\u0003\u0019y\u0002C\u0004\u0004$\u0001!\ta!\n\t\u000f\rU\u0002\u0001\"\u0001\u00048!91Q\b\u0001\u0005\u0002\r}\u0002bBB%\u0001\u0011\u000511\n\u0005\b\u0007\u001f\u0002A\u0011AB)\u0011\u001d\u0019)\u0006\u0001C\u0001\u0007/\u0012Q\"\u00113nS:T6n\u00117jK:$(B\u0001!B\u0003\tQ8NC\u0001C\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A#L!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fMB\u0011AjT\u0007\u0002\u001b*\u0011a*Q\u0001\u0006kRLGn]\u0005\u0003!6\u0013q\u0001T8hO&tw-\u0001\u0005{W\u000ec\u0017.\u001a8u!\t\u0019F+D\u0001@\u0013\t)vHA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005aK\u0006CA*\u0001\u0011\u0015\t&\u00011\u0001S\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u0019q{F.]:~\u0003\u0017\t)\"!\u0007\u0011\u0005\u0019k\u0016B\u00010H\u0005\u0011)f.\u001b;\t\u000b\u0001\u001c\u0001\u0019A1\u0002\u000bQ|\u0007/[2\u0011\u0005\tLgBA2h!\t!w)D\u0001f\u0015\t17)\u0001\u0004=e>|GOP\u0005\u0003Q\u001e\u000ba\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001n\u0012\u0005\u0006[\u000e\u0001\rA\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bC\u0001$p\u0013\t\u0001xIA\u0002J]RDQA]\u0002A\u00029\f\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011\u001d!8\u0001%AA\u0002U\f1\u0002^8qS\u000e\u001cuN\u001c4jOB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0005kRLGNC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q<(A\u0003)s_B,'\u000f^5fg\"9ap\u0001I\u0001\u0002\u0004y\u0018!\u0004:bG.\fu/\u0019:f\u001b>$W\r\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)!Q\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0003\u0013\t\u0019AA\u0007SC\u000e\\\u0017i^1sK6{G-\u001a\u0005\n\u0003\u001b\u0019\u0001\u0013!a\u0001\u0003\u001f\t\u0011#^:fg6{G-\u001a:o)>\u0004\u0018nY%e!\r1\u0015\u0011C\u0005\u0004\u0003'9%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003/\u0019\u0001\u0013!a\u0001\u0003\u001f\t\u0011#^:fg2+w-Y2z)>\u0004\u0018nY%e\u0011%\tYb\u0001I\u0001\u0002\u0004\ti\"A\u0006dYV\u001cH/\u001a:MS:\\\u0007#\u0002$\u0002 \u0005\r\u0012bAA\u0011\u000f\n1q\n\u001d;j_:\u0004B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0003mS:\\'bAA\u0017\u0003\u000611/\u001a:wKJLA!!\r\u0002(\t)2\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY*uCR,\u0017!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003oQ3!^A\u001dW\t\tY\u0004\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAA#\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0013q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H%N\u000b\u0003\u0003\u001fR3a`A\u001d\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIY*\"!!\u0016+\t\u0005=\u0011\u0011H\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00138\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIa*\"!!\u0018+\t\u0005u\u0011\u0011H\u0001\u0013O\u0016$(I]8lKJlU\r^1eCR\f7\u000f\u0006\u0004\u0002d\u0005U\u0014q\u000f\t\u0007\u0003K\nY'a\u001c\u000e\u0005\u0005\u001d$bAA5\u000f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0014q\r\u0002\u0004'\u0016\f\b\u0003BA\u0001\u0003cJA!a\u001d\u0002\u0004\tq!I]8lKJlU\r^1eCR\f\u0007b\u0002@\n!\u0003\u0005\ra \u0005\n\u0003sJ\u0001\u0013!a\u0001\u0003w\n!B\u0019:pW\u0016\u0014H*[:u!\u00151\u0015qDA?!\u0015\t)'a\u001bo\u0003q9W\r\u001e\"s_.,'/T3uC\u0012\fG/Y:%I\u00164\u0017-\u001e7uIE\nAdZ3u\u0005J|7.\u001a:NKR\fG-\u0019;bg\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0006*\"\u00111PA\u001d\u0003e\u0019'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;\u0015\u001fq\u000bY)!$\u0002\u0012\u0006\u001d\u00161VAW\u0003_CQ\u0001\u0019\u0007A\u0002\u0005Da!a$\r\u0001\u0004)\u0018AB2p]\u001aLw\rC\u0004\u0002\u00142\u0001\r!!&\u00025A\f'\u000f^5uS>t'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\u0011\u000f\u0005\u0015\u0014q\u00138\u0002\u001c&!\u0011\u0011TA4\u0005\ri\u0015\r\u001d\t\u0005\u0003;\u000b\u0019+\u0004\u0002\u0002 *\u0019\u0011\u0011U!\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0002&\u0006}%!\u0005*fa2L7-Y!tg&<g.\\3oi\"I\u0011\u0011\u0016\u0007\u0011\u0002\u0003\u0007\u0011qB\u0001\tm\u0006d\u0017\u000eZ1uK\"I\u0011Q\u0002\u0007\u0011\u0002\u0003\u0007\u0011q\u0002\u0005\n\u0003/a\u0001\u0013!a\u0001\u0003\u001fA\u0011\"a\u0007\r!\u0003\u0005\r!!\b\u0002G\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u00193M]3bi\u0016$v\u000e]5d/&$\b.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012*\u0014aI2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$C-\u001a4bk2$HEN\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003-!x\u000e]5d\u000bbL7\u000f^:\u0015\t\u0005=\u0011Q\u0018\u0005\u0007\u0003\u007f\u000b\u0002\u0019A1\u0002\u0013Q|\u0007/[2OC6,\u0017a\u0005<bY&$\u0017\r^3U_BL7m\u0011:fCR,Gc\u0002/\u0002F\u0006\u001d\u0017\u0011\u001a\u0005\u0006AJ\u0001\r!\u0019\u0005\b\u0003'\u0013\u0002\u0019AAK\u0011\u0019\tyI\u0005a\u0001k\u0006irO]5uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000fF\u0007]\u0003\u001f\f\t.!6\u0002Z\u0006m\u0017Q\u001c\u0005\u0006AN\u0001\r!\u0019\u0005\b\u0003'\u001c\u0002\u0019AAK\u0003E\u0011X\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0005\b\u0003/\u001c\u0002\u0019AA\b\u0003!I7/\u00169eCR,\u0007\"CA\u0007'A\u0005\t\u0019AA\b\u0011%\t9b\u0005I\u0001\u0002\u0004\ty\u0001C\u0005\u0002\u001cM\u0001\n\u00111\u0001\u0002\u001e\u00059sO]5uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d:(/\u001b;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$H\u0005Z3gCVdG\u000fJ\u001b\u0002O]\u0014\u0018\u000e^3U_BL7\rU1si&$\u0018n\u001c8BgNLwM\\7f]R$C-\u001a4bk2$HEN\u0001\fI\u0016dW\r^3U_BL7\rF\u0002]\u0003SDQ\u0001Y\fA\u0002\u0005\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cHCEAK\u0003_\f\t0!>\u0002z\u0006u(\u0011\u0001B\u0003\u0005/AQ\u0001\u0019\rA\u0002\u0005Dq!a=\u0019\u0001\u0004\t)*\u0001\nfq&\u001cH/\u001b8h\u0003N\u001c\u0018n\u001a8nK:$\bbBA|1\u0001\u0007\u00111M\u0001\u000bC2d'I]8lKJ\u001c\b\u0002CA~1A\u0005\t\u0019\u00018\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011%\t\u0019\u000e\u0007I\u0001\u0002\u0004\ty\u0010E\u0003G\u0003?\t)\nC\u0005\u0003\u0004a\u0001\n\u00111\u0001\u0002\u0010\u0005aa/\u00197jI\u0006$Xm\u00148ms\"I!q\u0001\r\u0011\u0002\u0003\u0007!\u0011B\u0001\u000fi>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u!\u00151\u0015q\u0004B\u0006!\u0011\u0011iAa\u0005\u000e\u0005\t=!b\u0001B\t\u0003\u000611m\\7n_:LAA!\u0006\u0003\u0010\tqAk\u001c9jGBc\u0017mY3nK:$\b\"CA\u000e1A\u0005\t\u0019AA\u000f\u0003]\tG\r\u001a)beRLG/[8og\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\u001e)\u001aa.!\u000f\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012*TC\u0001B\u0012U\u0011\ty0!\u000f\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u00122\u0014aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011YC\u000b\u0003\u0003\n\u0005e\u0012aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00139\u0003u\u0019'/Z1uK:+w\u000fU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8nK:$HCDAK\u0005g\u0011)Da\u000e\u0003:\tm\"Q\b\u0005\u0006Az\u0001\r!\u0019\u0005\b\u0003gt\u0002\u0019AAK\u0011\u001d\t9P\ba\u0001\u0003GB\u0001\"a?\u001f!\u0003\u0005\rA\u001c\u0005\b\u0003't\u0002\u0019AA\u0000\u0011\u001d\u00119A\ba\u0001\u0005\u0013\tqe\u0019:fCR,g*Z<QCJ$\u0018\u000e^5p]N\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005q2M]3bi\u0016\u0004\u0016M\u001d;ji&|gn],ji\"\f5o]5h]6,g\u000e\u001e\u000b\u000b\u0003+\u0013)Ea\u0012\u0003J\t5\u0003\"\u00021!\u0001\u0004\t\u0007bBAzA\u0001\u0007\u0011Q\u0013\u0005\b\u0005\u0017\u0002\u0003\u0019AAK\u0003YqWm\u001e)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$\b\"CA\u000eAA\u0005\t\u0019AA\u000f\u0003!\u001a'/Z1uKB\u000b'\u000f^5uS>t7oV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003e1\u0018\r\\5eCR,'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\u0015\u000fq\u0013)Fa\u0016\u0003\\!9\u00111\u001b\u0012A\u0002\u0005U\u0005B\u0002B-E\u0001\u0007a.A\rfqB,7\r^3e%\u0016\u0004H.[2bi&|gNR1di>\u0014\bb\u0002B/E\u0001\u0007!qL\u0001\u0013CZ\f\u0017\u000e\\1cY\u0016\u0014%o\\6fe&#7\u000f\u0005\u0003c\u0005Cr\u0017b\u0001B2W\n\u00191+\u001a;\u0002\u0017A\f'o]3Ce>\\WM\u001d\u000b\u0005\u0005S\u0012Y\u0007\u0005\u0003G\u0003?q\u0007B\u0002B7G\u0001\u0007\u0011-\u0001\u0004ce>\\WM]\u0001\u000eG\"\fgnZ3D_:4\u0017nZ:\u0015\u000fq\u0013\u0019Ha\u001e\u0003|!1!Q\u000f\u0013A\u0002\u0005\f!\"\u001a8uSRLH+\u001f9f\u0011\u0019\u0011I\b\na\u0001C\u0006QQM\u001c;jift\u0015-\\3\t\r\tuD\u00051\u0001v\u0003\u001d\u0019wN\u001c4jON\fAc\u00195b]\u001e,7\t\\5f]RLEmQ8oM&<G#\u0002/\u0003\u0004\n\u001d\u0005B\u0002BCK\u0001\u0007\u0011-A\ttC:LG/\u001b>fI\u000ec\u0017.\u001a8u\u0013\u0012DaA! &\u0001\u0004)\u0018AH2iC:<W-V:fe>\u0013Xk]3s\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015a&Q\u0012BI\u0011\u0019\u0011yI\na\u0001C\u0006\u00192/\u00198ji&TX\rZ#oi&$\u0018PT1nK\"1!Q\u0010\u0014A\u0002U\f\u0001C^1mS\u0012\fG/Z%q\u0007>tg-[4\u0015\u000bq\u00139Ja'\t\r\teu\u00051\u0001b\u0003\tI\u0007\u000f\u0003\u0004\u0003~\u001d\u0002\r!^\u0001\u000fG\"\fgnZ3Ja\u000e{gNZ5h)\u0015a&\u0011\u0015BR\u0011\u0019\u0011I\n\u000ba\u0001C\"1!Q\u0010\u0015A\u0002U\f1C^1mS\u0012\fG/\u001a+pa&\u001c7i\u001c8gS\u001e$R\u0001\u0018BU\u0005WCQ\u0001Y\u0015A\u0002\u0005DaA! *\u0001\u0004)\u0018!E2iC:<W\rV8qS\u000e\u001cuN\u001c4jOR)AL!-\u00034\")\u0001M\u000ba\u0001C\"1!Q\u0010\u0016A\u0002U\f!c\u00195b]\u001e,'I]8lKJ\u001cuN\u001c4jOR)AL!/\u0003>\"9!1X\u0016A\u0002\u0005u\u0014a\u00022s_.,'o\u001d\u0005\u0007\u0005{Z\u0003\u0019A;\u0015\u000bq\u0013\tMa1\t\u000f\t5D\u00061\u0001\u0003j!1!Q\u0010\u0017A\u0002U\fAC^1mS\u0012\fG/\u001a\"s_.,'oQ8oM&<Gc\u0001/\u0003J\"1!QP\u0017A\u0002U\fqc\u00195b]\u001e,7\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0015\u000bq\u0013yM!7\t\u000f\tEg\u00061\u0001\u0003T\u00061A.\u001b8l\u0013\u0012\u00042A\u001eBk\u0013\r\u00119n\u001e\u0002\u0005+VKE\t\u0003\u0004\u0003\\:\u0002\r!^\u0001\u0010a\u0016\u00148/[:uK:$\bK]8qg\u00061b-\u001a;dQ\u000ecWo\u001d;fe2Kgn[\"p]\u001aLw\rF\u0002v\u0005CDqA!50\u0001\u0004\u0011\u0019.A\ff]N,(/Z\"mkN$XM\u001d'j].,\u00050[:ugR\u0019ALa:\t\u000f\tE\u0007\u00071\u0001\u0003T\u0006\u00112\r[1oO\u0016,e\u000e^5us\u000e{gNZ5h)\u001da&Q\u001eBy\u0005kDaAa<2\u0001\u0004\t\u0017A\u0004:p_R,e\u000e^5usRK\b/\u001a\u0005\u0007\u0005g\f\u0004\u0019A1\u0002/\u0019,H\u000e\\*b]&$\u0018N_3e\u000b:$\u0018\u000e^=OC6,\u0007B\u0002B?c\u0001\u0007Q/A\tgKR\u001c\u0007.\u00128uSRL8i\u001c8gS\u001e$R!\u001eB~\u0005{DaAa<3\u0001\u0004\t\u0007B\u0002BHe\u0001\u0007\u0011-\u0001\nhKR\fE\u000e\u001c+pa&\u001c7i\u001c8gS\u001e\u001cHCAB\u0002!\u0019\t)'a&bk\u0006)b-\u001a;dQ\u0006cG.\u00128uSRL8i\u001c8gS\u001e\u001cH\u0003BB\u0002\u0007\u0013AaA!\u001e5\u0001\u0004\t\u0017A\u00074fi\u000eD\u0017\t\u001c7DQ&dG-\u00128uSRL8i\u001c8gS\u001e\u001cHCBB\u0002\u0007\u001f\u0019\t\u0002\u0003\u0004\u0003pV\u0002\r!\u0019\u0005\u0007\u0007')\u0004\u0019A1\u0002\u001f\rD\u0017\u000e\u001c3F]RLG/\u001f+za\u0016$Baa\u0006\u0004\u001aA1\u0011QMALC:Dqaa\u00077\u0001\u0004\u0019i\"\u0001\u0004u_BL7m\u001d\t\u0005E\n\u0005\u0014\r\u0006\u0003\u0003j\r\u0005\u0002\"\u000218\u0001\u0004\t\u0017!E2sK\u0006$Xm\u00117vgR,'\u000fT5oWR)Ala\n\u00042!91\u0011\u0006\u001dA\u0002\r-\u0012aD2mkN$XM\u001d'j].$\u0015\r^1\u0011\u0007M\u001bi#C\u0002\u00040}\u0012qb\u00117vgR,'\u000fT5oW\u0012\u000bG/\u0019\u0005\u0007\u0007gA\u0004\u0019A;\u0002#A,'o]5ti\u0016tGoQ8oM&<7/\u0001\bhKR\u001cE.^:uKJd\u0015N\\6\u0015\t\re21\b\t\u0006\r\u0006}11\u0006\u0005\b\u0005#L\u0004\u0019\u0001Bj\u0003=9W\r^\"mkN$XM\u001d'j].\u001cH\u0003BB!\u0007\u0007\u0002\u0002\"!\u001a\u0002\u0018\nM71\u0006\u0005\b\u0007\u000bR\u0004\u0019AB$\u0003\u001da\u0017N\\6JIN\u0004RA\u0019B1\u0005'\f!cZ3u\u00032d7\t\\;ti\u0016\u0014H*\u001b8lgR\u00111Q\n\t\u0007\u0003K\nYga\u000b\u0002\u001dM,Go\u00117vgR,'\u000fT5oWR\u0019Ala\u0015\t\u000f\r%B\b1\u0001\u0004,\u0005\tB-\u001a7fi\u0016\u001cE.^:uKJd\u0015N\\6\u0015\u0007q\u001bI\u0006C\u0004\u0003Rv\u0002\rAa5")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map replicaAssignment = (Map)AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)Nil$.MODULE$));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        boolean x$7 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, (Map<Object, ReplicaAssignment>)replicaAssignment, x$7, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public boolean createTopic$default$7() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopic$default$8() {
        return None$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable & scala.Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode2 != null ? !rackAwareMode2.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()), Seq$.MODULE$.canBuildFrom()));
        return (Seq)seq.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, ReplicaAssignment> partitionReplicaAssignment, boolean validate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, false, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public boolean createTopicWithAssignment$default$6() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopicWithAssignment$default$7() {
        return None$.MODULE$;
    }

    public boolean topicExists(String topicName) {
        return this.zkClient.topicExists(topicName);
    }

    public void validateTopicCreate(String topic, Map<Object, ReplicaAssignment> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            Set<String> allTopics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            Set collidingTopics = (Set)allTopics.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$2(x$4)), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$3(x$5)), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of observers");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable & scala.Serializable)assignment -> {
            AdminZkClient.$anonfun$validateTopicCreate$4(partitionReplicaAssignment, assignment);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((TraversableOnce)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig$.MODULE$.validate(config);
    }

    public void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        try {
            scala.collection.immutable.Map assignment = ((TraversableOnce)replicaAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int partitionId = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (!isUpdate) {
                None$ legacyTopicIdOpt = usesLegacyTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                None$ topicIdOpt = usesModernTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Option<Uuid>)legacyTopicIdOpt, (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink);
            } else {
                TopicZNode.TopicIdReplicaAssignment oldAssignment = (TopicZNode.TopicIdReplicaAssignment)this.zkClient.getReplicaAssignmentAndTopicIdForTopics((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).head();
                this.zkClient.setTopicAssignment(topic, oldAssignment.topicId(), oldAssignment.legacyTopicId(), (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink, this.zkClient.setTopicAssignment$default$6());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public boolean writeTopicPartitionAssignment$default$5() {
        return false;
    }

    public Option<ClusterLinkTopicState> writeTopicPartitionAssignment$default$6() {
        return None$.MODULE$;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, ReplicaAssignment> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, boolean validateOnly, Option<TopicPlacement> topicPlacement, Option<ClusterLinkTopicState> clusterLink) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment, topicPlacement);
        if (validateOnly) {
            return existingAssignment.$plus$plus(proposedAssignmentForNewPartitions);
        }
        return this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions, clusterLink);
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, ReplicaAssignment>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Option<TopicPlacement> addPartitions$default$7() {
        return None$.MODULE$;
    }

    public Option<ClusterLinkTopicState> addPartitions$default$8() {
        return None$.MODULE$;
    }

    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, Option<TopicPlacement> topicPlacement) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)proposedReplicaAssignment -> {
            this.validateReplicaAssignment((Map<Object, ReplicaAssignment>)proposedReplicaAssignment, existingAssignmentPartition0.size(), (Set<Object>)((TraversableOnce)allBrokers.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Seq$.MODULE$.canBuildFrom())).toSet());
            return BoxedUnit.UNIT;
        });
        return (Map)((Map)replicaAssignment.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            int startIndex = scala.math.package$.MODULE$.max(0, allBrokers.indexWhere((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$5(existingAssignmentPartition0, x$8))));
            return Observer$.MODULE$.getReplicaAssignment(allBrokers, topicPlacement, partitionsToAdd, existingAssignmentPartition0.size(), startIndex, existingAssignment.size());
        })).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int tp = x0$1._1$mcI$sp();
            ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment, Option<ClusterLinkTopicState> clusterLink) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(newPartitionAssignment).append(".").toString());
        Map combinedAssignment = existingAssignment.$plus$plus(newPartitionAssignment);
        boolean x$3 = true;
        boolean x$5 = this.writeTopicPartitionAssignment$default$4();
        boolean x$6 = this.writeTopicPartitionAssignment$default$5();
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, x$3, x$5, x$6, clusterLink);
        return combinedAssignment;
    }

    public Option<ClusterLinkTopicState> createPartitionsWithAssignment$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private void validateReplicaAssignment(Map<Object, ReplicaAssignment> replicaAssignment, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(partitionId, assignment) -> {
            AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), assignment);
            return BoxedUnit.UNIT;
        };
        Map<Object, ReplicaAssignment> map = Implicits$.MODULE$.MapExtensionMethods(replicaAssignment);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new scala.Serializable(null, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, ReplicaAssignment>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    ReplicaAssignment assignment = (ReplicaAssignment)x1._2();
                    if (assignment.replicas().size() != this.expectedReplicationFactor$1) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)assignment.replicas().size()));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, ReplicaAssignment> x1) {
                boolean bl = x1 != null && ((ReplicaAssignment)x1._2()).replicas().size() != this.expectedReplicationFactor$1;
                return bl;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)), Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)), Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        None$ none$;
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            none$ = None$.MODULE$;
        } else {
            Some some;
            try {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(broker)).toInt()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
            }
            none$ = some;
        }
        return none$;
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        String string5 = ConfigType$.MODULE$.Ip();
        if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
            this.changeIpConfig(entityName, configs);
            return;
        }
        String string6 = ConfigType$.MODULE$.ClusterLink();
        if (!(string6 != null ? !string6.equals(entityType) : entityType != null)) {
            throw new IllegalArgumentException("Cluster link configs can be altered only using Admin API");
        }
        throw new IllegalArgumentException(new StringBuilder(45).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.all()).toString());
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Ip(), ip, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(broker), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable & scala.Serializable)x$9 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$9))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    public void changeClusterLinkConfig(UUID linkId, Properties persistentProps) {
        this.ensureClusterLinkExists(linkId);
        this.changeEntityConfig(ConfigType$.MODULE$.ClusterLink(), linkId.toString(), persistentProps);
    }

    public Properties fetchClusterLinkConfig(UUID linkId) {
        return this.fetchEntityConfig(ConfigType$.MODULE$.ClusterLink(), linkId.toString());
    }

    public void ensureClusterLinkExists(UUID linkId) {
        if (!this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable & scala.Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable & scala.Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Object> numPartitions(Set<String> topics) {
        return (Map)this.zkClient.getPartitionsForTopics(topics).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            Seq partitions = (Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitions.size()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public Option<Object> numPartitions(String topic) {
        return this.zkClient.getTopicPartitionCount(topic);
    }

    public void createClusterLink(ClusterLinkData clusterLinkData, Properties persistentConfigs) {
        UUID linkId = clusterLinkData.linkId();
        if (this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkExistsException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' already exists.").toString());
        }
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString(), persistentConfigs);
        this.zkClient.createClusterLink(clusterLinkData);
        this.zkClient.createConfigChangeNotification(new StringBuilder(0).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(linkId).toString());
    }

    public Option<ClusterLinkData> getClusterLink(UUID linkId) {
        return this.zkClient.getClusterLinks((Set<UUID>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).get((Object)linkId);
    }

    public Map<UUID, ClusterLinkData> getClusterLinks(Set<UUID> linkIds) {
        return this.zkClient.getClusterLinks(linkIds);
    }

    public Seq<ClusterLinkData> getAllClusterLinks() {
        return this.zkClient.getClusterLinks((Set<UUID>)((TraversableOnce)this.zkClient.getChildren(ClusterLinksZNode$.MODULE$.path()).map((Function1 & Serializable & scala.Serializable)x$1 -> UUID.fromString(x$1), Seq$.MODULE$.canBuildFrom())).toSet()).values().toSeq();
    }

    public void setClusterLink(ClusterLinkData clusterLinkData) {
        UUID linkId = clusterLinkData.linkId();
        this.ensureClusterLinkExists(linkId);
        this.zkClient.setClusterLink(clusterLinkData);
        this.zkClient.createConfigChangeNotification(new StringBuilder(0).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(linkId).toString());
    }

    public void deleteClusterLink(UUID linkId) {
        this.ensureClusterLinkExists(linkId);
        this.zkClient.deleteClusterLink(linkId);
        this.zkClient.deleteEntityConfig(ConfigType$.MODULE$.ClusterLink(), linkId.toString(), this.zkClient.deleteEntityConfig$default$3());
        this.zkClient.createConfigChangeNotification(new StringBuilder(0).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(linkId).toString());
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$2(ReplicaAssignment x$4) {
        return x$4.replicas().size();
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$3(ReplicaAssignment x$5) {
        return x$5.observers().size();
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$4(Map partitionReplicaAssignment$2, ReplicaAssignment assignment) {
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
        if (assignment.observers().size() != assignment.observers().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(38).append("Duplicate observers assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$8) {
        return x$8.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ void $anonfun$validateReplicaAssignment$1(Set availableBrokerIds$1, int partitionId, ReplicaAssignment assignment) {
        if (assignment.replicas().isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(assignment.replicas().mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
        }
        if (!assignment.replicas().toSet().subsetOf((GenSet)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(assignment.replicas().mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        void var1_1;
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int partitionId = x0$1._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        void var1_1;
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int partitionId = x0$2._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        void var1_1;
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        int rf = x0$3._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$9) {
        return Integer.toString(x$9);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        Seq seq;
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        Seq entityNames = this.zkClient.getAllEntitiesWithConfig(string);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            seq = (Seq)entityNames.map((Function1 & Serializable & scala.Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString(), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(rootPath)) {
            seq = entityNames;
        } else {
            throw new MatchError((Object)rootPath);
        }
        return seq;
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
        Logging.$init$(this);
    }
}

