/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Some;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001\u0002\n\u0014\u0001aA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015)\b\u0001\"\u0003w\u0011\u0015A\b\u0001\"\u0003z\u0011\u0015Y\b\u0001\"\u0003}\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!!\u0003\u0001\t\u0013\tY\u0001\u0003\u0004c\u0001\u0011%\u0011q\u0002\u0005\b\u0003k\u0001A\u0011BA\u001c\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!a!\u0001\t\u0013\t)\tC\u0004\u0002\u0004\u0002!I!a%\u0003-Q+7\u000f\u001e*bMR\u0014V-];fgRD\u0015M\u001c3mKJT!\u0001F\u000b\u0002\u000bQ|w\u000e\\:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u00013})\u0003C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g\r\u0005\u0002!G5\t\u0011E\u0003\u0002#+\u000511/\u001a:wKJL!\u0001J\u0011\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cH\u000fS1oI2,'\u000f\u0005\u0002'S5\tqE\u0003\u0002)+\u0005)Q\u000f^5mg&\u0011!f\n\u0002\b\u0019><w-\u001b8h\u0003-\u0011\u0018M\u001a;NC:\fw-\u001a:1\u00055*\u0004c\u0001\u00182g5\tqF\u0003\u00021+\u0005!!/\u00194u\u0013\t\u0011tFA\u0006SC\u001a$X*\u00198bO\u0016\u0014\bC\u0001\u001b6\u0019\u0001!\u0011BN\u0001\u0002\u0002\u0003\u0005)\u0011A\u001c\u0003\u0007}#\u0013'\u0005\u00029wA\u0011!$O\u0005\u0003um\u0011qAT8uQ&tw\r\u0005\u0002\u001by%\u0011Qh\u0007\u0002\u0004\u0003:L\u0018A\u0004:fcV,7\u000f^\"iC:tW\r\u001c\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005V\tqA\\3uo>\u00148.\u0003\u0002E\u0003\nq!+Z9vKN$8\t[1o]\u0016d\u0017\u0001\u0002;j[\u0016\u0004\"a\u0012)\u000e\u0003!S!\u0001K%\u000b\u0005)[\u0015AB2p[6|gN\u0003\u0002\u0017\u0019*\u0011QJT\u0001\u0007CB\f7\r[3\u000b\u0003=\u000b1a\u001c:h\u0013\t\t\u0006J\u0001\u0003US6,\u0017!E1qSZ+'o]5p]6\u000bg.Y4feB\u0011\u0001\u0005V\u0005\u0003+\u0006\u0012\u0011#\u00119j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q)\u0001LW0aCB\u0011\u0011\fA\u0007\u0002'!)1&\u0002a\u00017B\u0012AL\u0018\t\u0004]Ej\u0006C\u0001\u001b_\t%1$,!A\u0001\u0002\u000b\u0005q\u0007C\u0003?\u000b\u0001\u0007q\bC\u0003F\u000b\u0001\u0007a\tC\u0003S\u000b\u0001\u00071+\u0001\u0004iC:$G.\u001a\u000b\u0004I\u001e\u0004\bC\u0001\u000ef\u0013\t17D\u0001\u0003V]&$\b\"\u00025\u0007\u0001\u0004I\u0017a\u0002:fcV,7\u000f\u001e\t\u0003U6t!\u0001Q6\n\u00051\f\u0015A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0003]>\u0014qAU3rk\u0016\u001cHO\u0003\u0002m\u0003\")\u0011O\u0002a\u0001e\u0006q!-\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\bCA$t\u0013\t!\bJ\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\u0002#!\fg\u000e\u001a7f\u0003BLg+\u001a:tS>t7\u000f\u0006\u0002eo\")\u0001n\u0002a\u0001S\u0006Q\u0001.\u00198eY\u00164v\u000e^3\u0015\u0005\u0011T\b\"\u00025\t\u0001\u0004I\u0017A\u00065b]\u0012dWMQ3hS:\fVo\u001c:v[\u0016\u0003xn\u00195\u0015\u0005\u0011l\b\"\u00025\n\u0001\u0004I\u0017\u0001\u00065b]\u0012dW-\u00128e#V|'/^7Fa>\u001c\u0007\u000eF\u0002e\u0003\u0003AQ\u0001\u001b\u0006A\u0002%\f1\u0002[1oI2,g)\u001a;dQR\u0019A-a\u0002\t\u000b!\\\u0001\u0019A5\u0002'!\fg\u000e\u001a7f\r\u0016$8\r[*oCB\u001c\bn\u001c;\u0015\u0007\u0011\fi\u0001C\u0003i\u0019\u0001\u0007\u0011\u000eF\u0003e\u0003#\t\u0019\u0002C\u0003i\u001b\u0001\u0007\u0011\u000eC\u0004\u0002\u00165\u0001\r!a\u0006\u0002\u001b\t,\u0018\u000e\u001c3SKN\u0004xN\\:f!\u001dQ\u0012\u0011DA\u000f\u0003SI1!a\u0007\u001c\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019#S\u0001\taJ|Go\\2pY&!\u0011qEA\u0011\u0005)\t\u0005/['fgN\fw-\u001a\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF%\u0002\u0011I,\u0017/^3tiNLA!a\r\u0002.\t\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\fQ\u0006tG\r\\3FeJ|'\u000fF\u0003e\u0003s\tY\u0004C\u0003i\u001d\u0001\u0007\u0011\u000eC\u0004\u0002>9\u0001\r!a\u0010\u0002\u0007\u0015\u0014(\u000f\u0005\u0003\u0002B\u0005Ec\u0002BA\"\u0003\u001brA!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013:\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\r\tyeG\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u0003\u0013QC'o\\<bE2,'bAA(7\u0005y1\r\\8tK\u000e{gN\\3di&|g\u000eF\u0003e\u00037\ni\u0006C\u0003i\u001f\u0001\u0007\u0011\u000eC\u0004\u0002`=\u0001\r!!\u0019\u0002\u0017\u0015\u0014(o\u001c:D_VtGo\u001d\t\t\u0003G\ni'!\u001d\u0002x5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'\u0001\u0003vi&d'BAA6\u0003\u0011Q\u0017M^1\n\t\u0005=\u0014Q\r\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0010\u0003gJA!!\u001e\u0002\"\t1QI\u001d:peN\u0004B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0005\u0003{\nI'\u0001\u0003mC:<\u0017\u0002BAA\u0003w\u0012q!\u00138uK\u001e,'/\u0001\u0007tK:$'+Z:q_:\u001cX\rF\u0003e\u0003\u000f\u000bI\tC\u0003i!\u0001\u0007\u0011\u000eC\u0004\u0002\fB\u0001\r!!$\u0002\u0017I,7\u000f]8og\u0016|\u0005\u000f\u001e\t\u00065\u0005=\u0015\u0011F\u0005\u0004\u0003#[\"AB(qi&|g\u000eF\u0002e\u0003+Cq!a&\u0012\u0001\u0004\tI*\u0001\u0005sKN\u0004xN\\:f!\rQ\u00171T\u0005\u0004\u0003;{'\u0001\u0003*fgB|gn]3")
public class TestRaftRequestHandler
implements ApiRequestHandler,
Logging {
    private final RaftManager<?> raftManager;
    private final RequestChannel requestChannel;
    private final Time time;
    private final ApiVersionManager apiVersionManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void handle(RequestChannel.Request request, BufferSupplier bufferSupplier) {
        block13: {
            try {
                try {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Handling request:").append(request.requestDesc(true)).append(" from connection ").append(request$1.context().connectionId).append(";").append("securityProtocol:").append(request$1.context().securityProtocol).append(",principal:").append(request$1.context().principal).toString());
                    ApiKeys apiKeys = request.header().apiKey();
                    if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                        this.handleApiVersions(request);
                        break block13;
                    }
                    if (ApiKeys.VOTE.equals(apiKeys)) {
                        this.handleVote(request);
                        break block13;
                    }
                    if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleBeginQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleEndQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH.equals(apiKeys)) {
                        this.handleFetch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                        this.handleFetchSnapshot(request);
                        break block13;
                    }
                    throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported api key: ").append(request.header().apiKey()).toString());
                }
                catch (FatalExitError fatalExitError) {
                    throw fatalExitError;
                }
                catch (Throwable e) {
                    this.handleError(request, e);
                }
            }
            finally {
                if (request.apiLocalCompleteTimeNanos() < 0L) {
                    request.apiLocalCompleteTimeNanos_$eq(this.time.nanoseconds());
                }
            }
        }
    }

    private void handleApiVersions(RequestChannel.Request request) {
        this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)this.apiVersionManager.apiVersionResponse(0)));
    }

    private void handleVote(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)res));
        });
    }

    private void handleBeginQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)res));
        });
    }

    private void handleEndQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)res));
        });
    }

    private void handleFetch(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)res));
        });
    }

    private void handleFetchSnapshot(RequestChannel.Request request) {
        Function1 & Serializable & scala.Serializable handle_buildResponse = (Function1 & Serializable & scala.Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)res));
        });
    }

    private void handle(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        this.raftManager.handleRequest(request.header(), requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)res));
        });
    }

    private void handleError(RequestChannel.Request request, Throwable err) {
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Error when handling request: ").append("clientId=").append(request.header().clientId()).append(", ").append("correlationId=").append(request.header().correlationId()).append(", ").append("api=").append(request.header().apiKey()).append(", ").append("version=").append(request.header().apiVersion()).append(", ").append("body=").append(request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> err);
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        AbstractResponse response = requestBody.getErrorResponse(0, err);
        if (response == null) {
            this.closeConnection(request, requestBody.errorCounts(err));
            return;
        }
        this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)response));
    }

    private void closeConnection(RequestChannel.Request request, java.util.Map<Errors, Integer> errorCounts) {
        this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(errorCounts).asScala()));
        this.requestChannel.sendResponse(new RequestChannel.CloseConnectionResponse(request));
    }

    private void sendResponse(RequestChannel.Request request, Option<AbstractResponse> responseOpt) {
        RequestChannel.Response response2;
        responseOpt.foreach((Function1 & Serializable & scala.Serializable)response -> {
            this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()));
            return BoxedUnit.UNIT;
        });
        if (responseOpt instanceof Some) {
            AbstractResponse response3 = (AbstractResponse)((Some)responseOpt).value();
            Send responseSend = request.context().buildResponseSend(response3);
            response2 = new RequestChannel.SendResponse(request, responseSend, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        } else if (None$.MODULE$.equals(responseOpt)) {
            response2 = new RequestChannel.NoOpResponse(request);
        } else {
            throw new MatchError(responseOpt);
        }
        this.sendResponse(response2);
    }

    private void sendResponse(RequestChannel.Response response) {
        this.requestChannel.sendResponse(response);
    }

    public TestRaftRequestHandler(RaftManager<?> raftManager, RequestChannel requestChannel, Time time, ApiVersionManager apiVersionManager) {
        this.raftManager = raftManager;
        this.requestChannel = requestChannel;
        this.time = time;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
    }
}

