/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.tier.tools.common.FenceEventInfo;

public class RestoreInfo {

    public static class RestoreRawOutput {
        private static final ObjectMapper JSON_SERDE = new ObjectMapper();
        private final RestoreRawInput input;
        private final String restore;

        public RestoreRawOutput(@JsonProperty(value="input") RestoreRawInput input, @JsonProperty(value="restore") String restore) {
            this.input = input;
            this.restore = restore;
        }

        @JsonProperty(value="input", required=true)
        public RestoreRawInput input() {
            return this.input;
        }

        @JsonProperty(value="restore", required=true)
        public String restore() {
            return this.restore;
        }

        public String toString() {
            return "RestoreRawOutput{restoreRawInput=" + this.input + '\'' + ", restore=" + Optional.ofNullable(this.restore) + '}';
        }

        public static void writeJsonToFile(List<RestoreRawOutput> outputList, OutputStream outputStream) throws IOException {
            JSON_SERDE.writeValue(outputStream, outputList);
        }

        public static List<RestoreRawOutput> readJsonFromFile(Path inputJsonFile) throws IOException {
            return (List)JSON_SERDE.readValue(inputJsonFile.toFile(), (TypeReference)new TypeReference<List<RestoreRawOutput>>(){});
        }

        static {
            JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        }
    }

    public static class RestoreRawInput {
        private static final ObjectMapper JSON_SERDE = new ObjectMapper();
        private final FenceEventInfo fenceEventInfo;
        private final Path path;

        public RestoreRawInput(@JsonProperty(value="fenceEventInfo") FenceEventInfo fenceEventInfo, @JsonProperty(value="path") Path path) {
            this.fenceEventInfo = fenceEventInfo;
            this.path = path;
        }

        @JsonProperty(value="fenceEventInfo", required=true)
        public FenceEventInfo fenceEventInfo() {
            return this.fenceEventInfo;
        }

        @JsonProperty(value="path", required=true)
        public Path path() {
            return this.path;
        }

        public String toString() {
            return "RestoreRawInput{fenceEventInfo=" + this.fenceEventInfo + '\'' + ", path=" + this.path + '}';
        }

        public static void writeJsonToFile(List<RestoreRawInput> outputList, OutputStream outputStream) throws IOException {
            JSON_SERDE.writeValue(outputStream, outputList);
        }

        public static List<RestoreRawInput> readJsonFromFile(Path inputJsonFile) throws IOException {
            return (List)JSON_SERDE.readValue(inputJsonFile.toFile(), (TypeReference)new TypeReference<List<RestoreRawInput>>(){});
        }

        static {
            JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        }
    }

    public static class ComparatorReplicaInfo {
        private final String replica;
        private final Path path;
        public final String header;
        private final boolean validationSuccess;

        public ComparatorReplicaInfo(@JsonProperty(value="replica") String replica, @JsonProperty(value="path") String path, @JsonProperty(value="header") String header, @JsonProperty(value="validationSuccess") boolean validationSuccess) {
            this.replica = replica;
            this.path = Paths.get(path, new String[0]);
            this.header = header;
            this.validationSuccess = validationSuccess;
        }

        public Path path() {
            return this.path;
        }

        public String replica() {
            return this.replica;
        }

        public boolean validationSuccess() {
            return this.validationSuccess;
        }

        public String header() {
            return this.header;
        }

        public String toString() {
            return "ComparatorReplicaInfo{header=" + this.header + ", replica='" + this.replica + "', path=" + this.path + ", validationSuccess=" + this.validationSuccess + '}';
        }
    }

    public static class RestoreComparatorOutput {
        private static final ObjectMapper JSON_SERDE = new ObjectMapper();
        private final RestoreComparatorInput input;
        private final String restore;

        public RestoreComparatorOutput(@JsonProperty(value="input") RestoreComparatorInput input, @JsonProperty(value="restore") String restore) {
            this.input = input;
            this.restore = restore;
        }

        @JsonProperty(value="input", required=true)
        public RestoreComparatorInput input() {
            return this.input;
        }

        @JsonProperty(value="restore")
        public String restore() {
            return this.restore;
        }

        public String toString() {
            return "RestoreComparatorOutput{restoreComparatorInput=" + this.input + '\'' + ", restore=" + this.restore + '}';
        }

        public static void writeJsonToFile(List<RestoreComparatorOutput> outputList, OutputStream outputStream) throws IOException {
            JSON_SERDE.writeValue(outputStream, outputList);
        }

        public static List<RestoreComparatorOutput> readJsonFromFile(Path inputJsonFile) throws IOException {
            return (List)JSON_SERDE.readValue(inputJsonFile.toFile(), (TypeReference)new TypeReference<List<RestoreComparatorOutput>>(){});
        }

        static {
            JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        }
    }

    public static class RestoreComparatorInput {
        private static final ObjectMapper JSON_SERDE = new ObjectMapper();
        private final Map<String, ComparatorReplicaInfo> replicas;
        private final ComparatorReplicaInfo choice;
        private final ComparatorReplicaInfo rematerialized;
        private final FenceEventInfo input;

        public RestoreComparatorInput(@JsonProperty(value="replicas") Map<String, ComparatorReplicaInfo> replicas, @JsonProperty(value="rematerialized") ComparatorReplicaInfo rematerialized, @JsonProperty(value="choice") ComparatorReplicaInfo choice, @JsonProperty(value="input") FenceEventInfo input) {
            this.replicas = replicas;
            this.choice = choice;
            this.input = input;
            this.rematerialized = rematerialized;
        }

        @JsonProperty(value="choice", required=true)
        public ComparatorReplicaInfo choice() {
            return this.choice;
        }

        @JsonProperty(value="replicas", required=true)
        public Map<String, ComparatorReplicaInfo> replicas() {
            return this.replicas;
        }

        @JsonProperty(value="input", required=true)
        public FenceEventInfo input() {
            return this.input;
        }

        @JsonProperty(value="rematerialized", required=true)
        public ComparatorReplicaInfo rematerialized() {
            return this.rematerialized;
        }

        public String toString() {
            return "RestoreComparatorInput{replicas=" + this.replicas + ", choice='" + this.choice + '\'' + ", input='" + this.input + '\'' + ", rematerialized=" + this.rematerialized + '}';
        }

        public static void writeJsonToFile(List<RestoreComparatorInput> outputList, OutputStream outputStream) throws IOException {
            JSON_SERDE.writeValue(outputStream, outputList);
        }

        public static List<RestoreComparatorInput> readJsonFromFile(Path inputJsonFile) throws IOException {
            return (List)JSON_SERDE.readValue(inputJsonFile.toFile(), (TypeReference)new TypeReference<List<RestoreComparatorInput>>(){});
        }

        static {
            JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        }
    }
}

