/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class FenceEventInfo {
    public final String topic;
    public final String topicIdBase64;
    public final int partition;
    public final String recordMessageIdBase64;
    public final long recordOffset;
    public final int recordPartition;
    public final long recordTimestamp;
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();

    @JsonCreator
    public FenceEventInfo(@JsonProperty(value="topic") String topic, @JsonProperty(value="topicIdBase64") String topicIdBase64, @JsonProperty(value="partition") int partition, @JsonProperty(value="recordMessageIdBase64") String recordMessageIdBase64, @JsonProperty(value="recordOffset") long recordOffset, @JsonProperty(value="recordPartition") int recordPartition, @JsonProperty(value="recordTimestamp") long recordTimestamp) {
        this.topic = topic;
        this.topicIdBase64 = topicIdBase64;
        this.partition = partition;
        this.recordMessageIdBase64 = recordMessageIdBase64;
        this.recordOffset = recordOffset;
        this.recordPartition = recordPartition;
        this.recordTimestamp = recordTimestamp;
    }

    @JsonProperty(value="topic", required=true)
    public String topic() {
        return this.topic;
    }

    @JsonProperty(value="topicIdBase64", required=true)
    public String topicIdBase64() {
        return this.topicIdBase64;
    }

    @JsonProperty(value="partition", required=true)
    public int partition() {
        return this.partition;
    }

    @JsonProperty(value="recordMessageIdBase64", required=true)
    public String recordMessageIdBase64() {
        return this.recordMessageIdBase64;
    }

    @JsonProperty(value="recordOffset", required=true)
    public long recordOffset() {
        return this.recordOffset;
    }

    @JsonProperty(value="recordPartition", required=true)
    public int recordPartition() {
        return this.recordPartition;
    }

    @JsonProperty(value="recordTimestamp", required=true)
    public long recordTimestamp() {
        return this.recordTimestamp;
    }

    public String toJson() {
        try {
            return JSON_SERDE.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String listToJson(List<FenceEventInfo> events) {
        try {
            return JSON_SERDE.writeValueAsString(events);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FenceEventInfo)) {
            return false;
        }
        FenceEventInfo fenceEventInfo = (FenceEventInfo)o;
        return Objects.equals(this.topic, fenceEventInfo.topic) && Objects.equals(this.topicIdBase64, fenceEventInfo.topicIdBase64) && Objects.equals(this.partition, fenceEventInfo.partition) && Objects.equals(this.recordMessageIdBase64, fenceEventInfo.recordMessageIdBase64) && Objects.equals(this.recordOffset, fenceEventInfo.recordOffset) && Objects.equals(this.recordPartition, fenceEventInfo.recordPartition) && Objects.equals(this.recordTimestamp, fenceEventInfo.recordTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.topicIdBase64, this.partition, this.recordMessageIdBase64, this.recordOffset, this.recordPartition, this.recordTimestamp);
    }

    public String toString() {
        return String.format("FenceEventInfo(topic=%s, topicIdBase64=%s, partition=%d, recordMessageIdBase64=%s, recordOffset=%d, recordPartition=%d, recordTimestamp=%d)", this.topic(), this.topicIdBase64(), this.partition(), this.recordMessageIdBase64(), this.recordOffset(), this.recordPartition(), this.recordTimestamp());
    }

    public static List<FenceEventInfo> jsonToList(Path inputJsonFile) throws IOException {
        return (List)JSON_SERDE.readValue(inputJsonFile.toFile(), (TypeReference)new TypeReference<List<FenceEventInfo>>(){});
    }

    static {
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

