/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.util.Optional;
import kafka.server.KafkaConfig;
import kafka.tier.store.TierObjectStoreConfig;
import scala.compat.java8.OptionConverters;

public class S3TierObjectStoreConfig
extends TierObjectStoreConfig {
    public String s3Bucket;
    public String s3Region;
    public String s3Prefix;
    public Optional<String> s3CredFilePath;
    public Optional<String> s3EndpointOverride;
    public Optional<String> s3SignerOverride;
    public String s3SseAlgorithm;
    public String s3SseCustomerEncryptionKey;
    public Integer s3AutoAbortThresholdBytes;
    public Optional<String> assumeRoleArn;
    public Boolean s3ForcePathStyleAccess;
    public String s3UserAgentPrefix;

    public S3TierObjectStoreConfig(Optional<String> clusterIdOpt, KafkaConfig config) {
        super(clusterIdOpt, config);
        this.validateConfig(config);
        this.s3Bucket = config.tierS3Bucket();
        this.s3Region = config.tierS3Region();
        this.s3Prefix = config.tierS3Prefix();
        this.s3CredFilePath = OptionConverters.toJava(config.tierS3CredFilePath());
        this.s3EndpointOverride = OptionConverters.toJava(config.tierS3EndpointOverride());
        this.s3SignerOverride = OptionConverters.toJava(config.tierS3SignerOverride());
        if (!config.tierS3SseAlgorithm().equals(KafkaConfig.TIER_S3_SSE_ALGORITHM_NONE())) {
            this.s3SseAlgorithm = config.tierS3SseAlgorithm();
        }
        this.s3SseCustomerEncryptionKey = config.s3SseCustomerEncryptionKey();
        this.s3AutoAbortThresholdBytes = config.tierS3AutoAbortThresholdBytes();
        this.assumeRoleArn = OptionConverters.toJava(config.tierS3AssumeRoleArn());
        this.s3ForcePathStyleAccess = config.tierS3ForcePathStyleAccess();
        this.s3UserAgentPrefix = config.tierS3UserAgentPrefix();
    }

    protected S3TierObjectStoreConfig(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt, String bucket, String region, String credFilePath, String endpointOverride, String signerOverride, String sseAlgorithm, String s3SseCustomerEncryptionKey, Integer s3AutoAbortThresholdBytes, String s3Prefix, String assumeRoleArn, Boolean s3ForcePathStyleAccess, String s3UserAgentPrefix) {
        super(clusterIdOpt, brokerIdOpt);
        this.s3Bucket = bucket;
        this.s3Region = region;
        this.s3CredFilePath = Optional.ofNullable(credFilePath);
        this.s3EndpointOverride = Optional.ofNullable(endpointOverride);
        this.s3SignerOverride = Optional.ofNullable(signerOverride);
        this.s3SseAlgorithm = sseAlgorithm;
        this.s3SseCustomerEncryptionKey = s3SseCustomerEncryptionKey;
        this.s3AutoAbortThresholdBytes = s3AutoAbortThresholdBytes;
        this.s3Prefix = s3Prefix;
        this.assumeRoleArn = Optional.ofNullable(assumeRoleArn);
        this.s3ForcePathStyleAccess = s3ForcePathStyleAccess;
        this.s3UserAgentPrefix = s3UserAgentPrefix;
    }

    static S3TierObjectStoreConfig createWithEmptyClusterIdBrokerId(String bucket, String region, String credFilePath, String endpointOverride, String signerOverride, String sseAlgorithm, String s3SseCustomerEncryptionKey, Integer s3AutoAbortThresholdBytes, String s3Prefix, String assumeRoleArn, Boolean s3ForcePathStyleAccess, String s3UserAgentPrefix) {
        return new S3TierObjectStoreConfig(Optional.empty(), Optional.empty(), bucket, region, credFilePath, endpointOverride, signerOverride, sseAlgorithm, s3SseCustomerEncryptionKey, s3AutoAbortThresholdBytes, s3Prefix, assumeRoleArn, s3ForcePathStyleAccess, s3UserAgentPrefix);
    }

    private void validateConfig(KafkaConfig config) {
        if (config.tierS3Region() == null && config.tierS3EndpointOverride().isEmpty()) {
            throw new IllegalArgumentException(KafkaConfig.TierS3RegionProp() + " or " + KafkaConfig.TierS3EndpointOverrideProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to S3.");
        }
        if (config.tierS3Bucket() == null) {
            throw new IllegalArgumentException(KafkaConfig.TierS3BucketProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to S3.");
        }
        if (config.tierS3EndpointOverride().isDefined() && config.tierS3Region() == null) {
            throw new IllegalArgumentException(KafkaConfig.TierS3RegionProp() + " must be set if " + KafkaConfig.TierS3EndpointOverrideProp() + " is set.");
        }
    }
}

