/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreResponse;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Utils;

public class MockInMemoryTierObjectStore
implements TierObjectStore,
AutoCloseable {
    public volatile boolean throwExceptionOnSegmentFetch = false;
    public volatile boolean throwExceptionOnTransactionFetch = false;
    private static final ConcurrentHashMap<String, byte[]> KEY_TO_BLOB = new ConcurrentHashMap();
    private final ConcurrentHashMap<TierObjectStore.FileType, Integer> objectCounts = new ConcurrentHashMap();
    private final TierObjectStoreConfig config;

    public MockInMemoryTierObjectStore(TierObjectStoreConfig config) {
        this.config = config;
    }

    public ConcurrentHashMap<String, byte[]> getStored() {
        return KEY_TO_BLOB;
    }

    public ConcurrentHashMap<TierObjectStore.FileType, Integer> getObjectCounts() {
        return this.objectCounts;
    }

    private boolean shouldThrow(TierObjectStore.FileType objectFileType) {
        return this.throwExceptionOnSegmentFetch && objectFileType == TierObjectStore.FileType.SEGMENT || this.throwExceptionOnTransactionFetch && objectFileType == TierObjectStore.FileType.TRANSACTION_INDEX;
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return TierObjectStore.Backend.Mock;
    }

    @Override
    public TierObjectStoreResponse getObject(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType objectFileType, Integer byteOffset, Integer byteOffsetEnd) throws IOException {
        if (this.shouldThrow(objectFileType)) {
            throw new IOException("");
        }
        String key = this.keyPath(objectMetadata, objectFileType);
        byte[] blob = KEY_TO_BLOB.get(key);
        if (blob == null) {
            throw new IOException(String.format("No bytes for key %s", key));
        }
        int start = byteOffset == null ? 0 : byteOffset;
        int end = byteOffsetEnd == null ? blob.length : Math.min(byteOffsetEnd, blob.length);
        int byteBufferSize = end - start;
        ByteBuffer buf = ByteBuffer.allocate(byteBufferSize);
        buf.put(blob, start, byteBufferSize);
        buf.flip();
        return new MockInMemoryTierObjectStoreResponse(new ByteArrayInputStream(blob));
    }

    @Override
    public void close() {
    }

    private void incrementObjectCount(TierObjectStore.FileType fileType) {
        this.objectCounts.compute(fileType, (key, integer) -> {
            int n;
            if (integer == null) {
                n = 1;
            } else {
                Integer n2 = integer;
                Integer n3 = integer = Integer.valueOf(integer + 1);
                n = n2;
            }
            return n;
        });
    }

    @Override
    public void putSegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) {
        this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.SEGMENT), segmentData);
        this.incrementObjectCount(TierObjectStore.FileType.SEGMENT);
        this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.OFFSET_INDEX), offsetIndexData);
        this.incrementObjectCount(TierObjectStore.FileType.OFFSET_INDEX);
        this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.TIMESTAMP_INDEX), timestampIndexData);
        this.incrementObjectCount(TierObjectStore.FileType.TIMESTAMP_INDEX);
        producerStateSnapshotData.ifPresent(data -> {
            this.writeFileToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.PRODUCER_STATE), (File)data);
            this.incrementObjectCount(TierObjectStore.FileType.PRODUCER_STATE);
        });
        transactionIndexData.ifPresent(data -> {
            this.writeBufToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.TRANSACTION_INDEX), (ByteBuffer)data);
            this.incrementObjectCount(TierObjectStore.FileType.TRANSACTION_INDEX);
        });
        if (epochState.isPresent()) {
            this.writeBufToArray(this.keyPath(objectMetadata, TierObjectStore.FileType.EPOCH_STATE), epochState.get());
            this.incrementObjectCount(TierObjectStore.FileType.EPOCH_STATE);
        }
    }

    @Override
    public void putObject(TierObjectStore.ObjectStoreMetadata objectMetadata, File file, TierObjectStore.FileType fileType) {
        this.writeFileToArray(this.keyPath(objectMetadata, fileType), file);
    }

    @Override
    public void deleteSegment(TierObjectStore.ObjectMetadata objectMetadata) {
        for (TierObjectStore.FileType type : TierObjectStore.FileType.values()) {
            KEY_TO_BLOB.remove(this.keyPath(objectMetadata, type));
        }
    }

    private String keyPath(TierObjectStore.ObjectStoreMetadata objectMetadata, TierObjectStore.FileType fileType) {
        return objectMetadata.toPath("", fileType);
    }

    private void writeFileToArray(String filePath, File file) {
        try (FileChannel sourceChan = FileChannel.open(file.toPath(), new OpenOption[0]);){
            ByteBuffer buf = ByteBuffer.allocate((int)sourceChan.size());
            sourceChan.read(buf);
            KEY_TO_BLOB.put(filePath, buf.array());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeBufToArray(String filePath, ByteBuffer buf) {
        try {
            ByteBufferInputStream inputStream = new ByteBufferInputStream(buf);
            byte[] bs = new byte[buf.limit()];
            Utils.readFully((InputStream)inputStream, (byte[])bs);
            KEY_TO_BLOB.put(filePath, bs);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private static class MockInMemoryTierObjectStoreResponse
    implements TierObjectStoreResponse {
        private final InputStream inputStream;

        MockInMemoryTierObjectStoreResponse(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

