/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.IOException;
import java.util.Optional;
import kafka.log.TierLogSegment;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.errors.KafkaStorageException;

public class TierUtils {
    private static Optional<MetadataWithOffset> metadataForOffset(TierPartitionState partitionState, long offset) throws KafkaStorageException {
        try {
            return partitionState.metadata(offset).map(metadata -> new MetadataWithOffset(offset, (TierObjectMetadata)metadata));
        }
        catch (IOException e) {
            throw new KafkaStorageException((Throwable)e);
        }
    }

    public static Optional<TierLogSegment> tierLogSegmentForOffset(TierPartitionState partitionState, long offset, Optional<TierObjectStore> objectStore) {
        return TierUtils.metadataForOffset(partitionState, offset).map(metadataOpt -> new TierLogSegment(metadataOpt.metadata, metadataOpt.startOffset, (TierObjectStore)objectStore.get()));
    }

    private static class MetadataWithOffset {
        long startOffset;
        TierObjectMetadata metadata;

        MetadataWithOffset(long startOffset, TierObjectMetadata metadata) {
            this.startOffset = startOffset;
            this.metadata = metadata;
        }
    }
}

