/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.common.FollowerRestorePoint;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import org.apache.kafka.common.TopicPartition;

public interface TierPartitionState {
    public TopicPartition topicPartition();

    public Optional<TopicIdPartition> topicIdPartition();

    public File dir();

    public Optional<Long> startOffset() throws IOException;

    public boolean setTopicId(UUID var1) throws IOException;

    public long committedEndOffset() throws IOException;

    public long endOffset() throws IOException;

    public OffsetAndEpoch lastLocalMaterializedSrcOffsetAndEpoch();

    public int numSegments();

    public int numSegments(long var1, long var3);

    public Iterator<TierObjectMetadata> segments();

    public Iterator<TierObjectMetadata> segments(long var1, long var3);

    public List<FileTierPartitionState.TierInMemorySegmentMetadata> segmentInMemoryMetadataRange(long var1, long var3);

    public Optional<FileTierPartitionState.TierInMemorySegmentMetadata> immediatePreviousInMemoryMetadata(long var1);

    public FollowerRestorePoint followerRestorePoint(long var1);

    public Optional<TierObjectMetadata> metadata(long var1) throws IOException;

    public Collection<TierObjectMetadata> fencedSegments();

    public AppendResult append(AbstractTierMetadata var1, OffsetAndEpoch var2);

    public RestoreResult restoreState(TierPartitionForceRestore var1, ByteBuffer var2, TierPartitionStatus var3, OffsetAndEpoch var4);

    public long totalSize() throws IOException;

    public int tierEpoch() throws IOException;

    public boolean isTieringEnabled();

    public boolean mayContainTieredData();

    public boolean maybeOpenChannelOnOffsetTieredException() throws IOException;

    public boolean setTieringEnabled() throws IOException;

    public void setTieringDisabled();

    public boolean flush() throws IOException;

    public void beginCatchup();

    public void onCatchUpComplete();

    public CompletableFuture<TierObjectMetadata> materializeUptoOffset(long var1) throws IOException;

    public CompletableFuture<TierObjectMetadata> materializeUptoObjectIdAndRestoreEpoch(long var1, UUID var3, int var4) throws IOException;

    public CompletableFuture<Optional<TierObjectMetadata>> materializeUptoLeaderEpoch(int var1) throws IOException;

    public CompletableFuture<Boolean> trackMetadataInitialization(int var1) throws IOException;

    public TierPartitionStatus status();

    public long materializationLag();

    public void updateDir(File var1);

    public void delete() throws IOException;

    public void close() throws IOException;

    public void closeHandlers() throws IOException;

    public static enum RestoreResult {
        SUCCEEDED,
        FAILED;

    }

    public static enum AppendResult {
        NOT_TIERABLE,
        FENCED,
        ACCEPTED,
        FAILED,
        RESTORE_FENCED;

    }
}

