/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Utils;

abstract class AbstractInputStreamFixedSizeIterator<T>
extends AbstractIterator<T> {
    private final InputStream inputStream;
    final byte[] indexEntryBytes;

    AbstractInputStreamFixedSizeIterator(InputStream inputStream, int entrySize) {
        this.inputStream = inputStream;
        this.indexEntryBytes = new byte[entrySize];
    }

    protected T makeNext() {
        try {
            if (Utils.readFully((InputStream)this.inputStream, (byte[])this.indexEntryBytes) == this.indexEntryBytes.length) {
                return this.toIndexEntry();
            }
            return (T)this.allDone();
        }
        catch (IOException e) {
            this.allDone();
            throw new UncheckedIOException(e);
        }
    }

    abstract T toIndexEntry();
}

