/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.serdes.SegmentUploadComplete;
import kafka.tier.state.OffsetAndEpoch;

public class TierSegmentUploadComplete
extends AbstractTierSegmentMetadata {
    private static final byte VERSION_V1 = 1;
    private static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 64;
    private final TopicIdPartition topicIdPartition;
    private final SegmentUploadComplete metadata;

    public TierSegmentUploadComplete(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, OffsetAndEpoch stateOffset) {
        FlatBufferBuilder builder = new FlatBufferBuilder(64).forceDefaults(true);
        SegmentUploadComplete.startSegmentUploadComplete(builder);
        SegmentUploadComplete.addVersion(builder, (byte)1);
        SegmentUploadComplete.addTierEpoch(builder, tierEpoch);
        int offsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffset.offset(), stateOffset.epoch().orElse(-1));
        SegmentUploadComplete.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        SegmentUploadComplete.addObjectId(builder, objectIdOffset);
        int entryId = SegmentUploadComplete.endSegmentUploadComplete(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = SegmentUploadComplete.getRootAsSegmentUploadComplete(builder.dataBuffer());
    }

    public TierSegmentUploadComplete(TierSegmentUploadInitiate uploadInitiate) {
        this(uploadInitiate.topicIdPartition(), uploadInitiate.tierEpoch(), uploadInitiate.objectId(), uploadInitiate.stateOffsetAndEpoch());
    }

    public TierSegmentUploadComplete(TopicIdPartition topicIdPartition, SegmentUploadComplete metadata) {
        if (metadata.version() >= 1 && metadata.stateOffsetAndEpoch() == null) {
            throw new IllegalArgumentException(String.format("TierSegmentUploadComplete version %d must contain a stateOffsetAndEpoch.", metadata.version()));
        }
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.SegmentUploadComplete;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public TierObjectMetadata.State state() {
        return TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.objectId().mostSignificantBits(), this.metadata.objectId().leastSignificantBits());
    }

    @Override
    public int expectedSizeLatestVersion() {
        return 64;
    }

    public String toString() {
        return "TierSegmentUploadComplete(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ")";
    }
}

