/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.serdes.PartitionForceRestore;
import kafka.tier.state.OffsetAndEpoch;

public class TierPartitionForceRestore
extends AbstractTierMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 136;
    private final TopicIdPartition topicIdPartition;
    private final PartitionForceRestore metadata;

    public TierPartitionForceRestore(TopicIdPartition topicIdPartition, UUID messageId, long startOffset, long endOffset, OffsetAndEpoch stateOffsetAndEpoch, String contentHash) {
        FlatBufferBuilder builder = new FlatBufferBuilder(136).forceDefaults(true);
        int contentHashId = builder.createString((CharSequence)contentHash);
        PartitionForceRestore.startPartitionForceRestore(builder);
        PartitionForceRestore.addVersion(builder, (byte)0);
        PartitionForceRestore.addStartOffset(builder, startOffset);
        PartitionForceRestore.addEndOffset(builder, endOffset);
        int messageIdOffset = kafka.tier.serdes.UUID.createUUID(builder, messageId.getMostSignificantBits(), messageId.getLeastSignificantBits());
        PartitionForceRestore.addMessageId(builder, messageIdOffset);
        int offsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffsetAndEpoch.offset(), stateOffsetAndEpoch.epoch().orElse(-1));
        PartitionForceRestore.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        PartitionForceRestore.addContentHash(builder, contentHashId);
        int entryId = PartitionForceRestore.endPartitionForceRestore(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = PartitionForceRestore.getRootAsPartitionForceRestore(builder.dataBuffer());
    }

    public TierPartitionForceRestore(TopicIdPartition topicIdPartition, PartitionForceRestore metadata) {
        if (metadata.stateOffsetAndEpoch() == null) {
            throw new IllegalArgumentException("TierPartitionForceRestore must contain a stateOffsetAndEpoch.");
        }
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public long startOffset() {
        return this.metadata.startOffset();
    }

    public long endOffset() {
        return this.metadata.endOffset();
    }

    public String contentHash() {
        return this.metadata.contentHash();
    }

    public byte version() {
        return this.metadata.version();
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.PartitionForceRestore;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public int tierEpoch() {
        return -1;
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return new OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    @Override
    public int expectedSizeLatestVersion() {
        return 136;
    }

    public String toString() {
        return "TierPartitionForceRestore(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ", startOffset=" + this.startOffset() + ", endOffset=" + this.endOffset() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ", contentHash=" + this.contentHash() + ")";
    }
}

