/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.serdes.PartitionFence;
import kafka.tier.state.OffsetAndEpoch;

public class TierPartitionFence
extends AbstractTierMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 60;
    private final TopicIdPartition topicIdPartition;
    private final PartitionFence metadata;

    public TierPartitionFence(TopicIdPartition topicIdPartition, UUID messageId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(60).forceDefaults(true);
        PartitionFence.startPartitionFence(builder);
        PartitionFence.addVersion(builder, (byte)0);
        int messageIdOffset = kafka.tier.serdes.UUID.createUUID(builder, messageId.getMostSignificantBits(), messageId.getLeastSignificantBits());
        PartitionFence.addMessageId(builder, messageIdOffset);
        int entryId = PartitionFence.endPartitionFence(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = PartitionFence.getRootAsPartitionFence(builder.dataBuffer());
    }

    public TierPartitionFence(TopicIdPartition topicIdPartition, PartitionFence metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.PartitionFence;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return OffsetAndEpoch.EMPTY;
    }

    @Override
    public int tierEpoch() {
        return -1;
    }

    private byte version() {
        return this.metadata.version();
    }

    @Override
    public int expectedSizeLatestVersion() {
        return 60;
    }

    public String toString() {
        return "TierPartitionFence(version=" + this.version() + ", topicIdPartition=" + this.topicIdPartition() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ")";
    }
}

