/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.serdes.TierPartitionStateEntry;
import kafka.utils.CoreUtils;

public class TierObjectMetadata {
    private final TopicIdPartition topicIdPartition;
    private final TierPartitionStateEntry metadata;
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int BASE_BUFFER_SIZE = 108;

    public TierObjectMetadata(TopicIdPartition topicIdPartition, TierPartitionStateEntry metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public TierObjectMetadata(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long baseOffset, long endOffset, long maxTimestamp, int size, State state, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState) {
        if (tierEpoch < 0) {
            throw new IllegalArgumentException(String.format("Illegal tierEpoch supplied %d.", tierEpoch));
        }
        FlatBufferBuilder builder = new FlatBufferBuilder(108).forceDefaults(true);
        TierPartitionStateEntry.startTierPartitionStateEntry(builder);
        TierPartitionStateEntry.addVersion(builder, (byte)0);
        TierPartitionStateEntry.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        TierPartitionStateEntry.addObjectId(builder, objectIdOffset);
        TierPartitionStateEntry.addBaseOffset(builder, baseOffset);
        TierPartitionStateEntry.addEndOffsetDelta(builder, (int)(endOffset - baseOffset));
        TierPartitionStateEntry.addMaxTimestamp(builder, maxTimestamp);
        TierPartitionStateEntry.addSize(builder, size);
        TierPartitionStateEntry.addState(builder, state.id());
        TierPartitionStateEntry.addHasEpochState(builder, hasEpochState);
        TierPartitionStateEntry.addHasAbortedTxns(builder, hasAbortedTxns);
        TierPartitionStateEntry.addHasProducerState(builder, hasProducerState);
        int entryId = TierPartitionStateEntry.endTierPartitionStateEntry(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = TierPartitionStateEntry.getRootAsTierPartitionStateEntry(builder.dataBuffer());
    }

    public TierObjectMetadata(TierSegmentUploadInitiate uploadInitiate) {
        this(uploadInitiate.topicIdPartition(), uploadInitiate.tierEpoch(), uploadInitiate.objectId(), uploadInitiate.baseOffset(), uploadInitiate.endOffset(), uploadInitiate.maxTimestamp(), uploadInitiate.size(), uploadInitiate.state(), uploadInitiate.hasEpochState(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState());
    }

    public TierObjectMetadata duplicate() {
        return new TierObjectMetadata(this.topicIdPartition, this.tierEpoch(), this.objectId(), this.baseOffset(), this.endOffset(), this.maxTimestamp(), this.size(), this.state(), this.hasEpochState(), this.hasAbortedTxns(), this.hasProducerState());
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    public int payloadSize() {
        return this.metadata.getByteBuffer().remaining();
    }

    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    public long baseOffset() {
        return this.metadata.baseOffset();
    }

    public UUID objectId() {
        return new UUID(this.metadata.objectId().mostSignificantBits(), this.metadata.objectId().leastSignificantBits());
    }

    public String objectIdAsBase64() {
        return CoreUtils.uuidToBase64(this.objectId());
    }

    public long endOffset() {
        return this.baseOffset() + (long)this.endOffsetDelta();
    }

    public long maxTimestamp() {
        return this.metadata.maxTimestamp();
    }

    public int size() {
        return this.metadata.size();
    }

    public boolean hasEpochState() {
        return this.metadata.hasEpochState();
    }

    public boolean hasAbortedTxns() {
        return this.metadata.hasAbortedTxns();
    }

    public State state() {
        return State.toState(this.metadata.state());
    }

    public void mutateState(State newState) {
        if (!this.state().canTransitionTo(newState)) {
            throw new IllegalStateException("Cannot transition from " + (Object)((Object)this.state()) + " to " + (Object)((Object)newState));
        }
        this.metadata.mutateState(newState.id);
    }

    public boolean hasProducerState() {
        return this.metadata.hasProducerState();
    }

    public short version() {
        return this.metadata.version();
    }

    private int endOffsetDelta() {
        return this.metadata.endOffsetDelta();
    }

    public String toString() {
        return "TierObjectMetadata(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", baseOffset=" + this.baseOffset() + ", endOffset=" + this.endOffset() + ", maxTimestamp=" + this.maxTimestamp() + ", size=" + this.size() + ", state=" + (Object)((Object)this.state()) + ", hasEpochState=" + this.hasEpochState() + ", hasAbortedTxns=" + this.hasAbortedTxns() + ", hasProducerState=" + this.hasProducerState() + ")";
    }

    public int hashCode() {
        return Objects.hash(this.topicIdPartition(), this.payloadBuffer());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierObjectMetadata that = (TierObjectMetadata)o;
        return Objects.equals(this.topicIdPartition(), that.topicIdPartition()) && Objects.equals(this.payloadBuffer(), that.payloadBuffer());
    }

    public static enum State {
        SEGMENT_UPLOAD_INITIATE(0, Arrays.asList((byte)1, (byte)2, (byte)4)),
        SEGMENT_UPLOAD_COMPLETE(1, Collections.singletonList((byte)2)),
        SEGMENT_DELETE_INITIATE(2, Arrays.asList((byte)3, (byte)4)),
        SEGMENT_DELETE_COMPLETE(3, Collections.emptyList()),
        SEGMENT_FENCED(4, Collections.singletonList((byte)2));

        private static final Map<Byte, State> VALUES;
        private final byte id;
        private final List<Byte> nextStates;

        private State(byte id, List<Byte> nextStates) {
            this.id = id;
            this.nextStates = nextStates;
        }

        public byte id() {
            return this.id;
        }

        public static State toState(byte id) {
            State state = VALUES.get(id);
            if (state == null) {
                throw new IllegalArgumentException("No mapping found for " + id);
            }
            return state;
        }

        public boolean canTransitionTo(State newState) {
            State.raiseIfIllegal(this, newState);
            return this.nextStates.contains(newState.id);
        }

        private static void raiseIfIllegal(State currentState, State newState) {
            if (newState == SEGMENT_DELETE_COMPLETE && currentState != SEGMENT_DELETE_INITIATE) {
                throw new IllegalStateException("Illegal transition from " + (Object)((Object)currentState) + " to " + (Object)((Object)newState));
            }
        }

        static {
            VALUES = new HashMap<Byte, State>();
            for (State state : State.values()) {
                State previousState = VALUES.put(state.id, state);
                if (previousState == null) continue;
                throw new ExceptionInInitializerError("Conflicting VALUES for " + (Object)((Object)previousState) + " and " + (Object)((Object)state));
            }
        }
    }
}

