/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.Objects;
import java.util.UUID;
import kafka.utils.CoreUtils;
import org.apache.kafka.common.TopicPartition;

public final class TopicIdPartition {
    private final UUID topicId;
    private final TopicPartition topicPartition;

    public TopicIdPartition(String topic, UUID topicId, int partition) {
        this.topicPartition = new TopicPartition(topic, partition);
        this.topicId = topicId;
    }

    public int partition() {
        return this.topicPartition.partition();
    }

    public String topic() {
        return this.topicPartition.topic();
    }

    public UUID topicId() {
        return this.topicId;
    }

    public String topicIdAsBase64() {
        return CoreUtils.uuidToBase64(this.topicId);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int hashCode() {
        return Objects.hash(this.topicPartition, this.topicId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicIdPartition other = (TopicIdPartition)obj;
        return Objects.equals(this.topicPartition(), other.topicPartition()) && Objects.equals(this.topicId(), other.topicId());
    }

    public String toString() {
        return this.topicIdAsBase64() + ":" + this.topic() + "-" + this.partition();
    }
}

