/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.IOException;
import java.io.Serializable;
import kafka.server.link.FilterType$;
import kafka.server.link.GroupFilter;
import kafka.server.link.GroupFilterJsonValidator;
import kafka.server.link.GroupFiltersJson;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxedUnit;

public final class GroupFilterJson$ {
    public static GroupFilterJson$ MODULE$;
    private final GroupFilterJsonValidator VALIDATOR;
    private final ObjectMapper JSON_SERDE;

    static {
        new GroupFilterJson$();
    }

    public GroupFilterJsonValidator VALIDATOR() {
        return this.VALIDATOR;
    }

    public ObjectMapper JSON_SERDE() {
        return this.JSON_SERDE;
    }

    public Option<GroupFiltersJson> parse(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Option$.MODULE$.empty();
        }
        try {
            ObjectMapper JSON_SERDE = new ObjectMapper();
            JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
            JSON_SERDE.registerModule((Module)DefaultScalaModule$.MODULE$);
            GroupFiltersJson groupFilterJson = (GroupFiltersJson)JSON_SERDE.readValue(value, GroupFiltersJson.class);
            if (groupFilterJson.groupFilters() == null) {
                throw new IllegalArgumentException("groupFilters cannot be the JSON null");
            }
            groupFilterJson.groupFilters().foreach((Function1 & Serializable & scala.Serializable)groupFilter -> {
                GroupFilterJson$.$anonfun$parse$1(groupFilter);
                return BoxedUnit.UNIT;
            });
            return new Some((Object)groupFilterJson);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IOException ? true : (throwable instanceof JsonMappingException ? true : throwable instanceof JsonParseException);
            if (bl) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Exception while parsing Group Filter JSON: ").append(throwable).toString());
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$parse$1(GroupFilter groupFilter) {
        block11: {
            String patternType;
            block10: {
                PatternType patternType2;
                PatternType patternType3;
                block9: {
                    String filterType = groupFilter.filterType();
                    if (filterType == null) {
                        throw new IllegalArgumentException("filterType field may not be null.");
                    }
                    if (FilterType$.MODULE$.fromString(filterType).isEmpty()) {
                        throw new IllegalArgumentException(new StringBuilder(20).append("Unknown filterType: ").append(filterType).toString());
                    }
                    patternType = groupFilter.patternType();
                    if (patternType == null) {
                        throw new IllegalArgumentException("patternType field may not be null.");
                    }
                    if (patternType.isEmpty()) {
                        throw new IllegalArgumentException("patternType field may not be empty.");
                    }
                    patternType3 = SecurityUtils.patternType((String)patternType);
                    patternType2 = PatternType.UNKNOWN;
                    if (patternType3 != null) break block9;
                    if (patternType2 != null) {
                        return;
                    }
                    break block10;
                }
                if (!patternType3.equals(patternType2)) break block11;
            }
            throw new IllegalArgumentException(new StringBuilder(21).append("Unknown patternType: ").append(patternType).toString());
        }
    }

    private GroupFilterJson$() {
        MODULE$ = this;
        this.VALIDATOR = new GroupFilterJsonValidator();
        this.JSON_SERDE = new ObjectMapper();
        this.JSON_SERDE().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        this.JSON_SERDE().registerModule((Module)DefaultScalaModule$.MODULE$);
    }
}

