/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kafka.controller.KafkaController;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkGroupFilter;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u000b\u0017\u0001uA\u0001B\n\u0001\u0003\u0006\u0004%\ta\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Q!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0011!I\u0004A!b\u0001\n\u0003Q\u0004\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011=\u0003!\u0011!Q\u0001\nACQa\u0015\u0001\u0005\u0002QC\u0001b\u0017\u0001C\u0002\u0013\u0005a\u0003\u0018\u0005\u0007y\u0002\u0001\u000b\u0011B/\t\u000fu\u0004\u0001\u0019!C\u0005}\"I\u0011Q\u0001\u0001A\u0002\u0013%\u0011q\u0001\u0005\b\u0003'\u0001\u0001\u0015)\u0003\u0000\u0011\u001d\t)\u0002\u0001C)\u0003/Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002.\u0001!I!a\f\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!9\u00111\u000e\u0001\u0005\n\u00055\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003\u0007\u0003A\u0011BAC\u0005Y\u0019E.^:uKJd\u0015N\\6Ts:\u001cwJ\u001a4tKR\u001c(BA\f\u0019\u0003\u0011a\u0017N\\6\u000b\u0005eQ\u0012AB:feZ,'OC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0019cB\u0001\u0011\"\u001b\u00051\u0012B\u0001\u0012\u0017\u0003Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&\u0011A%\n\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0003EY\tQb\u00197jK:$X*\u00198bO\u0016\u0014X#\u0001\u0015\u0011\u0005\u0001J\u0013B\u0001\u0016\u0017\u0005a\u0019E.^:uKJd\u0015N\\6DY&,g\u000e^'b]\u0006<WM]\u0001\u000fG2LWM\u001c;NC:\fw-\u001a:!\u0003!a\u0017N\\6ECR\f\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u001b\u0003\tQ8.\u0003\u00023_\ty1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-\u0001\u0006d_:$(o\u001c7mKJ\u0004\"!N\u001c\u000e\u0003YR!a\r\u000e\n\u0005a2$aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002!\u0011,7\u000f^!e[&tg)Y2u_JLX#A\u001e\u0011\u0007qz\u0014)D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002C\u00196\t1I\u0003\u0002E\u000b\u0006)\u0011\rZ7j]*\u0011aiR\u0001\bG2LWM\u001c;t\u0015\tY\u0002J\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<\u0017BA'D\u0005\u0015\tE-\\5o\u0003E!Wm\u001d;BI6LgNR1di>\u0014\u0018\u0010I\u0001\b[\u0016$(/[2t!\t\u0001\u0013+\u0003\u0002S-\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003\u0019a\u0014N\\5u}Q1QKV,Y3j\u0003\"\u0001\t\u0001\t\u000b\u0019B\u0001\u0019\u0001\u0015\t\u000b1B\u0001\u0019A\u0017\t\u000bMB\u0001\u0019\u0001\u001b\t\u000beB\u0001\u0019A\u001e\t\u000b=C\u0001\u0019\u0001)\u0002\u001d\r,(O]3oi>3gm]3ugV\tQ\f\u0005\u0003_G\u0016LX\"A0\u000b\u0005\u0001\f\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003Ev\n!bY8mY\u0016\u001cG/[8o\u0013\t!wLA\u0002NCB\u0004B\u0001\u00104ig&\u0011q-\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005%\u0004hB\u00016o!\tYW(D\u0001m\u0015\tiG$\u0001\u0004=e>|GOP\u0005\u0003_v\na\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011q.\u0010\t\u0003i^l\u0011!\u001e\u0006\u0003m\u001e\u000baaY8n[>t\u0017B\u0001=v\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"\u0001\u0010>\n\u0005ml$\u0001\u0002'p]\u001e\fqbY;se\u0016tGo\u00144gg\u0016$8\u000fI\u0001\u0007G>tg-[4\u0016\u0003}\u00042\u0001IA\u0001\u0013\r\t\u0019A\u0006\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017AC2p]\u001aLwm\u0018\u0013fcR!\u0011\u0011BA\b!\ra\u00141B\u0005\u0004\u0003\u001bi$\u0001B+oSRD\u0001\"!\u0005\r\u0003\u0003\u0005\ra`\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\u0004eVtGCAA\r!\ra\u00141D\u0005\u0004\u0003;i$a\u0002\"p_2,\u0017M\\\u0001\u0015M&dG/\u001a:D_:\u001cX/\\3s\u000fJ|W\u000f]:\u0015\t\u0005\r\u0012\u0011\u0006\t\u0005S\u0006\u0015\u0002.C\u0002\u0002(I\u00141aU3u\u0011\u001d\tYc\u0004a\u0001\u0003G\taa\u001a:pkB\u001c\u0018!D;qI\u0006$Xm\u00144gg\u0016$8\u000f\u0006\u0003\u0002\n\u0005E\u0002bBA\u0016!\u0001\u0007\u00111E\u0001\u0017Q\u0006tG\r\\3D_6l\u0017\u000e\u001e;fI>3gm]3ugR1\u0011\u0011BA\u001c\u0003\u000bBq!!\u000f\u0012\u0001\u0004\tY$A\u0007d_6l\u0017\u000e\u001e*fgVdGo\u001d\t\u0007S\u0006u\u0002.a\u0010\n\u0005\u0011\u0014\bc\u0001\"\u0002B%\u0019\u00111I\"\u0003?\u0005cG/\u001a:D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u001d*fgVdG\u000fC\u0004\u0002HE\u0001\r!!\u0013\u0002\u00171L7\u000f\u001e$viV\u0014Xm\u001d\t\u0007S\u0006u\u0002.a\u0013\u0011\u000bQ\fi%!\u0015\n\u0007\u0005=SOA\u0006LC\u001a\\\u0017MR;ukJ,\u0007cBA*\u0003;\u001a\u0018qL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005!Q\u000f^5m\u0015\t\tY&\u0001\u0003kCZ\f\u0017b\u00013\u0002VA!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f\u0015\u000b\u0001bY8ogVlWM]\u0005\u0005\u0003S\n\u0019GA\tPM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006\f1\"Y:z]\u000e\u001cu.\\7jiR!\u00111HA8\u0011\u001d\t\tH\u0005a\u0001\u0003\u0013\nAb\u001a:pkB4U\u000f^;sKN\f\u0001\u0003\\5ti\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\t\u0005]\u0014\u0011\u0011\t\b\u0003s\ny\b[A&\u001b\t\tYHC\u0002\u0002~\u0005\f\u0011\"[7nkR\f'\r\\3\n\u0007\u0011\fY\bC\u0004\u0002,M\u0001\r!a\t\u0002\u0015MDw.\u001e7e'ft7\r\u0006\u0003\u0002\u001a\u0005\u001d\u0005BBAE)\u0001\u0007\u0001.A\u0003u_BL7\r")
public class ClusterLinkSyncOffsets
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkClientManager clientManager;
    private final ClusterLinkData linkData;
    private final KafkaController controller;
    private final Function0<Admin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private final scala.collection.mutable.Map<Tuple2<String, TopicPartition>, Object> currentOffsets;
    private ClusterLinkConfig config;

    public ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    public Function0<Admin> destAdminFactory() {
        return this.destAdminFactory;
    }

    public scala.collection.mutable.Map<Tuple2<String, TopicPartition>, Object> currentOffsets() {
        return this.currentOffsets;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    @Override
    public boolean run() {
        this.config_$eq(this.clientManager().currentConfig());
        if (this.controller.isActive() && Predef$.MODULE$.Boolean2boolean(this.config().consumerOffsetSyncEnable())) {
            if (this.config().consumerGroupFilters().isEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).append(" is true but no consumer group filters are specified. No consumer offsets will be migrated.").toString());
                return true;
            }
            try {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to retrieve consumer groups from source cluster");
                ListConsumerGroupsResult listConsumerGroupsResult = this.clientManager().getAdmin().listConsumerGroups();
                this.scheduleWhenComplete(listConsumerGroupsResult.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    Set<String> filteredGroups = this.filterConsumerGroups((Set<String>)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)listConsumerGroupsResult.all().get()).asScala()).map((Function1 & Serializable & scala.Serializable)result -> result.groupId(), Iterable$.MODULE$.canBuildFrom())).toSet());
                    this.updateOffsets(filteredGroups);
                    return false;
                });
                return false;
            }
            catch (Throwable ex) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to list consumer groups on source cluster. Offsets will not be migrated.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                return true;
            }
        }
        return true;
    }

    private Set<String> filterConsumerGroups(Set<String> groups) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Filtering consumer groups to match consumer group JSON");
        Seq<ClusterLinkGroupFilter> groupFilters = ClusterLinkUtils$.MODULE$.groupFilters(this.config(), this.linkData.tenantPrefix());
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set filtered = (Set)groups.filter((Function1 & Serializable & scala.Serializable)group -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$filterConsumerGroups$2(groupFilters, usedFilters, group)));
        ((IterableLike)groupFilters.diff((GenSeq)usedFilters)).foreach((Function1 & Serializable & scala.Serializable)unusedFilter -> {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(199).append("The filter ").append(unusedFilter).append(" does not match any consumer group. This filter may not be ").append("required or the groups it referred to may not have the correct DESCRIBE ACL ").append("for the cluster link principal on the source cluster.").toString());
            return BoxedUnit.UNIT;
        });
        return filtered;
    }

    private void updateOffsets(Set<String> groups) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Updating offsets for the following consumer groups on target cluster: ").append(groups.toString()).toString());
        scala.collection.immutable.Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> groupFutures = this.listGroupOffsets(groups);
        KafkaFuture allGroupFutures = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])groupFutures.values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(allGroupFutures, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult> commitResults = this.asyncCommit(groupFutures);
            this.handleCommittedOffsets(commitResults, groupFutures);
            return false;
        });
    }

    private void handleCommittedOffsets(scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult> commitResults, scala.collection.immutable.Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> listFutures) {
        KafkaFuture allCommitFutures = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((TraversableOnce)commitResults.values().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.all(), Iterable$.MODULE$.canBuildFrom())).toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(allCommitFutures, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.currentOffsets().clear();
            commitResults.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ClusterLinkSyncOffsets.$anonfun$handleCommittedOffsets$3(this, listFutures, x0$1);
                return BoxedUnit.UNIT;
            });
            return true;
        });
    }

    private scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult> asyncCommit(scala.collection.immutable.Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> groupFutures) {
        return (scala.collection.immutable.Map)groupFutures.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            if (x0$1 != null) {
                String group = (String)x0$1._1();
                KafkaFuture groupFuture = (KafkaFuture)x0$1._2();
                scala.collection.mutable.Map offsets = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((Map)groupFuture.get()).asScala()).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$asyncCommit$2(this, group, t)));
                if (offsets.nonEmpty()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Committing offsets on target cluster for consumer group ").append(group).toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)((Admin)this.destAdminFactory().apply()).alterConsumerGroupOffsets(group, (Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(offsets).asJava()))));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            } else {
                throw new MatchError(null);
            }
            Iterable iterable2 = iterable;
            return iterable2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> listGroupOffsets(Set<String> groups) {
        return ((TraversableOnce)groups.flatMap((Function1 & Serializable & scala.Serializable)group -> {
            try {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Listing consumer group offsets on source cluster for consumer group ").append((String)group).toString());
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), (Object)this.clientManager().getAdmin().listConsumerGroupOffsets(group).partitionsToOffsetAndMetadata())));
            }
            catch (GroupAuthorizationException ex) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(142).append("Unable to list offsets for consumer group ").append((String)group).append(" on the source cluster, due to authorization issues.").append(" Please add DESCRIBE ACLs for the consumer group").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            catch (TopicAuthorizationException ex) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(149).append("Unable to list offsets for consumer group ").append((String)group).append(" on the source cluster, due to authorization issues.").append(" Please add DESCRIBE ACLs for the topics being migrated").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            catch (Throwable ex) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to list consumer groups on source cluster. Offsets will not be migrated.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private boolean shouldSync(String topic) {
        return this.controller.controllerContext().linkedTopics().get((Object)topic).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$shouldSync$1(x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$filterConsumerGroups$2(Seq groupFilters$1, Buffer usedFilters$1, String group) {
        Seq matchedFilters = (Seq)groupFilters$1.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matches(group)));
        if (matchedFilters.isEmpty()) {
            return false;
        }
        usedFilters$1.$plus$plus$eq((TraversableOnce)matchedFilters);
        return matchedFilters.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isInclude()));
    }

    public static final /* synthetic */ void $anonfun$handleCommittedOffsets$3(ClusterLinkSyncOffsets $this, scala.collection.immutable.Map listFutures$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String group = (String)x0$1._1();
            try {
                ((AlterConsumerGroupOffsetsResult)x0$1._2()).all().get();
                ((Map)((KafkaFuture)listFutures$1.apply((Object)group)).get()).forEach((tp, offsetAndMetadata) -> {
                    if ($this.shouldSync(tp.topic())) {
                        $this.currentOffsets().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)group, tp)), (Object)BoxesRunTime.boxToLong((long)offsetAndMetadata.offset())));
                        $this.metrics.consumerOffsetCommitSensor().record();
                        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Committed offsets on target cluster for consumer group ").append(group).toString());
                    }
                });
                return;
            }
            catch (GroupAuthorizationException ex) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(277).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster, due to authorization issues.").append(" Please add READ ACLs for the consumer group. This action is taken by the inter-broker principal defined in the broker ").append("configuration so ACLs should be added for this principal ").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                return;
            }
            catch (TopicAuthorizationException ex) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(284).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster, due to authorization issues.").append(" Please add READ ACLs for the topics being migrated. This action is taken by the inter-broker principal defined in the broker ").append("configuration so ACLs should be added for this principal ").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                return;
            }
            catch (Throwable ex) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Unable to commit offsets for consumer group ").append(group).append(" on destination cluster.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                $this.metrics.consumerOffsetCommitFailedSensor().record();
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$asyncCommit$2(ClusterLinkSyncOffsets $this, String group$3, Tuple2 t) {
        return $this.shouldSync(((TopicPartition)t._1()).topic()) && !BoxesRunTime.equals((Object)$this.currentOffsets().getOrElse((Object)new Tuple2((Object)group$3, t._1()), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1), (Object)BoxesRunTime.boxToLong((long)((OffsetAndMetadata)t._2()).offset()));
    }

    public static final /* synthetic */ boolean $anonfun$shouldSync$1(ClusterLinkTopicState x$4) {
        return x$4.state().shouldSync();
    }

    public ClusterLinkSyncOffsets(ClusterLinkClientManager clientManager, ClusterLinkData linkData, KafkaController controller, Function0<Admin> destAdminFactory, ClusterLinkMetrics metrics) {
        this.clientManager = clientManager;
        this.linkData = linkData;
        this.controller = controller;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkSyncOffsets", Predef$.MODULE$.Integer2int(clientManager.currentConfig().consumerOffsetSyncMs()));
        this.currentOffsets = Map$.MODULE$.empty();
        this.config = clientManager.currentConfig();
    }
}

