/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.server.ConfigType$;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkGroupFilter;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkStopTopicMirror$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$StoppedMirror$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.zk.TopicZNode;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.replica.ReplicaStatus;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001\u0002\u001e<\u0001\tC\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t3\u0002\u0011\t\u0011)A\u00055\"AQ\f\u0001B\u0001B\u0003%a\fC\u0005p\u0001\t\u0005\t\u0015!\u0003qg\"AQ\u000f\u0001B\u0001B\u0003%\u0001\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0004\u007f\u0001\u0001\u0007I\u0011B@\t\u0013\u0005\u001d\u0001\u00011A\u0005\n\u0005%\u0001\u0002CA\u000b\u0001\u0001\u0006K!!\u0001\t\u0011\u0005]\u0001\u00011A\u0005\n}D\u0011\"!\u0007\u0001\u0001\u0004%I!a\u0007\t\u0011\u0005}\u0001\u0001)Q\u0005\u0003\u0003A\u0001\"!\t\u0001\u0001\u0004%Ia \u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003KA\u0001\"!\u000b\u0001A\u0003&\u0011\u0011\u0001\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0003C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0003bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_A1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u0011\u0011\f\u0001A\u0002\u0003\u0007I\u0011BA.\u0011-\ty\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0014\t\u0017\u0005\u0005\u0004\u00011AA\u0002\u0013%\u00111\r\u0005\f\u0003{\u0002\u0001\u0019!a\u0001\n\u0013\ty\bC\u0006\u0002\u0004\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0004bBAC\u0001\u0011E\u0013q\u0011\u0005\b\u0003\u0013\u0003A\u0011AAD\u0011\u001d\tY\t\u0001C\u0005\u0003\u000fCq!!$\u0001\t\u0013\ty\tC\u0004\u0002:\u0002!I!a/\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002\b\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003?\u0004A\u0011BAD\u0011\u001d\t\t\u000f\u0001C\u0005\u0003GDq!!>\u0001\t\u0013\t9\u0010C\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!\u0011\u0005\u0001\u0005\n\t\r\u0002b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0011\u001d\u0011\t\u0006\u0001C\u0005\u0003\u000fCqAa\u0015\u0001\t\u0013\u0011)\u0006C\u0004\u0003^\u0001!IAa\u0018\t\u000f\t}\u0004\u0001\"\u0003\u0003\u0002\"9!1\u0013\u0001\u0005\n\tU\u0005b\u0002BR\u0001\u0011%!Q\u0015\u0005\b\u0005k\u0003A\u0011BAD\u0011\u001d\u00119\f\u0001C\u0005\u0005s;qAa0<\u0011\u0003\u0011\tM\u0002\u0004;w!\u0005!1\u0019\u0005\u0007mJ\"\tAa3\u0007\r\t5'\u0007\u0001Bh\u0011%\u00119\u000e\u000eB\u0001B\u0003%A\n\u0003\u0006\u0003ZR\u0012\t\u0011)A\u0005\u00057DaA\u001e\u001b\u0005\u0002\t\u0005\b\"\u0003BveE\u0005I\u0011\u0001Bw\u0011%\u0019\u0019AMI\u0001\n\u0003\u0011iO\u0001\u000eDYV\u001cH/\u001a:MS:\\7\u000b^8q)>\u0004\u0018nY'jeJ|'O\u0003\u0002={\u0005!A.\u001b8l\u0015\tqt(\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0001\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001D!\t!\u0005J\u0004\u0002F\r6\t1(\u0003\u0002Hw\u0005!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJL!!\u0013&\u0003\u0019A+'/[8eS\u000e$\u0016m]6\u000b\u0005\u001d[\u0014!\u0002;pa&\u001c\u0007CA'W\u001d\tqE\u000b\u0005\u0002P%6\t\u0001K\u0003\u0002R\u0003\u00061AH]8pizR\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u000ba\u0001\u0015:fI\u00164\u0017BA,Y\u0005\u0019\u0019FO]5oO*\u0011QKU\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0011\u0005\u0015[\u0016B\u0001/<\u0005a\u0019E.^:uKJd\u0015N\\6DY&,g\u000e^'b]\u0006<WM]\u0001\u000bY>\u001c\u0017\r\\!e[&t\u0007cA0aE6\t!+\u0003\u0002b%\nIa)\u001e8di&|g\u000e\r\t\u0003G6l\u0011\u0001\u001a\u0006\u0003K\u001a\fQ!\u00193nS:T!a\u001a5\u0002\u000f\rd\u0017.\u001a8ug*\u0011\u0001)\u001b\u0006\u0003U.\fa!\u00199bG\",'\"\u00017\u0002\u0007=\u0014x-\u0003\u0002oI\nq1i\u001c8gYV,g\u000e^!e[&t\u0017AC5oi\u0016\u0014h/\u00197NgB\u0011q,]\u0005\u0003eJ\u00131!\u00138u\u0013\t!\b*A\tsKN\u001c\u0007.\u001a3vY\u0016$U\r\\1z\u001bN\fa\"\u00193nS:$\u0016.\\3pkRl5/\u0001\u0004=S:LGO\u0010\u000b\u0007qfT8\u0010`?\u0011\u0005\u0015\u0003\u0001\"B&\u0007\u0001\u0004a\u0005\"B-\u0007\u0001\u0004Q\u0006\"B/\u0007\u0001\u0004q\u0006bB8\u0007!\u0003\u0005\r\u0001\u001d\u0005\bk\u001a\u0001\n\u00111\u0001q\u0003-\u0019\u0018P\\2ie>t\u0017N_3\u0016\u0005\u0005\u0005\u0001cA0\u0002\u0004%\u0019\u0011Q\u0001*\u0003\u000f\t{w\u000e\\3b]\u0006y1/\u001f8dQJ|g.\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005E\u0001cA0\u0002\u000e%\u0019\u0011q\u0002*\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003'A\u0011\u0011!a\u0001\u0003\u0003\t1\u0001\u001f\u00132\u00031\u0019\u0018P\\2ie>t\u0017N_3!\u0003I)\b\u000fZ1uK\u0012$v\u000e]5d\u0007>tg-[4\u0002-U\u0004H-\u0019;fIR{\u0007/[2D_:4\u0017nZ0%KF$B!a\u0003\u0002\u001e!I\u00111C\u0006\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0014kB$\u0017\r^3e)>\u0004\u0018nY\"p]\u001aLw\rI\u0001\u0014kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go]\u0001\u0018kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go]0%KF$B!a\u0003\u0002(!I\u00111\u0003\b\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0015kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go\u001d\u0011\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u00020A)Q*!\r\u00026%\u0019\u00111\u0007-\u0003\u0007M+G\u000f\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY\u0004[\u0001\u0007G>lWn\u001c8\n\t\u0005}\u0012\u0011\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u00039\u0001\u0018M\u001d;ji&|gn]0%KF$B!a\u0003\u0002F!I\u00111C\t\u0002\u0002\u0003\u0007\u0011qF\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\fqCJ$\u0018\u000e^5p]2{w-\u00128e\u001f\u001a47/\u001a;t+\t\ti\u0005E\u0004N\u0003\u001f\n)$a\u0015\n\u0007\u0005E\u0003LA\u0002NCB\u00042aXA+\u0013\r\t9F\u0015\u0002\u0005\u0019>tw-\u0001\u000eqCJ$\u0018\u000e^5p]2{w-\u00128e\u001f\u001a47/\u001a;t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005u\u0003\"CA\n)\u0005\u0005\t\u0019AA'\u0003]\u0001\u0018M\u001d;ji&|g\u000eT8h\u000b:$wJ\u001a4tKR\u001c\b%\u0001\u0007he>,\bOR5mi\u0016\u00148/\u0006\u0002\u0002fA1\u0011qMA9\u0003orA!!\u001b\u0002n9\u0019q*a\u001b\n\u0003MK1!a\u001cS\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001d\u0002v\t\u00191+Z9\u000b\u0007\u0005=$\u000bE\u0002F\u0003sJ1!a\u001f<\u0005Y\u0019E.^:uKJd\u0015N\\6He>,\bOR5mi\u0016\u0014\u0018\u0001E4s_V\u0004h)\u001b7uKJ\u001cx\fJ3r)\u0011\tY!!!\t\u0013\u0005Mq#!AA\u0002\u0005\u0015\u0014!D4s_V\u0004h)\u001b7uKJ\u001c\b%A\u0002sk:$\"!!\u0001\u0002\u0015Q\u0014\u0018M\\:ji&|g.\u0001\u0007qe>\u001cWm]:U_BL7-A\niC:$G.\u001a*fa2L7-Y*uCR,8\u000f\u0006\u0003\u0002\u0002\u0005E\u0005bBAJ9\u0001\u0007\u0011QS\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u000f5\u000by%!\u000e\u0002\u0018B1\u0011qGAM\u0003;KA!a'\u0002:\tY1*\u00194lC\u001a+H/\u001e:f!\u0019\ty*!+\u0002.6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+\u0001\u0003vi&d'BAAT\u0003\u0011Q\u0017M^1\n\t\u0005-\u0016\u0011\u0015\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u00020\u0006UVBAAY\u0015\u0011\t\u0019,!\u000f\u0002\u000fI,\u0007\u000f\\5dC&!\u0011qWAY\u00055\u0011V\r\u001d7jG\u0006\u001cF/\u0019;vg\u0006!\u0002O]8dKN\u001c(+\u001a9mS\u000e\f7\u000b^1ukN$B!!\u0001\u0002>\"9\u00111S\u000fA\u0002\u0005}\u0006cB'\u0002P\u0005U\u0012\u0011\u0019\t\u0007\u0003O\n\u0019-!,\n\t\u0005-\u0016QO\u0001\u0010gft7\rV8qS\u000e\u001cuN\u001c4jO\u0006)\u0002.\u00198eY\u0016\u001c\u0016P\\2U_BL7mQ8oM&<G\u0003BA\u0001\u0003\u0017Dq!!4 \u0001\u0004\ty-\u0001\u0004gkR,(/\u001a\t\u0007\u0003o\tI*!5\u0011\u0007\r\f\u0019.C\u0002\u0002V\u0012\u0014aaQ8oM&<\u0017A\u00069s_\u000e,7o]*z]\u000e$v\u000e]5d\u0007>tg-[4\u0015\t\u0005\u0005\u00111\u001c\u0005\b\u0003;\u0004\u0003\u0019AAi\u0003-!x\u000e]5d\u0007>tg-[4\u0002\u00151L7\u000f^$s_V\u00048/\u0001\tiC:$G.\u001a'jgR<%o\\;qgR!\u0011\u0011AAs\u0011\u001d\tiM\ta\u0001\u0003O\u0004b!a\u000e\u0002\u001a\u0006%\bCBAP\u0003W\fy/\u0003\u0003\u0002n\u0006\u0005&AC\"pY2,7\r^5p]B\u00191-!=\n\u0007\u0005MHM\u0001\u000bD_:\u001cX/\\3s\u000fJ|W\u000f\u001d'jgRLgnZ\u0001\u0012aJ|7-Z:t\u0019&\u001cHo\u0012:pkB\u001cH\u0003BA\u0001\u0003sDq!a?$\u0001\u0004\ti0\u0001\u0004he>,\bo\u001d\t\u0006\u0003O\n\t\bT\u0001\u0011Y&\u001cHo\u0012:pkB|eMZ:fiN$B!!\u0001\u0003\u0004!9\u00111 \u0013A\u0002\u0005u\u0018A\u00065b]\u0012dW\rT5ti\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\t\u0005\u0005!\u0011\u0002\u0005\b\u0005\u0017)\u0003\u0019\u0001B\u0007\u0003\u001d1W\u000f^;sKN\u0004b!TA(\u0019\n=\u0001CBA\u001c\u00033\u0013\t\u0002\u0005\u0005\u0002 \nM\u0011Q\u0007B\u000b\u0013\u0011\t\t&!)\u0011\t\t]!QD\u0007\u0003\u00053Q1Aa\u0007g\u0003!\u0019wN\\:v[\u0016\u0014\u0018\u0002\u0002B\u0010\u00053\u0011\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0003Y1\u0017\u000e\u001c;fe2K7\u000f^$s_V\u0004xJ\u001a4tKR\u001cHC\u0002B\u0013\u0005O\u0011Y\u0003E\u0004N\u0003\u001f\n)D!\u0006\t\r\t%b\u00051\u0001M\u0003\u00159'o\\;q\u0011\u001d\u0011iC\na\u0001\u0005K\tqa\u001c4gg\u0016$8/A\tbYR,'o\u0012:pkB|eMZ:fiN$B!!\u0001\u00034!9!QG\u0014A\u0002\t]\u0012\u0001D4s_V\u0004xJ\u001a4tKR\u001c\bCB'\u0002P1\u0013)#A\fiC:$G.Z!mi\u0016\u0014xI]8va>3gm]3ugR!\u0011\u0011\u0001B\u001f\u0011\u001d\u0011y\u0004\u000ba\u0001\u0005\u0003\nqA]3tk2$8\u000f\u0005\u0004N\u0003\u001fb%1\t\t\u0007\u0003o\tIJ!\u0012\u0011\t\t\u001d#QJ\u0007\u0003\u0005\u0013RAAa\u0013\u0002&\u0006!A.\u00198h\u0013\u0011\u0011yE!\u0013\u0003\tY{\u0017\u000eZ\u0001\u0010gR|\u0007\u000fV8qS\u000el\u0015N\u001d:pe\u0006\trM]8va>3gm]3ug\u0006#W.\u001b8\u0016\u0005\t]\u0003cA2\u0003Z%\u0019!1\f3\u0003\u000b\u0005#W.\u001b8\u0002\r%tgo\\6f+\u0011\u0011\tGa\u001a\u0015\t\t\r$\u0011\u0010\t\u0005\u0005K\u00129\u0007\u0004\u0001\u0005\u000f\t%4F1\u0001\u0003l\t\tA+\u0005\u0003\u0003n\tM\u0004cA0\u0003p%\u0019!\u0011\u000f*\u0003\u000f9{G\u000f[5oOB\u0019qL!\u001e\n\u0007\t]$KA\u0002B]fDqAa\u001f,\u0001\u0004\u0011i(\u0001\u0002dEB!q\f\u0019B2\u0003MIgN^8lKJ+\u0007\u000f\\5dCN#\u0018\r^;t+\u0011\u0011\u0019I!$\u0015\t\t\u0015%q\u0012\t\u0006?\n\u001d%1R\u0005\u0004\u0005\u0013\u0013&AB(qi&|g\u000e\u0005\u0003\u0003f\t5Ea\u0002B5Y\t\u0007!1\u000e\u0005\b\u0005wb\u0003\u0019\u0001BI!\u0011y\u0006Ma#\u0002+%tgo\\6f'ft7\rV8qS\u000e\u001cuN\u001c4jOV!!q\u0013BO)\u0011\u0011IJa(\u0011\u000b}\u00139Ia'\u0011\t\t\u0015$Q\u0014\u0003\b\u0005Sj#\u0019\u0001B6\u0011\u001d\u0011Y(\fa\u0001\u0005C\u0003Ba\u00181\u0003\u001c\u00061\u0012N\u001c<pW\u0016\u001c\u0016P\\2He>,\bo\u00144gg\u0016$8/\u0006\u0003\u0003(\n5FC\u0002BU\u0005_\u0013\t\fE\u0003`\u0005\u000f\u0013Y\u000b\u0005\u0003\u0003f\t5Fa\u0002B5]\t\u0007!1\u000e\u0005\u0007\u0005Sq\u0003\u0019\u0001'\t\u000f\tmd\u00061\u0001\u00034B!q\f\u0019BV\u00031ygnQ8na2,G/[8o\u0003%)\u0007pY3qi&|g\u000e\u0006\u0004\u0003<\u000e\u00151q\u0001\t\u0004\u0005{#dBA#2\u0003i\u0019E.^:uKJd\u0015N\\6Ti>\u0004Hk\u001c9jG6K'O]8s!\t)%gE\u00023\u0005\u000b\u00042a\u0018Bd\u0013\r\u0011IM\u0015\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0005'!C#yG\u0016\u0004H/[8o'\r!$\u0011\u001b\t\u0005\u0003o\u0011\u0019.\u0003\u0003\u0003V\u0006e\"AD&bM.\fW\t_2faRLwN\\\u0001\b[\u0016\u001c8/Y4f\u0003\u0005)\u0007\u0003BA4\u0005;LAAa8\u0002v\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u000b\u0007\u0005G\u00149O!;\u0011\u0007\t\u0015H'D\u00013\u0011\u0019\u00119n\u000ea\u0001\u0019\"9!\u0011\\\u001cA\u0002\tm\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0003p*\u001a\u0001O!=,\u0005\tM\b\u0003\u0002B{\u0005\u007fl!Aa>\u000b\t\te(1`\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!@S\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0003\u00119PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0004B\u0002Bla\u0001\u0007A\nC\u0004\u0004\nA\u0002\rAa7\u0002\u0005\u0015D\b")
public class ClusterLinkStopTopicMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkClientManager clientManager;
    private final Function0<ConfluentAdmin> localAdmin;
    private final int adminTimeoutMs;
    private boolean synchronize;
    private boolean updatedTopicConfig;
    private boolean updatedGroupOffsets;
    private scala.collection.immutable.Set<TopicPartition> partitions;
    private scala.collection.immutable.Map<TopicPartition, Object> partitionLogEndOffsets;
    private Seq<ClusterLinkGroupFilter> groupFilters;

    public static int $lessinit$greater$default$5() {
        return ClusterLinkStopTopicMirror$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return ClusterLinkStopTopicMirror$.MODULE$.$lessinit$greater$default$4();
    }

    private boolean synchronize() {
        return this.synchronize;
    }

    private void synchronize_$eq(boolean x$1) {
        this.synchronize = x$1;
    }

    private boolean updatedTopicConfig() {
        return this.updatedTopicConfig;
    }

    private void updatedTopicConfig_$eq(boolean x$1) {
        this.updatedTopicConfig = x$1;
    }

    private boolean updatedGroupOffsets() {
        return this.updatedGroupOffsets;
    }

    private void updatedGroupOffsets_$eq(boolean x$1) {
        this.updatedGroupOffsets = x$1;
    }

    private scala.collection.immutable.Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> partitionLogEndOffsets() {
        return this.partitionLogEndOffsets;
    }

    private void partitionLogEndOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.partitionLogEndOffsets = x$1;
    }

    private Seq<ClusterLinkGroupFilter> groupFilters() {
        return this.groupFilters;
    }

    private void groupFilters_$eq(Seq<ClusterLinkGroupFilter> x$1) {
        this.groupFilters = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean run() {
        TopicZNode.TopicIdReplicaAssignment topicData = (TopicZNode.TopicIdReplicaAssignment)this.clientManager.zkClient().getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).head();
        if (topicData.assignment().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Cannot stop topic mirror for deleted topic '").append($this.topic).append("'").toString());
            return this.onCompletion();
        }
        boolean bl = false;
        Some some = null;
        Option<ClusterLinkTopicState> option = topicData.clusterLink();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState clusterLinkTopicState = (ClusterLinkTopicState)some.value();
            if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                boolean sync = ((ClusterLinkTopicState.PendingStoppedMirror)clusterLinkTopicState).synchronize();
                this.partitions_$eq((scala.collection.immutable.Set<TopicPartition>)topicData.assignment().keys().toSet());
                this.synchronize_$eq(sync);
                return this.processTopic();
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("See cluster link state '").append(state).append("' for topic '").append($this.topic).append("', not performing stop topic mirror task").toString());
            return this.onCompletion();
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("No cluster link state for topic '").append($this.topic).append("', not performing stop topic mirror task").toString());
        return this.onCompletion();
    }

    public boolean transition() {
        if (this.synchronize() && !this.updatedTopicConfig()) {
            return this.syncTopicConfig();
        }
        if (!this.updatedGroupOffsets() && Predef$.MODULE$.Boolean2boolean(this.clientManager.currentConfig().consumerOffsetSyncEnable())) {
            return this.listGroups();
        }
        return this.stopTopicMirror();
    }

    private boolean processTopic() {
        boolean bl;
        Some some;
        ConfluentAdmin admin = (ConfluentAdmin)this.localAdmin.apply();
        ReplicaStatusOptions options = (ReplicaStatusOptions)new ReplicaStatusOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs));
        Function0 & Serializable & scala.Serializable invokeReplicaStatus_cb = (Function0 & Serializable & scala.Serializable)() -> admin.replicaStatus((Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.partitions()).asJava(), options);
        try {
            some = new Some(this.invoke(invokeReplicaStatus_cb));
        }
        catch (Throwable invokeReplicaStatus_e) {
            throw this.exception(new StringBuilder(36).append("While fetching replica status for '").append(this.topic).append("'").toString(), invokeReplicaStatus_e);
        }
        Some some2 = some;
        if (some2 instanceof Some) {
            ReplicaStatusResult result = (ReplicaStatusResult)some2.value();
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleReplicaStatus((scala.collection.immutable.Map<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>>)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result.result()).asScala()).toMap(Predef$.MODULE$.$conforms())));
            bl = false;
        } else if (None$.MODULE$.equals(some2)) {
            bl = true;
        } else {
            throw new MatchError((Object)some2);
        }
        return bl;
    }

    private boolean handleReplicaStatus(scala.collection.immutable.Map<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>> result) {
        boolean bl;
        Some some;
        Function0 & Serializable & scala.Serializable invokeReplicaStatus_cb = (Function0 & Serializable & scala.Serializable)() -> ((scala.collection.immutable.Map)result.map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)((KafkaFuture)e._2()).get()).asScala()).toList()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            some = new Some(this.invoke(invokeReplicaStatus_cb));
        }
        catch (Throwable invokeReplicaStatus_e) {
            throw this.exception(new StringBuilder(36).append("While fetching replica status for '").append(this.topic).append("'").toString(), invokeReplicaStatus_e);
        }
        Some some2 = some;
        if (some2 instanceof Some) {
            scala.collection.immutable.Map res = (scala.collection.immutable.Map)some2.value();
            bl = this.processReplicaStatus((scala.collection.immutable.Map<TopicPartition, List<ReplicaStatus>>)res);
        } else if (None$.MODULE$.equals(some2)) {
            bl = true;
        } else {
            throw new MatchError((Object)some2);
        }
        return bl;
    }

    private boolean processReplicaStatus(scala.collection.immutable.Map<TopicPartition, List<ReplicaStatus>> result) {
        this.partitionLogEndOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)result.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition part = (TopicPartition)x0$1._1();
            List rsList = (List)x0$1._2();
            ReplicaStatus leader = (ReplicaStatus)((IterableLike)rsList.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isLeader()))).head();
            Iterable iterable = Option$.MODULE$.apply(leader.mirrorInfo().orElse(null)).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopTopicMirror.$anonfun$processReplicaStatus$3(x$2))) && ((LinearSeqOptimized)rsList.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isInIsr()))).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopTopicMirror.$anonfun$processReplicaStatus$5(leader, x$4))) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)BoxesRunTime.boxToLong((long)leader.logEndOffset())))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        if (this.partitionLogEndOffsets().size() == result.size()) {
            return this.transition();
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Not all mirror partitions are ready to be stopped for topic '").append($this.topic).append("', awaiting state change").toString());
        return true;
    }

    private boolean syncTopicConfig() {
        boolean bl;
        Some some;
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, this.topic);
        ConfluentAdmin admin = this.clientManager.getAdmin();
        DescribeConfigsOptions options = new DescribeConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs));
        Function0 & Serializable & scala.Serializable invokeSyncTopicConfig_cb = (Function0 & Serializable & scala.Serializable)() -> admin.describeConfigs(Collections.singleton(resource), options);
        try {
            some = new Some(this.invoke(invokeSyncTopicConfig_cb));
        }
        catch (TopicAuthorizationException invokeSyncTopicConfig_e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Failed to authorize describe topic config for '").append($this.topic).append("', skipping final topic config sync").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncTopicConfig_e);
            some = None$.MODULE$;
        }
        catch (Throwable invokeSyncTopicConfig_e) {
            throw this.exception(new StringBuilder(36).append("While describing topic config for '").append(this.topic).append("'").toString(), invokeSyncTopicConfig_e);
        }
        Some some2 = some;
        if (some2 instanceof Some) {
            DescribeConfigsResult result = (DescribeConfigsResult)some2.value();
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleSyncTopicConfig((KafkaFuture<Config>)((KafkaFuture)result.values().get(resource))));
            bl = false;
        } else if (None$.MODULE$.equals(some2)) {
            this.updatedTopicConfig_$eq(true);
            bl = this.transition();
        } else {
            throw new MatchError((Object)some2);
        }
        return bl;
    }

    private boolean handleSyncTopicConfig(KafkaFuture<Config> future) {
        boolean bl;
        Some some;
        Function0 & Serializable & scala.Serializable invokeSyncTopicConfig_cb = (Function0 & Serializable & scala.Serializable)() -> (Config)future.get();
        try {
            some = new Some(this.invoke(invokeSyncTopicConfig_cb));
        }
        catch (TopicAuthorizationException invokeSyncTopicConfig_e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Failed to authorize describe topic config for '").append($this.topic).append("', skipping final topic config sync").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncTopicConfig_e);
            some = None$.MODULE$;
        }
        catch (Throwable invokeSyncTopicConfig_e) {
            throw this.exception(new StringBuilder(36).append("While describing topic config for '").append(this.topic).append("'").toString(), invokeSyncTopicConfig_e);
        }
        Some some2 = some;
        if (some2 instanceof Some) {
            Config config = (Config)some2.value();
            bl = this.processSyncTopicConfig(config);
        } else if (None$.MODULE$.equals(some2)) {
            this.updatedTopicConfig_$eq(true);
            bl = this.transition();
        } else {
            throw new MatchError((Object)some2);
        }
        return bl;
    }

    private boolean processSyncTopicConfig(Config topicConfig) {
        try {
            Properties newProps;
            Properties curProps = this.clientManager.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.topic);
            Properties properties = newProps = ClusterLinkUtils$.MODULE$.restrictValidateTopicConfigPolicy(this.topic, ClusterLinkUtils$.MODULE$.updateMirrorProps(this.topic, curProps, topicConfig), this.clientManager.alterConfigPolicy());
            if (properties == null ? curProps != null : !((Object)properties).equals(curProps)) {
                this.clientManager.adminZkClient().changeTopicConfig(this.topic, newProps);
            }
        }
        catch (PolicyViolationException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Encountered policy violation when finalizing topic configuration for '").append($this.topic).append("', skipping topic config update").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(41).append("While updating topic configuration for '").append(this.topic).append("'").toString(), e);
        }
        this.updatedTopicConfig_$eq(true);
        return this.transition();
    }

    /*
     * WARNING - void declaration
     */
    private boolean listGroups() {
        boolean bl;
        Some some;
        this.groupFilters_$eq(ClusterLinkUtils$.MODULE$.groupFilters(this.clientManager.currentConfig(), this.clientManager.linkData().tenantPrefix()));
        if (this.groupFilters().isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        Admin admin = this.groupOffsetsAdmin();
        ListConsumerGroupsOptions options = (ListConsumerGroupsOptions)new ListConsumerGroupsOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs));
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> admin.listConsumerGroups(options);
        String invokeSyncGroupOffsets_group = "(none)";
        try {
            void invokeSyncGroupOffsets_cb;
            some = new Some(this.invoke((Function0)invokeSyncGroupOffsets_cb));
        }
        catch (GroupAuthorizationException invokeSyncGroupOffsets_e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Failed to authorize group '").append(group).append("' for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
            some = None$.MODULE$;
        }
        catch (TopicAuthorizationException invokeSyncGroupOffsets_e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to authorize topic for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
            some = None$.MODULE$;
        }
        catch (Throwable invokeSyncGroupOffsets_e) {
            throw this.exception(new StringBuilder(54).append("While updating group offsets for topic '").append(this.topic).append("' and group '").append(invokeSyncGroupOffsets_group).append("'").toString(), invokeSyncGroupOffsets_e);
        }
        Some some2 = some;
        if (some2 instanceof Some) {
            ListConsumerGroupsResult result = (ListConsumerGroupsResult)some2.value();
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleListGroups((KafkaFuture<Collection<ConsumerGroupListing>>)result.all()));
            bl = false;
        } else if (None$.MODULE$.equals(some2)) {
            this.updatedGroupOffsets_$eq(true);
            bl = this.transition();
        } else {
            throw new MatchError((Object)some2);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleListGroups(KafkaFuture<Collection<ConsumerGroupListing>> future) {
        boolean bl;
        Some some;
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> (Collection)future.get();
        String invokeSyncGroupOffsets_group = "(none)";
        try {
            void invokeSyncGroupOffsets_cb;
            some = new Some(this.invoke((Function0)invokeSyncGroupOffsets_cb));
        }
        catch (GroupAuthorizationException invokeSyncGroupOffsets_e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Failed to authorize group '").append(group).append("' for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
            some = None$.MODULE$;
        }
        catch (TopicAuthorizationException invokeSyncGroupOffsets_e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to authorize topic for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
            some = None$.MODULE$;
        }
        catch (Throwable invokeSyncGroupOffsets_e) {
            throw this.exception(new StringBuilder(54).append("While updating group offsets for topic '").append(this.topic).append("' and group '").append(invokeSyncGroupOffsets_group).append("'").toString(), invokeSyncGroupOffsets_e);
        }
        Some some2 = some;
        if (some2 instanceof Some) {
            Collection result = (Collection)some2.value();
            bl = this.processListGroups((Seq<String>)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(result).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.groupId(), Iterable$.MODULE$.canBuildFrom())).toSeq());
        } else if (None$.MODULE$.equals(some2)) {
            this.updatedGroupOffsets_$eq(true);
            bl = this.transition();
        } else {
            throw new MatchError((Object)some2);
        }
        return bl;
    }

    private boolean processListGroups(Seq<String> groups) {
        Seq matchedGroups = (Seq)groups.filter((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopTopicMirror.$anonfun$processListGroups$1(this, g)));
        if (matchedGroups.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        return this.listGroupOffsets((Seq<String>)matchedGroups);
    }

    private boolean listGroupOffsets(Seq<String> groups) {
        ListConsumerGroupOffsetsOptions options = (ListConsumerGroupOffsetsOptions)new ListConsumerGroupOffsetsOptions().topicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.partitions().toList()).asJava()).timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs));
        Admin admin = this.groupOffsetsAdmin();
        scala.collection.immutable.Map futures = ((TraversableOnce)groups.flatMap((Function1 & Serializable & scala.Serializable)group -> Option$.MODULE$.option2Iterable(this.invokeSyncGroupOffsets((String)group, (Function0 & Serializable & scala.Serializable)() -> admin.listConsumerGroupOffsets(group, options)).map((Function1 & Serializable & scala.Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), (Object)result.partitionsToOffsetAndMetadata()))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (futures.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futures.values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleListGroupOffsets((scala.collection.immutable.Map<String, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>>)futures));
        return false;
    }

    private boolean handleListGroupOffsets(scala.collection.immutable.Map<String, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> futures) {
        scala.collection.immutable.Map groupOffsets = (scala.collection.immutable.Map)((MapLike)futures.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map;
            Some some;
            if (x0$1 == null) throw new MatchError(null);
            String group = (String)x0$1._1();
            Function0 & Serializable & scala.Serializable invokeSyncGroupOffsets_cb = () -> ClusterLinkStopTopicMirror.$anonfun$handleListGroupOffsets$2((KafkaFuture)x0$1._2());
            try {
                some = new Some(this.invoke(invokeSyncGroupOffsets_cb));
            }
            catch (GroupAuthorizationException invokeSyncGroupOffsets_e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Failed to authorize group '").append(group).append("' for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
                some = None$.MODULE$;
            }
            catch (TopicAuthorizationException invokeSyncGroupOffsets_e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to authorize topic for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
                some = None$.MODULE$;
            }
            catch (Throwable invokeSyncGroupOffsets_e) {
                throw this.exception(new StringBuilder(54).append("While updating group offsets for topic '").append($this.topic).append("' and group '").append(group).append("'").toString(), invokeSyncGroupOffsets_e);
            }
            Some some2 = some;
            if (some2 instanceof Some) {
                java.util.Map result = (java.util.Map)some2.value();
                map = this.filterListGroupOffsets(group, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms()));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)map);
            } else {
                if (!None$.MODULE$.equals(some2)) throw new MatchError((Object)some2);
                map = Predef$.MODULE$.Map().empty();
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)map);
        }, Map$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopTopicMirror.$anonfun$handleListGroupOffsets$3(x$7)));
        if (groupOffsets.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        return this.alterGroupOffsets((scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)groupOffsets);
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> filterListGroupOffsets(String group, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return ((scala.collection.immutable.Map)offsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            TopicPartition partition = (TopicPartition)x0$1._1();
            OffsetAndMetadata offsetMeta = (OffsetAndMetadata)x0$1._2();
            Option option = this.partitionLogEndOffsets().get((Object)partition);
            if (option instanceof Some) {
                Object object;
                long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (offsetMeta == null) {
                    object = None$.MODULE$;
                } else if (logEndOffset < offsetMeta.offset()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Rolling back offset for group '").append(group).append("' and topic '").append($this.topic).append("' from '").append(offsetMeta.offset()).append(" to '").append(logEndOffset).append("'").toString());
                    object = new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
                } else {
                    object = this.synchronize() ? new Some((Object)BoxesRunTime.boxToLong((long)offsetMeta.offset())) : None$.MODULE$;
                }
                None$ offset = object;
                return Option$.MODULE$.option2Iterable(offset.map((Function1 & Serializable & scala.Serializable)off -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new OffsetAndMetadata(BoxesRunTime.unboxToLong((Object)off), offsetMeta.leaderEpoch(), offsetMeta.metadata()))));
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Unexpected partition '").append(partition).append("', skipping").toString());
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private boolean alterGroupOffsets(scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> groupOffsets) {
        AlterConsumerGroupOffsetsOptions options;
        ConfluentAdmin admin = (ConfluentAdmin)this.localAdmin.apply();
        scala.collection.immutable.Map futures = ((scala.collection.immutable.Map)groupOffsets.flatMap(arg_0 -> ClusterLinkStopTopicMirror.$anonfun$alterGroupOffsets$1(this, admin, options = (AlterConsumerGroupOffsetsOptions)new AlterConsumerGroupOffsetsOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.adminTimeoutMs)), arg_0), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (futures.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition();
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futures.values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleAlterGroupOffsets((scala.collection.immutable.Map<String, KafkaFuture<Void>>)futures));
        return false;
    }

    private boolean handleAlterGroupOffsets(scala.collection.immutable.Map<String, KafkaFuture<Void>> results) {
        results.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Some some;
            if (x0$1 != null) {
                String group = (String)x0$1._1();
                Function0 & Serializable & scala.Serializable invokeSyncGroupOffsets_cb = () -> ClusterLinkStopTopicMirror.$anonfun$handleAlterGroupOffsets$2((KafkaFuture)x0$1._2());
                try {
                    some = new Some(this.invoke(invokeSyncGroupOffsets_cb));
                }
                catch (GroupAuthorizationException invokeSyncGroupOffsets_e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Failed to authorize group '").append(group).append("' for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
                    some = None$.MODULE$;
                }
                catch (TopicAuthorizationException invokeSyncGroupOffsets_e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to authorize topic for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
                    some = None$.MODULE$;
                }
                catch (Throwable invokeSyncGroupOffsets_e) {
                    throw this.exception(new StringBuilder(54).append("While updating group offsets for topic '").append($this.topic).append("' and group '").append(group).append("'").toString(), invokeSyncGroupOffsets_e);
                }
            } else {
                throw new MatchError(null);
            }
            Some some2 = some;
            return some2;
        });
        this.updatedGroupOffsets_$eq(true);
        return this.transition();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean stopTopicMirror() {
        TopicZNode.TopicIdReplicaAssignment topicData = (TopicZNode.TopicIdReplicaAssignment)this.clientManager.zkClient().getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).head();
        if (topicData.assignment().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Detected deleted topic '").append($this.topic).append("' while stopping topic mirror").toString());
            return this.onCompletion();
        }
        if (topicData.assignment().size() != this.partitions().size()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Detected change in partitions while stopping topic mirror");
            this.updatedGroupOffsets_$eq(false);
            return this.transition();
        }
        boolean bl = false;
        Some some = null;
        Option<ClusterLinkTopicState> option = topicData.clusterLink();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState clusterLinkTopicState = (ClusterLinkTopicState)some.value();
            if (clusterLinkTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)clusterLinkTopicState;
                String linkName = pendingStoppedMirror.linkName();
                UUID linkId = pendingStoppedMirror.linkId();
                List logEndOffsets = ((List)((List)this.partitionLogEndOffsets().toList().sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)ClusterLinkStopTopicMirror.$anonfun$stopTopicMirror$3(x$8)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9._2$mcJ$sp()), List$.MODULE$.canBuildFrom())).toList();
                ClusterLinkTopicState.StoppedMirror newState = new ClusterLinkTopicState.StoppedMirror(linkName, linkId, (Seq<Object>)logEndOffsets, ClusterLinkTopicState$StoppedMirror$.MODULE$.apply$default$4());
                this.clientManager.zkClient().setTopicClusterLink(this.topic, (Option<ClusterLinkTopicState>)new Some((Object)newState));
                return this.onCompletion();
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("See cluster link state '").append(state).append("' for topic '").append($this.topic).append("', not performing stop topic mirror task").toString());
            return this.onCompletion();
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("No cluster link state for topic '").append($this.topic).append("', not performing stop topic mirror task").toString());
        return this.onCompletion();
    }

    private Admin groupOffsetsAdmin() {
        if (this.synchronize()) {
            return this.clientManager.getAdmin();
        }
        return (Admin)this.localAdmin.apply();
    }

    private <T> T invoke(Function0<T> cb) {
        try {
            return (T)cb.apply();
        }
        catch (ExecutionException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered execution exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e.getCause());
            throw e.getCause();
        }
        catch (Throwable e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw e;
        }
    }

    private <T> Option<T> invokeReplicaStatus(Function0<T> cb) {
        try {
            return new Some(this.invoke(cb));
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(36).append("While fetching replica status for '").append(this.topic).append("'").toString(), e);
        }
    }

    private <T> Option<T> invokeSyncTopicConfig(Function0<T> cb) {
        try {
            return new Some(this.invoke(cb));
        }
        catch (TopicAuthorizationException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Failed to authorize describe topic config for '").append($this.topic).append("', skipping final topic config sync").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncTopicConfig_e);
            return None$.MODULE$;
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(36).append("While describing topic config for '").append(this.topic).append("'").toString(), e);
        }
    }

    private <T> Option<T> invokeSyncGroupOffsets(String group, Function0<T> cb) {
        try {
            return new Some(this.invoke(cb));
        }
        catch (GroupAuthorizationException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Failed to authorize group '").append(group).append("' for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
            return None$.MODULE$;
        }
        catch (TopicAuthorizationException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to authorize topic for '").append($this.topic).append("' while updating offsets, skipping update of group offsets").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> invokeSyncGroupOffsets_e);
            return None$.MODULE$;
        }
        catch (Throwable e) {
            throw this.exception(new StringBuilder(54).append("While updating group offsets for topic '").append(this.topic).append("' and group '").append(group).append("'").toString(), e);
        }
    }

    private boolean onCompletion() {
        this.shutdown();
        return true;
    }

    private Exception exception(String message, Throwable ex) {
        Exception exception;
        if (ex instanceof ExecutionException) {
            ExecutionException executionException = (ExecutionException)ex;
            exception = new Exception(message, executionException.getCause());
        } else if (ex != null) {
            exception = new Exception(message, ex);
        } else {
            throw new MatchError(null);
        }
        return exception;
    }

    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$3(ReplicaStatus.MirrorInfo x$2) {
        ReplicaStatus.MirrorInfo.State state = x$2.state();
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$5(ReplicaStatus leader$1, ReplicaStatus x$4) {
        return x$4.logEndOffset() == leader$1.logEndOffset();
    }

    public static final /* synthetic */ boolean $anonfun$processListGroups$1(ClusterLinkStopTopicMirror $this, String g) {
        return $this.groupFilters().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.matches(g)));
    }

    public static final /* synthetic */ java.util.Map $anonfun$handleListGroupOffsets$2(KafkaFuture future$3) {
        return (java.util.Map)future$3.get();
    }

    public static final /* synthetic */ boolean $anonfun$handleListGroupOffsets$3(Tuple2 x$7) {
        return ((MapLike)x$7._2()).isEmpty();
    }

    public static final /* synthetic */ Iterable $anonfun$alterGroupOffsets$1(ClusterLinkStopTopicMirror $this, ConfluentAdmin admin$5, AlterConsumerGroupOffsetsOptions options$5, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String group = (String)x0$1._1();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)x0$1._2();
        Iterable iterable = Option$.MODULE$.option2Iterable($this.invokeSyncGroupOffsets(group, (Function0 & Serializable & scala.Serializable)() -> admin$5.alterConsumerGroupOffsets(group, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), options$5)).map((Function1 & Serializable & scala.Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)result.all())));
        return iterable;
    }

    public static final /* synthetic */ Void $anonfun$handleAlterGroupOffsets$2(KafkaFuture future$4) {
        return (Void)future$4.get();
    }

    public static final /* synthetic */ int $anonfun$stopTopicMirror$3(Tuple2 x$8) {
        return ((TopicPartition)x$8._1()).partition();
    }

    public ClusterLinkStopTopicMirror(String topic, ClusterLinkClientManager clientManager, Function0<ConfluentAdmin> localAdmin, int intervalMs, int adminTimeoutMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.localAdmin = localAdmin;
        this.adminTimeoutMs = adminTimeoutMs;
        super(clientManager.scheduler(), "StopTopicMirror", intervalMs);
        this.synchronize = true;
        this.updatedTopicConfig = false;
        this.updatedGroupOffsets = false;
    }

    public static class Exception
    extends KafkaException {
        public Exception(String message, Throwable e) {
            super(message, e);
        }
    }
}

