/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.util.Collections;
import java.util.Set;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkMetadata;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001\u0002\u000f\u001e\u0001\u0011B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011!\u0004!\u0011!Q\u0001\n%D\u0001b\u001c\u0001\u0003\u0006\u0004%\t\u0001\u001d\u0005\tc\u0002\u0011\t\u0011)A\u0005}!A!\u000f\u0001B\u0001B\u0003%a\b\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003u\u0011\u00159\b\u0001\"\u0001y\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0007\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\r\u0011%\t9\u0003\u0001b\u0001\n\u0013\tI\u0003\u0003\u0005\u00022\u0001\u0001\u000b\u0011BA\u0016\u0011%\t\u0019\u0004\u0001b\u0001\n\u0003\t)\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u001c\u0011\u001d\ty\u0004\u0001C!\u0003\u0003Bq!a\u001c\u0001\t\u0003\n\t\bC\u0004\u0002z\u0001!\t%a\u001f\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAP\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003C\u0003A\u0011CAR\u0005a\u0019E.^:uKJd\u0015N\\6OKR<xN]6DY&,g\u000e\u001e\u0006\u0003=}\tA\u0001\\5oW*\u0011\u0001%I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\t\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001K5\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\t1\fgn\u001a\u0006\u0002U\u0005!!.\u0019<b\u0013\tasE\u0001\u0004PE*,7\r\u001e\t\u0003]Yj\u0011a\f\u0006\u0003aE\naaY8n[>t'B\u0001\u00123\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\n\u0005]z#A\u0004*fG>tg-[4ve\u0006\u0014G.Z\u0001\u0012G2,8\u000f^3s\u0019&t7nQ8oM&<\u0007C\u0001\u001e<\u001b\u0005i\u0012B\u0001\u001f\u001e\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\u0017i\"\u0014x\u000e\u001e;mKRKW.Z*f]N|'OT1nKB\u0011q\b\u0013\b\u0003\u0001\u001a\u0003\"!\u0011#\u000e\u0003\tS!aQ\u0012\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d#\u0015\u0001C7fi\u0006$\u0017\r^1\u0011\u00075s\u0005+D\u0001E\u0013\tyEI\u0001\u0004PaRLwN\u001c\t\u0003uEK!AU\u000f\u0003'\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1\u0002\u001f5,G/\u00193bi\u0006,\u0006\u000fZ1uKJ\u00042!\u0014(V!\t1\u0016,D\u0001X\u0015\tA\u0016'A\u0004dY&,g\u000e^:\n\u0005i;&aD'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a:\u0002\u000f5,GO]5dgB\u0011QlX\u0007\u0002=*\u00111lL\u0005\u0003Az\u0013q!T3ue&\u001c7/\u0001\u0006nKR\u0014\u0018n\u0019+bON\u0004Ba\u00194?}5\tAM\u0003\u0002f\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d$'aA'ba\u0006!A/[7f!\tQW.D\u0001l\u0015\taw&A\u0003vi&d7/\u0003\u0002oW\n!A+[7f\u0003!\u0019G.[3oi&#W#\u0001 \u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013AC2mS\u0016tG\u000fV=qK\u0006QAn\\4D_:$X\r\u001f;\u0011\u0005),\u0018B\u0001<l\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001feT8\u0010`?\u007f\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\u0001\"A\u000f\u0001\t\u000bab\u0001\u0019A\u001d\t\u000bub\u0001\u0019\u0001 \t\u000b-c\u0001\u0019\u0001'\t\u000bMc\u0001\u0019\u0001+\t\u000bmc\u0001\u0019\u0001/\t\u000b\u0005d\u0001\u0019\u00012\t\u000b!d\u0001\u0019A5\t\u000b=d\u0001\u0019\u0001 \t\u000bId\u0001\u0019\u0001 \t\u000bMd\u0001\u0019\u0001;\u0002%QD'o\u001c;uY\u0016$\u0016.\\3TK:\u001cxN]\u000b\u0003\u0003\u001b\u00012!XA\b\u0013\r\t\tB\u0018\u0002\u0007'\u0016t7o\u001c:\u0002'QD'o\u001c;uY\u0016$\u0016.\\3TK:\u001cxN\u001d\u0011\u0002\u001d\rD\u0017M\u001c8fY\n+\u0018\u000e\u001c3feV\u0011\u0011\u0011\u0004\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011qD\u0018\u0002\u000f9,Go^8sW&!\u00111EA\u000f\u00059\u0019\u0005.\u00198oK2\u0014U/\u001b7eKJ\fqb\u00195b]:,GNQ;jY\u0012,'\u000fI\u0001\tg\u0016dWm\u0019;peV\u0011\u00111\u0006\t\u0005\u00037\ti#\u0003\u0003\u00020\u0005u!\u0001C*fY\u0016\u001cGo\u001c:\u0002\u0013M,G.Z2u_J\u0004\u0013!\u00048fi^|'o[\"mS\u0016tG/\u0006\u0002\u00028A\u0019a+!\u000f\n\u0007\u0005mrKA\u0006LC\u001a\\\u0017m\u00117jK:$\u0018A\u00048fi^|'o[\"mS\u0016tG\u000fI\u0001\nG>tg-[4ve\u0016$B!a\u0011\u0002JA\u0019Q*!\u0012\n\u0007\u0005\u001dCI\u0001\u0003V]&$\bbBA&+\u0001\u0007\u0011QJ\u0001\bG>tg-[4ta\u0011\ty%!\u0018\u0011\u000f\u0005E\u0013q\u000b \u0002Z5\u0011\u00111\u000b\u0006\u0004\u0003+J\u0013\u0001B;uS2L1aZA*!\u0011\tY&!\u0018\r\u0001\u0011a\u0011qLA%\u0003\u0003\u0005\tQ!\u0001\u0002b\t\u0019q\fJ\u0019\u0012\t\u0005\r\u0014\u0011\u000e\t\u0004\u001b\u0006\u0015\u0014bAA4\t\n9aj\u001c;iS:<\u0007cA'\u0002l%\u0019\u0011Q\u000e#\u0003\u0007\u0005s\u00170A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0015\u0005\u0005M\u0004#BA)\u0003kr\u0014\u0002BA<\u0003'\u00121aU3u\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0002D\u0005u\u0004bBA&/\u0001\u0007\u0011q\u0010\u0019\u0005\u0003\u0003\u000b)\tE\u0004\u0002R\u0005]c(a!\u0011\t\u0005m\u0013Q\u0011\u0003\r\u0003\u000f\u000bi(!A\u0001\u0002\u000b\u0005\u0011\u0011\r\u0002\u0004?\u0012\u0012\u0014a\u0003:fG>tg-[4ve\u0016$B!a\u0011\u0002\u000e\"9\u0011q\u0012\rA\u0002\u0005E\u0015A\u00038fo\u000e{gNZ5hgB\"\u00111SAL!\u001d\t\t&a\u0016?\u0003+\u0003B!a\u0017\u0002\u0018\u0012a\u0011\u0011TAG\u0003\u0003\u0005\tQ!\u0001\u0002b\t\u0019q\fJ\u001a\u0002\u001b%t\u0017\u000e^5bi\u0016\u001cEn\\:f)\t\t\u0019%A\u0003dY>\u001cX-A\nde\u0016\fG/\u001a(fi^|'o[\"mS\u0016tG\u000f\u0006\u0003\u00028\u0005\u0015\u0006bBA\u00147\u0001\u0007\u00111\u0006")
public class ClusterLinkNetworkClient
implements Reconfigurable {
    private final ClusterLinkConfig clusterLinkConfig;
    private final Option<ClusterLinkMetadata> metadata;
    private final Option<MetadataUpdater> metadataUpdater;
    private final Time time;
    private final String clientId;
    private final LogContext logContext;
    private final Sensor throttleTimeSensor;
    private final ChannelBuilder channelBuilder;
    private final Selector selector;
    private final KafkaClient networkClient;

    public String clientId() {
        return this.clientId;
    }

    private Sensor throttleTimeSensor() {
        return this.throttleTimeSensor;
    }

    private ChannelBuilder channelBuilder() {
        return this.channelBuilder;
    }

    private Selector selector() {
        return this.selector;
    }

    public KafkaClient networkClient() {
        return this.networkClient;
    }

    public void configure(java.util.Map<String, ?> configs) {
    }

    public Set<String> reconfigurableConfigs() {
        ChannelBuilder channelBuilder = this.channelBuilder();
        Set set = channelBuilder instanceof Reconfigurable ? ((Reconfigurable)channelBuilder).reconfigurableConfigs() : Collections.emptySet();
        return set;
    }

    public void validateReconfiguration(java.util.Map<String, ?> configs) {
        ChannelBuilder channelBuilder = this.channelBuilder();
        if (channelBuilder instanceof Reconfigurable) {
            ((Reconfigurable)channelBuilder).validateReconfiguration(configs);
            return;
        }
    }

    public void reconfigure(java.util.Map<String, ?> newConfigs) {
        ChannelBuilder channelBuilder = this.channelBuilder();
        if (channelBuilder instanceof Reconfigurable) {
            ((Reconfigurable)channelBuilder).reconfigure(newConfigs);
            return;
        }
    }

    public void initiateClose() {
        this.networkClient().initiateClose();
    }

    public void close() {
        this.networkClient().close();
    }

    public KafkaClient createNetworkClient(Selector selector) {
        return new NetworkClient((MetadataUpdater)this.metadataUpdater.orNull(Predef$.MODULE$.$conforms()), (Metadata)this.metadata.orNull(Predef$.MODULE$.$conforms()), (Selectable)selector, this.clientId(), 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), this.clusterLinkConfig.connectionSetupTimeoutMs(), this.clusterLinkConfig.connectionSetupTimeoutMaxMs(), this.clusterLinkConfig.dnsLookup(), this.time, true, new ApiVersions(), this.throttleTimeSensor(), this.logContext);
    }

    public ClusterLinkNetworkClient(ClusterLinkConfig clusterLinkConfig, String throttleTimeSensorName, Option<ClusterLinkMetadata> metadata, Option<MetadataUpdater> metadataUpdater, Metrics metrics, Map<String, String> metricTags, Time time, String clientId, String clientType, LogContext logContext) {
        this.clusterLinkConfig = clusterLinkConfig;
        this.metadata = metadata;
        this.metadataUpdater = metadataUpdater;
        this.time = time;
        this.clientId = clientId;
        this.logContext = logContext;
        this.throttleTimeSensor = metrics.sensor(throttleTimeSensorName);
        this.channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)clusterLinkConfig.securityProtocol(), (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)clusterLinkConfig, null, (String)clusterLinkConfig.saslMechanism(), (Time)time, (boolean)true, (LogContext)logContext);
        this.selector = new Selector(-1, Predef$.MODULE$.Long2long(clusterLinkConfig.connectionsMaxIdleMs()), metrics, time, new StringBuilder(13).append("cluster-link-").append(clientType).toString(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(metricTags).asJava(), false, this.channelBuilder(), logContext);
        this.networkClient = this.createNetworkClient(this.selector());
    }
}

