/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.MetadataListener;
import kafka.server.link.MetadataRefreshListener;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\f\u0019\u0001}A\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000bQ\u0003A\u0011A+\t\u000fq\u0003!\u0019!C\u0005;\"1\u0011\r\u0001Q\u0001\nyC\u0001B\u0019\u0001C\u0002\u0013\u0005\u0001d\u0019\u0005\u0007O\u0002\u0001\u000b\u0011\u00023\t\u000f!\u0004!\u0019!C\u0005S\"1Q\u000f\u0001Q\u0001\n)D\u0011B\u001e\u0001A\u0002\u0003\u0007I\u0011B<\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\bBCA\u0004\u0001\u0001\u0007\t\u0011)Q\u0005q\"9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003?\u0001A\u0011IA\n\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\u000b\u0001\t#\tY\u0003C\u0004\u00022\u0001!\t%a\u0005\u00033\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1UQJ,\u0017\r\u001a\u0006\u00033i\tA\u0001\\5oW*\u00111\u0004H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001A\u0019R\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u001d\u0003\u0015)H/\u001b7t\u0013\t)#E\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007CA\u0014)\u001b\u0005A\u0012BA\u0015\u0019\u0005]iU\r^1eCR\f'+\u001a4sKNDG*[:uK:,'\u000f\u0005\u0002\"W%\u0011AF\t\u0002\b\u0019><w-\u001b8h\u0003E\u0019G.^:uKJd\u0015N\\6D_:4\u0017n\u001a\t\u0003O=J!\u0001\r\r\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-A\u000beKN$8i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0007M2\u0004(D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u0019y\u0005\u000f^5p]B\u0011q%O\u0005\u0003ua\u0011\u0001e\u00117vgR,'\u000fT5oW\u0012+7\u000f^\"p]:,7\r^5p]6\u000bg.Y4fe\u0006\u00192\r\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uCV\tQ\b\u0005\u0002(}%\u0011q\b\u0007\u0002\u0014\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y\u0001\u0015G2,8\u000f^3s\u0019&t7.T3uC\u0012\fG/\u0019\u0011\u0002\u000f5,GO]5dgB\u00111\tT\u0007\u0002\t*\u0011\u0011)\u0012\u0006\u0003\r\u001e\u000baaY8n[>t'BA\u000fI\u0015\tI%*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0006\u0019qN]4\n\u00055#%aB'fiJL7m]\u0001\u0005i&lW\r\u0005\u0002Q%6\t\u0011K\u0003\u0002$\u000b&\u00111+\u0015\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\u0007-^C\u0016LW.\u0011\u0005\u001d\u0002\u0001\"B\u0017\b\u0001\u0004q\u0003\"B\u0019\b\u0001\u0004\u0011\u0004\"B\u001e\b\u0001\u0004i\u0004\"B!\b\u0001\u0004\u0011\u0005\"\u0002(\b\u0001\u0004y\u0015A\u00037pO\u000e{g\u000e^3yiV\ta\f\u0005\u0002Q?&\u0011\u0001-\u0015\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\n\u0011c\u00197vgR,'\u000fT5oW\u000ec\u0017.\u001a8u+\u0005!\u0007CA\u0014f\u0013\t1\u0007D\u0001\rDYV\u001cH/\u001a:MS:\\g*\u001a;x_J\\7\t\\5f]R\f!c\u00197vgR,'\u000fT5oW\u000ec\u0017.\u001a8uA\u0005\tR.\u001a;bI\u0006$\u0018\rT5ti\u0016tWM]:\u0016\u0003)\u00042a\u001b9s\u001b\u0005a'BA7o\u0003\u001diW\u000f^1cY\u0016T!a\u001c\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002rY\n1!)\u001e4gKJ\u0004\"aJ:\n\u0005QD\"\u0001E'fi\u0006$\u0017\r^1MSN$XM\\3s\u0003IiW\r^1eCR\fG*[:uK:,'o\u001d\u0011\u0002-\r,(O]3oi6+G/\u00193bi\u0006\u001cE.^:uKJ,\u0012\u0001\u001f\t\u0003sjl\u0011!R\u0005\u0003w\u0016\u0013qa\u00117vgR,'/\u0001\u000edkJ\u0014XM\u001c;NKR\fG-\u0019;b\u00072,8\u000f^3s?\u0012*\u0017\u000fF\u0002\u007f\u0003\u0007\u0001\"aM@\n\u0007\u0005\u0005AG\u0001\u0003V]&$\b\u0002CA\u0003\u001f\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0013'A\fdkJ\u0014XM\u001c;NKR\fG-\u0019;b\u00072,8\u000f^3sA!\u001a\u0001#a\u0003\u0011\u0007M\ni!C\u0002\u0002\u0010Q\u0012\u0001B^8mCRLG.Z\u0001\u0007I><vN]6\u0015\u0003y\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\u0005e\u0001cA\u001a\u0002\u001c%\u0019\u0011Q\u0004\u001b\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011m^1jiNCW\u000f\u001e3po:\f1\"\u00193e\u0019&\u001cH/\u001a8feR\u0019a0!\n\t\r\u0005\u001dB\u00031\u0001s\u0003!a\u0017n\u001d;f]\u0016\u0014\u0018aE2sK\u0006$XMT3uo>\u00148n\u00117jK:$H#\u00023\u0002.\u0005=\u0002\"B\u0017\u0016\u0001\u0004q\u0003\"B\u001e\u0016\u0001\u0004i\u0014aF8o\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiV\u0003H-\u0019;f\u0001")
public class ClusterLinkMetadataThread
extends ShutdownableThread
implements MetadataRefreshListener {
    private final Option<ClusterLinkDestConnectionManager> destConnectionManager;
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final Metrics metrics;
    private final Time time;
    private final LogContext logContext;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final Buffer<MetadataListener> metadataListeners;
    private volatile Cluster currentMetadataCluster;

    public ClusterLinkMetadata clusterLinkMetadata() {
        return this.clusterLinkMetadata;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private Buffer<MetadataListener> metadataListeners() {
        return this.metadataListeners;
    }

    private Cluster currentMetadataCluster() {
        return this.currentMetadataCluster;
    }

    private void currentMetadataCluster_$eq(Cluster x$1) {
        this.currentMetadataCluster = x$1;
    }

    @Override
    public void doWork() {
        try {
            this.clusterLinkClient().networkClient().poll(Long.MAX_VALUE, this.time.milliseconds());
            Cluster newMetadataCluster = this.clusterLinkMetadata().fetch();
            if (newMetadataCluster != this.currentMetadataCluster()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Process cluster link metadata ").append(newMetadataCluster).toString());
                this.metadataListeners().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.onNewMetadata(newMetadataCluster);
                    return BoxedUnit.UNIT;
                });
                this.currentMetadataCluster_$eq(newMetadataCluster);
            }
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to refresh metadata", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    @Override
    public boolean initiateShutdown() {
        this.clusterLinkClient().initiateClose();
        return super.initiateShutdown();
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.clusterLinkClient().close();
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to close metadata client after shutting down thread", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void addListener(MetadataListener listener) {
        this.metadataListeners().$plus$eq((Object)listener);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkNetworkClient createNetworkClient(ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata) {
        void var3_3;
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)new Some((Object)clusterLinkMetadata), (Option<MetadataUpdater>)None$.MODULE$, this.metrics, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), this.time, new StringBuilder(22).append("cluster-link-metadata-").append(clusterLinkMetadata.linkDescription()).toString(), "metadata", this.logContext());
        this.destConnectionManager.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    @Override
    public void onMetadataRequestUpdate() {
        this.clusterLinkClient().networkClient().wakeup();
    }

    public ClusterLinkMetadataThread(ClusterLinkConfig clusterLinkConfig, Option<ClusterLinkDestConnectionManager> destConnectionManager, ClusterLinkMetadata clusterLinkMetadata, Metrics metrics, Time time) {
        this.destConnectionManager = destConnectionManager;
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.metrics = metrics;
        this.time = time;
        super(new StringBuilder(13).append("LinkMetadata-").append(clusterLinkMetadata.linkDescription()).toString(), ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.logContext = new LogContext(new StringBuilder(29).append("[ClusterLinkMetadataClient ").append(clusterLinkMetadata.linkDescription()).append("] ").toString());
        this.clusterLinkClient = this.createNetworkClient(clusterLinkConfig, clusterLinkMetadata);
        this.metadataListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        clusterLinkMetadata.setRefreshListener(this);
    }
}

