/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LogAppendInfo;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.FetchState;
import kafka.tier.fetcher.TierStateFetcher;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidMetadataException;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r}r!\u0002\u001b6\u0011\u0003ad!\u0002 6\u0011\u0003y\u0004\"\u0002$\u0002\t\u00039\u0005b\u0002%\u0002\u0005\u0004%\t!\u0013\u0005\u0007?\u0006\u0001\u000b\u0011\u0002&\t\u000b\u0001\fA\u0011A1\t\u0013\r\u001d\u0012!%A\u0005\u0002\r%b\u0001\u0002 6\u0001\rD\u0001\u0002[\u0004\u0003\u0002\u0003\u0006I!\u001b\u0005\ti\u001e\u0011\t\u0011)A\u0005k\"A\u0001p\u0002B\u0001B\u0003%\u0011\u0010\u0003\u0005}\u000f\t\u0005\t\u0015!\u0003~\u0011)\t\ta\u0002B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003\u00139!\u0011!Q\u0001\n\u0005-\u0001\u0002DA\t\u000f\t\u0005\t\u0015!\u0003\u0002\u0014\u0005}\u0001BCA\u0013\u000f\t\u0005\t\u0015!\u0003\u0002(!Q\u0011QF\u0004\u0003\u0002\u0003\u0006I!a\f\t\u0015\u0005UrA!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002>\u001d\u0011\t\u0011)A\u0005\u0003\u007fA!\"!\u0013\b\u0005\u0003\u0005\u000b\u0011BA&\u0011)\t9f\u0002B\u0001B\u0003%\u0011\u0011\f\u0005\f\u0003_:!Q1A\u0005\u0002U\n\t\b\u0003\u0006\u0002z\u001d\u0011\t\u0011)A\u0005\u0003gB!\"a\u001f\b\u0005\u0003\u0005\u000b\u0011BA?\u0011)\t\u0019i\u0002B\u0001B\u0003%\u0011Q\u0011\u0005\u0007\r\u001e!\t!!$\t\u0013\u0005=vA1A\u0005\n\u0005E\u0006\u0002CAb\u000f\u0001\u0006I!a-\t\u0013\u0005\u0015wA1A\u0005\n\u0005E\u0006\u0002CAd\u000f\u0001\u0006I!a-\t\u0013\u0005%wA1A\u0005\n\u0005E\u0006\u0002CAf\u000f\u0001\u0006I!a-\t\u0013\u00055w\u00011A\u0005\n\u0005=\u0007\"CAl\u000f\u0001\u0007I\u0011BAm\u0011!\t)o\u0002Q!\n\u0005E\u0007\"CAt\u000f\t\u0007I\u0011KAY\u0011!\tIo\u0002Q\u0001\n\u0005M\u0006\"CAv\u000f\t\u0007I\u0011KAw\u0011!\t)p\u0002Q\u0001\n\u0005=\bbBA|\u000f\u0011E\u0013\u0011 \u0005\b\u0005k9A\u0011\u000bB\u001c\u0011%\u0011\u0019h\u0002b\u0001\n\u0003\ni\u000f\u0003\u0005\u0003v\u001d\u0001\u000b\u0011BAx\u0011\u001d\u00119h\u0002C)\u0005sBqAa$\b\t#\u0012\t\nC\u0004\u0003\u001a\u001e!\tFa'\t\u0011\t\u001dv\u0001\"\u00156\u0005SCqAa.\b\t\u0003\u0012I\fC\u0004\u0003\\\u001e!\tE!8\t\u000f\tEx\u0001\"\u0011\u0003t\"9!q_\u0004\u0005B\te\bb\u0002B~\u000f\u0011E!Q`\u0001\u0019\u00072,8\u000f^3s\u0019&t7NR3uG\",'\u000f\u00165sK\u0006$'B\u0001\u001c8\u0003\u0011a\u0017N\\6\u000b\u0005aJ\u0014AB:feZ,'OC\u0001;\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!P\u0001\u000e\u0003U\u0012\u0001d\u00117vgR,'\u000fT5oW\u001a+Go\u00195feRC'/Z1e'\t\t\u0001\t\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%I\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\n!\u0002T5oW\u0016\u0013(o\u001c:t+\u0005Q\u0005cA&Q%6\tAJ\u0003\u0002N\u001d\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u001f\n\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\tFJA\u0002TKR\u0004\"aU/\u000e\u0003QS!!\u0016,\u0002\u0011A\u0014x\u000e^8d_2T!a\u0016-\u0002\r\r|W.\\8o\u0015\tQ\u0014L\u0003\u0002[7\u00061\u0011\r]1dQ\u0016T\u0011\u0001X\u0001\u0004_J<\u0017B\u00010U\u0005\u0019)%O]8sg\u0006YA*\u001b8l\u000bJ\u0014xN]:!\u0003\u0015\t\u0007\u000f\u001d7z)u\u001171AB\u0003\u0007\u000f\u0019Iaa\u0003\u0004\u000e\r=1\u0011DB\u000e\u0007;\u0019yb!\t\u0004$\r\u0015\u0002CA\u001f\b'\t9A\r\u0005\u0002fM6\tq'\u0003\u0002ho\t!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAA\\1nKB\u0011!.\u001d\b\u0003W>\u0004\"\u0001\u001c\"\u000e\u00035T!A\\\u001e\u0002\rq\u0012xn\u001c;?\u0013\t\u0001()\u0001\u0004Qe\u0016$WMZ\u0005\u0003eN\u0014aa\u0015;sS:<'B\u00019C\u0003%1W\r^2iKJLE\r\u0005\u0002Bm&\u0011qO\u0011\u0002\u0004\u0013:$\u0018\u0001\u00042s_.,'oQ8oM&<\u0007CA3{\u0013\tYxGA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!E2mkN$XM\u001d'j].\u001cuN\u001c4jOB\u0011QH`\u0005\u0003\u007fV\u0012\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003M\u0019G.^:uKJd\u0015N\\6NKR\fG-\u0019;b!\ri\u0014QA\u0005\u0004\u0003\u000f)$aE\"mkN$XM\u001d'j].lU\r^1eCR\f\u0017A\u00044fi\u000eDWM]'b]\u0006<WM\u001d\t\u0004{\u00055\u0011bAA\bk\tI2\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\rs\u000591\r\\;ti\u0016\u0014\u0018\u0002BA\u000f\u0003/\u0011aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/\u0003\u0003\u0002\u0012\u0005\u0005\u0012bAA\u0012o\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\r)\u0017\u0011F\u0005\u0004\u0003W9$\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0004K\u0006E\u0012bAA\u001ao\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!B9v_R\f\u0007cA3\u0002:%\u0019\u00111H\u001c\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\u0002\u000f5,GO]5dgB!\u0011\u0011IA#\u001b\t\t\u0019EC\u0002\u0002>YKA!a\u0012\u0002D\t9Q*\u001a;sS\u000e\u001c\u0018\u0001\u0002;j[\u0016\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#2\u0016!B;uS2\u001c\u0018\u0002BA+\u0003\u001f\u0012A\u0001V5nK\u0006\u0001B/[3s'R\fG/\u001a$fi\u000eDWM\u001d\t\u0006\u0003\u0006m\u0013qL\u0005\u0004\u0003;\u0012%AB(qi&|g\u000e\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\u000f\u0019,Go\u00195fe*\u0019\u0011\u0011N\u001d\u0002\tQLWM]\u0005\u0005\u0003[\n\u0019G\u0001\tUS\u0016\u00148\u000b^1uK\u001a+Go\u00195fe\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;\u0016\u0005\u0005M\u0004cA\u001f\u0002v%\u0019\u0011qO\u001b\u00031\rcWo\u001d;fe2Kgn\u001b(fi^|'o[\"mS\u0016tG/\u0001\ndYV\u001cH/\u001a:MS:\\7\t\\5f]R\u0004\u0013A\u00077fC\u0012,'/\u00128ea>Lg\u000e\u001e\"m_\u000e\\\u0017N\\4TK:$\u0007cA3\u0002\u0000%\u0019\u0011\u0011Q\u001c\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\u0002\u001b1|wmQ8oi\u0016DHo\u00149u!\u0015\t\u00151LAD!\u0011\ti%!#\n\t\u0005-\u0015q\n\u0002\u000b\u0019><7i\u001c8uKb$H#\t2\u0002\u0010\u0006E\u00151SAK\u0003/\u000bI*a'\u0002\u001e\u0006}\u0015\u0011UAR\u0003K\u000b9+!+\u0002,\u00065\u0006\"\u00025\u001a\u0001\u0004I\u0007\"\u0002;\u001a\u0001\u0004)\b\"\u0002=\u001a\u0001\u0004I\b\"\u0002?\u001a\u0001\u0004i\bbBA\u00013\u0001\u0007\u00111\u0001\u0005\b\u0003\u0013I\u0002\u0019AA\u0006\u0011\u001d\t\t\"\u0007a\u0001\u0003'Aq!!\n\u001a\u0001\u0004\t9\u0003C\u0004\u0002.e\u0001\r!a\f\t\u000f\u0005U\u0012\u00041\u0001\u00028!9\u0011QH\rA\u0002\u0005}\u0002bBA%3\u0001\u0007\u00111\n\u0005\b\u0003/J\u0002\u0019AA-\u0011\u001d\ty'\u0007a\u0001\u0003gBq!a\u001f\u001a\u0001\u0004\ti\bC\u0005\u0002\u0004f\u0001\n\u00111\u0001\u0002\u0006\u00069Q.\u0019=XC&$XCAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000bA\u0001\\1oO*\u0011\u0011QX\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002B\u0006]&aB%oi\u0016<WM]\u0001\t[\u0006Dx+Y5uA\u0005AQ.\u001b8CsR,7/A\u0005nS:\u0014\u0015\u0010^3tA\u0005AQ.\u0019=CsR,7/A\u0005nCb\u0014\u0015\u0010^3tA\u0005yA.Y:u\r\u0016$8\r\u001b+j[\u0016l5/\u0006\u0002\u0002RB\u0019\u0011)a5\n\u0007\u0005U'I\u0001\u0003M_:<\u0017a\u00057bgR4U\r^2i)&lW-T:`I\u0015\fH\u0003BAn\u0003C\u00042!QAo\u0013\r\tyN\u0011\u0002\u0005+:LG\u000fC\u0005\u0002d\u0006\n\t\u00111\u0001\u0002R\u0006\u0019\u0001\u0010J\u0019\u0002!1\f7\u000f\u001e$fi\u000eDG+[7f\u001bN\u0004\u0013!\u00034fi\u000eD7+\u001b>f\u0003)1W\r^2i'&TX\rI\u0001\u001dSN$&/\u001e8dCRLwN\\(o\r\u0016$8\r[*vaB|'\u000f^3e+\t\ty\u000fE\u0002B\u0003cL1!a=C\u0005\u001d\u0011un\u001c7fC:\fQ$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G\rI\u0001\u0014M\u0016$8\r\u001b*fcV,7\u000f\u001e\"vS2$WM\u001d\u000b\u0005\u0003w\u0014y\u0001\u0005\u0003\u0002~\n%a\u0002BA\u0000\u0005\u000bi!A!\u0001\u000b\u0007\t\ra+\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u00119A!\u0001\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\t-!Q\u0002\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\u00119A!\u0001\t\u000f\tEq\u00051\u0001\u0003\u0014\u0005Ia-\u001a;dQ\u0012\u000bG/\u0019\t\u0005\u0005+\u0011yC\u0004\u0003\u0003\u0018\t%b\u0002\u0002B\r\u0005KqAAa\u0007\u0003$9!!Q\u0004B\u0011\u001d\ra'qD\u0005\u00029&\u0011!lW\u0005\u0003ueK1Aa\nY\u0003\u001d\u0019G.[3oiNLAAa\u000b\u0003.\u0005\u0019b)\u001a;dQN+7o]5p]\"\u000bg\u000e\u001a7fe*\u0019!q\u0005-\n\t\tE\"1\u0007\u0002\u0011\r\u0016$8\r\u001b*fcV,7\u000f\u001e#bi\u0006TAAa\u000b\u0003.\u0005AB.[:u\u001f\u001a47/\u001a;SKF,Xm\u001d;Ck&dG-\u001a:\u0015\t\te\"Q\t\t\u0005\u0005w\u0011\tE\u0004\u0003\u0002\u0000\nu\u0012\u0002\u0002B \u0005\u0003\t!\u0003T5ti>3gm]3ugJ+\u0017/^3ti&!!1\u0002B\"\u0015\u0011\u0011yD!\u0001\t\u000f\t\u001d\u0003\u00061\u0001\u0003J\u0005\u0019\u0002/\u0019:uSRLwN\u001c+j[\u0016\u001cH/Y7qgBA!1\nB'\u0005#\u0012I&D\u0001O\u0013\r\u0011yE\u0014\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002B*\u0005+j\u0011AV\u0005\u0004\u0005/2&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u00057\u0012iG\u0004\u0003\u0003^\t\u001dd\u0002\u0002B0\u0005GrAA!\u0007\u0003b%\u0011q\u000bW\u0005\u0004\u0005K2\u0016aB7fgN\fw-Z\u0005\u0005\u0005S\u0012Y'\u0001\fMSN$xJ\u001a4tKR\u001c(+Z9vKN$H)\u0019;b\u0015\r\u0011)GV\u0005\u0005\u0005_\u0012\tH\u0001\u000bMSN$xJ\u001a4tKR\u001c\b+\u0019:uSRLwN\u001c\u0006\u0005\u0005S\u0012Y'A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\f\u0001%[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3eA\u0005qqN\\(gMN,G\u000fV5fe\u0016$GCBAx\u0005w\u0012y\bC\u0004\u0003~-\u0002\rA!\u0015\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9!\u0011Q\u0016A\u0002\t\r\u0015\u0001\u0004:fcV,7\u000f^#q_\u000eD\u0007C\u0002BC\u0005\u0017\u000b\u0019,\u0004\u0002\u0003\b*!!\u0011RA^\u0003\u0011)H/\u001b7\n\t\t5%q\u0011\u0002\t\u001fB$\u0018n\u001c8bY\u0006\trN\u001c)beRLG/[8o\r\u0016t7-\u001a3\u0015\r\u0005=(1\u0013BL\u0011\u001d\u0011)\n\fa\u0001\u0005#\n!\u0001\u001e9\t\u000f\t\u0005E\u00061\u0001\u0003\u0004\u0006Q\u0002.\u00198eY\u0016\u0004\u0016M\u001d;ji&|gn],ji\",%O]8sgR1\u00111\u001cBO\u0005GCqAa(.\u0001\u0004\u0011\t+\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004rAa\u0013\u0003N\tE#\u000b\u0003\u0004\u0003&6\u0002\r![\u0001\u000b[\u0016$\bn\u001c3OC6,\u0017aL;qI\u0006$XMR3uG\"|eMZ:fi\u0006sG-T1zE\u0016l\u0015M]6UeVt7-\u0019;j_:\u001cu.\u001c9mKR,G\u0003BAn\u0005WCqA!,/\u0001\u0004\u0011y+\u0001\u0007gKR\u001c\u0007n\u00144gg\u0016$8\u000f\u0005\u0005\u0003L\t5#\u0011\u000bBY!\r)'1W\u0005\u0004\u0005k;$!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0015aJ|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0015\u0011\tm&\u0011\u001aBf\u0005\u001f\u0004R!QA.\u0005{\u0003BAa0\u0003F6\u0011!\u0011\u0019\u0006\u0004\u0005\u0007L\u0014a\u00017pO&!!q\u0019Ba\u00055aunZ!qa\u0016tG-\u00138g_\"9!QS\u0018A\u0002\tE\u0003b\u0002Bg_\u0001\u0007\u0011\u0011[\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u0003R>\u0002\rAa5\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\u0011)Na6\u000e\u0003\u001dIAA!7\u0002\"\tIa)\u001a;dQ\u0012\u000bG/Y\u0001\u0017g\"|W\u000f\u001c3G_2dwn^3s)\"\u0014x\u000e\u001e;mKRQ\u0011q\u001eBp\u0005G\u0014)Oa<\t\u000f\t\u0005\b\u00071\u0001\u0002p\u0006y\u0011n])v_R\fW\t_2fK\u0012,G\rC\u0004\u00026A\u0002\r!a\u000e\t\u000f\t\u001d\b\u00071\u0001\u0003j\u0006Qa-\u001a;dQN#\u0018\r^3\u0011\u0007\u0015\u0014Y/C\u0002\u0003n^\u00121\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016DqA! 1\u0001\u0004\u0011\t&A\bjgJ+\u0017\rZ=G_J4U\r^2i)\u0011\tyO!>\t\u000f\tU\u0015\u00071\u0001\u0003R\u0005YR.\u0019:l\r>dGn\\<feJ+\u0007\u000f\\5dCRC'o\u001c;uY\u0016$\"!a7\u00023\rdW-\u0019:QCJ$\u0018\u000e^5p]2Kgn\u001b$bS2,(/\u001a\u000b\u0007\u00037\u0014yp!\u0001\t\u000f\tU5\u00071\u0001\u0003R!9!QZ\u001aA\u0002\u0005E\u0007\"\u00025\u0006\u0001\u0004I\u0007\"\u0002;\u0006\u0001\u0004)\b\"\u0002=\u0006\u0001\u0004I\b\"\u0002?\u0006\u0001\u0004i\bbBA\u0001\u000b\u0001\u0007\u00111\u0001\u0005\b\u0003\u0013)\u0001\u0019AA\u0006\u0011\u001d\u0019\t\"\u0002a\u0001\u0007'\tQ\u0003Z3ti\u000e{gN\\3di&|g.T1oC\u001e,'\u000fE\u0002>\u0007+I1aa\u00066\u0005\u0001\u001aE.^:uKJd\u0015N\\6EKN$8i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\t\u000f\u0005EQ\u00011\u0001\u0002\u0014!9\u0011QE\u0003A\u0002\u0005\u001d\u0002bBA\u0017\u000b\u0001\u0007\u0011q\u0006\u0005\b\u0003k)\u0001\u0019AA\u001c\u0011\u001d\ti$\u0002a\u0001\u0003\u007fAq!!\u0013\u0006\u0001\u0004\tY\u0005C\u0004\u0002X\u0015\u0001\r!!\u0017\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132mU\u001111\u0006\u0016\u0005\u0003\u000b\u001bic\u000b\u0002\u00040A!1\u0011GB\u001e\u001b\t\u0019\u0019D\u0003\u0003\u00046\r]\u0012!C;oG\",7m[3e\u0015\r\u0019IDQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u001f\u0007g\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ClusterLinkFetcherThread
extends ReplicaFetcherThread {
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final ClusterLinkFetcherManager fetcherManager;
    private final ReplicaManager replicaMgr;
    private final Time time;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private long lastFetchTimeMs;
    private final Integer fetchSize;
    private final boolean isTruncationOnFetchSupported;
    private final boolean isOffsetForLeaderEpochSupported;

    public static Option<LogContext> $lessinit$greater$default$16() {
        return ClusterLinkFetcherThread$.MODULE$.$lessinit$greater$default$16();
    }

    public static ClusterLinkFetcherThread apply(String string, int n, KafkaConfig kafkaConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager clusterLinkFetcherManager, ClusterLinkDestConnectionManager clusterLinkDestConnectionManager, BrokerEndPoint brokerEndPoint, FailedPartitions failedPartitions, ReplicaManager replicaManager, ReplicaQuota replicaQuota, Metrics metrics, Time time, Option<TierStateFetcher> option) {
        return ClusterLinkFetcherThread$.MODULE$.apply(string, n, kafkaConfig, clusterLinkConfig, clusterLinkMetadata, clusterLinkFetcherManager, clusterLinkDestConnectionManager, brokerEndPoint, failedPartitions, replicaManager, replicaQuota, metrics, time, option);
    }

    public static Set<Errors> LinkErrors() {
        return ClusterLinkFetcherThread$.MODULE$.LinkErrors();
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private long lastFetchTimeMs() {
        return this.lastFetchTimeMs;
    }

    private void lastFetchTimeMs_$eq(long x$1) {
        this.lastFetchTimeMs = x$1;
    }

    @Override
    public Integer fetchSize() {
        return this.fetchSize;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public FetchRequest.Builder fetchRequestBuilder(FetchSessionHandler.FetchRequestData fetchData) {
        this.lastFetchTimeMs_$eq(this.time.milliseconds());
        return FetchRequest.Builder.forConsumer((int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
    }

    @Override
    public ListOffsetsRequest.Builder listOffsetRequestBuilder(Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> partitionTimestamps) {
        Seq topics = ((TraversableOnce)partitionTimestamps.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = (ListOffsetsRequestData.ListOffsetsPartition)x0$1._2();
            ListOffsetsRequestData.ListOffsetsTopic listOffsetsTopic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(listOffsetPartition));
            return listOffsetsTopic;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes((List)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean onOffsetTiered(TopicPartition topicPartition, Optional<Integer> requestEpoch) {
        this.fetcherManager.onPartitionLinkFailure(topicPartition, false, new StringBuilder(36).append("Unexpected tiered offset for ").append(topicPartition).append(" epoch ").append(requestEpoch).toString());
        return false;
    }

    @Override
    public boolean onPartitionFenced(TopicPartition tp, Optional<Integer> requestEpoch) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("onPartitionFenced ").append(tp).append(" : request metadata ").toString());
        this.clusterLinkMetadata.requestUpdate();
        return super.onPartitionFenced(tp, requestEpoch);
    }

    @Override
    public void handlePartitionsWithErrors(Map<TopicPartition, Errors> partitions, String methodName) {
        Map failed = (Map)partitions.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherThread.$anonfun$handlePartitionsWithErrors$1(x0$1)));
        failed.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClusterLinkFetcherThread.$anonfun$handlePartitionsWithErrors$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
        if (failed.nonEmpty() || partitions.values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherThread.$anonfun$handlePartitionsWithErrors$3(x$1)))) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Request metadata update because of errors ").append(partitions).toString());
            this.clusterLinkMetadata.requestUpdate();
        }
        super.handlePartitionsWithErrors(partitions, methodName);
    }

    @Override
    public void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        super.updateFetchOffsetAndMaybeMarkTruncationComplete(fetchOffsets);
        fetchOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkFetcherThread.$anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition tp, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        this.fetcherManager.updatePartitionFetchState(tp, new FetchState(this.lastFetchTimeMs(), partitionData.highWatermark()));
        this.clearPartitionLinkFailure(tp, fetchOffset);
        return super.processPartitionData(tp, fetchOffset, partitionData);
    }

    @Override
    public boolean shouldFollowerThrottle(boolean isQuotaExceeded, ReplicaQuota quota, PartitionFetchState fetchState, TopicPartition topicPartition) {
        return isQuotaExceeded && quota.isThrottled(topicPartition);
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return this.replicaMgr.onlinePartition(tp).exists((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherThread.$anonfun$isReadyForFetch$1(partition)));
    }

    @Override
    public void markFollowerReplicaThrottle() {
        this.replicaMgr.markClusterLinkReplicaThrottle();
    }

    public void clearPartitionLinkFailure(TopicPartition tp, long fetchOffset) {
        this.fetcherManager.clearPartitionLinkFailure(tp, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("New data fetched from ").append(tp).append(" offset ").append(fetchOffset).toString());
    }

    public static final /* synthetic */ boolean $anonfun$handlePartitionsWithErrors$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)x0$1._2();
        boolean bl = ClusterLinkFetcherThread$.MODULE$.LinkErrors().contains((Object)error);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$handlePartitionsWithErrors$2(ClusterLinkFetcherThread $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition tp = (TopicPartition)x0$2._1();
            Errors error = (Errors)x0$2._2();
            $this.fetcherManager.onPartitionLinkFailure(tp, true, error.message());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$handlePartitionsWithErrors$3(Errors x$1) {
        return x$1.exception() instanceof InvalidMetadataException;
    }

    public static final /* synthetic */ void $anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(ClusterLinkFetcherThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            if (((OffsetTruncationState)x0$1._2()).truncationCompleted()) {
                $this.fetcherManager.partition(tp).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.linkedLeaderOffsetsPending(false);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ boolean $anonfun$isReadyForFetch$1(Partition partition) {
        return !partition.isUnderMinIsr();
    }

    public ClusterLinkFetcherThread(String name, int fetcherId, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, Metrics metrics, Time time, Option<TierStateFetcher> tierStateFetcher, ClusterLinkNetworkClient clusterLinkClient, BlockingSend leaderEndpointBlockingSend, Option<LogContext> logContextOpt) {
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.fetcherManager = fetcherManager;
        this.replicaMgr = replicaMgr;
        this.time = time;
        this.clusterLinkClient = clusterLinkClient;
        super(name, fetcherId, sourceBroker, brokerConfig, failedPartitions, replicaMgr, metrics, time, quota, (Option<BlockingSend>)new Some((Object)leaderEndpointBlockingSend), logContextOpt, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()));
        this.maxWait = clusterLinkConfig.replicaFetchWaitMaxMs();
        this.minBytes = clusterLinkConfig.replicaFetchMinBytes();
        this.maxBytes = clusterLinkConfig.replicaFetchResponseMaxBytes();
        this.lastFetchTimeMs = -1L;
        this.fetchSize = clusterLinkConfig.replicaFetchMaxBytes();
        this.isTruncationOnFetchSupported = false;
        this.isOffsetForLeaderEpochSupported = true;
    }
}

