/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkMode$Destination$;
import kafka.server.link.LinkMode$Source$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.errors.InvalidRequestException;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!B\u0010!\u0003\u00039\u0003\u0002\u0003\u001f\u0001\u0005\u000b\u0007I\u0011A\u001f\t\u0011\u0011\u0003!\u0011!Q\u0001\nyB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u0002\u0011)\u0019!C\u0001\u0015\"Aa\u000b\u0001B\u0001B\u0003%1\n\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d\u0011\u0007A1A\u0005\u0012\rDaa\u001c\u0001!\u0002\u0013!\u0007b\u00029\u0001\u0005\u0004%\t\"\u001d\u0005\u0007u\u0002\u0001\u000b\u0011\u0002:\t\u000fm\u0004\u0001\u0019!C\u0005y\"9Q\u0010\u0001a\u0001\n\u0013q\bbBA\u0005\u0001\u0001\u0006KA\u0012\u0005\n\u0003'\u0001\u0001\u0019!C\t\u0003+A\u0011\"!\b\u0001\u0001\u0004%\t\"a\b\t\u0011\u0005\r\u0002\u0001)Q\u0005\u0003/A\u0011\"a\n\u0001\u0001\u0004%\t\"!\u0006\t\u0013\u0005%\u0002\u00011A\u0005\u0012\u0005-\u0002\u0002CA\u0018\u0001\u0001\u0006K!a\u0006\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!A\u0011q\u0007\u0001\u0005B\u0001\nI\u0004C\u0004\u0002P\u0001!\t%!\u000e\t\r\u0005E\u0003\u0001\"\u0011}\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!!\u0018\u0001\t#\t)\u0004C\u0004\u0002`\u0001!\t\"!\u000e\t\u000f\u0005\u0005\u0004A\"\u0005\u00026!9\u00111\r\u0001\u0007\u0012\u0005U\u0002bBA3\u0001\u0011E\u0011Q\u0007\u0002\u001d\u00072,8\u000f^3s\u0019&t7nQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0015\t\t#%\u0001\u0003mS:\\'BA\u0012%\u0003\u0019\u0019XM\u001d<fe*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001AcF\u000e\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u001adB\u0001\u00192\u001b\u0005\u0001\u0013B\u0001\u001a!\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\n\u0005Q*$!E\"p]:,7\r^5p]6\u000bg.Y4fe*\u0011!\u0007\t\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0011\nQ!\u001e;jYNL!a\u000f\u001d\u0003\u000f1{wmZ5oO\u0006AA.\u001b8l\t\u0006$\u0018-F\u0001?!\ty$)D\u0001A\u0015\t\tE%\u0001\u0002{W&\u00111\t\u0011\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006IA.\u001b8l\t\u0006$\u0018\rI\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005A:\u0015B\u0001%!\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\u0014Y>\u001c\u0017\r\u001c'pO&\u001c\u0017\r\\\"mkN$XM]\u000b\u0002\u0017B\u0011Aj\u0015\b\u0003\u001bF\u0003\"A\u0014\u0016\u000e\u0003=S!\u0001\u0015\u0014\u0002\rq\u0012xn\u001c;?\u0013\t\u0011&&\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*+\u0003QawnY1m\u0019><\u0017nY1m\u00072,8\u000f^3sA\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u0019Z\u0013\tQ\u0006E\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018A\u0002\u001fj]&$h\bF\u0003^=~\u0003\u0017\r\u0005\u00021\u0001!)Ah\u0002a\u0001}!)Qi\u0002a\u0001\r\")\u0011j\u0002a\u0001\u0017\")qk\u0002a\u00011\u00061A.\u001b8l\u0013\u0012,\u0012\u0001\u001a\t\u0003K6l\u0011A\u001a\u0006\u0003O\"\faaY8n[>t'BA\u0013j\u0015\tQ7.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0006\u0019qN]4\n\u000594'\u0001B+vS\u0012\fq\u0001\\5oW&#\u0007%A\bti\u0006$Xm\u00115b]\u001e,Gj\\2l+\u0005\u0011\bCA:y\u001b\u0005!(BA;w\u0003\u0011a\u0017M\\4\u000b\u0003]\fAA[1wC&\u0011\u0011\u0010\u001e\u0002\u0007\u001f\nTWm\u0019;\u0002!M$\u0018\r^3DQ\u0006tw-\u001a'pG.\u0004\u0013!E2mkN$XM\u001d'j].\u001cuN\u001c4jOV\ta)A\u000bdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e|F%Z9\u0015\u0007}\f)\u0001E\u0002*\u0003\u0003I1!a\u0001+\u0005\u0011)f.\u001b;\t\u0011\u0005\u001dQ\"!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003I\u0019G.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u0011)\u00079\ti\u0001E\u0002*\u0003\u001fI1!!\u0005+\u0005!1x\u000e\\1uS2,\u0017aF:pkJ\u001cWmQ8o]\u0016\u001cG/[8o\u000b:\f'\r\\3e+\t\t9\u0002E\u0002*\u00033I1!a\u0007+\u0005\u001d\u0011un\u001c7fC:\f1d]8ve\u000e,7i\u001c8oK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3`I\u0015\fHcA@\u0002\"!I\u0011q\u0001\t\u0002\u0002\u0003\u0007\u0011qC\u0001\u0019g>,(oY3D_:tWm\u0019;j_:,e.\u00192mK\u0012\u0004\u0003fA\t\u0002\u000e\u0005A\u0011n]!di&4X-\u0001\u0007jg\u0006\u001bG/\u001b<f?\u0012*\u0017\u000fF\u0002\u0000\u0003[A\u0011\"a\u0002\u0014\u0003\u0003\u0005\r!a\u0006\u0002\u0013%\u001c\u0018i\u0019;jm\u0016\u0004\u0003f\u0001\u000b\u0002\u000e\u000591\u000f^1siV\u0004H#A@\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0006\u007f\u0006m\u0012q\b\u0005\u0007\u0003{1\u0002\u0019\u0001$\u0002\u00139,woQ8oM&<\u0007bBA!-\u0001\u0007\u00111I\u0001\fkB$\u0017\r^3e\u0017\u0016L8\u000fE\u0003\u0002F\u0005-3*\u0004\u0002\u0002H)\u0019\u0011\u0011\n\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0005\u001d#aA*fi\u0006A1\u000f[;uI><h.A\u0007dkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\rY&t7n\u00117vgR,'o]\u000b\u0003\u0003/\u0002R!!\u0012\u0002Z-KA!a\u0017\u0002H\t\u00191+Z9\u0002?\u0015t7/\u001e:f%\u00164XM]:f\u0007>tg.Z2uS>t7/\u00128bE2,G-A\u000esKN,GOU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o\u0003\u0012l\u0017N\\\u0001\u001dGJ,\u0017\r^3SKZ,'o]3D_:tWm\u0019;j_:\fE-\\5o\u0003m\u0019Gn\\:f%\u00164XM]:f\u0007>tg.Z2uS>t\u0017\tZ7j]\u0006)R\u000f\u001d3bi\u0016\f5\r^5wK2Kgn[\"pk:$\b")
public abstract class ClusterLinkConnectionManager
implements ClusterLinkFactory.ConnectionManager,
Logging {
    private final ClusterLinkData linkData;
    private final String localLogicalCluster;
    private final ClusterLinkMetrics metrics;
    private final Uuid linkId;
    private final Object stateChangeLock;
    private volatile ClusterLinkConfig clusterLinkConfig;
    private volatile boolean sourceConnectionEnabled;
    private volatile boolean isActive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void onControllerChange(boolean isActive) {
        ClusterLinkFactory.ConnectionManager.onControllerChange$(this, isActive);
    }

    @Override
    public int persistentConnectionCount() {
        return ClusterLinkFactory.ConnectionManager.persistentConnectionCount$(this);
    }

    @Override
    public int reverseConnectionCount() {
        return ClusterLinkFactory.ConnectionManager.reverseConnectionCount$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public ClusterLinkData linkData() {
        return this.linkData;
    }

    @Override
    public String localLogicalCluster() {
        return this.localLogicalCluster;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Object stateChangeLock() {
        return this.stateChangeLock;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return this.clusterLinkConfig;
    }

    private void clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.clusterLinkConfig = x$1;
    }

    public boolean sourceConnectionEnabled() {
        return this.sourceConnectionEnabled;
    }

    public void sourceConnectionEnabled_$eq(boolean x$1) {
        this.sourceConnectionEnabled = x$1;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    @Override
    public void startup() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cluster link connection manager has started up.");
            this.updateActiveLinkCount();
            this.resetReverseConnectionAdmin();
            return;
        }
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Reconfiguring link connection manager with new configs updated=").append(updatedKeys).append(" newConfig=").append(newConfig.values()).toString());
            this.clusterLinkConfig_$eq(newConfig);
            if (Predef$.MODULE$.Boolean2boolean(newConfig.clusterLinkPaused())) {
                if (this.isActive()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down cluster link connection manager because link has been paused");
                }
                this.shutdown();
            } else {
                this.isActive_$eq(true);
                this.resetReverseConnectionAdmin();
            }
            this.updateActiveLinkCount();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed reconfiguration of cluster link");
            return;
        }
    }

    @Override
    public void shutdown() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.isActive_$eq(false);
            this.closeReverseConnectionAdmin();
            this.updateActiveLinkCount();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Shutdown of ClusterLinkConnectionManager with cluster link data ").append(this.linkData()).toString());
            return;
        }
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.clusterLinkConfig();
    }

    @Override
    public Seq<String> linkClusters() {
        return (Seq)new .colon.colon((Object)this.localLogicalCluster(), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.linkData().clusterId()).toSeq(), Seq$.MODULE$.canBuildFrom());
    }

    public void ensureReverseConnectionsEnabled() {
        if (!this.isActive() || Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused())) {
            throw new ClusterLinkPausedException(new StringBuilder(36).append("Cluster link ").append(this.linkData().linkName()).append(" is not active,").append(" paused=").append(this.clusterLinkConfig().clusterLinkPaused()).toString());
        }
        if (!this.sourceConnectionEnabled()) {
            throw new InvalidRequestException(new StringBuilder(59).append("Source connection origination for cluster link ").append(this.linkData().linkName()).append(" not").append(" enabled").toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void resetReverseConnectionAdmin() {
        var1_1 = this.stateChangeLock();
        synchronized (var1_1) {
            block7: {
                config = this.currentConfig();
                if (!this.isActive() || Predef$.MODULE$.Boolean2boolean(config.clusterLinkPaused())) ** GOTO lbl-1000
                v0 = config.linkMode();
                var3_3 = LinkMode$Destination$.MODULE$;
                if (v0 != null ? v0.equals(var3_3) == false : var3_3 != null) break block7;
                v1 = config.connectionMode();
                var4_4 = ConnectionMode$Inbound$.MODULE$;
                if (!(v1 == null ? var4_4 != null : v1.equals(var4_4) == false)) ** GOTO lbl-1000
            }
            v2 = config.linkMode();
            var5_5 = LinkMode$Source$.MODULE$;
            if (!(v2 != null ? v2.equals(var5_5) == false : var5_5 != null)) {
                v3 = config.connectionMode();
                var6_6 = ConnectionMode$Outbound$.MODULE$;
                ** if (v3 != null ? v3.equals((Object)var6_6) == false : var6_6 != null) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v4 = true;
                ** GOTO lbl23
            }
lbl-1000:
            // 3 sources

            {
                v4 = false;
            }
lbl23:
            // 2 sources

            this.sourceConnectionEnabled_$eq(v4);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resetReverseConnectionAdmin$1(kafka.server.link.ClusterLinkConnectionManager ), ()Ljava/lang/String;)((ClusterLinkConnectionManager)this));
            this.closeReverseConnectionAdmin();
            if (this.sourceConnectionEnabled()) {
                this.createReverseConnectionAdmin();
            }
            return;
        }
    }

    public abstract void createReverseConnectionAdmin();

    public abstract void closeReverseConnectionAdmin();

    public void updateActiveLinkCount() {
        boolean count = this.isActive();
        this.metrics.activeLinkCountSensor().record((double)count);
    }

    public static final /* synthetic */ String $anonfun$resetReverseConnectionAdmin$1(ClusterLinkConnectionManager $this) {
        return new StringBuilder(62).append("Recreating reverse connection clients sourceConnectionEnabled=").append($this.sourceConnectionEnabled()).toString();
    }

    public ClusterLinkConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, ClusterLinkMetrics metrics) {
        this.linkData = linkData;
        this.localLogicalCluster = localLogicalCluster;
        this.metrics = metrics;
        ClusterLinkFactory.ConnectionManager.$init$(this);
        Logging.$init$(this);
        this.linkId = new Uuid(linkData.linkId().getMostSignificantBits(), linkData.linkId().getLeastSignificantBits());
        this.stateChangeLock = new Object();
        this.clusterLinkConfig = initialConfig;
        this.sourceConnectionEnabled = false;
        this.isActive = true;
    }
}

