/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.cluster.PartitionStatus;
import kafka.controller.KafkaController;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkCheckReachability;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkPauseTopicMirrors;
import kafka.server.link.ClusterLinkPauseTopicMirrors$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls;
import kafka.server.link.ClusterLinkSyncOffsets;
import kafka.server.link.ClusterLinkSyncTopicsConfigs;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rmc\u0001B!C\u0001%C\u0001B\u0018\u0001\u0003\u0006\u0004%\ta\u0018\u0005\tM\u0002\u0011\t\u0011)A\u0005A\"Aq\r\u0001BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003j\u0011!i\u0007A!b\u0001\n\u0003q\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011M\u0004!\u00111A\u0005\nQD\u0001\u0002\u001f\u0001\u0003\u0002\u0004%I!\u001f\u0005\t\u007f\u0002\u0011\t\u0011)Q\u0005k\"Q\u0011\u0011\u0002\u0001\u0003\u0002\u0003\u0006I!a\u0003\t\u0015\u0005\u001d\u0002A!A!\u0002\u0013\tI\u0003\u0003\u0006\u00024\u0001\u0011)\u0019!C\u0001\u0003kA!\"!\u0012\u0001\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011)\t9\u0005\u0001BC\u0002\u0013\u0005\u0011\u0011\n\u0005\u000b\u0003#\u0002!\u0011!Q\u0001\n\u0005-\u0003BCA*\u0001\t\u0005\t\u0015!\u0003\u0002V!Q\u0011\u0011\r\u0001\u0003\u0006\u0004%\t!a\u0019\t\u0015\u0005m\u0004A!A!\u0002\u0013\t)\u0007C\u0004\u0002~\u0001!\t!a \t\u0017\u0005E\u0004\u00011AA\u0002\u0013%\u0011q\u0013\u0005\f\u0003C\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019\u000bC\u0006\u0002(\u0002\u0001\r\u0011!Q!\n\u0005e\u0005\"CAV\u0001\u0001\u0007I\u0011BAW\u0011%\t9\f\u0001a\u0001\n\u0013\tI\f\u0003\u0005\u0002>\u0002\u0001\u000b\u0015BAX\u0011%\ty\f\u0001a\u0001\n\u0013\t\t\rC\u0005\u0002L\u0002\u0001\r\u0011\"\u0003\u0002N\"A\u0011\u0011\u001b\u0001!B\u0013\t\u0019\rC\u0005\u0002T\u0002\u0001\r\u0011\"\u0003\u0002V\"I\u0011q\u001c\u0001A\u0002\u0013%\u0011\u0011\u001d\u0005\t\u0003K\u0004\u0001\u0015)\u0003\u0002X\"I\u0011q\u001d\u0001A\u0002\u0013%\u0011\u0011\u001e\u0005\n\u0003g\u0004\u0001\u0019!C\u0005\u0003kD\u0001\"!?\u0001A\u0003&\u00111\u001e\u0005\n\u0003w\u0004!\u0019!C\u0005\u0003{D\u0001B!\u0002\u0001A\u0003%\u0011q \u0005\n\u0005\u000f\u0001!\u0019!C\u0005\u0005\u0013A\u0001Ba\u0007\u0001A\u0003%!1\u0002\u0005\n\u0005;\u0001!\u0019!C\u0005\u0005?A\u0001Ba\u0012\u0001A\u0003%!\u0011\u0005\u0005\n\u0005\u0013\u0002!\u0019!C\u0001\u0005\u0017B\u0001Ba\u0015\u0001A\u0003%!Q\n\u0005\b\u0005+\u0002A\u0011\u0001B,\u0011\u001d\u0011I\u0006\u0001C\u0005\u0005/BqAa\u0017\u0001\t\u0003\u00119\u0006C\u0004\u0003^\u0001!IAa\u0016\t\u0011\t}\u0003\u0001\"\u0001C\u0005CB\u0001B!\u001d\u0001\t\u0003\u0011%1\u000f\u0005\t\u0005o\u0002A\u0011\u0001\"\u0003z!9!Q\u0010\u0001\u0005\u0002\t}\u0004b\u0002BA\u0001\u0011\u0005!1\u0011\u0005\b\u0005\u000b\u0003A\u0011\u0001BD\u0011\u001d\u0011I\t\u0001C\u0001\u0003[CqAa#\u0001\t\u0013\u0011i\tC\u0004\u0003\u0016\u0002!IAa\u0016\t\u000f\t]\u0005\u0001\"\u0003\u0003X!9!\u0011\u0014\u0001\u0005\u0002\tm\u0005b\u0002B^\u0001\u0011\u0005!Q\u0018\u0005\b\u0005\u0017\u0004A\u0011\u0002Bg\u0011\u001d\u00119\u0010\u0001C\u0005\u0005sDqaa\u0006\u0001\t\u0003\u0019I\u0002C\u0004\u0004<\u0001!Ia!\u0010\t\r\r\u001d\u0003\u0001\"\u0001u\u0011\u001d\u0019I\u0005\u0001C\u0001\u0007\u0017\u0012\u0001d\u00117vgR,'\u000fT5oW\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u0015\t\u0019E)\u0001\u0003mS:\\'BA#G\u0003\u0019\u0019XM\u001d<fe*\tq)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Q\u0005\u000b\u0017\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E+fB\u0001*T\u001b\u0005\u0011\u0015B\u0001+C\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\n\u0005Y;&!D\"mS\u0016tG/T1oC\u001e,'O\u0003\u0002U\u0005B\u0011\u0011\fX\u0007\u00025*\u00111LR\u0001\u0006kRLGn]\u0005\u0003;j\u0013q\u0001T8hO&tw-\u0001\u0005mS:\\G)\u0019;b+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2G\u0003\tQ8.\u0003\u0002fE\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005I1o\u00195fIVdWM]\u000b\u0002SB\u0011!K[\u0005\u0003W\n\u0013Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005A!p[\"mS\u0016tG/F\u0001p!\t\t\u0007/\u0003\u0002rE\ni1*\u00194lCj[7\t\\5f]R\f\u0011B_6DY&,g\u000e\u001e\u0011\u0002\r\r|gNZ5h+\u0005)\bC\u0001*w\u0013\t9(IA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\tQX\u0010\u0005\u0002Lw&\u0011A\u0010\u0014\u0002\u0005+:LG\u000fC\u0004\u007f\u0011\u0005\u0005\t\u0019A;\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011)\u0007%\t\u0019\u0001E\u0002L\u0003\u000bI1!a\u0002M\u0005!1x\u000e\\1uS2,\u0017AC1vi\"|'/\u001b>feB)1*!\u0004\u0002\u0012%\u0019\u0011q\u0002'\u0003\r=\u0003H/[8o!\u0011\t\u0019\"a\t\u000e\u0005\u0005U!\u0002BA\u0005\u0003/Q1!RA\r\u0015\r9\u00151\u0004\u0006\u0005\u0003;\ty\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003C\t1a\u001c:h\u0013\u0011\t)#!\u0006\u0003\u0015\u0005+H\u000f[8sSj,'/\u0001\u0006d_:$(o\u001c7mKJ\u0004B!a\u000b\u000205\u0011\u0011Q\u0006\u0006\u0004\u0003O1\u0015\u0002BA\u0019\u0003[\u0011qbS1gW\u0006\u001cuN\u001c;s_2dWM]\u0001\u0012C2$XM]\"p]\u001aLw\rU8mS\u000eLXCAA\u001c!\u0015Y\u0015QBA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"\u0002BA \u0003/\ta\u0001]8mS\u000eL\u0018\u0002BA\"\u0003{\u0011\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0003I\tG\u000e^3s\u0007>tg-[4Q_2L7-\u001f\u0011\u0002\u000f5,GO]5dgV\u0011\u00111\n\t\u0004%\u00065\u0013bAA(\u0005\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u00057j].\fE-\\5o\r\u0006\u001cGo\u001c:z!\u0019Y\u0015qK;\u0002\\%\u0019\u0011\u0011\f'\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001*\u0002^%\u0019\u0011q\f\"\u0003-\rcWo\u001d;fe2Kgn[!e[&t7\t\\5f]R\f\u0001\u0003Z3ti\u0006#W.\u001b8GC\u000e$xN]=\u0016\u0005\u0005\u0015\u0004#B&\u0002h\u0005-\u0014bAA5\u0019\nIa)\u001e8di&|g\u000e\r\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u0015\tG-\\5o\u0015\u0011\t)(!\u0007\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011PA8\u0005\u0015\tE-\\5o\u0003E!Wm\u001d;BI6LgNR1di>\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005\u0005\u00151QAC\u0003\u000f\u000bI)a#\u0002\u000e\u0006=\u0015\u0011SAJ\u0003+\u0003\"A\u0015\u0001\t\u000by\u001b\u0002\u0019\u00011\t\u000b\u001d\u001c\u0002\u0019A5\t\u000b5\u001c\u0002\u0019A8\t\u000bM\u001c\u0002\u0019A;\t\u000f\u0005%1\u00031\u0001\u0002\f!9\u0011qE\nA\u0002\u0005%\u0002bBA\u001a'\u0001\u0007\u0011q\u0007\u0005\b\u0003\u000f\u001a\u0002\u0019AA&\u0011\u001d\t\u0019f\u0005a\u0001\u0003+Bq!!\u0019\u0014\u0001\u0004\t)'\u0006\u0002\u0002\u001aB)1*!\u0004\u0002\u001cB!\u0011QNAO\u0013\u0011\ty*a\u001c\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006I\u0011\rZ7j]~#S-\u001d\u000b\u0004u\u0006\u0015\u0006\u0002\u0003@\u0016\u0003\u0003\u0005\r!!'\u0002\r\u0005$W.\u001b8!Q\r1\u00121A\u0001\u0014G2,8\u000f^3s\u0019&t7nU=oG\u0006\u001bGn]\u000b\u0003\u0003_\u0003RaSA\u0007\u0003c\u00032AUAZ\u0013\r\t)L\u0011\u0002\u0014\u00072,8\u000f^3s\u0019&t7nU=oG\u0006\u001bGn]\u0001\u0018G2,8\u000f^3s\u0019&t7nU=oG\u0006\u001bGn]0%KF$2A_A^\u0011!q\b$!AA\u0002\u0005=\u0016\u0001F2mkN$XM\u001d'j].\u001c\u0016P\\2BG2\u001c\b%\u0001\fdYV\u001cH/\u001a:MS:\\7+\u001f8d\u001f\u001a47/\u001a;t+\t\t\u0019\rE\u0003L\u0003\u001b\t)\rE\u0002S\u0003\u000fL1!!3C\u0005Y\u0019E.^:uKJd\u0015N\\6Ts:\u001cwJ\u001a4tKR\u001c\u0018AG2mkN$XM\u001d'j].\u001c\u0016P\\2PM\u001a\u001cX\r^:`I\u0015\fHc\u0001>\u0002P\"AapGA\u0001\u0002\u0004\t\u0019-A\fdYV\u001cH/\u001a:MS:\\7+\u001f8d\u001f\u001a47/\u001a;tA\u0005Y2\r\\;ti\u0016\u0014H*\u001b8l'ft7\rV8qS\u000e\u001cuN\u001c4jON,\"!a6\u0011\u000b-\u000bi!!7\u0011\u0007I\u000bY.C\u0002\u0002^\n\u0013Ad\u00117vgR,'\u000fT5oWNKhn\u0019+pa&\u001c7oQ8oM&<7/A\u0010dYV\u001cH/\u001a:MS:\\7+\u001f8d)>\u0004\u0018nY\"p]\u001aLwm]0%KF$2A_Ar\u0011!qh$!AA\u0002\u0005]\u0017\u0001H2mkN$XM\u001d'j].\u001c\u0016P\\2U_BL7mQ8oM&<7\u000fI\u0001\u001dG2,8\u000f^3s\u0019&t7n\u00115fG.\u0014V-Y2iC\nLG.\u001b;z+\t\tY\u000fE\u0003L\u0003\u001b\ti\u000fE\u0002S\u0003_L1!!=C\u0005q\u0019E.^:uKJd\u0015N\\6DQ\u0016\u001c7NU3bG\"\f'-\u001b7jif\f\u0001e\u00197vgR,'\u000fT5oW\u000eCWmY6SK\u0006\u001c\u0007.\u00192jY&$\u0018p\u0018\u0013fcR\u0019!0a>\t\u0011y\f\u0013\u0011!a\u0001\u0003W\fQd\u00197vgR,'\u000fT5oW\u000eCWmY6SK\u0006\u001c\u0007.\u00192jY&$\u0018\u0010I\u0001\u001dG2,8\u000f^3s\u0019&t7\u000eU1vg\u0016$v\u000e]5d\u001b&\u0014(o\u001c:t+\t\ty\u0010E\u0002S\u0005\u0003I1Aa\u0001C\u0005q\u0019E.^:uKJd\u0015N\\6QCV\u001cX\rV8qS\u000el\u0015N\u001d:peN\fQd\u00197vgR,'\u000fT5oWB\u000bWo]3U_BL7-T5se>\u00148\u000fI\u0001\u0005Y>\u001c7.\u0006\u0002\u0003\fA!!Q\u0002B\f\u001b\t\u0011yA\u0003\u0003\u0003\u0012\tM\u0011\u0001\u00027b]\u001eT!A!\u0006\u0002\t)\fg/Y\u0005\u0005\u00053\u0011yA\u0001\u0004PE*,7\r^\u0001\u0006Y>\u001c7\u000eI\u0001\u0007i>\u0004\u0018nY:\u0016\u0005\t\u0005\u0002C\u0002B\u0012\u0005[\u0011\t$\u0004\u0002\u0003&)!!q\u0005B\u0015\u0003\u001diW\u000f^1cY\u0016T1Aa\u000bM\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005_\u0011)CA\u0002TKR\u0004BAa\r\u0003B9!!Q\u0007B\u001f!\r\u00119\u0004T\u0007\u0003\u0005sQ1Aa\u000fI\u0003\u0019a$o\\8u}%\u0019!q\b'\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\u0019E!\u0012\u0003\rM#(/\u001b8h\u0015\r\u0011y\u0004T\u0001\bi>\u0004\u0018nY:!\u00035\tG-\\5o5.\u001cE.[3oiV\u0011!Q\n\t\u0004C\n=\u0013b\u0001B)E\ni\u0011\tZ7j]j[7\t\\5f]R\fa\"\u00193nS:T6n\u00117jK:$\b%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003i\f!c\u001d;beR,\b/Q2uSZ,G+Y:lg\u0006A1\u000f[;uI><h.A\ntQV$Hm\\<o\u0003\u000e$\u0018N^3UCN\\7/A\u0006sK\u000e|gNZ5hkJ,G#\u0002>\u0003d\t\u001d\u0004B\u0002B3_\u0001\u0007Q/A\u0005oK^\u001cuN\u001c4jO\"9!\u0011N\u0018A\u0002\t-\u0014aC;qI\u0006$X\rZ&fsN\u0004bA!\u001c\u0003p\tERB\u0001B\u0015\u0013\u0011\u0011yC!\u000b\u0002\u0013\u0005$G\rV8qS\u000e\u001cHc\u0001>\u0003v!9!\u0011\u000f\u0019A\u0002\t-\u0014\u0001\u0004:f[>4X\rV8qS\u000e\u001cHc\u0001>\u0003|!9!qO\u0019A\u0002\t-\u0014!C4fiR{\u0007/[2t+\t\u0011Y'\u0001\u0005hKR\fE-\\5o+\t\tY*A\u0007hKR\fU\u000f\u001e5pe&TXM]\u000b\u0003\u0003\u0017\tabZ3u'ft7-Q2m)\u0006\u001c8.\u0001\u0005jg\u0006\u001bG/\u001b<f)\t\u0011y\tE\u0002L\u0005#K1Aa%M\u0005\u001d\u0011un\u001c7fC:\f\u0011c\u0019:fCR,\u0017I\u001c3TKR\fE-\\5o\u0003)\u0019Gn\\:f\u0003\u0012l\u0017N\\\u0001\u0015M\u0016$8\r\u001b+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\r\tu%1\u0017B\\!\u0019\u0011yJ!+\u0003.6\u0011!\u0011\u0015\u0006\u0005\u0005G\u0013)+\u0001\u0006d_:\u001cWO\u001d:f]RTAAa*\u0003\u0014\u0005!Q\u000f^5m\u0013\u0011\u0011YK!)\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\rE\u0002L\u0005_K1A!-M\u0005\rIe\u000e\u001e\u0005\b\u0005kK\u0004\u0019\u0001B\u0019\u0003\u0015!x\u000e]5d\u0011\u001d\u0011I,\u000fa\u0001\u0005[\u000b\u0011\u0002^5nK>,H/T:\u0002\u001d\u0019,Go\u00195U_BL7-\u00138g_R1!q\u0018Bd\u0005\u0013\u0004bAa(\u0003*\n\u0005\u0007c\u0001*\u0003D&\u0019!Q\u0019\"\u0003)\rcWo\u001d;fe2Kgn\u001b+pa&\u001c\u0017J\u001c4p\u0011\u001d\u0011)L\u000fa\u0001\u0005cAqA!/;\u0001\u0004\u0011i+A\u000egKR\u001c\u0007\u000eV8qS\u000eLeNZ8IC:$G.\u001a*fgVdGo\u001d\u000b\nu\n='\u0011\u001bBt\u0005gDqA!.<\u0001\u0004\u0011\t\u0004C\u0004\u0003Tn\u0002\rA!6\u0002\u0019\r|gNZ5h\rV$XO]3\u0011\r\t]'Q\u001cBq\u001b\t\u0011IN\u0003\u0003\u0003\\\u0006e\u0011AB2p[6|g.\u0003\u0003\u0003`\ne'aC&bM.\fg)\u001e;ve\u0016\u0004B!!\u001c\u0003d&!!Q]A8\u0005\u0019\u0019uN\u001c4jO\"9!\u0011^\u001eA\u0002\t-\u0018!\u00053fg\u000e\u0014\u0018\u000e\u001d;j_:4U\u000f^;sKB1!q\u001bBo\u0005[\u0004B!!\u001c\u0003p&!!\u0011_A8\u0005A!v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0003vn\u0002\rAa0\u0002\rI,7/\u001e7u\u0003m1W\r^2i)>\u0004\u0018nY%oM><&/\u00199Fq\u000e,\u0007\u000f^5p]RA!1`B\u0007\u0007\u001f\u0019\u0019\u0002\u0005\u0003\u0003~\u000e\u001da\u0002\u0002B\u0000\u0007\u0007qAAa\u000e\u0004\u0002%\tQ*C\u0002\u0004\u00061\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0004\n\r-!!\u0003+ie><\u0018M\u00197f\u0015\r\u0019)\u0001\u0014\u0005\b\u0005kc\u0004\u0019\u0001B\u0019\u0011\u001d\u0019\t\u0002\u0010a\u0001\u0005w\f\u0011!\u001a\u0005\b\u0007+a\u0004\u0019\u0001B\u0019\u0003\u0019\t7\r^5p]\u0006i!/\u001a9mS\u000e\f7\u000b^1ukN$Baa\u0007\u00046AA!QNB\u000f\u0007C\u00199#\u0003\u0003\u0004 \t%\"aA'baB!!q[B\u0012\u0013\u0011\u0019)C!7\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B1!q\u0014BU\u0007S\u0001Baa\u000b\u000425\u00111Q\u0006\u0006\u0004\u0007_1\u0015aB2mkN$XM]\u0005\u0005\u0007g\u0019iCA\bQCJ$\u0018\u000e^5p]N#\u0018\r^;t\u0011\u001d\u00199$\u0010a\u0001\u0007s\t!\u0002]1si&$\u0018n\u001c8t!\u0019\u0011iGa\u001c\u0004\"\u0005QBo\u001c*fgVdG/T5se>\u0014\u0018J\u001c4p'R\u0014\u0018\u000e\u001d9fIR!1\u0011FB \u0011\u001d\u0011)P\u0010a\u0001\u0007\u0003\u0002B!!\u001c\u0004D%!1QIA8\u0005=\u0001\u0016M\u001d;ji&|gNU3tk2$\u0018!D2veJ,g\u000e^\"p]\u001aLw-A\u0011sKN$(/[2u-\u0006d\u0017\u000eZ1uKR{\u0007/[2D_:4\u0017n\u001a)pY&\u001c\u0017\u0010\u0006\u0004\u0004N\rU3q\u000b\t\u0005\u0007\u001f\u001a\t&\u0004\u0002\u0003&&!11\u000bBS\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0005k\u0003\u0005\u0019\u0001B\u0019\u0011\u001d\u0019I\u0006\u0011a\u0001\u0007\u001b\nQ\u0001\u001d:paN\u0004")
public class ClusterLinkClientManager
implements ClusterLinkFactory.ClientManager,
Logging {
    private final ClusterLinkData linkData;
    private final ClusterLinkScheduler scheduler;
    private final KafkaZkClient zkClient;
    private volatile ClusterLinkConfig config;
    private final Option<Authorizer> authorizer;
    private final KafkaController controller;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkMetrics metrics;
    private final Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory;
    private final Function0<Admin> destAdminFactory;
    private volatile Option<ConfluentAdmin> admin;
    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls;
    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets;
    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs;
    private Option<ClusterLinkCheckReachability> clusterLinkCheckReachability;
    private final ClusterLinkPauseTopicMirrors clusterLinkPauseTopicMirrors;
    private final Object lock;
    private final scala.collection.mutable.Set<String> topics;
    private final AdminZkClient adminZkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    public Function0<Admin> destAdminFactory() {
        return this.destAdminFactory;
    }

    private Option<ConfluentAdmin> admin() {
        return this.admin;
    }

    private void admin_$eq(Option<ConfluentAdmin> x$1) {
        this.admin = x$1;
    }

    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls() {
        return this.clusterLinkSyncAcls;
    }

    private void clusterLinkSyncAcls_$eq(Option<ClusterLinkSyncAcls> x$1) {
        this.clusterLinkSyncAcls = x$1;
    }

    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets() {
        return this.clusterLinkSyncOffsets;
    }

    private void clusterLinkSyncOffsets_$eq(Option<ClusterLinkSyncOffsets> x$1) {
        this.clusterLinkSyncOffsets = x$1;
    }

    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs() {
        return this.clusterLinkSyncTopicConfigs;
    }

    private void clusterLinkSyncTopicConfigs_$eq(Option<ClusterLinkSyncTopicsConfigs> x$1) {
        this.clusterLinkSyncTopicConfigs = x$1;
    }

    private Option<ClusterLinkCheckReachability> clusterLinkCheckReachability() {
        return this.clusterLinkCheckReachability;
    }

    private void clusterLinkCheckReachability_$eq(Option<ClusterLinkCheckReachability> x$1) {
        this.clusterLinkCheckReachability = x$1;
    }

    private ClusterLinkPauseTopicMirrors clusterLinkPauseTopicMirrors() {
        return this.clusterLinkPauseTopicMirrors;
    }

    private Object lock() {
        return this.lock;
    }

    private scala.collection.mutable.Set<String> topics() {
        return this.topics;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    @Override
    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Starting ClusterLinkClientManager with cluster link data ").append(this.linkData()).toString());
        if (this.isActive()) {
            this.createAndSetAdmin();
            this.startupActiveTasks();
        }
        this.clusterLinkPauseTopicMirrors().startup();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Startup of ClusterLinkClientManager with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void startupActiveTasks() {
        this.clusterLinkSyncOffsets_$eq((Option<ClusterLinkSyncOffsets>)new Some((Object)new ClusterLinkSyncOffsets(this, this.linkData(), this.controller, this.destAdminFactory(), this.metrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncOffsets().get()).startup();
        this.clusterLinkSyncTopicConfigs_$eq((Option<ClusterLinkSyncTopicsConfigs>)new Some((Object)new ClusterLinkSyncTopicsConfigs(this, Predef$.MODULE$.Integer2int(this.config().topicConfigSyncMs()), this.metrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncTopicConfigs().get()).startup();
        if (Predef$.MODULE$.Boolean2boolean(this.config().aclSyncEnable())) {
            this.authorizer.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("ACL migration is enabled but authorizer.class.name is not set. Please set authorizer.class.name to proceed with ACL migration.");
            });
            this.config().aclFilters().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("ACL migration is enabled but acl.filters is not set. Please set acl.filters to proceed with ACL migration.");
            });
            this.clusterLinkSyncAcls_$eq((Option<ClusterLinkSyncAcls>)new Some((Object)new ClusterLinkSyncAcls(this, this.controller, this.metrics())));
            ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncAcls().get()).startup();
        }
        this.clusterLinkCheckReachability_$eq((Option<ClusterLinkCheckReachability>)new Some((Object)new ClusterLinkCheckReachability(this, Predef$.MODULE$.Integer2int(this.config().reachabilityCheckMs()), this.metrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckReachability().get()).startup();
    }

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Shutting down ClusterLinkClientManager with cluster link data ").append(this.linkData()).toString());
        this.clusterLinkPauseTopicMirrors().shutdown();
        if (this.isActive()) {
            this.shutdownActiveTasks();
            this.closeAdmin();
            this.admin_$eq(null);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Shutdown of ClusterLinkClientManager with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void shutdownActiveTasks() {
        this.clusterLinkSyncTopicConfigs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncOffsets().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncAcls().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckReachability().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.lock();
        synchronized (object) {
            boolean oldActive = this.isActive();
            this.config_$eq(newConfig);
            boolean newActive = this.isActive();
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(oldActive, newActive);
            if (oldActive || newActive) {
                if (!oldActive && newActive) {
                    this.createAndSetAdmin();
                    this.startupActiveTasks();
                } else if (sp2 != null && oldActive && !newActive) {
                    this.shutdownActiveTasks();
                    this.closeAdmin();
                    this.admin_$eq((Option<ConfluentAdmin>)None$.MODULE$);
                } else if (sp2 != null && oldActive && newActive) {
                    if (updatedKeys.diff(ClusterLinkConfig$.MODULE$.ReplicationProps()).nonEmpty()) {
                        this.createAndSetAdmin();
                    }
                } else {
                    throw new MatchError((Object)sp2);
                }
            }
            return;
        }
    }

    @Override
    public void addTopics(Set<String> addTopics) {
        Object object = this.lock();
        synchronized (object) {
            addTopics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ClusterLinkClientManager.$anonfun$addTopics$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void removeTopics(Set<String> removeTopics) {
        Object object = this.lock();
        synchronized (object) {
            removeTopics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ClusterLinkClientManager.$anonfun$removeTopics$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Set<String> getTopics() {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Set set = this.topics().toSet();
            return set;
        }
    }

    public ConfluentAdmin getAdmin() {
        Option<ConfluentAdmin> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(this.linkData()).toString());
        }
        return (ConfluentAdmin)currentAdmin.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.linkData().linkName()).append(" is paused").toString());
        });
    }

    public Option<Authorizer> getAuthorizer() {
        return this.authorizer;
    }

    public Option<ClusterLinkSyncAcls> getSyncAclTask() {
        return this.clusterLinkSyncAcls();
    }

    private boolean isActive() {
        return !Predef$.MODULE$.Boolean2boolean(this.config().clusterLinkPaused());
    }

    private void createAndSetAdmin() {
        this.closeAdmin();
        this.admin_$eq((Option<ConfluentAdmin>)new Some((Object)((ClusterLinkAdminClient)this.linkAdminFactory.apply((Object)this.config())).admin()));
    }

    private void closeAdmin() {
        Option<ConfluentAdmin> curAdmin = this.admin();
        if (curAdmin != null) {
            curAdmin.foreach((Function1 & Serializable & scala.Serializable)a -> {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> a.close(Duration.ZERO), this, CoreUtils$.MODULE$.swallow$default$3());
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<Object> fetchTopicPartitions(String topic, int timeoutMs) {
        void var3_3;
        CompletableFuture result = new CompletableFuture();
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), describeTopicsOptions);
            this.scheduler().scheduleWhenComplete("ClusterLinkFetchTopicPartitions", describeTopicsResult.all(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> result.complete(BoxesRunTime.boxToInteger((int)((TopicDescription)((KafkaFuture)describeTopicsResult.values().get(topic)).get()).partitions().size())));
        }
        catch (Throwable e) {
            result.completeExceptionally(this.fetchTopicInfoWrapException(topic, e, "fetching partitions"));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<ClusterLinkTopicInfo> fetchTopicInfo(String topic, int timeoutMs) {
        void var3_3;
        CompletableFuture result = new CompletableFuture();
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs)).includeAuthorizedOperations(true);
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), describeTopicsOptions);
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            DescribeConfigsOptions describeConfigsOptions = new DescribeConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeConfigsResult describeConfigsResult = this.getAdmin().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava(), describeConfigsOptions);
            KafkaFuture futures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{describeTopicsResult.all(), describeConfigsResult.all()});
            this.scheduler().scheduleWhenComplete("FetchTopicInfo", futures, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fetchTopicInfoHandleResults(topic, (KafkaFuture<Config>)((KafkaFuture)describeConfigsResult.values().get(resource)), (KafkaFuture<TopicDescription>)((KafkaFuture)describeTopicsResult.values().get(topic)), result));
        }
        catch (Throwable e) {
            result.completeExceptionally(this.fetchTopicInfoWrapException(topic, e, "preparing client to fetch information"));
        }
        return var3_3;
    }

    private void fetchTopicInfoHandleResults(String topic, KafkaFuture<Config> configFuture, KafkaFuture<TopicDescription> descriptionFuture, CompletableFuture<ClusterLinkTopicInfo> result) {
        try {
            TopicDescription description = (TopicDescription)this.maybeThrowException$1(topic, descriptionFuture, "fetching description");
            Config config = (Config)this.maybeThrowException$1(topic, configFuture, "fetching configuration");
            result.complete(new ClusterLinkTopicInfo(description, config));
            return;
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
            return;
        }
    }

    private Throwable fetchTopicInfoWrapException(String topic, Throwable e, String action) {
        ApiError error = ApiError.fromThrowable((Throwable)e);
        return error.error().exception(new StringBuilder(42).append("While ").append(action).append(" for topic '").append(topic).append("' over cluster link '").append(this.linkData().linkName()).append("': ").append(error.messageWithFallback()).toString());
    }

    @Override
    public Map<TopicPartition, CompletableFuture<PartitionStatus>> replicaStatus(Set<TopicPartition> partitions) {
        ReplicaStatusOptions options = new ReplicaStatusOptions().includeLinkedReplicas(false);
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.getAdmin().replicaStatus((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(partitions).asJava(), options).partitionResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            KafkaFuture future = (KafkaFuture)x0$1._2();
            CompletableFuture completableFuture = new CompletableFuture();
            future.whenComplete((res, ex) -> {
                Option option = Option$.MODULE$.apply(ex);
                if (option instanceof Some) {
                    Throwable e = (Throwable)((Some)option).value();
                    completableFuture.completeExceptionally(e);
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    completableFuture.complete(this.toResultMirrorInfoStripped((PartitionResult)res));
                    return;
                }
                throw new MatchError((Object)option);
            });
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), completableFuture);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private PartitionStatus toResultMirrorInfoStripped(PartitionResult result) {
        Seq replicas = ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)rs -> new ReplicaStatus(rs.brokerId(), rs.isLeader(), rs.isObserver(), rs.isIsrEligible(), rs.isInIsr(), rs.isCaughtUp(), rs.logStartOffset(), rs.logEndOffset(), rs.lastCaughtUpTimeMs(), rs.lastFetchTimeMs(), Optional.of(this.linkData().linkName()), Optional.empty()), Buffer$.MODULE$.canBuildFrom())).toSeq();
        return new PartitionStatus(result.leaderId(), result.leaderEpoch().getAsInt(), (Seq<ReplicaStatus>)replicas);
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.config();
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props) {
        Properties properties;
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            Properties properties2;
            AlterConfigPolicy policy = (AlterConfigPolicy)((Some)option).value();
            java.util.Map configs = Utils.propsToStringMap((Properties)props);
            if (policy instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)policy;
                java.util.Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                properties2 = Utils.mkProperties(newConfigs);
            } else {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                policy.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
                properties2 = props;
            }
            properties = properties2;
        } else if (None$.MODULE$.equals(option)) {
            properties = props;
        } else {
            throw new MatchError(option);
        }
        return properties;
    }

    public static final /* synthetic */ void $anonfun$addTopics$1(ClusterLinkClientManager $this, String topic) {
        if ($this.topics().add((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Added topic '").append(topic).append("' for cluster link data '").append($this.linkData()).append("'").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$removeTopics$1(ClusterLinkClientManager $this, String topic) {
        if ($this.topics().remove((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Removed topic '").append(topic).append("' for cluster link data '").append($this.linkData()).append("''").toString());
        }
    }

    private final Object maybeThrowException$1(String topic, KafkaFuture future, String action) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw this.fetchTopicInfoWrapException(topic, e.getCause(), action);
        }
        catch (Throwable e) {
            throw this.fetchTopicInfoWrapException(topic, e, action);
        }
    }

    public ClusterLinkClientManager(ClusterLinkData linkData, ClusterLinkScheduler scheduler, KafkaZkClient zkClient, ClusterLinkConfig config, Option<Authorizer> authorizer, KafkaController controller, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkMetrics metrics, Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory, Function0<Admin> destAdminFactory) {
        this.linkData = linkData;
        this.scheduler = scheduler;
        this.zkClient = zkClient;
        this.config = config;
        this.authorizer = authorizer;
        this.controller = controller;
        this.alterConfigPolicy = alterConfigPolicy;
        this.metrics = metrics;
        this.linkAdminFactory = linkAdminFactory;
        this.destAdminFactory = destAdminFactory;
        Logging.$init$(this);
        this.clusterLinkSyncAcls = None$.MODULE$;
        this.clusterLinkSyncOffsets = None$.MODULE$;
        this.clusterLinkSyncTopicConfigs = None$.MODULE$;
        this.clusterLinkCheckReachability = None$.MODULE$;
        this.clusterLinkPauseTopicMirrors = new ClusterLinkPauseTopicMirrors(linkData.linkId(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.isActive(), scheduler, controller, destAdminFactory, ClusterLinkPauseTopicMirrors$.MODULE$.$lessinit$greater$default$6(), ClusterLinkPauseTopicMirrors$.MODULE$.$lessinit$greater$default$7(), ClusterLinkPauseTopicMirrors$.MODULE$.$lessinit$greater$default$8());
        this.lock = new Object();
        this.topics = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.adminZkClient = new AdminZkClient(zkClient);
    }
}

