/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.KafkaFuture;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}3A\u0001D\u0007\u0001)!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0005\"\u0001\t\u0005\t\u0015!\u0003#Q!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u00045\u0001\t\u0007I\u0011B\u001b\t\rY\u0002\u0001\u0015!\u0003#\u0011\u001d9\u0004\u00011A\u0005\nUBq\u0001\u000f\u0001A\u0002\u0013%\u0011\b\u0003\u0004@\u0001\u0001\u0006KA\t\u0005\u0006\u0001\u0002!\t&\u0011\u0005\u0006\u000b\u0002!IA\u0012\u0002\u001d\u00072,8\u000f^3s\u0019&t7n\u00115fG.\u0014V-Y2iC\nLG.\u001b;z\u0015\tqq\"\u0001\u0003mS:\\'B\u0001\t\u0012\u0003\u0019\u0019XM\u001d<fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001b\u001d\t9\u0002$D\u0001\u000e\u0013\tIR\"\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u00037q\u0011A\u0002U3sS>$\u0017n\u0019+bg.T!!G\u0007\u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s!\t9r$\u0003\u0002!\u001b\tA2\t\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u001dMLhnY%oi\u0016\u0014h/\u00197NgB\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t\u0019\u0011J\u001c;\n\u0005%R\u0012!\u0005:fg\u000eDW\rZ;mK\u0012+G.Y=Ng\u00069Q.\u001a;sS\u000e\u001c\bCA\f-\u0013\tiSB\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u00031cI\u001a\u0004CA\f\u0001\u0011\u0015iB\u00011\u0001\u001f\u0011\u0015\tC\u00011\u0001#\u0011\u0015QC\u00011\u0001,\u0003a\tE-\\5o\u00072LWM\u001c;DC2dG+[7f_V$Xj]\u000b\u0002E\u0005I\u0012\tZ7j]\u000ec\u0017.\u001a8u\u0007\u0006dG\u000eV5nK>,H/T:!\u0003%1\u0017-\u001b7D_VtG/A\u0007gC&d7i\\;oi~#S-\u001d\u000b\u0003uu\u0002\"aI\u001e\n\u0005q\"#\u0001B+oSRDqA\u0010\u0005\u0002\u0002\u0003\u0007!%A\u0002yIE\n!BZ1jY\u000e{WO\u001c;!\u0003\r\u0011XO\u001c\u000b\u0002\u0005B\u00111eQ\u0005\u0003\t\u0012\u0012qAQ8pY\u0016\fg.\u0001\niC:$G.\u001a+pa&\u001c7OU3tk2$HC\u0001\"H\u0011\u0015A5\u00021\u0001J\u0003\u0019\u0011Xm];miB\u0019!J\u0015+\u000e\u0003-S!\u0001T'\u0002\r\r|W.\\8o\u0015\t\u0011bJ\u0003\u0002P!\u00061\u0011\r]1dQ\u0016T\u0011!U\u0001\u0004_J<\u0017BA*L\u0005-Y\u0015MZ6b\rV$XO]3\u0011\u0005UcfB\u0001,[!\t9F%D\u0001Y\u0015\tI6#\u0001\u0004=e>|GOP\u0005\u00037\u0012\na\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111\f\n")
public class ClusterLinkCheckReachability
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkClientManager clientManager;
    private final ClusterLinkMetrics metrics;
    private final int AdminClientCallTimeoutMs;
    private int failCount;

    private int AdminClientCallTimeoutMs() {
        return this.AdminClientCallTimeoutMs;
    }

    private int failCount() {
        return this.failCount;
    }

    private void failCount_$eq(int x$1) {
        this.failCount = x$1;
    }

    @Override
    public boolean run() {
        DescribeClusterResult describeClusterResult = this.clientManager.getAdmin().describeCluster(new DescribeClusterOptions().timeoutMs(Predef$.MODULE$.int2Integer(this.AdminClientCallTimeoutMs())));
        this.scheduleWhenComplete(describeClusterResult.clusterId(), (Function0<Object>)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> this.handleTopicsResult((KafkaFuture<String>)describeClusterResult.clusterId()));
        return false;
    }

    private boolean handleTopicsResult(KafkaFuture<String> result) {
        try {
            result.get();
        }
        catch (Exception e) {
            this.metrics.linkSourceUnreachableSensor().record();
            this.failCount_$eq(this.failCount() + 1);
            this.warn((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(38).append("Link ").append($this.metrics.linkName()).append(" reachability check failed ").append(this.failCount()).append(" times").toString(), (Function0<Throwable>)(Function0 & java.io.Serializable & Serializable)() -> e);
        }
        return true;
    }

    public ClusterLinkCheckReachability(ClusterLinkClientManager clientManager, int syncIntervalMs, ClusterLinkMetrics metrics) {
        this.clientManager = clientManager;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkCheckReachability", syncIntervalMs);
        this.AdminClientCallTimeoutMs = 3000;
        this.failCount = 0;
    }
}

