/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkAdminClient$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkManager$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$PendingStoppedMirror$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkMode;
import kafka.server.link.LinkMode$Destination$;
import kafka.server.link.LinkMode$Source$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.TopicMirrorDescription;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkInUseException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001B\u0010!\u0001\u001dB\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005}!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003F\u0011!\t\u0006A!b\u0001\n\u0003\u0011\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011i\u0003!Q1A\u0005\u0002mC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"AQ\u000e\u0001B\u0001B\u0003%a\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005\r\u0001\u0001)A\u0005}\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!a-\u0001\t\u0003\t)\fC\u0004\u0002H\u0002!I!!3\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9\u00111\u001c\u0001\u0005\n\u0005u\u0007bBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013AqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003l\u0001!IA!\u001c\t\u000f\t\r\u0005\u0001\"\u0003\u0003\u0006\"9!1\u0014\u0001\u0005\n\tu\u0005b\u0002BZ\u0001\u0011%!Q\u0017\u0005\b\u0005o\u0003A\u0011\u0002B]\u0005]\u0019E.^:uKJd\u0015N\\6BI6Lg.T1oC\u001e,'O\u0003\u0002\"E\u0005!A.\u001b8l\u0015\t\u0019C%\u0001\u0004tKJ4XM\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001)]Y\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0007CA\u00184\u001d\t\u0001\u0014'D\u0001!\u0013\t\u0011\u0004%\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL\u0018B\u0001\u001b6\u00051\tE-\\5o\u001b\u0006t\u0017mZ3s\u0015\t\u0011\u0004\u0005\u0005\u00028u5\t\u0001H\u0003\u0002:I\u0005)Q\u000f^5mg&\u00111\b\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOV\ta\b\u0005\u0002@\u00016\t!%\u0003\u0002BE\tY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0002\\8dC2\u001cE.^:uKJLE-F\u0001F!\t1UJ\u0004\u0002H\u0017B\u0011\u0001JK\u0007\u0002\u0013*\u0011!JJ\u0001\u0007yI|w\u000e\u001e \n\u00051S\u0013A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001\u0014\u0016\u0002\u001f1|7-\u00197DYV\u001cH/\u001a:JI\u0002\n\u0001B_6DY&,g\u000e^\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a\u000bJ\u0001\u0003u.L!\u0001W+\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%Q8n\u00117jK:$\b%\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014X#\u0001/\u0011\u0005Aj\u0016B\u00010!\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002'\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\u0011\u0002\u000f5,GO]5dgB\u0011!m[\u0007\u0002G*\u0011\u0001\r\u001a\u0006\u0003K\u001a\faaY8n[>t'BA\u0013h\u0015\tA\u0017.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0006\u0019qN]4\n\u00051\u001c'aB'fiJL7m]\u0001\u0005i&lW\r\u0005\u0002pc6\t\u0001O\u0003\u0002:I&\u0011!\u000f\u001d\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\bkZ<\b0\u001f>|!\t\u0001\u0004\u0001C\u0003=\u0017\u0001\u0007a\bC\u0003D\u0017\u0001\u0007Q\tC\u0003R\u0017\u0001\u00071\u000bC\u0003[\u0017\u0001\u0007A\fC\u0003a\u0017\u0001\u0007\u0011\rC\u0003n\u0017\u0001\u0007a.A\u0005qkJ<\u0017\r^8ssV\ta\u0010\u0005\u0002@\u007f&\u0019\u0011\u0011\u0001\u0012\u0003-\u0011+G.Y=fI\u001a+H/\u001e:f!V\u0014x-\u0019;pef\f!\u0002];sO\u0006$xN]=!\u0003!\u0019\b.\u001e;e_^tGCAA\u0005!\rI\u00131B\u0005\u0004\u0003\u001bQ#\u0001B+oSR\f\u0011c\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8l)9\t\u0019\"a\r\u0002H\u0005E\u0013\u0011MA6\u0003_\u0002b!!\u0006\u0002$\u0005\u001dRBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u001e\u0005}\u0011\u0001B;uS2T!!!\t\u0002\t)\fg/Y\u0005\u0005\u0003K\t9BA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0005\u0003[\ty\"\u0001\u0003mC:<\u0017\u0002BA\u0019\u0003W\u0011AAV8jI\"9\u0011QG\bA\u0002\u0005]\u0012A\u00048fo\u000ecWo\u001d;fe2Kgn\u001b\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0015\tG-\\5o\u0015\r\t\tEZ\u0001\bG2LWM\u001c;t\u0013\u0011\t)%a\u000f\u0003\u001d9+wo\u00117vgR,'\u000fT5oW\"9\u0011\u0011J\bA\u0002\u0005-\u0013\u0001\u0004;f]\u0006tG\u000f\u0015:fM&D\b\u0003B\u0015\u0002N\u0015K1!a\u0014+\u0005\u0019y\u0005\u000f^5p]\"9\u00111K\bA\u0002\u0005U\u0013a\u0005:fcV,7\u000f\u001e'jgR,g.\u001a:OC6,\u0007\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005mC-A\u0004oKR<xN]6\n\t\u0005}\u0013\u0011\f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0003Gz\u0001\u0019AA3\u000311\u0018\r\\5eCR,wJ\u001c7z!\rI\u0013qM\u0005\u0004\u0003SR#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003[z\u0001\u0019AA3\u000311\u0018\r\\5eCR,G*\u001b8l\u0011\u001d\t\th\u0004a\u0001\u0003g\n\u0011\u0002^5nK>,H/T:\u0011\u0007%\n)(C\u0002\u0002x)\u00121!\u00138u\u0003Aa\u0017n\u001d;DYV\u001cH/\u001a:MS:\\7\u000f\u0006\u0004\u0002~\u0005U\u0015\u0011\u0015\t\u0007\u0003\u007f\nI)a$\u000f\t\u0005\u0005\u0015Q\u0011\b\u0004\u0011\u0006\r\u0015\"A\u0016\n\u0007\u0005\u001d%&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0015Q\u0012\u0002\u0004'\u0016\f(bAADUA!\u0011\u0011HAI\u0013\u0011\t\u0019*a\u000f\u0003%\rcWo\u001d;fe2Kgn\u001b'jgRLgn\u001a\u0005\b\u0003/\u0003\u0002\u0019AAM\u0003%a\u0017N\\6OC6,7\u000fE\u0003*\u0003\u001b\nY\n\u0005\u0003G\u0003;+\u0015bAAP\u001f\n\u00191+\u001a;\t\u000f\u0005\r\u0006\u00031\u0001\u0002f\u0005i\u0011N\\2mk\u0012,Gk\u001c9jGN\f\u0011\u0003Z3mKR,7\t\\;ti\u0016\u0014H*\u001b8l)!\tI!!+\u0002.\u0006=\u0006BBAV#\u0001\u0007Q)\u0001\u0005mS:\\g*Y7f\u0011\u001d\t\u0019'\u0005a\u0001\u0003KBq!!-\u0012\u0001\u0004\t)'A\u0003g_J\u001cW-A\u0006bYR,'/T5se>\u0014H\u0003CA\n\u0003o\u000bY,!2\t\r\u0005e&\u00031\u0001F\u0003\u0015!x\u000e]5d\u0011\u001d\tiL\u0005a\u0001\u0003\u007f\u000b!a\u001c9\u0011\t\u0005e\u0012\u0011Y\u0005\u0005\u0003\u0007\fYDA\u0007BYR,'/T5se>\u0014x\n\u001d\u0005\b\u0003G\u0012\u0002\u0019AA3\u0003=\u0019Ho\u001c9U_BL7-T5se>\u0014H\u0003CA\n\u0003\u0017\fi-!5\t\r\u0005e6\u00031\u0001F\u0011\u001d\tym\u0005a\u0001\u0003K\n1b]=oG\"\u0014xN\\5{K\"9\u00111M\nA\u0002\u0005\u0015\u0014\u0001E2mK\u0006\u0014Hk\u001c9jG6K'O]8s)\u0019\t\u0019\"a6\u0002Z\"1\u0011\u0011\u0018\u000bA\u0002\u0015Cq!a\u0019\u0015\u0001\u0004\t)'\u0001\tqCV\u001cX\rV8qS\u000el\u0015N\u001d:peRQ\u00111CAp\u0003C\f)/!;\t\r\u0005eV\u00031\u0001F\u0011\u001d\t\u0019/\u0006a\u0001\u0003K\na!\u001a8bE2,\u0007bBAt+\u0001\u0007\u0011QM\u0001\fSNd\u0015N\\6MKZ,G\u000eC\u0004\u0002dU\u0001\r!!\u001a\u0002\u00171L7\u000f^'jeJ|'o\u001d\u000b\u0007\u0003_\f)0a>\u0011\u000b\u0005}\u0014\u0011_#\n\t\u0005M\u0018Q\u0012\u0002\t\u0013R,'/\u00192mK\"9\u00111\u0016\fA\u0002\u0005-\u0003bBA}-\u0001\u0007\u0011QM\u0001\u000fS:\u001cG.\u001e3f'R|\u0007\u000f]3e\u00039!Wm]2sS\n,W*\u001b:s_J$B!a@\u0003\u0006A!\u0011\u0011\bB\u0001\u0013\u0011\u0011\u0019!a\u000f\u0003-Q{\u0007/[2NSJ\u0014xN\u001d#fg\u000e\u0014\u0018\u000e\u001d;j_:Da!!/\u0018\u0001\u0004)\u0015a\u00064j]&\u001c\bn\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8l)A\tIAa\u0003\u0003\u000e\tm!q\u0004B\u0011\u0005W\u0011)\u0004\u0003\u0004\u0002,b\u0001\r!\u0012\u0005\b\u0005\u001fA\u0002\u0019\u0001B\t\u0003\u0019a\u0017N\\6JIB)\u0011&!\u0014\u0003\u0014A!!Q\u0003B\f\u001b\t\tY\"\u0003\u0003\u0003\u001a\u0005m!\u0001B+V\u0013\u0012CqA!\b\u0019\u0001\u0004\tY%A\u0007mS:\\7\t\\;ti\u0016\u0014\u0018\n\u001a\u0005\b\u0003\u0013B\u0002\u0019AA&\u0011\u001d\u0011\u0019\u0003\u0007a\u0001\u0005K\t!\u0002\\5oW\u000e{gNZ5h!\r\u0001$qE\u0005\u0004\u0005S\u0001#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\"9!Q\u0006\rA\u0002\t=\u0012a\u00049feNL7\u000f^3oiB\u0013x\u000e]:\u0011\t\tU!\u0011G\u0005\u0005\u0005g\tYB\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a\u0019\u0019\u0001\u0004\t)'A\bxSRD'+Z7pi\u0016\fE-\\5o+\u0011\u0011YDa\u0011\u0015\u0011\tu\"Q\rB4\u0005S\"BAa\u0010\u0003VA!!\u0011\tB\"\u0019\u0001!qA!\u0012\u001a\u0005\u0004\u00119EA\u0001U#\u0011\u0011IEa\u0014\u0011\u0007%\u0012Y%C\u0002\u0003N)\u0012qAT8uQ&tw\rE\u0002*\u0005#J1Aa\u0015+\u0005\r\te.\u001f\u0005\b\u0005/J\u0002\u0019\u0001B-\u0003\u00111WO\\2\u0011\u000f%\u0012YFa\u0018\u0003@%\u0019!Q\f\u0016\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u001d\u0005CJAAa\u0019\u0002<\tq1i\u001c8gYV,g\u000e^!e[&t\u0007BBAV3\u0001\u0007Q\tC\u0004\u0003$e\u0001\rA!\n\t\u000f\u0005%\u0013\u00041\u0001\u0002L\u0005qb/\u00197jI\u0006$X\rR3ti&t\u0017\r^5p]\u000ecWo\u001d;fe2Kgn\u001b\u000b\r\u0003\u0017\u0012yGa\u001e\u0003|\t}$\u0011\u0011\u0005\b\u0003{Q\u0002\u0019\u0001B9!\u0011\tIDa\u001d\n\t\tU\u00141\b\u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\b\u0005sR\u0002\u0019AA&\u0003E)\u0007\u0010]3di\u0016$7\t\\;ti\u0016\u0014\u0018\n\u001a\u0005\b\u0005{R\u0002\u0019\u0001B\u0018\u0003\u0015\u0001(o\u001c9t\u0011\u001d\t\tH\u0007a\u0001\u0003gBa!a+\u001b\u0001\u0004)\u0015!\u0007<bY&$\u0017\r^3T_V\u00148-Z\"mkN$XM\u001d'j].$BBa\"\u0003\u000e\nE%1\u0013BK\u00053\u0003b!\u000bBE\u0005')\u0015b\u0001BFU\t1A+\u001e9mKJBqAa$\u001c\u0001\u0004\u0011y&A\u0006sK6|G/Z!e[&t\u0007BBAV7\u0001\u0007Q\tC\u0004\u0002Jm\u0001\r!a\u0013\t\u000f\t]5\u00041\u0001\u0002L\u0005)R\r\u001f9fGR,G\rR3ti\u000ecWo\u001d;fe&#\u0007bBA97\u0001\u0007\u00111O\u0001\u0013O\u0016$\u0018\t\u001c7NSJ\u0014xN\u001d+pa&\u001c7\u000f\u0006\u0003\u0003 \nE\u0006c\u0002BQ\u0005O+%1V\u0007\u0003\u0005GS1A!*+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005S\u0013\u0019KA\u0002NCB\u00042\u0001\rBW\u0013\r\u0011y\u000b\t\u0002\u0016\u00072,8\u000f^3s\u0019&t7\u000eV8qS\u000e\u001cF/\u0019;f\u0011\u001d\tI\u0010\ba\u0001\u0003K\nqcZ3u\u00032dW*\u001b:s_J$v\u000e]5dg&sWk]3\u0016\u0005\t}\u0015\u0001D1qS\u0016C8-\u001a9uS>tG\u0003\u0002B^\u0005\u000f\u0004BA!0\u0003D6\u0011!q\u0018\u0006\u0004\u0005\u0003$\u0017AB3se>\u00148/\u0003\u0003\u0003F\n}&\u0001D!qS\u0016C8-\u001a9uS>t\u0007b\u0002Be=\u0001\u0007!1Z\u0001\ni\"\u0014xn^1cY\u0016\u0004B!a \u0003N&!!qZAG\u0005%!\u0006N]8xC\ndW\r")
public class ClusterLinkAdminManager
implements ClusterLinkFactory.AdminManager,
Logging {
    private final KafkaConfig config;
    private final String localClusterId;
    private final KafkaZkClient zkClient;
    private final ClusterLinkManager clusterLinkManager;
    private final Metrics metrics;
    private final Time time;
    private final DelayedFuturePurgatory purgatory;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    @Override
    public DelayedFuturePurgatory purgatory() {
        return this.purgatory;
    }

    public void shutdown() {
        this.purgatory().shutdown();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompletableFuture<Void> createClusterLink(NewClusterLink newClusterLink, Option<String> tenantPrefix, ListenerName requestListenerName, boolean validateOnly, boolean validateLink, int timeoutMs) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Attempting to create cluster link with link-name ").append(newClusterLink.linkName()).append(" with validateOnly=").append(validateOnly).append(" and validateLink=").append(validateLink).toString());
        if (this.config().interBrokerProtocolVersion().$less$eq(KAFKA_2_3_IV1$.MODULE$)) {
            throw new InvalidClusterLinkException(new StringBuilder(68).append("Cluster linking is not supported with inter-broker protocol version ").append(this.config().interBrokerProtocolVersion()).toString());
        }
        String linkName = newClusterLink.linkName();
        ClusterLinkUtils$.MODULE$.validateLinkName(linkName);
        this.clusterLinkManager().ensureLinkNameDoesntExist(linkName);
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq((Map<String, Object>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(newClusterLink.configs()).asScala()));
        if (!props.contains(ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            props.put(ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), requestListenerName.value());
        }
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create(props);
        Option expectedClusterId = Option$.MODULE$.apply((Object)newClusterLink.clusterId());
        if (expectedClusterId.contains((Object)this.localClusterId())) {
            throw new InvalidRequestException(new StringBuilder(85).append("Requested cluster ID matches local cluster ID '").append(this.localClusterId()).append("' - cannot create cluster link to self").toString());
        }
        LinkMode linkMode = linkConfig.linkMode();
        LinkMode$Destination$ linkMode$Destination$ = LinkMode$Destination$.MODULE$;
        if (!(linkMode != null ? !linkMode.equals(linkMode$Destination$) : linkMode$Destination$ != null)) {
            ConnectionMode connectionMode = linkConfig.connectionMode();
            ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
            if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null) && expectedClusterId.isEmpty()) {
                throw new InvalidRequestException("Remote cluster id must be provided for destination cluster link with source connection origination");
            }
        }
        LinkMode linkMode2 = linkConfig.linkMode();
        LinkMode$Source$ linkMode$Source$ = LinkMode$Source$.MODULE$;
        if (!(linkMode2 != null ? !linkMode2.equals(linkMode$Source$) : linkMode$Source$ != null)) {
            ConnectionMode connectionMode = linkConfig.connectionMode();
            ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
            if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null)) {
                throw new InvalidRequestException("Source links are currently supported only with source connection origination");
            }
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Properties persistentProps = this.clusterLinkManager().configEncoder().encode(props);
        LinkMode linkMode3 = linkConfig.linkMode();
        LinkMode$Source$ linkMode$Source$2 = LinkMode$Source$.MODULE$;
        if (!(linkMode3 != null ? !linkMode3.equals(linkMode$Source$2) : linkMode$Source$2 != null)) {
            this.clusterLinkManager().scheduler().schedule("CreateSourceClusterLink", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    void var11_18;
                    void var10_17;
                    Tuple2 tuple2;
                    ClusterLinkAdminClient withRemoteAdmin_admin;
                    block12: {
                        ClusterLinkAdminClient clusterLinkAdminClient;
                        try {
                            clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), $this.metrics, $this.time);
                        }
                        catch (Throwable withRemoteAdmin_e) {
                            throw new InvalidConfigurationException("Unable to create client using provided properties when validating the cluster link", withRemoteAdmin_e);
                        }
                        withRemoteAdmin_admin = clusterLinkAdminClient;
                        try {
                            ClientInterceptor withRemoteAdmin_clientInterceptor = (ClientInterceptor)tenantPrefix.map((Function1 & Serializable & scala.Serializable)prefix -> ClusterLinkManager$.MODULE$.tenantInterceptor((String)prefix, linkName, linkConfig.linkMode(), $this.metrics)).orNull(Predef$.MODULE$.$conforms());
                            LinkMode linkMode = linkConfig.linkMode();
                            if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                                withRemoteAdmin_admin.networkClient().enableDestinationClusterLink(null, withRemoteAdmin_clientInterceptor, null);
                                break block12;
                            }
                            if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                                withRemoteAdmin_admin.networkClient().enableSourceClusterLink(null, withRemoteAdmin_clientInterceptor, null, null);
                                break block12;
                            }
                            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
                        }
                        catch (Throwable withRemoteAdmin_e) {
                            throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", withRemoteAdmin_e);
                        }
                    }
                    try {
                        KafkaAdminClient kafkaAdminClient = withRemoteAdmin_admin.admin();
                        tuple2 = this.validateSourceClusterLink((ConfluentAdmin)kafkaAdminClient, linkName, (Option<String>)tenantPrefix, (Option<String>)expectedClusterId, timeoutMs);
                    }
                    finally {
                        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> withRemoteAdmin_admin.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError(null);
                    }
                    UUID linkId = (UUID)tuple22._1();
                    String remoteClusterId = (String)tuple22._2();
                    void linkId2 = var10_17;
                    void remoteClusterId2 = var11_18;
                    this.finishCreateClusterLink(linkName, (Option<UUID>)new Some((Object)linkId2), (Option<String>)new Some((Object)remoteClusterId2), tenantPrefix, linkConfig, persistentProps, validateOnly);
                    result.complete(null);
                    return;
                }
                catch (Throwable e) {
                    result.completeExceptionally(this.apiException(e));
                    return;
                }
            }, this.clusterLinkManager().scheduler().schedule$default$3(), this.clusterLinkManager().scheduler().schedule$default$4(), this.clusterLinkManager().scheduler().schedule$default$5());
            return result;
        }
        if (validateLink) {
            ConnectionMode connectionMode = linkConfig.connectionMode();
            ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
            if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Outbound$) : connectionMode$Outbound$ != null)) {
                this.clusterLinkManager().scheduler().schedule("CreateDestinationClusterLink", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    try {
                        Option option;
                        ClusterLinkAdminClient withRemoteAdmin_admin;
                        block11: {
                            ClusterLinkAdminClient clusterLinkAdminClient;
                            try {
                                clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), $this.metrics, $this.time);
                            }
                            catch (Throwable withRemoteAdmin_e) {
                                throw new InvalidConfigurationException("Unable to create client using provided properties when validating the cluster link", withRemoteAdmin_e);
                            }
                            withRemoteAdmin_admin = clusterLinkAdminClient;
                            try {
                                ClientInterceptor withRemoteAdmin_clientInterceptor = (ClientInterceptor)tenantPrefix.map((Function1 & Serializable & scala.Serializable)prefix -> ClusterLinkManager$.MODULE$.tenantInterceptor((String)prefix, linkName, linkConfig.linkMode(), $this.metrics)).orNull(Predef$.MODULE$.$conforms());
                                LinkMode linkMode = linkConfig.linkMode();
                                if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                                    withRemoteAdmin_admin.networkClient().enableDestinationClusterLink(null, withRemoteAdmin_clientInterceptor, null);
                                    break block11;
                                }
                                if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                                    withRemoteAdmin_admin.networkClient().enableSourceClusterLink(null, withRemoteAdmin_clientInterceptor, null, null);
                                    break block11;
                                }
                                throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
                            }
                            catch (Throwable withRemoteAdmin_e) {
                                throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", withRemoteAdmin_e);
                            }
                        }
                        try {
                            KafkaAdminClient kafkaAdminClient = withRemoteAdmin_admin.admin();
                            option = this.validateDestinationClusterLink((Admin)((ConfluentAdmin)kafkaAdminClient), (Option<String>)expectedClusterId, props, timeoutMs, linkName);
                        }
                        finally {
                            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> withRemoteAdmin_admin.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                        }
                        Option remoteClusterId = option;
                        this.finishCreateClusterLink(linkName, (Option<UUID>)None$.MODULE$, (Option<String>)remoteClusterId, tenantPrefix, linkConfig, persistentProps, validateOnly);
                        result.complete(null);
                        return;
                    }
                    catch (Throwable e) {
                        result.completeExceptionally(this.apiException(e));
                        return;
                    }
                }, this.clusterLinkManager().scheduler().schedule$default$3(), this.clusterLinkManager().scheduler().schedule$default$4(), this.clusterLinkManager().scheduler().schedule$default$5());
                return result;
            }
        }
        try {
            this.finishCreateClusterLink(linkName, (Option<UUID>)None$.MODULE$, (Option<String>)expectedClusterId, tenantPrefix, linkConfig, persistentProps, validateOnly);
            result.complete(null);
            return result;
        }
        catch (Throwable e) {
            result.completeExceptionally(this.apiException(e));
        }
        return result;
    }

    @Override
    public Seq<ClusterLinkListing> listClusterLinks(Option<scala.collection.immutable.Set<String>> linkNames, boolean includeTopics) {
        None$ none$;
        Seq clusterLinkDatas = (Seq)this.clusterLinkManager().listClusterLinks().filter((Function1 & Serializable & scala.Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)linkNames.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)cld.linkName())))));
        if (includeTopics) {
            scala.collection.immutable.Set linkIds = ((TraversableOnce)clusterLinkDatas.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.linkId(), Seq$.MODULE$.canBuildFrom())).toSet();
            none$ = new Some(this.getAllMirrorTopics(false).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)linkIds.contains((Object)((ClusterLinkTopicState)e._2()).linkId()))));
        } else {
            none$ = None$.MODULE$;
        }
        None$ topics = none$;
        return (Seq)clusterLinkDatas.map(arg_0 -> ClusterLinkAdminManager.$anonfun$listClusterLinks$5(this, (Option)topics, arg_0), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void deleteClusterLink(String linkName, boolean validateOnly, boolean force) {
        Map topicsInUse;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Attempting to delete cluster link ").append(linkName).append(" with validateOnly=").append(validateOnly).append(" and force=").append(force).toString());
        ClusterLinkUtils$.MODULE$.validateLinkName(linkName);
        UUID linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
        if (!force && (topicsInUse = (Map)this.getAllMirrorTopicsInUse().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$deleteClusterLink$2(linkId, x$5)))).nonEmpty()) {
            throw new ClusterLinkInUseException(new StringBuilder(46).append("Cluster link '").append(linkName).append("' with ID '").append(linkId).append("' in used by topics: ").append(topicsInUse).toString());
        }
        if (!validateOnly) {
            this.clusterLinkManager().deleteClusterLink(linkName, linkId);
        }
    }

    @Override
    public CompletableFuture<Void> alterMirror(String topic, AlterMirrorOp op, boolean validateOnly) {
        CompletableFuture<Void> completableFuture;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Attempting to alter mirror topic ").append(topic).append(" with request ").append(op).append(" and validateOnly=").append(validateOnly).toString());
        if (AlterMirrorOp.PROMOTE.equals(op)) {
            completableFuture = this.stopTopicMirror(topic, true, validateOnly);
        } else if (AlterMirrorOp.FAILOVER.equals(op)) {
            completableFuture = this.stopTopicMirror(topic, false, validateOnly);
        } else if (AlterMirrorOp.CLEAR.equals(op)) {
            completableFuture = this.clearTopicMirror(topic, validateOnly);
        } else if (AlterMirrorOp.PAUSE.equals(op)) {
            completableFuture = this.pauseTopicMirror(topic, true, false, validateOnly);
        } else if (AlterMirrorOp.RESUME.equals(op)) {
            completableFuture = this.pauseTopicMirror(topic, false, false, validateOnly);
        } else if (AlterMirrorOp.PAUSE_LINK.equals(op)) {
            completableFuture = this.pauseTopicMirror(topic, true, true, validateOnly);
        } else if (AlterMirrorOp.RESUME_LINK.equals(op)) {
            completableFuture = this.pauseTopicMirror(topic, false, true, validateOnly);
        } else {
            throw new UnsupportedVersionException("Unknown alter mirrors op type");
        }
        return completableFuture;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CompletableFuture<Void> stopTopicMirror(String topic, boolean synchronize, boolean validateOnly) {
        ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror;
        block8: {
            Option option;
            block9: {
                boolean bl;
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Requested to stop topic mirror for topic '").append(topic).append("' with synchronize=").append(synchronize).append(", validateOnly=").append(validateOnly).toString());
                Topic.validate((String)topic);
                if (!this.clusterLinkManager().adminManager().metadataCache().contains(topic)) {
                    throw new UnknownTopicOrPartitionException(new StringBuilder(16).append("Topic ").append(topic).append(" not found").toString());
                }
                option = this.zkClient().getClusterLinkForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
                if (!(option instanceof Some)) break block9;
                ClusterLinkTopicState clusterLink = (ClusterLinkTopicState)((Some)option).value();
                String linkName = clusterLink.linkName();
                boolean bl2 = clusterLink instanceof ClusterLinkTopicState.Mirror ? true : (clusterLink instanceof ClusterLinkTopicState.FailedMirror ? true : clusterLink instanceof ClusterLinkTopicState.PausedMirror);
                if (bl2) {
                    pendingStoppedMirror = new ClusterLinkTopicState.PendingStoppedMirror(linkName, clusterLink.linkId(), synchronize, ClusterLinkTopicState$PendingStoppedMirror$.MODULE$.apply$default$4());
                    break block8;
                } else if (clusterLink instanceof ClusterLinkTopicState.PendingStoppedMirror && (bl = ((ClusterLinkTopicState.PendingStoppedMirror)clusterLink).synchronize()) && !synchronize) {
                    pendingStoppedMirror = new ClusterLinkTopicState.PendingStoppedMirror(linkName, clusterLink.linkId(), false, ClusterLinkTopicState$PendingStoppedMirror$.MODULE$.apply$default$4());
                    break block8;
                } else {
                    boolean bl3 = clusterLink instanceof ClusterLinkTopicState.PendingStoppedMirror ? true : clusterLink instanceof ClusterLinkTopicState.StoppedMirror;
                    if (bl3) {
                        throw new InvalidRequestException(new StringBuilder(47).append("Topic '").append(topic).append("' has already stopped its mirror from '").append(linkName).append("'").toString());
                    }
                    throw new MatchError((Object)clusterLink);
                }
            }
            if (None$.MODULE$.equals(option)) {
                throw new InvalidRequestException(new StringBuilder(24).append("Topic '").append(topic).append("' is not mirrored").toString());
            }
            throw new MatchError((Object)option);
        }
        if (!validateOnly) {
            this.zkClient().setTopicClusterLink(topic, (Option<ClusterLinkTopicState>)new Some((Object)pendingStoppedMirror));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> clearTopicMirror(String topic, boolean validateOnly) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Requested to clear topic mirror for topic '").append(topic).append("' with validateOnly=").append(validateOnly).toString());
        Topic.validate((String)topic);
        if (!this.clusterLinkManager().adminManager().metadataCache().contains(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(16).append("Topic ").append(topic).append(" not found").toString());
        }
        if (!validateOnly && this.zkClient().getClusterLinkForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).contains((Object)topic)) {
            this.zkClient().setTopicClusterLink(topic, (Option<ClusterLinkTopicState>)None$.MODULE$);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * Unable to fully structure code
     */
    private CompletableFuture<Void> pauseTopicMirror(String topic, boolean enable, boolean isLinkLevel, boolean validateOnly) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pauseTopicMirror$1(java.lang.String boolean boolean boolean ), ()Ljava/lang/String;)((String)topic, (boolean)enable, (boolean)isLinkLevel, (boolean)validateOnly));
        Topic.validate((String)topic);
        if (!this.clusterLinkManager().adminManager().metadataCache().contains(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(16).append("Topic ").append(topic).append(" not found").toString());
        }
        var6_5 = false;
        var7_6 = null;
        var8_7 = this.zkClient().getClusterLinkForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
        if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
        var6_5 = true;
        var7_6 = (Some)var8_7;
        clusterLink = (ClusterLinkTopicState)var7_6.value();
        if (enable) {
            var5_9 = clusterLink.toPausedState(isLinkLevel);
        } else if (var6_5) {
            var5_9 = ((ClusterLinkTopicState)var7_6.value()).toUnpausedState(isLinkLevel);
        } else {
            if (None$.MODULE$.equals(var8_7)) {
                throw new InvalidRequestException(new StringBuilder(24).append("Topic '").append(topic).append("' is not mirrored").toString());
            }
            throw new MatchError((Object)var8_7);
        }
        if (!validateOnly) {
            var5_9.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$pauseTopicMirror$2$adapted(kafka.server.link.ClusterLinkAdminManager java.lang.String kafka.server.link.ClusterLinkTopicState ), (Lkafka/server/link/ClusterLinkTopicState;)Ljava/lang/Object;)((ClusterLinkAdminManager)this, (String)topic));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Iterable<String> listMirrors(Option<String> linkName, boolean includeStopped) {
        Option linkId = linkName.map((Function1 & Serializable & scala.Serializable)ln -> this.clusterLinkManager().resolveLinkIdOrThrow((String)ln));
        return ((MapLike)this.getAllMirrorTopics(includeStopped).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$listMirrors$2(linkId, x0$1)))).keys();
    }

    @Override
    public TopicMirrorDescription describeMirror(String topic) {
        Topic.validate((String)topic);
        int numPartitions = BoxesRunTime.unboxToInt((Object)this.clusterLinkManager().adminManager().metadataCache().numPartitions(topic).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new UnknownTopicOrPartitionException(new StringBuilder(15).append("Unknown topic: ").append(topic).toString());
        }));
        ClusterLinkTopicState state = (ClusterLinkTopicState)this.clusterLinkManager().controller().controllerContext().linkedTopics().getOrElse((Object)topic, (Function0 & Serializable & scala.Serializable)() -> {
            throw new ClusterLinkNotFoundException(new StringBuilder(24).append("Topic '").append(topic).append("' is not mirrored").toString());
        });
        if (this.clusterLinkManager().controller().controllerContext().isTopicQueuedUpForDeletion(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(15).append("Unknown topic: ").append(topic).toString());
        }
        return new TopicMirrorDescription(state.linkName(), state.linkId(), topic, numPartitions, state.topicMirrorDescriptionState(), state.timeMs());
    }

    private void finishCreateClusterLink(String linkName, Option<UUID> linkId, Option<String> linkClusterId, Option<String> tenantPrefix, ClusterLinkConfig linkConfig, Properties persistentProps, boolean validateOnly) {
        if (!validateOnly) {
            ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, (UUID)linkId.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID()), linkClusterId, tenantPrefix, false);
            this.clusterLinkManager().createClusterLink(clusterLinkData, linkConfig, persistentProps);
        }
    }

    private <T> T withRemoteAdmin(String linkName, ClusterLinkConfig linkConfig, Option<String> tenantPrefix, Function1<ConfluentAdmin, T> func) {
        Object object;
        ClusterLinkAdminClient admin;
        block9: {
            ClusterLinkAdminClient clusterLinkAdminClient;
            try {
                clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), this.metrics, this.time);
            }
            catch (Throwable e) {
                throw new InvalidConfigurationException("Unable to create client using provided properties when validating the cluster link", e);
            }
            admin = clusterLinkAdminClient;
            try {
                ClientInterceptor clientInterceptor = (ClientInterceptor)tenantPrefix.map((Function1 & Serializable & scala.Serializable)prefix -> ClusterLinkManager$.MODULE$.tenantInterceptor((String)prefix, linkName, linkConfig.linkMode(), $this.metrics)).orNull(Predef$.MODULE$.$conforms());
                LinkMode linkMode = linkConfig.linkMode();
                if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                    admin.networkClient().enableDestinationClusterLink(null, clientInterceptor, null);
                    break block9;
                }
                if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                    admin.networkClient().enableSourceClusterLink(null, clientInterceptor, null, null);
                    break block9;
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
            }
            catch (Throwable e) {
                throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", e);
            }
        }
        try {
            object = func.apply((Object)admin.admin());
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> withRemoteAdmin_admin.close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        return (T)object;
    }

    private Option<String> validateDestinationClusterLink(Admin admin, Option<String> expectedClusterId, Properties props, int timeoutMs, String linkName) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Validating creating destination cluster link ").append(linkName).toString());
        Boolean aclSyncEnabled = ClusterLinkConfig$.MODULE$.create(props).aclSyncEnable();
        DescribeClusterResult describeResult = admin.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(Predef$.MODULE$.Boolean2boolean(aclSyncEnabled)).timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs)));
        if (Predef$.MODULE$.Boolean2boolean(aclSyncEnabled) && !((Set)describeResult.authorizedOperations().get()).contains(AclOperation.DESCRIBE)) {
            throw new ClusterAuthorizationException("ACL sync was requested, but link credentials don't have DESCRIBE access for the source cluster");
        }
        Option linkClusterId = Option$.MODULE$.apply(describeResult.clusterId().get());
        if (linkClusterId instanceof Some) {
            String lcid = (String)((Some)linkClusterId).value();
            expectedClusterId.foreach((Function1 & Serializable & scala.Serializable)ecid -> {
                ClusterLinkAdminManager.$anonfun$validateDestinationClusterLink$2(lcid, ecid);
                return BoxedUnit.UNIT;
            });
        } else if (None$.MODULE$.equals(linkClusterId)) {
            expectedClusterId.foreach((Function1 & Serializable & scala.Serializable)ecid -> {
                throw new InvalidRequestException(new StringBuilder(67).append("Expected cluster ID '").append((String)ecid).append("' does not match due to no resolved cluster ID").toString());
            });
        } else {
            throw new MatchError((Object)linkClusterId);
        }
        return linkClusterId;
    }

    private Tuple2<UUID, String> validateSourceClusterLink(ConfluentAdmin remoteAdmin, String linkName, Option<String> tenantPrefix2, Option<String> expectedDestClusterId, int timeoutMs) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Validating creating source cluster link ").append(linkName).toString());
        ClusterLinkListing result = (ClusterLinkListing)((Collection)remoteAdmin.listClusterLinks((ListClusterLinksOptions)new ListClusterLinksOptions().linkNames(Optional.of(Collections.singletonList(linkName))).timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs))).result().get()).iterator().next();
        if (!((Set)remoteAdmin.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true).timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs))).authorizedOperations().get()).contains(AclOperation.ALTER)) {
            throw new ClusterAuthorizationException("Link credentials don't have ALTER access for the destination cluster");
        }
        String destClusterId = result.localClusterId();
        String sourceClusterId = result.remoteClusterId();
        UUID linkId = result.linkId();
        Option option = Option$.MODULE$.apply((Object)destClusterId);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new InvalidRequestException("Destination cluster id could not be determined for the cluster link");
            }
            throw new MatchError((Object)option);
        }
        String clusterId = (String)((Some)option).value();
        expectedDestClusterId.foreach((Function1 & Serializable & scala.Serializable)expectedId -> {
            ClusterLinkAdminManager.$anonfun$validateSourceClusterLink$2(clusterId, expectedId);
            return BoxedUnit.UNIT;
        });
        String expectedSourceClusterId = (String)tenantPrefix2.map((Function1 & Serializable & scala.Serializable)tenantPrefix -> ClusterLinkUtils$.MODULE$.logicalCluster((String)tenantPrefix)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.localClusterId());
        String string = sourceClusterId;
        if (string == null ? expectedSourceClusterId != null : !string.equals(expectedSourceClusterId)) {
            throw new InvalidRequestException(new StringBuilder(84).append("Source cluster id '").append(expectedSourceClusterId).append("' does not match the cluster id '").append(sourceClusterId).append("' configured on the destination.").toString());
        }
        return new Tuple2((Object)linkId, (Object)destClusterId);
    }

    private Map<String, ClusterLinkTopicState> getAllMirrorTopics(boolean includeStopped) {
        return ((TraversableOnce)this.clusterLinkManager().controller().controllerContext().linkedTopics().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$getAllMirrorTopics$1(this, includeStopped, x0$1)))).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, ClusterLinkTopicState> getAllMirrorTopicsInUse() {
        return ((TraversableOnce)this.clusterLinkManager().controller().controllerContext().linkedTopics().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$getAllMirrorTopicsInUse$1(this, x0$1)))).toMap(Predef$.MODULE$.$conforms());
    }

    private ApiException apiException(Throwable throwable) {
        Throwable throwable2 = throwable instanceof ExecutionException ? ((ExecutionException)throwable).getCause() : throwable;
        ApiError apiError = ApiError.fromThrowable((Throwable)throwable2);
        String errorMessage = new StringBuilder(46).append("Unable to validate cluster link due to error: ").append(apiError.messageWithFallback()).toString();
        Errors errors = apiError.error();
        Errors errors2 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable2);
        }
        return apiError.error().exception(errorMessage);
    }

    public static final /* synthetic */ boolean $anonfun$listClusterLinks$6(ClusterLinkData cld$2, Tuple2 x$4) {
        UUID uUID = ((ClusterLinkTopicState)x$4._2()).linkId();
        UUID uUID2 = cld$2.linkId();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ ClusterLinkListing $anonfun$listClusterLinks$5(ClusterLinkAdminManager $this, Option topics$1, ClusterLinkData cld) {
        Optional<Object> optional;
        if (topics$1 instanceof Some) {
            Map lt = (Map)((Some)topics$1).value();
            optional = Optional.of(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((MapLike)lt.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$listClusterLinks$6(cld, x$4)))).keys().toList()).asJavaCollection());
        } else if (None$.MODULE$.equals(topics$1)) {
            optional = Optional.empty();
        } else {
            throw new MatchError((Object)topics$1);
        }
        return new ClusterLinkListing(cld.linkName(), cld.linkId(), (String)cld.clusterId().orNull(Predef$.MODULE$.$conforms()), $this.localClusterId(), optional);
    }

    public static final /* synthetic */ boolean $anonfun$deleteClusterLink$2(UUID linkId$1, Tuple2 x$5) {
        UUID uUID = ((ClusterLinkTopicState)x$5._2()).linkId();
        return !(uUID != null ? !((Object)uUID).equals(linkId$1) : linkId$1 != null);
    }

    public static final /* synthetic */ String $anonfun$pauseTopicMirror$1(String topic$4, boolean enable$1, boolean isLinkLevel$1, boolean validateOnly$6) {
        return new StringBuilder(86).append("Requested to pause topic mirror for topic '").append(topic$4).append("' with enable=").append(enable$1).append(", isLinkLevel=").append(isLinkLevel$1).append(", validateOnly=").append(validateOnly$6).toString();
    }

    public static final /* synthetic */ void $anonfun$pauseTopicMirror$2(ClusterLinkAdminManager $this, String topic$4, ClusterLinkTopicState ncl) {
        $this.zkClient().setTopicClusterLink(topic$4, (Option<ClusterLinkTopicState>)new Some((Object)ncl));
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$3(ClusterLinkTopicState state$1, UUID x$6) {
        UUID uUID = x$6;
        UUID uUID2 = state$1.linkId();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$2(Option linkId$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
        boolean bl = linkId$2.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$listMirrors$3(state, x$6)));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$validateDestinationClusterLink$2(String lcid$1, String ecid) {
        String string = ecid;
        if (string == null ? lcid$1 != null : !string.equals(lcid$1)) {
            throw new InvalidRequestException(new StringBuilder(60).append("Expected cluster ID '").append(ecid).append("' does not match resolved cluster ID '").append(lcid$1).append("'").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validateSourceClusterLink$2(String clusterId$1, String expectedId) {
        String string = expectedId;
        if (string == null ? clusterId$1 != null : !string.equals(clusterId$1)) {
            throw new InvalidRequestException(new StringBuilder(60).append("Expected cluster ID '").append(expectedId).append("' does not match the dest cluster ID '").append(clusterId$1).append("'").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllMirrorTopics$1(ClusterLinkAdminManager $this, boolean includeStopped$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String topic = (String)x0$1._1();
        ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
        boolean bl = (includeStopped$1 || !(state instanceof ClusterLinkTopicState.StoppedMirror)) && !$this.clusterLinkManager().controller().controllerContext().isTopicQueuedUpForDeletion(topic);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getAllMirrorTopicsInUse$1(ClusterLinkAdminManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String topic = (String)x0$1._1();
        ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
        boolean bl = !(state instanceof ClusterLinkTopicState.PendingStoppedMirror) && !(state instanceof ClusterLinkTopicState.StoppedMirror) && !$this.clusterLinkManager().controller().controllerContext().isTopicQueuedUpForDeletion(topic);
        return bl;
    }

    public ClusterLinkAdminManager(KafkaConfig config, String localClusterId, KafkaZkClient zkClient, ClusterLinkManager clusterLinkManager, Metrics metrics, Time time) {
        this.config = config;
        this.localClusterId = localClusterId;
        this.zkClient = zkClient;
        this.clusterLinkManager = clusterLinkManager;
        this.metrics = metrics;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(41).append("[Cluster Link Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.purgatory = new DelayedFuturePurgatory("ClusterLink", config.brokerId());
    }

    public static final /* synthetic */ Object $anonfun$pauseTopicMirror$2$adapted(ClusterLinkAdminManager $this, String topic$4, ClusterLinkTopicState ncl) {
        ClusterLinkAdminManager.$anonfun$pauseTopicMirror$2($this, topic$4, ncl);
        return BoxedUnit.UNIT;
    }
}

