/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxedUnit;

public final class ClusterLinkAdminClient$ {
    public static ClusterLinkAdminClient$ MODULE$;

    static {
        new ClusterLinkAdminClient$();
    }

    public ClusterLinkAdminClient createRemoteAdmin(String linkName, ClusterLinkConfig linkConfig, Option<ClusterLinkDestConnectionManager> connectionManager, String clientType, int localBrokerId, Metrics metrics, Time time) {
        String clientId = new StringBuilder(16).append("cluster-link-").append(clientType).append("-").append(linkName).append("-").append(linkConfig.linkMode().lowerCaseName()).append("-").append(localBrokerId).toString();
        LogContext logContext = new LogContext(new StringBuilder(24).append("[AdminClient clientId=").append(clientId).append("] ").toString());
        Properties clientProps = new Properties();
        linkConfig.originals().forEach((k, v) -> clientProps.put(k, v));
        clientProps.put("client.id", clientId);
        AdminClientConfig adminConfig = new AdminClientConfig((Map)clientProps);
        AdminMetadataManager metadataManager = new AdminMetadataManager(logContext, Predef$.MODULE$.Long2long(adminConfig.getLong("retry.backoff.ms")), Predef$.MODULE$.Long2long(adminConfig.getLong("metadata.max.age.ms")));
        List addresses = ClientUtils.parseAndValidateAddresses((List)adminConfig.getList("bootstrap.servers"), (String)adminConfig.getString("client.dns.lookup"));
        metadataManager.update(Cluster.bootstrap((List)addresses), time.milliseconds());
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(linkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(linkName), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)metadataManager.updater()), metrics, ClusterLinkFactory$.MODULE$.linkMetricTags(linkName), time, clientId, clientType, logContext);
        NetworkClient networkClient = (NetworkClient)clusterLinkClient.networkClient();
        connectionManager.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)new Some((Object)metadataManager));
            return BoxedUnit.UNIT;
        });
        KafkaAdminClient admin = KafkaAdminClient.createInternal((AdminClientConfig)adminConfig, (AdminMetadataManager)metadataManager, (KafkaClient)networkClient, (Time)time);
        return new ClusterLinkAdminClient(admin, metadataManager, networkClient, clientId);
    }

    private ClusterLinkAdminClient$() {
        MODULE$ = this;
    }
}

