/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001\u0002\u0014(\u00019B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003V\u0001\u0011\u0005a\u000bC\u0004]\u0001\t\u0007I\u0011B/\t\r)\u0004\u0001\u0015!\u0003_\u0011\u001dY\u0007A1A\u0005\n1Daa\u001e\u0001!\u0002\u0013i\u0007b\u0002=\u0001\u0001\u0004%I!\u001f\u0005\b{\u0002\u0001\r\u0011\"\u0003\u007f\u0011\u001d\tI\u0001\u0001Q!\niDa!a\u0003\u0001\t\u0003I\bbBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003\u001b\u0001A\u0011BA\f\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\u0010\u0001\t\u0013\ty\u0004C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004BBAE\u0001\u0011\u0005\u0011\u0010C\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u00111\u0014\u0001\u0005\u0002\u0005]\u0005bBAO\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!a-\u0001\t\u0003\t)\fC\u0004\u0002L\u0002!\t!!4\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"I\u0011Q\u001c\u0001\u0012\u0002\u0013\u0005\u0011q\u001c\u0005\b\u0003k\u0004A\u0011AA|\u0011\u001d\tI\u0010\u0001C\u0001\u0003oDq!a?\u0001\t\u0003\t9\u0010C\u0004\u0002~\u0002!\t!a@\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b!9!\u0011\u0002\u0001\u0005\u0002\t-\u0001b\u0002B\u000f\u0001\u0011%\u0011q\u001f\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3\u000b\u0005!J\u0013!B3q_\u000eD'B\u0001\u0016,\u0003\u0019\u0019XM\u001d<fe*\tA&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001yS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VM\u001a\t\u0003mej\u0011a\u000e\u0006\u0003q-\nQ!\u001e;jYNL!AO\u001c\u0003\u000f1{wmZ5oO\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u001fF\u001b\u0005q$BA A\u0003\u0019\u0019w.\\7p]*\u0011A&\u0011\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G}\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u00047pO\u0016sGm\u00144gg\u0016$\bc\u0001\u0019J\u0017&\u0011!*\r\u0002\n\rVt7\r^5p]B\u0002\"\u0001\r'\n\u00055\u000b$\u0001\u0002'p]\u001e\f!b\u00195fG.\u0004x.\u001b8u!\t\u00016+D\u0001R\u0015\t\u0011\u0016&A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c\u0018B\u0001+R\u0005UaU-\u00193fe\u0016\u0003xn\u00195DQ\u0016\u001c7\u000e]8j]R\fa\u0001P5oSRtD\u0003B,Z5n\u0003\"\u0001\u0017\u0001\u000e\u0003\u001dBQa\u000f\u0003A\u0002qBQa\u0012\u0003A\u0002!CQA\u0014\u0003A\u0002=\u000bA\u0001\\8dWV\ta\f\u0005\u0002`Q6\t\u0001M\u0003\u0002bE\u0006)An\\2lg*\u00111\rZ\u0001\u000bG>t7-\u001e:sK:$(BA3g\u0003\u0011)H/\u001b7\u000b\u0003\u001d\fAA[1wC&\u0011\u0011\u000e\u0019\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u0006)An\\2lA\u00051Q\r]8dQN,\u0012!\u001c\t\u0005]>\fH/D\u0001e\u0013\t\u0001HMA\u0004Ue\u0016,W*\u00199\u0011\u0005A\u0012\u0018BA:2\u0005\rIe\u000e\u001e\t\u00031VL!A^\u0014\u0003\u0015\u0015\u0003xn\u00195F]R\u0014\u00180A\u0004fa>\u001c\u0007n\u001d\u0011\u0002\u0011}K7\u000fR5sif,\u0012A\u001f\t\u0003amL!\u0001`\u0019\u0003\u000f\t{w\u000e\\3b]\u0006aq,[:ESJ$\u0018p\u0018\u0013fcR\u0019q0!\u0002\u0011\u0007A\n\t!C\u0002\u0002\u0004E\u0012A!\u00168ji\"A\u0011q\u0001\u0006\u0002\u0002\u0003\u0007!0A\u0002yIE\n\u0011bX5t\t&\u0014H/\u001f\u0011\u0002\u000f%\u001cH)\u001b:us\u00061\u0011m]:jO:$Ra`A\t\u0003'AQ\u0001K\u0007A\u0002EDa!!\u0006\u000e\u0001\u0004Y\u0015aC:uCJ$xJ\u001a4tKR$2A_A\r\u0011\u0019\tYB\u0004a\u0001i\u0006)QM\u001c;ss\u00069!/Z:u_J,GcA@\u0002\"!9\u00111E\bA\u0002\u0005\u0015\u0012aB3oiJLWm\u001d\t\u0006\u0003O\t9\u0004\u001e\b\u0005\u0003S\t\u0019D\u0004\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty#L\u0001\u0007yI|w\u000e\u001e \n\u0003IJ1!!\u000e2\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000f\u0002<\t!A*[:u\u0015\r\t)$M\u0001![\u0006L(-\u001a+sk:\u001c\u0017\r^3O_:luN\\8u_:L7-\u00128ue&,7\u000fF\u0002\u0000\u0003\u0003Ba!a\u0011\u0011\u0001\u0004!\u0018\u0001\u00038fo\u0016sGO]=\u0002\u001bI,Wn\u001c<f\rJ|W.\u00128e)\u0011\tI%!\u0016\u0011\u000b\u0005-\u0013\u0011\u000b;\u000e\u0005\u00055#bAA(c\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0013Q\n\u0002\u0004'\u0016\f\bbBA,#\u0001\u0007\u0011\u0011L\u0001\naJ,G-[2bi\u0016\u0004R\u0001MA.ijL1!!\u00182\u0005%1UO\\2uS>t\u0017'A\bsK6|g/\u001a$s_6\u001cF/\u0019:u)\u0011\tI%a\u0019\t\u000f\u0005]#\u00031\u0001\u0002Z\u0005\u0019\"/Z7pm\u0016<\u0006.\u001b7f\u001b\u0006$8\r[5oOR1\u0011\u0011JA5\u0003\u000fCq!a\u001b\u0014\u0001\u0004\ti'\u0001\u0005ji\u0016\u0014\u0018\r^8s!\u0015q\u0017qNA:\u0013\r\t\t\b\u001a\u0002\t\u0013R,'/\u0019;peB1\u0011QOAAcRtA!a\u001e\u0002~9!\u0011\u0011PA>\u001b\u00051\u0017BA3g\u0013\r\ty\bZ\u0001\u0004\u001b\u0006\u0004\u0018\u0002BAB\u0003\u000b\u0013Q!\u00128uefT1!a e\u0011\u001d\t9f\u0005a\u0001\u00033\n\u0001B\\8o\u000b6\u0004H/_\u0001\fY\u0006$Xm\u001d;F]R\u0014\u00180\u0006\u0002\u0002\u0010B!\u0001'!%u\u0013\r\t\u0019*\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u00171\fG/Z:u\u000bB|7\r[\u000b\u0003\u00033\u0003B\u0001MAIc\u0006i\u0001O]3wS>,8/\u00129pG\"\fQ\"Z1sY&,7\u000f^#oiJL\u0018\u0001D3oI>3gm]3u\r>\u0014H\u0003BAR\u0003S\u0003R\u0001MASc.K1!a*2\u0005\u0019!V\u000f\u001d7fe!1\u00111V\rA\u0002E\faB]3rk\u0016\u001cH/\u001a3Fa>\u001c\u0007.\u0001\bpM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\u0007-\u000b\t\f\u0003\u0004\u0002,j\u0001\r!]\u0001\u001bM&tG\rR5wKJ<WM\\2f\u0013:,\u0005o\\2i\u0007\u0006\u001c\u0007.\u001a\u000b\f\u0017\u0006]\u00161XA`\u0003\u0007\f9\rC\u0004\u0002:n\u0001\r!!\n\u0002!QLWM]3e\u000bB|7\r[*uCR,\u0007BBA_7\u0001\u00071*A\tgSJ\u001cH\u000fV5fe\u0016$wJ\u001a4tKRDa!!1\u001c\u0001\u0004Y\u0015\u0001\u00057bgR$\u0016.\u001a:fI>3gm]3u\u0011\u0019\t)m\u0007a\u0001\u0017\u0006\u0001b-\u001b:ti2{7-\u00197PM\u001a\u001cX\r\u001e\u0005\u0007\u0003\u0013\\\u0002\u0019A&\u0002\u001f1\f7\u000f\u001e'pG\u0006dwJ\u001a4tKR\fq\u0002\u001e:v]\u000e\fG/\u001a$s_6,e\u000e\u001a\u000b\u0004\u007f\u0006=\u0007BBAi9\u0001\u00071*A\u0005f]\u0012|eMZ:fi\u0006\tBO];oG\u0006$XM\u0012:p[N#\u0018M\u001d;\u0015\u000b}\f9.!7\t\r\u0005UQ\u00041\u0001L\u0011!\tY.\bI\u0001\u0002\u0004Q\u0018\u0001\u00054mkND\u0017J\u001a+sk:\u001c\u0017\r^3e\u0003m!(/\u001e8dCR,gI]8n'R\f'\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001d\u0016\u0004u\u0006\r8FAAs!\u0011\t9/!=\u000e\u0005\u0005%(\u0002BAv\u0003[\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0018'\u0001\u0006b]:|G/\u0019;j_:LA!a=\u0002j\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u00155\f\u0017PY3GYV\u001c\b\u000eF\u0001\u0000\u00035\u0019G.Z1s\u0003:$g\t\\;tQ\u0006)1\r\\3be\u0006)1\r\\8oKR\u0019qK!\u0001\t\r\t\r!\u00051\u0001P\u00035qWm^\"iK\u000e\\\u0007o\\5oi\u0006aQ\r]8dQ\u0016sGO]5fgV\u0011\u0011\u0011J\u0001\u0013g:\f\u0007o\u001d5pi\u001a{'oU3h[\u0016tG\u000f\u0006\u0003\u0003\u000e\te\u0001#\u0002\u0019\u0003\u0010\tM\u0011b\u0001B\tc\t)\u0011I\u001d:bsB\u0019\u0001G!\u0006\n\u0007\t]\u0011G\u0001\u0003CsR,\u0007B\u0002B\u000eI\u0001\u00071*\u0001\nf]\u0012|eMZ:fi&s7\r\\;tSZ,\u0017!\u00024mkND\u0007")
public class LeaderEpochFileCache
implements Logging {
    private final TopicPartition topicPartition;
    private final Function0<Object> logEndOffset;
    private final LeaderEpochCheckpoint checkpoint;
    private final ReentrantReadWriteLock lock;
    private final TreeMap<Object, EpochEntry> epochs;
    private boolean _isDirty;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private TreeMap<Object, EpochEntry> epochs() {
        return this.epochs;
    }

    private boolean _isDirty() {
        return this._isDirty;
    }

    private void _isDirty_$eq(boolean x$1) {
        this._isDirty = x$1;
    }

    public boolean isDirty() {
        return this._isDirty();
    }

    public void assign(int epoch, long startOffset) {
        EpochEntry entry = new EpochEntry(epoch, startOffset);
        if (this.assign(entry)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Appended new epoch entry ").append(entry).append(". Cache now contains ").append(this.epochs().size()).append(" entries.").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean assign(EpochEntry entry) {
        boolean bl;
        void inWriteLock_lock;
        if (entry.epoch() < 0 || entry.startOffset() < 0L) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Received invalid partition leader epoch entry ").append(entry).toString());
        }
        if (!this.isUpdateNeeded$1(entry)) {
            return false;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$assign$2(this, entry);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void restore(List<EpochEntry> entries) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$restore$1(this, entries);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void maybeTruncateNonMonotonicEntries(EpochEntry newEntry) {
        void var3_3;
        EpochEntry removeFromEnd_removeWhileMatching_entry;
        EpochEntry epochEntry;
        java.util.Iterator removeFromEnd_removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
        ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeFromEnd_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry, epochEntry = (removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue()))) {
            removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
            removeFromEnd_removeWhileMatching_iterator.remove();
        }
        if (var3_3.size() > 1 || var3_3.nonEmpty() && ((EpochEntry)var3_3.head()).startOffset() != newEntry.startOffset()) {
            this.warn((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$2(this, newEntry, (Seq)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromEnd(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        EpochEntry removeWhileMatching_entry;
        java.util.Iterator removeWhileMatching_iterator = this.epochs().descendingMap().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext() && BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)(removeWhileMatching_entry = (EpochEntry)removeWhileMatching_iterator.next().getValue())))) {
            removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
            removeWhileMatching_iterator.remove();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeFromStart(Function1<EpochEntry, Object> predicate) {
        void var3_3;
        EpochEntry removeWhileMatching_entry;
        java.util.Iterator<Map.Entry<Object, EpochEntry>> removeWhileMatching_iterator = this.epochs().entrySet().iterator();
        ListBuffer removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeWhileMatching_iterator.hasNext() && BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)(removeWhileMatching_entry = removeWhileMatching_iterator.next().getValue())))) {
            removeWhileMatching_removedEpochs.$plus$eq((Object)removeWhileMatching_entry);
            removeWhileMatching_iterator.remove();
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<EpochEntry> removeWhileMatching(java.util.Iterator<Map.Entry<Object, EpochEntry>> iterator, Function1<EpochEntry, Object> predicate) {
        void var3_3;
        ListBuffer removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (iterator.hasNext()) {
            EpochEntry entry = iterator.next().getValue();
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)entry))) {
                removedEpochs.$plus$eq((Object)entry);
                iterator.remove();
                continue;
            }
            return removedEpochs;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean nonEmpty() {
        boolean bl;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            bl = LeaderEpochFileCache.$anonfun$nonEmpty$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Option<EpochEntry> latestEntry() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$latestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    public Option<Object> latestEpoch() {
        return this.latestEntry().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.epoch()));
    }

    /*
     * WARNING - void declaration
     */
    public Option<Object> previousEpoch() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$previousEpoch$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Option<EpochEntry> earliestEntry() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = LeaderEpochFileCache.$anonfun$earliestEntry$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, Object> endOffsetFor(int requestedEpoch) {
        Tuple2 tuple2;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            tuple2 = LeaderEpochFileCache.$anonfun$endOffsetFor$1(this, requestedEpoch);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return tuple2;
    }

    /*
     * WARNING - void declaration
     */
    public long offsetForEpoch(int requestedEpoch) {
        long l;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            l = LeaderEpochFileCache.$anonfun$offsetForEpoch$1(this, requestedEpoch);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public long findDivergenceInEpochCache(List<EpochEntry> tieredEpochState, long firstTieredOffset, long lastTieredOffset, long firstLocalOffset, long lastLocalOffset) {
        Object object = new Object();
        try {
            long l;
            void inReadLock_lock;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
            if (CoreUtils$.MODULE$ == null) {
                throw null;
            }
            Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
            inReadLock_inLock_lock.lock();
            try {
                l = LeaderEpochFileCache.$anonfun$findDivergenceInEpochCache$1(this, tieredEpochState, object, firstLocalOffset, lastLocalOffset, firstTieredOffset, lastTieredOffset);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
            return l;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcJ$sp();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void truncateFromEnd(long endOffset) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromEnd$1(this, endOffset);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void truncateFromStart(long startOffset, boolean flushIfTruncated) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$truncateFromStart$1(this, startOffset, flushIfTruncated);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean truncateFromStart$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void maybeFlush() {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$maybeFlush$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clearAndFlush() {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clearAndFlush$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void clear() {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$clear$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public LeaderEpochFileCache clone(LeaderEpochCheckpoint newCheckpoint) {
        LeaderEpochFileCache leaderEpochFileCache;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            leaderEpochFileCache = LeaderEpochFileCache.$anonfun$clone$1(this, newCheckpoint);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return leaderEpochFileCache;
    }

    public Seq<EpochEntry> epochEntries() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.epochs().values()).asScala()).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] snapshotForSegment(long endOffsetInclusive) {
        byte[] byArray;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            byArray = this.checkpoint.toByteArray((Seq<EpochEntry>)((Seq)this.epochEntries().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$snapshotForSegment$2(endOffsetInclusive$1, e)))));
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return byArray;
    }

    private void flush() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Flushing leader epoch cache for partition ").append($this.topicPartition).append(", isDirty is ").append(this.isDirty()).toString());
        this.checkpoint.write((Iterable<EpochEntry>)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.epochs().values()).asScala()));
        this._isDirty_$eq(false);
    }

    public static final /* synthetic */ void $anonfun$new$1(LeaderEpochFileCache $this) {
        $this.checkpoint.read().foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)$this.assign(entry)));
    }

    private final boolean isUpdateNeeded$1(EpochEntry entry$2) {
        boolean bl;
        Option<EpochEntry> option = this.latestEntry();
        if (option instanceof Some) {
            EpochEntry lastEntry = (EpochEntry)((Some)option).value();
            bl = entry$2.epoch() != lastEntry.epoch() || entry$2.startOffset() < lastEntry.startOffset();
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$assign$2(LeaderEpochFileCache $this, EpochEntry entry$2) {
        if ($this.isUpdateNeeded$1(entry$2)) {
            $this.maybeTruncateNonMonotonicEntries(entry$2);
            $this.epochs().put(BoxesRunTime.boxToInteger((int)entry$2.epoch()), entry$2);
            $this._isDirty_$eq(true);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$restore$1(LeaderEpochFileCache $this, List entries$1) {
        $this.epochs().clear();
        entries$1.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            $this.maybeTruncateNonMonotonicEntries((EpochEntry)entry);
            return $this.epochs().put(BoxesRunTime.boxToInteger((int)entry.epoch()), (EpochEntry)entry);
        });
        $this.flush();
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncateNonMonotonicEntries$1(EpochEntry newEntry$1, EpochEntry entry) {
        return entry.epoch() >= newEntry$1.epoch() || entry.startOffset() >= newEntry$1.startOffset();
    }

    public static final /* synthetic */ String $anonfun$maybeTruncateNonMonotonicEntries$2(LeaderEpochFileCache $this, EpochEntry newEntry$1, Seq removedEpochs$1) {
        return new StringBuilder(88).append("New epoch entry ").append(newEntry$1).append(" caused truncation of conflicting entries ").append(removedEpochs$1).append(". ").append("Cache now contains ").append($this.epochs().size()).append(" entries.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$nonEmpty$1(LeaderEpochFileCache $this) {
        return !$this.epochs().isEmpty();
    }

    public static final /* synthetic */ Option $anonfun$latestEntry$1(LeaderEpochFileCache $this) {
        return Option$.MODULE$.apply($this.epochs().lastEntry()).map((Function1 & Serializable & scala.Serializable)x$1 -> (EpochEntry)x$1.getValue());
    }

    public static final /* synthetic */ int $anonfun$previousEpoch$3(Map.Entry x$3) {
        return BoxesRunTime.unboxToInt(x$3.getKey());
    }

    public static final /* synthetic */ Option $anonfun$previousEpoch$1(LeaderEpochFileCache $this) {
        return $this.latestEntry().flatMap((Function1 & Serializable & scala.Serializable)entry -> Option$.MODULE$.apply($this.epochs().lowerEntry(BoxesRunTime.boxToInteger((int)entry.epoch())))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)LeaderEpochFileCache.$anonfun$previousEpoch$3(x$3)));
    }

    public static final /* synthetic */ Option $anonfun$earliestEntry$1(LeaderEpochFileCache $this) {
        return Option$.MODULE$.apply($this.epochs().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> (EpochEntry)x$4.getValue());
    }

    public static final /* synthetic */ String $anonfun$endOffsetFor$2(LeaderEpochFileCache $this, int requestedEpoch$1, Tuple2 epochAndOffset$1) {
        return new StringBuilder(103).append("Processed end offset request for epoch ").append(requestedEpoch$1).append(" and returning epoch ").append(epochAndOffset$1._1$mcI$sp()).append(" ").append("with end offset ").append(epochAndOffset$1._2$mcJ$sp()).append(" from epoch cache of size ").append($this.epochs().size()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$endOffsetFor$1(LeaderEpochFileCache $this, int requestedEpoch$1) {
        void var2_4;
        Map.Entry<Object, EpochEntry> floorEntry;
        Map.Entry<Object, EpochEntry> higherEntry;
        Tuple2.mcIJ.sp epochAndOffset = requestedEpoch$1 == -1 ? new Tuple2.mcIJ.sp(-1, -1L) : ($this.latestEpoch().contains((Object)BoxesRunTime.boxToInteger((int)requestedEpoch$1)) ? new Tuple2.mcIJ.sp(requestedEpoch$1, $this.logEndOffset.apply$mcJ$sp()) : ((higherEntry = $this.epochs().higherEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(-1, -1L) : ((floorEntry = $this.epochs().floorEntry(BoxesRunTime.boxToInteger((int)requestedEpoch$1))) == null ? new Tuple2.mcIJ.sp(requestedEpoch$1, higherEntry.getValue().startOffset()) : new Tuple2.mcIJ.sp(floorEntry.getValue().epoch(), higherEntry.getValue().startOffset()))));
        $this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$endOffsetFor$2($this, requestedEpoch$1, (Tuple2)epochAndOffset)));
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$offsetForEpoch$1(LeaderEpochFileCache $this, int requestedEpoch$2) {
        void var2_2;
        long requestedStartOffset = requestedEpoch$2 == -1 || !$this.epochs().containsKey(BoxesRunTime.boxToInteger((int)requestedEpoch$2)) ? -1L : $this.epochs().get(BoxesRunTime.boxToInteger((int)requestedEpoch$2)).startOffset();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Processed start offset request for epoch ").append(requestedEpoch$2).append(" and returning start offset ").append(requestedStartOffset).toString());
        return (long)var2_2;
    }

    public static final /* synthetic */ void $anonfun$findDivergenceInEpochCache$5(LeaderEpochFileCache $this, long lastLocalOffset$1, ObjectRef localEpochAndOffsetRanges$1, Map.Entry entry) {
        Map.Entry<Object, EpochEntry> nextEntry = $this.epochs().higherEntry(entry.getKey());
        long numMessages = nextEntry == null ? lastLocalOffset$1 - ((EpochEntry)entry.getValue()).startOffset() + 1L : nextEntry.getValue().startOffset() - ((EpochEntry)entry.getValue()).startOffset();
        localEpochAndOffsetRanges$1.elem = ((Map)localEpochAndOffsetRanges$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)((EpochEntry)entry.getValue()).epoch())), (Object)new Tuple2.mcJJ.sp(((EpochEntry)entry.getValue()).startOffset(), numMessages)));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$findDivergenceInEpochCache$1(LeaderEpochFileCache $this, List tieredEpochState$1, Object nonLocalReturnKey1$1, long firstLocalOffset$1, long lastLocalOffset$1, long firstTieredOffset$1, long lastTieredOffset$1) {
        LongRef divergenceOffset = LongRef.create((long)-1L);
        if ($this.epochs().isEmpty() || tieredEpochState$1.isEmpty()) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Local epoch cache or the tiered state is empty. Hence, no divergence.");
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey1$1, divergenceOffset.elem);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Find divergence between local leader epoch cache ").append($this.epochs()).append(" [startOffset: ").append(firstLocalOffset$1).append(" lastOffset: ").append(lastLocalOffset$1).append("] ").append("and tiered leader epoch state ").append(tieredEpochState$1).append(" [startOffset: ").append(firstTieredOffset$1).append(" lastOffset: ").append(lastTieredOffset$1).append("]").toString());
        ObjectRef tieredEpochAndOffsetRanges = ObjectRef.create((Object)Nil$.MODULE$);
        tieredEpochState$1.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long numMessages = i + 1 == tieredEpochState$1.size() ? lastTieredOffset$1 - ((EpochEntry)tieredEpochState$1.apply(i)).startOffset() + 1L : ((EpochEntry)tieredEpochState$1.apply(i + 1)).startOffset() - ((EpochEntry)tieredEpochState$1.apply(i)).startOffset();
            tieredEpochAndOffsetRanges$1.elem = (List)((List)tieredEpochAndOffsetRanges$1.elem).$colon$plus((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)((EpochEntry)tieredEpochState$1.apply(i)).epoch()), (Object)BoxesRunTime.boxToLong((long)((EpochEntry)tieredEpochState$1.apply(i)).startOffset()), (Object)BoxesRunTime.boxToLong((long)numMessages)), List$.MODULE$.canBuildFrom());
        });
        ObjectRef localEpochAndOffsetRanges = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter($this.epochs().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            LeaderEpochFileCache.$anonfun$findDivergenceInEpochCache$5($this, lastLocalOffset$1, localEpochAndOffsetRanges, entry);
            return BoxedUnit.UNIT;
        });
        Iterator it = ((List)tieredEpochAndOffsetRanges.elem).iterator();
        while (divergenceOffset.elem == -1L && it.hasNext()) {
            void var19_14;
            void var17_13;
            Tuple2 tuple2;
            void var16_12;
            Tuple3 tuple3 = (Tuple3)it.next();
            if (tuple3 == null) {
                throw new MatchError(null);
            }
            int tieredEpoch = BoxesRunTime.unboxToInt((Object)tuple3._1());
            long tieredEpochStartOffset = BoxesRunTime.unboxToLong((Object)tuple3._2());
            long tieredEpochNumMessages = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Option option = ((Map)localEpochAndOffsetRanges.elem).get((Object)BoxesRunTime.boxToInteger((int)var16_12));
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                long localEpochStartOffset = tuple2._1$mcJ$sp();
                long localEpochNumMessages = tuple2._2$mcJ$sp();
                if (var17_13 != localEpochStartOffset && (var16_12 != $this.epochs().firstEntry().getValue().epoch() || localEpochStartOffset < var17_13)) {
                    divergenceOffset.elem = Math.min((long)var17_13, localEpochStartOffset);
                }
                if (divergenceOffset.elem != -1L) continue;
                if (var17_13 + var19_14 < localEpochStartOffset + localEpochNumMessages && var17_13 + var19_14 - 1L != lastTieredOffset$1) {
                    divergenceOffset.elem = var17_13 + var19_14;
                    continue;
                }
                if (var17_13 + var19_14 <= localEpochStartOffset + localEpochNumMessages || localEpochStartOffset + localEpochNumMessages - 1L == lastLocalOffset$1) continue;
                divergenceOffset.elem = localEpochStartOffset + localEpochNumMessages;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                if (var17_13 + var19_14 - 1L < firstLocalOffset$1 || var17_13 > lastLocalOffset$1 || var19_14 == 0L) continue;
                divergenceOffset.elem = var17_13;
                continue;
            }
            throw new MatchError((Object)option);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Divergence reported: ").append(divergenceOffset$1.elem).toString());
        return divergenceOffset.elem;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$2(long endOffset$1, EpochEntry x$6) {
        return x$6.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromEnd$3(long endOffset$1, EpochEntry x$7) {
        return x$7.startOffset() >= endOffset$1;
    }

    public static final /* synthetic */ String $anonfun$truncateFromEnd$4(LeaderEpochFileCache $this, Seq removedEntries$1, long endOffset$1) {
        return new StringBuilder(97).append("Cleared entries ").append(removedEntries$1).append(" from epoch cache after ").append("truncating to end offset ").append(endOffset$1).append(", leaving ").append($this.epochs().size()).append(" entries in the cache.").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$truncateFromEnd$1(LeaderEpochFileCache $this, long endOffset$1) {
        if (endOffset$1 >= 0L && $this.latestEntry().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$2(endOffset$1, x$6)))) {
            void var4_3;
            EpochEntry removeFromEnd_removeWhileMatching_entry;
            EpochEntry epochEntry;
            java.util.Iterator removeFromEnd_removeWhileMatching_iterator = $this.epochs().descendingMap().entrySet().iterator();
            ListBuffer removeFromEnd_removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
            while (removeFromEnd_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, epochEntry = (removeFromEnd_removeWhileMatching_entry = (EpochEntry)removeFromEnd_removeWhileMatching_iterator.next().getValue()))) {
                removeFromEnd_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromEnd_removeWhileMatching_entry);
                removeFromEnd_removeWhileMatching_iterator.remove();
            }
            $this.flush();
            $this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> LeaderEpochFileCache.$anonfun$truncateFromEnd$4($this, (Seq)var4_3, endOffset$1)));
        }
    }

    public static final /* synthetic */ boolean $anonfun$truncateFromStart$2(long startOffset$1, EpochEntry entry) {
        return entry.startOffset() <= startOffset$1;
    }

    public static final /* synthetic */ void $anonfun$truncateFromStart$3(LeaderEpochFileCache $this, long startOffset$1, boolean flushIfTruncated$1, Seq removedEntries$2, EpochEntry firstBeforeStartOffset) {
        EpochEntry updatedFirstEntry = new EpochEntry(firstBeforeStartOffset.epoch(), startOffset$1);
        $this.epochs().put(BoxesRunTime.boxToInteger((int)updatedFirstEntry.epoch()), updatedFirstEntry);
        if (flushIfTruncated$1) {
            $this.flush();
        } else {
            $this._isDirty_$eq(true);
        }
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Cleared entries ").append(removedEntries$2).append(" and rewrote first entry ").append(updatedFirstEntry).append(" after ").append("truncating to start offset ").append(startOffset$1).append(", leaving ").append($this.epochs().size()).append(" in the cache.").toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$truncateFromStart$1(LeaderEpochFileCache $this, long startOffset$1, boolean flushIfTruncated$1) {
        void var5_4;
        EpochEntry removeFromStart_removeWhileMatching_entry;
        EpochEntry epochEntry;
        java.util.Iterator<Map.Entry<Object, EpochEntry>> removeFromStart_removeWhileMatching_iterator = $this.epochs().entrySet().iterator();
        ListBuffer removeFromStart_removeWhileMatching_removedEpochs = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (removeFromStart_removeWhileMatching_iterator.hasNext() && LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, epochEntry = (removeFromStart_removeWhileMatching_entry = removeFromStart_removeWhileMatching_iterator.next().getValue()))) {
            removeFromStart_removeWhileMatching_removedEpochs.$plus$eq((Object)removeFromStart_removeWhileMatching_entry);
            removeFromStart_removeWhileMatching_iterator.remove();
        }
        var5_4.lastOption().foreach(arg_0 -> LeaderEpochFileCache.$anonfun$truncateFromStart$3$adapted($this, startOffset$1, flushIfTruncated$1, (Seq)var5_4, arg_0));
    }

    public static final /* synthetic */ void $anonfun$maybeFlush$1(LeaderEpochFileCache $this) {
        if ($this._isDirty()) {
            $this.flush();
        }
    }

    public static final /* synthetic */ void $anonfun$clearAndFlush$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
        $this.flush();
    }

    public static final /* synthetic */ void $anonfun$clear$1(LeaderEpochFileCache $this) {
        $this.epochs().clear();
        $this._isDirty_$eq(true);
    }

    public static final /* synthetic */ LeaderEpochFileCache $anonfun$clone$1(LeaderEpochFileCache $this, LeaderEpochCheckpoint newCheckpoint$1) {
        newCheckpoint$1.write((Iterable<EpochEntry>)((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter($this.epochs().values()).asScala()));
        return new LeaderEpochFileCache($this.topicPartition, $this.logEndOffset, newCheckpoint$1);
    }

    public static final /* synthetic */ boolean $anonfun$snapshotForSegment$2(long endOffsetInclusive$1, EpochEntry e) {
        return e.startOffset() <= endOffsetInclusive$1;
    }

    /*
     * WARNING - void declaration
     */
    public LeaderEpochFileCache(TopicPartition topicPartition, Function0<Object> logEndOffset, LeaderEpochCheckpoint checkpoint) {
        void inWriteLock_lock;
        this.topicPartition = topicPartition;
        this.logEndOffset = logEndOffset;
        this.checkpoint = checkpoint;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(20).append("[LeaderEpochCache ").append(topicPartition).append("] ").toString());
        this.lock = new ReentrantReadWriteLock();
        this.epochs = new TreeMap();
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            LeaderEpochFileCache.$anonfun$new$1(this);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this._isDirty = false;
    }

    public static final /* synthetic */ Object $anonfun$maybeTruncateNonMonotonicEntries$1$adapted(EpochEntry newEntry$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$maybeTruncateNonMonotonicEntries$1(newEntry$1, entry));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromEnd$3$adapted(long endOffset$1, EpochEntry x$7) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromEnd$3(endOffset$1, x$7));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$2$adapted(long startOffset$1, EpochEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochFileCache.$anonfun$truncateFromStart$2(startOffset$1, entry));
    }

    public static final /* synthetic */ Object $anonfun$truncateFromStart$3$adapted(LeaderEpochFileCache $this, long startOffset$1, boolean flushIfTruncated$1, Seq removedEntries$2, EpochEntry firstBeforeStartOffset) {
        LeaderEpochFileCache.$anonfun$truncateFromStart$3($this, startOffset$1, flushIfTruncated$1, removedEntries$2, firstBeforeStartOffset);
        return BoxedUnit.UNIT;
    }
}

