/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.TenantHelpers;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.ZkMetadataCache$;
import kafka.server.ZkMetadataCache$MetadataSnapshot$;
import kafka.server.metadata.MetadataBroker;
import kafka.server.metadata.MetadataBroker$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\rb\u0001B&M\u0001EC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005O\")!\u000e\u0001C\u0001W\"9q\u000e\u0001b\u0001\n\u0013\u0001\bBB=\u0001A\u0003%\u0011\u000fC\u0004{\u0001\u0001\u0007I\u0011B>\t\u0013\t\u0005\u0004\u00011A\u0005\n\t\r\u0004b\u0002B7\u0001\u0001\u0006K\u0001 \u0005\n\u0005o\u0002!\u0019!C\u0005\u0005sB\u0001Ba\"\u0001A\u0003%!1\u0010\u0005\b\u0005\u0013\u0003A\u0011\u0002BF\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005cCqA!:\u0001\t\u0013\u00119\u000fC\u0004\u0003p\u0002!IA!=\t\u000f\tm\b\u0001\"\u0001\u0003~\"I11\u0004\u0001\u0012\u0002\u0013\u00051Q\u0004\u0005\n\u0007C\u0001\u0011\u0013!C\u0001\u0007;Aqaa\t\u0001\t\u0003\u0019)\u0003C\u0004\u0004.\u0001!\taa\f\t\u000f\r\r\u0002\u0001\"\u0003\u0004:!91Q\u0006\u0001\u0005\n\r}\u0002bBB#\u0001\u0011\u00051q\t\u0005\b\u0007\u0017\u0002A\u0011AB'\u0011\u001d\u0019y\u0006\u0001C\u0001\u0007CBqa!\u001a\u0001\t\u0003\u00199\u0007C\u0004\u0004r\u0001!\taa\u001d\t\u000f\r]\u0004\u0001\"\u0001\u0004z!91\u0011\u0011\u0001\u0005\u0002\r\r\u0005bBBG\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0007\u001f\u0003A\u0011ABI\u0011\u001d\u0019y\n\u0001C\u0001\u0007CCqa!/\u0001\t\u0003\u0019Y\fC\u0004\u0004:\u0002!\taa0\t\u000f\r\r\u0007\u0001\"\u0003\u0004F\"911\u001b\u0001\u0005\n\rUg\u0001\u0002@\u0001\u0001~D!\"!\u0004%\u0005+\u0007I\u0011AA\b\u0011)\t\t\b\nB\tB\u0003%\u0011\u0011\u0003\u0005\u000b\u0003g\"#Q3A\u0005\u0002\u0005U\u0004BCA@I\tE\t\u0015!\u0003\u0002x!Q\u0011\u0011\u0011\u0013\u0003\u0016\u0004%\t!a!\t\u0015\u0005MEE!E!\u0002\u0013\t)\t\u0003\u0006\u0002\u0016\u0012\u0012)\u001a!C\u0001\u0003/C!\"a(%\u0005#\u0005\u000b\u0011BAM\u0011)\t\t\u000b\nBK\u0002\u0013\u0005\u00111\u0015\u0005\u000b\u0003g##\u0011#Q\u0001\n\u0005\u0015\u0006BCA[I\tU\r\u0011\"\u0001\u00028\"Q\u00111\u001b\u0013\u0003\u0012\u0003\u0006I!!/\t\r)$C\u0011AAk\u0011%\t\u0019\u000fJA\u0001\n\u0003\t)\u000fC\u0005\u0002t\u0012\n\n\u0011\"\u0001\u0002v\"I!1\u0002\u0013\u0012\u0002\u0013\u0005!Q\u0002\u0005\n\u0005#!\u0013\u0013!C\u0001\u0005'A\u0011Ba\u0006%#\u0003%\tA!\u0007\t\u0013\tuA%%A\u0005\u0002\t}\u0001\"\u0003B\u0012IE\u0005I\u0011\u0001B\u0013\u0011%\u0011I\u0003JA\u0001\n\u0003\u0012Y\u0003C\u0005\u00032\u0011\n\t\u0011\"\u0001\u00034!I!Q\u0007\u0013\u0002\u0002\u0013\u0005!q\u0007\u0005\n\u0005\u0007\"\u0013\u0011!C!\u0005\u000bB\u0011B!\u0014%\u0003\u0003%\tAa\u0014\t\u0013\tMC%!A\u0005B\tU\u0003\"\u0003B,I\u0005\u0005I\u0011\tB-\u0011%\u0011Y\u0006JA\u0001\n\u0003\u0012ifB\u0005\u0004f\u0002\t\t\u0011#\u0001\u0004h\u001aAa\u0010AA\u0001\u0012\u0003\u0019I\u000f\u0003\u0004k\u0005\u0012\u00051q\u001f\u0005\n\u0005/\u0012\u0015\u0011!C#\u00053B\u0011b!?C\u0003\u0003%\tia?\t\u0013\u0011%!)!A\u0005\u0002\u0012-q!\u0003C\r\u0019\u0006\u0005\t\u0012\u0001C\u000e\r!YE*!A\t\u0002\u0011u\u0001B\u00026I\t\u0003!y\u0002C\u0005\u0005\"!\u000b\n\u0011\"\u0001\u0004\u001e\ty!l['fi\u0006$\u0017\r^1DC\u000eDWM\u0003\u0002N\u001d\u000611/\u001a:wKJT\u0011aT\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001!\u000b\u0017/\u0011\u0005M3V\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\r\u0005s\u0017PU3g!\tI&,D\u0001M\u0013\tYFJA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?:\u000bQ!\u001e;jYNL!!\u00190\u0003\u000f1{wmZ5oO\u0006A!M]8lKJLE\r\u0005\u0002TI&\u0011Q\r\u0016\u0002\u0004\u0013:$\u0018!D5t\u001bVdG/\u001b+f]\u0006tG\u000f\u0005\u0002TQ&\u0011\u0011\u000e\u0016\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0019A.\u001c8\u0011\u0005e\u0003\u0001\"\u00022\u0004\u0001\u0004\u0019\u0007b\u00024\u0004!\u0003\u0005\raZ\u0001\u0016a\u0006\u0014H/\u001b;j_:lU\r^1eCR\fGj\\2l+\u0005\t\bC\u0001:x\u001b\u0005\u0019(B\u0001;v\u0003\u0011a\u0017M\\4\u000b\u0003Y\fAA[1wC&\u0011\u0001p\u001d\u0002\u0007\u001f\nTWm\u0019;\u0002-A\f'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\rT8dW\u0002\n\u0001#\\3uC\u0012\fG/Y*oCB\u001c\bn\u001c;\u0016\u0003q\u0004\"! \u0013\u000e\u0003\u0001\u0011\u0001#T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;\u0014\r\u0011\u0012\u0016\u0011AA\u0004!\r\u0019\u00161A\u0005\u0004\u0003\u000b!&a\u0002)s_\u0012,8\r\u001e\t\u0004'\u0006%\u0011bAA\u0006)\na1+\u001a:jC2L'0\u00192mK\u0006y\u0001/\u0019:uSRLwN\\*uCR,7/\u0006\u0002\u0002\u0012AA\u00111CA\u000f\u0003C\t9$\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u001diW\u000f^1cY\u0016T1!a\u0007U\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\t)BA\u0005B]f\u0014VMZ'baB!\u00111EA\u0019\u001d\u0011\t)#!\f\u0011\u0007\u0005\u001dB+\u0004\u0002\u0002*)\u0019\u00111\u0006)\u0002\rq\u0012xn\u001c;?\u0013\r\ty\u0003V\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0012Q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=B\u000b\u0005\u0004\u0002\u0014\u0005e\u0012QH\u0005\u0005\u0003w\t)BA\u0004M_:<W*\u00199\u0011\t\u0005}\u00121\u000e\b\u0005\u0003\u0003\n)G\u0004\u0003\u0002D\u0005}c\u0002BA#\u00033rA!a\u0012\u0002V9!\u0011\u0011JA(\u001d\u0011\t9#a\u0013\n\u0005\u00055\u0013aA8sO&!\u0011\u0011KA*\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QJ\u0005\u0004\u001f\u0006]#\u0002BA)\u0003'JA!a\u0017\u0002^\u000511m\\7n_:T1aTA,\u0013\u0011\t\t'a\u0019\u0002\u000f5,7o]1hK*!\u00111LA/\u0013\u0011\t9'!\u001b\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0005\u0003C\n\u0019'\u0003\u0003\u0002n\u0005=$\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0003O\nI'\u0001\tqCJ$\u0018\u000e^5p]N#\u0018\r^3tA\u0005qAo\u001c9jGN\u0014\u0015\u0010V3oC:$XCAA<!!\t\u0019\"!\b\u0002\"\u0005e\u0004CBA\n\u0003w\n\t#\u0003\u0003\u0002~\u0005U!a\u0002%bg\"\u001cV\r^\u0001\u0010i>\u0004\u0018nY:CsR+g.\u00198uA\u0005AAo\u001c9jG&#7/\u0006\u0002\u0002\u0006BA\u00111EAD\u0003C\tY)\u0003\u0003\u0002\n\u0006U\"aA'baB!\u0011QRAH\u001b\t\t\u0019'\u0003\u0003\u0002\u0012\u0006\r$\u0001B+vS\u0012\f\u0011\u0002^8qS\u000eLEm\u001d\u0011\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0005\u0005e\u0005\u0003B*\u0002\u001c\u000eL1!!(U\u0005\u0019y\u0005\u000f^5p]\u0006i1m\u001c8ue>dG.\u001a:JI\u0002\nA\"\u00197jm\u0016\u0014%o\\6feN,\"!!*\u0011\r\u0005M\u0011\u0011HAT!\u0011\tI+a,\u000e\u0005\u0005-&bAAW\u001d\u000691\r\\;ti\u0016\u0014\u0018\u0002BAY\u0003W\u0013aA\u0011:pW\u0016\u0014\u0018!D1mSZ,'I]8lKJ\u001c\b%\u0001\u0006bY&4XMT8eKN,\"!!/\u0011\r\u0005M\u0011\u0011HA^!!\ti,a0\u0002B\u00065WBAA\r\u0013\u0011\tI)!\u0007\u0011\t\u0005\r\u0017\u0011Z\u0007\u0003\u0003\u000bTA!a2\u0002d\u00059a.\u001a;x_J\\\u0017\u0002BAf\u0003\u000b\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016\u0004B!!$\u0002P&!\u0011\u0011[A2\u0005\u0011qu\u000eZ3\u0002\u0017\u0005d\u0017N^3O_\u0012,7\u000f\t\u000b\u000ey\u0006]\u0017\u0011\\An\u0003;\fy.!9\t\u000f\u00055\u0011\u00071\u0001\u0002\u0012!9\u00111O\u0019A\u0002\u0005]\u0004bBAAc\u0001\u0007\u0011Q\u0011\u0005\b\u0003+\u000b\u0004\u0019AAM\u0011\u001d\t\t+\ra\u0001\u0003KCq!!.2\u0001\u0004\tI,\u0001\u0003d_BLH#\u0004?\u0002h\u0006%\u00181^Aw\u0003_\f\t\u0010C\u0005\u0002\u000eI\u0002\n\u00111\u0001\u0002\u0012!I\u00111\u000f\u001a\u0011\u0002\u0003\u0007\u0011q\u000f\u0005\n\u0003\u0003\u0013\u0004\u0013!a\u0001\u0003\u000bC\u0011\"!&3!\u0003\u0005\r!!'\t\u0013\u0005\u0005&\u0007%AA\u0002\u0005\u0015\u0006\"CA[eA\u0005\t\u0019AA]\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a>+\t\u0005E\u0011\u0011`\u0016\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!A\u0005v]\u000eDWmY6fI*\u0019!Q\u0001+\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\n\u0005}(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\bU\u0011\t9(!?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0003\u0016\u0005\u0003\u000b\u000bI0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tm!\u0006BAM\u0003s\fabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0003\")\"\u0011QUA}\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"Aa\n+\t\u0005e\u0016\u0011`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t5\u0002c\u0001:\u00030%\u0019\u00111G:\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003\r\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003:\t}\u0002cA*\u0003<%\u0019!Q\b+\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003Bm\n\t\u00111\u0001d\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\t\t\u0007\u0003{\u0013IE!\u000f\n\t\t-\u0013\u0011\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002h\u0005#B\u0011B!\u0011>\u0003\u0003\u0005\rA!\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012aY\u0001\ti>\u001cFO]5oOR\u0011!QF\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u001d\u0014y\u0006C\u0005\u0003B\u0001\u000b\t\u00111\u0001\u0003:\u0005!R.\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^0%KF$BA!\u001a\u0003lA\u00191Ka\u001a\n\u0007\t%DK\u0001\u0003V]&$\b\u0002\u0003B!\u000f\u0005\u0005\t\u0019\u0001?\u0002#5,G/\u00193bi\u0006\u001cf.\u00199tQ>$\b\u0005K\u0002\t\u0005c\u00022a\u0015B:\u0013\r\u0011)\b\u0016\u0002\tm>d\u0017\r^5mK\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0005\tm\u0004\u0003\u0002B?\u0005\u0007k!Aa \u000b\u0007\t\u0005e*\u0001\u0006d_:$(o\u001c7mKJLAA!\"\u0003\u0000\t\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000fI\u0001\u0019[\u0006L(-\u001a$jYR,'/\u00117jm\u0016\u0014V\r\u001d7jG\u0006\u001cHC\u0003BG\u0005?\u0013\u0019Ka*\u0003,B1!q\u0012BK\u00053k!A!%\u000b\u0007\tMU/\u0001\u0003vi&d\u0017\u0002\u0002BL\u0005#\u0013A\u0001T5tiB\u0019!Oa'\n\u0007\tu5OA\u0004J]R,w-\u001a:\t\r\t\u00056\u00021\u0001}\u0003!\u0019h.\u00199tQ>$\bb\u0002BS\u0017\u0001\u0007!QR\u0001\bEJ|7.\u001a:t\u0011\u001d\u0011Ik\u0003a\u0001\u0003\u0003\fA\u0002\\5ti\u0016tWM\u001d(b[\u0016DaA!,\f\u0001\u00049\u0017A\u00074jYR,'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\u0018\u0001F4fiB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0007\u00034\nU'q\u001bBn\u0005;\u0014\t\u000fE\u0003T\u00037\u0013)\f\u0005\u0004\u00038\n\u0005'q\u0019\b\u0005\u0005s\u0013iL\u0004\u0003\u0002(\tm\u0016\"A+\n\u0007\t}F+A\u0004qC\u000e\\\u0017mZ3\n\t\t\r'Q\u0019\u0002\t\u0013R,'/\u00192mK*\u0019!q\u0018+\u0011\t\t%'q\u001a\b\u0005\u0003\u0003\u0012Y-\u0003\u0003\u0003N\u0006%\u0014\u0001F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0003R\nM'!G'fi\u0006$\u0017\r^1SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:TAA!4\u0002j!1!\u0011\u0015\u0007A\u0002qDqA!7\r\u0001\u0004\t\t#A\u0003u_BL7\rC\u0004\u0003*2\u0001\r!!1\t\r\t}G\u00021\u0001h\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\r\t\rH\u00021\u0001h\u0003e)'O]8s+:\fg/Y5mC\ndW\rT5ti\u0016tWM]:\u0002!!\f7/\u00117jm\u0016,e\u000e\u001a9pS:$HcB4\u0003j\n-(Q\u001e\u0005\u0007\u0005Ck\u0001\u0019\u0001?\t\u000b\tl\u0001\u0019A2\t\u000f\t%V\u00021\u0001\u0002B\u0006\u0001r-\u001a;BY&4X-\u00128ea>Lg\u000e\u001e\u000b\t\u0005g\u0014)Pa>\u0003zB)1+a'\u0002N\"1!\u0011\u0015\bA\u0002qDQA\u0019\bA\u0002\rDqA!+\u000f\u0001\u0004\t\t-\u0001\thKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCRQ!q`B\u0006\u0007+\u00199b!\u0007\u0011\r\u0005u6\u0011AB\u0003\u0013\u0011\u0019\u0019!!\u0007\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003J\u000e\u001d\u0011\u0002BB\u0005\u0005'\u0014Q#T3uC\u0012\fG/\u0019*fgB|gn]3U_BL7\rC\u0004\u0004\u000e=\u0001\raa\u0004\u0002\rQ|\u0007/[2t!\u0019\til!\u0005\u0002\"%!11CA\r\u0005\r\u0019V\r\u001e\u0005\b\u0005S{\u0001\u0019AAa\u0011!\u0011yn\u0004I\u0001\u0002\u00049\u0007\u0002\u0003Br\u001fA\u0005\t\u0019A4\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r}!fA4\u0002z\u0006Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u0005aq-\u001a;BY2$v\u000e]5dgR!1qBB\u0014\u0011\u001d\u0019IC\u0005a\u0001\u0007W\tq\u0002^3oC:$\bK]3gSb|\u0005\u000f\u001e\t\u0006'\u0006m\u0015\u0011E\u0001\u0011O\u0016$\u0018\t\u001c7QCJ$\u0018\u000e^5p]N$\"a!\r\u0011\r\u0005u6\u0011CB\u001a!\u0011\tii!\u000e\n\t\r]\u00121\r\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o)\u0019\u0019yaa\u000f\u0004>!1!\u0011\u0015\u000bA\u0002qDqa!\u000b\u0015\u0001\u0004\u0019Y\u0003\u0006\u0003\u0004B\r\r\u0003\u0003CA\u0012\u0003\u000f\u001b\u0019$!\u0010\t\r\t\u0005V\u00031\u0001}\u0003Q9W\r\u001e(p]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dgR!1qBB%\u0011\u001d\u0019iA\u0006a\u0001\u0007\u001f\tabZ3u\u00032Lg/\u001a\"s_.,'\u000f\u0006\u0003\u0004P\ru\u0003#B*\u0002\u001c\u000eE\u0003\u0003BB*\u00073j!a!\u0016\u000b\u0007\r]C*\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\u0019Yf!\u0016\u0003\u001d5+G/\u00193bi\u0006\u0014%o\\6fe\")!m\u0006a\u0001G\u0006yq-\u001a;BY&4XM\u0011:pW\u0016\u00148/\u0006\u0002\u0004dA1\u0011QXB\u0001\u0007#\n\u0001cZ3u!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\r\r%41NB7!\u0015\u0019\u00161TA\u001f\u0011\u001d\u0011I.\u0007a\u0001\u0003CAaaa\u001c\u001a\u0001\u0004\u0019\u0017a\u00039beRLG/[8o\u0013\u0012\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001cH\u0003BAM\u0007kBqA!7\u001b\u0001\u0004\t\t#\u0001\u000ehKR\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0005\u0003t\u000em4QPB@\u0011\u001d\u0011In\u0007a\u0001\u0003CAaaa\u001c\u001c\u0001\u0004\u0019\u0007b\u0002BU7\u0001\u0007\u0011\u0011Y\u0001\u001dO\u0016$\b+\u0019:uSRLwN\u001c*fa2L7-Y#oIB|\u0017N\u001c;t)\u0019\u0019)ia\"\u0004\fB9\u00111EADG\u00065\u0007bBBE9\u0001\u000711G\u0001\u0003iBDqA!+\u001d\u0001\u0004\t\t-A\bhKR\u001cuN\u001c;s_2dWM]%e\u0003I9W\r^\"mkN$XM]'fi\u0006$\u0017\r^1\u0015\r\rM5\u0011TBO!\u0011\tii!&\n\t\r]\u00151\r\u0002\b\u00072,8\u000f^3s\u0011\u001d\u0019YJ\ba\u0001\u0003C\t\u0011b\u00197vgR,'/\u00133\t\u000f\t%f\u00041\u0001\u0002B\u0006qQ\u000f\u001d3bi\u0016lU\r^1eCR\fGCBBR\u0007K\u001bI\u000b\u0005\u0004\u0002>\u000e\u000511\u0007\u0005\u0007\u0007O{\u0002\u0019A2\u0002\u001b\r|'O]3mCRLwN\\%e\u0011\u001d\u0019Yk\ba\u0001\u0007[\u000bQ#\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\u0005\u0003\u00040\u000eUVBABY\u0015\u0011\u0019\u0019,a\u0019\u0002\u0011I,\u0017/^3tiNLAaa.\u00042\n)R\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\u0018\u0001C2p]R\f\u0017N\\:\u0015\u0007\u001d\u001ci\fC\u0004\u0003Z\u0002\u0002\r!!\t\u0015\u0007\u001d\u001c\t\rC\u0004\u0004\n\u0006\u0002\raa\r\u00021\u0005$Gm\u0014:Va\u0012\fG/\u001a)beRLG/[8o\u0013:4w\u000e\u0006\u0007\u0003f\r\u001d7\u0011ZBf\u0007\u001b\u001cy\rC\u0004\u0002\u000e\t\u0002\r!!\u0005\t\u000f\u0005M$\u00051\u0001\u0002x!9!\u0011\u001c\u0012A\u0002\u0005\u0005\u0002BBB8E\u0001\u00071\rC\u0004\u0004R\n\u0002\r!!\u0010\u0002\u0013M$\u0018\r^3J]\u001a|\u0017a\u0005:f[>4X\rU1si&$\u0018n\u001c8J]\u001a|G\u0003\u0004B3\u0007/\u001cIna7\u0004b\u000e\r\bbBA\u0007G\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003g\u001a\u0003\u0019AA<\u0011\u001d\t\ti\ta\u0001\u0007;\u0004\u0002\"a\u0005\u0004`\u0006\u0005\u00121R\u0005\u0005\u0003\u0013\u000b)\u0002C\u0004\u0003Z\u000e\u0002\r!!\t\t\r\r=4\u00051\u0001d\u0003AiU\r^1eCR\f7K\\1qg\"|G\u000f\u0005\u0002~\u0005N)!ia;\u0002\bA\t2Q^Bz\u0003#\t9(!\"\u0002\u001a\u0006\u0015\u0016\u0011\u0018?\u000e\u0005\r=(bABy)\u00069!/\u001e8uS6,\u0017\u0002BB{\u0007_\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87)\t\u00199/A\u0003baBd\u0017\u0010F\u0007}\u0007{\u001cy\u0010\"\u0001\u0005\u0004\u0011\u0015Aq\u0001\u0005\b\u0003\u001b)\u0005\u0019AA\t\u0011\u001d\t\u0019(\u0012a\u0001\u0003oBq!!!F\u0001\u0004\t)\tC\u0004\u0002\u0016\u0016\u0003\r!!'\t\u000f\u0005\u0005V\t1\u0001\u0002&\"9\u0011QW#A\u0002\u0005e\u0016aB;oCB\u0004H.\u001f\u000b\u0005\t\u001b!)\u0002E\u0003T\u00037#y\u0001E\bT\t#\t\t\"a\u001e\u0002\u0006\u0006e\u0015QUA]\u0013\r!\u0019\u0002\u0016\u0002\u0007)V\u0004H.\u001a\u001c\t\u0011\u0011]a)!AA\u0002q\f1\u0001\u001f\u00131\u0003=Q6.T3uC\u0012\fG/Y\"bG\",\u0007CA-I'\tA%\u000b\u0006\u0002\u0005\u001c\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\u0002")
public class ZkMetadataCache
implements MetadataCache,
Logging {
    private volatile ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final boolean isMultiTenant;
    private final Object partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return ZkMetadataCache$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Object partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(scala.math.package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(brokers).asScala()).foreach((Function1 & Serializable & scala.Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            if (x0$1 == null) throw new MatchError(null);
            long partitionId = x0$1._1$mcJ$sp();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.leader();
            int leaderEpoch = partitionState.leaderEpoch();
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            List replicas = partitionState.replicas();
            List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
            List isr = partitionState.isr();
            List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
            List offlineReplicas = partitionState.offlineReplicas();
            List observers = partitionState.observers();
            List<Integer> filteredObservers = this.maybeFilterAliveReplicas(snapshot, observers, listenerName, errorUnavailableEndpoints);
            if (None$.MODULE$.equals(maybeLeader)) {
                Errors errors2;
                if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors2 = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(leaderBrokerId).toString());
                    errors2 = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors2;
                return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
            }
            if (!(maybeLeader instanceof Some)) throw new MatchError(maybeLeader);
            if (filteredReplicas.size() < replicas.size()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else if (filteredIsr.size() < isr.size()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(isr).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else {
                errors = Errors.NONE;
            }
            Errors error = errors;
            return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions((List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        if (!this.isMultiTenant && tenantPrefixOpt.isDefined()) {
            throw new IllegalStateException("Multi-tenant getAllTopics but metadataCache is not multitenant. Multitenant interceptor and multitenant metadata must always be configured together in a multitenant broker.");
        }
        return this.getAllTopics(this.metadataSnapshot(), tenantPrefixOpt);
    }

    @Override
    public Set<TopicPartition> getAllPartitions() {
        return ((TraversableOnce)this.metadataSnapshot().partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topicName = (String)x0$1._1();
            Iterable iterable = (Iterable)((LongMap)x0$1._2()).keys().map((Function1 & Serializable & scala.Serializable)partitionId -> ZkMetadataCache.$anonfun$getAllPartitions$2(topicName, BoxesRunTime.unboxToLong((Object)partitionId)), scala.collection.Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot, Option<String> tenantPrefixOpt) {
        Set set;
        if (tenantPrefixOpt instanceof Some) {
            String tenantPrefix = (String)((Some)tenantPrefixOpt).value();
            set = (Set)snapshot.topicsByTenant().getOrElse((Object)tenantPrefix, (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty());
        } else if (None$.MODULE$.equals(tenantPrefixOpt)) {
            set = snapshot.partitionStates().keySet();
        } else {
            throw new MatchError(tenantPrefixOpt);
        }
        return set;
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                long partition = x0$2._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Set<String> getNonExistingTopics(Set<String> topics) {
        return topics.diff((GenSet)this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public Option<MetadataBroker> getAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId).map((Function1 & Serializable & scala.Serializable)broker -> MetadataBroker$.MODULE$.apply((Broker)broker));
    }

    @Override
    public Seq<MetadataBroker> getAliveBrokers() {
        return ((TraversableOnce)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable & scala.Serializable)broker -> MetadataBroker$.MODULE$.apply((Broker)broker), scala.collection.Iterable$.MODULE$.canBuildFrom())).toBuffer();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((long)partitionId)).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                node = (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get((long)tp.partition())).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicaIds).asScala()).map((Function1 & Serializable & scala.Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = (LongMap)snapshot.aliveNodes().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long id = x0$1._1$mcJ$sp();
            Map nodesByListener = (Map)x0$1._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(nodesByListener.get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node)));
            return iterable;
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((TraversableLike)this.getAllPartitions(snapshot).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$4(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$3._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
            PartitionInfo partitionInfo = PartitionInfo.of((String)tp.topic(), (int)tp.partition(), (Node)ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))), (Node[])((Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.observers()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))), (Node[])((Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))), (Node[])((Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))));
            return partitionInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot, (Option<String>)None$.MODULE$).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$10(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        Object object = this.partitionMetadataLock();
        synchronized (object) {
            void var10_10;
            LongMap aliveBrokers = new LongMap(this.metadataSnapshot().aliveBrokers().size());
            LongMap aliveNodes = new LongMap(this.metadataSnapshot().aliveNodes().size());
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            None$ controllerIdOpt = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
            updateMetadataRequest.liveBrokers().forEach(broker -> {
                HashMap nodes = new HashMap();
                ArrayBuffer endPoints = new ArrayBuffer();
                java.util.Map tags = UpdateMetadataRequest.tagMapFromBrokerTagCollection((List)broker.tags());
                broker.endpoints().forEach(ep -> {
                    ListenerName listenerName = new ListenerName(ep.listener());
                    endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                    nodes.put(listenerName, new ConfluentNode(broker.id(), ep.host(), ep.port(), broker.rack(), tags));
                });
                aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack()), (scala.collection.immutable.Map<String, String>)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(tags).asScala()).toMap(Predef$.MODULE$.$conforms())));
                aliveNodes.update((long)broker.id(), CollectionConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
            });
            aliveNodes.get((long)this.brokerId).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
                ZkMetadataCache.$anonfun$updateMetadata$3(this, aliveNodes, listenerMap);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Map newTopicIds = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.topicStates()).asScala()).map((Function1 & Serializable & scala.Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$7(x$9)))).toMap(Predef$.MODULE$.$conforms());
            scala.collection.mutable.Map topicIds = Map$.MODULE$.empty();
            topicIds.$plus$plus$eq(this.metadataSnapshot().topicIds());
            topicIds.$plus$plus$eq((TraversableOnce)newTopicIds);
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            if (!updateMetadataRequest.partitionStates().iterator().hasNext()) {
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, this.metadataSnapshot().partitionStates(), this.metadataSnapshot().topicsByTenant(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
            } else {
                void forKeyValue$extension_f;
                void forKeyValue$extension_$this;
                void forKeyValue$extension_f2;
                void forKeyValue$extension_$this2;
                AnyRefMap partitionStates = new AnyRefMap(this.metadataSnapshot().partitionStates().size());
                Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topic, partitions) -> {
                    partitionStates.update((Object)topic, (Object)partitions.clone());
                    return BoxedUnit.UNIT;
                };
                Map<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods(this.metadataSnapshot().partitionStates());
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this2), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f2, arg_0, arg_1));
                AnyRefMap topicsByTenant = new AnyRefMap(this.metadataSnapshot().topicsByTenant().size());
                Function2 & Serializable & scala.Serializable intersect2 = (Function2 & Serializable & scala.Serializable)(tenantPrefix, topics) -> {
                    topicsByTenant.update((Object)tenantPrefix, (Object)topics.clone());
                    return BoxedUnit.UNIT;
                };
                Map<String, HashSet<String>> map2 = Implicits$.MODULE$.MapExtensionMethods(this.metadataSnapshot().topicsByTenant());
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
                boolean traceEnabled = this.stateChangeLogger().isTraceEnabled();
                int controllerId = updateMetadataRequest.controllerId();
                int controllerEpoch = updateMetadataRequest.controllerEpoch();
                Iterable newStates = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala();
                newStates.foreach((Function1 & Serializable & scala.Serializable)state -> {
                    TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                    if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (AnyRefMap<String, HashSet<String>>)topicsByTenant, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                        if (traceEnabled) {
                            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString());
                        }
                        return deletedPartitions.$plus$eq((Object)tp);
                    }
                    this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (AnyRefMap<String, HashSet<String>>)topicsByTenant, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                    if (traceEnabled) {
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
                this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString());
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (AnyRefMap<String, HashSet<String>>)topicsByTenant, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
            }
            return var10_10;
        }
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        String tenantPrefix;
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
        if (this.isMultiTenant && (tenantPrefix = TenantHelpers.extractTenantPrefix(topic)) != null) {
            ((HashSet)topicsByTenant.getOrElseUpdate((Object)tenantPrefix, (Function0 & Serializable & scala.Serializable)() -> HashSet$.MODULE$.empty())).add((Object)topic);
            return;
        }
    }

    private void removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        partitionStates.get((Object)topic).foreach((Function1 & Serializable & scala.Serializable)infos -> {
            ZkMetadataCache.$anonfun$removePartitionInfo$1(this, partitionId, partitionStates, topic, topicIds, topicsByTenant, infos);
            return BoxedUnit.UNIT;
        });
    }

    private final void MetadataSnapshot$lzycompute$1() {
        synchronized (this) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new ZkMetadataCache$MetadataSnapshot$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ TopicPartition $anonfun$getAllPartitions$2(String topicName$1, long partitionId) {
        return new TopicPartition(topicName$1, (int)partitionId);
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair == null) {
            throw new MatchError(null);
        }
        boolean bl = !((Node)pair._2()).isEmpty();
        return bl;
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable & scala.Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$10(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$4(Set listeners$1, Map x$8) {
        Set set = x$8.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$3(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$4(listeners, x$8)))) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$7(Tuple2 x$9) {
        Object object = x$9._2();
        Uuid uuid = Uuid.ZERO_UUID;
        return object == null ? uuid != null : !object.equals(uuid);
    }

    public static final /* synthetic */ void $anonfun$removePartitionInfo$1(ZkMetadataCache $this, int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, AnyRefMap topicsByTenant$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            String tenantPrefix;
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
            if ($this.isMultiTenant && (tenantPrefix = TenantHelpers.extractTenantPrefix(topic$4)) != null) {
                topicsByTenant$2.get((Object)tenantPrefix).foreach((Function1 & Serializable & scala.Serializable)topics -> {
                    topics.remove((Object)topic$4);
                    if (topics.isEmpty()) {
                        return topicsByTenant$2.remove((Object)tenantPrefix);
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public ZkMetadataCache(int brokerId, boolean isMultiTenant) {
        this.brokerId = brokerId;
        this.isMultiTenant = isMultiTenant;
        Logging.$init$(this);
        this.partitionMetadataLock = new Object();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (AnyRefMap<String, HashSet<String>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    scala.Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final AnyRefMap<String, HashSet<String>> topicsByTenant;
        private final scala.collection.immutable.Map<String, Uuid> topicIds;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ ZkMetadataCache $outer;

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public AnyRefMap<String, HashSet<String>> topicsByTenant() {
            return this.topicsByTenant;
        }

        public scala.collection.immutable.Map<String, Uuid> topicIds() {
            return this.topicIds;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer(), partitionStates, topicsByTenant, topicIds, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public AnyRefMap<String, HashSet<String>> copy$default$2() {
            return this.topicsByTenant();
        }

        public scala.collection.immutable.Map<String, Uuid> copy$default$3() {
            return this.topicIds();
        }

        public Option<Object> copy$default$4() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$5() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$6() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partitionStates();
                }
                case 1: {
                    return this.topicsByTenant();
                }
                case 2: {
                    return this.topicIds();
                }
                case 3: {
                    return this.controllerId();
                }
                case 4: {
                    return this.aliveBrokers();
                }
                case 5: {
                    return this.aliveNodes();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)x$1).kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            AnyRefMap<String, HashSet<String>> anyRefMap3 = this.topicsByTenant();
            AnyRefMap<String, HashSet<String>> anyRefMap4 = metadataSnapshot.topicsByTenant();
            if (anyRefMap3 == null) {
                if (anyRefMap4 != null) {
                    return false;
                }
            } else if (!anyRefMap3.equals(anyRefMap4)) return false;
            scala.collection.immutable.Map<String, Uuid> map = this.topicIds();
            scala.collection.immutable.Map<String, Uuid> map2 = metadataSnapshot.topicIds();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ZkMetadataCache kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(ZkMetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.topicsByTenant = topicsByTenant;
            this.topicIds = topicIds;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

