/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.SocketServer$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RequestQueueSizePercentiles$ {
    public static RequestQueueSizePercentiles$ MODULE$;
    private final String MetricGroup;
    private final String PercentileNamePrefix;
    private final int Buckets;
    private final Map<String, String> Tags;
    private final Map<String, Object> percentileSuffixToValue;

    static {
        new RequestQueueSizePercentiles$();
    }

    private String MetricGroup() {
        return this.MetricGroup;
    }

    private String PercentileNamePrefix() {
        return this.PercentileNamePrefix;
    }

    private int Buckets() {
        return this.Buckets;
    }

    private Map<String, String> Tags() {
        return this.Tags;
    }

    private Map<String, Object> percentileSuffixToValue() {
        return this.percentileSuffixToValue;
    }

    public Percentiles createPercentiles(Metrics metrics, int queueSize, String metricNamePrefix) {
        String prefix = metricNamePrefix.concat(this.PercentileNamePrefix());
        List percentiles = ((TraversableOnce)this.percentileSuffixToValue().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String suffix = (String)x0$1._1();
            double value = x0$1._2$mcD$sp();
            Percentile percentile = new Percentile(MODULE$.queueSizeMetricName(metrics, new StringBuilder(0).append(prefix).append(suffix).toString()), value);
            return percentile;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        return new Percentiles(this.Buckets() * 4, 0.0, (double)queueSize, Percentiles.BucketSizing.CONSTANT, (Percentile[])percentiles.toArray(ClassTag$.MODULE$.apply(Percentile.class)));
    }

    public double dataPlaneQueueSize(Metrics metrics, String percentileSuffix) {
        String name = SocketServer$.MODULE$.DataPlaneMetricPrefix().concat(this.PercentileNamePrefix()).concat(percentileSuffix);
        Option metricOpt = Option$.MODULE$.apply((Object)metrics.metric(this.queueSizeMetricName(metrics, name)));
        double d = metricOpt instanceof Some ? BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((Some)metricOpt).value()).metricValue()) : 0.0;
        return d;
    }

    public boolean valid(String suffix) {
        return this.percentileSuffixToValue().keySet().contains((Object)suffix);
    }

    private MetricName queueSizeMetricName(Metrics metrics, String name) {
        return metrics.metricName(name, this.MetricGroup(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.Tags()).asJava());
    }

    private RequestQueueSizePercentiles$() {
        MODULE$ = this;
        this.MetricGroup = "request-queue-metrics";
        this.PercentileNamePrefix = "request-queue-size-";
        this.Buckets = 1000;
        this.Tags = Predef$.MODULE$.Map().empty();
        this.percentileSuffixToValue = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p90"), (Object)BoxesRunTime.boxToDouble((double)90.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p95"), (Object)BoxesRunTime.boxToDouble((double)95.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p98"), (Object)BoxesRunTime.boxToDouble((double)98.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p99"), (Object)BoxesRunTime.boxToDouble((double)99.0))}));
    }
}

