/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.server.ControllerMutationQuota;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper$;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\ter!\u0002\r\u001a\u0011\u0003qb!\u0002\u0011\u001a\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\"\u00022\u0002\t\u0003\u0019g\u0001\u0002\u0011\u001a\u0001mD!\"!\u0002\u0006\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011)\t\u0019\"\u0002B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003W)!\u0011!Q\u0001\n\u00055\u0002\"CA\u001c\u000b\t\u0005\t\u0015!\u0003e\u0011\u0019AS\u0001\"\u0001\u0002:!9\u0011QI\u0003\u0005\u0002\u0005\u001d\u0003bBA3\u000b\u0011\u0005\u0011q\r\u0005\b\u0003k*A\u0011AA<\u0011\u001d\tY)\u0002C\u0001\u0003\u001bCq!!&\u0006\t\u0003\t9\nC\u0004\u0002\u001c\u0016!\t!!(\t\u000f\u00055V\u0001\"\u0001\u00020\"I\u0011qY\u0003\u0012\u0002\u0013\u0005\u0011\u0011\u001a\u0005\b\u0003?,A\u0011AAq\u0011\u001d\tY/\u0002C\u0001\u0003[Dq!a=\u0006\t\u0003\t)\u0010C\u0004\u0002z\u0016!\t!a?\t\u000f\t-R\u0001\"\u0001\u0003.\u0005!\"+Z9vKN$\b*\u00198eY\u0016\u0014\b*\u001a7qKJT!AG\u000e\u0002\rM,'O^3s\u0015\u0005a\u0012!B6bM.\f7\u0001\u0001\t\u0003?\u0005i\u0011!\u0007\u0002\u0015%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0011\u0016d\u0007/\u001a:\u0014\u0005\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=\u0005\u0011rN\u001c'fC\u0012,'o\u001d5ja\u000eC\u0017M\\4f)\u0019as&O!MAB\u00111%L\u0005\u0003]\u0011\u0012A!\u00168ji\")\u0001g\u0001a\u0001c\u0005\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0003e]j\u0011a\r\u0006\u0003iU\nQa\u001a:pkBT!AN\u000e\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0003qM\u0012\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\t\u000bi\u001a\u0001\u0019A\u001e\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB\u0011AhP\u0007\u0002{)\u0011a(N\u0001\fiJ\fgn]1di&|g.\u0003\u0002A{\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'\u000fC\u0003C\u0007\u0001\u00071)A\u0012uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014x\n\u001d;\u0011\u0007\r\"e)\u0003\u0002FI\t1q\n\u001d;j_:\u0004\"a\u0012&\u000e\u0003!S!!S\u000e\u0002\tQLWM]\u0005\u0003\u0017\"\u0013\u0001\u0005V5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;pe\")Qj\u0001a\u0001\u001d\u0006qQ\u000f\u001d3bi\u0016$G*Z1eKJ\u001c\bcA(X5:\u0011\u0001+\u0016\b\u0003#Rk\u0011A\u0015\u0006\u0003'v\ta\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005Y#\u0013a\u00029bG.\fw-Z\u0005\u00031f\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003-\u0012\u0002\"a\u00170\u000e\u0003qS!!X\u000e\u0002\u000f\rdWo\u001d;fe&\u0011q\f\u0018\u0002\n!\u0006\u0014H/\u001b;j_:DQ!Y\u0002A\u00029\u000b\u0001#\u001e9eCR,GMR8mY><XM]:\u0002/I|W\u000f^5oOB\u000bG\u000f\u001b)sK\u001aL\u0007p\u0014:Ok2dGC\u00013m!\t)\u0017N\u0004\u0002gOB\u0011\u0011\u000bJ\u0005\u0003Q\u0012\na\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000e\n\u0005\u0006[\u0012\u0001\rA\\\u0001\bG>tG/\u001a=u!\ty\u00170D\u0001q\u0015\t\t(/\u0001\u0005sKF,Xm\u001d;t\u0015\t\u0019H/\u0001\u0004d_6lwN\u001c\u0006\u00039UT!A^<\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0018aA8sO&\u0011!\u0010\u001d\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u'\r)!\u0005 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}\\\u0012!B;uS2\u001c\u0018bAA\u0002}\n9Aj\\4hS:<\u0017A\u0004:fcV,7\u000f^\"iC:tW\r\u001c\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\u000e\u0002\u000f9,Go^8sW&!\u0011\u0011CA\u0006\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fa!];pi\u0006\u001c\b\u0003BA\f\u0003KqA!!\u0007\u0002\"9!\u00111DA\u0010\u001d\r\t\u0016QD\u0005\u00029%\u0011!dG\u0005\u0004\u0003GI\u0012\u0001D)v_R\fg)Y2u_JL\u0018\u0002BA\u0014\u0003S\u0011Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAA\u00123\u0005!A/[7f!\u0011\ty#a\r\u000e\u0005\u0005E\"BA@s\u0013\u0011\t)$!\r\u0003\tQKW.Z\u0001\nY><\u0007K]3gSb$\"\"a\u000f\u0002>\u0005}\u0012\u0011IA\"!\tyR\u0001C\u0004\u0002\u0006)\u0001\r!a\u0002\t\u000f\u0005M!\u00021\u0001\u0002\u0016!9\u00111\u0006\u0006A\u0002\u00055\u0002BBA\u001c\u0015\u0001\u0007A-A\u0006iC:$G.Z#se>\u0014H#\u0002\u0017\u0002J\u0005m\u0003bBA&\u0017\u0001\u0007\u0011QJ\u0001\be\u0016\fX/Z:u!\u0011\ty%!\u0016\u000f\t\u0005%\u0011\u0011K\u0005\u0005\u0003'\nY!\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\t\u0005]\u0013\u0011\f\u0002\b%\u0016\fX/Z:u\u0015\u0011\t\u0019&a\u0003\t\u000f\u0005u3\u00021\u0001\u0002`\u0005\tQ\rE\u0002P\u0003CJ1!a\u0019Z\u0005%!\u0006N]8xC\ndW-A\u000btK:$gi\u001c:xCJ$W\r\u001a*fgB|gn]3\u0015\u000b1\nI'a\u001b\t\u000f\u0005-C\u00021\u0001\u0002N!9\u0011Q\u000e\u0007A\u0002\u0005=\u0014\u0001\u0003:fgB|gn]3\u0011\u0007=\f\t(C\u0002\u0002tA\u0014\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u00023M,g\u000e\u001a*fgB|gn]3NCf\u0014W\r\u00165s_R$H.\u001a\u000b\u0006Y\u0005e\u00141\u0010\u0005\b\u0003\u0017j\u0001\u0019AA'\u0011\u001d\ti(\u0004a\u0001\u0003\u007f\nab\u0019:fCR,'+Z:q_:\u001cX\rE\u0004$\u0003\u0003\u000b))a\u001c\n\u0007\u0005\rEEA\u0005Gk:\u001cG/[8ocA\u00191%a\"\n\u0007\u0005%EEA\u0002J]R\fad]3oI\u0016\u0013(o\u001c:SKN\u0004xN\\:f\u001b\u0006L(-\u001a+ie>$H\u000f\\3\u0015\u000b1\ny)!%\t\u000f\u0005-c\u00021\u0001\u0002N!9\u00111\u0013\bA\u0002\u0005}\u0013!B3se>\u0014\u0018aH7bs\n,'+Z2pe\u0012\fe\u000eZ$fiRC'o\u001c;uY\u0016$\u0016.\\3NgR!\u0011QQAM\u0011\u001d\tYe\u0004a\u0001\u0003\u001b\nAf]3oIJ+7\u000f]8og\u0016l\u0015-\u001f2f)\"\u0014x\u000e\u001e;mK^KG\u000f[\"p]R\u0014x\u000e\u001c7feF+x\u000e^1\u0015\u000f1\ny*!+\u0002,\"9\u0011\u0011\u0015\tA\u0002\u0005\r\u0016aF2p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b!\ry\u0012QU\u0005\u0004\u0003OK\"aF\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u0011\u001d\tY\u0005\u0005a\u0001\u0003\u001bBq!! \u0011\u0001\u0004\ty(\u0001\u000etK:$'+Z:q_:\u001cX-\u0012=f[B$H\u000b\u001b:piRdW\rF\u0004-\u0003c\u000b\u0019,!.\t\u000f\u0005-\u0013\u00031\u0001\u0002N!9\u0011QN\tA\u0002\u0005=\u0004\"CA\\#A\u0005\t\u0019AA]\u0003)ygnQ8na2,G/\u001a\t\u0005G\u0011\u000bY\f\u0005\u0004$\u0003\u0003\u000bi\f\f\t\u0005\u0003\u007f\u000b\u0019-\u0004\u0002\u0002B*\u0019\u0011Q\u0002:\n\t\u0005\u0015\u0017\u0011\u0019\u0002\u0005'\u0016tG-\u0001\u0013tK:$'+Z:q_:\u001cX-\u0012=f[B$H\u000b\u001b:piRdW\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tYM\u000b\u0003\u0002:\u000657FAAh!\u0011\t\t.a7\u000e\u0005\u0005M'\u0002BAk\u0003/\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eG%\u0001\u0006b]:|G/\u0019;j_:LA!!8\u0002T\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025M,g\u000eZ#se>\u0014xJ]\"m_N,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u000f1\n\u0019/!:\u0002h\"9\u00111J\nA\u0002\u00055\u0003bBAJ'\u0001\u0007\u0011q\f\u0005\b\u0003S\u001c\u0002\u0019AAC\u0003)!\bN]8ui2,Wj]\u0001 g\u0016tG-\u0012:s_J\u0014Vm\u001d9p]N,W\t_3naR$\u0006N]8ui2,G#\u0002\u0017\u0002p\u0006E\bbBA&)\u0001\u0007\u0011Q\n\u0005\b\u0003'#\u0002\u0019AA0\u0003y\u0019XM\u001c3O_>\u0003(+Z:q_:\u001cX-\u0012=f[B$H\u000b\u001b:piRdW\rF\u0002-\u0003oDq!a\u0013\u0016\u0001\u0004\ti%A\bdY>\u001cXmQ8o]\u0016\u001cG/[8o)\u0015a\u0013Q`A\u0000\u0011\u001d\tYE\u0006a\u0001\u0003\u001bBqA!\u0001\u0017\u0001\u0004\u0011\u0019!A\u0006feJ|'oQ8v]R\u001c\b\u0003\u0003B\u0003\u0005\u001f\u0011\u0019Ba\b\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\tA!\u001e;jY*\u0011!QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0012\t\u001d!aA'baB!!Q\u0003B\u000e\u001b\t\u00119BC\u0002\u0003\u001aI\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005;\u00119B\u0001\u0004FeJ|'o\u001d\t\u0005\u0005C\u00119#\u0004\u0002\u0003$)!!Q\u0005B\u0006\u0003\u0011a\u0017M\\4\n\t\t%\"1\u0005\u0002\b\u0013:$XmZ3s\u00031\u0019XM\u001c3SKN\u0004xN\\:f)\u001da#q\u0006B\u0019\u0005oAq!a\u0013\u0018\u0001\u0004\ti\u0005C\u0004\u00034]\u0001\rA!\u000e\u0002\u0017I,7\u000f]8og\u0016|\u0005\u000f\u001e\t\u0005G\u0011\u000by\u0007C\u0004\u00028^\u0001\r!!/")
public class RequestHandlerHelper
implements Logging {
    private final RequestChannel requestChannel;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String routingPathPrefixOrNull(RequestContext requestContext) {
        return RequestHandlerHelper$.MODULE$.routingPathPrefixOrNull(requestContext);
    }

    public static void onLeadershipChange(GroupCoordinator groupCoordinator, TransactionCoordinator transactionCoordinator, Option<TierDeletedPartitionsCoordinator> option, Iterable<Partition> iterable, Iterable<Partition> iterable2) {
        RequestHandlerHelper$.MODULE$.onLeadershipChange(groupCoordinator, transactionCoordinator, option, iterable, iterable2);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void handleError(RequestChannel.Request request, Throwable e) {
        boolean mayThrottle = e instanceof ClusterAuthorizationException || !request.header().apiKey().clusterAction;
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Error when handling request: ").append("clientId=").append(request.header().clientId()).append(", ").append("correlationId=").append(request.header().correlationId()).append(", ").append("api=").append(request.header().apiKey()).append(", ").append("version=").append(request.header().apiVersion()).append(", ").append("body=").append(request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        if (mayThrottle) {
            this.sendErrorResponseMaybeThrottle(request, e);
            return;
        }
        this.sendErrorResponseExemptThrottle(request, e);
    }

    public void sendForwardedResponse(RequestChannel.Request request, AbstractResponse response2) {
        int throttleTimeMs = response2.throttleTimeMs();
        this.quotas.request().throttle(request, throttleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            this.requestChannel.sendResponse(response);
            return BoxedUnit.UNIT;
        });
        this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)response2), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseMaybeThrottle(RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.quotas.request().throttle(request, throttleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.requestChannel.sendResponse(response);
                return BoxedUnit.UNIT;
            });
        }
        this.sendResponse(request, (Option<AbstractResponse>)new Some(createResponse.apply((Object)BoxesRunTime.boxToInteger((int)throttleTimeMs))), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendErrorResponseMaybeThrottle(RequestChannel.Request request, Throwable error) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (error instanceof ClusterAuthorizationException || !request.isForwarded()) {
            this.quotas.request().throttle(request, throttleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.requestChannel.sendResponse(response);
                return BoxedUnit.UNIT;
            });
        }
        this.sendErrorOrCloseConnection(request, error, throttleTimeMs);
    }

    /*
     * WARNING - void declaration
     */
    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        void var2_2;
        int throttleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, this.time.milliseconds());
        request.apiThrottleTimeMs_$eq(throttleTimeMs);
        return (int)var2_2;
    }

    public void sendResponseMaybeThrottleWithControllerQuota(ControllerMutationQuota controllerMutationQuota, RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int requestThrottleTimeMs;
        long timeMs = this.time.milliseconds();
        int controllerThrottleTimeMs = controllerMutationQuota.throttleTime();
        int maxThrottleTimeMs = Math.max(controllerThrottleTimeMs, requestThrottleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, timeMs));
        if (maxThrottleTimeMs > 0 && !request.isForwarded()) {
            request.apiThrottleTimeMs_$eq(maxThrottleTimeMs);
            if (controllerThrottleTimeMs > requestThrottleTimeMs) {
                this.quotas.controllerMutation().throttle(request, controllerThrottleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                    this.requestChannel.sendResponse(response);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.quotas.request().throttle(request, requestThrottleTimeMs, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                    this.requestChannel.sendResponse(response);
                    return BoxedUnit.UNIT;
                });
            }
        }
        this.sendResponse(request, (Option<AbstractResponse>)new Some(createResponse.apply((Object)BoxesRunTime.boxToInteger((int)maxThrottleTimeMs))), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseExemptThrottle(RequestChannel.Request request, AbstractResponse response, Option<Function1<Send, BoxedUnit>> onComplete) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)response), onComplete);
    }

    public void sendErrorOrCloseConnection(RequestChannel.Request request, Throwable error, int throttleMs) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        AbstractResponse response = requestBody.getErrorResponse(throttleMs, error);
        if (response == null) {
            this.closeConnection(request, requestBody.errorCounts(error));
            return;
        }
        this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)response), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendErrorResponseExemptThrottle(RequestChannel.Request request, Throwable error) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendErrorOrCloseConnection(request, error, 0);
    }

    public void sendNoOpResponseExemptThrottle(RequestChannel.Request request) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendResponse(request, (Option<AbstractResponse>)None$.MODULE$, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void closeConnection(RequestChannel.Request request, java.util.Map<Errors, Integer> errorCounts) {
        this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(errorCounts).asScala()));
        this.requestChannel.sendResponse(new RequestChannel.CloseConnectionResponse(request));
    }

    public void sendResponse(RequestChannel.Request request, Option<AbstractResponse> responseOpt, Option<Function1<Send, BoxedUnit>> onComplete) {
        RequestChannel.Response response2;
        responseOpt.foreach((Function1 & Serializable & scala.Serializable)response -> {
            this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()));
            return BoxedUnit.UNIT;
        });
        if (responseOpt instanceof Some) {
            AbstractResponse response3 = (AbstractResponse)((Some)responseOpt).value();
            response2 = new RequestChannel.SendResponse(request, request.buildResponseSend(response3), onComplete);
        } else if (None$.MODULE$.equals(responseOpt)) {
            response2 = new RequestChannel.NoOpResponse(request);
        } else {
            throw new MatchError(responseOpt);
        }
        this.requestChannel.sendResponse(response2);
    }

    public Option<Function1<Send, BoxedUnit>> sendResponseExemptThrottle$default$3() {
        return None$.MODULE$;
    }

    public RequestHandlerHelper(RequestChannel requestChannel, QuotaFactory.QuotaManagers quotas, Time time, String logPrefix) {
        this.requestChannel = requestChannel;
        this.quotas = quotas;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logPrefix);
    }
}

