/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Future;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.api.KAFKA_2_8_IV0$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetFromLeader;
import kafka.server.OffsetFromLeader$;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend$;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierMaterializationRequirements;
import kafka.server.TierState;
import kafka.tier.domain.TierObjectMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011Ua\u0001\u0002&L\u0001AC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"I\u0001\u000e\u0001B\u0001B\u0003%\u0011n\u001c\u0005\ta\u0002\u0011\t\u0011)A\u0005c\"AA\u000f\u0001B\u0001B\u0003%Q\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003z\u0011!a\bA!A!\u0002\u0013i\bBCA\n\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011\u0011\u0005\u0001\u0003\u0002\u0003\u0006I!a\t\t\u0015\u0005%\u0002A!A!\u0002\u0013\tY\u0003\u0003\u0006\u00028\u0001\u0011\t\u0011)A\u0005\u0003sA!\"!\u0011\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011\u001d\ty\u0005\u0001C\u0001\u0003#B\u0011\"!\u001c\u0001\u0005\u0004%I!a\u001c\t\u000f\u0005E\u0004\u0001)A\u0005I\"I\u00111\u000f\u0001C\u0002\u0013%\u0011Q\u000f\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002<!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u0003{\u0002\u0001\u0015!\u0003\u00022!Q\u0011q\u0010\u0001C\u0002\u0013\u00051*!!\t\u0011\u0005%\u0005\u0001)A\u0005\u0003\u0007C!\"a#\u0001\u0005\u0004%\taSAA\u0011!\ti\t\u0001Q\u0001\n\u0005\r\u0005BCAH\u0001\t\u0007I\u0011A&\u0002\u0002\"A\u0011\u0011\u0013\u0001!\u0002\u0013\t\u0019\tC\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u0003\u0002\u0016\"A\u0011q\u0015\u0001!\u0002\u0013\t9\nC\u0005\u0002*\u0002\u0011\r\u0011\"\u0003\u0002\u0016\"A\u00111\u0016\u0001!\u0002\u0013\t9\nC\u0005\u0002.\u0002\u0011\r\u0011\"\u0003\u0002\u0016\"A\u0011q\u0016\u0001!\u0002\u0013\t9\nC\u0005\u00022\u0002\u0011\r\u0011\"\u0005\u0002\u0016\"A\u00111\u0017\u0001!\u0002\u0013\t9\nC\u0005\u00026\u0002\u0011\r\u0011\"\u0015\u00028\"A\u0011q\u0018\u0001!\u0002\u0013\tI\fC\u0005\u0002B\u0002\u0011\r\u0011\"\u0015\u00028\"A\u00111\u0019\u0001!\u0002\u0013\tI\fC\u0005\u0002F\u0002\u0011\r\u0011\"\u0001\u0002H\"A\u0011Q\u001b\u0001!\u0002\u0013\tI\rC\u0004\u0002X\u0002!\t\"!7\t\u000f\tE\u0001\u0001\"\u0005\u0003\u0014!9!\u0011\n\u0001\u0005R\t-\u0003b\u0002B*\u0001\u0011E#Q\u000b\u0005\b\u0005?\u0002A\u0011\u000bB1\u0011\u001d\u0011)\u0007\u0001C)\u0005OBqAa\u001e\u0001\t\u0003\u0012I\bC\u0004\u0003|\u0001!\tE! \t\u000f\t\u0015\u0005\u0001\"\u0011\u0003\b\"9!\u0011\u0016\u0001\u0005B\t-\u0006b\u0002B_\u0001\u0011\u0005#q\u0018\u0005\b\u0005O\u0004A\u0011\tBu\u0011\u001d\u0011\u0019\u0010\u0001C\t\u0005kDqaa\u0003\u0001\t\u0003\u0019i\u0001C\u0004\u0004\"\u0001!\tfa\t\t\u000f\r-\u0002\u0001\"\u0015\u0004.!91Q\u0007\u0001\u0005R\r]\u0002bBB\"\u0001\u0011E3Q\t\u0005\b\u0007\u0017\u0002A\u0011BB'\u0011\u001d\u00199\u0006\u0001C!\u00073Bqa!\"\u0001\t\u0003\u001a9\tC\u0004\u0004\u0018\u0002!\tf!'\t\u000f\r\u0005\u0006\u0001\"\u0011\u0004$\"91\u0011\u0019\u0001\u0005\u0012\tu\u0004bBBb\u0001\u0011E1Q\u0019\u0005\b\u0007'\u0004A\u0011CBk\u0011\u001d\u0019I\u000e\u0001C\u0005\u00077DQba8\u0001!\u0003\r\t\u0011!C\u0005\u0007C|w!CBr\u0017\u0006\u0005\t\u0012ABs\r!Q5*!A\t\u0002\r\u001d\bbBA(\u000b\u0012\u00051q\u001e\u0005\n\u0007c,\u0015\u0013!C\u0001\u0007gD\u0011\u0002\"\u0003F#\u0003%\t\u0001b\u0003\t\u0013\u0011=Q)%A\u0005\u0002\u0011E!\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002M\u001b\u000611/\u001a:wKJT\u0011AT\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u000b\u0005\u0002S'6\t1*\u0003\u0002U\u0017\n)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0001\u00028b[\u0016\u0004\"a\u00161\u000f\u0005as\u0006CA-]\u001b\u0005Q&BA.P\u0003\u0019a$o\\8u})\tQ,A\u0003tG\u0006d\u0017-\u0003\u0002`9\u00061\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\tyF,A\u0005gKR\u001c\u0007.\u001a:JIB\u0011QMZ\u0007\u00029&\u0011q\r\u0018\u0002\u0004\u0013:$\u0018\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bC\u00016n\u001b\u0005Y'B\u00017N\u0003\u001d\u0019G.^:uKJL!A\\6\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi&\u0011\u0001nU\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003%JL!a]&\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"A\u0015<\n\u0005]\\%\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003%jL!a_&\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u00069Q.\u001a;sS\u000e\u001c\bc\u0001@\u0002\u00105\tqPC\u0002}\u0003\u0003QA!a\u0001\u0002\u0006\u000511m\\7n_:T1ATA\u0004\u0015\u0011\tI!a\u0003\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti!A\u0002pe\u001eL1!!\u0005\u0000\u0005\u001diU\r\u001e:jGN\fA\u0001^5nKB!\u0011qCA\u000f\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005\u0005\u0011!B;uS2\u001c\u0018\u0002BA\u0010\u00033\u0011A\u0001V5nK\u0006)\u0011/^8uCB\u0019!+!\n\n\u0007\u0005\u001d2J\u0001\u0007SKBd\u0017nY1Rk>$\u0018-\u0001\u000emK\u0006$WM]#oIB|\u0017N\u001c;CY>\u001c7.\u001b8h'\u0016tG\rE\u0003f\u0003[\t\t$C\u0002\u00020q\u0013aa\u00149uS>t\u0007c\u0001*\u00024%\u0019\u0011QG&\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\u0002\u001b1|wmQ8oi\u0016DHo\u00149u!\u0015)\u0017QFA\u001e!\u0011\t9\"!\u0010\n\t\u0005}\u0012\u0011\u0004\u0002\u000b\u0019><7i\u001c8uKb$\u0018aD3yiJ\fW*\u001a;sS\u000e$\u0016mZ:\u0011\r\u0005\u0015\u00131\n,W\u001b\t\t9EC\u0002\u0002Jq\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti%a\u0012\u0003\u00075\u000b\u0007/\u0001\u0004=S:LGO\u0010\u000b\u001b\u0003'\n)&a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\n\u0019'!\u001a\u0002h\u0005%\u00141\u000e\t\u0003%\u0002AQ!V\u0007A\u0002YCQaY\u0007A\u0002\u0011DQ\u0001[\u0007A\u0002%DQ\u0001]\u0007A\u0002EDQ\u0001^\u0007A\u0002UDQ\u0001_\u0007A\u0002eDQ\u0001`\u0007A\u0002uDq!a\u0005\u000e\u0001\u0004\t)\u0002C\u0004\u0002\"5\u0001\r!a\t\t\u0013\u0005%R\u0002%AA\u0002\u0005-\u0002\"CA\u001c\u001bA\u0005\t\u0019AA\u001d\u0011%\t\t%\u0004I\u0001\u0002\u0004\t\u0019%A\u0005sKBd\u0017nY1JIV\tA-\u0001\u0006sKBd\u0017nY1JI\u0002\n!\u0002\\8h\u0007>tG/\u001a=u+\t\tY$A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013A\u00047fC\u0012,'/\u00128ea>Lg\u000e^\u000b\u0003\u0003c\tq\u0002\\3bI\u0016\u0014XI\u001c3q_&tG\u000fI\u0001\u0014M\u0016$8\r\u001b*fcV,7\u000f\u001e,feNLwN\\\u000b\u0003\u0003\u0007\u00032!ZAC\u0013\r\t9\t\u0018\u0002\u0006'\"|'\u000f^\u0001\u0015M\u0016$8\r\u001b*fcV,7\u000f\u001e,feNLwN\u001c\u0011\u0002E=4gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u-\u0016\u00148/[8o\u0003\rzgMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3tiZ+'o]5p]\u0002\n\u0001\u0004\\5ti>3gm]3u%\u0016\fX/Z:u-\u0016\u00148/[8o\u0003ea\u0017n\u001d;PM\u001a\u001cX\r\u001e*fcV,7\u000f\u001e,feNLwN\u001c\u0011\u0002\u000f5\f\u0007pV1jiV\u0011\u0011q\u0013\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0016\u0001\u00026bm\u0006LA!!*\u0002\u001c\n9\u0011J\u001c;fO\u0016\u0014\u0018\u0001C7bq^\u000b\u0017\u000e\u001e\u0011\u0002\u00115LgNQ=uKN\f\u0011\"\\5o\u0005f$Xm\u001d\u0011\u0002\u00115\f\u0007PQ=uKN\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u0013\u0019,Go\u00195TSj,\u0017A\u00034fi\u000eD7+\u001b>fA\u0005y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\u0005e\u0006cA3\u0002<&\u0019\u0011Q\u0018/\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0013n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3!\u0003qI7\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'V\u0004\bo\u001c:uK\u0012\fQ$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G\rI\u0001\u0014M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u000b\u0003\u0003\u0013\u0004B!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0005\u0003\u001f\f)!A\u0004dY&,g\u000e^:\n\t\u0005M\u0017Q\u001a\u0002\u0014\r\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u0001\u0015M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM\u001d\u0011\u0002'\u0019,Go\u00195SKF,Xm\u001d;Ck&dG-\u001a:\u0015\t\u0005m\u0017q\u001e\t\u0005\u0003;\fIO\u0004\u0003\u0002`\u0006\u0015XBAAq\u0015\u0011\t\u0019/!\u0001\u0002\u0011I,\u0017/^3tiNLA!a:\u0002b\u0006aa)\u001a;dQJ+\u0017/^3ti&!\u00111^Aw\u0005\u001d\u0011U/\u001b7eKJTA!a:\u0002b\"9\u0011\u0011\u001f\u0015A\u0002\u0005M\u0018!\u00034fi\u000eDG)\u0019;b!\u0011\t)Pa\u0003\u000f\t\u0005](q\u0001\b\u0005\u0003s\u0014)A\u0004\u0003\u0002|\n\ra\u0002BA\u007f\u0005\u0003q1!WA\u0000\u0013\t\ti!\u0003\u0003\u0002\n\u0005-\u0011b\u0001(\u0002\b%!\u0011qZA\u0003\u0013\u0011\u0011I!!4\u0002'\u0019+Go\u00195TKN\u001c\u0018n\u001c8IC:$G.\u001a:\n\t\t5!q\u0002\u0002\u0011\r\u0016$8\r\u001b*fcV,7\u000f\u001e#bi\u0006TAA!\u0003\u0002N\u0006AB.[:u\u001f\u001a47/\u001a;SKF,Xm\u001d;Ck&dG-\u001a:\u0015\t\tU!\u0011\u0005\t\u0005\u0005/\u0011iB\u0004\u0003\u0002`\ne\u0011\u0002\u0002B\u000e\u0003C\f!\u0003T5ti>3gm]3ugJ+\u0017/^3ti&!\u00111\u001eB\u0010\u0015\u0011\u0011Y\"!9\t\u000f\t\r\u0012\u00061\u0001\u0003&\u0005\u0019\u0002/\u0019:uSRLwN\u001c+j[\u0016\u001cH/Y7qgBA\u0011QIA&\u0005O\u0011y\u0003\u0005\u0003\u0003*\t-RBAA\u0001\u0013\u0011\u0011i#!\u0001\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!!\u0011\u0007B\"\u001d\u0011\u0011\u0019D!\u0010\u000f\t\tU\"\u0011\b\b\u0005\u0003s\u00149$\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0002\u0002B\u001e\u0003\u0003\tq!\\3tg\u0006<W-\u0003\u0003\u0003@\t\u0005\u0013A\u0006'jgR|eMZ:fiN\u0014V-];fgR$\u0015\r^1\u000b\t\tm\u0012\u0011A\u0005\u0005\u0005\u000b\u00129E\u0001\u000bMSN$xJ\u001a4tKR\u001c\b+\u0019:uSRLwN\u001c\u0006\u0005\u0005\u007f\u0011\t%A\u0006mCR,7\u000f^#q_\u000eDG\u0003\u0002B'\u0005\u001f\u0002B!ZA\u0017I\"9!\u0011\u000b\u0016A\u0002\t\u001d\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000fY><7\u000b^1si>3gm]3u)\u0011\u00119F!\u0018\u0011\u0007\u0015\u0014I&C\u0002\u0003\\q\u0013A\u0001T8oO\"9!\u0011K\u0016A\u0002\t\u001d\u0012\u0001\u00047pO\u0016sGm\u00144gg\u0016$H\u0003\u0002B,\u0005GBqA!\u0015-\u0001\u0004\u00119#A\tf]\u0012|eMZ:fi\u001a{'/\u00129pG\"$bA!\u001b\u0003r\tM\u0004#B3\u0002.\t-\u0004c\u0001*\u0003n%\u0019!qN&\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\"9!\u0011K\u0017A\u0002\t\u001d\u0002B\u0002B;[\u0001\u0007A-A\u0003fa>\u001c\u0007.\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]R\u0011\u0011\u0011X\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0015\u0005\t}\u0004cA3\u0003\u0002&\u0019!1\u0011/\u0003\tUs\u0017\u000e^\u0001\u0015aJ|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0015\u0011\t%%q\u0013BM\u0005;\u0003R!ZA\u0017\u0005\u0017\u0003BA!$\u0003\u00146\u0011!q\u0012\u0006\u0004\u0005#k\u0015a\u00017pO&!!Q\u0013BH\u00055aunZ!qa\u0016tG-\u00138g_\"9!\u0011\u000b\u0019A\u0002\t\u001d\u0002b\u0002BNa\u0001\u0007!qK\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u0003 B\u0002\rA!)\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\u0011\u0019K!*\u000e\u0003\u0001I1Aa*T\u0005%1U\r^2i\t\u0006$\u0018-\u0001\np]J+7\u000f^8sKRKWM]*uCR,G\u0003\u0003B@\u0005[\u0013yKa-\t\u000f\tE\u0013\u00071\u0001\u0003(!9!\u0011W\u0019A\u0002\t]\u0013!\u00069s_B|7/\u001a3M_\u000e\fG\u000eT8h'R\f'\u000f\u001e\u0005\b\u0005k\u000b\u0004\u0019\u0001B\\\u0003%!\u0018.\u001a:Ti\u0006$X\rE\u0002S\u0005sK1Aa/L\u0005%!\u0016.\u001a:Ti\u0006$X-\u0001\bgKR\u001c\u0007\u000eV5feN#\u0018\r^3\u0015\r\t\u0005'\u0011\u001bBj!\u0019\u0011\u0019M!4\u000386\u0011!Q\u0019\u0006\u0005\u0005\u000f\u0014I-\u0001\u0006d_:\u001cWO\u001d:f]RTAAa3\u0002 \u0006!Q\u000f^5m\u0013\u0011\u0011yM!2\u0003\r\u0019+H/\u001e:f\u0011\u001d\u0011\tF\ra\u0001\u0005OAqA!63\u0001\u0004\u00119.\u0001\nuS\u0016\u0014xJ\u00196fGRlU\r^1eCR\f\u0007\u0003\u0002Bm\u0005Gl!Aa7\u000b\t\tu'q\\\u0001\u0007I>l\u0017-\u001b8\u000b\u0007\t\u0005X*\u0001\u0003uS\u0016\u0014\u0018\u0002\u0002Bs\u00057\u0014!\u0003V5fe>\u0013'.Z2u\u001b\u0016$\u0018\rZ1uC\u0006yR.\u0019;fe&\fG.\u001b>f)&,'o\u0015;bi\u0016,f\u000e^5m\u001f\u001a47/\u001a;\u0015\r\t-(Q\u001eBx!\u0019\u0011\u0019M!4\u0003X\"9!\u0011K\u001aA\u0002\t\u001d\u0002b\u0002Byg\u0001\u0007!qK\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r^\u0001\"[\u0006$XM]5bY&TX\rV5feN#\u0018\r^3V]RLGn\u00142kK\u000e$\u0018\n\u001a\u000b\u000b\u0005W\u00149P!?\u0003|\u000e\u001d\u0001b\u0002B)i\u0001\u0007!q\u0005\u0005\b\u0005c$\u0004\u0019\u0001B,\u0011\u001d\u0011i\u0010\u000ea\u0001\u0005\u007f\fa\u0002^1sO\u0016$xJ\u00196fGRLE\r\u0005\u0003\u0004\u0002\r\rQB\u0001Be\u0013\u0011\u0019)A!3\u0003\tU+\u0016\n\u0012\u0005\u0007\u0007\u0013!\u0004\u0019\u00013\u0002%Q\f'oZ3u%\u0016\u001cHo\u001c:f\u000bB|7\r[\u0001\u001c[\u0006L(-Z,be:Lem\u0014<feNL'0\u001a3SK\u000e|'\u000fZ:\u0015\r\t}4qBB\u0010\u0011\u001d\u0019\t\"\u000ea\u0001\u0007'\tqA]3d_J$7\u000f\u0005\u0003\u0004\u0016\rmQBAB\f\u0015\u0011\u0019I\"!\u0001\u0002\rI,7m\u001c:e\u0013\u0011\u0019iba\u0006\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\u0011\t&\u000ea\u0001\u0005O\tqBZ3uG\"4%o\\7MK\u0006$WM\u001d\u000b\u0005\u0007K\u00199\u0003\u0005\u0005\u0002F\u0005-#q\u0005BQ\u0011\u001d\u0019IC\u000ea\u0001\u00037\fABZ3uG\"\u0014V-];fgR\fQDZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0005/\u001ayc!\r\t\u000f\tEs\u00071\u0001\u0003(!111G\u001cA\u0002\u0011\f!cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQ\u0006Ac-\u001a;dQRKWM]'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UCJ<W\r\u001e$s_6dU-\u00193feR11\u0011HB \u0007\u0003\u00022AUB\u001e\u0013\r\u0019id\u0013\u0002\u0011\u001f\u001a47/\u001a;Ge>lG*Z1eKJDqA!\u00159\u0001\u0004\u00119\u0003\u0003\u0004\u00044a\u0002\r\u0001Z\u0001\u001cM\u0016$8\r\u001b'bi\u0016\u001cHo\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\r\t]3qIB%\u0011\u001d\u0011\t&\u000fa\u0001\u0005OAaaa\r:\u0001\u0004!\u0017!\u00064fi\u000eDwJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\t\u0007s\u0019ye!\u0015\u0004T!9!\u0011\u000b\u001eA\u0002\t\u001d\u0002BBB\u001au\u0001\u0007A\rC\u0004\u0004Vi\u0002\rAa\u0016\u0002!\u0015\f'\u000f\\5fgR|%\u000fT1uKN$\u0018A\u00032vS2$g)\u001a;dQR!11LB=!\u0019\u0019ifa\u001b\u0004r9!1qLB4\u001d\u0011\u0019\tg!\u001a\u000f\u0007e\u001b\u0019'C\u0001O\u0013\taU*C\u0002\u0004j-\u000bQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u0004n\r=$\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u0004j-\u0003R!ZA\u0017\u0007g\u0002Ba!\u0018\u0004v%!1qOB8\u00051\u0011V\r\u001d7jG\u00064U\r^2i\u0011\u001d\u0019Yh\u000fa\u0001\u0007{\nA\u0002]1si&$\u0018n\u001c8NCB\u0004\u0002\"!\u0012\u0002L\t\u001d2q\u0010\t\u0004%\u000e\u0005\u0015bABB\u0017\n\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u0006AAO];oG\u0006$X\r\u0006\u0004\u0003\u0000\r%5Q\u0012\u0005\b\u0007\u0017c\u0004\u0019\u0001B\u0014\u0003\t!\b\u000fC\u0004\u0004\u0010r\u0002\ra!%\u0002+=4gm]3u)J,hnY1uS>t7\u000b^1uKB\u0019!ka%\n\u0007\rU5JA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HC\u0002B@\u00077\u001bi\nC\u0004\u0003Ru\u0002\rAa\n\t\u000f\r}U\b1\u0001\u0003X\u00051qN\u001a4tKR\fACZ3uG\",\u0005o\\2i\u000b:$wJ\u001a4tKR\u001cH\u0003BBS\u0007k\u0003\u0002\"!\u0012\u0002L\t\u001d2q\u0015\t\u0005\u0007S\u001byK\u0004\u0003\u00034\r-\u0016\u0002BBW\u0005\u0003\n\u0001e\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z:q_:\u001cX\rR1uC&!1\u0011WBZ\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRTAa!,\u0003B!91q\u0017 A\u0002\re\u0016A\u00039beRLG/[8ogBA\u0011QIA&\u0005O\u0019Y\f\u0005\u0003\u0003$\u000eu\u0016bAB`'\nIQ\t]8dQ\u0012\u000bG/Y\u0001\u001c[\u0006\u00148NR8mY><XM\u001d*fa2L7-\u0019+ie>$H\u000f\\3\u0002-MDw.\u001e7e\r>dGn\\<feRC'o\u001c;uY\u0016$\"\"!/\u0004H\u000e-7QZBi\u0011\u001d\u0019I\r\u0011a\u0001\u0003s\u000bq\"[:Rk>$\u0018-\u0012=dK\u0016$W\r\u001a\u0005\b\u0003C\u0001\u0005\u0019AA\u0012\u0011\u001d\u0019y\r\u0011a\u0001\u0007\u007f\n!BZ3uG\"\u001cF/\u0019;f\u0011\u001d\u0011\t\u0006\u0011a\u0001\u0005O\tq\"[:SK\u0006$\u0017PR8s\r\u0016$8\r\u001b\u000b\u0005\u0003s\u001b9\u000eC\u0004\u0004\f\u0006\u0003\rAa\n\u00025MDw.\u001e7e)\"\u0014x\u000e\u001e;mK\u0012+X\rV8M_^$\u0015n]6\u0015\t\u0005e6Q\u001c\u0005\b\u0003C\u0011\u0005\u0019AA\u0012\u0003I\u0019X\u000f]3sIM|WO]2f\u0005J|7.\u001a:\u0016\u0003%\fACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$\u0007C\u0001*F'\r)5\u0011\u001e\t\u0004K\u000e-\u0018bABw9\n1\u0011I\\=SK\u001a$\"a!:\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132aU\u00111Q\u001f\u0016\u0005\u0003W\u00199p\u000b\u0002\u0004zB!11 C\u0003\u001b\t\u0019iP\u0003\u0003\u0004\u0000\u0012\u0005\u0011!C;oG\",7m[3e\u0015\r!\u0019\u0001X\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002C\u0004\u0007{\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cE*\"\u0001\"\u0004+\t\u0005e2q_\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00193+\t!\u0019B\u000b\u0003\u0002D\r]\b")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicaQuota quota;
    private final Map<String, String> extraMetricTags;
    private final int replicaId;
    private final LogContext logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean isOffsetForLeaderEpochSupported;
    private final boolean isTruncationOnFetchSupported;
    private final FetchSessionHandler fetchSessionHandler;

    public static Map<String, String> $lessinit$greater$default$12() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$12();
    }

    public static Option<LogContext> $lessinit$greater$default$11() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<BlockingSend> $lessinit$greater$default$10() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    public Integer fetchSize() {
        return this.fetchSize;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    public FetchRequest.Builder fetchRequestBuilder(FetchSessionHandler.FetchRequestData fetchData) {
        return FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
    }

    public ListOffsetsRequest.Builder listOffsetRequestBuilder(Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> partitionTimestamps) {
        Seq topics = ((TraversableOnce)partitionTimestamps.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = (ListOffsetsRequestData.ListOffsetsPartition)x0$1._2();
            ListOffsetsRequestData.ListOffsetsTopic listOffsetsTopic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(listOffsetPartition));
            return listOffsetsTopic;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return ListOffsetsRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.replicaId()).setTargetTimes((List)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                this.leaderEndpoint().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.leaderEndpoint()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.leaderEndpoint().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.leaderEndpoint()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        boolean logTrace = this.isTraceEnabled();
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records());
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long leaderLogStartOffset = partitionData.logStartOffset();
        long followerHighWatermark = log.updateHighWatermark(partitionData.highWatermark());
        log.maybeIncrementLogStartOffset(leaderLogStartOffset, LeaderOffsetIncremented$.MODULE$);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn(records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Restoring tier state ").append(topicPartition).append(": ").append(tierState).toString());
        log.truncateAndRestoreTierState(proposedLocalLogStart, tierState);
    }

    @Override
    public Future<TierState> fetchTierState(TopicPartition topicPartition, TierObjectMetadata tierObjectMetadata) {
        return ((Partition)this.replicaMgr.onlinePartition(topicPartition).get()).fetchTierState(tierObjectMetadata);
    }

    @Override
    public Future<TierObjectMetadata> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        return this.replicaMgr.localLogOrException(topicPartition).materializeTierStateUntilOffset(targetOffset);
    }

    @Override
    public Future<TierObjectMetadata> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
        return this.replicaMgr.localLogOrException(topicPartition).materializeTierStateUntilObjectId(targetOffset, targetObjectId, targetRestoreEpoch);
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
        }
    }

    @Override
    public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        scala.collection.immutable.Map map;
        try {
            FetchResponse fetchResponse = (FetchResponse)this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest).responseBody();
            if (this.fetchSessionHandler().handleResponse(fetchResponse)) {
                return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala();
            }
            map = scala.collection.Map$.MODULE$.empty();
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_5;
        OffsetFromLeader offsetFromLeader = this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
        if (offsetFromLeader == null) {
            throw new MatchError(null);
        }
        long localLogStartOffset = offsetFromLeader.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = offsetFromLeader.tierRestorePoint();
        if (var6_5.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for earliest timestamp fetch");
        }
        return (long)var4_4;
    }

    @Override
    public OffsetFromLeader fetchTierMaterializationTargetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.tierFeature())) {
            return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -10000L);
        }
        throw new IllegalStateException("Incompatible configuration for tiered storage");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_5;
        OffsetFromLeader offsetFromLeader = this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
        if (offsetFromLeader == null) {
            throw new MatchError(null);
        }
        long localLogStartOffset = offsetFromLeader.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = offsetFromLeader.tierRestorePoint();
        if (var6_5.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for latest timestamp fetch");
        }
        return (long)var4_4;
    }

    private OffsetFromLeader fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(earliestOrLatest)));
        ListOffsetsRequest.Builder requestBuilder = ListOffsetsRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.replicaId()).setTargetTimes(Collections.singletonList(topic));
        ListOffsetsResponse response = (ListOffsetsResponse)this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder).responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$fetchOffsetFromLeader$1(topicPartition, x$3))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$fetchOffsetFromLeader$2(topicPartition, x$4))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (Errors.NONE.equals(errors)) {
        } else {
            throw errors.exception();
        }
        OffsetFromLeader offsetFromLeader = this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? (responsePartition.followerRestorePointObjectId() != null && !responsePartition.followerRestorePointObjectId().equals((Object)Uuid.ZERO_UUID) ? OffsetFromLeader$.MODULE$.apply(responsePartition.offset(), CoreUtils$.MODULE$.toJavaUUID(responsePartition.followerRestorePointObjectId()), responsePartition.followerRestorePointEpoch()) : OffsetFromLeader$.MODULE$.apply(responsePartition.offset())) : OffsetFromLeader$.MODULE$.apply(Predef$.MODULE$.Long2long((Long)responsePartition.oldStyleOffsets().get(0)));
        return offsetFromLeader;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitionMap.size(), false);
        boolean lowDiskThrottle = this.shouldThrottleDueToLowDisk(this.quota);
        boolean isQuotaExceeded = this.quota.isQuotaExceeded();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && this.isReadyForFetch((TopicPartition)topicPartition)) {
                if (lowDiskThrottle || this.shouldFollowerThrottle(isQuotaExceeded, $this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                    this.markFollowerReplicaThrottle();
                    return BoxedUnit.UNIT;
                }
                try {
                    long logStartOffset = this.logStartOffset((TopicPartition)topicPartition);
                    Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable & scala.Serializable)x$5 -> ReplicaFetcherThread.$anonfun$buildFetch$2(BoxesRunTime.unboxToInt((Object)x$5))))) : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    return BoxedUnit.UNIT;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    return partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)Errors.KAFKA_STORAGE_ERROR));
                }
            }
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, PartitionFetchState> map = Implicits$.MODULE$.MapExtensionMethods(partitionMap);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        Some fetchRequestOpt = fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty() ? None$.MODULE$ : new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), this.fetchRequestBuilder(fetchData)));
        return new AbstractFetcherThread.ResultWithPartitions<Some>(fetchRequestOpt, (Map<TopicPartition, Errors>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        AbstractLog log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(log.highWatermark()).toString());
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return scala.collection.Map$.MODULE$.empty();
        }
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, epochData) -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$fetchEpochEndOffsets$2(topics, topicPartition, epochData));
        Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> map = Implicits$.MODULE$.MapExtensionMethods(partitions);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((short)this.offsetForLeaderEpochRequestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)topics, (int)this.brokerConfig.brokerId());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)responseBody.data().topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)offsetForLeaderTopicResult -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(offsetForLeaderTopicResult.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)offsetForLeaderPartitionResult -> {
                TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), offsetForLeaderPartitionResult);
            }, Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition tp = (TopicPartition)x0$1._1();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom());
        }
    }

    public void markFollowerReplicaThrottle() {
        this.replicaMgr.markFollowerReplicaThrottle();
    }

    public boolean shouldFollowerThrottle(boolean isQuotaExceeded, ReplicaQuota quota, PartitionFetchState fetchState, TopicPartition topicPartition) {
        return isQuotaExceeded && !fetchState.isReplicaInSync() && quota.isThrottled(topicPartition);
    }

    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    private boolean shouldThrottleDueToLowDisk(ReplicaQuota quota) {
        ReplicationQuotaManager replicationQuotaManager;
        boolean bl = quota instanceof ReplicationQuotaManager ? DiskUsageBasedThrottler$.MODULE$.diskThrottlingActive(replicationQuotaManager = (ReplicationQuotaManager)quota) && quota.isQuotaExceeded() : false;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetFromLeader$1(TopicPartition topicPartition$4, ListOffsetsResponseData.ListOffsetsTopicResponse x$3) {
        String string = x$3.name();
        String string2 = topicPartition$4.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetFromLeader$2(TopicPartition topicPartition$4, ListOffsetsResponseData.ListOffsetsPartitionResponse x$4) {
        return x$4.partitionIndex() == topicPartition$4.partition();
    }

    public static final /* synthetic */ Integer $anonfun$buildFetch$2(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public static final /* synthetic */ boolean $anonfun$fetchEpochEndOffsets$2(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics$1, TopicPartition topicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics$1.find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
            topics$1.add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add(epochData);
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<BlockingSend> leaderEndpointBlockingSend, Option<LogContext> logContextOpt, Map<String, String> extraMetricTags) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        this.extraMetricTags = extraMetricTags;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, replicaMgr.brokerTopicStats(), extraMetricTags);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = (LogContext)logContextOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(this.super$sourceBroker().id()).append(", fetcherId=").append($this.fetcherId).append("] ").toString()));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0 & Serializable & scala.Serializable)() -> ReplicaFetcherBlockingSend$.MODULE$.apply(this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringBuilder(16).append("broker-").append(this.replicaId()).append("-fetcher-").append($this.fetcherId).toString(), this.logContext(), $this.extraMetricTags));
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_7_IV1$.MODULE$) ? 12 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 11 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0))))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_8_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0))));
        this.listOffsetRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_8_IV0$.MODULE$) ? 6 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0))))));
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.isOffsetForLeaderEpochSupported = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.isTruncationOnFetchSupported = ApiVersion$.MODULE$.isTruncationOnFetchSupported(brokerConfig.interBrokerProtocolVersion());
        this.fetchSessionHandler = new FetchSessionHandler(this.logContext(), super.sourceBroker().id());
    }
}

