/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetFromLeader;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierState;
import kafka.tier.domain.TierObjectMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rMa\u0001B\u0016-\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\n\t\u0002\u0011\t\u0011)A\u0005\u000b.C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011%a\u0006A!A!\u0002\u0013i\u0006\rC\u0003b\u0001\u0011\u0005!\rC\u0004l\u0001\t\u0007I\u0011\u00027\t\rE\u0004\u0001\u0015!\u0003n\u0011\u001d\u0011\bA1A\u0005\nMDa\u0001 \u0001!\u0002\u0013!\bbB?\u0001\u0005\u0004%Ia\u001d\u0005\u0007}\u0002\u0001\u000b\u0011\u0002;\t\u0011}\u0004\u0001\u0019!C\u0005\u0003\u0003A\u0011\"a\b\u0001\u0001\u0004%I!!\t\t\u0011\u00055\u0002\u0001)Q\u0005\u0003\u0007Aq!a\f\u0001\t#\n\t\u0004C\u0004\u0002:\u0001!\t&a\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0015\u0002H!9\u00111\n\u0001\u0005R\u00055\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\t9\u000e\u0001C!\u00033Dq!!<\u0001\t#\ny\u000fC\u0004\u0002x\u0002!\t&!?\t\u000f\t\u0015\u0001\u0001\"\u0015\u0003\b!9!Q\u0002\u0001\u0005B\t=\u0001\"\u0003B\u001b\u0001\t\u0007I\u0011\u000bB\u001c\u0011!\u0011y\u0004\u0001Q\u0001\n\te\u0002\"\u0003B!\u0001\t\u0007I\u0011\u000bB\u001c\u0011!\u0011\u0019\u0005\u0001Q\u0001\n\te\u0002b\u0002B#\u0001\u0011\u0005#q\t\u0005\b\u0005+\u0002A\u0011\u000bB,\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005CBqAa\u001e\u0001\t\u0013\u0011I\bC\u0004\u0003~\u0001!IAa \t\u000f\t\u001d\u0006\u0001\"\u0001\u0003*\"9!Q\u0016\u0001\u0005R\t=\u0006b\u0002Ba\u0001\u0011E#1\u0019\u0005\b\u0005W\u0004A\u0011\u000bBw\u0011\u001d\u0011Y\u0010\u0001C)\u0005{\u0014\u0011DU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bI*\u0011QFL\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003=\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001eA\u00111\u0007N\u0007\u0002Y%\u0011Q\u0007\f\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0003\u0011q\u0017-\\3\u0011\u0005a\neBA\u001d@!\tQT(D\u0001<\u0015\ta\u0004'\u0001\u0004=e>|GO\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)P\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002A{\u0005a1o\\;sG\u0016\u0014%o\\6feB\u0011a)S\u0007\u0002\u000f*\u0011\u0001JL\u0001\bG2,8\u000f^3s\u0013\tQuI\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\n\u0005\u0011#\u0014\u0001\u00042s_.,'oQ8oM&<\u0007CA\u001aO\u0013\tyEFA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\t\u0019$+\u0003\u0002TY\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA\u001aW\u0013\t9FF\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005MR\u0016BA.-\u0005]\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'/\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugB\u00111GX\u0005\u0003?2\u0012\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\n\u0005q#\u0014A\u0002\u001fj]&$h\b\u0006\u0005dI\u00164w\r[5k!\t\u0019\u0004\u0001C\u00037\u0011\u0001\u0007q\u0007C\u0003E\u0011\u0001\u0007Q\tC\u0003M\u0011\u0001\u0007Q\nC\u0003Q\u0011\u0001\u0007\u0011\u000bC\u0003U\u0011\u0001\u0007Q\u000bC\u0003Y\u0011\u0001\u0007\u0011\fC\u0003]\u0011\u0001\u0007Q,A\u0005sKBd\u0017nY1JIV\tQ\u000e\u0005\u0002o_6\tQ(\u0003\u0002q{\t\u0019\u0011J\u001c;\u0002\u0015I,\u0007\u000f\\5dC&#\u0007%\u0001\u0005nCb\u0014\u0015\u0010^3t+\u0005!\bCA;{\u001b\u00051(BA<y\u0003\u0011a\u0017M\\4\u000b\u0003e\fAA[1wC&\u00111P\u001e\u0002\b\u0013:$XmZ3s\u0003%i\u0017\r\u001f\"zi\u0016\u001c\b%A\u0005gKR\u001c\u0007nU5{K\u0006Qa-\u001a;dQNK'0\u001a\u0011\u0002'%t\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8\u0016\u0005\u0005\r\u0001#\u00028\u0002\u0006\u0005%\u0011bAA\u0004{\t1q\n\u001d;j_:\u0004B!a\u0003\u0002\u001c5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0004d_6lwN\u001c\u0006\u0004_\u0005M!\u0002BA\u000b\u0003/\ta!\u00199bG\",'BAA\r\u0003\ry'oZ\u0005\u0005\u0003;\tiA\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002/%t\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8`I\u0015\fH\u0003BA\u0012\u0003S\u00012A\\A\u0013\u0013\r\t9#\u0010\u0002\u0005+:LG\u000fC\u0005\u0002,A\t\t\u00111\u0001\u0002\u0004\u0005\u0019\u0001\u0010J\u0019\u0002)%t\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8!\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\t\u0005M\u0012Q\u0007\t\u0005]\u0006\u0015Q\u000eC\u0004\u00028I\u0001\r!!\u0003\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BA\u001f\u0003\u0007\u00022A\\A \u0013\r\t\t%\u0010\u0002\u0005\u0019>tw\rC\u0004\u00028M\u0001\r!!\u0003\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\t\u0005u\u0012\u0011\n\u0005\b\u0003o!\u0002\u0019AA\u0005\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0003\u001f\n9&!\u0017\u0011\u000b9\f)!!\u0015\u0011\u0007M\n\u0019&C\u0002\u0002V1\u0012ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000eC\u0004\u00028U\u0001\r!!\u0003\t\r\u0005mS\u00031\u0001n\u0003\u0015)\u0007o\\2i\u0003=1W\r^2i\rJ|W\u000eT3bI\u0016\u0014H\u0003BA1\u0003k\u0002\u0002\"a\u0019\u0002j\u0005%\u0011QN\u0007\u0003\u0003KR1!a\u001a>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003W\n)GA\u0002NCB\u0004B!a\u001c\u0002r5\t\u0001!C\u0002\u0002tQ\u0012\u0011BR3uG\"$\u0015\r^1\t\u000f\u0005]d\u00031\u0001\u0002z\u0005aa-\u001a;dQJ+\u0017/^3tiB!\u00111PAD\u001d\u0011\ti(a!\u000e\u0005\u0005}$\u0002BAA\u0003\u001b\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u000b\u000by(\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0002\n\u0006-%a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u000b\u000by(\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0003#\u000by*!)\u0002&B)a.!\u0002\u0002\u0014B!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001a:\n1\u0001\\8h\u0013\u0011\ti*a&\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\t9d\u0006a\u0001\u0003\u0013Aq!a)\u0018\u0001\u0004\ti$A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBAT/\u0001\u0007\u0011\u0011V\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\r\u0005-\u0016QYAf\u001d\u0011\ti+!1\u000f\t\u0005=\u0016q\u0018\b\u0005\u0003c\u000biL\u0004\u0003\u00024\u0006mf\u0002BA[\u0003ss1AOA\\\u0013\t\tI\"\u0003\u0003\u0002\u0016\u0005]\u0011bA\u0018\u0002\u0014%!\u0011qBA\t\u0013\u0011\t\t)!\u0004\n\t\u0005\r\u0017qP\u0001\u000e\r\u0016$8\r\u001b*fgB|gn]3\n\t\u0005\u001d\u0017\u0011\u001a\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\u0005\r\u0017q\u0010\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*!\u0011\u0011[A\u0007\u0003\u0019\u0011XmY8sI&!\u0011Q[Ah\u0005\u001d\u0011VmY8sIN\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0003BAn\u0003C\u0004b!a\u0019\u0002^\u0006%\u0011\u0002BAp\u0003K\u00121aU3u\u0011\u001d\t\u0019\u000f\u0007a\u0001\u0003K\f!#\u001b8ji&\fGNR3uG\"\u001cF/\u0019;fgBA\u00111MA5\u0003\u0013\t9\u000fE\u00024\u0003SL1!a;-\u0005EIe.\u001b;jC24U\r^2i'R\fG/Z\u0001\u001eM\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR1\u0011QHAy\u0003gDq!a\u000e\u001a\u0001\u0004\tI\u0001\u0003\u0004\u0002vf\u0001\r!\\\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.\u0001\u0015gKR\u001c\u0007\u000eV5fe6\u000bG/\u001a:jC2L'0\u0019;j_:$\u0016M]4fi\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0004\u0002|\n\u0005!1\u0001\t\u0004g\u0005u\u0018bAA\u0000Y\t\u0001rJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u0005\b\u0003oQ\u0002\u0019AA\u0005\u0011\u0019\t)P\u0007a\u0001[\u0006Yb-\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;Ge>lG*Z1eKJ$b!!\u0010\u0003\n\t-\u0001bBA\u001c7\u0001\u0007\u0011\u0011\u0002\u0005\u0007\u0003k\\\u0002\u0019A7\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\u0011\tB!\u000b\u0011\u0011\u0005\r\u0014\u0011NA\u0005\u0005'\u0001BA!\u0006\u0003$9!!q\u0003B\u000f\u001d\u0011\tyK!\u0007\n\t\tm\u0011QB\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011yB!\t\u0002A=3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u00057\ti!\u0003\u0003\u0003&\t\u001d\"AD#q_\u000eDWI\u001c3PM\u001a\u001cX\r\u001e\u0006\u0005\u0005?\u0011\t\u0003C\u0004\u0003,q\u0001\rA!\f\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0005\u0002d\u0005%\u0014\u0011\u0002B\u0018!\u0011\tyG!\r\n\u0007\tMBGA\u0005Fa>\u001c\u0007\u000eR1uC\u0006y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\te\u0002c\u00018\u0003<%\u0019!QH\u001f\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0013n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3!\u0003qI7\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'V\u0004\bo\u001c:uK\u0012\fQ$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G\rI\u0001\tiJ,hnY1uKR1\u00111\u0005B%\u0005\u0017Bq!a\u000e\"\u0001\u0004\tI\u0001C\u0004\u0003N\u0005\u0002\rAa\u0014\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u00042a\rB)\u0013\r\u0011\u0019\u0006\f\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u0002$\te#1\f\u0005\b\u0003o\u0011\u0003\u0019AA\u0005\u0011\u001d\u0011iF\ta\u0001\u0003{\taa\u001c4gg\u0016$\u0018A\u00058fqR\u0014V-\u00193z!\u0006\u0014H/\u001b;j_:$BAa\u0019\u0003rA)a.!\u0002\u0003fA9aNa\u001a\u0002\n\t-\u0014b\u0001B5{\t1A+\u001e9mKJ\u00022a\rB7\u0013\r\u0011y\u0007\f\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/\u001a\u0005\b\u0005g\u001a\u0003\u0019\u0001B;\u00031\u0001\u0018M\u001d;ji&|g.T1q!!\t\u0019'!\u001b\u0002\n\t-\u0014AF:fY\u0016\u001cG\u000fU1si&$\u0018n\u001c8U_\u001a+Go\u00195\u0015\t\t\r$1\u0010\u0005\b\u0005g\"\u0003\u0019\u0001B;\u0003Y\u0011W/\u001b7e\r\u0016$8\r\u001b$peB\u000b'\u000f^5uS>tGC\u0002BA\u0005?\u0013\u0019\u000b\u0005\u0004\u0003\u0004\nE%q\u0013\b\u0005\u0005\u000b\u0013iI\u0004\u0003\u0003\b\n-eb\u0001\u001e\u0003\n&\tq&\u0003\u0002.]%\u0019!q\u0012\u0017\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&!!1\u0013BK\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og*\u0019!q\u0012\u0017\u0011\u000b9\f)A!'\u0011\t\t\r%1T\u0005\u0005\u0005;\u0013)J\u0001\u0007SKBd\u0017nY1GKR\u001c\u0007\u000eC\u0004\u0003\"\u0016\u0002\r!!\u0003\u0002\u0005Q\u0004\bb\u0002BSK\u0001\u0007!1N\u0001\u000bM\u0016$8\r[*uCR,\u0017A\u00032vS2$g)\u001a;dQR!!\u0011\u0011BV\u0011\u001d\u0011\u0019H\na\u0001\u0005k\n!c\u001c8SKN$xN]3US\u0016\u00148\u000b^1uKRA\u00111\u0005BY\u0005g\u00139\fC\u0004\u00028\u001d\u0002\r!!\u0003\t\u000f\tUv\u00051\u0001\u0002>\u0005)\u0002O]8q_N,G\rT8dC2dunZ*uCJ$\bb\u0002B]O\u0001\u0007!1X\u0001\ni&,'o\u0015;bi\u0016\u00042a\rB_\u0013\r\u0011y\f\f\u0002\n)&,'o\u0015;bi\u0016\faBZ3uG\"$\u0016.\u001a:Ti\u0006$X\r\u0006\u0004\u0003F\nU'q\u001b\t\u0007\u0005\u000f\u0014\tNa/\u000e\u0005\t%'\u0002\u0002Bf\u0005\u001b\f!bY8oGV\u0014(/\u001a8u\u0015\r\u0011y\r_\u0001\u0005kRLG.\u0003\u0003\u0003T\n%'!E\"p[BdW\r^1cY\u00164U\u000f^;sK\"9\u0011q\u0007\u0015A\u0002\u0005%\u0001b\u0002BmQ\u0001\u0007!1\\\u0001\u0013i&,'o\u00142kK\u000e$X*\u001a;bI\u0006$\u0018\r\u0005\u0003\u0003^\n\u001dXB\u0001Bp\u0015\u0011\u0011\tOa9\u0002\r\u0011|W.Y5o\u0015\r\u0011)OL\u0001\u0005i&,'/\u0003\u0003\u0003j\n}'A\u0005+jKJ|%M[3di6+G/\u00193bi\u0006\fq$\\1uKJL\u0017\r\\5{KRKWM]*uCR,WK\u001c;jY>3gm]3u)\u0019\u0011yO!>\u0003xB1!q\u0019By\u00057LAAa=\u0003J\n1a)\u001e;ve\u0016Dq!a\u000e*\u0001\u0004\tI\u0001C\u0004\u0003z&\u0002\r!!\u0010\u0002\u0019Q\f'oZ3u\u001f\u001a47/\u001a;\u0002C5\fG/\u001a:jC2L'0\u001a+jKJ\u001cF/\u0019;f+:$\u0018\u000e\\(cU\u0016\u001cG/\u00133\u0015\u0015\t=(q`B\u0001\u0007\u0007\u0019y\u0001C\u0004\u00028)\u0002\r!!\u0003\t\u000f\te(\u00061\u0001\u0002>!91Q\u0001\u0016A\u0002\r\u001d\u0011A\u0004;be\u001e,Go\u00142kK\u000e$\u0018\n\u001a\t\u0005\u0007\u0013\u0019Y!\u0004\u0002\u0003N&!1Q\u0002Bg\u0005\u0011)V+\u0013#\t\r\rE!\u00061\u0001n\u0003I!\u0018M]4fiJ+7\u000f^8sK\u0016\u0003xn\u00195")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private final boolean isOffsetForLeaderEpochSupported;
    private final boolean isTruncationOnFetchSupported;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), false, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel(), (Option<ClientMetadata>)None$.MODULE$);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray())).mkString(",")).toString());
        }
        return ((Seq)partitionData.elem).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records());
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LeaderOffsetIncremented$.MODULE$);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition).localLogOrException().logStartOffset();
    }

    @Override
    public OffsetFromLeader fetchTierMaterializationTargetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Alter log dirs does not support tiered partitions");
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        return this.replicaMgr.getPartitionOrException(topicPartition).localLogOrException().logEndOffset();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaMgr.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, true);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((TraversableOnce)partitionMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$less((Object)((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable & scala.Serializable)tp -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        None$ none$;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaMgr.futureLocalLogOrException(tp).logStartOffset();
            Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable & scala.Serializable)x$3 -> ReplicaAlterLogDirsThread.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt((Object)x$3))))) : Optional.empty();
            requestMap.put(tp, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.KAFKA_STORAGE_ERROR));
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Map<TopicPartition, Errors>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Map<TopicPartition, Errors>)scala.collection.Map$.MODULE$.empty());
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitionMap);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            resultWithPartitions = this.buildFetchForPartition(tp, fetchState);
        } else if (None$.MODULE$.equals(option)) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Map<TopicPartition, Errors>)scala.collection.Map$.MODULE$.empty());
        } else {
            throw new MatchError(option);
        }
        return resultWithPartitions;
    }

    @Override
    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        throw new UnsupportedOperationException("Restoring tier state during an alter log dirs operation is not currently supported.");
    }

    public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierObjectMetadata tierObjectMetadata) {
        throw new UnsupportedOperationException("Fetching tier state during an alter log dirs operation is not currently supported.");
    }

    @Override
    public Future<TierObjectMetadata> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        throw new UnsupportedOperationException("Materializing tier state is not supported with alter log dirs.");
    }

    @Override
    public Future<TierObjectMetadata> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
        throw new UnsupportedOperationException("Materializing tier state is not supported with alter log dirs.");
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            FetchPartitionData data = (FetchPartitionData)x0$1._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable & scala.Serializable)x$1 -> (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, (BaseRecords)data.records()));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.replicaMgr.futureLogExists(tp);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        partitionMap$1.get((Object)tp).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isReadyForFetch())).foreach((Function1 & Serializable & scala.Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(ReplicaAlterLogDirsThread $this, Map partitionMap$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(133).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, brokerTopicStats, AbstractFetcherThread$.MODULE$.$lessinit$greater$default$8());
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
        this.isOffsetForLeaderEpochSupported = true;
        this.isTruncationOnFetchSupported = false;
    }
}

