/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.controller.StateChangeLogger;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedDeleteRecords;
import kafka.server.DelayedElectLeader;
import kafka.server.DelayedFetch;
import kafka.server.DelayedListOffsets;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedProduce;
import kafka.server.HostedPartition;
import kafka.server.HostedPartition$None$;
import kafka.server.HostedPartition$Offline$;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.server.QuotaFactory;
import kafka.server.RaftReplicaChangeDelegate;
import kafka.server.RaftReplicaChangeDelegateHelper;
import kafka.server.RaftReplicaManager$;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.server.TierReplicaComponents$;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MetadataBrokers;
import kafka.server.metadata.MetadataImage;
import kafka.server.metadata.MetadataImageBuilder;
import kafka.server.metadata.MetadataPartition;
import kafka.server.metadata.MetadataPartitions;
import kafka.server.metadata.MetadataPartitionsBuilder;
import kafka.server.metadata.RaftMetadataCache;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\r\u0015c\u0001B\u001b7\u0001mB\u0011\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011#\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t3\u0002\u0011\t\u0011)A\u00055\"Iq\f\u0001B\u0001B\u0003%\u0001M\u001a\u0005\nO\u0002\u0011\t\u0011)A\u0005QRD\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\r\u0003\u0013\u0001!\u0011!Q\u0001\n\u0005-\u0011\u0011\u0003\u0005\r\u0003'\u0001!\u0011!Q\u0001\n\u0005U\u0011\u0011\u0005\u0005\u000b\u0003G\u0001!\u0011!Q\u0001\n\u0005\u0015\u0002\u0002DA\u0016\u0001\t\u0005\t\u0015!\u0003\u0002.\u0005e\u0002\u0002DA\u001e\u0001\t\u0005\t\u0015!\u0003\u0002>\u0005\u0015\u0003\u0002DA$\u0001\t\u0005\t\u0015!\u0003\u0002J\u0005E\u0003\u0002DA*\u0001\t\u0005\t\u0015!\u0003\u0002V\u0005u\u0003\u0002DA0\u0001\t\u0005\t\u0015!\u0003\u0002b\u0005%\u0004BCA6\u0001\t\u0005\t\u0015!\u0003\u0002n!Q\u0011\u0011\u0012\u0001\u0003\u0002\u0003\u0006I!a#\t\u0019\u0005E\u0005A!A!\u0002\u0013\t\u0019*!'\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u00111\u0014\u0001\u0005\u0002\u0005\u0015gABAq\u0001\u0001\t\u0019\u000f\u0003\u0006\u0002rV\u0011\t\u0011)A\u0005\u0003?Cq!a'\u0016\t\u0003\t\u0019\u0010C\u0004\u0002|V!\t%!@\t\r\u0001+B\u0011\tB\t\u0011\u001d\u0011\u0019\"\u0006C!\u0005+AqA!\u000f\u0016\t\u0003\u0012Y\u0004C\u0004\u0003@U!\tE!\u0011\t\r\u001d,B\u0011\tB)\u0011\u001d\u0011I&\u0006C!\u00057BqAa\u001c\u0016\t\u0003\u0012\t\bC\u0004\u0003vU!\tEa\u001e\t\u000f\t%U\u0003\"\u0011\u0003\f\"9!1S\u000b\u0005B\tU\u0005b\u0002BO+\u0011\u0005#q\u0014\u0005\u000b\u0005[\u0003\u0001\u0019!C\u0001m\t=\u0006B\u0003B\\\u0001\u0001\u0007I\u0011\u0001\u001c\u0003:\"A!q\u0018\u0001!B\u0013\u0011\t\fC\u0005\u0003B\u0002\u0001\r\u0011\"\u0003\u0003R!I!1\u0019\u0001A\u0002\u0013%!Q\u0019\u0005\t\u0005\u0013\u0004\u0001\u0015)\u0003\u0003T!9!1\u001a\u0001\u0005\u0002\t5\u0007b\u0002Bh\u0001\u0011\u0005!\u0011\u001b\u0005\b\u0005G\u0004A\u0011\u0001Bs\u0011\u001d\u00119\u0010\u0001C\u0001\u0005sDqAa>\u0001\t\u0013\u0019\t\u0001C\u0004\u0004\u0006\u0001!Iaa\u0002\t\u000f\r=\u0001\u0001\"\u0003\u0004\u0012\u001dI1Q\u0005\u001c\u0002\u0002#\u00051q\u0005\u0004\tkY\n\t\u0011#\u0001\u0004*!9\u00111\u0014\u001a\u0005\u0002\r-\u0002\"CB\u0017eE\u0005I\u0011AB\u0018\u0005I\u0011\u0016M\u001a;SKBd\u0017nY1NC:\fw-\u001a:\u000b\u0005]B\u0014AB:feZ,'OC\u0001:\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001f\u0011\u0005urT\"\u0001\u001c\n\u0005}2$A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0007G>tg-[4\u0011\u0005u\u0012\u0015BA\"7\u0005-Y\u0015MZ6b\u0007>tg-[4\n\u0005\u0001s\u0014aB7fiJL7m\u001d\t\u0003\u000fBk\u0011\u0001\u0013\u0006\u0003\u000b&S!AS&\u0002\r\r|W.\\8o\u0015\tIDJ\u0003\u0002N\u001d\u00061\u0011\r]1dQ\u0016T\u0011aT\u0001\u0004_J<\u0017BA)I\u0005\u001diU\r\u001e:jGN\fA\u0001^5nKB\u0011AkV\u0007\u0002+*\u0011a+S\u0001\u0006kRLGn]\u0005\u00031V\u0013A\u0001V5nK\u0006I1o\u00195fIVdWM\u001d\t\u00037vk\u0011\u0001\u0018\u0006\u0003-bJ!A\u0018/\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u00037pO6\u000bg.Y4feB\u0011\u0011\rZ\u0007\u0002E*\u00111\rO\u0001\u0004Y><\u0017BA3c\u0005)aunZ'b]\u0006<WM]\u0005\u0003?z\na\"[:TQV$H/\u001b8h\t><h\u000e\u0005\u0002je6\t!N\u0003\u0002lY\u00061\u0011\r^8nS\u000eT!!\u001c8\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002pa\u0006!Q\u000f^5m\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a\u001d6\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0013\t9g(A\u0007rk>$\u0018-T1oC\u001e,'o\u001d\t\u0004o\u0006\raB\u0001=\u0000\u001d\tIhP\u0004\u0002{{6\t1P\u0003\u0002}u\u00051AH]8pizJ\u0011!O\u0005\u0003oaJ1!!\u00017\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\u0011\t)!a\u0002\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\r\t\tAN\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u00042!PA\u0007\u0013\r\tyA\u000e\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biNL1!!\u0003?\u00035iW\r^1eCR\f7)Y2iKB!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cY\n\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003?\tIBA\tSC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016L1!a\u0005?\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYB\u0019Q(a\n\n\u0007\u0005%bG\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0018I\u0016d\u0017-_3e!J|G-^2f!V\u0014x-\u0019;pef\u0004R!PA\u0018\u0003gI1!!\r7\u0005e!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000eU;sO\u0006$xN]=\u0011\u0007u\n)$C\u0002\u00028Y\u0012a\u0002R3mCf,G\r\u0015:pIV\u001cW-C\u0002\u0002,y\nQ\u0003Z3mCf,GMR3uG\"\u0004VO]4bi>\u0014\u0018\u0010E\u0003>\u0003_\ty\u0004E\u0002>\u0003\u0003J1!a\u00117\u00051!U\r\\1zK\u00124U\r^2i\u0013\r\tYDP\u0001\u001eI\u0016d\u0017-_3e\t\u0016dW\r^3SK\u000e|'\u000fZ:QkJ<\u0017\r^8ssB)Q(a\f\u0002LA\u0019Q(!\u0014\n\u0007\u0005=cG\u0001\u000bEK2\f\u00170\u001a3EK2,G/\u001a*fG>\u0014Hm]\u0005\u0004\u0003\u000fr\u0014a\u00073fY\u0006LX\rZ#mK\u000e$H*Z1eKJ\u0004VO]4bi>\u0014\u0018\u0010E\u0003>\u0003_\t9\u0006E\u0002>\u00033J1!a\u00177\u0005I!U\r\\1zK\u0012,E.Z2u\u0019\u0016\fG-\u001a:\n\u0007\u0005Mc(A\u000eeK2\f\u00170\u001a3MSN$xJ\u001a4tKR\u001c\b+\u001e:hCR|'/\u001f\t\u0006{\u0005=\u00121\r\t\u0004{\u0005\u0015\u0014bAA4m\t\u0011B)\u001a7bs\u0016$G*[:u\u001f\u001a47/\u001a;t\u0013\r\tyFP\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004b!a\u001c\u0002v\u0005eTBAA9\u0015\t\t\u0019(A\u0003tG\u0006d\u0017-\u0003\u0003\u0002x\u0005E$AB(qi&|g\u000e\u0005\u0003\u0002|\u0005\re\u0002BA?\u0003\u007f\u00022A_A9\u0013\u0011\t\t)!\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t))a\"\u0003\rM#(/\u001b8h\u0015\u0011\t\t)!\u001d\u0002!\r|gNZ5h%\u0016\u0004xn]5u_JL\b\u0003BA\f\u0003\u001bKA!a$\u0002\u001a\t\u00012i\u001c8gS\u001e\u0014V\r]8tSR|'/_\u0001\u0010C2$XM]%te6\u000bg.Y4feB\u0019Q(!&\n\u0007\u0005]eGA\bBYR,'/S:s\u001b\u0006t\u0017mZ3s\u0013\r\t\tJP\u0001\u0007y%t\u0017\u000e\u001e \u0015M\u0005}\u0015\u0011UAR\u0003K\u000b9+!+\u0002,\u00065\u0016qVAY\u0003g\u000b),a.\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019\r\u0005\u0002>\u0001!)\u0001i\u0005a\u0001\u0003\")Qi\u0005a\u0001\r\")!k\u0005a\u0001'\")\u0011l\u0005a\u00015\")ql\u0005a\u0001A\")qm\u0005a\u0001Q\")Qo\u0005a\u0001m\"9\u0011\u0011B\nA\u0002\u0005-\u0001bBA\n'\u0001\u0007\u0011Q\u0003\u0005\b\u0003G\u0019\u0002\u0019AA\u0013\u0011\u001d\tYc\u0005a\u0001\u0003[Aq!a\u000f\u0014\u0001\u0004\ti\u0004C\u0004\u0002HM\u0001\r!!\u0013\t\u000f\u0005M3\u00031\u0001\u0002V!9\u0011qL\nA\u0002\u0005\u0005\u0004bBA6'\u0001\u0007\u0011Q\u000e\u0005\b\u0003\u0013\u001b\u0002\u0019AAF\u0011\u001d\t\tj\u0005a\u0001\u0003'#B$a(\u0002H\u0006%\u00171ZAg\u0003\u001f\f\t.a5\u0002V\u0006]\u0017\u0011\\An\u0003;\fy\u000eC\u0003A)\u0001\u0007\u0011\tC\u0003F)\u0001\u0007a\tC\u0003S)\u0001\u00071\u000bC\u0003Z)\u0001\u0007!\fC\u0003`)\u0001\u0007\u0001\rC\u0003h)\u0001\u0007\u0001\u000eC\u0003v)\u0001\u0007a\u000fC\u0004\u0002\nQ\u0001\r!a\u0003\t\u000f\u0005MA\u00031\u0001\u0002\u0016!9\u00111\u0005\u000bA\u0002\u0005\u0015\u0002bBAI)\u0001\u0007\u00111\u0013\u0005\b\u0003\u0013#\u0002\u0019AAF\u0011%\tY\u0007\u0006I\u0001\u0002\u0004\tiG\u0001\u0014SC\u001a$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148\t[1oO\u0016$U\r\\3hCR,\u0007*\u001a7qKJ\u001cR!FAs\u0003W\u0004B!a\u001c\u0002h&!\u0011\u0011^A9\u0005\u0019\te.\u001f*fMB\u0019Q(!<\n\u0007\u0005=hGA\u0010SC\u001a$(+\u001a9mS\u000e\f7\t[1oO\u0016$U\r\\3hCR,\u0007*\u001a7qKJ\f!C]1giJ+\u0007\u000f\\5dC6\u000bg.Y4feR!\u0011Q_A}!\r\t90F\u0007\u0002\u0001!9\u0011\u0011_\fA\u0002\u0005}\u0015aF2p[BdW\r^3EK2\f\u00170\u001a3SKF,Xm\u001d;t)\u0011\tyP!\u0002\u0011\t\u0005=$\u0011A\u0005\u0005\u0005\u0007\t\tH\u0001\u0003V]&$\bb\u0002B\u00041\u0001\u0007!\u0011B\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\u0011YA!\u0004\u000e\u0003%K1Aa\u0004J\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012!Q\u0001\u0006KJ\u0014xN\u001d\u000b\u0007\u0003\u007f\u00149B!\t\t\u0011\te!\u0004\"a\u0001\u00057\t1!\\:h!\u0019\tyG!\b\u0002z%!!qDA9\u0005!a$-\u001f8b[\u0016t\u0004\u0002\u0003B\u00125\u0011\u0005\rA!\n\u0002\u0003\u0015\u0004b!a\u001c\u0003\u001e\t\u001d\u0002\u0003\u0002B\u0015\u0005gqAAa\u000b\u000309\u0019!P!\f\n\u0005\u0005M\u0014\u0002\u0002B\u0019\u0003c\nq\u0001]1dW\u0006<W-\u0003\u0003\u00036\t]\"!\u0003+ie><\u0018M\u00197f\u0015\u0011\u0011\t$!\u001d\u0002\u0013\u001d,G\u000fT8h\t&\u0014H\u0003BA7\u0005{AqAa\u0002\u001c\u0001\u0004\u0011I!\u0001\nj]&$\u0018.\u00197GKR\u001c\u0007n\u00144gg\u0016$H\u0003\u0002B\"\u0005\u0013\u0002B!a\u001c\u0003F%!!qIA9\u0005\u0011auN\\4\t\r\rd\u0002\u0019\u0001B&!\r\t'QJ\u0005\u0004\u0005\u001f\u0012'aC!cgR\u0014\u0018m\u0019;M_\u001e,\"Aa\u0015\u0011\t\u0005=$QK\u0005\u0005\u0005/\n\tHA\u0004C_>dW-\u00198\u0002\u00195\f'o\u001b#fM\u0016\u0014(/\u001a3\u0015\t\u0005}(Q\f\u0005\b\u0005?r\u0002\u0019\u0001B1\u0003\u0015\u0019H/\u0019;f!\u0011\u0011\u0019G!\u001b\u000f\u0007u\u0012)'C\u0002\u0003hY\nq\u0002S8ti\u0016$\u0007+\u0019:uSRLwN\\\u0005\u0005\u0005W\u0012iG\u0001\u0005EK\u001a,'O]3e\u0015\r\u00119GN\u0001\f[\u0006\u00148n\u00144gY&tW\r\u0006\u0003\u0002\u0000\nM\u0004b\u0002B\u0004?\u0001\u0007!\u0011B\u0001\u000b[\u0006\u00148n\u00148mS:,G\u0003BA\u0000\u0005sBqAa\u001f!\u0001\u0004\u0011i(A\u0005qCJ$\u0018\u000e^5p]B!!q\u0010BC\u001b\t\u0011\tIC\u0002\u0003\u0004b\nqa\u00197vgR,'/\u0003\u0003\u0003\b\n\u0005%!\u0003)beRLG/[8o\u0003i\u0011X\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t\u001b\u0006t\u0017mZ3s+\t\u0011i\tE\u0002>\u0005\u001fK1A!%7\u0005i\u0011V\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t\u001b\u0006t\u0017mZ3s\u0003U\u0011X\r\u001d7jG\u00064U\r^2iKJl\u0015M\\1hKJ,\"Aa&\u0011\u0007u\u0012I*C\u0002\u0003\u001cZ\u0012QCU3qY&\u001c\u0017MR3uG\",'/T1oC\u001e,'/A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ,\"A!)\u0011\t\t\r&\u0011V\u0007\u0003\u0005KS1Aa*9\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0005\u0005W\u0013)KA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\f\u0001\u0002Z3mK\u001e\fG/Z\u000b\u0003\u0005c\u00032!\u0010BZ\u0013\r\u0011)L\u000e\u0002\u001a%\u00064GOU3qY&\u001c\u0017m\u00115b]\u001e,G)\u001a7fO\u0006$X-\u0001\u0007eK2,w-\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\nm\u0006\"\u0003B_K\u0005\u0005\t\u0019\u0001BY\u0003\rAH%M\u0001\nI\u0016dWmZ1uK\u0002\n\u0001\u0004Z3gKJ\u0014\u0018N\\4NKR\fG-\u0019;b\u0007\"\fgnZ3t\u0003q!WMZ3se&tw-T3uC\u0012\fG/Y\"iC:<Wm]0%KF$B!a@\u0003H\"I!Q\u0018\u0015\u0002\u0002\u0003\u0007!1K\u0001\u001aI\u00164WM\u001d:j]\u001elU\r^1eCR\f7\t[1oO\u0016\u001c\b%A\u000ecK\u001eLg.T3uC\u0012\fG/Y\"iC:<W\rR3gKJ\u0014\u0018\r\u001c\u000b\u0003\u0003\u007f\f\u0011$\u001a8e\u001b\u0016$\u0018\rZ1uC\u000eC\u0017M\\4f\t\u00164WM\u001d:bYR!\u0011q Bj\u0011\u001d\u0011)n\u000ba\u0001\u0005/\f!c\u001c8MK\u0006$WM]:iSB\u001c\u0005.\u00198hKBQ\u0011q\u000eBm\u0005;\u0014i.a@\n\t\tm\u0017\u0011\u000f\u0002\n\rVt7\r^5p]J\u0002bA!\u000b\u0003`\nu\u0014\u0002\u0002Bq\u0005o\u0011\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\u0016Q\u0006tG\r\\3NKR\fG-\u0019;b%\u0016\u001cwN\u001d3t)!\tyPa:\u0003r\nU\bb\u0002BuY\u0001\u0007!1^\u0001\rS6\fw-\u001a\"vS2$WM\u001d\t\u0005\u0003/\u0011i/\u0003\u0003\u0003p\u0006e!\u0001F'fi\u0006$\u0017\r^1J[\u0006<WMQ;jY\u0012,'\u000fC\u0004\u0003t2\u0002\rAa\u0011\u0002\u001d5,G/\u00193bi\u0006|eMZ:fi\"9!Q\u001b\u0017A\u0002\t]\u0017!F7be.\u0004\u0016M\u001d;ji&|g\u000eR3gKJ\u0014X\r\u001a\u000b\u0007\u0003\u007f\u0014YP!@\t\u000f\tmT\u00061\u0001\u0003~!9!q`\u0017A\u0002\tM\u0013!B5t\u001d\u0016<H\u0003BA\u0000\u0007\u0007AqAa\u0018/\u0001\u0004\u0011\t'\u0001\u000eeK\u001a,'O]3e!\u0006\u0014H/\u001b;j_:\u001c\u0018\n^3sCR|'/\u0006\u0002\u0004\nA1!\u0011FB\u0006\u0005CJAa!\u0004\u00038\tA\u0011\n^3sCR|'/A\u0006dC\u000eDW\rZ*uCR,GCBB\n\u00073\u0019\u0019\u0003\u0005\u0003\u0002\u0018\rU\u0011\u0002BB\f\u00033\u0011\u0011#T3uC\u0012\fG/\u0019)beRLG/[8o\u0011\u001d\u0019Y\u0002\ra\u0001\u0007;\tQ\"\\3uC\u0012\fG/Y%nC\u001e,\u0007\u0003BA\f\u0007?IAa!\t\u0002\u001a\tiQ*\u001a;bI\u0006$\u0018-S7bO\u0016DqAa\u001f1\u0001\u0004\u0011i(\u0001\nSC\u001a$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA\u001f3'\r\u0011\u0014Q\u001d\u000b\u0003\u0007O\tA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n4'\u0006\u0002\u00042)\"\u0011QNB\u001aW\t\u0019)\u0004\u0005\u0003\u00048\r\u0005SBAB\u001d\u0015\u0011\u0019Yd!\u0010\u0002\u0013Ut7\r[3dW\u0016$'\u0002BB \u0003c\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0019\u0019e!\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class RaftReplicaManager
extends ReplicaManager {
    private final Time time;
    private final ConfigRepository configRepository;
    private RaftReplicaChangeDelegate delegate;
    private boolean deferringMetadataChanges;

    public static Option<String> $lessinit$greater$default$13() {
        return RaftReplicaManager$.MODULE$.$lessinit$greater$default$13();
    }

    public RaftReplicaChangeDelegate delegate() {
        return this.delegate;
    }

    public void delegate_$eq(RaftReplicaChangeDelegate x$1) {
        this.delegate = x$1;
    }

    private boolean deferringMetadataChanges() {
        return this.deferringMetadataChanges;
    }

    private void deferringMetadataChanges_$eq(boolean x$1) {
        this.deferringMetadataChanges = x$1;
    }

    public void beginMetadataChangeDeferral() {
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            this.deferringMetadataChanges_$eq(true);
            this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metadata changes are now being deferred");
            return;
        }
    }

    public void endMetadataChangeDeferral(Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit> onLeadershipChange) {
        long startMs = this.time.milliseconds();
        ObjectRef partitionsMadeFollower = ObjectRef.create((Object)Set$.MODULE$.empty());
        ObjectRef partitionsMadeLeader = ObjectRef.create((Object)Set$.MODULE$.empty());
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Applying deferred metadata changes");
            LazyOffsetCheckpoints highWatermarkCheckpoints = new LazyOffsetCheckpoints(this.highWatermarkCheckpoints());
            MetadataImage metadataImage = ((RaftMetadataCache)super.metadataCache()).currentImage();
            MetadataBrokers brokers = metadataImage.brokers();
            try {
                scala.collection.mutable.Map liftedTree1$1_leaderPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                scala.collection.mutable.Map liftedTree1$1_followerPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                scala.collection.mutable.Set liftedTree1$1_partitionsAlreadyExisting = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.deferredPartitionsIterator().foreach((Function1 & Serializable & scala.Serializable)deferredPartition -> {
                    Partition partition = deferredPartition.partition();
                    MetadataPartition state = this.cachedState(metadataImage, partition);
                    if (state.leaderId() == this.localBrokerId()) {
                        leaderPartitionStates.put((Object)partition, (Object)state);
                    } else {
                        followerPartitionStates.put((Object)partition, (Object)state);
                    }
                    if (!deferredPartition.isNew()) {
                        return partitionsAlreadyExisting.$plus$eq((Object)state);
                    }
                    return BoxedUnit.UNIT;
                });
                if (liftedTree1$1_leaderPartitionStates.nonEmpty()) {
                    partitionsMadeLeader.elem = this.delegate().makeLeaders((Set<MetadataPartition>)liftedTree1$1_partitionsAlreadyExisting, (Map<Partition, MetadataPartition>)liftedTree1$1_leaderPartitionStates, highWatermarkCheckpoints, (Option<Object>)None$.MODULE$);
                }
                if (liftedTree1$1_followerPartitionStates.nonEmpty()) {
                    partitionsMadeFollower.elem = this.delegate().makeFollowers((Set<MetadataPartition>)liftedTree1$1_partitionsAlreadyExisting, brokers, (Map<Partition, MetadataPartition>)liftedTree1$1_followerPartitionStates, highWatermarkCheckpoints, (Option<Object>)None$.MODULE$);
                }
                this.deferredPartitionsIterator().foreach((Function1 & Serializable & scala.Serializable)deferredPartition -> {
                    Partition partition = deferredPartition.partition();
                    return this.allPartitions().put(partition.topicPartition(), new HostedPartition.Online(partition));
                });
                this.updateLeaderAndFollowerMetrics((Set<String>)((TraversableOnce)((Set)partitionsMadeFollower.elem).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom())).toSet());
                this.maybeAddLogDirFetchers((Set<Partition>)((Set)partitionsMadeFollower.elem), highWatermarkCheckpoints);
                this.replicaFetcherManager().shutdownIdleFetcherThreads();
                this.replicaAlterLogDirsManager().shutdownIdleFetcherThreads();
                if (((Set)partitionsMadeLeader.elem).nonEmpty() || ((Set)partitionsMadeFollower.elem).nonEmpty()) {
                    onLeadershipChange.apply((Object)((Set)partitionsMadeLeader.elem), (Object)((Set)partitionsMadeFollower.elem));
                }
            }
            catch (Throwable liftedTree1$1_e) {
                this.deferredPartitionsIterator().foreach((Function1 & Serializable & scala.Serializable)metadata -> {
                    RaftReplicaManager.$anonfun$endMetadataChangeDeferral$5(this, metadataImage, e, metadata);
                    return BoxedUnit.UNIT;
                });
                this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Applied ").append(((Set)partitionsMadeLeader$1.elem).size() + ((Set)partitionsMadeFollower$1.elem).size()).append(" deferred partitions prior to the error: ").append(((Set)partitionsMadeLeader$1.elem).size()).append(" leader(s) and ").append(((Set)partitionsMadeFollower$1.elem).size()).append(" follower(s)").toString());
                throw liftedTree1$1_e;
            }
            this.deferringMetadataChanges_$eq(false);
        }
        long elapsedMs = this.time.milliseconds() - startMs;
        this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Applied ").append(((Set)partitionsMadeLeader$1.elem).size() + ((Set)partitionsMadeFollower$1.elem).size()).append(" deferred partitions: ").append(((Set)partitionsMadeLeader$1.elem).size()).append(" leader(s) and ").append(((Set)partitionsMadeFollower$1.elem).size()).append(" follower(s)").append("in ").append(elapsedMs).append(" ms").toString());
        this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metadata changes are no longer being deferred");
    }

    public void handleMetadataRecords(MetadataImageBuilder imageBuilder, long metadataOffset, Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit> onLeadershipChange) {
        long startMs = this.time.milliseconds();
        MetadataPartitionsBuilder builder = imageBuilder.partitionsBuilder();
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Metadata batch %d: %d local partition(s) changed, %d local partition(s) removed.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)metadataOffset), BoxesRunTime.boxToInteger((int)builder.localChanged().size()), BoxesRunTime.boxToInteger((int)builder.localRemoved().size())})));
            if (this.stateChangeLogger().isTraceEnabled()) {
                builder.localChanged().foreach((Function1 & Serializable & scala.Serializable)state -> {
                    RaftReplicaManager.$anonfun$handleMetadataRecords$2(this, metadataOffset, state);
                    return BoxedUnit.UNIT;
                });
                builder.localRemoved().foreach((Function1 & Serializable & scala.Serializable)state -> {
                    RaftReplicaManager.$anonfun$handleMetadataRecords$4(this, metadataOffset, state);
                    return BoxedUnit.UNIT;
                });
            }
            if (this.deferringMetadataChanges()) {
                MetadataPartitions prevPartitions = imageBuilder.prevImage().partitions();
                HashMap partitionChangesToBeDeferred = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                builder.localChanged().foreach((Function1 & Serializable & scala.Serializable)currentState -> {
                    RaftReplicaManager.$anonfun$handleMetadataRecords$6(this, metadataOffset, prevPartitions, partitionChangesToBeDeferred, currentState);
                    return BoxedUnit.UNIT;
                });
                this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Deferring metadata changes for ").append(partitionChangesToBeDeferred.size()).append(" partition(s)").toString());
                if (partitionChangesToBeDeferred.nonEmpty()) {
                    this.delegate().makeDeferred((Map<Partition, Object>)partitionChangesToBeDeferred, metadataOffset);
                }
            } else {
                HashMap partitionsToBeLeader = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                HashMap partitionsToBeFollower = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                builder.localChanged().foreach((Function1 & Serializable & scala.Serializable)currentState -> {
                    RaftReplicaManager.$anonfun$handleMetadataRecords$10(this, metadataOffset, partitionsToBeLeader, partitionsToBeFollower, currentState);
                    return BoxedUnit.UNIT;
                });
                MetadataPartitions prevPartitions = imageBuilder.prevImage().partitions();
                scala.collection.mutable.Set changedPartitionsPreviouslyExisting = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
                builder.localChanged().foreach((Function1 & Serializable & scala.Serializable)metadataPartition -> {
                    RaftReplicaManager.$anonfun$handleMetadataRecords$13(prevPartitions, changedPartitionsPreviouslyExisting, metadataPartition);
                    return BoxedUnit.UNIT;
                });
                MetadataBrokers nextBrokers = imageBuilder.brokers();
                LazyOffsetCheckpoints highWatermarkCheckpoints = new LazyOffsetCheckpoints(this.highWatermarkCheckpoints());
                Set<Partition> partitionsBecomeLeader = partitionsToBeLeader.nonEmpty() ? this.delegate().makeLeaders((Set<MetadataPartition>)changedPartitionsPreviouslyExisting, (Map<Partition, MetadataPartition>)partitionsToBeLeader, highWatermarkCheckpoints, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)metadataOffset))) : Set$.MODULE$.empty();
                Set<Partition> partitionsBecomeFollower = partitionsToBeFollower.nonEmpty() ? this.delegate().makeFollowers((Set<MetadataPartition>)changedPartitionsPreviouslyExisting, nextBrokers, (Map<Partition, MetadataPartition>)partitionsToBeFollower, highWatermarkCheckpoints, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)metadataOffset))) : Set$.MODULE$.empty();
                this.updateLeaderAndFollowerMetrics((Set<String>)((TraversableOnce)partitionsBecomeFollower.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topic(), Set$.MODULE$.canBuildFrom())).toSet());
                builder.localChanged().foreach((Function1 & Serializable & scala.Serializable)state -> {
                    RaftReplicaManager.$anonfun$handleMetadataRecords$16(this, state);
                    return BoxedUnit.UNIT;
                });
                this.maybeAddLogDirFetchers(partitionsBecomeFollower, highWatermarkCheckpoints);
                this.replicaFetcherManager().shutdownIdleFetcherThreads();
                this.replicaAlterLogDirsManager().shutdownIdleFetcherThreads();
                onLeadershipChange.apply(partitionsBecomeLeader, partitionsBecomeFollower);
                this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Metadata batch ").append(metadataOffset).append(": applied ").append(partitionsBecomeLeader.size() + partitionsBecomeFollower.size()).append(" partitions: ").append(partitionsBecomeLeader.size()).append(" leader(s) and ").append(partitionsBecomeFollower.size()).append(" follower(s)").toString());
            }
            if (builder.localRemoved().nonEmpty()) {
                this.stopPartitions((Map<TopicPartition, Object>)((TraversableOnce)builder.localRemoved().map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$4.toTopicPartition()), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    RaftReplicaManager.$anonfun$handleMetadataRecords$19(this, metadataOffset, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
        }
        long elapsedMs = this.time.milliseconds() - startMs;
        this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Metadata batch ").append(metadataOffset).append(": handled replica changes ").append("in ").append(elapsedMs).append(" ms").toString());
    }

    public void markPartitionDeferred(Partition partition, boolean isNew) {
        this.kafka$server$RaftReplicaManager$$markPartitionDeferred(new HostedPartition.Deferred(partition, isNew));
    }

    public void kafka$server$RaftReplicaManager$$markPartitionDeferred(HostedPartition.Deferred state) {
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            this.allPartitions().put(state.partition().topicPartition(), state);
            return;
        }
    }

    private Iterator<HostedPartition.Deferred> deferredPartitionsIterator() {
        return this.allPartitions().values().iterator().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            if (x0$1 instanceof HostedPartition.Deferred) {
                HostedPartition.Deferred deferred = (HostedPartition.Deferred)x0$1;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)deferred));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        });
    }

    private MetadataPartition cachedState(MetadataImage metadataImage, Partition partition) {
        return (MetadataPartition)metadataImage.partitions().topicPartition(partition.topic(), partition.partitionId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(73).append("Partition has metadata changes but does not exist in the metadata cache: ").append(partition.topicPartition()).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$endMetadataChangeDeferral$5(RaftReplicaManager $this, MetadataImage metadataImage$1, Throwable e$1, HostedPartition.Deferred metadata) {
        Partition partition = metadata.partition();
        MetadataPartition state = $this.cachedState(metadataImage$1, partition);
        TopicPartition topicPartition = partition.topicPartition();
        String leaderOrFollower = state.leaderId() == $this.localBrokerId() ? "leader" : "follower";
        String partitionLogMsgPrefix = new StringBuilder(26).append("Apply deferred ").append(leaderOrFollower).append(" partition ").append(topicPartition).toString();
        $this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append(partitionLogMsgPrefix).append(": error while applying deferred metadata.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e$1);
    }

    private final /* synthetic */ void liftedTree1$1(MetadataImage metadataImage$1, ObjectRef partitionsMadeLeader$1, LazyOffsetCheckpoints highWatermarkCheckpoints$1, ObjectRef partitionsMadeFollower$1, MetadataBrokers brokers$1, Function2 onLeadershipChange$1) {
        try {
            scala.collection.mutable.Map leaderPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map followerPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Set partitionsAlreadyExisting = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.deferredPartitionsIterator().foreach((Function1 & Serializable & scala.Serializable)deferredPartition -> {
                Partition partition = deferredPartition.partition();
                MetadataPartition state = this.cachedState(metadataImage, partition);
                if (state.leaderId() == this.localBrokerId()) {
                    leaderPartitionStates.put((Object)partition, (Object)state);
                } else {
                    followerPartitionStates.put((Object)partition, (Object)state);
                }
                if (!deferredPartition.isNew()) {
                    return partitionsAlreadyExisting.$plus$eq((Object)state);
                }
                return BoxedUnit.UNIT;
            });
            if (leaderPartitionStates.nonEmpty()) {
                partitionsMadeLeader$1.elem = this.delegate().makeLeaders((Set<MetadataPartition>)partitionsAlreadyExisting, (Map<Partition, MetadataPartition>)leaderPartitionStates, highWatermarkCheckpoints$1, (Option<Object>)None$.MODULE$);
            }
            if (followerPartitionStates.nonEmpty()) {
                partitionsMadeFollower$1.elem = this.delegate().makeFollowers((Set<MetadataPartition>)partitionsAlreadyExisting, brokers$1, (Map<Partition, MetadataPartition>)followerPartitionStates, highWatermarkCheckpoints$1, (Option<Object>)None$.MODULE$);
            }
            this.deferredPartitionsIterator().foreach((Function1 & Serializable & scala.Serializable)deferredPartition -> {
                Partition partition = deferredPartition.partition();
                return this.allPartitions().put(partition.topicPartition(), new HostedPartition.Online(partition));
            });
            this.updateLeaderAndFollowerMetrics((Set<String>)((TraversableOnce)((Set)partitionsMadeFollower$1.elem).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom())).toSet());
            this.maybeAddLogDirFetchers((Set<Partition>)((Set)partitionsMadeFollower$1.elem), highWatermarkCheckpoints$1);
            this.replicaFetcherManager().shutdownIdleFetcherThreads();
            this.replicaAlterLogDirsManager().shutdownIdleFetcherThreads();
            if (((Set)partitionsMadeLeader$1.elem).nonEmpty() || ((Set)partitionsMadeFollower$1.elem).nonEmpty()) {
                onLeadershipChange$1.apply((Object)((Set)partitionsMadeLeader$1.elem), (Object)((Set)partitionsMadeFollower$1.elem));
            }
        }
        catch (Throwable e) {
            this.deferredPartitionsIterator().foreach((Function1 & Serializable & scala.Serializable)metadata -> {
                RaftReplicaManager.$anonfun$endMetadataChangeDeferral$5(this, metadataImage, e, metadata);
                return BoxedUnit.UNIT;
            });
            this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Applied ").append(((Set)partitionsMadeLeader$1.elem).size() + ((Set)partitionsMadeFollower$1.elem).size()).append(" deferred partitions prior to the error: ").append(((Set)partitionsMadeLeader$1.elem).size()).append(" leader(s) and ").append(((Set)partitionsMadeFollower$1.elem).size()).append(" follower(s)").toString());
            throw e;
        }
    }

    public static final /* synthetic */ void $anonfun$handleMetadataRecords$2(RaftReplicaManager $this, long metadataOffset$1, MetadataPartition state) {
        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Metadata batch ").append(metadataOffset$1).append(": locally changed: ").append(state).toString());
    }

    public static final /* synthetic */ void $anonfun$handleMetadataRecords$4(RaftReplicaManager $this, long metadataOffset$1, MetadataPartition state) {
        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Metadata batch ").append(metadataOffset$1).append(": locally removed: ").append(state).toString());
    }

    public static final /* synthetic */ Option $anonfun$handleMetadataRecords$8(Option priorDeferredMetadata$1, MetadataPartitions prevPartitions$1, TopicPartition topicPartition$1, HashMap partitionChangesToBeDeferred$1, Partition partition) {
        boolean bl = priorDeferredMetadata$1 instanceof Some ? ((HostedPartition.Deferred)((Some)priorDeferredMetadata$1).value()).isNew() : prevPartitions$1.topicPartition(topicPartition$1.topic(), topicPartition$1.partition()).isEmpty();
        return partitionChangesToBeDeferred$1.put((Object)partition, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$handleMetadataRecords$6(RaftReplicaManager $this, long metadataOffset$1, MetadataPartitions prevPartitions$1, HashMap partitionChangesToBeDeferred$1, MetadataPartition currentState) {
        void var12_13;
        void var11_12;
        None$ none$;
        None$ none$2;
        TopicPartition topicPartition = currentState.toTopicPartition();
        HostedPartition hostedPartition = $this.getPartition(topicPartition);
        if (HostedPartition$Offline$.MODULE$.equals(hostedPartition)) {
            $this.stateChangeLogger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Ignoring handlePartitionChanges at ").append(metadataOffset$1).append(" ").append("for partition ").append(topicPartition).append(" as the local replica for the partition is ").append("in an offline log directory").toString());
            none$2 = None$.MODULE$;
            none$ = None$.MODULE$;
        } else if (hostedPartition instanceof HostedPartition.Online) {
            Partition partition = ((HostedPartition.Online)hostedPartition).partition();
            none$2 = None$.MODULE$;
            none$ = new Some((Object)partition);
        } else if (hostedPartition instanceof HostedPartition.Deferred) {
            HostedPartition.Deferred deferred = (HostedPartition.Deferred)hostedPartition;
            Partition partition = deferred.partition();
            none$2 = new Some((Object)deferred);
            none$ = new Some((Object)partition);
        } else if (HostedPartition$None$.MODULE$.equals(hostedPartition)) {
            none$2 = None$.MODULE$;
            none$ = new Some((Object)Partition$.MODULE$.apply(topicPartition, $this.time, $this.configRepository, $this));
        } else {
            throw new MatchError((Object)hostedPartition);
        }
        Option partition = (Option)none$;
        Option priorDeferredMetadata = (Option)none$2;
        var11_12.foreach(arg_0 -> RaftReplicaManager.$anonfun$handleMetadataRecords$8((Option)var12_13, prevPartitions$1, topicPartition, partitionChangesToBeDeferred$1, arg_0));
    }

    public static final /* synthetic */ void $anonfun$handleMetadataRecords$10(RaftReplicaManager $this, long metadataOffset$1, HashMap partitionsToBeLeader$1, HashMap partitionsToBeFollower$1, MetadataPartition currentState) {
        None$ none$;
        TopicPartition topicPartition = currentState.toTopicPartition();
        HostedPartition hostedPartition = $this.getPartition(topicPartition);
        if (HostedPartition$Offline$.MODULE$.equals(hostedPartition)) {
            $this.stateChangeLogger().warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Ignoring handlePartitionChanges at ").append(metadataOffset$1).append(" ").append("for partition ").append(topicPartition).append(" as the local replica for the partition is ").append("in an offline log directory").toString());
            none$ = None$.MODULE$;
        } else if (hostedPartition instanceof HostedPartition.Online) {
            Partition partition2 = ((HostedPartition.Online)hostedPartition).partition();
            none$ = new Some((Object)partition2);
        } else {
            if (hostedPartition instanceof HostedPartition.Deferred) {
                throw new IllegalStateException(new StringBuilder(84).append("There should never be deferred partition metadata when we aren't deferring changes: ").append(topicPartition).toString());
            }
            if (HostedPartition$None$.MODULE$.equals(hostedPartition)) {
                Partition partition3 = Partition$.MODULE$.apply(topicPartition, $this.time, $this.configRepository, $this);
                $this.allPartitions().putIfNotExists(topicPartition, new HostedPartition.Online(partition3));
                none$ = new Some((Object)partition3);
            } else {
                throw new MatchError((Object)hostedPartition);
            }
        }
        none$.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            if (currentState.leaderId() == $this.localBrokerId()) {
                return partitionsToBeLeader$1.put(partition, (Object)currentState);
            }
            return partitionsToBeFollower$1.put(partition, (Object)currentState);
        });
    }

    public static final /* synthetic */ void $anonfun$handleMetadataRecords$13(MetadataPartitions prevPartitions$2, scala.collection.mutable.Set changedPartitionsPreviouslyExisting$1, MetadataPartition metadataPartition) {
        prevPartitions$2.topicPartition(metadataPartition.topicName(), metadataPartition.partitionIndex()).foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)changedPartitionsPreviouslyExisting$1.add((Object)elem)));
    }

    public static final /* synthetic */ void $anonfun$handleMetadataRecords$16(RaftReplicaManager $this, MetadataPartition state) {
        TopicPartition topicPartition = state.toTopicPartition();
        if ($this.localLog(topicPartition).isEmpty()) {
            $this.markPartitionOffline(topicPartition);
        }
    }

    public static final /* synthetic */ void $anonfun$handleMetadataRecords$19(RaftReplicaManager $this, long metadataOffset$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Throwable e = (Throwable)x0$1._2();
            if (e instanceof KafkaStorageException) {
                $this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("Metadata batch ").append(metadataOffset$1).append(": unable to delete ").append(topicPartition).append(" as the local replica for the partition is in an offline ").append("log directory").toString());
                return;
            }
            $this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Metadata batch ").append(metadataOffset$1).append(": unable to delete ").append(topicPartition).append(" due to an unexpected ").append(e.getClass().getName()).append(" exception: ").append(e.getMessage()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public RaftReplicaManager(KafkaConfig config, Metrics metrics, Time time, Scheduler scheduler, LogManager logManager, AtomicBoolean isShuttingDown, QuotaFactory.QuotaManagers quotaManagers, BrokerTopicStats brokerTopicStats, RaftMetadataCache metadataCache, LogDirFailureChannel logDirFailureChannel, DelayedOperationPurgatory<DelayedProduce> delayedProducePurgatory, DelayedOperationPurgatory<DelayedFetch> delayedFetchPurgatory, DelayedOperationPurgatory<DelayedDeleteRecords> delayedDeleteRecordsPurgatory, DelayedOperationPurgatory<DelayedElectLeader> delayedElectLeaderPurgatory, DelayedOperationPurgatory<DelayedListOffsets> delayedListOffsetsPurgatory, Option<String> threadNamePrefix, ConfigRepository configRepository, AlterIsrManager alterIsrManager) {
        this.time = time;
        this.configRepository = configRepository;
        super(config, metrics, time, (Option<KafkaZkClient>)None$.MODULE$, scheduler, logManager, isShuttingDown, quotaManagers, brokerTopicStats, metadataCache, logDirFailureChannel, delayedProducePurgatory, delayedFetchPurgatory, delayedDeleteRecordsPurgatory, delayedElectLeaderPurgatory, delayedListOffsetsPurgatory, TierReplicaComponents$.MODULE$.EMPTY(), (Option<ClusterLinkFactory.LinkManager>)None$.MODULE$, threadNamePrefix, configRepository, alterIsrManager);
        if (super.config().requiresZookeeper()) {
            throw new IllegalStateException(new StringBuilder(32).append("Cannot use ").append(this.getClass().getSimpleName()).append(" when using ZooKeeper").toString());
        }
        this.delegate = new RaftReplicaChangeDelegate(new RaftReplicaManagerChangeDelegateHelper(this, this));
        this.deferringMetadataChanges = true;
        this.stateChangeLogger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metadata changes are initially being deferred");
    }

    public RaftReplicaManager(KafkaConfig config, Metrics metrics, Time time, Scheduler scheduler, LogManager logManager, AtomicBoolean isShuttingDown, QuotaFactory.QuotaManagers quotaManagers, BrokerTopicStats brokerTopicStats, RaftMetadataCache metadataCache, LogDirFailureChannel logDirFailureChannel, AlterIsrManager alterIsrManager, ConfigRepository configRepository, Option<String> threadNamePrefix) {
        this(config, metrics, time, scheduler, logManager, isShuttingDown, quotaManagers, brokerTopicStats, metadataCache, logDirFailureChannel, DelayedOperationPurgatory$.MODULE$.apply("Produce", config.brokerId(), Predef$.MODULE$.Integer2int(config.producerPurgatoryPurgeIntervalRequests()), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()), DelayedOperationPurgatory$.MODULE$.apply("Fetch", config.brokerId(), Predef$.MODULE$.Integer2int(config.fetchPurgatoryPurgeIntervalRequests()), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()), DelayedOperationPurgatory$.MODULE$.apply("DeleteRecords", config.brokerId(), Predef$.MODULE$.Integer2int(config.deleteRecordsPurgatoryPurgeIntervalRequests()), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()), DelayedOperationPurgatory$.MODULE$.apply("ElectLeader", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()), DelayedOperationPurgatory$.MODULE$.apply("ListOffsets", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()), threadNamePrefix, configRepository, alterIsrManager);
    }

    public class RaftReplicaManagerChangeDelegateHelper
    implements RaftReplicaChangeDelegateHelper {
        private final RaftReplicaManager raftReplicaManager;
        public final /* synthetic */ RaftReplicaManager $outer;

        @Override
        public void completeDelayedRequests(TopicPartition topicPartition) {
            this.raftReplicaManager.completeDelayedRequests(topicPartition);
        }

        @Override
        public KafkaConfig config() {
            return this.raftReplicaManager.config();
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            this.raftReplicaManager.error(msg, e);
        }

        @Override
        public Option<String> getLogDir(TopicPartition topicPartition) {
            return this.raftReplicaManager.getLogDir(topicPartition);
        }

        @Override
        public long initialFetchOffset(AbstractLog log) {
            return this.raftReplicaManager.initialFetchOffset(log);
        }

        @Override
        public boolean isShuttingDown() {
            return this.raftReplicaManager.isShuttingDown().get();
        }

        @Override
        public void markDeferred(HostedPartition.Deferred state) {
            this.raftReplicaManager.kafka$server$RaftReplicaManager$$markPartitionDeferred(state);
        }

        @Override
        public void markOffline(TopicPartition topicPartition) {
            this.raftReplicaManager.markPartitionOffline(topicPartition);
        }

        @Override
        public void markOnline(Partition partition) {
            this.raftReplicaManager.allPartitions().put(partition.topicPartition(), new HostedPartition.Online(partition));
        }

        @Override
        public ReplicaAlterLogDirsManager replicaAlterLogDirsManager() {
            return this.raftReplicaManager.replicaAlterLogDirsManager();
        }

        @Override
        public ReplicaFetcherManager replicaFetcherManager() {
            return this.raftReplicaManager.replicaFetcherManager();
        }

        @Override
        public StateChangeLogger stateChangeLogger() {
            return this.raftReplicaManager.stateChangeLogger();
        }

        public /* synthetic */ RaftReplicaManager kafka$server$RaftReplicaManager$RaftReplicaManagerChangeDelegateHelper$$$outer() {
            return this.$outer;
        }

        public RaftReplicaManagerChangeDelegateHelper(RaftReplicaManager $outer, RaftReplicaManager raftReplicaManager) {
            this.raftReplicaManager = raftReplicaManager;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

