/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.DefaultRequestLogFilter;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tq\u0001\u0011)\u0019!C\u0001s!AQ\b\u0001B\u0001B\u0003%!\b\u0003\u0005?\u0001\t\u0015\r\u0011\"\u0001@\u0011!1\u0005A!A!\u0002\u0013\u0001\u0005\u0002C$\u0001\u0005\u000b\u0007I\u0011\u0001%\t\u00111\u0003!\u0011!Q\u0001\n%C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t5\u0002\u0011\t\u0011)A\u0005u!A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003]\u0011!\u0001\u0004A!b\u0001\n\u0013A\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u000b=\u0004A\u0011\u00019\t\u000fm\u0004!\u0019!C\u0005y\"9\u00111\u0003\u0001!\u0002\u0013i\b\"CA\u000b\u0001\t\u0007I\u0011BA\f\u0011!\ty\u0003\u0001Q\u0001\n\u0005e\u0001\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\t\t\u0005\u0001Q\u0001\n\u0005U\u0002\"CA\"\u0001\t\u0007I\u0011AA#\u0011!\ti\u0006\u0001Q\u0001\n\u0005\u001d\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t)\b\u0001C\u0001\u0003o\u0012qcS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7\u000b\u0005qi\u0012AB:feZ,'OC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u0011([A\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0016\u000e\u0003%R!AK\u000f\u0002\u000bU$\u0018\u000e\\:\n\u00051J#a\u0002'pO\u001eLgn\u001a\t\u0003]Ej\u0011a\f\u0006\u0003au\tq!\\3ue&\u001c7/\u0003\u00023_\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\r\r|gNZ5h!\t)d'D\u0001\u001c\u0013\t94DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u00032s_.,'/\u00133\u0016\u0003i\u0002\"AI\u001e\n\u0005q\u001a#aA%oi\u0006I!M]8lKJLE\rI\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m+\u0005\u0001\u0005CA!E\u001b\u0005\u0011%BA\"\u001e\u0003\u001dqW\r^<pe.L!!\u0012\"\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0003ba&\u001cX#A%\u0011\u0005UR\u0015BA&\u001c\u0005E\t\u0005/\u001b*fcV,7\u000f\u001e%b]\u0012dWM]\u0001\u0006CBL7\u000fI\u0001\u0005i&lW\r\u0005\u0002P16\t\u0001K\u0003\u0002+#*\u0011!kU\u0001\u0007G>lWn\u001c8\u000b\u0005y!&BA+W\u0003\u0019\t\u0007/Y2iK*\tq+A\u0002pe\u001eL!!\u0017)\u0003\tQKW.Z\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\u0018a\b:fcV,7\u000f\u001e%b]\u0012dWM]!wO&#G.Z'fiJL7MT1nKB\u0011Q\f\u001a\b\u0003=\n\u0004\"aX\u0012\u000e\u0003\u0001T!!Y\u0010\u0002\rq\u0012xn\u001c;?\u0013\t\u00197%\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2$\u0003YawnZ!oIRC'/Z1e\u001d\u0006lW\r\u0015:fM&DX#A5\u0011\u0005)dW\"A6\u000b\u0005A\n\u0016BA7l\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015E\u00148\u000f^;wobL(\u0010\u0005\u00026\u0001!)1G\u0004a\u0001i!)\u0001H\u0004a\u0001u!)aH\u0004a\u0001\u0001\")qI\u0004a\u0001\u0013\")QJ\u0004a\u0001\u001d\")!L\u0004a\u0001u!)1L\u0004a\u00019\")qM\u0004a\u00019\")\u0001G\u0004a\u0001S\u0006qA\u000f\u001b:fC\u0012\u0004vn\u001c7TSj,W#A?\u0011\u0007y\fy!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\r\u0005$x.\\5d\u0015\u0011\t)!a\u0002\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\n\u0005-\u0011\u0001B;uS2T!!!\u0004\u0002\t)\fg/Y\u0005\u0004\u0003#y(!D!u_6L7-\u00138uK\u001e,'/A\buQJ,\u0017\r\u001a)p_2\u001c\u0016N_3!\u0003I\twm\u001a:fO\u0006$X-\u00133mK6+G/\u001a:\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Wi!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0005G>\u0014XMC\u00021\u0003GQA!!\n\u0002(\u00051\u00110Y7nKJT!!!\u000b\u0002\u0007\r|W.\u0003\u0003\u0002.\u0005u!!B'fi\u0016\u0014\u0018aE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ\u0004\u0013a\u0007;ie\u0016\fG\r]8pY\u000e\u000b\u0007/Y2jif\u001cVM\\:pe>\u0003H/\u0006\u0002\u00026A)!%a\u000e\u0002<%\u0019\u0011\u0011H\u0012\u0003\r=\u0003H/[8o!\rQ\u0017QH\u0005\u0004\u0003\u007fY'AB*f]N|'/\u0001\u000fuQJ,\u0017\r\u001a9p_2\u001c\u0015\r]1dSRL8+\u001a8t_J|\u0005\u000f\u001e\u0011\u0002\u0013I,hN\\1cY\u0016\u001cXCAA$!\u0019\tI%a\u0015\u0002X5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0004nkR\f'\r\\3\u000b\u0007\u0005E3%\u0001\u0006d_2dWm\u0019;j_:LA!!\u0016\u0002L\tY\u0011I\u001d:bs\n+hMZ3s!\r)\u0014\u0011L\u0005\u0004\u00037Z\"aE&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014\u0018A\u0003:v]:\f'\r\\3tA\u0005i1M]3bi\u0016D\u0015M\u001c3mKJ$B!a\u0019\u0002jA\u0019!%!\u001a\n\u0007\u0005\u001d4E\u0001\u0003V]&$\bBBA6/\u0001\u0007!(\u0001\u0002jI\u0006\u0001\"/Z:ju\u0016$\u0006N]3bIB{w\u000e\u001c\u000b\u0005\u0003G\n\t\b\u0003\u0004\u0002ta\u0001\rAO\u0001\b]\u0016<8+\u001b>f\u0003!\u0019\b.\u001e;e_^tGCAA2\u0001")
public class KafkaRequestHandlerPool
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final Metrics metrics;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final Option<Sensor> threadpoolCapacitySensorOpt;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    private Option<Sensor> threadpoolCapacitySensorOpt() {
        return this.threadpoolCapacitySensorOpt;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        DefaultRequestLogFilter requestLogFilter = new DefaultRequestLogFilter(this.config.newRequestLogFilter());
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), requestLogFilter, this.apis(), this.time));
        KafkaThread.daemon((String)new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString(), (Runnable)((Runnable)this.runnables().apply(id))).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((KafkaRequestHandler)this.runnables().remove(currentSize - i)).stop());
        }
        this.threadPoolSize().set(newSize);
        this.threadpoolCapacitySensorOpt().foreach((Function1 & Serializable & scala.Serializable)sensor -> {
            sensor.record(100.0 * (double)newSize);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shut down completely");
    }

    public KafkaRequestHandlerPool(KafkaConfig config, int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix, Metrics metrics) {
        None$ none$;
        this.config = config;
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        this.metrics = metrics;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS, this.newMeter$default$4());
        String string = requestHandlerAvgIdleMetricName;
        String string2 = "RequestHandlerAvgIdlePercent";
        if (string != null && string.equals(string2)) {
            Sensor sensor = metrics.sensor("TotalIoThreadsPercentage");
            sensor.add(ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(metrics), (MeasurableStat)new Value());
            sensor.record(100.0 * (double)numThreads);
            none$ = new Some((Object)sensor);
        } else {
            none$ = None$.MODULE$;
        }
        this.threadpoolCapacitySensorOpt = none$;
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.createHandler(i));
    }
}

