/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.server.ApiRequestHandler;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u000e\u001d\u0001\u0005B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005i!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003>\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011]\u0003!Q1A\u0005\u0002aC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\tA\u0002\u0011)\u0019!C\u0001C\"Aq\u000e\u0001B\u0001B\u0003%!\r\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011!)\bA!A!\u0002\u00131\b\"B>\u0001\t\u0003a\b\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\tI\u0002\u0001Q\u0001\n\u0005E\u0001\"CA\u000e\u0001\t\u0007I\u0011BA\u000f\u0011!\t)\u0003\u0001Q\u0001\n\u0005}\u0001\"CA\u0014\u0001\u0001\u0007I\u0011BA\u0015\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019\u0004\u0003\u0005\u0002@\u0001\u0001\u000b\u0015BA\u0016\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017B\u0001\"!\u0014\u0001\t\u0003a\u0012q\n\u0005\b\u0003+\u0002A\u0011BA&\u0011\u001d\t9\u0006\u0001C\u0001\u0003\u0017Bq!!\u0017\u0001\t\u0003\tY\u0005C\u0004\u0002\\\u0001!\t!a\u0013\u0003'-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:\u000b\u0005uq\u0012AB:feZ,'OC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0012+[A\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AB(cU\u0016\u001cG\u000f\u0005\u0002$W%\u0011A\u0006\n\u0002\t%Vtg.\u00192mKB\u0011a&M\u0007\u0002_)\u0011\u0001GH\u0001\u0006kRLGn]\u0005\u0003e=\u0012q\u0001T8hO&tw-\u0001\u0002jIB\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t\u0019\u0011J\u001c;\u0002\u0011\t\u0014xn[3s\u0013\u0012\f!#Y4he\u0016<\u0017\r^3JI2,W*\u001a;feV\tQ\b\u0005\u0002?\u000f6\tqH\u0003\u0002A\u0003\u0006!1m\u001c:f\u0015\t\u00115)A\u0004nKR\u0014\u0018nY:\u000b\u0005\u0011+\u0015AB=b[6,'OC\u0001G\u0003\r\u0019w.\\\u0005\u0003\u0011~\u0012Q!T3uKJ\f1#Y4he\u0016<\u0017\r^3JI2,W*\u001a;fe\u0002\n1\u0003^8uC2D\u0015M\u001c3mKJ$\u0006N]3bIN,\u0012\u0001\u0014\t\u0003\u001bRk\u0011A\u0014\u0006\u0003\u001fB\u000ba!\u0019;p[&\u001c'BA)S\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003'\u001a\nA!\u001e;jY&\u0011QK\u0014\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002)Q|G/\u00197IC:$G.\u001a:UQJ,\u0017\rZ:!\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039z\tqA\\3uo>\u00148.\u0003\u0002_7\nq!+Z9vKN$8\t[1o]\u0016d\u0017a\u0004:fcV,7\u000f^\"iC:tW\r\u001c\u0011\u0002!I,\u0017/^3ti2{wMR5mi\u0016\u0014X#\u00012\u0011\u0005\rlW\"\u00013\u000b\u0005\u00154\u0017\u0001\u0003:fcV,7\u000f^:\u000b\u0005\u001dD\u0017AB2p[6|gN\u0003\u0002 S*\u0011!n[\u0001\u0007CB\f7\r[3\u000b\u00031\f1a\u001c:h\u0013\tqGM\u0001\tSKF,Xm\u001d;M_\u001e4\u0015\u000e\u001c;fe\u0006\t\"/Z9vKN$Hj\\4GS2$XM\u001d\u0011\u0002\t\u0005\u0004\u0018n\u001d\t\u0003eNl\u0011\u0001H\u0005\u0003ir\u0011\u0011#\u00119j%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003\u0011!\u0018.\\3\u0011\u0005]LX\"\u0001=\u000b\u0005A2\u0017B\u0001>y\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)=ihp`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0001C\u0001:\u0001\u0011\u0015\u0019T\u00021\u00015\u0011\u0015QT\u00021\u00015\u0011\u0015YT\u00021\u0001>\u0011\u0015QU\u00021\u0001M\u0011\u00159V\u00021\u0001Z\u0011\u0015\u0001W\u00021\u0001c\u0011\u0015\u0001X\u00021\u0001r\u0011\u0015)X\u00021\u0001w\u0003A\u0019\b.\u001e;e_^t7i\\7qY\u0016$X-\u0006\u0002\u0002\u0012A!\u00111CA\u000b\u001b\u0005\u0001\u0016bAA\f!\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017!E:ikR$wn\u001e8D_6\u0004H.\u001a;fA\u0005q!-\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014XCAA\u0010!\r9\u0018\u0011E\u0005\u0004\u0003GA(A\u0004\"vM\u001a,'oU;qa2LWM]\u0001\u0010EV4g-\u001a:TkB\u0004H.[3sA\u000591\u000f^8qa\u0016$WCAA\u0016!\r)\u0014QF\u0005\u0004\u0003_1$a\u0002\"p_2,\u0017M\\\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005m\u0002cA\u001b\u00028%\u0019\u0011\u0011\b\u001c\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003{\u0019\u0012\u0011!a\u0001\u0003W\t1\u0001\u001f\u00132\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003f\u0001\u000b\u0002DA\u0019Q'!\u0012\n\u0007\u0005\u001dcG\u0001\u0005w_2\fG/\u001b7f\u0003\r\u0011XO\u001c\u000b\u0003\u0003k\tA\u0001]8mYR!\u0011QGA)\u0011\u0019\t\u0019F\u0006a\u0001i\u0005IA/[7f_V$Xj]\u0001\u0011G>l\u0007\u000f\\3uKNCW\u000f\u001e3po:\fAa\u001d;pa\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\\\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final RequestLogFilter requestLogFilter;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final BufferSupplier bufferSupplier;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public RequestLogFilter requestLogFilter() {
        return this.requestLogFilter;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private BufferSupplier bufferSupplier() {
        return this.bufferSupplier;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        try {
            while (!this.stopped()) {
                this.poll(300);
            }
        }
        finally {
            this.completeShutdown();
        }
    }

    public void poll(int timeoutMs) {
        long startSelectTime = this.time.nanoseconds();
        RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(timeoutMs);
        long endTime = this.time.nanoseconds();
        long idleTime = endTime - startSelectTime;
        this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
        if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
            this.stop();
            return;
        }
        if (req instanceof RequestChannel.Request) {
            RequestChannel.Request request = (RequestChannel.Request)req;
            try {
                try {
                    request.requestDequeueTimeNanos_$eq(endTime);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                    request.maybeSetRequestLog(this.requestLogFilter().processRequest(request.context(), request.startTimeNanos()));
                    this.apis.handle(request, this.bufferSupplier());
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            finally {
                request.releaseBuffer();
            }
            return;
        }
        if (req == null) {
            return;
        }
        throw new MatchError((Object)req);
    }

    private void completeShutdown() {
        this.bufferSupplier().close();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, RequestLogFilter requestLogFilter, ApiRequestHandler apis, Time time) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.requestLogFilter = requestLogFilter;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[Kafka Request Handler ").append(id).append(" on Broker ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.bufferSupplier = BufferSupplier.create();
        this.stopped = false;
    }
}

