/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import kafka.network.RequestChannel;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PrincipalDeserializationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class EnvelopeUtils$ {
    public static EnvelopeUtils$ MODULE$;

    static {
        new EnvelopeUtils$();
    }

    public void handleEnvelopeRequest(RequestChannel.Request request, RequestChannel.Metrics requestChannelMetrics, Function1<RequestChannel.Request, BoxedUnit> handler) {
        EnvelopeRequest envelope = (EnvelopeRequest)request.body(ClassTag$.MODULE$.apply(EnvelopeRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        KafkaPrincipal forwardedPrincipal = this.parseForwardedPrincipal(request.context(), envelope.requestPrincipal());
        InetAddress forwardedClientAddress = this.parseForwardedClientAddress(envelope.clientAddress());
        ByteBuffer forwardedRequestBuffer = envelope.requestData().duplicate();
        RequestHeader forwardedRequestHeader = this.parseForwardedRequestHeader(forwardedRequestBuffer);
        ApiKeys forwardedApi = forwardedRequestHeader.apiKey();
        if (!forwardedApi.forwardable) {
            throw new InvalidRequestException(new StringBuilder(53).append("API ").append(forwardedApi).append(" is not enabled or is not eligible for forwarding").toString());
        }
        RequestContext forwardedContext = new RequestContext(forwardedRequestHeader, request.context().connectionId, forwardedClientAddress, forwardedPrincipal, request.context().listenerName, request.context().securityProtocol, ClientInformation.EMPTY, request.context().sniHostName, request.context().fromPrivilegedListener);
        RequestChannel.Request forwardedRequest = this.parseForwardedRequest(request, forwardedContext, forwardedRequestBuffer, requestChannelMetrics);
        handler.apply((Object)forwardedRequest);
    }

    private InetAddress parseForwardedClientAddress(byte[] address) {
        try {
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new InvalidRequestException("Failed to parse client address from envelope", (Throwable)e);
        }
    }

    private RequestChannel.Request parseForwardedRequest(RequestChannel.Request envelope, RequestContext forwardedContext, ByteBuffer buffer, RequestChannel.Metrics requestChannelMetrics) {
        try {
            return new RequestChannel.Request(envelope.processor(), forwardedContext, envelope.startTimeNanos(), envelope.memoryPool(), buffer, requestChannelMetrics, (Option<RequestChannel.Request>)new Some((Object)envelope));
        }
        catch (InvalidRequestException e) {
            throw new UnsupportedVersionException(new StringBuilder(46).append("Failed to parse forwarded request ").append("with header ").append(forwardedContext.header).toString(), (Throwable)e);
        }
    }

    private RequestHeader parseForwardedRequestHeader(ByteBuffer buffer) {
        try {
            return RequestHeader.parse((ByteBuffer)buffer);
        }
        catch (InvalidRequestException e) {
            throw new UnsupportedVersionException("Failed to parse request header from envelope", (Throwable)e);
        }
    }

    private KafkaPrincipal parseForwardedPrincipal(RequestContext envelopeContext, byte[] principalBytes) {
        KafkaPrincipal kafkaPrincipal;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(envelopeContext.principalSerde));
        if (option instanceof Some) {
            try {
                kafkaPrincipal = ((KafkaPrincipalSerde)((Some)option).value()).deserialize(principalBytes);
            }
            catch (Exception e) {
                throw new PrincipalDeserializationException("Failed to deserialize client principal from envelope", (Throwable)e);
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new PrincipalDeserializationException("Could not deserialize principal since no `KafkaPrincipalSerde` has been defined");
            }
            throw new MatchError((Object)option);
        }
        KafkaPrincipal kafkaPrincipal2 = kafkaPrincipal;
        return kafkaPrincipal2;
    }

    private EnvelopeUtils$() {
        MODULE$ = this;
    }
}

