/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBackpressure;
import kafka.server.DynamicBalancerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerTagsConfig;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicClusterLinkConfig;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.DelegatingReconfigurable;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\rUx!\u0002*T\u0011\u0003Af!\u0002.T\u0011\u0003Y\u0006\"\u00022\u0002\t\u0003\u0019\u0007\u0002\u00033\u0002\u0005\u0004%\taU3\t\rY\f\u0001\u0015!\u0003g\u0011\u001d9\u0018A1A\u0005\u0002\u0015Da\u0001_\u0001!\u0002\u00131\u0007bB=\u0002\u0005\u0004%IA\u001f\u0005\u0007}\u0006\u0001\u000b\u0011B>\t\u000f}\f!\u0019!C\u0005K\"9\u0011\u0011A\u0001!\u0002\u00131\u0007\u0002CA\u0002\u0003\t\u0007I\u0011\u0002>\t\u000f\u0005\u0015\u0011\u0001)A\u0005w\"A\u0011qA\u0001C\u0002\u0013%!\u0010C\u0004\u0002\n\u0005\u0001\u000b\u0011B>\t\u0013\u0005-\u0011A1A\u0005\u0002\u00055\u0001\u0002CA\u0010\u0003\u0001\u0006I!a\u0004\t\u0011\u0005\u0005\u0012A1A\u0005\n\u0015Dq!a\t\u0002A\u0003%a\rC\u0004\u0002&\u0005!\t!a\n\t\u000f\u0005\u001d\u0013\u0001\"\u0001\u0002J!9\u00111M\u0001\u0005\u0002\u0005\u0015\u0004bBA@\u0003\u0011%\u0011\u0011\u0011\u0005\b\u0003\u000f\u000bA\u0011BAE\u0011\u001d\ti)\u0001C\u0005\u0003\u001fCq!a%\u0002\t\u0013\t)\n\u0003\u0005\u0002\u001a\u0006!\taUAN\u0011!\tY,\u0001C\u0001'\u0006u\u0006\u0002CAc\u0003\u0011\u00051+a2\u0007\u000bi\u001b\u0006!!4\t\u0015\u0005mWD!b\u0001\n\u0013\ti\u000e\u0003\u0006\u0002fv\u0011\t\u0011)A\u0005\u0003?DaAY\u000f\u0005\u0002\u0005\u001d\bBCAw;\t\u0007I\u0011A*\u0002p\"A\u0011Q_\u000f!\u0002\u0013\t\t\u0010\u0003\u0006\u0002xv\u0011\r\u0011\"\u0001T\u0003_D\u0001\"!?\u001eA\u0003%\u0011\u0011\u001f\u0005\n\u0003wl\"\u0019!C\u0005\u0003{D\u0001B!\u0001\u001eA\u0003%\u0011q \u0005\n\u0005\u0007i\"\u0019!C\u0005\u0003{D\u0001B!\u0002\u001eA\u0003%\u0011q \u0005\n\u0005\u000fi\"\u0019!C\u0005\u0005\u0013A\u0001B!\u0007\u001eA\u0003%!1\u0002\u0005\n\u00057i\"\u0019!C\u0005\u0005;A\u0001Ba\n\u001eA\u0003%!q\u0004\u0005\n\u0005Si\"\u0019!C\u0005\u0005WA\u0001B!\u0010\u001eA\u0003%!Q\u0006\u0005\n\u0005\u007fi\u0002\u0019!C\u0005\u0003;D\u0011B!\u0011\u001e\u0001\u0004%IAa\u0011\t\u0011\t%S\u0004)Q\u0005\u0003?D\u0011Ba\u0013\u001e\u0005\u0004%IA!\u0014\t\u0011\tmS\u0004)A\u0005\u0005\u001fB\u0001B!\u0018\u001e\t\u0003\u0019&q\f\u0005\t\u0005cjB\u0011A*\u0003t!9!QO\u000f\u0005\u0002\t]\u0004b\u0002BB;\u0011\u0005!Q\u0011\u0005\b\u0005\u0017kB\u0011\u0001BG\u0011\u001d\u0011\t*\bC\u0001\u0005'CqAa&\u001e\t\u0013\u0011I\n\u0003\u0005\u0003 v!\taUAo\u0011!\u0011\t+\bC\u0001'\n\r\u0006\u0002\u0003BU;\u0011\u00051Ka)\t\u0011\t-V\u0004\"\u0001T\u0005[C\u0001B!0\u001e\t\u0003\u0019&q\u0018\u0005\t\u0005\u0007lB\u0011A*\u0003F\"9!1Z\u000f\u0005\n\t5\u0007b\u0002Bq;\u0011%!1\u001d\u0005\t\u0005KlB\u0011A*\u0003h\"A!q^\u000f\u0005\u0002M\u0013\t\u0010C\u0004\u0003xv!IA!?\t\u000f\r\u001dQ\u0004\"\u0003\u0004\n!A1\u0011C\u000f\u0005\u0002M\u001b\u0019\u0002C\u0004\u0004\u001au!Iaa\u0007\t\u0011\r\u0005R\u0004\"\u0001T\u0007GAqa!\u0013\u001e\t\u0013\u0019Y\u0005C\u0004\u0004xu!Ia!\u001f\t\u000f\r}T\u0004\"\u0003\u0003t!91\u0011Q\u000f\u0005\n\r\r\u0005bBBH;\u0011%1\u0011\u0013\u0005\b\u0007?kB\u0011BBQ\u0011\u001d\u0019y+\bC\u0005\u0007cCqaa6\u001e\t\u0013\u0019I.A\nEs:\fW.[2Ce>\\WM]\"p]\u001aLwM\u0003\u0002U+\u000611/\u001a:wKJT\u0011AV\u0001\u0006W\u000647.Y\u0002\u0001!\tI\u0016!D\u0001T\u0005M!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h'\t\tA\f\u0005\u0002^A6\taLC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tgL\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u000ba\u0003R=oC6L7mU3dkJLG/_\"p]\u001aLwm]\u000b\u0002MB\u0019q\r\u001c8\u000e\u0003!T!!\u001b6\u0002\u000f5,H/\u00192mK*\u00111NX\u0001\u000bG>dG.Z2uS>t\u0017BA7i\u0005\r\u0019V\r\u001e\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u0019\u0019FO]5oO\u00069B)\u001f8b[&\u001c7+Z2ve&$\u0018pQ8oM&<7\u000fI\u0001\u0012\u00032dG)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0018AE!mY\u0012Kh.Y7jG\u000e{gNZ5hg\u0002\n1d\u00117vgR,'\u000fT3wK2d\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u001cX#A>\u0011\u0007qlh.D\u0001k\u0013\ti'.\u0001\u000fDYV\u001cH/\u001a:MKZ,G\u000eT5ti\u0016tWM]\"p]\u001aLwm\u001d\u0011\u0002!A+'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0018!\u0005)fe\n\u0013xn[3s\u0007>tg-[4tA\u0005AB*[:uK:,'/T3dQ\u0006t\u0017n]7D_:4\u0017nZ:\u000231K7\u000f^3oKJlUm\u00195b]&\u001cXnQ8oM&<7\u000fI\u0001\u0016%\u0016dw.\u00193bE2,g)\u001b7f\u0007>tg-[4t\u0003Y\u0011V\r\\8bI\u0006\u0014G.\u001a$jY\u0016\u001cuN\u001c4jON\u0004\u0013a\u0005'jgR,g.\u001a:D_:4\u0017n\u001a*fO\u0016DXCAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u00033q\u0016\u0001B;uS2LA!!\b\u0002\u0014\t)!+Z4fq\u0006!B*[:uK:,'oQ8oM&<'+Z4fq\u0002\na\u0003R=oC6L7\rU1tg^|'\u000fZ\"p]\u001aLwm]\u0001\u0018\tft\u0017-\\5d!\u0006\u001c8o^8sI\u000e{gNZ5hg\u0002\n\u0001#[:QCN\u001cxo\u001c:e\u0007>tg-[4\u0015\t\u0005%\u0012q\u0006\t\u0004;\u0006-\u0012bAA\u0017=\n9!i\\8mK\u0006t\u0007bBA\u0019'\u0001\u0007\u00111G\u0001\u0005]\u0006lW\r\u0005\u0003\u00026\u0005\rc\u0002BA\u001c\u0003\u007f\u00012!!\u000f_\u001b\t\tYDC\u0002\u0002>]\u000ba\u0001\u0010:p_Rt\u0014bAA!=\u00061\u0001K]3eK\u001aL1!^A#\u0015\r\t\tEX\u0001\u0015EJ|7.\u001a:D_:4\u0017nZ*z]>t\u00170\\:\u0015\r\u0005-\u0013QLA0!\u0019\ti%a\u0016\u000249!\u0011qJA*\u001d\u0011\tI$!\u0015\n\u0003}K1!!\u0016_\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0017\u0002\\\t!A*[:u\u0015\r\t)F\u0018\u0005\b\u0003c!\u0002\u0019AA\u001a\u0011\u001d\t\t\u0007\u0006a\u0001\u0003S\tQ#\\1uG\"d\u0015n\u001d;f]\u0016\u0014xJ^3se&$W-A\bwC2LG-\u0019;f\u0007>tg-[4t)\u0019\t9'!\u001c\u0002|A\u0019Q,!\u001b\n\u0007\u0005-dL\u0001\u0003V]&$\bbBA8+\u0001\u0007\u0011\u0011O\u0001\u0006aJ|\u0007o\u001d\t\u0005\u0003g\n9(\u0004\u0002\u0002v)\u0019\u0011\u0011\u0004:\n\t\u0005e\u0014Q\u000f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA?+\u0001\u0007\u0011\u0011F\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jO\u0006\u0001\u0002/\u001a:Ce>\\WM]\"p]\u001aLwm\u001d\u000b\u0005\u0003\u0007\u000b)\t\u0005\u0003}{\u0006M\u0002bBA8-\u0001\u0007\u0011\u0011O\u0001\u0012]>tG)\u001f8b[&\u001c7i\u001c8gS\u001e\u001cH\u0003BAB\u0003\u0017Cq!a\u001c\u0018\u0001\u0004\t\t(\u0001\u0013tK\u000e,(/\u001b;z\u0007>tg-[4t/&$\bn\\;u\u0019&\u001cH/\u001a8feB\u0013XMZ5y)\u0011\t\u0019)!%\t\u000f\u0005=\u0004\u00041\u0001\u0002r\u0005\u0019b/\u00197jI\u0006$XmQ8oM&<G+\u001f9fgR!\u0011qMAL\u0011\u001d\ty'\u0007a\u0001\u0003c\n\u0011#\u00193e\tft\u0017-\\5d\u0007>tg-[4t)\u0011\t9'!(\t\u000f\u0005}%\u00041\u0001\u0002\"\u0006I1m\u001c8gS\u001e$UM\u001a\t\u0005\u0003G\u000b9,\u0004\u0002\u0002&*!\u0011qUAU\u0003\u0019\u0019wN\u001c4jO*!\u00111VAW\u0003\u0019\u0019w.\\7p]*\u0019a+a,\u000b\t\u0005E\u00161W\u0001\u0007CB\f7\r[3\u000b\u0005\u0005U\u0016aA8sO&!\u0011\u0011XAS\u0005%\u0019uN\u001c4jO\u0012+g-\u0001\res:\fW.[2D_:4\u0017nZ+qI\u0006$X-T8eKN,\"!a0\u0011\u0011\u0005M\u0014\u0011YA\u001a\u0003gIA!a1\u0002v\t\u0019Q*\u00199\u0002-I,7o\u001c7wKZ\u000b'/[1cY\u0016\u001cuN\u001c4jON$B!!\u001d\u0002J\"9\u00111\u001a\u000fA\u0002\u0005E\u0014!\u00049s_B\u001cxJ]5hS:\fGn\u0005\u0003\u001e9\u0006=\u0007\u0003BAi\u0003/l!!a5\u000b\u0007\u0005UW+A\u0003vi&d7/\u0003\u0003\u0002Z\u0006M'a\u0002'pO\u001eLgnZ\u0001\fW\u000647.Y\"p]\u001aLw-\u0006\u0002\u0002`B\u0019\u0011,!9\n\u0007\u0005\r8KA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001D6bM.\f7i\u001c8gS\u001e\u0004C\u0003BAu\u0003W\u0004\"!W\u000f\t\u000f\u0005m\u0007\u00051\u0001\u0002`\u0006\u00192\u000f^1uS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011\u0011\u0011\u001f\t\u0006O\u0006MhN\\\u0005\u0004\u0003\u0007D\u0017\u0001F:uCRL7M\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\b%\u0001\u000bti\u0006$\u0018n\u0019#fM\u0006,H\u000e^\"p]\u001aLwm]\u0001\u0016gR\fG/[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:!\u0003Q!\u0017P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011\u0011q \t\bO\u0006M\u00181GA\u001a\u0003U!\u0017P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hg\u0002\nQ\u0003Z=oC6L7\rR3gCVdGoQ8oM&<7/\u0001\fes:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:!\u0003=\u0011XmY8oM&<WO]1cY\u0016\u001cXC\u0001B\u0006!\u00159'Q\u0002B\t\u0013\r\u0011y\u0001\u001b\u0002\u0007\u0005V4g-\u001a:\u0011\t\tM!QC\u0007\u0003\u0003SKAAa\u0006\u0002*\nq!+Z2p]\u001aLw-\u001e:bE2,\u0017\u0001\u0005:fG>tg-[4ve\u0006\u0014G.Z:!\u0003U\u0011'o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKN,\"Aa\b\u0011\u000b\u001d\u0014iA!\t\u0011\u0007e\u0013\u0019#C\u0002\u0003&M\u0013AC\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0017A\u00062s_.,'OU3d_:4\u0017nZ;sC\ndWm\u001d\u0011\u0002\t1|7m[\u000b\u0003\u0005[\u0001BAa\f\u0003:5\u0011!\u0011\u0007\u0006\u0005\u0005g\u0011)$A\u0003m_\u000e\\7O\u0003\u0003\u00038\u0005U\u0014AC2p]\u000e,(O]3oi&!!1\bB\u0019\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017!\u00027pG.\u0004\u0013!D2veJ,g\u000e^\"p]\u001aLw-A\tdkJ\u0014XM\u001c;D_:4\u0017nZ0%KF$B!a\u001a\u0003F!I!q\t\u0019\u0002\u0002\u0003\u0007\u0011q\\\u0001\u0004q\u0012\n\u0014AD2veJ,g\u000e^\"p]\u001aLw\rI\u0001\u001dIft\u0017-\\5d\u0007>tg-[4QCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s+\t\u0011y\u0005E\u0003^\u0005#\u0012)&C\u0002\u0003Ty\u0013aa\u00149uS>t\u0007\u0003BAi\u0005/JAA!\u0017\u0002T\ny\u0001+Y:to>\u0014H-\u00128d_\u0012,'/A\u000fes:\fW.[2D_:4\u0017n\u001a)bgN<xN\u001d3F]\u000e|G-\u001a:!\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0005\u0003O\u0012\t\u0007C\u0004\u0003dQ\u0002\rA!\u001a\u0002\u0011i\\7\t\\5f]R\u0004BAa\u001a\u0003n5\u0011!\u0011\u000e\u0006\u0004\u0005W*\u0016A\u0001>l\u0013\u0011\u0011yG!\u001b\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003\u0015\u0019G.Z1s)\t\t9'\u0001\nbI\u0012\u0014VmY8oM&<WO]1cY\u0016\u001cH\u0003BA4\u0005sBqAa\u001f7\u0001\u0004\u0011i(A\u0006lC\u001a\\\u0017mU3sm\u0016\u0014\bcA-\u0003\u0000%\u0019!\u0011Q*\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u0012C\u0012$'+Z2p]\u001aLw-\u001e:bE2,G\u0003BA4\u0005\u000fCqA!#8\u0001\u0004\u0011\t\"\u0001\bsK\u000e|gNZ5hkJ\f'\r\\3\u0002/\u0005$GM\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,G\u0003BA4\u0005\u001fCqA!#9\u0001\u0004\u0011\t#\u0001\u000bsK6|g/\u001a*fG>tg-[4ve\u0006\u0014G.\u001a\u000b\u0005\u0003O\u0012)\nC\u0004\u0003\nf\u0002\rA!\u0005\u00027Y,'/\u001b4z%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t)\u0011\t9Ga'\t\u000f\tu%\b1\u0001\u0002\u0004\u0006Y1m\u001c8gS\u001et\u0015-\\3t\u0003I\u0019WO\u001d:f]R\\\u0015MZ6b\u0007>tg-[4\u00027\r,(O]3oi\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4t+\t\u0011)\u000bE\u0004}\u0005O\u000b\u0019$a\r\n\u0007\u0005\r'.\u0001\u000fdkJ\u0014XM\u001c;Es:\fW.[2EK\u001a\fW\u000f\u001c;D_:4\u0017nZ:\u0002%U\u0004H-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0007\u0003O\u0012yK!/\t\u000f\tEf\b1\u0001\u00034\u0006A!M]8lKJLE\rE\u0002^\u0005kK1Aa._\u0005\rIe\u000e\u001e\u0005\b\u0005ws\u0004\u0019AA9\u0003=\u0001XM]:jgR,g\u000e\u001e)s_B\u001c\u0018aE;qI\u0006$X\rR3gCVdGoQ8oM&<G\u0003BA4\u0005\u0003DqAa/@\u0001\u0004\t\t(A\u0013sK2|\u0017\rZ+qI\u0006$X\r\u001a$jY\u0016\u001cx+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0005.\u00198hKR!\u0011q\rBd\u0011\u001d\u0011I\r\u0011a\u0001\u0003c\n\u0001B\\3x!J|\u0007o]\u0001\u001b[\u0006L(-Z\"sK\u0006$X\rU1tg^|'\u000fZ#oG>$WM\u001d\u000b\u0005\u0005\u001f\u0012y\rC\u0004\u0003R\u0006\u0003\rAa5\u0002\rM,7M]3u!\u0015i&\u0011\u000bBk!\u0011\u00119N!8\u000e\u0005\te'\u0002\u0002Bn\u0003K\u000bQ\u0001^=qKNLAAa8\u0003Z\nA\u0001+Y:to>\u0014H-A\bqCN\u001cxo\u001c:e\u000b:\u001cw\u000eZ3s+\t\u0011)&A\tu_B+'o]5ti\u0016tG\u000f\u0015:paN$b!!\u001d\u0003j\n5\bb\u0002Bv\u0007\u0002\u0007\u0011\u0011O\u0001\fG>tg-[4Qe>\u00048\u000fC\u0004\u0002~\r\u0003\r!!\u000b\u0002'\u0019\u0014x.\u001c)feNL7\u000f^3oiB\u0013x\u000e]:\u0015\r\u0005E$1\u001fB{\u0011\u001d\u0011Y\f\u0012a\u0001\u0003cBq!! E\u0001\u0004\tI#\u0001\fnCf\u0014WMU3F]\u000e|G-\u001a)bgN<xN\u001d3t)\u0019\t\tHa?\u0003~\"9!1X#A\u0002\u0005E\u0004b\u0002B\u0000\u000b\u0002\u00071\u0011A\u0001\u000eC\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0011\t\t\u001d41A\u0005\u0005\u0007\u000b\u0011IGA\u0007BI6LgNW6DY&,g\u000e^\u0001\u0014m\u0006d\u0017\u000eZ1uK\u0012\\\u0015MZ6b!J|\u0007o\u001d\u000b\u0007\u0005K\u001bYaa\u0004\t\u000f\r5a\t1\u0001\u0002r\u0005i\u0001O]8qg>3XM\u001d:jI\u0016Dq!! G\u0001\u0004\tI#\u0001\u0005wC2LG-\u0019;f)\u0019\t9g!\u0006\u0004\u0018!9\u0011qN$A\u0002\u0005E\u0004bBA?\u000f\u0002\u0007\u0011\u0011F\u0001\u0015e\u0016lwN^3J]Z\fG.\u001b3D_:4\u0017nZ:\u0015\r\u0005\u001d4QDB\u0010\u0011\u001d\ty\u0007\u0013a\u0001\u0003cBq!! I\u0001\u0004\tI#\u0001\tnCf\u0014WMU3d_:4\u0017nZ;sKRA\u0011qMB\u0013\u0007O\u0019Y\u0003C\u0004\u0003\n&\u0003\rA!\u0005\t\u000f\r%\u0012\n1\u0001\u0002`\u0006Iq\u000e\u001c3D_:4\u0017n\u001a\u0005\b\u0007[I\u0005\u0019AB\u0018\u0003%qWm^\"p]\u001aLw\r\r\u0003\u00042\r]\u0002\u0003CA:\u0003\u0003\f\u0019da\r\u0011\t\rU2q\u0007\u0007\u0001\t1\u0019Ida\u000b\u0002\u0002\u0003\u0005)\u0011AB\u001e\u0005\ryF%M\t\u0005\u0007{\u0019\u0019\u0005E\u0002^\u0007\u007fI1a!\u0011_\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!XB#\u0013\r\u00199E\u0018\u0002\u0004\u0003:L\u0018AD;qI\u0006$X\rZ\"p]\u001aLwm\u001d\u000b\u0007\u0007\u001b\u001aif!\u001b\u0011\u000fu\u001byea\u0015\u0002\u0004&\u00191\u0011\u000b0\u0003\rQ+\b\u000f\\33a\u0011\u0019)f!\u0017\u0011\u000f\u001d\f\u00190a\r\u0004XA!1QGB-\t-\u0019YFSA\u0001\u0002\u0003\u0015\taa\u000f\u0003\u0007}#C\u0007C\u0004\u0003J*\u0003\raa\u00181\t\r\u00054Q\r\t\t\u0003g\n\t-a\r\u0004dA!1QGB3\t1\u00199g!\u0018\u0002\u0002\u0003\u0005)\u0011AB\u001e\u0005\ryFE\r\u0005\b\u0007WR\u0005\u0019AB7\u00031\u0019WO\u001d:f]R\u0004&o\u001c9ta\u0011\u0019yga\u001d\u0011\u0011\u0005M\u0014\u0011YA\u001a\u0007c\u0002Ba!\u000e\u0004t\u0011a1QOB5\u0003\u0003\u0005\tQ!\u0001\u0004<\t\u0019q\fJ\u001a\u0002\u001b=4XM\u001d:jI\u0016\u0004&o\u001c9t)\u0019\t9ga\u001f\u0004~!9\u0011qN&A\u0002\u0005}\bbBB\u0007\u0017\u0002\u0007\u0011q`\u0001\u0014kB$\u0017\r^3DkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\u0017aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R11QQBE\u0007\u0017\u0003r!XB(\u0003?\u001c9\t\u0005\u0004\u0002N\u0005]#\u0011\u0005\u0005\b\u0005\u0013l\u0005\u0019\u0001BS\u0011\u001d\u0019i)\u0014a\u0001\u0003S\tAB^1mS\u0012\fG/Z(oYf\f!D\u0019:pW\u0016\u0014h*Z3egJ+7m\u001c8gS\u001e,(/\u0019;j_:$\u0002\"!\u000b\u0004\u0014\u000e]51\u0014\u0005\b\u0007+s\u0005\u0019\u0001B\u0011\u0003Q\u0011'o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\"91\u0011\u0014(A\u0002\u0005\r\u0015aC;qI\u0006$X\rZ&fsNDqa!(O\u0001\u0004\t\u0019)A\u0006eK2,G/\u001a3LKf\u001c\u0018\u0001\u00068fK\u0012\u001c(+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0005\u0002*\r\r61VBW\u0011\u001d\u0019)k\u0014a\u0001\u0007O\u000bQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\u0005\u0004\u0002t\r%\u00161G\u0005\u0004[\u0006U\u0004bBBM\u001f\u0002\u0007\u00111\u0011\u0005\b\u0007;{\u0005\u0019AAB\u0003u\u0001(o\\2fgNd\u0015n\u001d;f]\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,G\u0003DA4\u0007g\u001b\u0019m!2\u0004R\u000eM\u0007bBB[!\u0002\u00071qW\u0001\u0017Y&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mKB!1\u0011XB`\u001b\t\u0019YL\u0003\u0003\u0004>\u0006%\u0016a\u00028fi^|'o[\u0005\u0005\u0007\u0003\u001cYL\u0001\fMSN$XM\\3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0011\u001d\u0019i\u0003\u0015a\u0001\u0003?Dqaa2Q\u0001\u0004\u0019I-A\u0007dkN$x.\\\"p]\u001aLwm\u001d\t\t\u0003g\n\t-a\r\u0004LB\u0019qn!4\n\u0007\r=\u0007O\u0001\u0004PE*,7\r\u001e\u0005\b\u0007\u001b\u0003\u0006\u0019AA\u0015\u0011\u001d\u0019)\u000e\u0015a\u0001\u0003S\t!B]3m_\u0006$wJ\u001c7z\u0003U\u0001(o\\2fgN\u0014VmY8oM&<WO]1cY\u0016$B\"a\u001a\u0004\\\u000eu7\u0011]Bx\u0007gDqA!#R\u0001\u0004\u0011\t\u0002C\u0004\u0004`F\u0003\r!a!\u0002%U\u0004H-\u0019;fI\u000e{gNZ5h\u001d\u0006lWm\u001d\u0005\b\u0007G\f\u0006\u0019ABs\u00035\tG\u000e\u001c(fo\u000e{gNZ5hgB\"1q]Bv!!\t\u0019(!1\u00024\r%\b\u0003BB\u001b\u0007W$Ab!<\u0004b\u0006\u0005\t\u0011!B\u0001\u0007w\u00111a\u0018\u00136\u0011\u001d\u0019\t0\u0015a\u0001\u0007\u0013\f\u0001C\\3x\u0007V\u001cHo\\7D_:4\u0017nZ:\t\u000f\r5\u0015\u000b1\u0001\u0002*\u0001")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final Buffer<Reconfigurable> reconfigurables;
    private final Buffer<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    private Buffer<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private Buffer<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(KafkaZkClient zkClient) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()));
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(this.kafkaConfig().brokerId()));
        Properties brokerConfig = this.maybeReEncodePasswords(props, adminZkClient);
        this.updateBrokerConfig(this.kafkaConfig().brokerId(), brokerConfig);
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable((Reconfigurable)new DelegatingReconfigurable(() -> kafkaServer.httpServer().orNull(Predef$.MODULE$.$conforms())));
        if (kafkaServer.auditLogProvider() != null) {
            this.addReconfigurable((Reconfigurable)kafkaServer.auditLogProvider());
        }
        this.addReconfigurable(kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer));
        this.addReconfigurable(new DynamicClientQuotaCallback(this.kafkaConfig().brokerId(), kafkaServer));
        if (kafkaServer instanceof KafkaServer) {
            ((KafkaServer)kafkaServer).adminManager().createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DynamicBrokerConfig.$anonfun$addReconfigurables$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.logManager());
        if (kafkaServer.logManager().cleaner() != null) {
            this.addBrokerReconfigurable(kafkaServer.logManager().cleaner());
        }
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
        this.addBrokerReconfigurable(new DynamicBackpressure(kafkaServer));
        this.addBrokerReconfigurable(new DynamicBalancerConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicClusterLinkConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicBrokerTagsConfig(kafkaServer));
        kafkaServer.tierDeletedPartitionsCoordinatorOpt().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
            this.addBrokerReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        kafkaServer.tierFetcherOpt().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
            this.addBrokerReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void addReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$removeReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyReconfigurableConfigs(Set<String> configNames) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$1(configNames);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public void updateBrokerConfig(int brokerId, Properties persistentProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateDefaultConfig(Properties persistentProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> new PasswordEncoder((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)configProps.clone();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        void var3_3;
        Properties props = (Properties)persistentProps.clone();
        if (((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) {
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Properties props, boolean perBrokerConfig) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Dynamic ").append(configSource).append(" config contains invalid values in: ").append(invalidProps.keys()).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(currentProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    /*
     * WARNING - void declaration
     */
    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            return props.put(k, v);
        };
        Map<String, String> map = Implicits$.MODULE$.MapExtensionMethods(propsOverride);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig() {
        void var5_5;
        void var4_4;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.BrokerSessionUuidProp()), (Object)this.kafkaConfig().brokerSessionUuid())}))));
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)((Object)tuple2._1());
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        void newConfig2 = var4_4;
        void brokerReconfigurablesToUpdate2 = var5_5;
        if (newConfig2 != this.currentConfig()) {
            this.currentConfig_$eq((KafkaConfig)newConfig2);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)newConfig2);
            brokerReconfigurablesToUpdate2.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)newConfig2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly) {
        void var6_6;
        void var5_5;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), !validateOnly, (Option<DynamicBrokerConfig>)None$.MODULE$);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        void changeMap2 = var5_5;
        void deletedKeySet2 = var6_6;
        if (changeMap2.nonEmpty() || deletedKeySet2.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(x$6 -> customConfigs.remove(x$6));
                this.reconfigurables().foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$2$adapted(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
    }

    private boolean brokerNeedsReconfiguration(BrokerReconfigurable brokerReconfigurable, Set<String> updatedKeys, Set<String> deletedKeys) {
        boolean bl = brokerReconfigurable instanceof DynamicBrokerTagsConfig ? updatedKeys.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(KafkaConfig$.MODULE$.BrokerTagsProp()))) || deletedKeys.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith(KafkaConfig$.MODULE$.BrokerTagsProp()))) : this.needsReconfiguration((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(brokerReconfigurable.reconfigurableConfigs()).asJava(), updatedKeys, deletedKeys);
        return bl;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty() || ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(deletedKeys)).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        void changeMap2 = var10_10;
        void deletedKeys2 = var11_11;
        Set updatedKeys = changeMap2.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)deletedKeys2);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" ").append("custom configs: ").append(ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString());
            reconfigurable.reconfigure(newConfigs);
        }
    }

    public static final /* synthetic */ void $anonfun$addReconfigurables$2(DynamicBrokerConfig $this, CreateTopicPolicy x0$1) {
        if (x0$1 instanceof Reconfigurable) {
            $this.addReconfigurable((Reconfigurable)x0$1);
            return;
        }
    }

    public static final /* synthetic */ Buffer $anonfun$addReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$1) {
        $this.verifyReconfigurableConfigs((Set<String>)((Set)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable$1.reconfigurableConfigs()).asScala()));
        return $this.reconfigurables().$plus$eq((Object)reconfigurable$1);
    }

    public static final /* synthetic */ Buffer $anonfun$addBrokerReconfigurable$1(DynamicBrokerConfig $this, BrokerReconfigurable reconfigurable$2) {
        $this.verifyReconfigurableConfigs(reconfigurable$2.reconfigurableConfigs());
        return $this.brokerReconfigurables().$plus$eq((Object)reconfigurable$2);
    }

    public static final /* synthetic */ Buffer $anonfun$removeReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$3) {
        return $this.reconfigurables().$minus$eq((Object)reconfigurable$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$verifyReconfigurableConfigs$1(Set configNames$1) {
        Set nonDynamic = (Set)configNames$1.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig();
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId$1).append(" could not be applied: ").append(persistentProps$1.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig();
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps$2.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(reconfigurable.reconfigurableConfigs(), arg_0));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            return;
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        ((IterableLike)$this.reconfigurables().filter((Function1 & Serializable & scala.Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4($this, newProps$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$3(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$5, String configName, String value2) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(configName) && value2 != null) {
            Some some;
            try {
                some = new Some((Object)passwordDecoder$1.decode(value2).value());
            }
            catch (Exception exception) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                some = None$.MODULE$;
            }
            some.foreach((Function1 & Serializable & scala.Serializable)value -> props$5.put(configName, $this.passwordEncoder().encode(new Password(value))));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$5, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(configName, value) -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$3($this, passwordDecoder, props$5, configName, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$6, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$6, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        boolean bl;
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String k = (String)x0$1._1();
        boolean bl = !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String k = (String)x0$2._1();
        boolean bl = !newProps$2.containsKey(k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.brokerNeedsReconfiguration(reconfigurable, (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                return brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerReconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = kafkaConfig;
        this.dynamicConfigPasswordEncoder = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$4) {
        x$4.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$2$adapted(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        DynamicBrokerConfig.$anonfun$processReconfiguration$2($this, newConfig$3, customConfigs$1, validateOnly$1, changeMap$1, deletedKeySet$1, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

