/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.server.ZkAdminManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\u000b\u0016\u0001iA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000bI\u0003A\u0011A*\t\u000fm\u0003!\u0019!C\u00059\"1\u0001\u000f\u0001Q\u0001\nuCQ!\u001d\u0001\u0005BIDQA\u001e\u0001\u0005BIDQa\u001e\u0001\u0005BaDq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\t)\n\u0001C\u0005\u0003/\u0013q\u0004R3gCVdG/Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s\u0015\t1r#\u0001\u0004tKJ4XM\u001d\u0006\u00021\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u001cC\u0015\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012$\u001b\u0005)\u0012B\u0001\u0013\u0016\u0005a\tU\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM\u001d\t\u0003M%j\u0011a\n\u0006\u0003Q]\tQ!\u001e;jYNL!AK\u0014\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"AI\u0017\n\u00059*\"aC&bM.\f7i\u001c8gS\u001e\fab\u00195b]:,G.T1oC\u001e,'\u000fE\u0002\u001dcMJ!AM\u000f\u0003\r=\u0003H/[8o!\t\u0011C'\u0003\u00026+\t\u0001#I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u00031\tG-\\5o\u001b\u0006t\u0017mZ3s!\ra\u0012\u0007\u000f\t\u0003EeJ!AO\u000b\u0003\u001di[\u0017\tZ7j]6\u000bg.Y4fe\u0006Q1m\u001c8ue>dG.\u001a:\u0011\u0007q\tT\b\u0005\u0002?\u00016\tqH\u0003\u0002</%\u0011\u0011i\u0010\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\u0006\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000bQa\u001a:pkBT!\u0001S\f\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0003\u0015\u0016\u0013\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB\u0011Q\nU\u0007\u0002\u001d*\u0011qjR\u0001\fiJ\fgn]1di&|g.\u0003\u0002R\u001d\n1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\u0004=S:LGO\u0010\u000b\b)V3v\u000bW-[!\t\u0011\u0003\u0001C\u0003,\u000f\u0001\u0007A\u0006C\u00030\u000f\u0001\u0007\u0001\u0007C\u00037\u000f\u0001\u0007q\u0007C\u0003<\u000f\u0001\u0007A\bC\u0003C\u000f\u0001\u00071\tC\u0003L\u000f\u0001\u0007A*\u0001\bj]\u001ad\u0017n\u001a5u)>\u0004\u0018nY:\u0016\u0003u\u00032AX2f\u001b\u0005y&B\u00011b\u0003\u0011)H/\u001b7\u000b\u0003\t\fAA[1wC&\u0011Am\u0018\u0002\u0004'\u0016$\bC\u00014n\u001d\t97\u000e\u0005\u0002i;5\t\u0011N\u0003\u0002k3\u00051AH]8pizJ!\u0001\\\u000f\u0002\rA\u0013X\rZ3g\u0013\tqwN\u0001\u0004TiJLgn\u001a\u0006\u0003Yv\tq\"\u001b8gY&<\u0007\u000e\u001e+pa&\u001c7\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0002gB\u0011A\u0004^\u0005\u0003kv\u0011A!\u00168ji\u0006A1\u000f[;uI><h.\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000fF\u0003z\u0003g\tY\u0004E\u0002{{~l\u0011a\u001f\u0006\u0003yv\t!bY8mY\u0016\u001cG/[8o\u0013\tq8PA\u0002TKF\u0004B!!\u0001\u0002.9!\u00111AA\u0014\u001d\u0011\t)!!\t\u000f\t\u0005\u001d\u00111\u0004\b\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005Eab\u00015\u0002\u000e%\u0011\u0011qB\u0001\u0004_J<\u0017\u0002BA\n\u0003+\ta!\u00199bG\",'BAA\b\u0013\rA\u0012\u0011\u0004\u0006\u0005\u0003'\t)\"\u0003\u0003\u0002\u001e\u0005}\u0011AB2p[6|gNC\u0002\u0019\u00033IA!a\t\u0002&\u00059Q.Z:tC\u001e,'\u0002BA\u000f\u0003?IA!!\u000b\u0002,\u0005!R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a#bi\u0006TA!a\t\u0002&%!\u0011qFA\u0019\u0005UiU\r^1eCR\f'+Z:q_:\u001cX\rV8qS\u000eTA!!\u000b\u0002,!9\u0011Q\u0007\u0007A\u0002\u0005]\u0012A\u0002;pa&\u001c7\u000f\u0005\u0003{\u0003s)\u0017B\u00013|\u0011\u001d\ti\u0004\u0004a\u0001\u0003\u007f\tqcY8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1\u0011\u0007\t\n\t%C\u0002\u0002DU\u0011qcQ8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]F+x\u000e^1\u0002!\r\u0014X-\u0019;f)>\u0004\u0018nY:J]j[G#B=\u0002J\u0005\u0005\u0004bBA&\u001b\u0001\u0007\u0011QJ\u0001\u0010GJ,\u0017\r^1cY\u0016$v\u000e]5dgB1!0a\u0014f\u0003'J1!!\u0015|\u0005\ri\u0015\r\u001d\t\u0005\u0003+\nYF\u0004\u0003\u0002\u0004\u0005]\u0013\u0002BA-\u0003W\tqc\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR$\u0015\r^1\n\t\u0005u\u0013q\f\u0002\u000f\u0007J,\u0017\r^1cY\u0016$v\u000e]5d\u0015\u0011\tI&a\u000b\t\u000f\u0005uR\u00021\u0001\u0002@\u000512/\u001a8e\u0007J,\u0017\r^3U_BL7MU3rk\u0016\u001cH\u000fF\u0002z\u0003OBq!a\u0013\u000f\u0001\u0004\ti%A\u000bdY\u0016\f'/\u00138gY&<\u0007\u000e\u001e*fcV,7\u000f^:\u0015\u0007M\fi\u0007C\u0004\u0002L=\u0001\r!!\u0014\u0002\u001d\r\u0014X-\u0019;bE2,Gk\u001c9jGR!\u00111KA:\u0011\u0019\t)\b\u0005a\u0001K\u0006)Ao\u001c9jG\u0006y2m\u001c8wKJ$Hk\u001c+pa&\u001c7i\u001c8gS\u001e\u001cu\u000e\u001c7fGRLwN\\:\u0015\t\u0005m\u0014\u0011\u0011\t\u0005\u0003+\ni(\u0003\u0003\u0002\u0000\u0005}#aH\"sK\u0006$X-\u00192mKR{\u0007/[2D_:4\u0017nZ\"pY2,7\r^5p]\"11&\u0005a\u0001\u0003\u0007\u00032AXAC\u0013\r\t9i\u0018\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E5t-\u0006d\u0017\u000e\u001a+pa&\u001cg*Y7f)\u0011\ti)a%\u0011\u0007q\ty)C\u0002\u0002\u0012v\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002vI\u0001\r!Z\u0001\u0016M&dG/\u001a:De\u0016\fG/\u00192mKR{\u0007/[2t)\u0011\tI*a(\u0011\rq\tY*!\u0014z\u0013\r\ti*\b\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005U2\u00031\u0001\u00028\u0001")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final Option<BrokerToControllerChannelManager> channelManager;
    private final Option<ZkAdminManager> adminManager;
    private final Option<KafkaController> controller;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    @Override
    public void start() {
        this.channelManager.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void shutdown() {
        this.channelManager.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.inflightTopics().clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota) {
        void var5_5;
        void var4_4;
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map creatableTopics = (Map)tuple2._1();
        Seq uncreatableTopicResponses = (Seq)tuple2._2();
        void creatableTopics2 = var4_4;
        void uncreatableTopicResponses2 = var5_5;
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = creatableTopics2.isEmpty() ? Nil$.MODULE$ : (this.controller.isEmpty() || !((KafkaController)this.controller.get()).isActive() && this.channelManager.isDefined() ? this.sendCreateTopicRequest((Map<String, CreateTopicsRequestData.CreatableTopic>)creatableTopics2) : this.createTopicsInZk((Map<String, CreateTopicsRequestData.CreatableTopic>)creatableTopics2, controllerMutationQuota));
        return (Seq)uncreatableTopicResponses2.$plus$plus(creatableTopicResponses, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> createTopicsInZk(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, ControllerMutationQuota controllerMutationQuota) {
        Seq seq;
        AtomicReference topicErrors = new AtomicReference();
        try {
            Seq seq2;
            ((ZkAdminManager)this.adminManager.get()).createTopics(0, false, creatableTopics, (Map<String, CreateTopicsResponseData.CreatableTopicResult>)scala.collection.Map$.MODULE$.empty(), controllerMutationQuota, (Function1<Map<String, ApiError>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                topicErrors.set(x$1);
                return BoxedUnit.UNIT;
            });
            Option option = Option$.MODULE$.apply(topicErrors.get());
            if (option instanceof Some) {
                seq2 = (Seq)((Map)((Some)option).value()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    String topic = (String)x0$1._1();
                    Errors errors = ((ApiError)x0$1._2()).error();
                    boolean bl = Errors.TOPIC_ALREADY_EXISTS.equals(errors) ? true : Errors.REQUEST_TIMED_OUT.equals(errors);
                    Errors errors2 = bl ? Errors.LEADER_NOT_AVAILABLE : (Errors.POLICY_VIOLATION.equals(errors) ? Errors.TOPIC_AUTHORIZATION_FAILED : errors);
                    MetadataResponseData.MetadataResponseTopic metadataResponseTopic = new MetadataResponseData.MetadataResponseTopic().setErrorCode(errors2.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic));
                    return metadataResponseTopic;
                }, Seq$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                seq2 = (Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)option);
            }
            seq = seq2;
        }
        finally {
            this.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(creatableTopics);
        }
        return seq;
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.asJavaCollectionConverter(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs())).setTopics(topicsToCreate));
        ((BrokerToControllerChannelManager)this.channelManager.get()).sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)createTopicsRequest, new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Auto topic creation timed out for ").append($this.creatableTopics$1.keys()).append(".").toString());
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
            }

            public void onComplete(ClientResponse response) {
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Auto topic creation completed for ").append($this.creatableTopics$1.keys()).append(".").toString());
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 )}, serializedLambda);
            }
        });
        Seq creatableTopicResponses = (Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)), Seq$.MODULE$.canBuildFrom());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Sent auto-creation request for ").append(creatableTopics.keys()).append(" to the active controller.").toString());
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Cleared inflight topic creation state for ").append(creatableTopics).toString());
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        CreateTopicsRequestData.CreatableTopic creatableTopic = "__consumer_offsets".equals(topic) ? new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.offsetsTopicPartitions())).setReplicationFactor(Predef$.MODULE$.Short2short(this.config.offsetsTopicReplicationFactor())).setConfigs(this.convertToTopicConfigCollections(this.groupCoordinator.offsetsTopicConfigs())) : ("__transaction_state".equals(topic) ? new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.transactionTopicPartitions())).setReplicationFactor(Predef$.MODULE$.Short2short(this.config.transactionTopicReplicationFactor())).setConfigs(this.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs())) : new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor()));
        return creatableTopic;
    }

    /*
     * WARNING - void declaration
     */
    private CreateTopicsRequestData.CreateableTopicConfigCollection convertToTopicConfigCollections(Properties config) {
        void var2_2;
        CreateTopicsRequestData.CreateableTopicConfigCollection topicConfigs = new CreateTopicsRequestData.CreateableTopicConfigCollection();
        config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> topicConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName(x0$1.toString()).setValue(x1$1.toString()))));
        return var2_2;
    }

    private boolean isValidTopicName(String topic) {
        try {
            Topic.validate((String)topic);
            return true;
        }
        catch (InvalidTopicException invalidTopicException) {
            return false;
        }
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            Option option;
            Some validationError;
            Object object = !this.isValidTopicName((String)topic) ? new Some((Object)Errors.INVALID_TOPIC_EXCEPTION) : (validationError = !this.inflightTopics().add((String)topic) ? new Some((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            if (validationError instanceof Some) {
                Errors error = (Errors)validationError.value();
                option = uncreatableTopics.$plus$eq((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            } else if (None$.MODULE$.equals(validationError)) {
                option = creatableTopics.put(topic, (Object)this.creatableTopic((String)topic));
            } else {
                throw new MatchError((Object)validationError);
            }
            return option;
        });
        return new Tuple2((Object)creatableTopics, (Object)uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, Option<BrokerToControllerChannelManager> channelManager, Option<ZkAdminManager> adminManager, Option<KafkaController> controller, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.adminManager = adminManager;
        this.controller = controller;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        Logging.$init$(this);
        if (controller.isEmpty() && channelManager.isEmpty()) {
            throw new IllegalArgumentException("Must supply a channel manager if not supplying a controller");
        }
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

